/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.demosystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.rndr.demosystem.Task;
import studio.rndr.demosystem.TaskContext;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\fJ\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\u0006\u0010%\u001a\u00020 J\u0006\u0010&\u001a\u00020 J6\u0010\u0014\u001a\u00020 2\u0006\u0010'\u001a\u00020\f2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020 0+J\u000e\u0010-\u001a\u00020 2\u0006\u0010\"\u001a\u00020\fR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lstudio/rndr/demosystem/Scheduler;", "", "()V", "activeTasks", "", "Lstudio/rndr/demosystem/Task;", "getActiveTasks", "()Ljava/util/Set;", "setActiveTasks", "(Ljava/util/Set;)V", "cursorStack", "Ljava/util/Stack;", "", "getCursorStack", "()Ljava/util/Stack;", "startCursor", "getStartCursor", "()D", "setStartCursor", "(D)V", "task", "getTask", "()Lstudio/rndr/demosystem/Task;", "setTask", "(Lstudio/rndr/demosystem/Task;)V", "taskStack", "getTaskStack", "tasks", "", "getTasks", "()Ljava/util/List;", "complete", "", "delay", "time", "popCursor", "popTask", "pushCursor", "pushTask", "duration", "repeat", "", "offset", "Lkotlin/Function1;", "Lstudio/rndr/demosystem/TaskContext;", "update", "demo-paddock"})
public final class Scheduler {
    @NotNull
    private final List<Task> tasks;
    @NotNull
    private Set<Task> activeTasks;
    private double startCursor;
    @Nullable
    private Task task;
    @NotNull
    private final Stack<Double> cursorStack;
    @NotNull
    private final Stack<Task> taskStack;

    @NotNull
    public final List<Task> getTasks() {
        return this.tasks;
    }

    @NotNull
    public final Set<Task> getActiveTasks() {
        return this.activeTasks;
    }

    public final void setActiveTasks(@NotNull Set<Task> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.activeTasks = set;
    }

    public final double getStartCursor() {
        return this.startCursor;
    }

    public final void setStartCursor(double d) {
        this.startCursor = d;
    }

    @Nullable
    public final Task getTask() {
        return this.task;
    }

    public final void setTask(@Nullable Task task) {
        this.task = task;
    }

    @NotNull
    public final Stack<Double> getCursorStack() {
        return this.cursorStack;
    }

    @NotNull
    public final Stack<Task> getTaskStack() {
        return this.taskStack;
    }

    public final void pushCursor() {
        this.cursorStack.push(this.startCursor);
    }

    public final void popCursor() {
        Double d = this.cursorStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(d, "cursorStack.pop()");
        this.startCursor = ((Number)d).doubleValue();
    }

    public final void pushTask() {
        this.taskStack.push(this.task);
    }

    public final void popTask() {
        this.task = this.taskStack.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void task(double duration, int repeat, double offset, @NotNull Function1<? super TaskContext, Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, "task");
        this.pushCursor();
        int n = 0;
        int n2 = repeat;
        while (n < n2) {
            void i;
            this.tasks.add(new Task(this.startCursor + offset, offset + this.startCursor + duration, task));
            this.task = CollectionsKt.last(this.tasks);
            if (repeat > 1) {
                this.complete();
            }
            ++i;
        }
        this.popCursor();
    }

    public static /* bridge */ /* synthetic */ void task$default(Scheduler scheduler, double d, int n, double d2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            d2 = 0.0;
        }
        scheduler.task(d, n, d2, function1);
    }

    public final void complete() {
        Task task = this.task;
        if (task == null) {
            Intrinsics.throwNpe();
        }
        this.startCursor = task.getEnd();
    }

    public final void update(double time) {
        Task it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.tasks;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Task)element$iv$iv;
            if (!(it.getStart() <= time && time < it.getEnd())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List timeStepTasks = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)timeStepTasks;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Task)element$iv$iv;
            if (!(it.getStart() <= time && time < it.getEnd())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Task it2 = (Task)element$iv;
            it2.getTask().invoke(new TaskContext(time - it2.getStart(), time, it2.getEnd() - it2.getStart(), !this.activeTasks.contains(it2)));
        }
        this.activeTasks = CollectionsKt.toSet(timeStepTasks);
    }

    public final void delay(double time) {
        this.startCursor += time;
    }

    public Scheduler() {
        Collection<Object> collection;
        Scheduler scheduler = this;
        scheduler.tasks = collection = (List)new ArrayList();
        scheduler = this;
        collection = SetsKt.emptySet();
        scheduler.activeTasks = collection;
        this.cursorStack = new Stack();
        this.taskStack = new Stack();
    }
}

