/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.camera;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Quaternion;
import org.openrndr.math.QuaternionKt;
import org.openrndr.math.Vector3;
import studio.rndr.camera.CameraKey;
import studio.rndr.camera.CameraKeyframer$WhenMappings;
import studio.rndr.camera.CameraKeyframerKt;
import studio.rndr.camera.TweenMode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lstudio/rndr/camera/CameraKeyframer;", "", "()V", "keys", "", "Lstudio/rndr/camera/CameraKey;", "getKeys", "()Ljava/util/List;", "frame", "time", "", "demo-paddock"})
public final class CameraKeyframer {
    @NotNull
    private final List<CameraKey> keys;

    @NotNull
    public final List<CameraKey> getKeys() {
        return this.keys;
    }

    @NotNull
    public final CameraKey frame(double time) {
        int n;
        block31: {
            if (this.keys.size() == 0) {
                return new CameraKey(Vector3.Companion.getZERO(), Quaternion.Companion.getIDENTITY(), 90.0, 1.0, 100.0, 10.0, 1.0, 0.0, 0.0, -1.0, TweenMode.LINEAR);
            }
            if (this.keys.size() == 1) {
                return this.keys.get(0);
            }
            if (time <= this.keys.get(0).getTime()) {
                n = 1;
            } else {
                List<CameraKey> $receiver$iv = this.keys;
                int index$iv = 0;
                for (CameraKey item$iv : $receiver$iv) {
                    CameraKey it = item$iv;
                    if (it.getTime() > time) {
                        n = index$iv;
                        break block31;
                    }
                    ++index$iv;
                }
                n = -1;
            }
        }
        int rightIndex = n;
        int leftIndex = rightIndex - 1;
        if (leftIndex >= 0 && rightIndex >= 0) {
            double d;
            CameraKey left = this.keys.get(leftIndex);
            CameraKey right = this.keys.get(rightIndex);
            double dt = right.getTime() - left.getTime();
            double d0 = Math.max(0.0, time - left.getTime());
            double px = d0 / dt;
            switch (CameraKeyframer$WhenMappings.$EnumSwitchMapping$0[right.getTweenMode().ordinal()]) {
                case 1: {
                    d = px;
                    break;
                }
                case 2: {
                    d = 1.0;
                    break;
                }
                case 3: {
                    d = 0.0;
                    break;
                }
                case 4: {
                    d = (double)((int)(px * 2.0)) / 2.0;
                    break;
                }
                case 5: {
                    d = (double)((int)(px * 4.0)) / 4.0;
                    break;
                }
                case 6: {
                    d = (double)((int)(px * 8.0)) / 8.0;
                    break;
                }
                case 7: {
                    d = (double)((int)(px * 16.0)) / 16.0;
                    break;
                }
                case 8: {
                    d = (double)((int)(px * 32.0)) / 32.0;
                    break;
                }
                case 9: {
                    d = MappingKt.smoothstep(0.0, 1.0, px);
                    break;
                }
                case 10: {
                    if (px < 0.5) {
                        d = MappingKt.smoothstep(0.0, 1.0, px);
                        break;
                    }
                    d = px;
                    break;
                }
                case 11: {
                    if (px > 0.5) {
                        d = MappingKt.smoothstep(0.0, 1.0, px);
                        break;
                    }
                    d = px;
                    break;
                }
                case 12: {
                    d = MappingKt.smoothstep(0.5, 1.0, px * 8.0 % 1.0) * 1.0 / 8.0 + (double)((int)(px * 8.0)) / 8.0;
                    break;
                }
                case 13: {
                    d = MappingKt.smoothstep(0.5, 1.0, px * 16.0 % 1.0) * 1.0 / 16.0 + (double)((int)(px * 16.0)) / 16.0;
                    break;
                }
                case 14: {
                    d = MappingKt.smoothstep(0.5, 1.0, px * 32.0 % 1.0) * 1.0 / 32.0 + (double)((int)(px * 32.0)) / 32.0;
                    break;
                }
                case 15: {
                    d = CameraKeyframerKt.expoIn(px);
                    break;
                }
                case 16: {
                    d = CameraKeyframerKt.expoOut(px);
                    break;
                }
                case 17: {
                    d = CameraKeyframerKt.expoIn(CameraKeyframerKt.expoIn(px * 4.0 % 1.0) * 1.0 / 4.0 + (double)((int)(px * 4.0)) / 4.0);
                    break;
                }
                case 18: {
                    d = CameraKeyframerKt.expoIn(CameraKeyframerKt.expoIn(px * 8.0 % 1.0) * 1.0 / 8.0 + (double)((int)(px * 8.0)) / 8.0);
                    break;
                }
                case 19: {
                    d = CameraKeyframerKt.expoIn(CameraKeyframerKt.expoIn(px * 16.0 % 1.0) * 1.0 / 16.0 + (double)((int)(px * 16.0)) / 16.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double x = d;
            return new CameraKey(left.getPosition().plus(right.getPosition().minus(left.getPosition()).times(x)), QuaternionKt.slerp(left.getOrientation(), right.getOrientation(), x), left.getFov() + (right.getFov() - left.getFov()) * x, left.getAperture() + (right.getAperture() - left.getAperture()) * x, left.getFocalPlane() + (right.getFocalPlane() - left.getFocalPlane()) * x, left.getFocalLength() + (right.getFocalLength() - left.getFocalLength()) * x, left.getExposure() + (right.getExposure() - left.getExposure()) * x, left.getCenterX() + (right.getCenterX() - left.getCenterX()) * x, left.getCenterY() + (right.getCenterY() - left.getCenterY()) * x, time, right.getTweenMode());
        }
        if (rightIndex < 0) {
            return this.keys.get(this.keys.size() - 1);
        }
        return new CameraKey(Vector3.Companion.getZERO(), Quaternion.Companion.getIDENTITY(), 90.0, 1.0, 100.0, 10.0, 1.0, 0.0, 0.0, -1.0, TweenMode.LINEAR);
    }

    public CameraKeyframer() {
        List list;
        CameraKeyframer cameraKeyframer = this;
        cameraKeyframer.keys = list = (List)new ArrayList();
    }
}

