/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.FontImageMapDrawer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.text.Cursor;
import org.openrndr.text.RenderToken;
import org.openrndr.text.WriteStyle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\"H\u0002J\u0006\u0010$\u001a\u00020\u001fJ \u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0006\u0010/\u001a\u00020\u001fJ\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(J\u000e\u00100\u001a\u00020-2\u0006\u0010'\u001a\u00020(R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00061"}, d2={"Lorg/openrndr/text/Writer;", "", "drawer", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "value", "Lorg/openrndr/shape/Rectangle;", "box", "getBox", "()Lorg/openrndr/shape/Rectangle;", "setBox", "(Lorg/openrndr/shape/Rectangle;)V", "cursor", "Lorg/openrndr/text/Cursor;", "getCursor", "()Lorg/openrndr/text/Cursor;", "setCursor", "(Lorg/openrndr/text/Cursor;)V", "getDrawer", "()Lorg/openrndr/draw/Drawer;", "style", "Lorg/openrndr/text/WriteStyle;", "getStyle", "()Lorg/openrndr/text/WriteStyle;", "setStyle", "(Lorg/openrndr/text/WriteStyle;)V", "styleStack", "Ljava/util/Stack;", "getStyleStack", "()Ljava/util/Stack;", "emitToken", "", "renderTokens", "", "Lorg/openrndr/text/RenderToken;", "renderToken", "gaplessNewLine", "makeRenderTokens", "", "text", "", "mustFit", "", "move", "x", "", "y", "newLine", "textWidth", "openrndr-core"})
public final class Writer {
    @NotNull
    private Cursor cursor;
    @NotNull
    private Rectangle box;
    @NotNull
    private WriteStyle style;
    @NotNull
    private final Stack<WriteStyle> styleStack;
    @NotNull
    private final Drawer drawer;

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Cursor cursor) {
        Intrinsics.checkParameterIsNotNull(cursor, "<set-?>");
        this.cursor = cursor;
    }

    @NotNull
    public final Rectangle getBox() {
        return this.box;
    }

    public final void setBox(@NotNull Rectangle value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.box = value;
        this.cursor.setX(value.getCorner().getX());
        this.cursor.setY(value.getCorner().getY());
    }

    @NotNull
    public final WriteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull WriteStyle writeStyle) {
        Intrinsics.checkParameterIsNotNull(writeStyle, "<set-?>");
        this.style = writeStyle;
    }

    @NotNull
    public final Stack<WriteStyle> getStyleStack() {
        return this.styleStack;
    }

    public final void newLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.drawer.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + ((fontMap != null ? fontMap.getLeading() : 0.0) + this.style.getLeading()));
    }

    public final void gaplessNewLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.drawer.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + (fontMap != null ? fontMap.getHeight() : 0.0));
    }

    public final void move(double x, double y) {
        Cursor cursor = this.cursor;
        cursor.setX(cursor.getX() + x);
        Cursor cursor2 = this.cursor;
        cursor2.setY(cursor2.getY() + y);
    }

    /*
     * WARNING - void declaration
     */
    public final double textWidth(@NotNull String text2) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(text2, "text");
        CharSequence $receiver$iv = text2;
        double sum$iv = 0.0;
        CharSequence charSequence = $receiver$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void it;
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            double d = sum$iv;
            FontMap fontMap = this.drawer.getDrawStyle().getFontMap();
            if (fontMap == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            FontImageMap fontImageMap = (FontImageMap)fontMap;
            GlyphMetrics glyphMetrics = (fontImageMap != null ? fontImageMap.getGlyphMetrics() : null).get(Character.valueOf((char)it));
            double d2 = glyphMetrics != null ? glyphMetrics.getAdvanceWidth() : 0.0;
            sum$iv = d + d2;
        }
        return (double)var3_3;
    }

    public final void text(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        FontImageMapDrawer renderer = this.drawer.getFontImageMapDrawer$openrndr_core();
        List<RenderToken> renderTokens = this.makeRenderTokens(text2, false);
        Iterable $receiver$iv = renderTokens;
        for (Object element$iv : $receiver$iv) {
            RenderToken it = (RenderToken)element$iv;
            FontMap fontMap = this.drawer.getDrawStyle().getFontMap();
            if (fontMap == null) {
                Intrinsics.throwNpe();
            }
            renderer.queueText(fontMap, it.getToken(), it.getX(), it.getY(), this.style.getTracking());
        }
        renderer.flush(this.drawer.getContext(), this.drawer.getDrawStyle());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RenderToken> makeRenderTokens(String text2, boolean mustFit) {
        FontMap fontMap = this.drawer.getDrawStyle().getFontMap();
        if (fontMap != null) {
            List list;
            Collection $receiver$iv;
            FontMap fontMap2;
            FontMap font = fontMap2 = fontMap;
            boolean fits = true;
            FontMap fontMap3 = font;
            if (fontMap3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            FontImageMap cfr_ignored_0 = (FontImageMap)fontMap3;
            Object object = text2;
            Object object2 = "((?<=\n)|(?=\n))";
            object2 = new Regex((String)object2);
            int n = 0;
            object = ((Regex)object2).split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take($receiver$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] lines = stringArray;
            List tokens = new ArrayList();
            for (Object element$iv : (Object[])lines) {
                String line = (String)element$iv;
                List lineTokens = StringsKt.split$default((CharSequence)line, new String[]{" "}, false, 0, 6, null);
                tokens.addAll(lineTokens);
            }
            Cursor localCursor = new Cursor(this.cursor);
            GlyphMetrics glyphMetrics = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf(' '));
            if (glyphMetrics == null) {
                Intrinsics.throwNpe();
            }
            double spaceWidth = glyphMetrics.getAdvanceWidth();
            double verticalSpace = font.getHeight() + this.style.getLeading() + font.getLeading();
            List renderTokens = new ArrayList();
            int $i$a$1$forEach = 0;
            int n2 = tokens.size();
            while ($i$a$1$forEach < n2) {
                void i;
                String token = (String)tokens.get((int)i);
                if (Intrinsics.areEqual(token, "\n")) {
                    localCursor.setX(this.box.getCorner().getX());
                    Cursor cursor = localCursor;
                    cursor.setY(cursor.getY() + verticalSpace);
                } else {
                    CharSequence $receiver$iv2 = token;
                    double sum$iv = 0.0;
                    CharSequence charSequence = $receiver$iv2;
                    for (int j = 0; j < charSequence.length(); ++j) {
                        void it;
                        char element$iv;
                        char c = element$iv = charSequence.charAt(j);
                        double d = sum$iv;
                        GlyphMetrics glyphMetrics2 = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf((char)it));
                        double d2 = glyphMetrics2 != null ? glyphMetrics2.getAdvanceWidth() : 0.0;
                        sum$iv = d + d2;
                    }
                    double tokenWidth = sum$iv + this.style.getTracking() * (double)token.length();
                    if (localCursor.getX() + tokenWidth < this.box.getX() + this.box.getWidth() && localCursor.getY() <= this.box.getY() + this.box.getHeight()) {
                        Writer writer;
                        Writer $receiver = writer = this;
                        RenderToken renderToken = new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, $receiver.style.getTracking());
                        $receiver.emitToken(localCursor, renderTokens, renderToken);
                    } else {
                        if (localCursor.getY() > this.box.getCorner().getY() + this.box.getHeight()) {
                            fits = false;
                        }
                        if (localCursor.getY() + verticalSpace <= this.box.getY() + this.box.getHeight()) {
                            Cursor cursor = localCursor;
                            cursor.setY(cursor.getY() + verticalSpace);
                            localCursor.setX(this.box.getX());
                            this.emitToken(localCursor, renderTokens, new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                        } else {
                            if (!mustFit && this.style.getEllipsis() != null && this.cursor.getY() <= this.box.getY() + this.box.getHeight()) {
                                this.emitToken(localCursor, renderTokens, new RenderToken(this.style.getEllipsis(), localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                                break;
                            }
                            fits = false;
                        }
                    }
                    Cursor cursor = localCursor;
                    cursor.setX(cursor.getX() + tokenWidth);
                    if (i != tokens.size() - 1) {
                        Cursor cursor2 = localCursor;
                        cursor2.setX(cursor2.getX() + spaceWidth);
                    }
                }
                ++i;
            }
            if (fits || !fits && !mustFit) {
                this.cursor = new Cursor(localCursor);
            } else {
                renderTokens.clear();
            }
            return renderTokens;
        }
        return CollectionsKt.emptyList();
    }

    static /* bridge */ /* synthetic */ List makeRenderTokens$default(Writer writer, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return writer.makeRenderTokens(string, bl);
    }

    private final void emitToken(Cursor cursor, List<RenderToken> renderTokens, RenderToken renderToken) {
        renderTokens.add(renderToken);
    }

    @NotNull
    public final Drawer getDrawer() {
        return this.drawer;
    }

    public Writer(@NotNull Drawer drawer) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        this.drawer = drawer;
        this.cursor = new Cursor(0.0, 0.0, 3, null);
        this.box = new Rectangle(Vector2.Companion.getZERO(), this.drawer.getWidth(), this.drawer.getHeight());
        this.style = new WriteStyle();
        this.styleStack = new Stack();
    }
}

