/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Segment;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aJ#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0018J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u001aJ \u0010'\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u001aJ\u0016\u0010+\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u001e\u0010+\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0004J\u000e\u00100\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lorg/openrndr/shape/ContourBuilder;", "", "()V", "anchor", "Lorg/openrndr/math/Vector2;", "getAnchor", "()Lorg/openrndr/math/Vector2;", "setAnchor", "(Lorg/openrndr/math/Vector2;)V", "closed", "", "getClosed$openrndr_shape", "()Z", "setClosed$openrndr_shape", "(Z)V", "cursor", "getCursor", "setCursor", "segments", "", "Lorg/openrndr/shape/Segment;", "getSegments", "()Ljava/util/List;", "arcTo", "", "rx", "", "ry", "angle", "largeArcFlag", "sweepFlag", "tx", "ty", "arcToBeziers", "", "angleStart", "angleExtent", "(DD)[Lorg/openrndr/math/Vector2;", "close", "continueTo", "end", "tangentScale", "control", "curveTo", "position", "control0", "control1", "lineTo", "moveTo", "openrndr-shape"})
public final class ContourBuilder {
    @NotNull
    private Vector2 cursor = new Vector2(0.0, 0.0);
    @NotNull
    private Vector2 anchor = new Vector2(0.0, 0.0);
    private boolean closed;
    @NotNull
    private final List<Segment> segments;

    @NotNull
    public final Vector2 getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Vector2 vector2) {
        Intrinsics.checkParameterIsNotNull(vector2, "<set-?>");
        this.cursor = vector2;
    }

    @NotNull
    public final Vector2 getAnchor() {
        return this.anchor;
    }

    public final void setAnchor(@NotNull Vector2 vector2) {
        Intrinsics.checkParameterIsNotNull(vector2, "<set-?>");
        this.anchor = vector2;
    }

    public final boolean getClosed$openrndr_shape() {
        return this.closed;
    }

    public final void setClosed$openrndr_shape(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final void moveTo(@NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        this.cursor = position;
        this.anchor = position;
    }

    public final void lineTo(@NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Segment segment = new Segment(this.cursor, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void curveTo(@NotNull Vector2 control, @NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(control, "control");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Segment segment = new Segment(this.cursor, control, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void curveTo(@NotNull Vector2 control0, @NotNull Vector2 control1, @NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(control0, "control0");
        Intrinsics.checkParameterIsNotNull(control1, "control1");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Segment segment = new Segment(this.cursor, control0, control1, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void close() {
        this.closed = true;
    }

    public final void arcTo(double rx, double ry, double angle, boolean largeArcFlag, boolean sweepFlag, double tx, double ty) {
        int i;
        double angleExtent;
        double y1;
        double sinAngle;
        if (rx == 0.0 || ry == 0.0) {
            this.lineTo(new Vector2(tx, ty));
        }
        double rx2 = Math.abs(rx);
        double ry2 = Math.abs(ry);
        double angleRad = Math.toRadians(angle % 360.0);
        double dx2 = (this.cursor.getX() - tx) / 2.0;
        double dy2 = (this.cursor.getY() - ty) / 2.0;
        double cosAngle = Math.cos(angleRad);
        double x1 = cosAngle * dx2 + (sinAngle = Math.sin(angleRad)) * dy2;
        double radiiCheck = x1 * x1 / (rx2 * rx2) + (y1 = -sinAngle * dx2 + cosAngle * dy2) * y1 / (ry2 * ry2);
        if (radiiCheck > 1.0) {
            rx2 = Math.sqrt(radiiCheck) * rx2;
            ry2 = Math.sqrt(radiiCheck) * ry2;
        }
        double rx_sq = rx2 * rx2;
        double ry_sq = ry2 * ry2;
        double y1_sq = y1 * y1;
        double x1_sq = x1 * x1;
        double sign = largeArcFlag == sweepFlag ? -1 : 1;
        double sq = (rx_sq * ry_sq - rx_sq * y1_sq - ry_sq * x1_sq) / (rx_sq * y1_sq + ry_sq * x1_sq);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rx2 * y1 / ry2);
        double cy1 = coef * -(ry2 * x1 / rx2);
        double sx2 = (this.cursor.getX() + tx) / 2.0;
        double sy2 = (this.cursor.getY() + ty) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx2;
        double uy = (y1 - cy1) / ry2;
        double vx = (-x1 - cx1) / rx2;
        double vy = (-y1 - cy1) / ry2;
        double n = Math.sqrt(ux * ux + uy * uy);
        if (n == 0.0) {
            n = 1.0E-6;
        }
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        double ratio = n > 0.0 ? p / n : 0.0;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double d = angleExtent = ratio >= 0.0 ? Math.toDegrees(sign * Math.acos(p / n)) : 180.0;
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        Vector2[] coords = this.arcToBeziers(angleStart %= 360.0, angleExtent %= 360.0);
        int n2 = 0;
        int n3 = coords.length;
        while (n2 < n3) {
            double x = coords[i].getX();
            double y = coords[i].getY();
            coords[i] = new Vector2(cosAngle * rx2 * x + -sinAngle * ry2 * y + cx, sinAngle * rx2 * x + cosAngle * ry2 * y + cy);
            ++i;
        }
        if (((Object[])coords).length > 0) {
            coords[((Object[])coords).length - 1] = new Vector2(tx, ty);
            for (i = 0; i < ((Object[])coords).length; i += 3) {
                this.curveTo(coords[i], coords[i + 1], coords[i + 2]);
            }
        }
        this.cursor = new Vector2(tx, ty);
    }

    public final void continueTo(@NotNull Vector2 end2, double tangentScale) {
        Intrinsics.checkParameterIsNotNull(end2, "end");
        Segment last = CollectionsKt.last(this.segments);
        Vector2 delta = ((Vector2)ArraysKt.last((Object[])last.getControl())).minus(last.getEnd());
        this.curveTo(last.getEnd().minus(delta.times(tangentScale)), end2);
    }

    public static /* bridge */ /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, d);
    }

    public final void continueTo(@NotNull Vector2 control, @NotNull Vector2 end2, double tangentScale) {
        Intrinsics.checkParameterIsNotNull(control, "control");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        Segment last = CollectionsKt.last(this.segments);
        Vector2 delta = ((Vector2)ArraysKt.last((Object[])last.getControl())).minus(last.getEnd());
        this.curveTo(last.getEnd().minus(delta.times(tangentScale)), control, end2);
    }

    public static /* bridge */ /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, Vector2 vector22, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, vector22, d);
    }

    /*
     * WARNING - void declaration
     */
    private final Vector2[] arcToBeziers(double angleStart, double angleExtent) {
        double angleStart2 = angleStart;
        double angleExtent2 = angleExtent;
        int numSegments = (int)Math.ceil(Math.abs(angleExtent2) / 90.0);
        angleStart2 = Math.toRadians(angleStart2);
        angleExtent2 = Math.toRadians(angleExtent2);
        float angleIncrement = (float)(angleExtent2 / (double)numSegments);
        double controlLength = 1.3333333333333333 * Math.sin((double)angleIncrement / 2.0) / (1.0 + Math.cos((double)angleIncrement / 2.0));
        int size$iv = numSegments * 3;
        Vector2[] result$iv22 = new Vector2[size$iv];
        int n = 0;
        int n2 = result$iv22.length;
        while (n < n2) {
            Vector2 vector2;
            void i$iv;
            void var18_14 = i$iv;
            void var24_16 = i$iv++;
            Vector2[] vector2Array = result$iv22;
            vector2Array[var24_16] = vector2 = Vector2.Companion.getZERO();
        }
        Vector2[] coords = result$iv22;
        int pos = 0;
        int result$iv22 = 0;
        n = numSegments;
        while (result$iv22 < n) {
            void i;
            double angle = angleStart2 + (double)((float)i * angleIncrement);
            double dx = Math.cos(angle);
            double dy = Math.sin(angle);
            coords[pos] = new Vector2(dx - controlLength * dy, dy + controlLength * dx);
            dx = Math.cos(angle += (double)angleIncrement);
            dy = Math.sin(angle);
            coords[++pos] = new Vector2(dx + controlLength * dy, dy - controlLength * dx);
            coords[++pos] = new Vector2(dx, dy);
            ++pos;
            ++i;
        }
        return coords;
    }

    public ContourBuilder() {
        List list;
        ContourBuilder contourBuilder = this;
        contourBuilder.segments = list = (List)new ArrayList();
    }
}

