/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/math/Quaternion;", "", "x", "", "y", "z", "w", "(DDDD)V", "inversed", "getInversed", "()Lorg/openrndr/math/Quaternion;", "length", "getLength", "()D", "matrix", "Lorg/openrndr/math/Matrix44;", "getMatrix", "()Lorg/openrndr/math/Matrix44;", "negated", "getNegated", "norm", "getNorm", "normalized", "getNormalized", "getW", "getX", "getY", "getZ", "times", "q", "Companion", "openrndr-math"})
public final class Quaternion {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Quaternion IDENTITY;
    @NotNull
    private static final Quaternion ZERO;
    public static final Companion Companion;

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return new Quaternion(this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x, -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y, this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z, -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w);
    }

    @NotNull
    public final Quaternion getNegated() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Quaternion getInversed() {
        double n = this.getNorm();
        if (n > 0.0) {
            double invNorm = 1.0 / n;
            return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
        }
        throw (Throwable)new RuntimeException("norm <= 0 => quaternion is not invertible");
    }

    @NotNull
    public final Quaternion getNormalized() {
        double l = this.getLength();
        return new Quaternion(this.x / l, this.y / l, this.z / l, this.w / l);
    }

    public final double getNorm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @NotNull
    public final Matrix44 getMatrix() {
        double norm = this.getNorm();
        double s = norm == 1.0 ? 2.0 : (norm > (double)0.0f ? (double)2.0f / norm : 0.0);
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        return new Matrix44(1.0 - (yy + zz), xy - zw, xz + yw, 0.0, xy + zw, 1.0 - (xx + zz), yz - xw, 0.0, xz - yw, yz + xw, 1.0 - (xx + yy), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    static {
        Companion = new Companion(null);
        IDENTITY = new Quaternion(0.0, 0.0, 0.0, 1.0);
        ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/openrndr/math/Quaternion$Companion;", "", "()V", "IDENTITY", "Lorg/openrndr/math/Quaternion;", "getIDENTITY", "()Lorg/openrndr/math/Quaternion;", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Quaternion getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Quaternion getZERO() {
            return ZERO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

