/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBufferShadow;
import org.openrndr.internal.gl3.BufferWriterGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.ColorBufferShadowGL3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferShadowGL3;", "Lorg/openrndr/draw/ColorBufferShadow;", "colorBuffer", "Lorg/openrndr/internal/gl3/ColorBufferGL3;", "(Lorg/openrndr/internal/gl3/ColorBufferGL3;)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getColorBuffer", "()Lorg/openrndr/internal/gl3/ColorBufferGL3;", "elementSize", "", "getElementSize", "()I", "size", "getSize", "destroy", "", "download", "upload", "writer", "Lorg/openrndr/draw/BufferWriter;", "openrndr-gl3"})
public final class ColorBufferShadowGL3
implements ColorBufferShadow {
    private final int size;
    private final int elementSize;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final ColorBufferGL3 colorBuffer;

    public final int getSize() {
        return this.size;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void download() {
        ColorBufferGL3Kt.access$getLogger$p().debug(download.1.INSTANCE);
        this.getColorBuffer().read(this.getBuffer());
    }

    @Override
    public void upload() {
        this.getColorBuffer().write(this.getBuffer());
    }

    @Override
    public void destroy() {
        this.getColorBuffer().destroyShadow();
    }

    @Override
    @NotNull
    public BufferWriter writer() {
        return new BufferWriterGL3(this.getBuffer(), 0, 2, null);
    }

    @Override
    @NotNull
    public ColorBufferGL3 getColorBuffer() {
        return this.colorBuffer;
    }

    public ColorBufferShadowGL3(@NotNull ColorBufferGL3 colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.colorBuffer = colorBuffer;
        this.size = this.getColorBuffer().getWidth() * this.getColorBuffer().getHeight();
        this.elementSize = this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(this.elementSize * this.size);
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "BufferUtils.createByteBuffer(elementSize * size)");
        this.buffer = byteBuffer;
    }
}

