/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.Configuration;
import org.openrndr.DropEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyboardModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseEventType;
import org.openrndr.Program;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.draw.Drawer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGL3;
import org.openrndr.internal.gl3.ApplicationGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010\r\u00a8\u0006*"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "value", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "driver", "Lorg/openrndr/internal/gl3/DriverGL3;", "exitRequested", "", "realWindowTitle", "seconds", "", "getSeconds", "()D", "startTimeMillis", "", "getStartTimeMillis", "()J", "setStartTimeMillis", "(J)V", "window", "windowTitle", "getWindowTitle", "setWindowTitle", "exit", "", "loop", "modifierSet", "", "Lorg/openrndr/KeyboardModifier;", "mods", "", "Companion", "openrndr-gl3"})
public final class ApplicationGL3
extends Application {
    private final long window;
    private DriverGL3 driver;
    private String realWindowTitle;
    private boolean exitRequested;
    private long startTimeMillis;
    private final Program program;
    private final Configuration configuration;
    private static boolean once;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getClipboardContents() {
        try {
            String result;
            String string = result = GLFW.glfwGetClipboardString(this.window);
            Intrinsics.checkExpressionValueIsNotNull(string, "result");
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void setClipboardContents(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        GLFW.glfwSetClipboardString(this.window, value);
    }

    public final long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public final void setStartTimeMillis(long l) {
        this.startTimeMillis = l;
    }

    @Override
    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.startTimeMillis) / 1000.0;
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.realWindowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        GLFW.glfwSetWindowTitle(this.window, value);
        this.realWindowTitle = value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loop() {
        void down;
        void globalModifiers;
        Ref.ObjectRef objectRef;
        ApplicationGL3Kt.access$getLogger$p().debug(loop.1.INSTANCE);
        GL.createCapabilities();
        int[] vaos = new int[1];
        GL30.glGenVertexArrays(vaos);
        GL30.glBindVertexArray(vaos[0]);
        this.driver = new DriverGL3();
        this.driver.setDefaultVAO(vaos[0]);
        this.program.setDriver(this.driver);
        this.program.setDrawer(new Drawer(this.driver));
        this.program.getDrawer().setWidth((int)(this.program.getWindow().getSize().getX() / this.program.getWindow().getScale().getX()));
        this.program.getDrawer().setHeight((int)(this.program.getWindow().getSize().getY() / this.program.getWindow().getScale().getY()));
        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ ApplicationGL3 this$0;

            @NotNull
            public final String invoke() {
                return "program.drawer size " + ApplicationGL3.access$getProgram$p(this.this$0).getDrawer().getWidth() + ' ' + ApplicationGL3.access$getProgram$p(this.this$0).getDrawer().getHeight();
            }
            {
                this.this$0 = applicationGL3;
                super(0);
            }
        });
        this.program.setWidth(this.program.getDrawer().getWidth());
        this.program.setHeight(this.program.getDrawer().getHeight());
        this.program.getDrawer().ortho();
        Ref.ObjectRef objectRef2 = objectRef = new Ref.ObjectRef();
        Set set = SetsKt.emptySet();
        objectRef2.element = set;
        GLFW.glfwSetKeyCallback(this.window, new GLFWKeyCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, int key, int scancode, int action, int mods) {
                Set modifiers = ApplicationGL3.access$modifierSet(this.this$0, mods);
                String string = GLFW.glfwGetKeyName(key, scancode);
                if (string == null) {
                    string = "<null>";
                }
                String name = string;
                this.$globalModifiers.element = modifiers;
                switch (action) {
                    case 1: {
                        ApplicationGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyDown().trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, scancode, name, modifiers));
                        break;
                    }
                    case 0: {
                        ApplicationGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyUp().trigger(new KeyEvent(KeyEventType.KEY_UP, key, scancode, name, modifiers));
                    }
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetDropCallback(this.window, new GLFWDropCallbackI(this){
            final /* synthetic */ ApplicationGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(long $noName_0, int count, long names) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(count){
                    final /* synthetic */ int $count;

                    @NotNull
                    public final String invoke() {
                        return "" + this.$count + " file(s) have been dropped";
                    }
                    {
                        this.$count = n;
                        super(0);
                    }
                });
                PointerBuffer pointers = PointerBuffer.create(names, count);
                Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, count);
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    File file = new File(pointers.getStringUTF8(0));
                    collection.add(file);
                }
                List files = (List)destination$iv$iv;
                ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getDrop().trigger(new DropEvent(new Vector2(0.0, 0.0), files));
            }
            {
                this.this$0 = applicationGL3;
            }
        });
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        GLFW.glfwSetScrollCallback(this.window, new GLFWScrollCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, double xoffset, double yoffset) {
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getScrolled().trigger(new Program.Mouse.MouseEvent(new Vector2(xoffset, yoffset), MouseEventType.SCROLLED, MouseButton.NONE, (Set)this.$globalModifiers.element));
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.window, new GLFWMouseButtonCallbackI(this, (Ref.BooleanRef)down){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.BooleanRef $down;

            public final void invoke(long $noName_0, int button, int action, int mods) {
                MouseButton mouseButton;
                switch (button) {
                    case 0: {
                        mouseButton = MouseButton.LEFT;
                        break;
                    }
                    case 1: {
                        mouseButton = MouseButton.RIGHT;
                        break;
                    }
                    case 2: {
                        mouseButton = MouseButton.CENTER;
                        break;
                    }
                    default: {
                        mouseButton = MouseButton.NONE;
                    }
                }
                MouseButton mouseButton2 = mouseButton;
                Set modifiers = new LinkedHashSet<E>();
                if ((mods & 1) != 0) {
                    modifiers.add(KeyboardModifier.SHIFT);
                }
                if ((mods & 4) != 0) {
                    modifiers.add(KeyboardModifier.ALT);
                }
                if ((mods & 2) != 0) {
                    modifiers.add(KeyboardModifier.CTRL);
                }
                if ((mods & 8) != 0) {
                    modifiers.add(KeyboardModifier.SUPER);
                }
                if (action == 1) {
                    this.$down.element = true;
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getButtonDown().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition().div(ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getScale()), MouseEventType.BUTTON_DOWN, mouseButton2, modifiers));
                }
                if (action == 0) {
                    this.$down.element = false;
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getButtonUp().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition().div(ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getScale()), MouseEventType.BUTTON_UP, mouseButton2, modifiers));
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$down = booleanRef;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.window, new GLFWCursorPosCallbackI(this, (Ref.ObjectRef)globalModifiers, (Ref.BooleanRef)down){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;
            final /* synthetic */ Ref.BooleanRef $down;

            public final void invoke(long $noName_0, double xpos, double ypos) {
                Vector2 position = new Vector2(xpos, ypos).div(ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getScale());
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(xpos, ypos, position){
                    final /* synthetic */ double $xpos;
                    final /* synthetic */ double $ypos;
                    final /* synthetic */ Vector2 $position;

                    @NotNull
                    public final String invoke() {
                        return "mouse moved " + this.$xpos + ' ' + this.$ypos + " -- " + this.$position;
                    }
                    {
                        this.$xpos = d;
                        this.$ypos = d2;
                        this.$position = vector2;
                        super(0);
                    }
                });
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().setPosition(position);
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getMoved().trigger(new Program.Mouse.MouseEvent(position, MouseEventType.MOVED, MouseButton.NONE, (Set)this.$globalModifiers.element));
                if (this.$down.element) {
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getDragged().trigger(new Program.Mouse.MouseEvent(position, MouseEventType.DRAGGED, MouseButton.NONE, SetsKt.emptySet()));
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
                this.$down = booleanRef;
            }
        });
        GLFW.glfwSetCursorEnterCallback(this.window, loop.8.INSTANCE);
        ProgramRenderTargetGL3 defaultRenderTarget = new ProgramRenderTargetGL3(this.program);
        defaultRenderTarget.bind();
        if (this.configuration.getShowBeforeSetup()) {
            ApplicationGL3Kt.access$getLogger$p().debug(loop.9.INSTANCE);
            GL11.glDepthMask(true);
            GL11.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL11.glClear(17664);
            GLFW.glfwSwapBuffers(this.window);
            GL11.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL11.glClear(17664);
            GL11.glDepthMask(false);
            GLFW.glfwPollEvents();
        }
        ApplicationGL3Kt.access$getLogger$p().debug(loop.10.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().debug(loop.11.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().debug(loop.12.INSTANCE);
        int[] fbw = new int[1];
        int[] fbh = new int[1];
        GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
        String string = "frame buffer size: " + fbw[0] + ' ' + fbh[0];
        System.out.println((Object)string);
        ApplicationGL3Kt.access$getLogger$p().info((Function0<? extends Object>)new Function0<String>(fbw, fbh){
            final /* synthetic */ int[] $fbw;
            final /* synthetic */ int[] $fbh;

            @NotNull
            public final String invoke() {
                return "frame buffer size: " + this.$fbw[0] + ' ' + this.$fbh[0];
            }
            {
                this.$fbw = nArray;
                this.$fbh = nArray2;
                super(0);
            }
        });
        this.program.getWindow().setSize(new Vector2((double)fbw[0] * 1.0, (double)fbh[0] * 1.0));
        this.program.setWidth((int)((double)fbw[0] / this.program.getWindow().getScale().getX()));
        this.program.setHeight((int)((double)fbh[0] / this.program.getWindow().getScale().getY()));
        this.program.getDrawer().setWidth(this.program.getWidth());
        this.program.getDrawer().setHeight(this.program.getHeight());
        this.program.getDrawer().reset();
        this.program.getDrawer().ortho();
        if (this.configuration.getHideCursor()) {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
        this.program.setup();
        this.startTimeMillis = System.currentTimeMillis();
        Throwable exception = null;
        GLFW.glfwSwapInterval(1);
        while (!this.exitRequested && !GLFW.glfwWindowShouldClose(this.window)) {
            GL30.glBindVertexArray(vaos[0]);
            int[] fbw2 = new int[1];
            int[] fbh2 = new int[1];
            GLFW.glfwGetFramebufferSize(this.window, fbw2, fbh2);
            this.program.getWindow().setSize(new Vector2((double)fbw2[0] * 1.0, (double)fbh2[0] * 1.0));
            this.program.setWidth((int)((double)fbw2[0] / this.program.getWindow().getScale().getX()));
            this.program.setHeight((int)((double)fbh2[0] / this.program.getWindow().getScale().getY()));
            this.program.getDrawer().setWidth(this.program.getWidth());
            this.program.getDrawer().setHeight(this.program.getHeight());
            this.program.getDrawer().reset();
            this.program.getDrawer().ortho();
            this.program.getWindow().getDrop().deliver();
            this.program.getKeyboard().getKeyDown().deliver();
            this.program.getKeyboard().getKeyUp().deliver();
            this.program.getKeyboard().getKeyRepeat().deliver();
            this.program.getMouse().getMoved().deliver();
            this.program.getMouse().getScrolled().deliver();
            this.program.getMouse().getButtonDown().deliver();
            this.program.getMouse().getButtonUp().deliver();
            this.program.getMouse().getDragged().deliver();
            try {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
                    final /* synthetic */ ApplicationGL3 this$0;

                    @NotNull
                    public final String invoke() {
                        return "window: " + (int)ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSize().getX() + 'x' + (int)ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSize().getY() + " program: " + ApplicationGL3.access$getProgram$p(this.this$0).getWidth() + 'x' + ApplicationGL3.access$getProgram$p(this.this$0).getHeight();
                    }
                    {
                        this.this$0 = applicationGL3;
                        super(0);
                    }
                });
                GL11.glViewport(0, 0, fbw2[0], fbh2[0]);
                this.program.draw();
            }
            catch (Throwable e) {
                ApplicationGL3Kt.access$getLogger$p().error(loop.15.INSTANCE);
                exception = e;
                break;
            }
            GLFW.glfwSwapBuffers(this.window);
            GLFW.glfwPollEvents();
        }
        ApplicationGL3Kt.access$getLogger$p().info(loop.16.INSTANCE);
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
        ApplicationGL3Kt.access$getLogger$p().info(loop.17.INSTANCE);
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            throw it;
        }
    }

    private final Set<KeyboardModifier> modifierSet(int mods) {
        Set modifiers = new LinkedHashSet();
        if ((mods & 1) != 0) {
            modifiers.add(KeyboardModifier.SHIFT);
        }
        if ((mods & 4) != 0) {
            modifiers.add(KeyboardModifier.ALT);
        }
        if ((mods & 2) != 0) {
            modifiers.add(KeyboardModifier.CTRL);
        }
        if ((mods & 8) != 0) {
            modifiers.add(KeyboardModifier.SUPER);
        }
        return modifiers;
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationGL3(@NotNull Program program, @NotNull Configuration configuration) {
        void readyFrames;
        long l;
        Intrinsics.checkParameterIsNotNull(program, "program");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.program = program;
        this.configuration = configuration;
        this.realWindowTitle = this.configuration.getTitle();
        this.startTimeMillis = System.currentTimeMillis();
        ApplicationGL3Kt.access$getLogger$p().debug(1.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().trace(2.INSTANCE);
        this.driver = new DriverGL3();
        Driver.Companion.setDriver(this.driver);
        this.program.setApplication(this);
        GLFW.glfwSetErrorCallback(GLFWErrorCallback.create(3.INSTANCE));
        if (!GLFW.glfwInit()) {
            throw (Throwable)new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 0);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        final float[] xscale = new float[1];
        final float[] yscale = new float[1];
        GLFW.glfwGetMonitorContentScale(GLFW.glfwGetPrimaryMonitor(), xscale, yscale);
        if (this.configuration.getFullscreen()) {
            xscale[0] = 1.0f;
            yscale[0] = 1.0f;
        }
        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return "content scale " + xscale[0] + ' ' + yscale[0];
            }
        });
        this.program.getWindow().setScale(new Vector2(xscale[0], yscale[0]));
        ApplicationGL3Kt.access$getLogger$p().debug(5.INSTANCE);
        if (!this.configuration.getFullscreen()) {
            int adjustedWidth = (int)(xscale[0] * (float)this.configuration.getWidth());
            int adjustedHeight = (int)(yscale[0] * (float)this.configuration.getHeight());
            l = GLFW.glfwCreateWindow(adjustedWidth, adjustedHeight, this.configuration.getTitle(), 0L, 0L);
        } else {
            ApplicationGL3Kt.access$getLogger$p().info(6.INSTANCE);
            int requestWidth = this.configuration.getWidth();
            int requestHeight = this.configuration.getHeight();
            if (requestWidth == -1 || requestHeight == -1) {
                GLFWVidMode mode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
                requestWidth = mode.width();
                requestHeight = mode.height();
            }
            l = GLFW.glfwCreateWindow(requestWidth, requestHeight, this.configuration.getTitle(), GLFW.glfwGetPrimaryMonitor(), 0L);
        }
        this.window = l;
        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return "window created: " + window;
            }
        });
        if (this.window == 0L) {
            throw (Throwable)new RuntimeException("Failed to create the GLFW window");
        }
        Object requestWidth = MemoryStack.stackPush();
        MemoryStack stack = requestWidth;
        IntBuffer pWidth = stack.mallocInt(1);
        IntBuffer pHeight = stack.mallocInt(1);
        GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        ApplicationGL3Kt.access$getLogger$p().debug(9.INSTANCE);
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(1);
        requestWidth = new Ref.IntRef();
        ((Ref.IntRef)requestWidth).element = 0;
        GLFW.glfwSetFramebufferSizeCallback(this.window, new GLFWFramebufferSizeCallbackI((Ref.IntRef)readyFrames){
            final /* synthetic */ Ref.IntRef $readyFrames;

            @Override
            public final void invoke(long window, final int width, final int height) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "resizing window to " + width + 'x' + height + ' ';
                    }
                });
                final float[] xscale = new float[1];
                final float[] yscale = new float[1];
                GLFW.glfwGetWindowContentScale(window, xscale, yscale);
                final int[] fbw = new int[1];
                final int[] fbh = new int[1];
                GLFW.glfwGetFramebufferSize(window, fbw, fbh);
                final int[] fl = new int[1];
                final int[] ft = new int[1];
                final int[] fr = new int[1];
                final int[] fb = new int[1];
                long monitor = GLFW.glfwGetPrimaryMonitor();
                GLFWVidMode mode = GLFW.glfwGetVideoMode(monitor);
                GLFW.glfwGetWindowFrameSize(window, fl, ft, fr, fb);
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "window scale: " + xscale[0] + ' ' + yscale[0];
                    }
                });
                final int[] ww = new int[1];
                final int[] wh = new int[1];
                GLFW.glfwGetWindowSize(window, ww, wh);
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "window frame size: " + (fr[0] - fl[0]) + ' ' + (fb[0] - ft[0]) + ' ' + fl[0] + ' ' + fr[0] + ' ' + ft[0] + ' ' + fb[0];
                    }
                });
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "window size      : " + ww[0] + ' ' + wh[0];
                    }
                });
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "frame buffer size: " + fbw[0] + ' ' + fbh[0];
                    }
                });
                program.getWindow().setScale(new Vector2(xscale[0], yscale[0]));
                program.getWindow().setSize(new Vector2(width, height));
                if (this.$readyFrames.element > 0) {
                    GL11.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
                    GL11.glClear(16384);
                    GLFW.glfwGetFramebufferSize(window, fbw, fbh);
                    program.getWindow().setSize(new Vector2((double)fbw[0] * 1.0, (double)fbh[0] * 1.0));
                    program.setWidth((int)((double)fbw[0] / program.getWindow().getScale().getX()));
                    program.setHeight((int)((double)fbh[0] / program.getWindow().getScale().getY()));
                    program.getDrawer().setWidth(program.getWidth());
                    program.getDrawer().setHeight(program.getHeight());
                    program.getDrawer().reset();
                    program.getDrawer().ortho();
                    program.getKeyboard().getKeyDown().deliver();
                    program.getKeyboard().getKeyUp().deliver();
                    program.getKeyboard().getKeyRepeat().deliver();
                    program.getMouse().getMoved().deliver();
                    program.getMouse().getButtonDown().deliver();
                    program.getMouse().getButtonUp().deliver();
                    program.getMouse().getDragged().deliver();
                    try {
                        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Vector2>(){

                            @Override
                            @NotNull
                            public final Vector2 invoke() {
                                return program.getWindow().getSize();
                            }
                        });
                        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                            @Override
                            @NotNull
                            public final String invoke() {
                                return "" + program.getWidth() + ' ' + program.getHeight();
                            }
                        });
                        GL11.glViewport(0, 0, fbw[0], fbh[0]);
                        program.draw();
                    }
                    catch (Throwable e) {
                        ApplicationGL3Kt.access$getLogger$p().error(8.INSTANCE);
                    }
                    GLFW.glfwSwapBuffers(window);
                }
                int n = this.$readyFrames.element;
                this.$readyFrames.element = n + 1;
                ApplicationGL3Kt.access$getLogger$p().debug(9.INSTANCE);
            }
            {
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetWindowPosCallback(this.window, new GLFWWindowPosCallbackI(){

            @Override
            public final void invoke(long $noName_0, final int x, final int y) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "window has moved to " + x + ' ' + y;
                    }
                });
                program.getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
            }
        });
        GLFW.glfwSetWindowFocusCallback(this.window, new GLFWWindowFocusCallbackI(){

            @Override
            public final void invoke(long $noName_0, final boolean focused) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(){

                    @Override
                    @NotNull
                    public final String invoke() {
                        return "window focus has changed; focused=" + focused;
                    }
                });
                if (focused) {
                    program.getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, new Vector2(0.0, 0.0), new Vector2(0.0, 0.0), true));
                } else {
                    program.getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, new Vector2(0.0, 0.0), new Vector2(0.0, 0.0), true));
                }
            }
        });
        ApplicationGL3Kt.access$getLogger$p().debug(13.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().debug(14.INSTANCE);
        GLFW.glfwShowWindow(this.window);
    }

    static {
        Companion = new Companion(null);
        once = true;
    }

    @NotNull
    public static final /* synthetic */ Set access$modifierSet(ApplicationGL3 $this, int mods) {
        return $this.modifierSet(mods);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGL3$Companion;", "", "()V", "once", "", "getOnce", "()Z", "setOnce", "(Z)V", "openrndr-gl3"})
    public static final class Companion {
        public final boolean getOnce() {
            return once;
        }

        public final void setOnce(boolean bl) {
            once = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

