/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Shader;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/draw/DrawContext;", "", "view", "Lorg/openrndr/math/Matrix44;", "projection", "width", "", "height", "(Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;II)V", "getHeight", "()I", "getProjection", "()Lorg/openrndr/math/Matrix44;", "getView", "getWidth", "applyToShader", "", "shader", "Lorg/openrndr/draw/Shader;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "openrndr-core"})
public final class DrawContext {
    @NotNull
    private final Matrix44 view;
    @NotNull
    private final Matrix44 projection;
    private final int width;
    private final int height;

    public final void applyToShader(@NotNull Shader shader2) {
        Intrinsics.checkParameterIsNotNull(shader2, "shader");
        shader2.uniform("viewMatrix", this.view);
        shader2.uniform("projectionMatrix", this.projection);
        shader2.uniform("viewProjectionMatrix", this.projection.times(this.view));
        shader2.uniform("viewDimensions", new Vector2(this.width, this.height));
        shader2.uniform("normalMatrix", TransformsKt.normalMatrix(this.view));
    }

    @NotNull
    public final Matrix44 getView() {
        return this.view;
    }

    @NotNull
    public final Matrix44 getProjection() {
        return this.projection;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public DrawContext(@NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        this.view = view;
        this.projection = projection;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final Matrix44 component1() {
        return this.view;
    }

    @NotNull
    public final Matrix44 component2() {
        return this.projection;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final DrawContext copy(@NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        return new DrawContext(view, projection, width, height);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DrawContext copy$default(DrawContext drawContext, Matrix44 matrix44, Matrix44 matrix442, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            matrix44 = drawContext.view;
        }
        if ((n3 & 2) != 0) {
            matrix442 = drawContext.projection;
        }
        if ((n3 & 4) != 0) {
            n = drawContext.width;
        }
        if ((n3 & 8) != 0) {
            n2 = drawContext.height;
        }
        return drawContext.copy(matrix44, matrix442, n, n2);
    }

    public String toString() {
        return "DrawContext(view=" + this.view + ", projection=" + this.projection + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public int hashCode() {
        Matrix44 matrix44 = this.view;
        Matrix44 matrix442 = this.projection;
        return (((matrix44 != null ? ((Object)matrix44).hashCode() : 0) * 31 + (matrix442 != null ? ((Object)matrix442).hashCode() : 0)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawContext)) break block3;
                DrawContext drawContext = (DrawContext)object;
                if (!Intrinsics.areEqual(this.view, drawContext.view) || !Intrinsics.areEqual(this.projection, drawContext.projection) || !(this.width == drawContext.width) || !(this.height == drawContext.height)) break block3;
            }
            return true;
        }
        return false;
    }
}

