/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00128\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016RA\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/binpack/RandomBinarySplitter;", "Lorg/openrndr/binpack/Splitter;", "enclosement", "Lorg/openrndr/shape/IntRectangle;", "invert", "", "constraints", "Lkotlin/Function2;", "Lorg/openrndr/binpack/PackNode;", "Lkotlin/ParameterName;", "name", "node", "rectangle", "(Lorg/openrndr/shape/IntRectangle;ZLkotlin/jvm/functions/Function2;)V", "getConstraints", "()Lkotlin/jvm/functions/Function2;", "getEnclosement", "()Lorg/openrndr/shape/IntRectangle;", "getInvert", "()Z", "split", "", "rect", "openrndr-binpack"})
public final class RandomBinarySplitter
implements Splitter {
    @NotNull
    private final IntRectangle enclosement;
    private final boolean invert;
    @NotNull
    private final Function2<PackNode, IntRectangle, Boolean> constraints;

    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rect) {
        IntRectangle rrect;
        IntRectangle lrect;
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        if (!this.constraints.invoke(node, rect).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        int dw = node.getArea().getWidth() - rect.getWidth();
        int dh = node.getArea().getHeight() - rect.getHeight();
        float s = this.invert ? 1 : -1;
        if (dw > dh) {
            if (Math.random() < 0.5) {
                lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), rect.getWidth(), node.getArea().getHeight());
                rrect = new IntRectangle(node.getArea().getX() + rect.getWidth(), node.getArea().getY(), node.getArea().getWidth() - rect.getWidth(), node.getArea().getHeight());
            } else {
                int ew = node.getArea().getWidth() - rect.getWidth();
                rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), ew, node.getArea().getHeight());
                lrect = new IntRectangle(node.getArea().getX() + ew, node.getArea().getY(), rect.getWidth(), node.getArea().getHeight());
            }
        } else if (Math.random() < 0.5) {
            lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), node.getArea().getWidth(), rect.getHeight());
            rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY() + rect.getHeight(), node.getArea().getWidth(), node.getArea().getHeight() - rect.getHeight());
        } else {
            int eh = node.getArea().getHeight() - rect.getHeight();
            rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), node.getArea().getWidth(), eh);
            lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY() + eh, node.getArea().getWidth(), rect.getHeight());
        }
        return CollectionsKt.listOf(new PackNode[]{new PackNode(lrect, node), new PackNode(rrect, node)});
    }

    @NotNull
    public final IntRectangle getEnclosement() {
        return this.enclosement;
    }

    public final boolean getInvert() {
        return this.invert;
    }

    @NotNull
    public final Function2<PackNode, IntRectangle, Boolean> getConstraints() {
        return this.constraints;
    }

    public RandomBinarySplitter(@NotNull IntRectangle enclosement, boolean invert2, @NotNull Function2<? super PackNode, ? super IntRectangle, Boolean> constraints) {
        Intrinsics.checkParameterIsNotNull(enclosement, "enclosement");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        this.enclosement = enclosement;
        this.invert = invert2;
        this.constraints = constraints;
    }

    public /* synthetic */ RandomBinarySplitter(IntRectangle intRectangle, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(intRectangle, bl, function2);
    }
}

