/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.animatable;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.animatable.AnimationKey;
import org.openrndr.animatable.Clock;
import org.openrndr.animatable.DefaultClock;
import org.openrndr.animatable.easing.Easer;
import org.openrndr.animatable.easing.Easing;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J&\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J,\u0010\"\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020!J\u0006\u0010$\u001a\u00020%J(\u0010&\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0002J\u0006\u0010*\u001a\u00020\u001aJ\u0019\u0010*\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020\u001aJ\u001a\u0010/\u001a\u00020\u001a2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a01J\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011J\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0000J(\u0010/\u001a\u00020\u001a2\b\b\u0002\u0010\b\u001a\u00020\u00002\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a\u0018\u000101J\r\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b2J\u000e\u00103\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u00104\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u00104\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0006\u00105\u001a\u00020\u001aJ\u0012\u00106\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0016\u00107\u001a\u00020\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010#H\u0002J\u0006\u00108\u001a\u000209J\u001f\u00108\u001a\u0002092\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110,\"\u00020\u0011\u00a2\u0006\u0002\u0010;J\n\u0010<\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010=\u001a\u00020\u001aJ\u0006\u0010>\u001a\u00020\u001aJ\u0018\u0010?\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\u001cH\u0002J\u0012\u0010A\u001a\u00020\u001a2\b\b\u0002\u0010B\u001a\u00020\u0006H\u0007J\u000e\u0010C\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0011J\u000e\u0010D\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u0006R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u0007R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/openrndr/animatable/Animatable;", "", "target", "(Ljava/lang/Object;)V", "()V", "createAtTime", "", "(J)V", "animatable", "animationKeys", "", "Lorg/openrndr/animatable/AnimationKey;", "getCreateAtTime$openrndr_animatable", "()J", "setCreateAtTime$openrndr_animatable", "fieldCache", "Ljava/util/HashMap;", "", "Ljava/lang/reflect/Field;", "lastTime", "getLastTime$openrndr_animatable", "setLastTime$openrndr_animatable", "stage", "timeStack", "Ljava/util/Stack;", "add", "", "variable", "", "duration", "easer", "Lorg/openrndr/animatable/easing/Easer;", "easing", "Lorg/openrndr/animatable/easing/Easing;", "animate", "Lkotlin/reflect/KMutableProperty0;", "animationCount", "", "blend", "dt", "from", "delta", "cancel", "fields", "", "([Ljava/lang/String;)V", "cancelQueued", "complete", "callback", "Lkotlin/Function1;", "createAtTime$openrndr_animatable", "delay", "ease", "end", "getField", "getFieldValue", "hasAnimations", "", "variables", "([Ljava/lang/String;)Z", "lastQueued", "popTime", "pushTime", "setFieldValue", "value", "updateAnimation", "time", "velocity", "waitUntil", "Companion", "openrndr-animatable"})
public class Animatable {
    private long createAtTime;
    private long lastTime;
    private List<AnimationKey> animationKeys;
    private String stage;
    private Stack<Long> timeStack;
    private Object animatable;
    private final HashMap<String, Field> fieldCache;
    @NotNull
    private static Clock clock;
    public static final Companion Companion;

    public final long getCreateAtTime$openrndr_animatable() {
        return this.createAtTime;
    }

    public final void setCreateAtTime$openrndr_animatable(long l) {
        this.createAtTime = l;
    }

    public final long getLastTime$openrndr_animatable() {
        return this.lastTime;
    }

    public final void setLastTime$openrndr_animatable(long l) {
        this.lastTime = l;
    }

    public final void pushTime() {
        if (this.timeStack == null) {
            this.timeStack = new Stack();
        }
        Stack<Long> stack = this.timeStack;
        if (stack == null) {
            Intrinsics.throwNpe();
        }
        stack.push(this.createAtTime);
    }

    public final void popTime() {
        Stack<Long> stack = this.timeStack;
        if (stack == null) {
            Intrinsics.throwNpe();
        }
        Long l = stack.pop();
        Intrinsics.checkExpressionValueIsNotNull(l, "timeStack!!.pop()");
        this.createAtTime = ((Number)l).longValue();
    }

    public final void delay(long duration) {
        this.createAtTime += duration;
    }

    public final void waitUntil(long time) {
        this.createAtTime = time;
    }

    public final void animate(@NotNull String variable, double target, long duration) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        this.animate(variable, target, duration, Easing.None);
    }

    public final void animate(@NotNull String variable, double target, long duration, @NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull((Object)easing, "easing");
        this.animate(variable, target, duration, easing.getEaser());
    }

    public final void animate(@NotNull String variable, double target, long duration, @NotNull Easer easer) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(easer, "easer");
        AnimationKey key = new AnimationKey(variable, target, duration, this.createAtTime);
        key.setEasing(easer);
        if (this.animationKeys == null) {
            List list;
            Animatable animatable = this;
            animatable.animationKeys = list = (List)new ArrayList();
        }
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(key);
    }

    public final boolean hasAnimations() {
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size() != 0;
    }

    public final boolean hasAnimations(String ... variables) {
        Intrinsics.checkParameterIsNotNull(variables, "variables");
        HashSet<String> variableSet = new HashSet<String>();
        for (String variable : variables) {
            variableSet.add(variable);
        }
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey animationKey : list) {
            if (animationKey.getVariable() == null || !variableSet.contains(animationKey.getVariable())) continue;
            return true;
        }
        return false;
    }

    public final void add(@NotNull String variable, double target, long duration) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        this.add(variable, target, duration, Easing.None);
    }

    public final void add(@NotNull String variable, double target, long duration, @NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull((Object)easing, "easing");
        this.add(variable, target, duration, easing.getEaser());
    }

    public final void add(@NotNull String variable, double target, long duration, @NotNull Easer easer) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(easer, "easer");
        AnimationKey key = new AnimationKey(variable, target, duration, this.createAtTime);
        key.setAnimationMode(AnimationKey.AnimationMode.Additive);
        key.setEasing(easer);
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(key);
    }

    public final void complete(@NotNull String variable) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        AnimationKey key = this.lastQueued(variable);
        if (key != null) {
            this.createAtTime = key.getStart() + key.getDuration();
        }
    }

    public final void complete(@NotNull Function1<? super Animatable, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        this.complete(this, callback);
    }

    public final void ease(@NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull((Object)easing, "easing");
        this.ease(easing.getEaser());
    }

    public final void ease(@NotNull Easer easer) {
        Intrinsics.checkParameterIsNotNull(easer, "easer");
        AnimationKey last = this.lastQueued();
        if (last != null) {
            last.setEasing(easer);
        }
    }

    public final double velocity(@NotNull String variable) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            if (key.getStart() > this.lastTime || !key.getVariable().equals(variable)) continue;
            double delta = key.getTarget() - key.getFrom();
            long dt = this.lastTime - key.getStart();
            return key.getEasing().velocity((double)dt / 1000.0, key.getFrom(), delta, (double)key.getDuration() / 1000.0);
        }
        return 0.0;
    }

    public final void complete(@NotNull Animatable animatable) {
        Intrinsics.checkParameterIsNotNull(animatable, "animatable");
        this.complete(animatable, null);
    }

    public final void complete(@NotNull Animatable animatable, @Nullable Function1<? super Animatable, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(animatable, "animatable");
        AnimationKey waitForKey = animatable.lastQueued();
        if (waitForKey != null) {
            this.createAtTime = waitForKey.getStart() + waitForKey.getDuration();
            if (callback != null) {
                List<AnimationKey> list = this.animationKeys;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                List<AnimationKey> list2 = this.animationKeys;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list.get(list2.size() - 1).addCompletionCallback(callback);
            }
        } else if (callback != null) {
            callback.invoke(this);
        }
    }

    public static /* bridge */ /* synthetic */ void complete$default(Animatable animatable, Animatable animatable2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: complete");
        }
        if ((n & 1) != 0) {
            animatable2 = animatable;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        animatable.complete(animatable2, function1);
    }

    public final void cancel() {
        if (this.animationKeys != null) {
            List<AnimationKey> list = this.animationKeys;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.clear();
        }
        this.createAtTime = this.lastTime;
    }

    public final void cancelQueued() {
        List keep = new ArrayList();
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            if (!Intrinsics.areEqual((Object)key.getAnimationState(), (Object)AnimationKey.AnimationState.Playing)) continue;
            keep.add(key);
        }
        List<AnimationKey> list2 = this.animationKeys;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        list2.clear();
        List<AnimationKey> list3 = this.animationKeys;
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        list3.addAll(keep);
    }

    public final void end() {
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            if (!Intrinsics.areEqual((Object)key.getAnimationState(), (Object)AnimationKey.AnimationState.Playing)) continue;
            this.setFieldValue(key.getVariable(), key.getTarget());
        }
        List<AnimationKey> list2 = this.animationKeys;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        list2.clear();
        this.createAtTime = this.lastTime;
    }

    public final void cancel(@NotNull String[] fields) {
        Intrinsics.checkParameterIsNotNull(fields, "fields");
        HashSet filter = new HashSet();
        Collections.addAll(filter, Arrays.copyOf(fields, fields.length));
        ArrayList<AnimationKey> toRemove = new ArrayList<AnimationKey>();
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            if (!filter.contains(key.getVariable())) continue;
            toRemove.add(key);
        }
        List<AnimationKey> list2 = this.animationKeys;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        list2.removeAll((Collection)toRemove);
        this.createAtTime = this.lastTime;
    }

    private final Field getField(String variable) {
        Field field = this.fieldCache.get(variable);
        if (field == null) {
            if (this.animatable == null) {
                this.animatable = this;
            }
            if (this.animatable == null) {
                Intrinsics.throwNpe();
            }
            for (Class<?> _class = (v40393).getClass(); _class != null; _class = _class.getSuperclass()) {
                try {
                    Field field2 = field = _class.getDeclaredField(variable);
                    if (field2 == null) {
                        Intrinsics.throwNpe();
                    }
                    field2.setAccessible(true);
                    this.fieldCache.put(variable, field);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        return field;
    }

    private final double getFieldValue(String variable) {
        try {
            int indexPos;
            int n = indexPos = variable.charAt(variable.length() - 1) == ']' ? StringsKt.indexOf$default((CharSequence)variable, "[", 0, false, 6, null) : -1;
            if (indexPos != -1) {
                int offset;
                Class<?> _class;
                Field field;
                String string = variable;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, indexPos);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String fieldName = string3;
                String string4 = variable;
                int n3 = indexPos + 1;
                int n4 = variable.length() - 1;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3, n4);
                Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String keyName = string6;
                Field field2 = field = this.getField(fieldName);
                if (field2 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual(_class = field2.getType(), double[].class)) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this.animatable);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.DoubleArray");
                    }
                    double[] a = (double[])object;
                    return a[offset];
                }
                if (Intrinsics.areEqual(_class, float[].class)) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this.animatable);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.FloatArray");
                    }
                    float[] a = (float[])object;
                    return a[offset];
                }
                if (field.get(this) instanceof List) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                    }
                    List a = (List)object;
                    Object o = a.get(offset);
                    if (o instanceof Double) {
                        return ((Number)o).doubleValue();
                    }
                    if (o instanceof Float) {
                        return ((Number)o).floatValue();
                    }
                }
            } else {
                Field field = this.getField(variable);
                if (field != null) {
                    return field.getDouble(this.animatable);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    private final double getFieldValue(KMutableProperty0<Object> variable) {
        Object g = variable.get();
        Object r = g;
        if (r instanceof Double) {
            return ((Number)g).doubleValue();
        }
        return 0.0;
    }

    private final AnimationKey lastQueued() {
        AnimationKey animationKey;
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (list.size() > 0) {
            List<AnimationKey> list2 = this.animationKeys;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            List<AnimationKey> list3 = this.animationKeys;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            animationKey = list2.get(list3.size() - 1);
        } else {
            animationKey = null;
        }
        return animationKey;
    }

    /*
     * WARNING - void declaration
     */
    private final AnimationKey lastQueued(String variable) {
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int n = ((Collection)list).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            void i;
            AnimationKey k;
            List<AnimationKey> list2 = this.animationKeys;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(variable, (k = list2.get((int)i)).getVariable())) {
                return k;
            }
            --i;
        }
        return null;
    }

    private final void setFieldValue(String variable, double value) {
        try {
            int indexPos;
            int n = indexPos = variable.charAt(variable.length() - 1) == ']' ? StringsKt.indexOf$default((CharSequence)variable, "[", 0, false, 6, null) : -1;
            if (indexPos != -1) {
                int offset;
                Field field;
                String string = variable;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, indexPos);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String fieldName = string3;
                String string4 = variable;
                int n3 = indexPos + 1;
                int n4 = variable.length() - 1;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3, n4);
                Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String keyName = string6;
                Field field2 = field = this.getField(fieldName);
                if (field2 == null) {
                    Intrinsics.throwNpe();
                }
                Class<?> _class = field2.getType();
                field.setAccessible(true);
                if (Intrinsics.areEqual(_class, double[].class)) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this.animatable);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.DoubleArray");
                    }
                    double[] a = (double[])object;
                    a[offset] = value;
                } else if (Intrinsics.areEqual(_class, float[].class)) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this.animatable);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.FloatArray");
                    }
                    float[] a = (float[])object;
                    a[offset] = (float)value;
                } else if (TypeIntrinsics.isMutableList(field.get(this.animatable))) {
                    offset = Integer.parseInt(keyName);
                    Object object = field.get(this.animatable);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<*>");
                    }
                    List list = TypeIntrinsics.asMutableList(object);
                    Object o = list.get(offset);
                    if (o instanceof Float) {
                        Object object2 = field.get(this.animatable);
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Float>");
                        }
                        List floatList = TypeIntrinsics.asMutableList(object2);
                        floatList.set(offset, Float.valueOf((float)value));
                    } else if (o instanceof Double) {
                        Object object3 = field.get(this.animatable);
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Double>");
                        }
                        List doubleList = TypeIntrinsics.asMutableList(object3);
                        doubleList.set(offset, value);
                    }
                }
            } else {
                Field field = this.getField(variable);
                if (field != null) {
                    if (Intrinsics.areEqual(field.getType(), JvmClassMappingKt.getJavaPrimitiveType(Reflection.getOrCreateKotlinClass(Double.TYPE)))) {
                        field.setDouble(this.animatable, value);
                    } else if (Intrinsics.areEqual(field.getType(), JvmClassMappingKt.getJavaPrimitiveType(Reflection.getOrCreateKotlinClass(Float.TYPE)))) {
                        field.setFloat(this.animatable, (float)value);
                    } else {
                        System.err.println("warning: could not set animatable value");
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private final double blend(Easer easing, double dt, double from, double delta) {
        return easing.ease(dt, from, delta, 1.0);
    }

    public final long duration() {
        long latest = 0L;
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            long end2 = key.getStart() + key.getDuration();
            if (end2 <= latest) continue;
            latest = end2;
        }
        return Math.max(0L, Math.max(latest, this.createAtTime) - this.lastTime);
    }

    @JvmOverloads
    public final void updateAnimation(long time) {
        List toRemove = new ArrayList();
        List calls = new ArrayList();
        String updateStage = null;
        if (this.animationKeys == null) {
            List list;
            Animatable animatable = this;
            animatable.animationKeys = list = (List)new ArrayList();
        }
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (AnimationKey key : list) {
            if (key.getStart() == -1L) {
                key.setStart(time);
            }
            if (key.getStart() > time) continue;
            if (Intrinsics.areEqual((Object)key.getAnimationState(), (Object)AnimationKey.AnimationState.Queued)) {
                if (key.getVariable() != null) {
                    key.play(this.getFieldValue(key.getVariable()));
                } else {
                    key.play(0.0);
                }
            }
            if (Intrinsics.areEqual((Object)key.getAnimationState(), (Object)AnimationKey.AnimationState.Playing)) {
                double dt = time - key.getStart();
                dt = key.getDuration() > 0L ? (dt /= (double)key.getDuration()) : 1.0;
                if (dt < 0.0) {
                    dt = 0.0;
                }
                if (dt >= 1.0) {
                    dt = 1.0;
                    key.stop();
                }
                if (key.getVariable() != null) {
                    double value;
                    if (Intrinsics.areEqual((Object)key.getAnimationMode(), (Object)AnimationKey.AnimationMode.Blend)) {
                        value = this.blend(key.getEasing(), dt, key.getFrom(), key.getTarget() - key.getFrom());
                        this.setFieldValue(key.getVariable(), value);
                    } else if (Intrinsics.areEqual((Object)key.getAnimationMode(), (Object)AnimationKey.AnimationMode.Additive)) {
                        value = this.blend(key.getEasing(), dt, key.getFrom(), key.getTarget());
                        this.setFieldValue(key.getVariable(), value);
                    }
                }
            }
            if (!Intrinsics.areEqual((Object)key.getAnimationState(), (Object)AnimationKey.AnimationState.Stopped)) continue;
            for (Function1<Animatable, Unit> callback : key.getCompletionCallbacks()) {
                calls.add(new Pair<Function1<Animatable, Unit>, Animatable>(callback, this));
            }
            toRemove.add(key);
        }
        for (Pair call : calls) {
            ((Function1)call.getFirst()).invoke(call.getSecond());
        }
        for (AnimationKey key : toRemove) {
            List<AnimationKey> list2 = this.animationKeys;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.remove(key);
        }
        this.lastTime = time;
        if (this.lastTime > this.createAtTime) {
            this.createAtTime = this.lastTime;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void updateAnimation$default(Animatable animatable, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateAnimation");
        }
        if ((n & 1) != 0) {
            l = Companion.getClock$openrndr_animatable().getTime();
        }
        animatable.updateAnimation(l);
    }

    @JvmOverloads
    public final void updateAnimation() {
        Animatable.updateAnimation$default(this, 0L, 1, null);
    }

    public final long createAtTime$openrndr_animatable() {
        return this.createAtTime;
    }

    public final int animationCount() {
        List<AnimationKey> list = this.animationKeys;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size();
    }

    public final void animate(@NotNull KMutableProperty0<?> variable, double target, long duration, @NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull((Object)easing, "easing");
        this.animate(variable.getName(), target, duration, easing);
    }

    public static /* bridge */ /* synthetic */ void animate$default(Animatable animatable, KMutableProperty0 kMutableProperty0, double d, long l, Easing easing, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: animate");
        }
        if ((n & 8) != 0) {
            easing = Easing.None;
        }
        animatable.animate(kMutableProperty0, d, l, easing);
    }

    public Animatable(@NotNull Object target) {
        List list;
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.lastTime = this.createAtTime = Companion.getClock$openrndr_animatable().getTime();
        Animatable animatable = this;
        animatable.animationKeys = list = (List)new ArrayList();
        this.fieldCache = new HashMap();
        this.animatable = target;
    }

    public Animatable() {
        List list;
        this.lastTime = this.createAtTime = Companion.getClock$openrndr_animatable().getTime();
        Animatable animatable = this;
        animatable.animationKeys = list = (List)new ArrayList();
        this.fieldCache = new HashMap();
        this.animatable = this;
    }

    public Animatable(long createAtTime) {
        List list;
        this.lastTime = this.createAtTime = Companion.getClock$openrndr_animatable().getTime();
        Animatable animatable = this;
        animatable.animationKeys = list = (List)new ArrayList();
        this.fieldCache = new HashMap();
        this.createAtTime = createAtTime;
        this.animatable = this;
    }

    static {
        Companion = new Companion(null);
        clock = new DefaultClock();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/animatable/Animatable$Companion;", "", "()V", "clock", "Lorg/openrndr/animatable/Clock;", "getClock$openrndr_animatable", "()Lorg/openrndr/animatable/Clock;", "setClock$openrndr_animatable", "(Lorg/openrndr/animatable/Clock;)V", "array", "", "variable", "index", "", "", "openrndr-animatable"})
    public static final class Companion {
        @NotNull
        public final Clock getClock$openrndr_animatable() {
            return clock;
        }

        public final void setClock$openrndr_animatable(@NotNull Clock clock) {
            Intrinsics.checkParameterIsNotNull(clock, "<set-?>");
            Animatable.clock = clock;
        }

        public final void clock(@NotNull Clock clock) {
            Intrinsics.checkParameterIsNotNull(clock, "clock");
            Companion.setClock$openrndr_animatable(clock);
        }

        @NotNull
        public final Clock clock() {
            return Companion.getClock$openrndr_animatable();
        }

        @NotNull
        public final String array(@NotNull String variable, int index) {
            Intrinsics.checkParameterIsNotNull(variable, "variable");
            return "" + variable + '[' + index + ']';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

