/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = Configuration.LIBRARY_NAME.get(System.getProperty("os.arch").contains("64") ? "lwjgl" : "lwjgl32");
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(File.pathSeparator);
    private static final Pattern NATIVES_JAR = Pattern.compile("/[\\w-]+?-natives-\\w+.jar!/");

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String name) throws UnsatisfiedLinkError {
        Library.loadSystem(System::load, System::loadLibrary, Library.class, name);
    }

    public static void loadSystem(Consumer<String> load, Consumer<String> loadLibrary, Class<?> context, String name) throws UnsatisfiedLinkError {
        String libName;
        block18: {
            APIUtil.apiLog("Loading library (system): " + name);
            if (Paths.get(name, new String[0]).isAbsolute()) {
                load.accept(name);
                APIUtil.apiLog("\tSuccess");
                return;
            }
            libName = Platform.get().mapLibraryName(name);
            URL libURL = context.getClassLoader().getResource(libName);
            if (libURL == null) {
                if (Library.loadSystem(load, context, libName, Configuration.LIBRARY_PATH)) {
                    return;
                }
            } else {
                boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                try {
                    if (debugLoader) {
                        APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                    }
                    try (FileChannel ignored = SharedLibraryLoader.load(name, libName, libURL);){
                        if (Library.loadSystem(load, context, libName, Configuration.LIBRARY_PATH)) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    if (!debugLoader) break block18;
                    e.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        try {
            Path libFile;
            loadLibrary.accept(name);
            String paths = System.getProperty(JAVA_LIBRARY_PATH);
            Path path = libFile = paths == null ? null : Library.findLibrary(paths, libName);
            if (libFile != null) {
                APIUtil.apiLog(String.format("\tLoaded from %s: %s", JAVA_LIBRARY_PATH, libFile));
                Library.checkHash(context, libFile);
            } else {
                APIUtil.apiLog("\tLoaded from a ClassLoader provided path.");
            }
            return;
        }
        catch (Throwable t) {
            APIUtil.apiLog(String.format("\t%s not found in %s", libName, JAVA_LIBRARY_PATH));
            Library.printError(true);
            throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
        }
    }

    private static boolean loadSystem(Consumer<String> load, Class<?> context, String libName, Configuration<String> property) {
        String paths = property.get();
        return paths != null && Library.loadSystem(load, context, libName, property.getProperty(), paths);
    }

    private static boolean loadSystem(Consumer<String> load, Class<?> context, String libName, String property, String paths) {
        Path libFile = Library.findLibrary(paths, libName);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return false;
        }
        load.accept(libFile.toAbsolutePath().toString());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile));
        Library.checkHash(context, libFile);
        return true;
    }

    public static SharedLibrary loadNative(String name) {
        return Library.loadNative(Library.class, name);
    }

    public static SharedLibrary loadNative(Class<?> context, String name) {
        return Library.loadNative(context, name, false);
    }

    public static SharedLibrary loadNative(Class<?> context, String name, boolean bundledWithLWJGL) {
        String paths;
        SharedLibrary lib;
        String libName;
        block21: {
            APIUtil.apiLog("Loading library: " + name);
            if (new File(name).isAbsolute()) {
                SharedLibrary lib2 = APIUtil.apiCreateLibrary(name);
                APIUtil.apiLog("\tSuccess");
                return lib2;
            }
            libName = Platform.get().mapLibraryName(name);
            URL libURL = context.getClassLoader().getResource(libName);
            if (libURL == null) {
                lib = Library.loadNative(context, libName, Configuration.LIBRARY_PATH);
                if (lib != null) {
                    return lib;
                }
            } else {
                SharedLibrary sharedLibrary;
                block20: {
                    boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                    if (debugLoader) {
                        APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                    }
                    FileChannel ignored = SharedLibraryLoader.load(name, libName, libURL);
                    Throwable throwable = null;
                    try {
                        sharedLibrary = Library.loadNative(context, libName, Configuration.LIBRARY_PATH);
                        if (ignored == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (ignored != null) {
                                    Library.$closeResource(throwable, ignored);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            if (!debugLoader) break block21;
                            e.printStackTrace(APIUtil.DEBUG_STREAM);
                        }
                    }
                    Library.$closeResource(throwable, ignored);
                }
                return sharedLibrary;
            }
        }
        if (!bundledWithLWJGL && (lib = Library.loadNativeFromSystem(libName)) != null) {
            return lib;
        }
        if (Configuration.EMULATE_SYSTEM_LOADLIBRARY.get(false).booleanValue()) {
            try {
                Method findLibrary = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                findLibrary.setAccessible(true);
                String libPath = (String)findLibrary.invoke((Object)context.getClassLoader(), name);
                if (libPath != null) {
                    lib = APIUtil.apiCreateLibrary(libPath);
                    APIUtil.apiLog(String.format("\tLoaded from ClassLoader provided path: %s", libPath));
                    return lib;
                }
            }
            catch (Exception findLibrary) {
                // empty catch block
            }
        }
        if ((paths = System.getProperty(JAVA_LIBRARY_PATH)) != null && (lib = Library.loadNative(context, libName, JAVA_LIBRARY_PATH, paths)) != null) {
            return lib;
        }
        if (bundledWithLWJGL && (lib = Library.loadNativeFromSystem(libName)) != null) {
            return lib;
        }
        Library.printError(bundledWithLWJGL);
        throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
    }

    private static SharedLibrary loadNativeFromSystem(String libName) {
        SharedLibrary lib;
        try {
            lib = APIUtil.apiCreateLibrary(libName);
            APIUtil.apiLog("\tLoaded from system paths");
        }
        catch (UnsatisfiedLinkError e) {
            lib = null;
            APIUtil.apiLog(String.format("\t%s not found in system paths", libName));
        }
        return lib;
    }

    private static SharedLibrary loadNative(Class<?> context, String libName, Configuration<String> property) {
        SharedLibrary lib;
        String paths = property.get();
        if (paths != null && (lib = Library.loadNative(context, libName, property.getProperty(), paths)) != null) {
            return lib;
        }
        return null;
    }

    private static SharedLibrary loadNative(Class<?> context, String libName, String property, String paths) {
        Path libFile = Library.findLibrary(paths, libName);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return null;
        }
        SharedLibrary lib = APIUtil.apiCreateLibrary(libFile.toString());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile));
        Library.checkHash(context, libFile);
        return lib;
    }

    public static SharedLibrary loadNative(Class<?> context, Configuration<String> name, String ... defaultNames) {
        SharedLibrary library;
        block8: {
            if (name.get() != null) {
                return Library.loadNative(context, name.get());
            }
            if (defaultNames.length <= 1) {
                if (defaultNames.length == 0) {
                    throw new RuntimeException("No default names specified.");
                }
                return Library.loadNative(context, defaultNames[0]);
            }
            library = null;
            try {
                library = Library.loadNative(context, defaultNames[0]);
            }
            catch (Throwable t) {
                for (int i = 1; i < defaultNames.length; ++i) {
                    try {
                        library = Library.loadNative(context, defaultNames[i]);
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (library != null) break block8;
                throw t;
            }
        }
        return library;
    }

    private static Path findLibrary(String path, String libName) {
        for (String directory : PATH_SEPARATOR.split(path)) {
            Path p = Paths.get(directory, libName);
            if (!Files.isReadable(p)) continue;
            return p;
        }
        return null;
    }

    private static void printError(boolean bundledWithLWJGL) {
        APIUtil.DEBUG_STREAM.println("[LWJGL] Failed to load a library. Possible solutions:\n" + (bundledWithLWJGL ? "\ta) Add the directory that contains the shared library to -Djava.library.path or -Dorg.lwjgl.librarypath.\n\tb) Add the JAR that contains the shared library to the classpath." : "\ta) Install the library or the driver that provides the library.\n\tb) Ensure that the library is accessible from the system library paths."));
        if (!Checks.DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] Enable debug mode with -Dorg.lwjgl.util.Debug=true for better diagnostics.");
            if (!Configuration.DEBUG_LOADER.get(false).booleanValue()) {
                APIUtil.DEBUG_STREAM.println("[LWJGL] Enable the SharedLibraryLoader debug mode with -Dorg.lwjgl.util.DebugLoader=true for better diagnostics.");
            }
        }
    }

    private static void checkHash(Class<?> context, Path libFile) {
        block7: {
            if (!Checks.CHECKS) {
                return;
            }
            try {
                byte[] actual;
                URL classesURL = null;
                URL nativesURL = null;
                Enumeration<URL> resources = context.getClassLoader().getResources(libFile.getFileName() + ".sha1");
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (NATIVES_JAR.matcher(url.toExternalForm()).find()) {
                        nativesURL = url;
                        continue;
                    }
                    classesURL = url;
                }
                if (classesURL == null) {
                    return;
                }
                byte[] expected = Library.getSHA1(classesURL);
                byte[] byArray = actual = Checks.DEBUG || nativesURL == null ? Library.getSHA1(libFile) : Library.getSHA1(nativesURL);
                if (!Arrays.equals(expected, actual)) {
                    APIUtil.DEBUG_STREAM.println("[LWJGL] [ERROR] Incompatible Java and native library versions detected.\nPossible reasons:\n\ta) -Djava.library.path is set to a folder containing shared libraries of an older LWJGL version.\n\tb) The classpath contains jar files of an older LWJGL version.\nPossible solutions:\n\ta) Make sure to not set -Djava.library.path (it is not needed for developing with LWJGL 3) or make\n\t   sure the folder it points to contains the shared libraries of the correct LWJGL version.\n\tb) Check the classpath and make sure to only have jar files of the same LWJGL version in it.");
                }
            }
            catch (Throwable t) {
                if (!Checks.DEBUG) break block7;
                APIUtil.apiLog("Failed to verify native library.");
                t.printStackTrace();
            }
        }
    }

    private static byte[] getSHA1(URL hashURL) throws IOException {
        byte[] hash = new byte[20];
        try (InputStream sha1 = hashURL.openStream();){
            for (int i = 0; i < 20; ++i) {
                hash[i] = (byte)(Character.digit(sha1.read(), 16) << 4 | Character.digit(sha1.read(), 16));
            }
        }
        return hash;
    }

    private static byte[] getSHA1(Path libFile) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (InputStream input = Files.newInputStream(libFile, new OpenOption[0]);){
            int n;
            byte[] buffer = new byte[8192];
            while ((n = input.read(buffer)) != -1) {
                digest.update(buffer, 0, n);
            }
        }
        return digest.digest();
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.apiLog("Version: " + Version.getVersion());
            APIUtil.apiLog("\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
            APIUtil.apiLog("\tJRE: " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
            APIUtil.apiLog("\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        }
        Library.loadSystem(JNI_LIBRARY_NAME);
    }
}

