/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import jouvieje.bass.utils.MiscJNI;
import jouvieje.bass.utils.Pointer;
import jouvieje.bass.utils.SizeOfPrimitive;

public class BufferUtils
implements SizeOfPrimitive {
    public static ByteBuffer newByteBuffer(int nbElements) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(nbElements);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static CharBuffer newCharBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 2);
        return buffer.asCharBuffer();
    }

    public static ShortBuffer newShortBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 2);
        return buffer.asShortBuffer();
    }

    public static IntBuffer newIntBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 4);
        return buffer.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 8);
        return buffer.asLongBuffer();
    }

    public static FloatBuffer newFloatBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 4);
        return buffer.asFloatBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(int nbElements) {
        ByteBuffer buffer = BufferUtils.newByteBuffer(nbElements * 8);
        return buffer.asDoubleBuffer();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer src) {
        ByteBuffer dest = BufferUtils.newByteBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer src) {
        ShortBuffer dest = BufferUtils.newShortBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static IntBuffer copyIntBuffer(IntBuffer src) {
        IntBuffer dest = BufferUtils.newIntBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static LongBuffer copyLongBuffer(LongBuffer src) {
        LongBuffer dest = BufferUtils.newLongBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer src) {
        FloatBuffer dest = BufferUtils.newFloatBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer src) {
        DoubleBuffer dest = BufferUtils.newDoubleBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static int getCapacityInBytes(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return buffer.capacity();
        }
        if (buffer instanceof CharBuffer) {
            return buffer.capacity() * 2;
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.capacity() * 2;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.capacity() * 4;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.capacity() * 8;
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.capacity() * 4;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.capacity() * 8;
        }
        return -1;
    }

    public static int getPositionInBytes(Buffer buffer) {
        if (buffer != null) {
            if (buffer instanceof ByteBuffer) {
                return buffer.position();
            }
            if (buffer instanceof CharBuffer) {
                return buffer.position() * 2;
            }
            if (buffer instanceof ShortBuffer) {
                return buffer.position() * 2;
            }
            if (buffer instanceof IntBuffer) {
                return buffer.position() * 4;
            }
            if (buffer instanceof LongBuffer) {
                return buffer.position() * 8;
            }
            if (buffer instanceof FloatBuffer) {
                return buffer.position() * 4;
            }
            if (buffer instanceof DoubleBuffer) {
                return buffer.position() * 8;
            }
        }
        return -1;
    }

    public static String toString(ByteBuffer buffer) {
        long address = MiscJNI.getBufferAddress(buffer, BufferUtils.getPositionInBytes(buffer));
        return address == 0L ? null : MiscJNI.Pointer_toString(address);
    }

    public static String toString(ByteBuffer buffer, int offset, int length) {
        byte[] bytes = new byte[length];
        int position = buffer.position();
        buffer.position(position + offset);
        buffer.get(bytes, 0, length);
        buffer.rewind();
        buffer.position(position);
        return new String(bytes);
    }

    public static String toString(CharBuffer charBuffer) {
        char[] cs = new char[charBuffer.capacity()];
        charBuffer.get(cs).rewind();
        int i = 0;
        while (i < cs.length) {
            if (i == 0) break;
            ++i;
        }
        return new String(cs, 0, i);
    }

    public static ByteBuffer fromString(String s) {
        return BufferUtils.fromByteArray(s.getBytes(), 1);
    }

    public static ByteBuffer fromStringUTF16(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return BufferUtils.fromByteArray(bytes, 2);
    }

    private static ByteBuffer fromByteArray(byte[] bytes, int numTerminal) {
        ByteBuffer buff = BufferUtils.newByteBuffer(bytes.length + numTerminal);
        buff.put(bytes);
        int i = 0;
        while (i < numTerminal) {
            BufferUtils.putNullTerminal(buff);
            ++i;
        }
        buff.rewind();
        return buff;
    }

    public static void putString(ByteBuffer buffer, String s) {
        buffer.put(s.getBytes());
    }

    public static void putString(ByteBuffer buffer, String s, String charset) {
        try {
            buffer.put(s.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void putNullTerminal(ByteBuffer buffer) {
        buffer.put((byte)0);
    }

    public static Pointer asPointer(Buffer buffer) {
        long address = MiscJNI.getBufferAddress(buffer, BufferUtils.getPositionInBytes(buffer));
        return address == 0L ? null : new Pointer(address);
    }
}

