/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.structures;

import jouvieje.bass.structures.BASS_PLUGINFORM;
import jouvieje.bass.structures.StructureJNI;
import jouvieje.bass.utils.Pointer;

public class BASS_PLUGININFO
extends Pointer {
    public static BASS_PLUGININFO asBASS_PLUGININFO(Pointer pointer) {
        long address = Pointer.getPointer(pointer);
        if (address == 0L) {
            return null;
        }
        return new BASS_PLUGININFO(address);
    }

    public static BASS_PLUGININFO allocate() {
        long pointer = StructureJNI.BASS_PLUGININFO_new();
        if (pointer == 0L) {
            throw new OutOfMemoryError();
        }
        return new BASS_PLUGININFO(pointer);
    }

    protected BASS_PLUGININFO(long pointer) {
        super(pointer);
    }

    public BASS_PLUGININFO() {
    }

    public void release() {
        if (this.pointer != 0L) {
            StructureJNI.BASS_PLUGININFO_delete(this.pointer);
        }
        this.pointer = 0L;
    }

    public int getVersion() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        int javaResult = StructureJNI.BASS_PLUGININFO_get_version(this.pointer);
        return javaResult;
    }

    public int getNumFormats() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        int javaResult = StructureJNI.BASS_PLUGININFO_get_formatc(this.pointer);
        return javaResult;
    }

    public BASS_PLUGINFORM getFormat(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > this.getNumFormats()) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + this.getNumFormats() + "[");
        }
        long javaResult = StructureJNI.BASS_PLUGININFO_get_formats_element(this.pointer, elementIndex);
        return javaResult == 0L ? null : BASS_PLUGINFORM.asBASS_PLUGINFORM(Pointer.newPointer(javaResult));
    }

    public BASS_PLUGINFORM[] getFormats() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        long javaResult = StructureJNI.BASS_PLUGININFO_get_formats(this.pointer);
        int formatsLength = this.getNumFormats();
        if (formatsLength <= 0 || javaResult == 0L) {
            return null;
        }
        BASS_PLUGINFORM[] formatsArray = new BASS_PLUGINFORM[formatsLength];
        int SIZEOF_BASS_PLUGINFORM = StructureJNI.BASS_PLUGINFORM_SIZEOF();
        int i = 0;
        while (i < formatsArray.length) {
            formatsArray[i] = new BASS_PLUGINFORM(javaResult + (long)(i * SIZEOF_BASS_PLUGINFORM));
            ++i;
        }
        return formatsArray;
    }
}

