
const coordinate = (x, y) => ({x, y});
const line = (x1, y1, x2, y2) => ({x1, y1, x2, y2});
const coordinatesEqual = (c1, c2) => c1.x === c2.x && c1.y === c2.y;
const linesEqual = (l1, l2) => l1.x1 == l2.x1 && l1.y1 == l2.y1 && l1.x2 == l2.x2 && l1.y2 == l2.y2;

const listContainsCoordinate = (list, c) => {
  var value = list.find(current => coordinatesEqual(current, c));
  if (value === undefined) {
    //console.log("undefined", c)
    return false;
  } else {
    //console.log("value", value)
    return value;
  }
};


const listContainsLine = (list, l) => list.find(current => linesEqual(current, l));

const generateNeighbors = (x, y, cellSize) => {

  let NeighborCells = [
    coordinate(x-cellSize, y),
    coordinate(x, y + cellSize),
    coordinate(x + cellSize, y),
    coordinate(x, y - cellSize)
  ];

  return NeighborCells

}

const resolution = (h, w) => ({h, w});

function detectScreenSize() {
  var availableScreenHeight = screen.availHeight;
  var availableScreenWidth = screen.availWidth;
  var screenResolution = resolution(availableScreenHeight, availableScreenWidth);
  console.log(availableScreenHeight)
  console.log(availableScreenWidth)

  return screenResolution;
}

function shuffle(arra1) {
    var ctr = arra1.length, temp, index;

// While there are elements in the array
    while (ctr > 0) {
// Pick a random index
        index = Math.floor(Math.random() * ctr);
// Decrease ctr by 1
        ctr--;
// And swap the last element with it
        temp = arra1[ctr];
        arra1[ctr] = arra1[index];
        arra1[index] = temp;
    }
    return arra1;
}

function getRandomInt(max) {
  return Math.floor(Math.random() * Math.floor(max));
}

function getRandomCell(CellList) {
  let RandomCell = CellList[getRandomInt(CellList.length-1)];
  return RandomCell
}


export {
  coordinate,
  line,
  coordinatesEqual,
  linesEqual,
  listContainsCoordinate,
  listContainsLine,
  generateNeighbors,
  shuffle,
  detectScreenSize,
  getRandomInt,
  getRandomCell
};
