; blur editor by TomCat/Abaddon
; press 5 and then BackSpace!

; arrows - move cursor
; space - set and reset block
; backspace - restore DATA.BIN
; enter - backup DATA.BIN
; S - save bits BITS4.BIN
; 1-9 - inc and dec color palette treshold
; tab - horiyontal flip

Iteration EQU 45
ResX      EQU 16
ResY      EQU 26
Width     EQU 8
Height    EQU 7
Line      EQU 320
Lines     EQU 200
Topleft   EQU Line*7+16

CUT EQU 105

ORG 256

 MOV    AL,13H
 INT    10H
 SALC
 MOV    DX,03C8H
 OUT    DX,AL
 INC    DX
.1:
 MOV    CX,3*96
.2:
 OUT    DX,AL
 LOOP   .2
; INC    AX
; JNZ    .1
 XOR    AL,255
 JNZ    .1
 SUB    CX,CX
 SUB    BP,BP

 PUSH    07000H
 POP     ES
@@:
 STOSB
 LOOP    @B

DECOMP:
 MOV     SI,L1C6
 MOV     DI,Topleft
 MOV     BL,ResY
L125:
 LODSW
 MOV     CL,ResX
L129:
 SHL     AX,1
 PUSHA
 SALC
 MOV     BL,Height
L133:
 MOV     CL,Width
 REP     STOSB
 ADD     DI,Line-Width
 DEC     BX
 JNZ     L133
 POPA
 ADD     DI,Width
 LOOP    L129
 ADD     DI,Line*Height-ResX*Width
 DEC     BX
 JNZ     L125

BLUR:
 PUSH    07000H
 POP     DS
 PUSH    08000H
 POP     ES
 SUB     SI,SI
 SUB     DI,DI
 MOV     CH,128
 REP     MOVSW
 PUSH    ES
 POP     DS

 MOV     CL,Iteration
.1:
 MOV     CH,Lines
.2:
 MOV     BL,Line/2
.3:
 LODSB
 ADD     AL,[SI+1]
 ADC     AH,BH
 ADD     AL,[SI-Line]
 ADC     AH,BH
 ADD     AL,[SI+Line]
 ADC     AH,BH
 SHR     AX,2
 MOV     [SI],AL
 DEC     BX
 JNZ     .3
 ADD     SI,Line/2
 DEC     CH
 JNZ     .2
 SUB     SI,SI
 SUB     DI,DI
 LOOP    .1

KEYS:
 CALL   COPY
 CALL   CURSOR
 CALL   COPY
 CALL   CURSOR
 MOV    AH,1
 INT    16H
 JZ     KEYS
 MOV    AH,0
 INT    16H
 CMP    AH,10
 JA     KEYS2
 CMP    AH,1                   ; key ESC
 JE     EXIT

 SUB    AH,6
 ADD    [PutPal.C0-1],AH
 CALL   PutPal
 JMP    KEYS

KEYS2:
 CMP    AL,"S"                  ; key S
 JNE    @F
 CALL   CONVERT
 PUSHA                          ; save snapshot
 PUSH   CS
 POP    DS
 MOV    DX,fname2               ; save the data
 SUB    CX,CX
 MOV    AH,3CH
 INT    21H
 XCHG   BX,AX
 MOV    DX,2000H
 MOV    CX,44
 MOV    AH,40H
 INT    21H
 MOV    AH,3EH
 INT    21H
 POPA
@@:
 CMP    AL,9                    ; key TAB
 JNE    @F
 XOR    BYTE [CS:COPY+2],0F0H
 JMP    KEYS
@@:                             ; key Space
 CMP    AL,' '
 JNE    @F
 CALL   CURSOR
 MOV    AX,BP
 MOV    BX,ResX-1
 SUB    BL,AH
 MOV    AH,ResX
 MUL    AH
 ADD    BX,AX
 BTC    [CS:L1C6],BX
 JMP    BLUR
@@:
 CMP    AL,13                   ; key ENTER
 JNE    @F
 PUSHA                          ; save snapshot
 PUSH   CS
 POP    DS
 MOV    DX,fname1               ; save the data
 SUB    CX,CX
 MOV    AH,3CH
 INT    21H
 XCHG   BX,AX
 MOV    DX,L1C6
 MOV    CX,XXX-L1C6
 MOV    AH,40H
 INT    21H
 MOV    AH,3EH
 INT    21H
 POPA
@@:
 CMP    AL,8                    ; key backspace
 JNE    @F
 PUSHA                          ; restore snapshot
 CALL   PutPal
 PUSH   CS
 POP    DS
 MOV    DX,fname1               ; restore data
 MOV    AX,3D00H
 INT    21H
 XCHG   BX,AX
 MOV    DX,L1C6
 MOV    CX,XXX-L1C6
 MOV    AH,3FH
 INT    21H
 MOV    AH,3EH
 INT    21H
 POPA
 PUSH   07000H
 POP    ES
 JMP    DECOMP
@@:

 CMP    AH,75                   ; key left
 JNE    @F
 CMP    BP,256
 JB     @F
 SUB    BP,256
@@:
 CMP    AH,77                   ; key right
 JNE    @F
 CMP    BP,256*(ResX-1)
 JNB    @F
 ADD    BP,256
@@:
 CMP    AH,72                   ; key up
 JNE    @F
 TEST   BP,255
 JZ     @F
 DEC    BP
@@:
 CMP    AH,80                   ; key down
 JNE    @F
 MOV    AX,BP
 CMP    AL,ResY-1
 JE     @F
 INC    BP
@@:
 JMP    KEYS

EXIT:
 MOV     AX,3
 INT     10H
RETN

CURSOR:
 PUSH    07000H
 POP     DS
 MOV     SI,Topleft
 MOV     AX,BP
 CBW
 MOV     DX,Line*Height
 MUL     DX
 ADD     SI,AX
 MOV     AX,BP
 MOV     AL,0
 AAD     Width
 ADD     SI,AX
 MOV     BL,Height
.1:
 MOV     CL,Width
.2:
 NOT     BYTE [SI]
 INC     SI
 LOOP    .2
 ADD     SI,Line-Width
 DEC     BX
 JNZ     .1
RETN

COPY:
 MOV     DX,8000H
 SUB     SI,SI
 PUSH    0A000H
 POP     ES
 SUB     DI,DI
 MOV     BL,Lines
@@:
 MOV     DS,DX
 MOV     CL,Line/2/2
 REP     MOVSW
 SUB     SI,Line/2
 XOR     DH,0F0H
 MOV     DS,DX
 MOV     CL,Line/2/2
 REP     MOVSW
 ADD     SI,Line/2
 XOR     DH,0F0H
 DEC     BX
 JNZ     @B
RETN

CONVERT:
 PUSHA
 PUSH    CS
 POP     DS
 MOV     BP,-26-15
 MOV     CL,16
.1:
 MOV     BL,26
.2:
 MOV     AX,16*256+26
 MOV     AL,BL
 DEC     AX
 MUL     AH
 ADD     AX,CX
 DEC     AX
 BT      [L1C6],AX
 JNC     .3
 BTS     [2000H],BP
 JMP     .4
.3:
 BTR     [2000H],BP
.4:
 INC     BP
 DEC     BX
 JNZ     .2
 LOOP    .1
 POPA
RETN

PutPal:
 PUSH   DS
 PUSH   CS
 POP    DS
.0:
 MOV    CL,188
 SUB    CL,[.C0-1]
 MOV    AX,18*256
 DIV    CL
 MOV    [.R1-1],AL
 MOV    AX,26*256
 DIV    CL
 MOV    [.R2-1],AL
 MOV    AX,30*256
 DIV    CL
 MOV    [.R3-1],AL

 MOV    CL,[.C0-1]
 MOV    AX,45*256
 DIV    CL
 MOV    [.B1-1],AL
 SUB    AL,[.R1-1]
 IMUL   CL
 MOV    [.O1-1],AH

 MOV    AX,26*256
 DIV    CL
 MOV    [.B2-1],AL
 SUB    AL,[.R2-1]
 IMUL   CL
 MOV    [.O2-1],AH

 MOV    AX,20*256
 DIV    CL
 MOV    [.B3-1],AL
 SUB    AL,[.R3-1]
 IMUL   CL
 MOV    [.O3-1],AH

.1:
 IMUL   DX,BX,110
.B1:
 IMUL   CX,BX,63
.B2:
 IMUL   AX,BX,49
.B3:
 CMP    BL,CUT
.C0:
 JB     .2
 IMUL   DX,BX,86
.R1:
 IMUL   CX,BX,71
.R2:
 IMUL   AX,BX,68
.R3:
 ADD    DH,0
.O1:
 ADD    CH,0
.O2:
 ADD    AH,0
.O3:
.2:
 MOV    CL,AH
 MOV    AX,1010H
 INT    10H
 INC    BL
 JNZ    .1

 POP    DS
RETN

fname1:
 DB 'DATA.BIN',0
fname2:
 DB 'BITS4.BIN',0

L1C6:
 DW 0000001111000000B
 DW 0010110111100000B
 DW 0001110110111110B
 DW 0001011101011101B
 DW 0001101011111101B
 DW 0011010110110110B
 DW 0101110101010100B
 DW 0111100101110100B
 DW 0010100111101000B
 DW 0001010011101000B
 DW 0000001000010000B
 DW 0000001111110000B
 DW 0001010010100000B
 DW 0001001101100000B
 DW 0000010101100000B
 DW 0001001101110000B
 DW 0000001010111000B
 DW 0000000101011100B
 DW 0000000100101100B
 DW 0000100010101110B
 DW 0000110000010110B
 DW 0000101000001110B
 DW 0000011110001110B
 DW 0000101100010110B
 DW 0000111000101100B
 DW 0000101001011100B
XXX:
