extends Control

signal host_game
signal start_game
signal quit_game
signal connect
signal cancel
signal build_tower

# class member variables go here, for example:
# var a = 2
# var b = "textvar"

func _ready():
	state_main_menu()
	print("Menu ready")

#func _process(delta):
#	# Called every frame. Delta is time since last frame.
#	# Update game logic here.
#	pass

func state_main_menu():
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/NicknameContainer.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer/MainMenu.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer/BackButton.visible = false
	$GameStats.visible = false

func state_host_game():
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/NicknameContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer/MainMenu.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer/BackButton.visible = true
	$GameStats.visible = false

func state_connect():
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/NicknameContainer.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer/MainMenu.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer/BackButton.visible = true
	$GameStats.visible = false

func state_connected():
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer.visible = true
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer/StartGame.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/NicknameContainer.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer/MainMenu.visible = false
	$MarginContainer/VBoxContainer2/HBoxContainer/BackButton.visible = true
	$GameStats.visible = false


func get_nickname():
	var nick = $MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/NicknameContainer/NicknameInput.text
	if len(nick) == 0:
		return "Unnamed noob"
	return nick

func get_server_ip():
	return $MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer/HostIPInput.text	

func set_lobby(my_info, players):
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer/ConnectedClients.clear()
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer/ConnectedClients.add_item(my_info.nickname + ": Builder")
	for player_id in players:
		$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer/ConnectedClients.add_item(players[player_id].nickname + ": Operator")
	
	$MarginContainer/VBoxContainer2/HBoxContainer2/LobbyContainer/ConnectedClients.update()


func _on_StartSolo_pressed():
	print("Starting solo game")
	emit_signal("start_game")


func _on_Host_pressed():
	print("Acting host")
	state_host_game()
	emit_signal("host_game")


func _on_Connect_pressed():
	print("Acting client")
	state_connect()


func _on_BackButton_pressed():
	print("Backing out")
	state_main_menu()
	emit_signal("cancel")


func _on_Quit_pressed():
	print("Quitting game")
	emit_signal("quit_game")


func _on_ConnectToIP_pressed():
	var ip = get_server_ip()
	if len(ip) > 0:
		emit_signal("connect")
	else:
		$MarginContainer/VBoxContainer2/HBoxContainer2/ClientContainer/ConnectContainer/HostIPInput.self_modulate = Color(1, 0.7, 0.7, 1)



func _on_StartGame_pressed():
	emit_signal("start_game")


func _on_BuildTower_pressed():
	emit_signal("build_tower")
