import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

Minim minim;
AudioPlayer song;
/*
"Disco con Tutti" Kevin MacLeod (incompetech.com)
Licensed under Creative Commons: By Attribution 3.0 License
http://creativecommons.org/licenses/by/3.0/
*/

PImage img;
PShader texShader;

void setup() {
  size(1024, 800, P3D);  
  img = loadImage("gnu.jpg");
  texShader = loadShader("texfrag.glsl", "texvert.glsl");
  texShader.set("u_resolution", float(width), float(height));
  
  minim = new Minim(this);
  song = minim.loadFile("disco.mp3");
  song.play();
}

void draw() {
  background(0);
  texShader.set("u_time", millis() / 1000.0);
  shader(texShader);
  image(img, width/2 - 437/2, height/2 - 797/2, 437, 797);
}
