/*
 * Example of how to use Shadertoy
 * shaders in Processing.
 * taken from here: https://github.com/anttihirvonen/demoscene-starter-kits
 */
 
// Syncing with Rocket
import moonlander.library.*;

import ddf.minim.*;

// These control how big the opened window is.
// Before you release your demo, set these to 
// full HD resolution (1920x1080).
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

Moonlander moonlander;
PImage boat;
PImage bg;
PImage jml;

PShader shader,shaderTex;
PFont font;
void settings() {
  // Set up the drawing area size and renderer (P2D / P3D).
  size((int)CANVAS_WIDTH,(int)CANVAS_HEIGHT, P3D);
  fullScreen();
}

void setup() {
  frameRate(60);

  shader = loadShader("plasma.fs","plasma.vs");
  shaderTex = loadShader("shaderTex.fs","plasma.vs");
  shader.set("iResolution", (float)CANVAS_WIDTH, (float)CANVAS_HEIGHT);

  font = createFont("Comic Sans MS",50,true);
  textFont(font);
  jml = loadImage("jml.png");

  // Init & start moonlander
  moonlander = Moonlander.initWithSoundtrack(this, "EDM_Detection_Mode_Snip.mp3", 128, 8);
  moonlander.start();
}

void draw() {
  moonlander.update();
  scale(width/CANVAS_WIDTH, height/CANVAS_HEIGHT);
  
  background((float)moonlander.getValue("bg"));
    
  pushMatrix();
  shader(shaderTex);
  scale(0.5,0.5);
  fill(color(255,255,255,0));
  image(jml, width/2-jml.width/2, height/2-jml.height/2);
  fill(color(255));
  popMatrix();

  

  double now = moonlander.getCurrentTime();
  double end = 33;
  if (now > end) {
    exit();
  }
  
  int tilesX = 10;
  int tilesY = 5;
  for (int y = 0; y < tilesY; y++) {
    for (int x = 0; x < tilesX; x++) {
      float th = CANVAS_HEIGHT/tilesX*16/9.;
      float tw = CANVAS_WIDTH/tilesX;
      
      String tRocketName = "t_x" + x + "_y" + y;
      if (moonlander.getValue(tRocketName + "_v") > 0) {
        shader(shader);
        // Update current time to shader
        // (and any custom uniforms)
        shader.set("iGlobalTime", (float)moonlander.getCurrentTime());
        shader.set("grid_rotation", (float)moonlander.getValue("grid_rotate"));
        shader.set("grid_resolution", (float)moonlander.getValue("grid_resolution"));
        shader.set("grid_distort", (float)moonlander.getValue("grid_distort"));
        shader.set("use_plasma", (int)moonlander.getValue(tRocketName + "_plasma"));
        pushMatrix();
        translate(x*tw+tw/2+(float)moonlander.getValue(tRocketName + "_x"), y*th+th/3+th/2+(float)moonlander.getValue(tRocketName + "_y"));
        
        rotateZ(radians((float)moonlander.getValue("tileRotZ") + (float)moonlander.getValue(tRocketName + "_rz")));
        rect(-tw/2, -th/2, tw, th);
        popMatrix();
      }
      
    }
  }

  /*
  background(255);
  pushMatrix();
  scale(0.5,0.5);
  image(bg, 0, 0);
  popMatrix();

  pushMatrix();
  scale(0.3,0.3);
  translate(-100,-50);
  rotate(PI / 3 * (sin((float)now*0.8)));
  translate(100,50);
  image(boat, 0, 0);
  popMatrix();
  fill(0,0,0);
  text("Jumalauta 18 years demoparty in sunny and hopefully less hot Hauho",width/2,height/2);*/
}
