

(function universalModuleDefinition(root, factory) {
    var amdDependencies = [];
    var CANNON = root.CANNON || this.CANNON;
    var OIMO = root.OIMO || this.OIMO;
    var earcut = root.earcut || this.earcut;
    if(typeof exports === 'object' && typeof module === 'object') {
         try {  CANNON = CANNON || require("cannon");  } catch(e) {} 
         try {  OIMO = OIMO || require("oimo");  } catch(e) {} 
         try {  earcut = earcut || require("earcut");  } catch(e) {} 

        module.exports = factory(CANNON,OIMO,earcut);
    } else if(typeof define === 'function' && define.amd) {
         if(require.specified && require.specified("cannon")) amdDependencies.push("cannon");
         if(require.specified && require.specified("oimo")) amdDependencies.push("oimo");
         if(require.specified && require.specified("earcut")) amdDependencies.push("earcut");

        define("babylonjs", amdDependencies, factory);
    } else if(typeof exports === 'object') {
         try {  CANNON = CANNON || require("cannon");  } catch(e) {} 
         try {  OIMO = OIMO || require("oimo");  } catch(e) {} 
         try {  earcut = earcut || require("earcut");  } catch(e) {} 

        exports["babylonjs"] = factory(CANNON,OIMO,earcut);
    } else {
        root["BABYLON"] = factory(CANNON,OIMO,earcut);
    }
})(this, function(CANNON,OIMO,earcut) {
  CANNON = CANNON || this.CANNON;
  OIMO = OIMO || this.OIMO;
  earcut = earcut || this.earcut;

var __decorate=this&&this.__decorate||function(e,t,r,c){var o,f=arguments.length,n=f<3?t:null===c?c=Object.getOwnPropertyDescriptor(t,r):c;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)n=Reflect.decorate(e,t,r,c);else for(var l=e.length-1;l>=0;l--)(o=e[l])&&(n=(f<3?o(n):f>3?o(t,r,n):o(t,r))||n);return f>3&&n&&Object.defineProperty(t,r,n),n};
var __extends=this&&this.__extends||function(){var t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var n in o)o.hasOwnProperty(n)&&(t[n]=o[n])};return function(o,n){function r(){this.constructor=o}t(o,n),o.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();
var BABYLON;
(function (BABYLON) {
    /**
     * EffectFallbacks can be used to add fallbacks (properties to disable) to certain properties when desired to improve performance.
     * (Eg. Start at high quality with reflection and fog, if fps is low, remove reflection, if still low remove fog)
     */
    var EffectFallbacks = /** @class */ (function () {
        function EffectFallbacks() {
            this._defines = {};
            this._currentRank = 32;
            this._maxRank = -1;
        }
        /**
         * Removes the fallback from the bound mesh.
         */
        EffectFallbacks.prototype.unBindMesh = function () {
            this._mesh = null;
        };
        /**
         * Adds a fallback on the specified property.
         * @param rank The rank of the fallback (Lower ranks will be fallbacked to first)
         * @param define The name of the define in the shader
         */
        EffectFallbacks.prototype.addFallback = function (rank, define) {
            if (!this._defines[rank]) {
                if (rank < this._currentRank) {
                    this._currentRank = rank;
                }
                if (rank > this._maxRank) {
                    this._maxRank = rank;
                }
                this._defines[rank] = new Array();
            }
            this._defines[rank].push(define);
        };
        /**
         * Sets the mesh to use CPU skinning when needing to fallback.
         * @param rank The rank of the fallback (Lower ranks will be fallbacked to first)
         * @param mesh The mesh to use the fallbacks.
         */
        EffectFallbacks.prototype.addCPUSkinningFallback = function (rank, mesh) {
            this._mesh = mesh;
            if (rank < this._currentRank) {
                this._currentRank = rank;
            }
            if (rank > this._maxRank) {
                this._maxRank = rank;
            }
        };
        Object.defineProperty(EffectFallbacks.prototype, "isMoreFallbacks", {
            /**
             * Checks to see if more fallbacks are still availible.
             */
            get: function () {
                return this._currentRank <= this._maxRank;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Removes the defines that shoould be removed when falling back.
         * @param currentDefines defines the current define statements for the shader.
         * @param effect defines the current effect we try to compile
         * @returns The resulting defines with defines of the current rank removed.
         */
        EffectFallbacks.prototype.reduce = function (currentDefines, effect) {
            // First we try to switch to CPU skinning
            if (this._mesh && this._mesh.computeBonesUsingShaders && this._mesh.numBoneInfluencers > 0 && this._mesh.material) {
                this._mesh.computeBonesUsingShaders = false;
                currentDefines = currentDefines.replace("#define NUM_BONE_INFLUENCERS " + this._mesh.numBoneInfluencers, "#define NUM_BONE_INFLUENCERS 0");
                effect._bonesComputationForcedToCPU = true;
                var scene = this._mesh.getScene();
                for (var index = 0; index < scene.meshes.length; index++) {
                    var otherMesh = scene.meshes[index];
                    if (!otherMesh.material) {
                        continue;
                    }
                    if (!otherMesh.computeBonesUsingShaders || otherMesh.numBoneInfluencers === 0) {
                        continue;
                    }
                    if (otherMesh.material.getEffect() === effect) {
                        otherMesh.computeBonesUsingShaders = false;
                    }
                    else if (otherMesh.subMeshes) {
                        for (var _i = 0, _a = otherMesh.subMeshes; _i < _a.length; _i++) {
                            var subMesh = _a[_i];
                            var subMeshEffect = subMesh.effect;
                            if (subMeshEffect === effect) {
                                otherMesh.computeBonesUsingShaders = false;
                                break;
                            }
                        }
                    }
                }
            }
            else {
                var currentFallbacks = this._defines[this._currentRank];
                if (currentFallbacks) {
                    for (var index = 0; index < currentFallbacks.length; index++) {
                        currentDefines = currentDefines.replace("#define " + currentFallbacks[index], "");
                    }
                }
                this._currentRank++;
            }
            return currentDefines;
        };
        return EffectFallbacks;
    }());
    BABYLON.EffectFallbacks = EffectFallbacks;
    /**
     * Options to be used when creating an effect.
     */
    var EffectCreationOptions = /** @class */ (function () {
        function EffectCreationOptions() {
        }
        return EffectCreationOptions;
    }());
    BABYLON.EffectCreationOptions = EffectCreationOptions;
    /**
     * Effect containing vertex and fragment shader that can be executed on an object.
     */
    var Effect = /** @class */ (function () {
        /**
         * Instantiates an effect.
         * An effect can be used to create/manage/execute vertex and fragment shaders.
         * @param baseName Name of the effect.
         * @param attributesNamesOrOptions List of attribute names that will be passed to the shader or set of all options to create the effect.
         * @param uniformsNamesOrEngine List of uniform variable names that will be passed to the shader or the engine that will be used to render effect.
         * @param samplers List of sampler variables that will be passed to the shader.
         * @param engine Engine to be used to render the effect
         * @param defines Define statements to be added to the shader.
         * @param fallbacks Possible fallbacks for this effect to improve performance when needed.
         * @param onCompiled Callback that will be called when the shader is compiled.
         * @param onError Callback that will be called if an error occurs during shader compilation.
         * @param indexParameters Parameters to be used with Babylons include syntax to iterate over an array (eg. {lights: 10})
         */
        function Effect(baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers, engine, defines, fallbacks, onCompiled, onError, indexParameters) {
            if (samplers === void 0) { samplers = null; }
            if (defines === void 0) { defines = null; }
            if (fallbacks === void 0) { fallbacks = null; }
            if (onCompiled === void 0) { onCompiled = null; }
            if (onError === void 0) { onError = null; }
            var _this = this;
            /**
             * Unique ID of the effect.
             */
            this.uniqueId = 0;
            /**
             * Observable that will be called when the shader is compiled.
             */
            this.onCompileObservable = new BABYLON.Observable();
            /**
             * Observable that will be called if an error occurs during shader compilation.
             */
            this.onErrorObservable = new BABYLON.Observable();
            /**
             * Observable that will be called when effect is bound.
             */
            this.onBindObservable = new BABYLON.Observable();
            /** @hidden */
            this._bonesComputationForcedToCPU = false;
            this._uniformBuffersNames = {};
            this._isReady = false;
            this._compilationError = "";
            this.name = baseName;
            if (attributesNamesOrOptions.attributes) {
                var options = attributesNamesOrOptions;
                this._engine = uniformsNamesOrEngine;
                this._attributesNames = options.attributes;
                this._uniformsNames = options.uniformsNames.concat(options.samplers);
                this._samplers = options.samplers.slice();
                this.defines = options.defines;
                this.onError = options.onError;
                this.onCompiled = options.onCompiled;
                this._fallbacks = options.fallbacks;
                this._indexParameters = options.indexParameters;
                this._transformFeedbackVaryings = options.transformFeedbackVaryings;
                if (options.uniformBuffersNames) {
                    for (var i = 0; i < options.uniformBuffersNames.length; i++) {
                        this._uniformBuffersNames[options.uniformBuffersNames[i]] = i;
                    }
                }
            }
            else {
                this._engine = engine;
                this.defines = defines;
                this._uniformsNames = uniformsNamesOrEngine.concat(samplers);
                this._samplers = samplers ? samplers.slice() : [];
                this._attributesNames = attributesNamesOrOptions;
                this.onError = onError;
                this.onCompiled = onCompiled;
                this._indexParameters = indexParameters;
                this._fallbacks = fallbacks;
            }
            this.uniqueId = Effect._uniqueIdSeed++;
            var vertexSource;
            var fragmentSource;
            if (baseName.vertexElement) {
                vertexSource = document.getElementById(baseName.vertexElement);
                if (!vertexSource) {
                    vertexSource = baseName.vertexElement;
                }
            }
            else {
                vertexSource = baseName.vertex || baseName;
            }
            if (baseName.fragmentElement) {
                fragmentSource = document.getElementById(baseName.fragmentElement);
                if (!fragmentSource) {
                    fragmentSource = baseName.fragmentElement;
                }
            }
            else {
                fragmentSource = baseName.fragment || baseName;
            }
            this._loadVertexShader(vertexSource, function (vertexCode) {
                _this._processIncludes(vertexCode, function (vertexCodeWithIncludes) {
                    _this._processShaderConversion(vertexCodeWithIncludes, false, function (migratedVertexCode) {
                        _this._loadFragmentShader(fragmentSource, function (fragmentCode) {
                            _this._processIncludes(fragmentCode, function (fragmentCodeWithIncludes) {
                                _this._processShaderConversion(fragmentCodeWithIncludes, true, function (migratedFragmentCode) {
                                    if (baseName) {
                                        var vertex = baseName.vertexElement || baseName.vertex || baseName;
                                        var fragment = baseName.fragmentElement || baseName.fragment || baseName;
                                        _this._vertexSourceCode = "#define SHADER_NAME vertex:" + vertex + "\n" + migratedVertexCode;
                                        _this._fragmentSourceCode = "#define SHADER_NAME fragment:" + fragment + "\n" + migratedFragmentCode;
                                    }
                                    else {
                                        _this._vertexSourceCode = migratedVertexCode;
                                        _this._fragmentSourceCode = migratedFragmentCode;
                                    }
                                    _this._prepareEffect();
                                });
                            });
                        });
                    });
                });
            });
        }
        Object.defineProperty(Effect.prototype, "key", {
            /**
             * Unique key for this effect
             */
            get: function () {
                return this._key;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * If the effect has been compiled and prepared.
         * @returns if the effect is compiled and prepared.
         */
        Effect.prototype.isReady = function () {
            return this._isReady;
        };
        /**
         * The engine the effect was initialized with.
         * @returns the engine.
         */
        Effect.prototype.getEngine = function () {
            return this._engine;
        };
        /**
         * The compiled webGL program for the effect
         * @returns the webGL program.
         */
        Effect.prototype.getProgram = function () {
            return this._program;
        };
        /**
         * The set of names of attribute variables for the shader.
         * @returns An array of attribute names.
         */
        Effect.prototype.getAttributesNames = function () {
            return this._attributesNames;
        };
        /**
         * Returns the attribute at the given index.
         * @param index The index of the attribute.
         * @returns The location of the attribute.
         */
        Effect.prototype.getAttributeLocation = function (index) {
            return this._attributes[index];
        };
        /**
         * Returns the attribute based on the name of the variable.
         * @param name of the attribute to look up.
         * @returns the attribute location.
         */
        Effect.prototype.getAttributeLocationByName = function (name) {
            var index = this._attributesNames.indexOf(name);
            return this._attributes[index];
        };
        /**
         * The number of attributes.
         * @returns the numnber of attributes.
         */
        Effect.prototype.getAttributesCount = function () {
            return this._attributes.length;
        };
        /**
         * Gets the index of a uniform variable.
         * @param uniformName of the uniform to look up.
         * @returns the index.
         */
        Effect.prototype.getUniformIndex = function (uniformName) {
            return this._uniformsNames.indexOf(uniformName);
        };
        /**
         * Returns the attribute based on the name of the variable.
         * @param uniformName of the uniform to look up.
         * @returns the location of the uniform.
         */
        Effect.prototype.getUniform = function (uniformName) {
            return this._uniforms[this._uniformsNames.indexOf(uniformName)];
        };
        /**
         * Returns an array of sampler variable names
         * @returns The array of sampler variable neames.
         */
        Effect.prototype.getSamplers = function () {
            return this._samplers;
        };
        /**
         * The error from the last compilation.
         * @returns the error string.
         */
        Effect.prototype.getCompilationError = function () {
            return this._compilationError;
        };
        /**
         * Adds a callback to the onCompiled observable and call the callback imediatly if already ready.
         * @param func The callback to be used.
         */
        Effect.prototype.executeWhenCompiled = function (func) {
            if (this.isReady()) {
                func(this);
                return;
            }
            this.onCompileObservable.add(function (effect) {
                func(effect);
            });
        };
        /** @hidden */
        Effect.prototype._loadVertexShader = function (vertex, callback) {
            if (BABYLON.Tools.IsWindowObjectExist()) {
                // DOM element ?
                if (vertex instanceof HTMLElement) {
                    var vertexCode = BABYLON.Tools.GetDOMTextContent(vertex);
                    callback(vertexCode);
                    return;
                }
            }
            // Base64 encoded ?
            if (vertex.substr(0, 7) === "base64:") {
                var vertexBinary = window.atob(vertex.substr(7));
                callback(vertexBinary);
                return;
            }
            // Is in local store ?
            if (Effect.ShadersStore[vertex + "VertexShader"]) {
                callback(Effect.ShadersStore[vertex + "VertexShader"]);
                return;
            }
            var vertexShaderUrl;
            if (vertex[0] === "." || vertex[0] === "/" || vertex.indexOf("http") > -1) {
                vertexShaderUrl = vertex;
            }
            else {
                vertexShaderUrl = BABYLON.Engine.ShadersRepository + vertex;
            }
            // Vertex shader
            this._engine._loadFile(vertexShaderUrl + ".vertex.fx", callback);
        };
        /** @hidden */
        Effect.prototype._loadFragmentShader = function (fragment, callback) {
            if (BABYLON.Tools.IsWindowObjectExist()) {
                // DOM element ?
                if (fragment instanceof HTMLElement) {
                    var fragmentCode = BABYLON.Tools.GetDOMTextContent(fragment);
                    callback(fragmentCode);
                    return;
                }
            }
            // Base64 encoded ?
            if (fragment.substr(0, 7) === "base64:") {
                var fragmentBinary = window.atob(fragment.substr(7));
                callback(fragmentBinary);
                return;
            }
            // Is in local store ?
            if (Effect.ShadersStore[fragment + "PixelShader"]) {
                callback(Effect.ShadersStore[fragment + "PixelShader"]);
                return;
            }
            if (Effect.ShadersStore[fragment + "FragmentShader"]) {
                callback(Effect.ShadersStore[fragment + "FragmentShader"]);
                return;
            }
            var fragmentShaderUrl;
            if (fragment[0] === "." || fragment[0] === "/" || fragment.indexOf("http") > -1) {
                fragmentShaderUrl = fragment;
            }
            else {
                fragmentShaderUrl = BABYLON.Engine.ShadersRepository + fragment;
            }
            // Fragment shader
            this._engine._loadFile(fragmentShaderUrl + ".fragment.fx", callback);
        };
        Effect.prototype._dumpShadersSource = function (vertexCode, fragmentCode, defines) {
            // Rebuild shaders source code
            var shaderVersion = (this._engine.webGLVersion > 1) ? "#version 300 es\n#define WEBGL2 \n" : "";
            var prefix = shaderVersion + (defines ? defines + "\n" : "");
            vertexCode = prefix + vertexCode;
            fragmentCode = prefix + fragmentCode;
            // Number lines of shaders source code
            var i = 2;
            var regex = /\n/gm;
            var formattedVertexCode = "\n1\t" + vertexCode.replace(regex, function () { return "\n" + (i++) + "\t"; });
            i = 2;
            var formattedFragmentCode = "\n1\t" + fragmentCode.replace(regex, function () { return "\n" + (i++) + "\t"; });
            // Dump shaders name and formatted source code
            if (this.name.vertexElement) {
                BABYLON.Tools.Error("Vertex shader: " + this.name.vertexElement + formattedVertexCode);
                BABYLON.Tools.Error("Fragment shader: " + this.name.fragmentElement + formattedFragmentCode);
            }
            else if (this.name.vertex) {
                BABYLON.Tools.Error("Vertex shader: " + this.name.vertex + formattedVertexCode);
                BABYLON.Tools.Error("Fragment shader: " + this.name.fragment + formattedFragmentCode);
            }
            else {
                BABYLON.Tools.Error("Vertex shader: " + this.name + formattedVertexCode);
                BABYLON.Tools.Error("Fragment shader: " + this.name + formattedFragmentCode);
            }
        };
        ;
        Effect.prototype._processShaderConversion = function (sourceCode, isFragment, callback) {
            var preparedSourceCode = this._processPrecision(sourceCode);
            if (this._engine.webGLVersion == 1) {
                callback(preparedSourceCode);
                return;
            }
            // Already converted
            if (preparedSourceCode.indexOf("#version 3") !== -1) {
                callback(preparedSourceCode.replace("#version 300 es", ""));
                return;
            }
            var hasDrawBuffersExtension = preparedSourceCode.search(/#extension.+GL_EXT_draw_buffers.+require/) !== -1;
            // Remove extensions 
            // #extension GL_OES_standard_derivatives : enable
            // #extension GL_EXT_shader_texture_lod : enable
            // #extension GL_EXT_frag_depth : enable
            // #extension GL_EXT_draw_buffers : require
            var regex = /#extension.+(GL_OES_standard_derivatives|GL_EXT_shader_texture_lod|GL_EXT_frag_depth|GL_EXT_draw_buffers).+(enable|require)/g;
            var result = preparedSourceCode.replace(regex, "");
            // Migrate to GLSL v300
            result = result.replace(/varying(?![\n\r])\s/g, isFragment ? "in " : "out ");
            result = result.replace(/attribute[ \t]/g, "in ");
            result = result.replace(/[ \t]attribute/g, " in");
            if (isFragment) {
                result = result.replace(/texture2DLodEXT\s*\(/g, "textureLod(");
                result = result.replace(/textureCubeLodEXT\s*\(/g, "textureLod(");
                result = result.replace(/texture2D\s*\(/g, "texture(");
                result = result.replace(/textureCube\s*\(/g, "texture(");
                result = result.replace(/gl_FragDepthEXT/g, "gl_FragDepth");
                result = result.replace(/gl_FragColor/g, "glFragColor");
                result = result.replace(/gl_FragData/g, "glFragData");
                result = result.replace(/void\s+?main\s*\(/g, (hasDrawBuffersExtension ? "" : "out vec4 glFragColor;\n") + "void main(");
            }
            callback(result);
        };
        Effect.prototype._processIncludes = function (sourceCode, callback) {
            var _this = this;
            var regex = /#include<(.+)>(\((.*)\))*(\[(.*)\])*/g;
            var match = regex.exec(sourceCode);
            var returnValue = new String(sourceCode);
            while (match != null) {
                var includeFile = match[1];
                // Uniform declaration
                if (includeFile.indexOf("__decl__") !== -1) {
                    includeFile = includeFile.replace(/__decl__/, "");
                    if (this._engine.supportsUniformBuffers) {
                        includeFile = includeFile.replace(/Vertex/, "Ubo");
                        includeFile = includeFile.replace(/Fragment/, "Ubo");
                    }
                    includeFile = includeFile + "Declaration";
                }
                if (Effect.IncludesShadersStore[includeFile]) {
                    // Substitution
                    var includeContent = Effect.IncludesShadersStore[includeFile];
                    if (match[2]) {
                        var splits = match[3].split(",");
                        for (var index = 0; index < splits.length; index += 2) {
                            var source = new RegExp(splits[index], "g");
                            var dest = splits[index + 1];
                            includeContent = includeContent.replace(source, dest);
                        }
                    }
                    if (match[4]) {
                        var indexString = match[5];
                        if (indexString.indexOf("..") !== -1) {
                            var indexSplits = indexString.split("..");
                            var minIndex = parseInt(indexSplits[0]);
                            var maxIndex = parseInt(indexSplits[1]);
                            var sourceIncludeContent = includeContent.slice(0);
                            includeContent = "";
                            if (isNaN(maxIndex)) {
                                maxIndex = this._indexParameters[indexSplits[1]];
                            }
                            for (var i = minIndex; i < maxIndex; i++) {
                                if (!this._engine.supportsUniformBuffers) {
                                    // Ubo replacement
                                    sourceIncludeContent = sourceIncludeContent.replace(/light\{X\}.(\w*)/g, function (str, p1) {
                                        return p1 + "{X}";
                                    });
                                }
                                includeContent += sourceIncludeContent.replace(/\{X\}/g, i.toString()) + "\n";
                            }
                        }
                        else {
                            if (!this._engine.supportsUniformBuffers) {
                                // Ubo replacement
                                includeContent = includeContent.replace(/light\{X\}.(\w*)/g, function (str, p1) {
                                    return p1 + "{X}";
                                });
                            }
                            includeContent = includeContent.replace(/\{X\}/g, indexString);
                        }
                    }
                    // Replace
                    returnValue = returnValue.replace(match[0], includeContent);
                }
                else {
                    var includeShaderUrl = BABYLON.Engine.ShadersRepository + "ShadersInclude/" + includeFile + ".fx";
                    this._engine._loadFile(includeShaderUrl, function (fileContent) {
                        Effect.IncludesShadersStore[includeFile] = fileContent;
                        _this._processIncludes(returnValue, callback);
                    });
                    return;
                }
                match = regex.exec(sourceCode);
            }
            callback(returnValue);
        };
        Effect.prototype._processPrecision = function (source) {
            if (source.indexOf("precision highp float") === -1) {
                if (!this._engine.getCaps().highPrecisionShaderSupported) {
                    source = "precision mediump float;\n" + source;
                }
                else {
                    source = "precision highp float;\n" + source;
                }
            }
            else {
                if (!this._engine.getCaps().highPrecisionShaderSupported) { // Moving highp to mediump
                    source = source.replace("precision highp float", "precision mediump float");
                }
            }
            return source;
        };
        /**
         * Recompiles the webGL program
         * @param vertexSourceCode The source code for the vertex shader.
         * @param fragmentSourceCode The source code for the fragment shader.
         * @param onCompiled Callback called when completed.
         * @param onError Callback called on error.
         */
        Effect.prototype._rebuildProgram = function (vertexSourceCode, fragmentSourceCode, onCompiled, onError) {
            var _this = this;
            this._isReady = false;
            this._vertexSourceCodeOverride = vertexSourceCode;
            this._fragmentSourceCodeOverride = fragmentSourceCode;
            this.onError = function (effect, error) {
                if (onError) {
                    onError(error);
                }
            };
            this.onCompiled = function () {
                var scenes = _this.getEngine().scenes;
                for (var i = 0; i < scenes.length; i++) {
                    scenes[i].markAllMaterialsAsDirty(BABYLON.Material.TextureDirtyFlag);
                }
                if (onCompiled) {
                    onCompiled(_this._program);
                }
            };
            this._fallbacks = null;
            this._prepareEffect();
        };
        /**
         * Gets the uniform locations of the the specified variable names
         * @param names THe names of the variables to lookup.
         * @returns Array of locations in the same order as variable names.
         */
        Effect.prototype.getSpecificUniformLocations = function (names) {
            var engine = this._engine;
            return engine.getUniforms(this._program, names);
        };
        /**
         * Prepares the effect
         */
        Effect.prototype._prepareEffect = function () {
            var attributesNames = this._attributesNames;
            var defines = this.defines;
            var fallbacks = this._fallbacks;
            this._valueCache = {};
            var previousProgram = this._program;
            try {
                var engine = this._engine;
                if (this._vertexSourceCodeOverride && this._fragmentSourceCodeOverride) {
                    this._program = engine.createRawShaderProgram(this._vertexSourceCodeOverride, this._fragmentSourceCodeOverride, undefined, this._transformFeedbackVaryings);
                }
                else {
                    this._program = engine.createShaderProgram(this._vertexSourceCode, this._fragmentSourceCode, defines, undefined, this._transformFeedbackVaryings);
                }
                this._program.__SPECTOR_rebuildProgram = this._rebuildProgram.bind(this);
                if (engine.supportsUniformBuffers) {
                    for (var name in this._uniformBuffersNames) {
                        this.bindUniformBlock(name, this._uniformBuffersNames[name]);
                    }
                }
                this._uniforms = engine.getUniforms(this._program, this._uniformsNames);
                this._attributes = engine.getAttributes(this._program, attributesNames);
                var index;
                for (index = 0; index < this._samplers.length; index++) {
                    var sampler = this.getUniform(this._samplers[index]);
                    if (sampler == null) {
                        this._samplers.splice(index, 1);
                        index--;
                    }
                }
                engine.bindSamplers(this);
                this._compilationError = "";
                this._isReady = true;
                if (this.onCompiled) {
                    this.onCompiled(this);
                }
                this.onCompileObservable.notifyObservers(this);
                this.onCompileObservable.clear();
                // Unbind mesh reference in fallbacks
                if (this._fallbacks) {
                    this._fallbacks.unBindMesh();
                }
                if (previousProgram) {
                    this.getEngine()._deleteProgram(previousProgram);
                }
            }
            catch (e) {
                this._compilationError = e.message;
                // Let's go through fallbacks then
                BABYLON.Tools.Error("Unable to compile effect:");
                BABYLON.Tools.Error("Uniforms: " + this._uniformsNames.map(function (uniform) {
                    return " " + uniform;
                }));
                BABYLON.Tools.Error("Attributes: " + attributesNames.map(function (attribute) {
                    return " " + attribute;
                }));
                this._dumpShadersSource(this._vertexSourceCode, this._fragmentSourceCode, defines);
                BABYLON.Tools.Error("Error: " + this._compilationError);
                if (previousProgram) {
                    this._program = previousProgram;
                    this._isReady = true;
                    if (this.onError) {
                        this.onError(this, this._compilationError);
                    }
                    this.onErrorObservable.notifyObservers(this);
                }
                if (fallbacks && fallbacks.isMoreFallbacks) {
                    BABYLON.Tools.Error("Trying next fallback.");
                    this.defines = fallbacks.reduce(this.defines, this);
                    this._prepareEffect();
                }
                else { // Sorry we did everything we can
                    if (this.onError) {
                        this.onError(this, this._compilationError);
                    }
                    this.onErrorObservable.notifyObservers(this);
                    this.onErrorObservable.clear();
                    // Unbind mesh reference in fallbacks
                    if (this._fallbacks) {
                        this._fallbacks.unBindMesh();
                    }
                }
            }
        };
        Object.defineProperty(Effect.prototype, "isSupported", {
            /**
             * Checks if the effect is supported. (Must be called after compilation)
             */
            get: function () {
                return this._compilationError === "";
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Binds a texture to the engine to be used as output of the shader.
         * @param channel Name of the output variable.
         * @param texture Texture to bind.
         */
        Effect.prototype._bindTexture = function (channel, texture) {
            this._engine._bindTexture(this._samplers.indexOf(channel), texture);
        };
        /**
         * Sets a texture on the engine to be used in the shader.
         * @param channel Name of the sampler variable.
         * @param texture Texture to set.
         */
        Effect.prototype.setTexture = function (channel, texture) {
            this._engine.setTexture(this._samplers.indexOf(channel), this.getUniform(channel), texture);
        };
        /**
         * Sets a depth stencil texture from a render target on the engine to be used in the shader.
         * @param channel Name of the sampler variable.
         * @param texture Texture to set.
         */
        Effect.prototype.setDepthStencilTexture = function (channel, texture) {
            this._engine.setDepthStencilTexture(this._samplers.indexOf(channel), this.getUniform(channel), texture);
        };
        /**
         * Sets an array of textures on the engine to be used in the shader.
         * @param channel Name of the variable.
         * @param textures Textures to set.
         */
        Effect.prototype.setTextureArray = function (channel, textures) {
            if (this._samplers.indexOf(channel + "Ex") === -1) {
                var initialPos = this._samplers.indexOf(channel);
                for (var index = 1; index < textures.length; index++) {
                    this._samplers.splice(initialPos + index, 0, channel + "Ex");
                }
            }
            this._engine.setTextureArray(this._samplers.indexOf(channel), this.getUniform(channel), textures);
        };
        /**
         * Sets a texture to be the input of the specified post process. (To use the output, pass in the next post process in the pipeline)
         * @param channel Name of the sampler variable.
         * @param postProcess Post process to get the input texture from.
         */
        Effect.prototype.setTextureFromPostProcess = function (channel, postProcess) {
            this._engine.setTextureFromPostProcess(this._samplers.indexOf(channel), postProcess);
        };
        /**
         * (Warning! setTextureFromPostProcessOutput may be desired instead)
         * Sets the input texture of the passed in post process to be input of this effect. (To use the output of the passed in post process use setTextureFromPostProcessOutput)
         * @param channel Name of the sampler variable.
         * @param postProcess Post process to get the output texture from.
         */
        Effect.prototype.setTextureFromPostProcessOutput = function (channel, postProcess) {
            this._engine.setTextureFromPostProcessOutput(this._samplers.indexOf(channel), postProcess);
        };
        /** @hidden */
        Effect.prototype._cacheMatrix = function (uniformName, matrix) {
            var cache = this._valueCache[uniformName];
            var flag = matrix.updateFlag;
            if (cache !== undefined && cache === flag) {
                return false;
            }
            this._valueCache[uniformName] = flag;
            return true;
        };
        /** @hidden */
        Effect.prototype._cacheFloat2 = function (uniformName, x, y) {
            var cache = this._valueCache[uniformName];
            if (!cache) {
                cache = [x, y];
                this._valueCache[uniformName] = cache;
                return true;
            }
            var changed = false;
            if (cache[0] !== x) {
                cache[0] = x;
                changed = true;
            }
            if (cache[1] !== y) {
                cache[1] = y;
                changed = true;
            }
            return changed;
        };
        /** @hidden */
        Effect.prototype._cacheFloat3 = function (uniformName, x, y, z) {
            var cache = this._valueCache[uniformName];
            if (!cache) {
                cache = [x, y, z];
                this._valueCache[uniformName] = cache;
                return true;
            }
            var changed = false;
            if (cache[0] !== x) {
                cache[0] = x;
                changed = true;
            }
            if (cache[1] !== y) {
                cache[1] = y;
                changed = true;
            }
            if (cache[2] !== z) {
                cache[2] = z;
                changed = true;
            }
            return changed;
        };
        /** @hidden */
        Effect.prototype._cacheFloat4 = function (uniformName, x, y, z, w) {
            var cache = this._valueCache[uniformName];
            if (!cache) {
                cache = [x, y, z, w];
                this._valueCache[uniformName] = cache;
                return true;
            }
            var changed = false;
            if (cache[0] !== x) {
                cache[0] = x;
                changed = true;
            }
            if (cache[1] !== y) {
                cache[1] = y;
                changed = true;
            }
            if (cache[2] !== z) {
                cache[2] = z;
                changed = true;
            }
            if (cache[3] !== w) {
                cache[3] = w;
                changed = true;
            }
            return changed;
        };
        /**
         * Binds a buffer to a uniform.
         * @param buffer Buffer to bind.
         * @param name Name of the uniform variable to bind to.
         */
        Effect.prototype.bindUniformBuffer = function (buffer, name) {
            var bufferName = this._uniformBuffersNames[name];
            if (bufferName === undefined || Effect._baseCache[bufferName] === buffer) {
                return;
            }
            Effect._baseCache[bufferName] = buffer;
            this._engine.bindUniformBufferBase(buffer, bufferName);
        };
        /**
         * Binds block to a uniform.
         * @param blockName Name of the block to bind.
         * @param index Index to bind.
         */
        Effect.prototype.bindUniformBlock = function (blockName, index) {
            this._engine.bindUniformBlock(this._program, blockName, index);
        };
        /**
         * Sets an interger value on a uniform variable.
         * @param uniformName Name of the variable.
         * @param value Value to be set.
         * @returns this effect.
         */
        Effect.prototype.setInt = function (uniformName, value) {
            var cache = this._valueCache[uniformName];
            if (cache !== undefined && cache === value)
                return this;
            this._valueCache[uniformName] = value;
            this._engine.setInt(this.getUniform(uniformName), value);
            return this;
        };
        /**
         * Sets an int array on a uniform variable.
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setIntArray = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setIntArray(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an int array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setIntArray2 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setIntArray2(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an int array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setIntArray3 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setIntArray3(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an int array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setIntArray4 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setIntArray4(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an float array on a uniform variable.
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setFloatArray = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setFloatArray(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an float array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setFloatArray2 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setFloatArray2(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an float array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setFloatArray3 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setFloatArray3(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an float array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setFloatArray4 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setFloatArray4(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an array on a uniform variable.
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setArray = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setArray(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setArray2 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setArray2(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setArray3 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setArray3(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets an array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
         * @param uniformName Name of the variable.
         * @param array array to be set.
         * @returns this effect.
         */
        Effect.prototype.setArray4 = function (uniformName, array) {
            this._valueCache[uniformName] = null;
            this._engine.setArray4(this.getUniform(uniformName), array);
            return this;
        };
        /**
         * Sets matrices on a uniform variable.
         * @param uniformName Name of the variable.
         * @param matrices matrices to be set.
         * @returns this effect.
         */
        Effect.prototype.setMatrices = function (uniformName, matrices) {
            if (!matrices) {
                return this;
            }
            this._valueCache[uniformName] = null;
            this._engine.setMatrices(this.getUniform(uniformName), matrices);
            return this;
        };
        /**
         * Sets matrix on a uniform variable.
         * @param uniformName Name of the variable.
         * @param matrix matrix to be set.
         * @returns this effect.
         */
        Effect.prototype.setMatrix = function (uniformName, matrix) {
            if (this._cacheMatrix(uniformName, matrix)) {
                this._engine.setMatrix(this.getUniform(uniformName), matrix);
            }
            return this;
        };
        /**
         * Sets a 3x3 matrix on a uniform variable. (Speicified as [1,2,3,4,5,6,7,8,9] will result in [1,2,3][4,5,6][7,8,9] matrix)
         * @param uniformName Name of the variable.
         * @param matrix matrix to be set.
         * @returns this effect.
         */
        Effect.prototype.setMatrix3x3 = function (uniformName, matrix) {
            this._valueCache[uniformName] = null;
            this._engine.setMatrix3x3(this.getUniform(uniformName), matrix);
            return this;
        };
        /**
         * Sets a 2x2 matrix on a uniform variable. (Speicified as [1,2,3,4] will result in [1,2][3,4] matrix)
         * @param uniformName Name of the variable.
         * @param matrix matrix to be set.
         * @returns this effect.
         */
        Effect.prototype.setMatrix2x2 = function (uniformName, matrix) {
            this._valueCache[uniformName] = null;
            this._engine.setMatrix2x2(this.getUniform(uniformName), matrix);
            return this;
        };
        /**
         * Sets a float on a uniform variable.
         * @param uniformName Name of the variable.
         * @param value value to be set.
         * @returns this effect.
         */
        Effect.prototype.setFloat = function (uniformName, value) {
            var cache = this._valueCache[uniformName];
            if (cache !== undefined && cache === value)
                return this;
            this._valueCache[uniformName] = value;
            this._engine.setFloat(this.getUniform(uniformName), value);
            return this;
        };
        /**
         * Sets a boolean on a uniform variable.
         * @param uniformName Name of the variable.
         * @param bool value to be set.
         * @returns this effect.
         */
        Effect.prototype.setBool = function (uniformName, bool) {
            var cache = this._valueCache[uniformName];
            if (cache !== undefined && cache === bool)
                return this;
            this._valueCache[uniformName] = bool;
            this._engine.setBool(this.getUniform(uniformName), bool ? 1 : 0);
            return this;
        };
        /**
         * Sets a Vector2 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param vector2 vector2 to be set.
         * @returns this effect.
         */
        Effect.prototype.setVector2 = function (uniformName, vector2) {
            if (this._cacheFloat2(uniformName, vector2.x, vector2.y)) {
                this._engine.setFloat2(this.getUniform(uniformName), vector2.x, vector2.y);
            }
            return this;
        };
        /**
         * Sets a float2 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param x First float in float2.
         * @param y Second float in float2.
         * @returns this effect.
         */
        Effect.prototype.setFloat2 = function (uniformName, x, y) {
            if (this._cacheFloat2(uniformName, x, y)) {
                this._engine.setFloat2(this.getUniform(uniformName), x, y);
            }
            return this;
        };
        /**
         * Sets a Vector3 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param vector3 Value to be set.
         * @returns this effect.
         */
        Effect.prototype.setVector3 = function (uniformName, vector3) {
            if (this._cacheFloat3(uniformName, vector3.x, vector3.y, vector3.z)) {
                this._engine.setFloat3(this.getUniform(uniformName), vector3.x, vector3.y, vector3.z);
            }
            return this;
        };
        /**
         * Sets a float3 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param x First float in float3.
         * @param y Second float in float3.
         * @param z Third float in float3.
         * @returns this effect.
         */
        Effect.prototype.setFloat3 = function (uniformName, x, y, z) {
            if (this._cacheFloat3(uniformName, x, y, z)) {
                this._engine.setFloat3(this.getUniform(uniformName), x, y, z);
            }
            return this;
        };
        /**
         * Sets a Vector4 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param vector4 Value to be set.
         * @returns this effect.
         */
        Effect.prototype.setVector4 = function (uniformName, vector4) {
            if (this._cacheFloat4(uniformName, vector4.x, vector4.y, vector4.z, vector4.w)) {
                this._engine.setFloat4(this.getUniform(uniformName), vector4.x, vector4.y, vector4.z, vector4.w);
            }
            return this;
        };
        /**
         * Sets a float4 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param x First float in float4.
         * @param y Second float in float4.
         * @param z Third float in float4.
         * @param w Fourth float in float4.
         * @returns this effect.
         */
        Effect.prototype.setFloat4 = function (uniformName, x, y, z, w) {
            if (this._cacheFloat4(uniformName, x, y, z, w)) {
                this._engine.setFloat4(this.getUniform(uniformName), x, y, z, w);
            }
            return this;
        };
        /**
         * Sets a Color3 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param color3 Value to be set.
         * @returns this effect.
         */
        Effect.prototype.setColor3 = function (uniformName, color3) {
            if (this._cacheFloat3(uniformName, color3.r, color3.g, color3.b)) {
                this._engine.setColor3(this.getUniform(uniformName), color3);
            }
            return this;
        };
        /**
         * Sets a Color4 on a uniform variable.
         * @param uniformName Name of the variable.
         * @param color3 Value to be set.
         * @param alpha Alpha value to be set.
         * @returns this effect.
         */
        Effect.prototype.setColor4 = function (uniformName, color3, alpha) {
            if (this._cacheFloat4(uniformName, color3.r, color3.g, color3.b, alpha)) {
                this._engine.setColor4(this.getUniform(uniformName), color3, alpha);
            }
            return this;
        };
        /**
         * Sets a Color4 on a uniform variable
         * @param uniformName defines the name of the variable
         * @param color4 defines the value to be set
         * @returns this effect.
         */
        Effect.prototype.setDirectColor4 = function (uniformName, color4) {
            if (this._cacheFloat4(uniformName, color4.r, color4.g, color4.b, color4.a)) {
                this._engine.setDirectColor4(this.getUniform(uniformName), color4);
            }
            return this;
        };
        /**
         * Resets the cache of effects.
         */
        Effect.ResetCache = function () {
            Effect._baseCache = {};
        };
        Effect._uniqueIdSeed = 0;
        Effect._baseCache = {};
        /**
         * Store of each shader (The can be looked up using effect.key)
         */
        Effect.ShadersStore = {};
        /**
         * Store of each included file for a shader (The can be looked up using effect.key)
         */
        Effect.IncludesShadersStore = {};
        return Effect;
    }());
    BABYLON.Effect = Effect;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.effect.js.map



//# sourceMappingURL=babylon.types.js.map


var BABYLON;
(function (BABYLON) {
    var KeyboardEventTypes = /** @class */ (function () {
        function KeyboardEventTypes() {
        }
        Object.defineProperty(KeyboardEventTypes, "KEYDOWN", {
            get: function () {
                return KeyboardEventTypes._KEYDOWN;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(KeyboardEventTypes, "KEYUP", {
            get: function () {
                return KeyboardEventTypes._KEYUP;
            },
            enumerable: true,
            configurable: true
        });
        KeyboardEventTypes._KEYDOWN = 0x01;
        KeyboardEventTypes._KEYUP = 0x02;
        return KeyboardEventTypes;
    }());
    BABYLON.KeyboardEventTypes = KeyboardEventTypes;
    var KeyboardInfo = /** @class */ (function () {
        function KeyboardInfo(type, event) {
            this.type = type;
            this.event = event;
        }
        return KeyboardInfo;
    }());
    BABYLON.KeyboardInfo = KeyboardInfo;
    /**
     * This class is used to store keyboard related info for the onPreKeyboardObservable event.
     * Set the skipOnKeyboardObservable property to true if you want the engine to stop any process after this event is triggered, even not calling onKeyboardObservable
     */
    var KeyboardInfoPre = /** @class */ (function (_super) {
        __extends(KeyboardInfoPre, _super);
        function KeyboardInfoPre(type, event) {
            var _this = _super.call(this, type, event) || this;
            _this.skipOnPointerObservable = false;
            return _this;
        }
        return KeyboardInfoPre;
    }(KeyboardInfo));
    BABYLON.KeyboardInfoPre = KeyboardInfoPre;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.keyboardEvents.js.map


var BABYLON;
(function (BABYLON) {
    var PointerEventTypes = /** @class */ (function () {
        function PointerEventTypes() {
        }
        Object.defineProperty(PointerEventTypes, "POINTERDOWN", {
            get: function () {
                return PointerEventTypes._POINTERDOWN;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERUP", {
            get: function () {
                return PointerEventTypes._POINTERUP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERMOVE", {
            get: function () {
                return PointerEventTypes._POINTERMOVE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERWHEEL", {
            get: function () {
                return PointerEventTypes._POINTERWHEEL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERPICK", {
            get: function () {
                return PointerEventTypes._POINTERPICK;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERTAP", {
            get: function () {
                return PointerEventTypes._POINTERTAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERDOUBLETAP", {
            get: function () {
                return PointerEventTypes._POINTERDOUBLETAP;
            },
            enumerable: true,
            configurable: true
        });
        PointerEventTypes._POINTERDOWN = 0x01;
        PointerEventTypes._POINTERUP = 0x02;
        PointerEventTypes._POINTERMOVE = 0x04;
        PointerEventTypes._POINTERWHEEL = 0x08;
        PointerEventTypes._POINTERPICK = 0x10;
        PointerEventTypes._POINTERTAP = 0x20;
        PointerEventTypes._POINTERDOUBLETAP = 0x40;
        return PointerEventTypes;
    }());
    BABYLON.PointerEventTypes = PointerEventTypes;
    var PointerInfoBase = /** @class */ (function () {
        function PointerInfoBase(type, event) {
            this.type = type;
            this.event = event;
        }
        return PointerInfoBase;
    }());
    BABYLON.PointerInfoBase = PointerInfoBase;
    /**
     * This class is used to store pointer related info for the onPrePointerObservable event.
     * Set the skipOnPointerObservable property to true if you want the engine to stop any process after this event is triggered, even not calling onPointerObservable
     */
    var PointerInfoPre = /** @class */ (function (_super) {
        __extends(PointerInfoPre, _super);
        function PointerInfoPre(type, event, localX, localY) {
            var _this = _super.call(this, type, event) || this;
            _this.skipOnPointerObservable = false;
            _this.localPosition = new BABYLON.Vector2(localX, localY);
            return _this;
        }
        return PointerInfoPre;
    }(PointerInfoBase));
    BABYLON.PointerInfoPre = PointerInfoPre;
    /**
     * This type contains all the data related to a pointer event in Babylon.js.
     * The event member is an instance of PointerEvent for all types except PointerWheel and is of type MouseWheelEvent when type equals PointerWheel. The different event types can be found in the PointerEventTypes class.
     */
    var PointerInfo = /** @class */ (function (_super) {
        __extends(PointerInfo, _super);
        function PointerInfo(type, event, pickInfo) {
            var _this = _super.call(this, type, event) || this;
            _this.pickInfo = pickInfo;
            return _this;
        }
        return PointerInfo;
    }(PointerInfoBase));
    BABYLON.PointerInfo = PointerInfo;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.pointerEvents.js.map

var BABYLON;
(function (BABYLON) {
    BABYLON.ToGammaSpace = 1 / 2.2;
    BABYLON.ToLinearSpace = 2.2;
    BABYLON.Epsilon = 0.001;
    /**
     * Class used to hold a RBG color
     */
    var Color3 = /** @class */ (function () {
        /**
         * Creates a new Color3 object from red, green, blue values, all between 0 and 1
         * @param r defines the red component (between 0 and 1, default is 0)
         * @param g defines the green component (between 0 and 1, default is 0)
         * @param b defines the blue component (between 0 and 1, default is 0)
         */
        function Color3(
        /**
         * Defines the red component (between 0 and 1, default is 0)
         */
        r, 
        /**
         * Defines the green component (between 0 and 1, default is 0)
         */
        g, 
        /**
         * Defines the blue component (between 0 and 1, default is 0)
         */
        b) {
            if (r === void 0) { r = 0; }
            if (g === void 0) { g = 0; }
            if (b === void 0) { b = 0; }
            this.r = r;
            this.g = g;
            this.b = b;
        }
        /**
         * Creates a string with the Color3 current values
         * @returns the string representation of the Color3 object
         */
        Color3.prototype.toString = function () {
            return "{R: " + this.r + " G:" + this.g + " B:" + this.b + "}";
        };
        /**
         * Returns the string "Color3"
         * @returns "Color3"
         */
        Color3.prototype.getClassName = function () {
            return "Color3";
        };
        /**
         * Compute the Color3 hash code
         * @returns an unique number that can be used to hash Color3 objects
         */
        Color3.prototype.getHashCode = function () {
            var hash = this.r || 0;
            hash = (hash * 397) ^ (this.g || 0);
            hash = (hash * 397) ^ (this.b || 0);
            return hash;
        };
        // Operators
        /**
         * Stores in the given array from the given starting index the red, green, blue values as successive elements
         * @param array defines the array where to store the r,g,b components
         * @param index defines an optional index in the target array to define where to start storing values
         * @returns the current Color3 object
         */
        Color3.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.r;
            array[index + 1] = this.g;
            array[index + 2] = this.b;
            return this;
        };
        /**
         * Returns a new {BABYLON.Color4} object from the current Color3 and the given alpha
         * @param alpha defines the alpha component on the new {BABYLON.Color4} object (default is 1)
         * @returns a new {BABYLON.Color4} object
         */
        Color3.prototype.toColor4 = function (alpha) {
            if (alpha === void 0) { alpha = 1; }
            return new Color4(this.r, this.g, this.b, alpha);
        };
        /**
         * Returns a new array populated with 3 numeric elements : red, green and blue values
         * @returns the new array
         */
        Color3.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Returns the luminance value
         * @returns a float value
         */
        Color3.prototype.toLuminance = function () {
            return this.r * 0.3 + this.g * 0.59 + this.b * 0.11;
        };
        /**
         * Multiply each Color3 rgb values by the given Color3 rgb values in a new Color3 object
         * @param otherColor defines the second operand
         * @returns the new Color3 object
         */
        Color3.prototype.multiply = function (otherColor) {
            return new Color3(this.r * otherColor.r, this.g * otherColor.g, this.b * otherColor.b);
        };
        /**
         * Multiply the rgb values of the Color3 and the given Color3 and stores the result in the object "result"
         * @param otherColor defines the second operand
         * @param result defines the Color3 object where to store the result
         * @returns the current Color3
         */
        Color3.prototype.multiplyToRef = function (otherColor, result) {
            result.r = this.r * otherColor.r;
            result.g = this.g * otherColor.g;
            result.b = this.b * otherColor.b;
            return this;
        };
        /**
         * Determines equality between Color3 objects
         * @param otherColor defines the second operand
         * @returns true if the rgb values are equal to the given ones
         */
        Color3.prototype.equals = function (otherColor) {
            return otherColor && this.r === otherColor.r && this.g === otherColor.g && this.b === otherColor.b;
        };
        /**
         * Determines equality between the current Color3 object and a set of r,b,g values
         * @param r defines the red component to check
         * @param g defines the green component to check
         * @param b defines the blue component to check
         * @returns true if the rgb values are equal to the given ones
         */
        Color3.prototype.equalsFloats = function (r, g, b) {
            return this.r === r && this.g === g && this.b === b;
        };
        /**
         * Multiplies in place each rgb value by scale
         * @param scale defines the scaling factor
         * @returns the updated Color3
         */
        Color3.prototype.scale = function (scale) {
            return new Color3(this.r * scale, this.g * scale, this.b * scale);
        };
        /**
         * Multiplies the rgb values by scale and stores the result into "result"
         * @param scale defines the scaling factor
         * @param result defines the Color3 object where to store the result
         * @returns the unmodified current Color3
         */
        Color3.prototype.scaleToRef = function (scale, result) {
            result.r = this.r * scale;
            result.g = this.g * scale;
            result.b = this.b * scale;
            return this;
        };
        /**
         * Scale the current Color3 values by a factor and add the result to a given Color3
         * @param scale defines the scale factor
         * @param result defines color to store the result into
         * @returns the unmodified current Color3
         */
        Color3.prototype.scaleAndAddToRef = function (scale, result) {
            result.r += this.r * scale;
            result.g += this.g * scale;
            result.b += this.b * scale;
            return this;
        };
        /**
         * Clamps the rgb values by the min and max values and stores the result into "result"
         * @param min defines minimum clamping value (default is 0)
         * @param max defines maximum clamping value (default is 1)
         * @param result defines color to store the result into
         * @returns the original Color3
         */
        Color3.prototype.clampToRef = function (min, max, result) {
            if (min === void 0) { min = 0; }
            if (max === void 0) { max = 1; }
            result.r = BABYLON.Scalar.Clamp(this.r, min, max);
            result.g = BABYLON.Scalar.Clamp(this.g, min, max);
            result.b = BABYLON.Scalar.Clamp(this.b, min, max);
            return this;
        };
        /**
         * Creates a new Color3 set with the added values of the current Color3 and of the given one
         * @param otherColor defines the second operand
         * @returns the new Color3
         */
        Color3.prototype.add = function (otherColor) {
            return new Color3(this.r + otherColor.r, this.g + otherColor.g, this.b + otherColor.b);
        };
        /**
         * Stores the result of the addition of the current Color3 and given one rgb values into "result"
         * @param otherColor defines the second operand
         * @param result defines Color3 object to store the result into
         * @returns the unmodified current Color3
         */
        Color3.prototype.addToRef = function (otherColor, result) {
            result.r = this.r + otherColor.r;
            result.g = this.g + otherColor.g;
            result.b = this.b + otherColor.b;
            return this;
        };
        /**
         * Returns a new Color3 set with the subtracted values of the given one from the current Color3
         * @param otherColor defines the second operand
         * @returns the new Color3
         */
        Color3.prototype.subtract = function (otherColor) {
            return new Color3(this.r - otherColor.r, this.g - otherColor.g, this.b - otherColor.b);
        };
        /**
         * Stores the result of the subtraction of given one from the current Color3 rgb values into "result"
         * @param otherColor defines the second operand
         * @param result defines Color3 object to store the result into
         * @returns the unmodified current Color3
         */
        Color3.prototype.subtractToRef = function (otherColor, result) {
            result.r = this.r - otherColor.r;
            result.g = this.g - otherColor.g;
            result.b = this.b - otherColor.b;
            return this;
        };
        /**
         * Copy the current object
         * @returns a new Color3 copied the current one
         */
        Color3.prototype.clone = function () {
            return new Color3(this.r, this.g, this.b);
        };
        /**
         * Copies the rgb values from the source in the current Color3
         * @param source defines the source Color3 object
         * @returns the updated Color3 object
         */
        Color3.prototype.copyFrom = function (source) {
            this.r = source.r;
            this.g = source.g;
            this.b = source.b;
            return this;
        };
        /**
         * Updates the Color3 rgb values from the given floats
         * @param r defines the red component to read from
         * @param g defines the green component to read from
         * @param b defines the blue component to read from
         * @returns the current Color3 object
         */
        Color3.prototype.copyFromFloats = function (r, g, b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        };
        /**
         * Updates the Color3 rgb values from the given floats
         * @param r defines the red component to read from
         * @param g defines the green component to read from
         * @param b defines the blue component to read from
         * @returns the current Color3 object
         */
        Color3.prototype.set = function (r, g, b) {
            return this.copyFromFloats(r, g, b);
        };
        /**
         * Compute the Color3 hexadecimal code as a string
         * @returns a string containing the hexadecimal representation of the Color3 object
         */
        Color3.prototype.toHexString = function () {
            var intR = (this.r * 255) | 0;
            var intG = (this.g * 255) | 0;
            var intB = (this.b * 255) | 0;
            return "#" + BABYLON.Scalar.ToHex(intR) + BABYLON.Scalar.ToHex(intG) + BABYLON.Scalar.ToHex(intB);
        };
        /**
         * Computes a new Color3 converted from the current one to linear space
         * @returns a new Color3 object
         */
        Color3.prototype.toLinearSpace = function () {
            var convertedColor = new Color3();
            this.toLinearSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color3 values to linear space and stores the result in "convertedColor"
         * @param convertedColor defines the Color3 object where to store the linear space version
         * @returns the unmodified Color3
         */
        Color3.prototype.toLinearSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToLinearSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToLinearSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToLinearSpace);
            return this;
        };
        /**
         * Computes a new Color3 converted from the current one to gamma space
         * @returns a new Color3 object
         */
        Color3.prototype.toGammaSpace = function () {
            var convertedColor = new Color3();
            this.toGammaSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color3 values to gamma space and stores the result in "convertedColor"
         * @param convertedColor defines the Color3 object where to store the gamma space version
         * @returns the unmodified Color3
         */
        Color3.prototype.toGammaSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToGammaSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToGammaSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToGammaSpace);
            return this;
        };
        // Statics
        /**
         * Creates a new Color3 from the string containing valid hexadecimal values
         * @param hex defines a string containing valid hexadecimal values
         * @returns a new Color3 object
         */
        Color3.FromHexString = function (hex) {
            if (hex.substring(0, 1) !== "#" || hex.length !== 7) {
                return new Color3(0, 0, 0);
            }
            var r = parseInt(hex.substring(1, 3), 16);
            var g = parseInt(hex.substring(3, 5), 16);
            var b = parseInt(hex.substring(5, 7), 16);
            return Color3.FromInts(r, g, b);
        };
        /**
         * Creates a new Vector3 from the starting index of the given array
         * @param array defines the source array
         * @param offset defines an offset in the source array
         * @returns a new Color3 object
         */
        Color3.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Color3(array[offset], array[offset + 1], array[offset + 2]);
        };
        /**
         * Creates a new Color3 from integer values (< 256)
         * @param r defines the red component to read from (value between 0 and 255)
         * @param g defines the green component to read from (value between 0 and 255)
         * @param b defines the blue component to read from (value between 0 and 255)
         * @returns a new Color3 object
         */
        Color3.FromInts = function (r, g, b) {
            return new Color3(r / 255.0, g / 255.0, b / 255.0);
        };
        /**
         * Creates a new Color3 with values linearly interpolated of "amount" between the start Color3 and the end Color3
         * @param start defines the start Color3 value
         * @param end defines the end Color3 value
         * @param amount defines the gradient value between start and end
         * @returns a new Color3 object
         */
        Color3.Lerp = function (start, end, amount) {
            var r = start.r + ((end.r - start.r) * amount);
            var g = start.g + ((end.g - start.g) * amount);
            var b = start.b + ((end.b - start.b) * amount);
            return new Color3(r, g, b);
        };
        /**
         * Returns a Color3 value containing a red color
         * @returns a new Color3 object
         */
        Color3.Red = function () { return new Color3(1, 0, 0); };
        /**
         * Returns a Color3 value containing a green color
         * @returns a new Color3 object
         */
        Color3.Green = function () { return new Color3(0, 1, 0); };
        /**
         * Returns a Color3 value containing a blue color
         * @returns a new Color3 object
         */
        Color3.Blue = function () { return new Color3(0, 0, 1); };
        /**
         * Returns a Color3 value containing a black color
         * @returns a new Color3 object
         */
        Color3.Black = function () { return new Color3(0, 0, 0); };
        /**
         * Returns a Color3 value containing a white color
         * @returns a new Color3 object
         */
        Color3.White = function () { return new Color3(1, 1, 1); };
        /**
         * Returns a Color3 value containing a purple color
         * @returns a new Color3 object
         */
        Color3.Purple = function () { return new Color3(0.5, 0, 0.5); };
        /**
         * Returns a Color3 value containing a magenta color
         * @returns a new Color3 object
         */
        Color3.Magenta = function () { return new Color3(1, 0, 1); };
        /**
         * Returns a Color3 value containing a yellow color
         * @returns a new Color3 object
         */
        Color3.Yellow = function () { return new Color3(1, 1, 0); };
        /**
         * Returns a Color3 value containing a gray color
         * @returns a new Color3 object
         */
        Color3.Gray = function () { return new Color3(0.5, 0.5, 0.5); };
        /**
         * Returns a Color3 value containing a teal color
         * @returns a new Color3 object
         */
        Color3.Teal = function () { return new Color3(0, 1.0, 1.0); };
        /**
         * Returns a Color3 value containing a random color
         * @returns a new Color3 object
         */
        Color3.Random = function () { return new Color3(Math.random(), Math.random(), Math.random()); };
        return Color3;
    }());
    BABYLON.Color3 = Color3;
    /**
     * Class used to hold a RBGA color
     */
    var Color4 = /** @class */ (function () {
        /**
         * Creates a new Color4 object from red, green, blue values, all between 0 and 1
         * @param r defines the red component (between 0 and 1, default is 0)
         * @param g defines the green component (between 0 and 1, default is 0)
         * @param b defines the blue component (between 0 and 1, default is 0)
         * @param a defines the alpha component (between 0 and 1, default is 1)
         */
        function Color4(
        /**
         * Defines the red component (between 0 and 1, default is 0)
         */
        r, 
        /**
         * Defines the green component (between 0 and 1, default is 0)
         */
        g, 
        /**
         * Defines the blue component (between 0 and 1, default is 0)
         */
        b, 
        /**
         * Defines the alpha component (between 0 and 1, default is 1)
         */
        a) {
            if (r === void 0) { r = 0; }
            if (g === void 0) { g = 0; }
            if (b === void 0) { b = 0; }
            if (a === void 0) { a = 1; }
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
        // Operators
        /**
         * Adds in place the given Color4 values to the current Color4 object
         * @param right defines the second operand
         * @returns the current updated Color4 object
         */
        Color4.prototype.addInPlace = function (right) {
            this.r += right.r;
            this.g += right.g;
            this.b += right.b;
            this.a += right.a;
            return this;
        };
        /**
         * Creates a new array populated with 4 numeric elements : red, green, blue, alpha values
         * @returns the new array
         */
        Color4.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Stores from the starting index in the given array the Color4 successive values
         * @param array defines the array where to store the r,g,b components
         * @param index defines an optional index in the target array to define where to start storing values
         * @returns the current Color4 object
         */
        Color4.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.r;
            array[index + 1] = this.g;
            array[index + 2] = this.b;
            array[index + 3] = this.a;
            return this;
        };
        /**
         * Creates a new Color4 set with the added values of the current Color4 and of the given one
         * @param right defines the second operand
         * @returns a new Color4 object
         */
        Color4.prototype.add = function (right) {
            return new Color4(this.r + right.r, this.g + right.g, this.b + right.b, this.a + right.a);
        };
        /**
         * Creates a new Color4 set with the subtracted values of the given one from the current Color4
         * @param right defines the second operand
         * @returns a new Color4 object
         */
        Color4.prototype.subtract = function (right) {
            return new Color4(this.r - right.r, this.g - right.g, this.b - right.b, this.a - right.a);
        };
        /**
         * Subtracts the given ones from the current Color4 values and stores the results in "result"
         * @param right defines the second operand
         * @param result defines the Color4 object where to store the result
         * @returns the current Color4 object
         */
        Color4.prototype.subtractToRef = function (right, result) {
            result.r = this.r - right.r;
            result.g = this.g - right.g;
            result.b = this.b - right.b;
            result.a = this.a - right.a;
            return this;
        };
        /**
         * Creates a new Color4 with the current Color4 values multiplied by scale
         * @param scale defines the scaling factor to apply
         * @returns a new Color4 object
         */
        Color4.prototype.scale = function (scale) {
            return new Color4(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
        };
        /**
         * Multiplies the current Color4 values by scale and stores the result in "result"
         * @param scale defines the scaling factor to apply
         * @param result defines the Color4 object where to store the result
         * @returns the current unmodified Color4
         */
        Color4.prototype.scaleToRef = function (scale, result) {
            result.r = this.r * scale;
            result.g = this.g * scale;
            result.b = this.b * scale;
            result.a = this.a * scale;
            return this;
        };
        /**
         * Scale the current Color4 values by a factor and add the result to a given Color4
         * @param scale defines the scale factor
         * @param result defines the Color4 object where to store the result
         * @returns the unmodified current Color4
         */
        Color4.prototype.scaleAndAddToRef = function (scale, result) {
            result.r += this.r * scale;
            result.g += this.g * scale;
            result.b += this.b * scale;
            result.a += this.a * scale;
            return this;
        };
        /**
         * Clamps the rgb values by the min and max values and stores the result into "result"
         * @param min defines minimum clamping value (default is 0)
         * @param max defines maximum clamping value (default is 1)
         * @param result defines color to store the result into.
         * @returns the cuurent Color4
         */
        Color4.prototype.clampToRef = function (min, max, result) {
            if (min === void 0) { min = 0; }
            if (max === void 0) { max = 1; }
            result.r = BABYLON.Scalar.Clamp(this.r, min, max);
            result.g = BABYLON.Scalar.Clamp(this.g, min, max);
            result.b = BABYLON.Scalar.Clamp(this.b, min, max);
            result.a = BABYLON.Scalar.Clamp(this.a, min, max);
            return this;
        };
        /**
          * Multipy an Color4 value by another and return a new Color4 object
          * @param color defines the Color4 value to multiply by
          * @returns a new Color4 object
          */
        Color4.prototype.multiply = function (color) {
            return new Color4(this.r * color.r, this.g * color.g, this.b * color.b, this.a * color.a);
        };
        /**
         * Multipy a Color4 value by another and push the result in a reference value
         * @param color defines the Color4 value to multiply by
         * @param result defines the Color4 to fill the result in
         * @returns the result Color4
         */
        Color4.prototype.multiplyToRef = function (color, result) {
            result.r = this.r * color.r;
            result.g = this.g * color.g;
            result.b = this.b * color.b;
            result.a = this.a * color.a;
            return result;
        };
        /**
         * Creates a string with the Color4 current values
         * @returns the string representation of the Color4 object
         */
        Color4.prototype.toString = function () {
            return "{R: " + this.r + " G:" + this.g + " B:" + this.b + " A:" + this.a + "}";
        };
        /**
         * Returns the string "Color4"
         * @returns "Color4"
         */
        Color4.prototype.getClassName = function () {
            return "Color4";
        };
        /**
         * Compute the Color4 hash code
         * @returns an unique number that can be used to hash Color4 objects
         */
        Color4.prototype.getHashCode = function () {
            var hash = this.r || 0;
            hash = (hash * 397) ^ (this.g || 0);
            hash = (hash * 397) ^ (this.b || 0);
            hash = (hash * 397) ^ (this.a || 0);
            return hash;
        };
        /**
         * Creates a new Color4 copied from the current one
         * @returns a new Color4 object
         */
        Color4.prototype.clone = function () {
            return new Color4(this.r, this.g, this.b, this.a);
        };
        /**
         * Copies the given Color4 values into the current one
         * @param source defines the source Color4 object
         * @returns the current updated Color4 object
         */
        Color4.prototype.copyFrom = function (source) {
            this.r = source.r;
            this.g = source.g;
            this.b = source.b;
            this.a = source.a;
            return this;
        };
        /**
         * Copies the given float values into the current one
         * @param r defines the red component to read from
         * @param g defines the green component to read from
         * @param b defines the blue component to read from
         * @param a defines the alpha component to read from
         * @returns the current updated Color4 object
         */
        Color4.prototype.copyFromFloats = function (r, g, b, a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        };
        /**
         * Copies the given float values into the current one
         * @param r defines the red component to read from
         * @param g defines the green component to read from
         * @param b defines the blue component to read from
         * @param a defines the alpha component to read from
         * @returns the current updated Color4 object
         */
        Color4.prototype.set = function (r, g, b, a) {
            return this.copyFromFloats(r, g, b, a);
        };
        /**
         * Compute the Color4 hexadecimal code as a string
         * @returns a string containing the hexadecimal representation of the Color4 object
         */
        Color4.prototype.toHexString = function () {
            var intR = (this.r * 255) | 0;
            var intG = (this.g * 255) | 0;
            var intB = (this.b * 255) | 0;
            var intA = (this.a * 255) | 0;
            return "#" + BABYLON.Scalar.ToHex(intR) + BABYLON.Scalar.ToHex(intG) + BABYLON.Scalar.ToHex(intB) + BABYLON.Scalar.ToHex(intA);
        };
        /**
         * Computes a new Color4 converted from the current one to linear space
         * @returns a new Color4 object
         */
        Color4.prototype.toLinearSpace = function () {
            var convertedColor = new Color4();
            this.toLinearSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color4 values to linear space and stores the result in "convertedColor"
         * @param convertedColor defines the Color4 object where to store the linear space version
         * @returns the unmodified Color4
         */
        Color4.prototype.toLinearSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToLinearSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToLinearSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToLinearSpace);
            convertedColor.a = this.a;
            return this;
        };
        /**
         * Computes a new Color4 converted from the current one to gamma space
         * @returns a new Color4 object
         */
        Color4.prototype.toGammaSpace = function () {
            var convertedColor = new Color4();
            this.toGammaSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color4 values to gamma space and stores the result in "convertedColor"
         * @param convertedColor defines the Color4 object where to store the gamma space version
         * @returns the unmodified Color4
         */
        Color4.prototype.toGammaSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToGammaSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToGammaSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToGammaSpace);
            convertedColor.a = this.a;
            return this;
        };
        // Statics
        /**
         * Creates a new Color4 from the string containing valid hexadecimal values
         * @param hex defines a string containing valid hexadecimal values
         * @returns a new Color4 object
         */
        Color4.FromHexString = function (hex) {
            if (hex.substring(0, 1) !== "#" || hex.length !== 9) {
                return new Color4(0.0, 0.0, 0.0, 0.0);
            }
            var r = parseInt(hex.substring(1, 3), 16);
            var g = parseInt(hex.substring(3, 5), 16);
            var b = parseInt(hex.substring(5, 7), 16);
            var a = parseInt(hex.substring(7, 9), 16);
            return Color4.FromInts(r, g, b, a);
        };
        /**
         * Creates a new Color4 object set with the linearly interpolated values of "amount" between the left Color4 object and the right Color4 object
         * @param left defines the start value
         * @param right defines the end value
         * @param amount defines the gradient factor
         * @returns a new Color4 object
         */
        Color4.Lerp = function (left, right, amount) {
            var result = new Color4(0.0, 0.0, 0.0, 0.0);
            Color4.LerpToRef(left, right, amount, result);
            return result;
        };
        /**
         * Set the given "result" with the linearly interpolated values of "amount" between the left Color4 object and the right Color4 object
         * @param left defines the start value
         * @param right defines the end value
         * @param amount defines the gradient factor
         * @param result defines the Color4 object where to store data
         */
        Color4.LerpToRef = function (left, right, amount, result) {
            result.r = left.r + (right.r - left.r) * amount;
            result.g = left.g + (right.g - left.g) * amount;
            result.b = left.b + (right.b - left.b) * amount;
            result.a = left.a + (right.a - left.a) * amount;
        };
        /**
         * Creates a new Color4 from the starting index element of the given array
         * @param array defines the source array to read from
         * @param offset defines the offset in the source array
         * @returns a new Color4 object
         */
        Color4.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Color4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Creates a new Color3 from integer values (< 256)
         * @param r defines the red component to read from (value between 0 and 255)
         * @param g defines the green component to read from (value between 0 and 255)
         * @param b defines the blue component to read from (value between 0 and 255)
         * @param a defines the alpha component to read from (value between 0 and 255)
         * @returns a new Color3 object
         */
        Color4.FromInts = function (r, g, b, a) {
            return new Color4(r / 255.0, g / 255.0, b / 255.0, a / 255.0);
        };
        /**
         * Check the content of a given array and convert it to an array containing RGBA data
         * If the original array was already containing count * 4 values then it is returned directly
         * @param colors defines the array to check
         * @param count defines the number of RGBA data to expect
         * @returns an array containing count * 4 values (RGBA)
         */
        Color4.CheckColors4 = function (colors, count) {
            // Check if color3 was used
            if (colors.length === count * 3) {
                var colors4 = [];
                for (var index = 0; index < colors.length; index += 3) {
                    var newIndex = (index / 3) * 4;
                    colors4[newIndex] = colors[index];
                    colors4[newIndex + 1] = colors[index + 1];
                    colors4[newIndex + 2] = colors[index + 2];
                    colors4[newIndex + 3] = 1.0;
                }
                return colors4;
            }
            return colors;
        };
        return Color4;
    }());
    BABYLON.Color4 = Color4;
    /**
     * Class representing a vector containing 2 coordinates
     */
    var Vector2 = /** @class */ (function () {
        /**
         * Creates a new Vector2 from the given x and y coordinates
         * @param x defines the first coordinate
         * @param y defines the second coordinate
         */
        function Vector2(
        /** defines the first coordinate */
        x, 
        /** defines the second coordinate */
        y) {
            this.x = x;
            this.y = y;
        }
        /**
         * Gets a string with the Vector2 coordinates
         * @returns a string with the Vector2 coordinates
         */
        Vector2.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + "}";
        };
        /**
         * Gets class name
         * @returns the string "Vector2"
         */
        Vector2.prototype.getClassName = function () {
            return "Vector2";
        };
        /**
         * Gets current vector hash code
         * @returns the Vector2 hash code as a number
         */
        Vector2.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            return hash;
        };
        // Operators
        /**
         * Sets the Vector2 coordinates in the given array or Float32Array from the given index.
         * @param array defines the source array
         * @param index defines the offset in source array
         * @returns the current Vector2
         */
        Vector2.prototype.toArray = function (array, index) {
            if (index === void 0) { index = 0; }
            array[index] = this.x;
            array[index + 1] = this.y;
            return this;
        };
        /**
         * Copy the current vector to an array
         * @returns a new array with 2 elements: the Vector2 coordinates.
         */
        Vector2.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Sets the Vector2 coordinates with the given Vector2 coordinates
         * @param source defines the source Vector2
         * @returns the current updated Vector2
         */
        Vector2.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            return this;
        };
        /**
         * Sets the Vector2 coordinates with the given floats
         * @param x defines the first coordinate
         * @param y defines the second coordinate
         * @returns the current updated Vector2
         */
        Vector2.prototype.copyFromFloats = function (x, y) {
            this.x = x;
            this.y = y;
            return this;
        };
        /**
         * Sets the Vector2 coordinates with the given floats
         * @param x defines the first coordinate
         * @param y defines the second coordinate
         * @returns the current updated Vector2
         */
        Vector2.prototype.set = function (x, y) {
            return this.copyFromFloats(x, y);
        };
        /**
         * Add another vector with the current one
         * @param otherVector defines the other vector
         * @returns a new Vector2 set with the addition of the current Vector2 and the given one coordinates
         */
        Vector2.prototype.add = function (otherVector) {
            return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the addition of the current Vector2 and the given one coordinates
         * @param otherVector defines the other vector
         * @param result defines the target vector
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            return this;
        };
        /**
         * Set the Vector2 coordinates by adding the given Vector2 coordinates
         * @param otherVector defines the other vector
         * @returns the current updated Vector2
         */
        Vector2.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            return this;
        };
        /**
         * Gets a new Vector2 by adding the current Vector2 coordinates to the given Vector3 x, y coordinates
         * @param otherVector defines the other vector
         * @returns a new Vector2
         */
        Vector2.prototype.addVector3 = function (otherVector) {
            return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
        };
        /**
         * Gets a new Vector2 set with the subtracted coordinates of the given one from the current Vector2
         * @param otherVector defines the other vector
         * @returns a new Vector2
         */
        Vector2.prototype.subtract = function (otherVector) {
            return new Vector2(this.x - otherVector.x, this.y - otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the subtraction of the given one from the current Vector2 coordinates.
         * @param otherVector defines the other vector
         * @param result defines the target vector
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            return this;
        };
        /**
         * Sets the current Vector2 coordinates by subtracting from it the given one coordinates
         * @param otherVector defines the other vector
         * @returns the current updated Vector2
         */
        Vector2.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            return this;
        };
        /**
         * Multiplies in place the current Vector2 coordinates by the given ones
         * @param otherVector defines the other vector
         * @returns the current updated Vector2
         */
        Vector2.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            return this;
        };
        /**
         * Returns a new Vector2 set with the multiplication of the current Vector2 and the given one coordinates
         * @param otherVector defines the other vector
         * @returns a new Vector2
         */
        Vector2.prototype.multiply = function (otherVector) {
            return new Vector2(this.x * otherVector.x, this.y * otherVector.y);
        };
        /**
         * Sets "result" coordinates with the multiplication of the current Vector2 and the given one coordinates
         * @param otherVector defines the other vector
         * @param result defines the target vector
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            return this;
        };
        /**
         * Gets a new Vector2 set with the Vector2 coordinates multiplied by the given floats
         * @param x defines the first coordinate
         * @param y defines the second coordinate
         * @returns a new Vector2
         */
        Vector2.prototype.multiplyByFloats = function (x, y) {
            return new Vector2(this.x * x, this.y * y);
        };
        /**
         * Returns a new Vector2 set with the Vector2 coordinates divided by the given one coordinates
         * @param otherVector defines the other vector
         * @returns a new Vector2
         */
        Vector2.prototype.divide = function (otherVector) {
            return new Vector2(this.x / otherVector.x, this.y / otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the Vector2 divided by the given one coordinates
         * @param otherVector defines the other vector
         * @param result defines the target vector
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            return this;
        };
        /**
         * Divides the current Vector3 coordinates by the given ones
         * @param otherVector defines the other vector
         * @returns the current updated Vector2
         */
        Vector2.prototype.divideInPlace = function (otherVector) {
            return this.divideToRef(otherVector, this);
        };
        /**
         * Gets a new Vector2 with current Vector2 negated coordinates
         * @returns a new Vector2
         */
        Vector2.prototype.negate = function () {
            return new Vector2(-this.x, -this.y);
        };
        /**
         * Multiply the Vector2 coordinates by scale
         * @param scale defines the scaling factor
         * @returns the current updated Vector2
         */
        Vector2.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            return this;
        };
        /**
         * Returns a new Vector2 scaled by "scale" from the current Vector2
         * @param scale defines the scaling factor
         * @returns a new Vector2
         */
        Vector2.prototype.scale = function (scale) {
            var result = new Vector2(0, 0);
            this.scaleToRef(scale, result);
            return result;
        };
        /**
         * Scale the current Vector2 values by a factor to a given Vector2
         * @param scale defines the scale factor
         * @param result defines the Vector2 object where to store the result
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            return this;
        };
        /**
         * Scale the current Vector2 values by a factor and add the result to a given Vector2
         * @param scale defines the scale factor
         * @param result defines the Vector2 object where to store the result
         * @returns the unmodified current Vector2
         */
        Vector2.prototype.scaleAndAddToRef = function (scale, result) {
            result.x += this.x * scale;
            result.y += this.y * scale;
            return this;
        };
        /**
         * Gets a boolean if two vectors are equals
         * @param otherVector defines the other vector
         * @returns true if the given vector coordinates strictly equal the current Vector2 ones
         */
        Vector2.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y;
        };
        /**
         * Gets a boolean if two vectors are equals (using an epsilon value)
         * @param otherVector defines the other vector
         * @param epsilon defines the minimal distance to consider equality
         * @returns true if the given vector coordinates are close to the current ones by a distance of epsilon.
         */
        Vector2.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon) && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon);
        };
        // Properties
        /**
         * Gets the length of the vector
         * @returns the vector length (float)
         */
        Vector2.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        };
        /**
         * Gets the vector squared length
         * @returns the vector squared length (float)
         */
        Vector2.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y);
        };
        // Methods
        /**
         * Normalize the vector
         * @returns the current updated Vector2
         */
        Vector2.prototype.normalize = function () {
            var len = this.length();
            if (len === 0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            return this;
        };
        /**
         * Gets a new Vector2 copied from the Vector2
         * @returns a new Vector2
         */
        Vector2.prototype.clone = function () {
            return new Vector2(this.x, this.y);
        };
        // Statics
        /**
         * Gets a new Vector2(0, 0)
         * @returns a new Vector2
         */
        Vector2.Zero = function () {
            return new Vector2(0, 0);
        };
        /**
         * Gets a new Vector2(1, 1)
         * @returns a new Vector2
         */
        Vector2.One = function () {
            return new Vector2(1, 1);
        };
        /**
         * Gets a new Vector2 set from the given index element of the given array
         * @param array defines the data source
         * @param offset defines the offset in the data source
         * @returns a new Vector2
         */
        Vector2.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Vector2(array[offset], array[offset + 1]);
        };
        /**
         * Sets "result" from the given index element of the given array
         * @param array defines the data source
         * @param offset defines the offset in the data source
         * @param result defines the target vector
         */
        Vector2.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
        };
        /**
         * Gets a new Vector2 located for "amount" (float) on the CatmullRom spline defined by the given four Vector2
         * @param value1 defines 1st point of control
         * @param value2 defines 2nd point of control
         * @param value3 defines 3rd point of control
         * @param value4 defines 4th point of control
         * @param amount defines the interpolation factor
         * @returns a new Vector2
         */
        Vector2.CatmullRom = function (value1, value2, value3, value4, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var x = 0.5 * ((((2.0 * value2.x) + ((-value1.x + value3.x) * amount)) +
                (((((2.0 * value1.x) - (5.0 * value2.x)) + (4.0 * value3.x)) - value4.x) * squared)) +
                ((((-value1.x + (3.0 * value2.x)) - (3.0 * value3.x)) + value4.x) * cubed));
            var y = 0.5 * ((((2.0 * value2.y) + ((-value1.y + value3.y) * amount)) +
                (((((2.0 * value1.y) - (5.0 * value2.y)) + (4.0 * value3.y)) - value4.y) * squared)) +
                ((((-value1.y + (3.0 * value2.y)) - (3.0 * value3.y)) + value4.y) * cubed));
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 set with same the coordinates than "value" ones if the vector "value" is in the square defined by "min" and "max".
         * If a coordinate of "value" is lower than "min" coordinates, the returned Vector2 is given this "min" coordinate.
         * If a coordinate of "value" is greater than "max" coordinates, the returned Vector2 is given this "max" coordinate
         * @param value defines the value to clamp
         * @param min defines the lower limit
         * @param max defines the upper limit
         * @returns a new Vector2
         */
        Vector2.Clamp = function (value, min, max) {
            var x = value.x;
            x = (x > max.x) ? max.x : x;
            x = (x < min.x) ? min.x : x;
            var y = value.y;
            y = (y > max.y) ? max.y : y;
            y = (y < min.y) ? min.y : y;
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 located for "amount" (float) on the Hermite spline defined by the vectors "value1", "value3", "tangent1", "tangent2"
         * @param value1 defines the 1st control point
         * @param tangent1 defines the outgoing tangent
         * @param value2 defines the 2nd control point
         * @param tangent2 defines the incoming tangent
         * @param amount defines the interpolation factor
         * @returns a new Vector2
         */
        Vector2.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 located for "amount" (float) on the linear interpolation between the vector "start" adn the vector "end".
         * @param start defines the start vector
         * @param end defines the end vector
         * @param amount defines the interpolation factor
         * @returns a new Vector2
         */
        Vector2.Lerp = function (start, end, amount) {
            var x = start.x + ((end.x - start.x) * amount);
            var y = start.y + ((end.y - start.y) * amount);
            return new Vector2(x, y);
        };
        /**
         * Gets the dot product of the vector "left" and the vector "right"
         * @param left defines first vector
         * @param right defines second vector
         * @returns the dot product (float)
         */
        Vector2.Dot = function (left, right) {
            return left.x * right.x + left.y * right.y;
        };
        /**
         * Returns a new Vector2 equal to the normalized given vector
         * @param vector defines the vector to normalize
         * @returns a new Vector2
         */
        Vector2.Normalize = function (vector) {
            var newVector = vector.clone();
            newVector.normalize();
            return newVector;
        };
        /**
         * Gets a new Vector2 set with the minimal coordinate values from the "left" and "right" vectors
         * @param left defines 1st vector
         * @param right defines 2nd vector
         * @returns a new Vector2
         */
        Vector2.Minimize = function (left, right) {
            var x = (left.x < right.x) ? left.x : right.x;
            var y = (left.y < right.y) ? left.y : right.y;
            return new Vector2(x, y);
        };
        /**
         * Gets a new Vecto2 set with the maximal coordinate values from the "left" and "right" vectors
         * @param left defines 1st vector
         * @param right defines 2nd vector
         * @returns a new Vector2
         */
        Vector2.Maximize = function (left, right) {
            var x = (left.x > right.x) ? left.x : right.x;
            var y = (left.y > right.y) ? left.y : right.y;
            return new Vector2(x, y);
        };
        /**
         * Gets a new Vector2 set with the transformed coordinates of the given vector by the given transformation matrix
         * @param vector defines the vector to transform
         * @param transformation defines the matrix to apply
         * @returns a new Vector2
         */
        Vector2.Transform = function (vector, transformation) {
            var r = Vector2.Zero();
            Vector2.TransformToRef(vector, transformation, r);
            return r;
        };
        /**
         * Transforms the given vector coordinates by the given transformation matrix and stores the result in the vector "result" coordinates
         * @param vector defines the vector to transform
         * @param transformation defines the matrix to apply
         * @param result defines the target vector
         */
        Vector2.TransformToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + transformation.m[12];
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + transformation.m[13];
            result.x = x;
            result.y = y;
        };
        /**
         * Determines if a given vector is included in a triangle
         * @param p defines the vector to test
         * @param p0 defines 1st triangle point
         * @param p1 defines 2nd triangle point
         * @param p2 defines 3rd triangle point
         * @returns true if the point "p" is in the triangle defined by the vertors "p0", "p1", "p2"
         */
        Vector2.PointInTriangle = function (p, p0, p1, p2) {
            var a = 1 / 2 * (-p1.y * p2.x + p0.y * (-p1.x + p2.x) + p0.x * (p1.y - p2.y) + p1.x * p2.y);
            var sign = a < 0 ? -1 : 1;
            var s = (p0.y * p2.x - p0.x * p2.y + (p2.y - p0.y) * p.x + (p0.x - p2.x) * p.y) * sign;
            var t = (p0.x * p1.y - p0.y * p1.x + (p0.y - p1.y) * p.x + (p1.x - p0.x) * p.y) * sign;
            return s > 0 && t > 0 && (s + t) < 2 * a * sign;
        };
        /**
         * Gets the distance between the vectors "value1" and "value2"
         * @param value1 defines first vector
         * @param value2 defines second vector
         * @returns the distance between vectors
         */
        Vector2.Distance = function (value1, value2) {
            return Math.sqrt(Vector2.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance between the vectors "value1" and "value2"
         * @param value1 defines first vector
         * @param value2 defines second vector
         * @returns the squared distance between vectors
         */
        Vector2.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            return (x * x) + (y * y);
        };
        /**
         * Gets a new Vector2 located at the center of the vectors "value1" and "value2"
         * @param value1 defines first vector
         * @param value2 defines second vector
         * @returns a new Vector2
         */
        Vector2.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Gets the shortest distance (float) between the point "p" and the segment defined by the two points "segA" and "segB".
         * @param p defines the middle point
         * @param segA defines one point of the segment
         * @param segB defines the other point of the segment
         * @returns the shortest distance
         */
        Vector2.DistanceOfPointFromSegment = function (p, segA, segB) {
            var l2 = Vector2.DistanceSquared(segA, segB);
            if (l2 === 0.0) {
                return Vector2.Distance(p, segA);
            }
            var v = segB.subtract(segA);
            var t = Math.max(0, Math.min(1, Vector2.Dot(p.subtract(segA), v) / l2));
            var proj = segA.add(v.multiplyByFloats(t, t));
            return Vector2.Distance(p, proj);
        };
        return Vector2;
    }());
    BABYLON.Vector2 = Vector2;
    /**
     * Classed used to store (x,y,z) vector representation
     * A Vector3 is the main object used in 3D geometry
     * It can represent etiher the coordinates of a point the space, either a direction
     * Reminder: Babylon.js uses a left handed forward facing system
     */
    var Vector3 = /** @class */ (function () {
        /**
         * Creates a new Vector3 object from the given x, y, z (floats) coordinates.
         * @param x defines the first coordinates (on X axis)
         * @param y defines the second coordinates (on Y axis)
         * @param z defines the third coordinates (on Z axis)
         */
        function Vector3(
        /**
         * Defines the first coordinates (on X axis)
         */
        x, 
        /**
         * Defines the second coordinates (on Y axis)
         */
        y, 
        /**
         * Defines the third coordinates (on Z axis)
         */
        z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        /**
         * Creates a string representation of the Vector3
         * @returns a string with the Vector3 coordinates.
         */
        Vector3.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + "}";
        };
        /**
         * Gets the class name
         * @returns the string "Vector3"
         */
        Vector3.prototype.getClassName = function () {
            return "Vector3";
        };
        /**
         * Creates the Vector3 hash code
         * @returns a number which tends to be unique between Vector3 instances
         */
        Vector3.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            return hash;
        };
        // Operators
        /**
         * Creates an array containing three elements : the coordinates of the Vector3
         * @returns a new array of numbers
         */
        Vector3.prototype.asArray = function () {
            var result = [];
            this.toArray(result, 0);
            return result;
        };
        /**
         * Populates the given array or Float32Array from the given index with the successive coordinates of the Vector3
         * @param array defines the destination array
         * @param index defines the offset in the destination array
         * @returns the current Vector3
         */
        Vector3.prototype.toArray = function (array, index) {
            if (index === void 0) { index = 0; }
            array[index] = this.x;
            array[index + 1] = this.y;
            array[index + 2] = this.z;
            return this;
        };
        /**
         * Converts the current Vector3 into a quaternion (considering that the Vector3 contains Euler angles representation of a rotation)
         * @returns a new Quaternion object, computed from the Vector3 coordinates
         */
        Vector3.prototype.toQuaternion = function () {
            return BABYLON.Quaternion.RotationYawPitchRoll(this.x, this.y, this.z);
        };
        /**
         * Adds the given vector to the current Vector3
         * @param otherVector defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            this.z += otherVector.z;
            return this;
        };
        /**
         * Gets a new Vector3, result of the addition the current Vector3 and the given vector
         * @param otherVector defines the second operand
         * @returns the resulting Vector3
         */
        Vector3.prototype.add = function (otherVector) {
            return new Vector3(this.x + otherVector.x, this.y + otherVector.y, this.z + otherVector.z);
        };
        /**
         * Adds the current Vector3 to the given one and stores the result in the vector "result"
         * @param otherVector defines the second operand
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            result.z = this.z + otherVector.z;
            return this;
        };
        /**
         * Subtract the given vector from the current Vector3
         * @param otherVector defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            this.z -= otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3, result of the subtraction of the given vector from the current Vector3
         * @param otherVector defines the second operand
         * @returns the resulting Vector3
         */
        Vector3.prototype.subtract = function (otherVector) {
            return new Vector3(this.x - otherVector.x, this.y - otherVector.y, this.z - otherVector.z);
        };
        /**
         * Subtracts the given vector from the current Vector3 and stores the result in the vector "result".
         * @param otherVector defines the second operand
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            result.z = this.z - otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3 set with the subtraction of the given floats from the current Vector3 coordinates
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @returns the resulting Vector3
         */
        Vector3.prototype.subtractFromFloats = function (x, y, z) {
            return new Vector3(this.x - x, this.y - y, this.z - z);
        };
        /**
         * Subtracts the given floats from the current Vector3 coordinates and set the given vector "result" with this result
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.subtractFromFloatsToRef = function (x, y, z, result) {
            result.x = this.x - x;
            result.y = this.y - y;
            result.z = this.z - z;
            return this;
        };
        /**
         * Gets a new Vector3 set with the current Vector3 negated coordinates
         * @returns a new Vector3
         */
        Vector3.prototype.negate = function () {
            return new Vector3(-this.x, -this.y, -this.z);
        };
        /**
         * Multiplies the Vector3 coordinates by the float "scale"
         * @param scale defines the multiplier factor
         * @returns the current updated Vector3
         */
        Vector3.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            this.z *= scale;
            return this;
        };
        /**
         * Returns a new Vector3 set with the current Vector3 coordinates multiplied by the float "scale"
         * @param scale defines the multiplier factor
         * @returns a new Vector3
         */
        Vector3.prototype.scale = function (scale) {
            return new Vector3(this.x * scale, this.y * scale, this.z * scale);
        };
        /**
         * Multiplies the current Vector3 coordinates by the float "scale" and stores the result in the given vector "result" coordinates
         * @param scale defines the multiplier factor
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            result.z = this.z * scale;
            return this;
        };
        /**
         * Scale the current Vector3 values by a factor and add the result to a given Vector3
         * @param scale defines the scale factor
         * @param result defines the Vector3 object where to store the result
         * @returns the unmodified current Vector3
         */
        Vector3.prototype.scaleAndAddToRef = function (scale, result) {
            result.x += this.x * scale;
            result.y += this.y * scale;
            result.z += this.z * scale;
            return this;
        };
        /**
         * Returns true if the current Vector3 and the given vector coordinates are strictly equal
         * @param otherVector defines the second operand
         * @returns true if both vectors are equals
         */
        Vector3.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y && this.z === otherVector.z;
        };
        /**
         * Returns true if the current Vector3 and the given vector coordinates are distant less than epsilon
         * @param otherVector defines the second operand
         * @param epsilon defines the minimal distance to define values as equals
         * @returns true if both vectors are distant less than epsilon
         */
        Vector3.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon) && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon) && BABYLON.Scalar.WithinEpsilon(this.z, otherVector.z, epsilon);
        };
        /**
         * Returns true if the current Vector3 coordinates equals the given floats
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @returns true if both vectors are equals
         */
        Vector3.prototype.equalsToFloats = function (x, y, z) {
            return this.x === x && this.y === y && this.z === z;
        };
        /**
         * Multiplies the current Vector3 coordinates by the given ones
         * @param otherVector defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            this.z *= otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3, result of the multiplication of the current Vector3 by the given vector
         * @param otherVector defines the second operand
         * @returns the new Vector3
         */
        Vector3.prototype.multiply = function (otherVector) {
            return new Vector3(this.x * otherVector.x, this.y * otherVector.y, this.z * otherVector.z);
        };
        /**
         * Multiplies the current Vector3 by the given one and stores the result in the given vector "result"
         * @param otherVector defines the second operand
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            result.z = this.z * otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3 set with the result of the mulliplication of the current Vector3 coordinates by the given floats
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @returns the new Vector3
         */
        Vector3.prototype.multiplyByFloats = function (x, y, z) {
            return new Vector3(this.x * x, this.y * y, this.z * z);
        };
        /**
         * Returns a new Vector3 set with the result of the division of the current Vector3 coordinates by the given ones
         * @param otherVector defines the second operand
         * @returns the new Vector3
         */
        Vector3.prototype.divide = function (otherVector) {
            return new Vector3(this.x / otherVector.x, this.y / otherVector.y, this.z / otherVector.z);
        };
        /**
         * Divides the current Vector3 coordinates by the given ones and stores the result in the given vector "result"
         * @param otherVector defines the second operand
         * @param result defines the Vector3 object where to store the result
         * @returns the current Vector3
         */
        Vector3.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            result.z = this.z / otherVector.z;
            return this;
        };
        /**
         * Divides the current Vector3 coordinates by the given ones.
         * @param otherVector defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.divideInPlace = function (otherVector) {
            return this.divideToRef(otherVector, this);
        };
        /**
         * Updates the current Vector3 with the minimal coordinate values between its and the given vector ones
         * @param other defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.minimizeInPlace = function (other) {
            if (other.x < this.x)
                this.x = other.x;
            if (other.y < this.y)
                this.y = other.y;
            if (other.z < this.z)
                this.z = other.z;
            return this;
        };
        /**
         * Updates the current Vector3 with the maximal coordinate values between its and the given vector ones.
         * @param other defines the second operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.maximizeInPlace = function (other) {
            if (other.x > this.x)
                this.x = other.x;
            if (other.y > this.y)
                this.y = other.y;
            if (other.z > this.z)
                this.z = other.z;
            return this;
        };
        Object.defineProperty(Vector3.prototype, "isNonUniform", {
            /**
             * Gets a boolean indicating that the vector is non uniform meaning x, y or z are not all the same
             */
            get: function () {
                var absX = Math.abs(this.x);
                var absY = Math.abs(this.y);
                if (absX !== absY) {
                    return true;
                }
                var absZ = Math.abs(this.z);
                if (absX !== absZ) {
                    return true;
                }
                if (absY !== absZ) {
                    return true;
                }
                return false;
            },
            enumerable: true,
            configurable: true
        });
        // Properties
        /**
         * Gets the length of the Vector3
         * @returns the length of the Vecto3
         */
        Vector3.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        };
        /**
         * Gets the squared length of the Vector3
         * @returns squared length of the Vector3
         */
        Vector3.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y + this.z * this.z);
        };
        /**
         * Normalize the current Vector3.
         * Please note that this is an in place operation.
         * @returns the current updated Vector3
         */
        Vector3.prototype.normalize = function () {
            var len = this.length();
            if (len === 0 || len === 1.0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            this.z *= num;
            return this;
        };
        /**
         * Normalize the current Vector3 to a new vector
         * @returns the new Vector3
         */
        Vector3.prototype.normalizeToNew = function () {
            var normalized = new Vector3(0, 0, 0);
            this.normalizeToRef(normalized);
            return normalized;
        };
        /**
         * Normalize the current Vector3 to the reference
         * @param reference define the Vector3 to update
         * @returns the updated Vector3
         */
        Vector3.prototype.normalizeToRef = function (reference) {
            var len = this.length();
            if (len === 0 || len === 1.0) {
                reference.set(this.x, this.y, this.z);
                return reference;
            }
            var scale = 1.0 / len;
            this.scaleToRef(scale, reference);
            return reference;
        };
        /**
         * Creates a new Vector3 copied from the current Vector3
         * @returns the new Vector3
         */
        Vector3.prototype.clone = function () {
            return new Vector3(this.x, this.y, this.z);
        };
        /**
         * Copies the given vector coordinates to the current Vector3 ones
         * @param source defines the source Vector3
         * @returns the current updated Vector3
         */
        Vector3.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            return this;
        };
        /**
         * Copies the given floats to the current Vector3 coordinates
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.copyFromFloats = function (x, y, z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        };
        /**
         * Copies the given floats to the current Vector3 coordinates
         * @param x defines the x coordinate of the operand
         * @param y defines the y coordinate of the operand
         * @param z defines the z coordinate of the operand
         * @returns the current updated Vector3
         */
        Vector3.prototype.set = function (x, y, z) {
            return this.copyFromFloats(x, y, z);
        };
        // Statics
        /**
         * Get the clip factor between two vectors
         * @param vector0 defines the first operand
         * @param vector1 defines the second operand
         * @param axis defines the axis to use
         * @param size defines the size along the axis
         * @returns the clip factor
         */
        Vector3.GetClipFactor = function (vector0, vector1, axis, size) {
            var d0 = Vector3.Dot(vector0, axis) - size;
            var d1 = Vector3.Dot(vector1, axis) - size;
            var s = d0 / (d0 - d1);
            return s;
        };
        /**
         * Get angle between two vectors
         * @param vector0 angle between vector0 and vector1
         * @param vector1 angle between vector0 and vector1
         * @param normal direction of the normal
         * @return the angle between vector0 and vector1
         */
        Vector3.GetAngleBetweenVectors = function (vector0, vector1, normal) {
            var v0 = vector0.clone().normalize();
            var v1 = vector1.clone().normalize();
            var dot = Vector3.Dot(v0, v1);
            var n = Vector3.Cross(v0, v1);
            if (Vector3.Dot(n, normal) > 0) {
                return Math.acos(dot);
            }
            return -Math.acos(dot);
        };
        /**
         * Returns a new Vector3 set from the index "offset" of the given array
         * @param array defines the source array
         * @param offset defines the offset in the source array
         * @returns the new Vector3
         */
        Vector3.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Vector3(array[offset], array[offset + 1], array[offset + 2]);
        };
        /**
         * Returns a new Vector3 set from the index "offset" of the given Float32Array
         * This function is deprecated.  Use FromArray instead
         * @param array defines the source array
         * @param offset defines the offset in the source array
         * @returns the new Vector3
         */
        Vector3.FromFloatArray = function (array, offset) {
            return Vector3.FromArray(array, offset);
        };
        /**
         * Sets the given vector "result" with the element values from the index "offset" of the given array
         * @param array defines the source array
         * @param offset defines the offset in the source array
         * @param result defines the Vector3 where to store the result
         */
        Vector3.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
            result.z = array[offset + 2];
        };
        /**
         * Sets the given vector "result" with the element values from the index "offset" of the given Float32Array
         * This function is deprecated.  Use FromArrayToRef instead.
         * @param array defines the source array
         * @param offset defines the offset in the source array
         * @param result defines the Vector3 where to store the result
         */
        Vector3.FromFloatArrayToRef = function (array, offset, result) {
            return Vector3.FromArrayToRef(array, offset, result);
        };
        /**
         * Sets the given vector "result" with the given floats.
         * @param x defines the x coordinate of the source
         * @param y defines the y coordinate of the source
         * @param z defines the z coordinate of the source
         * @param result defines the Vector3 where to store the result
         */
        Vector3.FromFloatsToRef = function (x, y, z, result) {
            result.x = x;
            result.y = y;
            result.z = z;
        };
        /**
         * Returns a new Vector3 set to (0.0, 0.0, 0.0)
         * @returns a new empty Vector3
         */
        Vector3.Zero = function () {
            return new Vector3(0.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (1.0, 1.0, 1.0)
         * @returns a new unit Vector3
         */
        Vector3.One = function () {
            return new Vector3(1.0, 1.0, 1.0);
        };
        /**
         * Returns a new Vector3 set to (0.0, 1.0, 0.0)
         * @returns a new up Vector3
         */
        Vector3.Up = function () {
            return new Vector3(0.0, 1.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (0.0, 0.0, 1.0)
         * @returns a new forward Vector3
         */
        Vector3.Forward = function () {
            return new Vector3(0.0, 0.0, 1.0);
        };
        /**
         * Returns a new Vector3 set to (1.0, 0.0, 0.0)
         * @returns a new right Vector3
         */
        Vector3.Right = function () {
            return new Vector3(1.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (-1.0, 0.0, 0.0)
         * @returns a new left Vector3
         */
        Vector3.Left = function () {
            return new Vector3(-1.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set with the result of the transformation by the given matrix of the given vector.
         * This method computes tranformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
         * @param vector defines the Vector3 to transform
         * @param transformation defines the transformation matrix
         * @returns the transformed Vector3
         */
        Vector3.TransformCoordinates = function (vector, transformation) {
            var result = Vector3.Zero();
            Vector3.TransformCoordinatesToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given vector
         * This method computes tranformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
         * @param vector defines the Vector3 to transform
         * @param transformation defines the transformation matrix
         * @param result defines the Vector3 where to store the result
         */
        Vector3.TransformCoordinatesToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]) + transformation.m[12];
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]) + transformation.m[13];
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]) + transformation.m[14];
            var w = (vector.x * transformation.m[3]) + (vector.y * transformation.m[7]) + (vector.z * transformation.m[11]) + transformation.m[15];
            result.x = x / w;
            result.y = y / w;
            result.z = z / w;
        };
        /**
         * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given floats (x, y, z)
         * This method computes tranformed coordinates only, not transformed direction vectors
         * @param x define the x coordinate of the source vector
         * @param y define the y coordinate of the source vector
         * @param z define the z coordinate of the source vector
         * @param transformation defines the transformation matrix
         * @param result defines the Vector3 where to store the result
         */
        Vector3.TransformCoordinatesFromFloatsToRef = function (x, y, z, transformation, result) {
            var rx = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]) + transformation.m[12];
            var ry = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]) + transformation.m[13];
            var rz = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]) + transformation.m[14];
            var rw = (x * transformation.m[3]) + (y * transformation.m[7]) + (z * transformation.m[11]) + transformation.m[15];
            result.x = rx / rw;
            result.y = ry / rw;
            result.z = rz / rw;
        };
        /**
         * Returns a new Vector3 set with the result of the normal transformation by the given matrix of the given vector
         * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
         * @param vector defines the Vector3 to transform
         * @param transformation defines the transformation matrix
         * @returns the new Vector3
         */
        Vector3.TransformNormal = function (vector, transformation) {
            var result = Vector3.Zero();
            Vector3.TransformNormalToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given vector
         * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
         * @param vector defines the Vector3 to transform
         * @param transformation defines the transformation matrix
         * @param result defines the Vector3 where to store the result
         */
        Vector3.TransformNormalToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]);
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]);
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]);
            result.x = x;
            result.y = y;
            result.z = z;
        };
        /**
         * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given floats (x, y, z)
         * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
         * @param x define the x coordinate of the source vector
         * @param y define the y coordinate of the source vector
         * @param z define the z coordinate of the source vector
         * @param transformation defines the transformation matrix
         * @param result defines the Vector3 where to store the result
         */
        Vector3.TransformNormalFromFloatsToRef = function (x, y, z, transformation, result) {
            result.x = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]);
            result.y = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]);
            result.z = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]);
        };
        /**
         * Returns a new Vector3 located for "amount" on the CatmullRom interpolation spline defined by the vectors "value1", "value2", "value3", "value4"
         * @param value1 defines the first control point
         * @param value2 defines the second control point
         * @param value3 defines the third control point
         * @param value4 defines the fourth control point
         * @param amount defines the amount on the spline to use
         * @returns the new Vector3
         */
        Vector3.CatmullRom = function (value1, value2, value3, value4, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var x = 0.5 * ((((2.0 * value2.x) + ((-value1.x + value3.x) * amount)) +
                (((((2.0 * value1.x) - (5.0 * value2.x)) + (4.0 * value3.x)) - value4.x) * squared)) +
                ((((-value1.x + (3.0 * value2.x)) - (3.0 * value3.x)) + value4.x) * cubed));
            var y = 0.5 * ((((2.0 * value2.y) + ((-value1.y + value3.y) * amount)) +
                (((((2.0 * value1.y) - (5.0 * value2.y)) + (4.0 * value3.y)) - value4.y) * squared)) +
                ((((-value1.y + (3.0 * value2.y)) - (3.0 * value3.y)) + value4.y) * cubed));
            var z = 0.5 * ((((2.0 * value2.z) + ((-value1.z + value3.z) * amount)) +
                (((((2.0 * value1.z) - (5.0 * value2.z)) + (4.0 * value3.z)) - value4.z) * squared)) +
                ((((-value1.z + (3.0 * value2.z)) - (3.0 * value3.z)) + value4.z) * cubed));
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 set with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max"
         * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
         * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
         * @param value defines the current value
         * @param min defines the lower range value
         * @param max defines the upper range value
         * @returns the new Vector3
         */
        Vector3.Clamp = function (value, min, max) {
            var x = value.x;
            x = (x > max.x) ? max.x : x;
            x = (x < min.x) ? min.x : x;
            var y = value.y;
            y = (y > max.y) ? max.y : y;
            y = (y < min.y) ? min.y : y;
            var z = value.z;
            z = (z > max.z) ? max.z : z;
            z = (z < min.z) ? min.z : z;
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 located for "amount" (float) on the Hermite interpolation spline defined by the vectors "value1", "tangent1", "value2", "tangent2"
         * @param value1 defines the first control point
         * @param tangent1 defines the first tangent vector
         * @param value2 defines the second control point
         * @param tangent2 defines the second tangent vector
         * @param amount defines the amount on the interpolation spline (between 0 and 1)
         * @returns the new Vector3
         */
        Vector3.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            var z = (((value1.z * part1) + (value2.z * part2)) + (tangent1.z * part3)) + (tangent2.z * part4);
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 located for "amount" (float) on the linear interpolation between the vectors "start" and "end"
         * @param start defines the start value
         * @param end defines the end value
         * @param amount max defines amount between both (between 0 and 1)
         * @returns the new Vector3
         */
        Vector3.Lerp = function (start, end, amount) {
            var result = new Vector3(0, 0, 0);
            Vector3.LerpToRef(start, end, amount, result);
            return result;
        };
        /**
         * Sets the given vector "result" with the result of the linear interpolation from the vector "start" for "amount" to the vector "end"
         * @param start defines the start value
         * @param end defines the end value
         * @param amount max defines amount between both (between 0 and 1)
         * @param result defines the Vector3 where to store the result
         */
        Vector3.LerpToRef = function (start, end, amount, result) {
            result.x = start.x + ((end.x - start.x) * amount);
            result.y = start.y + ((end.y - start.y) * amount);
            result.z = start.z + ((end.z - start.z) * amount);
        };
        /**
         * Returns the dot product (float) between the vectors "left" and "right"
         * @param left defines the left operand
         * @param right defines the right operand
         * @returns the dot product
         */
        Vector3.Dot = function (left, right) {
            return (left.x * right.x + left.y * right.y + left.z * right.z);
        };
        /**
         * Returns a new Vector3 as the cross product of the vectors "left" and "right"
         * The cross product is then orthogonal to both "left" and "right"
         * @param left defines the left operand
         * @param right defines the right operand
         * @returns the cross product
         */
        Vector3.Cross = function (left, right) {
            var result = Vector3.Zero();
            Vector3.CrossToRef(left, right, result);
            return result;
        };
        /**
         * Sets the given vector "result" with the cross product of "left" and "right"
         * The cross product is then orthogonal to both "left" and "right"
         * @param left defines the left operand
         * @param right defines the right operand
         * @param result defines the Vector3 where to store the result
         */
        Vector3.CrossToRef = function (left, right, result) {
            MathTmp.Vector3[0].x = left.y * right.z - left.z * right.y;
            MathTmp.Vector3[0].y = left.z * right.x - left.x * right.z;
            MathTmp.Vector3[0].z = left.x * right.y - left.y * right.x;
            result.copyFrom(MathTmp.Vector3[0]);
        };
        /**
         * Returns a new Vector3 as the normalization of the given vector
         * @param vector defines the Vector3 to normalize
         * @returns the new Vector3
         */
        Vector3.Normalize = function (vector) {
            var result = Vector3.Zero();
            Vector3.NormalizeToRef(vector, result);
            return result;
        };
        /**
         * Sets the given vector "result" with the normalization of the given first vector
         * @param vector defines the Vector3 to normalize
         * @param result defines the Vector3 where to store the result
         */
        Vector3.NormalizeToRef = function (vector, result) {
            result.copyFrom(vector);
            result.normalize();
        };
        /**
         * Project a Vector3 onto screen space
         * @param vector defines the Vector3 to project
         * @param world defines the world matrix to use
         * @param transform defines the transform (view x projection) matrix to use
         * @param viewport defines the screen viewport to use
         * @returns the new Vector3
         */
        Vector3.Project = function (vector, world, transform, viewport) {
            var cw = viewport.width;
            var ch = viewport.height;
            var cx = viewport.x;
            var cy = viewport.y;
            var viewportMatrix = Vector3._viewportMatrixCache ? Vector3._viewportMatrixCache : (Vector3._viewportMatrixCache = new Matrix());
            Matrix.FromValuesToRef(cw / 2.0, 0, 0, 0, 0, -ch / 2.0, 0, 0, 0, 0, 0.5, 0, cx + cw / 2.0, ch / 2.0 + cy, 0.5, 1, viewportMatrix);
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(transform, matrix);
            matrix.multiplyToRef(viewportMatrix, matrix);
            return Vector3.TransformCoordinates(vector, matrix);
        };
        /**
         * Unproject from screen space to object space
         * @param source defines the screen space Vector3 to use
         * @param viewportWidth defines the current width of the viewport
         * @param viewportHeight defines the current height of the viewport
         * @param world defines the world matrix to use (can be set to Identity to go to world space)
         * @param transform defines the transform (view x projection) matrix to use
         * @returns the new Vector3
         */
        Vector3.UnprojectFromTransform = function (source, viewportWidth, viewportHeight, world, transform) {
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(transform, matrix);
            matrix.invert();
            source.x = source.x / viewportWidth * 2 - 1;
            source.y = -(source.y / viewportHeight * 2 - 1);
            var vector = Vector3.TransformCoordinates(source, matrix);
            var num = source.x * matrix.m[3] + source.y * matrix.m[7] + source.z * matrix.m[11] + matrix.m[15];
            if (BABYLON.Scalar.WithinEpsilon(num, 1.0)) {
                vector = vector.scale(1.0 / num);
            }
            return vector;
        };
        /**
         * Unproject from screen space to object space
         * @param source defines the screen space Vector3 to use
         * @param viewportWidth defines the current width of the viewport
         * @param viewportHeight defines the current height of the viewport
         * @param world defines the world matrix to use (can be set to Identity to go to world space)
         * @param view defines the view matrix to use
         * @param projection defines the projection matrix to use
         * @returns the new Vector3
         */
        Vector3.Unproject = function (source, viewportWidth, viewportHeight, world, view, projection) {
            var result = Vector3.Zero();
            Vector3.UnprojectToRef(source, viewportWidth, viewportHeight, world, view, projection, result);
            return result;
        };
        /**
         * Unproject from screen space to object space
         * @param source defines the screen space Vector3 to use
         * @param viewportWidth defines the current width of the viewport
         * @param viewportHeight defines the current height of the viewport
         * @param world defines the world matrix to use (can be set to Identity to go to world space)
         * @param view defines the view matrix to use
         * @param projection defines the projection matrix to use
         * @param result defines the Vector3 where to store the result
         */
        Vector3.UnprojectToRef = function (source, viewportWidth, viewportHeight, world, view, projection, result) {
            Vector3.UnprojectFloatsToRef(source.x, source.y, source.z, viewportWidth, viewportHeight, world, view, projection, result);
        };
        /**
         * Unproject from screen space to object space
         * @param sourceX defines the screen space x coordinate to use
         * @param sourceY defines the screen space y coordinate to use
         * @param sourceZ defines the screen space z coordinate to use
         * @param viewportWidth defines the current width of the viewport
         * @param viewportHeight defines the current height of the viewport
         * @param world defines the world matrix to use (can be set to Identity to go to world space)
         * @param view defines the view matrix to use
         * @param projection defines the projection matrix to use
         * @param result defines the Vector3 where to store the result
         */
        Vector3.UnprojectFloatsToRef = function (sourceX, sourceY, sourceZ, viewportWidth, viewportHeight, world, view, projection, result) {
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(view, matrix);
            matrix.multiplyToRef(projection, matrix);
            matrix.invert();
            var screenSource = MathTmp.Vector3[0];
            screenSource.x = sourceX / viewportWidth * 2 - 1;
            screenSource.y = -(sourceY / viewportHeight * 2 - 1);
            screenSource.z = 2 * sourceZ - 1.0;
            Vector3.TransformCoordinatesToRef(screenSource, matrix, result);
            var num = screenSource.x * matrix.m[3] + screenSource.y * matrix.m[7] + screenSource.z * matrix.m[11] + matrix.m[15];
            if (BABYLON.Scalar.WithinEpsilon(num, 1.0)) {
                result.scaleInPlace(1.0 / num);
            }
        };
        /**
         * Gets the minimal coordinate values between two Vector3
         * @param left defines the first operand
         * @param right defines the second operand
         * @returns the new Vector3
         */
        Vector3.Minimize = function (left, right) {
            var min = left.clone();
            min.minimizeInPlace(right);
            return min;
        };
        /**
         * Gets the maximal coordinate values between two Vector3
         * @param left defines the first operand
         * @param right defines the second operand
         * @returns the new Vector3
         */
        Vector3.Maximize = function (left, right) {
            var max = left.clone();
            max.maximizeInPlace(right);
            return max;
        };
        /**
         * Returns the distance between the vectors "value1" and "value2"
         * @param value1 defines the first operand
         * @param value2 defines the second operand
         * @returns the distance
         */
        Vector3.Distance = function (value1, value2) {
            return Math.sqrt(Vector3.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance between the vectors "value1" and "value2"
         * @param value1 defines the first operand
         * @param value2 defines the second operand
         * @returns the squared distance
         */
        Vector3.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            var z = value1.z - value2.z;
            return (x * x) + (y * y) + (z * z);
        };
        /**
         * Returns a new Vector3 located at the center between "value1" and "value2"
         * @param value1 defines the first operand
         * @param value2 defines the second operand
         * @returns the new Vector3
         */
        Vector3.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Given three orthogonal normalized left-handed oriented Vector3 axis in space (target system),
         * RotationFromAxis() returns the rotation Euler angles (ex : rotation.x, rotation.y, rotation.z) to apply
         * to something in order to rotate it from its local system to the given target system
         * Note: axis1, axis2 and axis3 are normalized during this operation
         * @param axis1 defines the first axis
         * @param axis2 defines the second axis
         * @param axis3 defines the third axis
         * @returns a new Vector3
         */
        Vector3.RotationFromAxis = function (axis1, axis2, axis3) {
            var rotation = Vector3.Zero();
            Vector3.RotationFromAxisToRef(axis1, axis2, axis3, rotation);
            return rotation;
        };
        /**
         * The same than RotationFromAxis but updates the given ref Vector3 parameter instead of returning a new Vector3
         * @param axis1 defines the first axis
         * @param axis2 defines the second axis
         * @param axis3 defines the third axis
         * @param ref defines the Vector3 where to store the result
         */
        Vector3.RotationFromAxisToRef = function (axis1, axis2, axis3, ref) {
            var quat = MathTmp.Quaternion[0];
            Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
            quat.toEulerAnglesToRef(ref);
        };
        return Vector3;
    }());
    BABYLON.Vector3 = Vector3;
    //Vector4 class created for EulerAngle class conversion to Quaternion
    var Vector4 = /** @class */ (function () {
        /**
         * Creates a Vector4 object from the given floats.
         */
        function Vector4(x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        /**
         * Returns the string with the Vector4 coordinates.
         */
        Vector4.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + " W:" + this.w + "}";
        };
        /**
         * Returns the string "Vector4".
         */
        Vector4.prototype.getClassName = function () {
            return "Vector4";
        };
        /**
         * Returns the Vector4 hash code.
         */
        Vector4.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            hash = (hash * 397) ^ (this.w || 0);
            return hash;
        };
        // Operators
        /**
         * Returns a new array populated with 4 elements : the Vector4 coordinates.
         */
        Vector4.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Populates the given array from the given index with the Vector4 coordinates.
         * Returns the Vector4.
         */
        Vector4.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.x;
            array[index + 1] = this.y;
            array[index + 2] = this.z;
            array[index + 3] = this.w;
            return this;
        };
        /**
         * Adds the given vector to the current Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            this.z += otherVector.z;
            this.w += otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 as the result of the addition of the current Vector4 and the given one.
         */
        Vector4.prototype.add = function (otherVector) {
            return new Vector4(this.x + otherVector.x, this.y + otherVector.y, this.z + otherVector.z, this.w + otherVector.w);
        };
        /**
         * Updates the given vector "result" with the result of the addition of the current Vector4 and the given one.
         * Returns the current Vector4.
         */
        Vector4.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            result.z = this.z + otherVector.z;
            result.w = this.w + otherVector.w;
            return this;
        };
        /**
         * Subtract in place the given vector from the current Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            this.z -= otherVector.z;
            this.w -= otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 with the result of the subtraction of the given vector from the current Vector4.
         */
        Vector4.prototype.subtract = function (otherVector) {
            return new Vector4(this.x - otherVector.x, this.y - otherVector.y, this.z - otherVector.z, this.w - otherVector.w);
        };
        /**
         * Sets the given vector "result" with the result of the subtraction of the given vector from the current Vector4.
         * Returns the current Vector4.
         */
        Vector4.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            result.z = this.z - otherVector.z;
            result.w = this.w - otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the result of the subtraction of the given floats from the current Vector4 coordinates.
         */
        Vector4.prototype.subtractFromFloats = function (x, y, z, w) {
            return new Vector4(this.x - x, this.y - y, this.z - z, this.w - w);
        };
        /**
         * Sets the given vector "result" set with the result of the subtraction of the given floats from the current Vector4 coordinates.
         * Returns the current Vector4.
         */
        Vector4.prototype.subtractFromFloatsToRef = function (x, y, z, w, result) {
            result.x = this.x - x;
            result.y = this.y - y;
            result.z = this.z - z;
            result.w = this.w - w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the current Vector4 negated coordinates.
         */
        Vector4.prototype.negate = function () {
            return new Vector4(-this.x, -this.y, -this.z, -this.w);
        };
        /**
         * Multiplies the current Vector4 coordinates by scale (float).
         * Returns the updated Vector4.
         */
        Vector4.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            this.z *= scale;
            this.w *= scale;
            return this;
        };
        /**
         * Returns a new Vector4 set with the current Vector4 coordinates multiplied by scale (float).
         */
        Vector4.prototype.scale = function (scale) {
            return new Vector4(this.x * scale, this.y * scale, this.z * scale, this.w * scale);
        };
        /**
         * Sets the given vector "result" with the current Vector4 coordinates multiplied by scale (float).
         * Returns the current Vector4.
         */
        Vector4.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            result.z = this.z * scale;
            result.w = this.w * scale;
            return this;
        };
        /**
         * Scale the current Vector4 values by a factor and add the result to a given Vector4
         * @param scale defines the scale factor
         * @param result defines the Vector4 object where to store the result
         * @returns the unmodified current Vector4
         */
        Vector4.prototype.scaleAndAddToRef = function (scale, result) {
            result.x += this.x * scale;
            result.y += this.y * scale;
            result.z += this.z * scale;
            result.w += this.w * scale;
            return this;
        };
        /**
         * Boolean : True if the current Vector4 coordinates are stricly equal to the given ones.
         */
        Vector4.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y && this.z === otherVector.z && this.w === otherVector.w;
        };
        /**
         * Boolean : True if the current Vector4 coordinates are each beneath the distance "epsilon" from the given vector ones.
         */
        Vector4.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector
                && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.z, otherVector.z, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.w, otherVector.w, epsilon);
        };
        /**
         * Boolean : True if the given floats are strictly equal to the current Vector4 coordinates.
         */
        Vector4.prototype.equalsToFloats = function (x, y, z, w) {
            return this.x === x && this.y === y && this.z === z && this.w === w;
        };
        /**
         * Multiplies in place the current Vector4 by the given one.
         * Returns the updated Vector4.
         */
        Vector4.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            this.z *= otherVector.z;
            this.w *= otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the multiplication result of the current Vector4 and the given one.
         */
        Vector4.prototype.multiply = function (otherVector) {
            return new Vector4(this.x * otherVector.x, this.y * otherVector.y, this.z * otherVector.z, this.w * otherVector.w);
        };
        /**
         * Updates the given vector "result" with the multiplication result of the current Vector4 and the given one.
         * Returns the current Vector4.
         */
        Vector4.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            result.z = this.z * otherVector.z;
            result.w = this.w * otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the multiplication result of the given floats and the current Vector4 coordinates.
         */
        Vector4.prototype.multiplyByFloats = function (x, y, z, w) {
            return new Vector4(this.x * x, this.y * y, this.z * z, this.w * w);
        };
        /**
         * Returns a new Vector4 set with the division result of the current Vector4 by the given one.
         */
        Vector4.prototype.divide = function (otherVector) {
            return new Vector4(this.x / otherVector.x, this.y / otherVector.y, this.z / otherVector.z, this.w / otherVector.w);
        };
        /**
         * Updates the given vector "result" with the division result of the current Vector4 by the given one.
         * Returns the current Vector4.
         */
        Vector4.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            result.z = this.z / otherVector.z;
            result.w = this.w / otherVector.w;
            return this;
        };
        /**
         * Divides the current Vector3 coordinates by the given ones.
         * @returns the updated Vector3.
         */
        Vector4.prototype.divideInPlace = function (otherVector) {
            return this.divideToRef(otherVector, this);
        };
        /**
         * Updates the Vector4 coordinates with the minimum values between its own and the given vector ones
         * @param other defines the second operand
         * @returns the current updated Vector4
         */
        Vector4.prototype.minimizeInPlace = function (other) {
            if (other.x < this.x)
                this.x = other.x;
            if (other.y < this.y)
                this.y = other.y;
            if (other.z < this.z)
                this.z = other.z;
            if (other.w < this.w)
                this.w = other.w;
            return this;
        };
        /**
         * Updates the Vector4 coordinates with the maximum values between its own and the given vector ones
         * @param other defines the second operand
         * @returns the current updated Vector4
         */
        Vector4.prototype.maximizeInPlace = function (other) {
            if (other.x > this.x)
                this.x = other.x;
            if (other.y > this.y)
                this.y = other.y;
            if (other.z > this.z)
                this.z = other.z;
            if (other.w > this.w)
                this.w = other.w;
            return this;
        };
        // Properties
        /**
         * Returns the Vector4 length (float).
         */
        Vector4.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        };
        /**
         * Returns the Vector4 squared length (float).
         */
        Vector4.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        };
        // Methods
        /**
         * Normalizes in place the Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.normalize = function () {
            var len = this.length();
            if (len === 0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            this.z *= num;
            this.w *= num;
            return this;
        };
        /**
         * Returns a new Vector3 from the Vector4 (x, y, z) coordinates.
         */
        Vector4.prototype.toVector3 = function () {
            return new Vector3(this.x, this.y, this.z);
        };
        /**
         * Returns a new Vector4 copied from the current one.
         */
        Vector4.prototype.clone = function () {
            return new Vector4(this.x, this.y, this.z, this.w);
        };
        /**
         * Updates the current Vector4 with the given one coordinates.
         * Returns the updated Vector4.
         */
        Vector4.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            this.w = source.w;
            return this;
        };
        /**
         * Updates the current Vector4 coordinates with the given floats.
         * Returns the updated Vector4.
         */
        Vector4.prototype.copyFromFloats = function (x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            return this;
        };
        /**
         * Updates the current Vector4 coordinates with the given floats.
         * Returns the updated Vector4.
         */
        Vector4.prototype.set = function (x, y, z, w) {
            return this.copyFromFloats(x, y, z, w);
        };
        // Statics
        /**
         * Returns a new Vector4 set from the starting index of the given array.
         */
        Vector4.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Vector4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Updates the given vector "result" from the starting index of the given array.
         */
        Vector4.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
            result.z = array[offset + 2];
            result.w = array[offset + 3];
        };
        /**
         * Updates the given vector "result" from the starting index of the given Float32Array.
         */
        Vector4.FromFloatArrayToRef = function (array, offset, result) {
            Vector4.FromArrayToRef(array, offset, result);
        };
        /**
         * Updates the given vector "result" coordinates from the given floats.
         */
        Vector4.FromFloatsToRef = function (x, y, z, w, result) {
            result.x = x;
            result.y = y;
            result.z = z;
            result.w = w;
        };
        /**
         * Returns a new Vector4 set to (0.0, 0.0, 0.0, 0.0)
         */
        Vector4.Zero = function () {
            return new Vector4(0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector4 set to (1.0, 1.0, 1.0, 1.0)
         */
        Vector4.One = function () {
            return new Vector4(1.0, 1.0, 1.0, 1.0);
        };
        /**
         * Returns a new normalized Vector4 from the given one.
         */
        Vector4.Normalize = function (vector) {
            var result = Vector4.Zero();
            Vector4.NormalizeToRef(vector, result);
            return result;
        };
        /**
         * Updates the given vector "result" from the normalization of the given one.
         */
        Vector4.NormalizeToRef = function (vector, result) {
            result.copyFrom(vector);
            result.normalize();
        };
        Vector4.Minimize = function (left, right) {
            var min = left.clone();
            min.minimizeInPlace(right);
            return min;
        };
        Vector4.Maximize = function (left, right) {
            var max = left.clone();
            max.maximizeInPlace(right);
            return max;
        };
        /**
         * Returns the distance (float) between the vectors "value1" and "value2".
         */
        Vector4.Distance = function (value1, value2) {
            return Math.sqrt(Vector4.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance (float) between the vectors "value1" and "value2".
         */
        Vector4.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            var z = value1.z - value2.z;
            var w = value1.w - value2.w;
            return (x * x) + (y * y) + (z * z) + (w * w);
        };
        /**
         * Returns a new Vector4 located at the center between the vectors "value1" and "value2".
         */
        Vector4.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Returns a new Vector4 set with the result of the normal transformation by the given matrix of the given vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormal = function (vector, transformation) {
            var result = Vector4.Zero();
            Vector4.TransformNormalToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormalToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]);
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]);
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]);
            result.x = x;
            result.y = y;
            result.z = z;
            result.w = vector.w;
        };
        /**
         * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given floats (x, y, z, w).
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormalFromFloatsToRef = function (x, y, z, w, transformation, result) {
            result.x = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]);
            result.y = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]);
            result.z = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]);
            result.w = w;
        };
        return Vector4;
    }());
    BABYLON.Vector4 = Vector4;
    var Size = /** @class */ (function () {
        /**
         * Creates a Size object from the given width and height (floats).
         */
        function Size(width, height) {
            this.width = width;
            this.height = height;
        }
        // Returns a string with the Size width and height.  
        Size.prototype.toString = function () {
            return "{W: " + this.width + ", H: " + this.height + "}";
        };
        /**
         * Returns the string "Size"
         */
        Size.prototype.getClassName = function () {
            return "Size";
        };
        /**
         * Returns the Size hash code.
         */
        Size.prototype.getHashCode = function () {
            var hash = this.width || 0;
            hash = (hash * 397) ^ (this.height || 0);
            return hash;
        };
        /**
         * Updates the current size from the given one.
         * Returns the updated Size.
         */
        Size.prototype.copyFrom = function (src) {
            this.width = src.width;
            this.height = src.height;
        };
        /**
         * Updates in place the current Size from the given floats.
         * Returns the updated Size.
         */
        Size.prototype.copyFromFloats = function (width, height) {
            this.width = width;
            this.height = height;
            return this;
        };
        /**
         * Updates in place the current Size from the given floats.
         * Returns the updated Size.
         */
        Size.prototype.set = function (width, height) {
            return this.copyFromFloats(width, height);
        };
        /**
         * Returns a new Size set with the multiplication result of the current Size and the given floats.
         */
        Size.prototype.multiplyByFloats = function (w, h) {
            return new Size(this.width * w, this.height * h);
        };
        /**
         * Returns a new Size copied from the given one.
         */
        Size.prototype.clone = function () {
            return new Size(this.width, this.height);
        };
        /**
         * Boolean : True if the current Size and the given one width and height are strictly equal.
         */
        Size.prototype.equals = function (other) {
            if (!other) {
                return false;
            }
            return (this.width === other.width) && (this.height === other.height);
        };
        Object.defineProperty(Size.prototype, "surface", {
            /**
             * Returns the surface of the Size : width * height (float).
             */
            get: function () {
                return this.width * this.height;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns a new Size set to (0.0, 0.0)
         */
        Size.Zero = function () {
            return new Size(0.0, 0.0);
        };
        /**
         * Returns a new Size set as the addition result of the current Size and the given one.
         */
        Size.prototype.add = function (otherSize) {
            var r = new Size(this.width + otherSize.width, this.height + otherSize.height);
            return r;
        };
        /**
         * Returns a new Size set as the subtraction result of  the given one from the current Size.
         */
        Size.prototype.subtract = function (otherSize) {
            var r = new Size(this.width - otherSize.width, this.height - otherSize.height);
            return r;
        };
        /**
         * Returns a new Size set at the linear interpolation "amount" between "start" and "end".
         */
        Size.Lerp = function (start, end, amount) {
            var w = start.width + ((end.width - start.width) * amount);
            var h = start.height + ((end.height - start.height) * amount);
            return new Size(w, h);
        };
        return Size;
    }());
    BABYLON.Size = Size;
    /**
     * Class used to store quaternion data
     * @see https://en.wikipedia.org/wiki/Quaternion
     * @see http://doc.babylonjs.com/features/position,_rotation,_scaling
     */
    var Quaternion = /** @class */ (function () {
        /**
         * Creates a new Quaternion from the given floats
         * @param x defines the first component (0 by default)
         * @param y defines the second component (0 by default)
         * @param z defines the third component (0 by default)
         * @param w defines the fourth component (1.0 by default)
         */
        function Quaternion(
        /** defines the first component (0 by default) */
        x, 
        /** defines the second component (0 by default) */
        y, 
        /** defines the third component (0 by default) */
        z, 
        /** defines the fourth component (1.0 by default) */
        w) {
            if (x === void 0) { x = 0.0; }
            if (y === void 0) { y = 0.0; }
            if (z === void 0) { z = 0.0; }
            if (w === void 0) { w = 1.0; }
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        /**
         * Gets a string representation for the current quaternion
         * @returns a string with the Quaternion coordinates
         */
        Quaternion.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + " W:" + this.w + "}";
        };
        /**
         * Gets the class name of the quaternion
         * @returns the string "Quaternion"
         */
        Quaternion.prototype.getClassName = function () {
            return "Quaternion";
        };
        /**
         * Gets a hash code for this quaternion
         * @returns the quaternion hash code
         */
        Quaternion.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            hash = (hash * 397) ^ (this.w || 0);
            return hash;
        };
        /**
         * Copy the quaternion to an array
         * @returns a new array populated with 4 elements from the quaternion coordinates
         */
        Quaternion.prototype.asArray = function () {
            return [this.x, this.y, this.z, this.w];
        };
        /**
         * Check if two quaternions are equals
         * @param otherQuaternion defines the second operand
         * @return true if the current quaternion and the given one coordinates are strictly equals
         */
        Quaternion.prototype.equals = function (otherQuaternion) {
            return otherQuaternion && this.x === otherQuaternion.x && this.y === otherQuaternion.y && this.z === otherQuaternion.z && this.w === otherQuaternion.w;
        };
        /**
         * Clone the current quaternion
         * @returns a new quaternion copied from the current one
         */
        Quaternion.prototype.clone = function () {
            return new Quaternion(this.x, this.y, this.z, this.w);
        };
        /**
         * Copy a quaternion to the current one
         * @param other defines the other quaternion
         * @returns the updated current quaternion
         */
        Quaternion.prototype.copyFrom = function (other) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.w = other.w;
            return this;
        };
        /**
         * Updates the current quaternion with the given float coordinates
         * @param x defines the x coordinate
         * @param y defines the y coordinate
         * @param z defines the z coordinate
         * @param w defines the w coordinate
         * @returns the updated current quaternion
         */
        Quaternion.prototype.copyFromFloats = function (x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            return this;
        };
        /**
         * Updates the current quaternion from the given float coordinates
         * @param x defines the x coordinate
         * @param y defines the y coordinate
         * @param z defines the z coordinate
         * @param w defines the w coordinate
         * @returns the updated current quaternion
         */
        Quaternion.prototype.set = function (x, y, z, w) {
            return this.copyFromFloats(x, y, z, w);
        };
        /**
         * Adds two quaternions
         * @param other defines the second operand
         * @returns a new quaternion as the addition result of the given one and the current quaternion
         */
        Quaternion.prototype.add = function (other) {
            return new Quaternion(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
        };
        /**
         * Add a quaternion to the current one
         * @param other defines the quaternion to add
         * @returns the current quaternion
         */
        Quaternion.prototype.addInPlace = function (other) {
            this.x += other.x;
            this.y += other.y;
            this.z += other.z;
            this.w += other.w;
            return this;
        };
        /**
         * Subtract two quaternions
         * @param other defines the second operand
         * @returns a new quaternion as the subtraction result of the given one from the current one
         */
        Quaternion.prototype.subtract = function (other) {
            return new Quaternion(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
        };
        /**
         * Multiplies the current quaternion by a scale factor
         * @param value defines the scale factor
         * @returns a new quaternion set by multiplying the current quaternion coordinates by the float "scale"
         */
        Quaternion.prototype.scale = function (value) {
            return new Quaternion(this.x * value, this.y * value, this.z * value, this.w * value);
        };
        /**
         * Scale the current quaternion values by a factor and stores the result to a given quaternion
         * @param scale defines the scale factor
         * @param result defines the Quaternion object where to store the result
         * @returns the unmodified current quaternion
         */
        Quaternion.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            result.z = this.z * scale;
            result.w = this.w * scale;
            return this;
        };
        /**
         * Multiplies in place the current quaternion by a scale factor
         * @param value defines the scale factor
         * @returns the current modified quaternion
         */
        Quaternion.prototype.scaleInPlace = function (value) {
            this.x *= value;
            this.y *= value;
            this.z *= value;
            this.w *= value;
            return this;
        };
        /**
         * Scale the current quaternion values by a factor and add the result to a given quaternion
         * @param scale defines the scale factor
         * @param result defines the Quaternion object where to store the result
         * @returns the unmodified current quaternion
         */
        Quaternion.prototype.scaleAndAddToRef = function (scale, result) {
            result.x += this.x * scale;
            result.y += this.y * scale;
            result.z += this.z * scale;
            result.w += this.w * scale;
            return this;
        };
        /**
         * Multiplies two quaternions
         * @param q1 defines the second operand
         * @returns a new quaternion set as the multiplication result of the current one with the given one "q1"
         */
        Quaternion.prototype.multiply = function (q1) {
            var result = new Quaternion(0, 0, 0, 1.0);
            this.multiplyToRef(q1, result);
            return result;
        };
        /**
         * Sets the given "result" as the the multiplication result of the current one with the given one "q1"
         * @param q1 defines the second operand
         * @param result defines the target quaternion
         * @returns the current quaternion
         */
        Quaternion.prototype.multiplyToRef = function (q1, result) {
            var x = this.x * q1.w + this.y * q1.z - this.z * q1.y + this.w * q1.x;
            var y = -this.x * q1.z + this.y * q1.w + this.z * q1.x + this.w * q1.y;
            var z = this.x * q1.y - this.y * q1.x + this.z * q1.w + this.w * q1.z;
            var w = -this.x * q1.x - this.y * q1.y - this.z * q1.z + this.w * q1.w;
            result.copyFromFloats(x, y, z, w);
            return this;
        };
        /**
         * Updates the current quaternion with the multiplication of itself with the given one "q1"
         * @param q1 defines the second operand
         * @returns the currentupdated quaternion
         */
        Quaternion.prototype.multiplyInPlace = function (q1) {
            this.multiplyToRef(q1, this);
            return this;
        };
        /**
         * Conjugates (1-q) the current quaternion and stores the result in the given quaternion
         * @param ref defines the target quaternion
         * @returns the current quaternion
         */
        Quaternion.prototype.conjugateToRef = function (ref) {
            ref.copyFromFloats(-this.x, -this.y, -this.z, this.w);
            return this;
        };
        /**
         * Conjugates in place (1-q) the current quaternion
         * @returns the current updated quaternion
         */
        Quaternion.prototype.conjugateInPlace = function () {
            this.x *= -1;
            this.y *= -1;
            this.z *= -1;
            return this;
        };
        /**
         * Conjugates in place (1-q) the current quaternion
         * @returns a new quaternion
         */
        Quaternion.prototype.conjugate = function () {
            var result = new Quaternion(-this.x, -this.y, -this.z, this.w);
            return result;
        };
        /**
         * Gets length of current quaternion
         * @returns the quaternion length (float)
         */
        Quaternion.prototype.length = function () {
            return Math.sqrt((this.x * this.x) + (this.y * this.y) + (this.z * this.z) + (this.w * this.w));
        };
        /**
         * Normalize in place the current quaternion
         * @returns the current updated quaternion
         */
        Quaternion.prototype.normalize = function () {
            var length = 1.0 / this.length();
            this.x *= length;
            this.y *= length;
            this.z *= length;
            this.w *= length;
            return this;
        };
        /**
         * Returns a new Vector3 set with the Euler angles translated from the current quaternion
         * @param order is a reserved parameter and is ignore for now
         * @returns a new Vector3 containing the Euler angles
         */
        Quaternion.prototype.toEulerAngles = function (order) {
            if (order === void 0) { order = "YZX"; }
            var result = Vector3.Zero();
            this.toEulerAnglesToRef(result, order);
            return result;
        };
        /**
         * Sets the given vector3 "result" with the Euler angles translated from the current quaternion
         * @param result defines the vector which will be filled with the Euler angles
         * @param order is a reserved parameter and is ignore for now
         * @returns the current unchanged quaternion
         */
        Quaternion.prototype.toEulerAnglesToRef = function (result, order) {
            if (order === void 0) { order = "YZX"; }
            var qz = this.z;
            var qx = this.x;
            var qy = this.y;
            var qw = this.w;
            var sqw = qw * qw;
            var sqz = qz * qz;
            var sqx = qx * qx;
            var sqy = qy * qy;
            var zAxisY = qy * qz - qx * qw;
            var limit = .4999999;
            if (zAxisY < -limit) {
                result.y = 2 * Math.atan2(qy, qw);
                result.x = Math.PI / 2;
                result.z = 0;
            }
            else if (zAxisY > limit) {
                result.y = 2 * Math.atan2(qy, qw);
                result.x = -Math.PI / 2;
                result.z = 0;
            }
            else {
                result.z = Math.atan2(2.0 * (qx * qy + qz * qw), (-sqz - sqx + sqy + sqw));
                result.x = Math.asin(-2.0 * (qz * qy - qx * qw));
                result.y = Math.atan2(2.0 * (qz * qx + qy * qw), (sqz - sqx - sqy + sqw));
            }
            return this;
        };
        /**
         * Updates the given rotation matrix with the current quaternion values
         * @param result defines the target matrix
         * @returns the current unchanged quaternion
         */
        Quaternion.prototype.toRotationMatrix = function (result) {
            var xx = this.x * this.x;
            var yy = this.y * this.y;
            var zz = this.z * this.z;
            var xy = this.x * this.y;
            var zw = this.z * this.w;
            var zx = this.z * this.x;
            var yw = this.y * this.w;
            var yz = this.y * this.z;
            var xw = this.x * this.w;
            result.m[0] = 1.0 - (2.0 * (yy + zz));
            result.m[1] = 2.0 * (xy + zw);
            result.m[2] = 2.0 * (zx - yw);
            result.m[3] = 0;
            result.m[4] = 2.0 * (xy - zw);
            result.m[5] = 1.0 - (2.0 * (zz + xx));
            result.m[6] = 2.0 * (yz + xw);
            result.m[7] = 0;
            result.m[8] = 2.0 * (zx + yw);
            result.m[9] = 2.0 * (yz - xw);
            result.m[10] = 1.0 - (2.0 * (yy + xx));
            result.m[11] = 0;
            result.m[12] = 0;
            result.m[13] = 0;
            result.m[14] = 0;
            result.m[15] = 1.0;
            result._markAsUpdated();
            return this;
        };
        /**
         * Updates the current quaternion from the given rotation matrix values
         * @param matrix defines the source matrix
         * @returns the current updated quaternion
         */
        Quaternion.prototype.fromRotationMatrix = function (matrix) {
            Quaternion.FromRotationMatrixToRef(matrix, this);
            return this;
        };
        // Statics
        /**
         * Creates a new quaternion from a rotation matrix
         * @param matrix defines the source matrix
         * @returns a new quaternion created from the given rotation matrix values
         */
        Quaternion.FromRotationMatrix = function (matrix) {
            var result = new Quaternion();
            Quaternion.FromRotationMatrixToRef(matrix, result);
            return result;
        };
        /**
         * Updates the given quaternion with the given rotation matrix values
         * @param matrix defines the source matrix
         * @param result defines the target quaternion
         */
        Quaternion.FromRotationMatrixToRef = function (matrix, result) {
            var data = matrix.m;
            var m11 = data[0], m12 = data[4], m13 = data[8];
            var m21 = data[1], m22 = data[5], m23 = data[9];
            var m31 = data[2], m32 = data[6], m33 = data[10];
            var trace = m11 + m22 + m33;
            var s;
            if (trace > 0) {
                s = 0.5 / Math.sqrt(trace + 1.0);
                result.w = 0.25 / s;
                result.x = (m32 - m23) * s;
                result.y = (m13 - m31) * s;
                result.z = (m21 - m12) * s;
            }
            else if (m11 > m22 && m11 > m33) {
                s = 2.0 * Math.sqrt(1.0 + m11 - m22 - m33);
                result.w = (m32 - m23) / s;
                result.x = 0.25 * s;
                result.y = (m12 + m21) / s;
                result.z = (m13 + m31) / s;
            }
            else if (m22 > m33) {
                s = 2.0 * Math.sqrt(1.0 + m22 - m11 - m33);
                result.w = (m13 - m31) / s;
                result.x = (m12 + m21) / s;
                result.y = 0.25 * s;
                result.z = (m23 + m32) / s;
            }
            else {
                s = 2.0 * Math.sqrt(1.0 + m33 - m11 - m22);
                result.w = (m21 - m12) / s;
                result.x = (m13 + m31) / s;
                result.y = (m23 + m32) / s;
                result.z = 0.25 * s;
            }
        };
        /**
         * Returns the dot product (float) between the quaternions "left" and "right"
         * @param left defines the left operand
         * @param right defines the right operand
         * @returns the dot product
         */
        Quaternion.Dot = function (left, right) {
            return (left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w);
        };
        /**
         * Checks if the two quaternions are close to each other
         * @param quat0 defines the first quaternion to check
         * @param quat1 defines the second quaternion to check
         * @returns true if the two quaternions are close to each other
         */
        Quaternion.AreClose = function (quat0, quat1) {
            var dot = Quaternion.Dot(quat0, quat1);
            return dot >= 0;
        };
        /**
         * Creates an empty quaternion
         * @returns a new quaternion set to (0.0, 0.0, 0.0)
         */
        Quaternion.Zero = function () {
            return new Quaternion(0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Inverse a given quaternion
         * @param q defines the source quaternion
         * @returns a new quaternion as the inverted current quaternion
         */
        Quaternion.Inverse = function (q) {
            return new Quaternion(-q.x, -q.y, -q.z, q.w);
        };
        /**
         * Creates an identity quaternion
         * @returns the identity quaternion
         */
        Quaternion.Identity = function () {
            return new Quaternion(0.0, 0.0, 0.0, 1.0);
        };
        /**
         * Gets a boolean indicating if the given quaternion is identity
         * @param quaternion defines the quaternion to check
         * @returns true if the quaternion is identity
         */
        Quaternion.IsIdentity = function (quaternion) {
            return quaternion && quaternion.x === 0 && quaternion.y === 0 && quaternion.z === 0 && quaternion.w === 1;
        };
        /**
         * Creates a quaternion from a rotation around an axis
         * @param axis defines the axis to use
         * @param angle defines the angle to use
         * @returns a new quaternion created from the given axis (Vector3) and angle in radians (float)
         */
        Quaternion.RotationAxis = function (axis, angle) {
            return Quaternion.RotationAxisToRef(axis, angle, new Quaternion());
        };
        /**
         * Creates a rotation around an axis and stores it into the given quaternion
         * @param axis defines the axis to use
         * @param angle defines the angle to use
         * @param result defines the target quaternion
         * @returns the target quaternion
         */
        Quaternion.RotationAxisToRef = function (axis, angle, result) {
            var sin = Math.sin(angle / 2);
            axis.normalize();
            result.w = Math.cos(angle / 2);
            result.x = axis.x * sin;
            result.y = axis.y * sin;
            result.z = axis.z * sin;
            return result;
        };
        /**
         * Creates a new quaternion from data stored into an array
         * @param array defines the data source
         * @param offset defines the offset in the source array where the data starts
         * @returns a new quaternion
         */
        Quaternion.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Quaternion(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Creates a new quaternion from the given Euler float angles (y, x, z)
         * @param yaw defines the rotation around Y axis
         * @param pitch defines the rotation around X axis
         * @param roll defines the rotation around Z axis
         * @returns the new quaternion
         */
        Quaternion.RotationYawPitchRoll = function (yaw, pitch, roll) {
            var q = new Quaternion();
            Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, q);
            return q;
        };
        /**
         * Creates a new rotation from the given Euler float angles (y, x, z) and stores it in the target quaternion
         * @param yaw defines the rotation around Y axis
         * @param pitch defines the rotation around X axis
         * @param roll defines the rotation around Z axis
         * @param result defines the target quaternion
         */
        Quaternion.RotationYawPitchRollToRef = function (yaw, pitch, roll, result) {
            // Produces a quaternion from Euler angles in the z-y-x orientation (Tait-Bryan angles)
            var halfRoll = roll * 0.5;
            var halfPitch = pitch * 0.5;
            var halfYaw = yaw * 0.5;
            var sinRoll = Math.sin(halfRoll);
            var cosRoll = Math.cos(halfRoll);
            var sinPitch = Math.sin(halfPitch);
            var cosPitch = Math.cos(halfPitch);
            var sinYaw = Math.sin(halfYaw);
            var cosYaw = Math.cos(halfYaw);
            result.x = (cosYaw * sinPitch * cosRoll) + (sinYaw * cosPitch * sinRoll);
            result.y = (sinYaw * cosPitch * cosRoll) - (cosYaw * sinPitch * sinRoll);
            result.z = (cosYaw * cosPitch * sinRoll) - (sinYaw * sinPitch * cosRoll);
            result.w = (cosYaw * cosPitch * cosRoll) + (sinYaw * sinPitch * sinRoll);
        };
        /**
         * Creates a new quaternion from the given Euler float angles expressed in z-x-z orientation
         * @param alpha defines the rotation around first axis
         * @param beta defines the rotation around second axis
         * @param gamma defines the rotation around third axis
         * @returns the new quaternion
         */
        Quaternion.RotationAlphaBetaGamma = function (alpha, beta, gamma) {
            var result = new Quaternion();
            Quaternion.RotationAlphaBetaGammaToRef(alpha, beta, gamma, result);
            return result;
        };
        /**
         * Creates a new quaternion from the given Euler float angles expressed in z-x-z orientation and stores it in the target quaternion
         * @param alpha defines the rotation around first axis
         * @param beta defines the rotation around second axis
         * @param gamma defines the rotation around third axis
         * @param result defines the target quaternion
         */
        Quaternion.RotationAlphaBetaGammaToRef = function (alpha, beta, gamma, result) {
            // Produces a quaternion from Euler angles in the z-x-z orientation
            var halfGammaPlusAlpha = (gamma + alpha) * 0.5;
            var halfGammaMinusAlpha = (gamma - alpha) * 0.5;
            var halfBeta = beta * 0.5;
            result.x = Math.cos(halfGammaMinusAlpha) * Math.sin(halfBeta);
            result.y = Math.sin(halfGammaMinusAlpha) * Math.sin(halfBeta);
            result.z = Math.sin(halfGammaPlusAlpha) * Math.cos(halfBeta);
            result.w = Math.cos(halfGammaPlusAlpha) * Math.cos(halfBeta);
        };
        /**
         * Creates a new quaternion containing the rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system (axis1, axis2 and axis3 are normalized during this operation)
         * @param axis1 defines the first axis
         * @param axis2 defines the second axis
         * @param axis3 defines the third axis
         * @returns the new quaternion
         */
        Quaternion.RotationQuaternionFromAxis = function (axis1, axis2, axis3) {
            var quat = new Quaternion(0.0, 0.0, 0.0, 0.0);
            Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
            return quat;
        };
        /**
         * Creates a rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system (axis1, axis2 and axis3 are normalized during this operation) and stores it in the target quaternion
         * @param axis1 defines the first axis
         * @param axis2 defines the second axis
         * @param axis3 defines the third axis
         * @param ref defines the target quaternion
         */
        Quaternion.RotationQuaternionFromAxisToRef = function (axis1, axis2, axis3, ref) {
            var rotMat = MathTmp.Matrix[0];
            Matrix.FromXYZAxesToRef(axis1.normalize(), axis2.normalize(), axis3.normalize(), rotMat);
            Quaternion.FromRotationMatrixToRef(rotMat, ref);
        };
        /**
         * Interpolates between two quaternions
         * @param left defines first quaternion
         * @param right defines second quaternion
         * @param amount defines the gradient to use
         * @returns the new interpolated quaternion
         */
        Quaternion.Slerp = function (left, right, amount) {
            var result = Quaternion.Identity();
            Quaternion.SlerpToRef(left, right, amount, result);
            return result;
        };
        /**
         * Interpolates between two quaternions and stores it into a target quaternion
         * @param left defines first quaternion
         * @param right defines second quaternion
         * @param amount defines the gradient to use
         * @param result defines the target quaternion
         */
        Quaternion.SlerpToRef = function (left, right, amount, result) {
            var num2;
            var num3;
            var num4 = (((left.x * right.x) + (left.y * right.y)) + (left.z * right.z)) + (left.w * right.w);
            var flag = false;
            if (num4 < 0) {
                flag = true;
                num4 = -num4;
            }
            if (num4 > 0.999999) {
                num3 = 1 - amount;
                num2 = flag ? -amount : amount;
            }
            else {
                var num5 = Math.acos(num4);
                var num6 = (1.0 / Math.sin(num5));
                num3 = (Math.sin((1.0 - amount) * num5)) * num6;
                num2 = flag ? ((-Math.sin(amount * num5)) * num6) : ((Math.sin(amount * num5)) * num6);
            }
            result.x = (num3 * left.x) + (num2 * right.x);
            result.y = (num3 * left.y) + (num2 * right.y);
            result.z = (num3 * left.z) + (num2 * right.z);
            result.w = (num3 * left.w) + (num2 * right.w);
        };
        /**
         * Interpolate between two quaternions using Hermite interpolation
         * @param value1 defines first quaternion
         * @param tangent1 defines the incoming tangent
         * @param value2 defines second quaternion
         * @param tangent2 defines the outgoing tangent
         * @param amount defines the target quaternion
         * @returns the new interpolated quaternion
         */
        Quaternion.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            var z = (((value1.z * part1) + (value2.z * part2)) + (tangent1.z * part3)) + (tangent2.z * part4);
            var w = (((value1.w * part1) + (value2.w * part2)) + (tangent1.w * part3)) + (tangent2.w * part4);
            return new Quaternion(x, y, z, w);
        };
        return Quaternion;
    }());
    BABYLON.Quaternion = Quaternion;
    /**
     * Class used to store matrix data (4x4)
     */
    var Matrix = /** @class */ (function () {
        /**
         * Creates an empty matrix (filled with zeros)
         */
        function Matrix() {
            this._isIdentity = false;
            this._isIdentityDirty = true;
            /**
             * Gets or sets the internal data of the matrix
             */
            this.m = new Float32Array(16);
            this._markAsUpdated();
        }
        /** @hidden */
        Matrix.prototype._markAsUpdated = function () {
            this.updateFlag = Matrix._updateFlagSeed++;
            this._isIdentityDirty = true;
        };
        // Properties
        /**
         * Check if the current matrix is indentity
         * @param considerAsTextureMatrix defines if the current matrix must be considered as a texture matrix (3x2)
         * @returns true is the matrix is the identity matrix
         */
        Matrix.prototype.isIdentity = function (considerAsTextureMatrix) {
            if (considerAsTextureMatrix === void 0) { considerAsTextureMatrix = false; }
            if (this._isIdentityDirty) {
                this._isIdentityDirty = false;
                if (this.m[0] !== 1.0 || this.m[5] !== 1.0 || this.m[15] !== 1.0) {
                    this._isIdentity = false;
                }
                else if (this.m[1] !== 0.0 || this.m[2] !== 0.0 || this.m[3] !== 0.0 ||
                    this.m[4] !== 0.0 || this.m[6] !== 0.0 || this.m[7] !== 0.0 ||
                    this.m[8] !== 0.0 || this.m[9] !== 0.0 || this.m[11] !== 0.0 ||
                    this.m[12] !== 0.0 || this.m[13] !== 0.0 || this.m[14] !== 0.0) {
                    this._isIdentity = false;
                }
                else {
                    this._isIdentity = true;
                }
                if (!considerAsTextureMatrix && this.m[10] !== 1.0) {
                    this._isIdentity = false;
                }
            }
            return this._isIdentity;
        };
        /**
         * Gets the determinant of the matrix
         * @returns the matrix determinant
         */
        Matrix.prototype.determinant = function () {
            var temp1 = (this.m[10] * this.m[15]) - (this.m[11] * this.m[14]);
            var temp2 = (this.m[9] * this.m[15]) - (this.m[11] * this.m[13]);
            var temp3 = (this.m[9] * this.m[14]) - (this.m[10] * this.m[13]);
            var temp4 = (this.m[8] * this.m[15]) - (this.m[11] * this.m[12]);
            var temp5 = (this.m[8] * this.m[14]) - (this.m[10] * this.m[12]);
            var temp6 = (this.m[8] * this.m[13]) - (this.m[9] * this.m[12]);
            return ((((this.m[0] * (((this.m[5] * temp1) - (this.m[6] * temp2)) + (this.m[7] * temp3))) - (this.m[1] * (((this.m[4] * temp1) -
                (this.m[6] * temp4)) + (this.m[7] * temp5)))) + (this.m[2] * (((this.m[4] * temp2) - (this.m[5] * temp4)) + (this.m[7] * temp6)))) -
                (this.m[3] * (((this.m[4] * temp3) - (this.m[5] * temp5)) + (this.m[6] * temp6))));
        };
        // Methods
        /**
         * Returns the matrix as a Float32Array
         * @returns the matrix underlying array
         */
        Matrix.prototype.toArray = function () {
            return this.m;
        };
        /**
         * Returns the matrix as a Float32Array
        * @returns the matrix underlying array.
        */
        Matrix.prototype.asArray = function () {
            return this.toArray();
        };
        /**
         * Inverts the current matrix in place
         * @returns the current inverted matrix
         */
        Matrix.prototype.invert = function () {
            this.invertToRef(this);
            return this;
        };
        /**
         * Sets all the matrix elements to zero
         * @returns the current matrix
         */
        Matrix.prototype.reset = function () {
            for (var index = 0; index < 16; index++) {
                this.m[index] = 0.0;
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Adds the current matrix with a second one
         * @param other defines the matrix to add
         * @returns a new matrix as the addition of the current matrix and the given one
         */
        Matrix.prototype.add = function (other) {
            var result = new Matrix();
            this.addToRef(other, result);
            return result;
        };
        /**
         * Sets the given matrix "result" to the addition of the current matrix and the given one
         * @param other defines the matrix to add
         * @param result defines the target matrix
         * @returns the current matrix
         */
        Matrix.prototype.addToRef = function (other, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = this.m[index] + other.m[index];
            }
            result._markAsUpdated();
            return this;
        };
        /**
         * Adds in place the given matrix to the current matrix
         * @param other defines the second operand
         * @returns the current updated matrix
         */
        Matrix.prototype.addToSelf = function (other) {
            for (var index = 0; index < 16; index++) {
                this.m[index] += other.m[index];
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Sets the given matrix to the current inverted Matrix
         * @param other defines the target matrix
         * @returns the unmodified current matrix
         */
        Matrix.prototype.invertToRef = function (other) {
            var l1 = this.m[0];
            var l2 = this.m[1];
            var l3 = this.m[2];
            var l4 = this.m[3];
            var l5 = this.m[4];
            var l6 = this.m[5];
            var l7 = this.m[6];
            var l8 = this.m[7];
            var l9 = this.m[8];
            var l10 = this.m[9];
            var l11 = this.m[10];
            var l12 = this.m[11];
            var l13 = this.m[12];
            var l14 = this.m[13];
            var l15 = this.m[14];
            var l16 = this.m[15];
            var l17 = (l11 * l16) - (l12 * l15);
            var l18 = (l10 * l16) - (l12 * l14);
            var l19 = (l10 * l15) - (l11 * l14);
            var l20 = (l9 * l16) - (l12 * l13);
            var l21 = (l9 * l15) - (l11 * l13);
            var l22 = (l9 * l14) - (l10 * l13);
            var l23 = ((l6 * l17) - (l7 * l18)) + (l8 * l19);
            var l24 = -(((l5 * l17) - (l7 * l20)) + (l8 * l21));
            var l25 = ((l5 * l18) - (l6 * l20)) + (l8 * l22);
            var l26 = -(((l5 * l19) - (l6 * l21)) + (l7 * l22));
            var l27 = 1.0 / ((((l1 * l23) + (l2 * l24)) + (l3 * l25)) + (l4 * l26));
            var l28 = (l7 * l16) - (l8 * l15);
            var l29 = (l6 * l16) - (l8 * l14);
            var l30 = (l6 * l15) - (l7 * l14);
            var l31 = (l5 * l16) - (l8 * l13);
            var l32 = (l5 * l15) - (l7 * l13);
            var l33 = (l5 * l14) - (l6 * l13);
            var l34 = (l7 * l12) - (l8 * l11);
            var l35 = (l6 * l12) - (l8 * l10);
            var l36 = (l6 * l11) - (l7 * l10);
            var l37 = (l5 * l12) - (l8 * l9);
            var l38 = (l5 * l11) - (l7 * l9);
            var l39 = (l5 * l10) - (l6 * l9);
            other.m[0] = l23 * l27;
            other.m[4] = l24 * l27;
            other.m[8] = l25 * l27;
            other.m[12] = l26 * l27;
            other.m[1] = -(((l2 * l17) - (l3 * l18)) + (l4 * l19)) * l27;
            other.m[5] = (((l1 * l17) - (l3 * l20)) + (l4 * l21)) * l27;
            other.m[9] = -(((l1 * l18) - (l2 * l20)) + (l4 * l22)) * l27;
            other.m[13] = (((l1 * l19) - (l2 * l21)) + (l3 * l22)) * l27;
            other.m[2] = (((l2 * l28) - (l3 * l29)) + (l4 * l30)) * l27;
            other.m[6] = -(((l1 * l28) - (l3 * l31)) + (l4 * l32)) * l27;
            other.m[10] = (((l1 * l29) - (l2 * l31)) + (l4 * l33)) * l27;
            other.m[14] = -(((l1 * l30) - (l2 * l32)) + (l3 * l33)) * l27;
            other.m[3] = -(((l2 * l34) - (l3 * l35)) + (l4 * l36)) * l27;
            other.m[7] = (((l1 * l34) - (l3 * l37)) + (l4 * l38)) * l27;
            other.m[11] = -(((l1 * l35) - (l2 * l37)) + (l4 * l39)) * l27;
            other.m[15] = (((l1 * l36) - (l2 * l38)) + (l3 * l39)) * l27;
            other._markAsUpdated();
            return this;
        };
        /**
         * Inserts the translation vector (using 3 floats) in the current matrix
         * @param x defines the 1st component of the translation
         * @param y defines the 2nd component of the translation
         * @param z defines the 3rd component of the translation
         * @returns the current updated matrix
         */
        Matrix.prototype.setTranslationFromFloats = function (x, y, z) {
            this.m[12] = x;
            this.m[13] = y;
            this.m[14] = z;
            this._markAsUpdated();
            return this;
        };
        /**
         * Inserts the translation vector in the current matrix
         * @param vector3 defines the translation to insert
         * @returns the current updated matrix
         */
        Matrix.prototype.setTranslation = function (vector3) {
            this.m[12] = vector3.x;
            this.m[13] = vector3.y;
            this.m[14] = vector3.z;
            this._markAsUpdated();
            return this;
        };
        /**
         * Gets the translation value of the current matrix
         * @returns a new Vector3 as the extracted translation from the matrix
         */
        Matrix.prototype.getTranslation = function () {
            return new Vector3(this.m[12], this.m[13], this.m[14]);
        };
        /**
         * Fill a Vector3 with the extracted translation from the matrix
         * @param result defines the Vector3 where to store the translation
         * @returns the current matrix
         */
        Matrix.prototype.getTranslationToRef = function (result) {
            result.x = this.m[12];
            result.y = this.m[13];
            result.z = this.m[14];
            return this;
        };
        /**
         * Remove rotation and scaling part from the matrix
         * @returns the updated matrix
         */
        Matrix.prototype.removeRotationAndScaling = function () {
            this.setRowFromFloats(0, 1, 0, 0, 0);
            this.setRowFromFloats(1, 0, 1, 0, 0);
            this.setRowFromFloats(2, 0, 0, 1, 0);
            return this;
        };
        /**
         * Multiply two matrices
         * @param other defines the second operand
         * @returns a new matrix set with the multiplication result of the current Matrix and the given one
         */
        Matrix.prototype.multiply = function (other) {
            var result = new Matrix();
            this.multiplyToRef(other, result);
            return result;
        };
        /**
         * Copy the current matrix from the given one
         * @param other defines the source matrix
         * @returns the current updated matrix
         */
        Matrix.prototype.copyFrom = function (other) {
            for (var index = 0; index < 16; index++) {
                this.m[index] = other.m[index];
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Populates the given array from the starting index with the current matrix values
         * @param array defines the target array
         * @param offset defines the offset in the target array where to start storing values
         * @returns the current matrix
         */
        Matrix.prototype.copyToArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            for (var index = 0; index < 16; index++) {
                array[offset + index] = this.m[index];
            }
            return this;
        };
        /**
         * Sets the given matrix "result" with the multiplication result of the current Matrix and the given one
         * @param other defines the second operand
         * @param result defines the matrix where to store the multiplication
         * @returns the current matrix
         */
        Matrix.prototype.multiplyToRef = function (other, result) {
            this.multiplyToArray(other, result.m, 0);
            result._markAsUpdated();
            return this;
        };
        /**
         * Sets the Float32Array "result" from the given index "offset" with the multiplication of the current matrix and the given one
         * @param other defines the second operand
         * @param result defines the array where to store the multiplication
         * @param offset defines the offset in the target array where to start storing values
         * @returns the current matrix
         */
        Matrix.prototype.multiplyToArray = function (other, result, offset) {
            var tm0 = this.m[0];
            var tm1 = this.m[1];
            var tm2 = this.m[2];
            var tm3 = this.m[3];
            var tm4 = this.m[4];
            var tm5 = this.m[5];
            var tm6 = this.m[6];
            var tm7 = this.m[7];
            var tm8 = this.m[8];
            var tm9 = this.m[9];
            var tm10 = this.m[10];
            var tm11 = this.m[11];
            var tm12 = this.m[12];
            var tm13 = this.m[13];
            var tm14 = this.m[14];
            var tm15 = this.m[15];
            var om0 = other.m[0];
            var om1 = other.m[1];
            var om2 = other.m[2];
            var om3 = other.m[3];
            var om4 = other.m[4];
            var om5 = other.m[5];
            var om6 = other.m[6];
            var om7 = other.m[7];
            var om8 = other.m[8];
            var om9 = other.m[9];
            var om10 = other.m[10];
            var om11 = other.m[11];
            var om12 = other.m[12];
            var om13 = other.m[13];
            var om14 = other.m[14];
            var om15 = other.m[15];
            result[offset] = tm0 * om0 + tm1 * om4 + tm2 * om8 + tm3 * om12;
            result[offset + 1] = tm0 * om1 + tm1 * om5 + tm2 * om9 + tm3 * om13;
            result[offset + 2] = tm0 * om2 + tm1 * om6 + tm2 * om10 + tm3 * om14;
            result[offset + 3] = tm0 * om3 + tm1 * om7 + tm2 * om11 + tm3 * om15;
            result[offset + 4] = tm4 * om0 + tm5 * om4 + tm6 * om8 + tm7 * om12;
            result[offset + 5] = tm4 * om1 + tm5 * om5 + tm6 * om9 + tm7 * om13;
            result[offset + 6] = tm4 * om2 + tm5 * om6 + tm6 * om10 + tm7 * om14;
            result[offset + 7] = tm4 * om3 + tm5 * om7 + tm6 * om11 + tm7 * om15;
            result[offset + 8] = tm8 * om0 + tm9 * om4 + tm10 * om8 + tm11 * om12;
            result[offset + 9] = tm8 * om1 + tm9 * om5 + tm10 * om9 + tm11 * om13;
            result[offset + 10] = tm8 * om2 + tm9 * om6 + tm10 * om10 + tm11 * om14;
            result[offset + 11] = tm8 * om3 + tm9 * om7 + tm10 * om11 + tm11 * om15;
            result[offset + 12] = tm12 * om0 + tm13 * om4 + tm14 * om8 + tm15 * om12;
            result[offset + 13] = tm12 * om1 + tm13 * om5 + tm14 * om9 + tm15 * om13;
            result[offset + 14] = tm12 * om2 + tm13 * om6 + tm14 * om10 + tm15 * om14;
            result[offset + 15] = tm12 * om3 + tm13 * om7 + tm14 * om11 + tm15 * om15;
            return this;
        };
        /**
         * Check equality between this matrix and a second one
         * @param value defines the second matrix to compare
         * @returns true is the current matrix and the given one values are strictly equal
         */
        Matrix.prototype.equals = function (value) {
            return value &&
                (this.m[0] === value.m[0] && this.m[1] === value.m[1] && this.m[2] === value.m[2] && this.m[3] === value.m[3] &&
                    this.m[4] === value.m[4] && this.m[5] === value.m[5] && this.m[6] === value.m[6] && this.m[7] === value.m[7] &&
                    this.m[8] === value.m[8] && this.m[9] === value.m[9] && this.m[10] === value.m[10] && this.m[11] === value.m[11] &&
                    this.m[12] === value.m[12] && this.m[13] === value.m[13] && this.m[14] === value.m[14] && this.m[15] === value.m[15]);
        };
        /**
         * Clone the current matrix
         * @returns a new matrix from the current matrix
         */
        Matrix.prototype.clone = function () {
            return Matrix.FromValues(this.m[0], this.m[1], this.m[2], this.m[3], this.m[4], this.m[5], this.m[6], this.m[7], this.m[8], this.m[9], this.m[10], this.m[11], this.m[12], this.m[13], this.m[14], this.m[15]);
        };
        /**
         * Returns the name of the current matrix class
         * @returns the string "Matrix"
         */
        Matrix.prototype.getClassName = function () {
            return "Matrix";
        };
        /**
         * Gets the hash code of the current matrix
         * @returns the hash code
         */
        Matrix.prototype.getHashCode = function () {
            var hash = this.m[0] || 0;
            for (var i = 1; i < 16; i++) {
                hash = (hash * 397) ^ (this.m[i] || 0);
            }
            return hash;
        };
        /**
         * Decomposes the current Matrix into a translation, rotation and scaling components
         * @param scale defines the scale vector3 given as a reference to update
         * @param rotation defines the rotation quaternion given as a reference to update
         * @param translation defines the translation vector3 given as a reference to update
         * @returns true if operation was successful
         */
        Matrix.prototype.decompose = function (scale, rotation, translation) {
            if (translation) {
                translation.x = this.m[12];
                translation.y = this.m[13];
                translation.z = this.m[14];
            }
            scale = scale || MathTmp.Vector3[0];
            scale.x = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2]);
            scale.y = Math.sqrt(this.m[4] * this.m[4] + this.m[5] * this.m[5] + this.m[6] * this.m[6]);
            scale.z = Math.sqrt(this.m[8] * this.m[8] + this.m[9] * this.m[9] + this.m[10] * this.m[10]);
            if (this.determinant() <= 0) {
                scale.y *= -1;
            }
            if (scale.x === 0 || scale.y === 0 || scale.z === 0) {
                if (rotation) {
                    rotation.x = 0;
                    rotation.y = 0;
                    rotation.z = 0;
                    rotation.w = 1;
                }
                return false;
            }
            if (rotation) {
                Matrix.FromValuesToRef(this.m[0] / scale.x, this.m[1] / scale.x, this.m[2] / scale.x, 0, this.m[4] / scale.y, this.m[5] / scale.y, this.m[6] / scale.y, 0, this.m[8] / scale.z, this.m[9] / scale.z, this.m[10] / scale.z, 0, 0, 0, 0, 1, MathTmp.Matrix[0]);
                Quaternion.FromRotationMatrixToRef(MathTmp.Matrix[0], rotation);
            }
            return true;
        };
        /**
         * Gets specific row of the matrix
         * @param index defines the number of the row to get
         * @returns the index-th row of the current matrix as a new Vector4
         */
        Matrix.prototype.getRow = function (index) {
            if (index < 0 || index > 3) {
                return null;
            }
            var i = index * 4;
            return new Vector4(this.m[i + 0], this.m[i + 1], this.m[i + 2], this.m[i + 3]);
        };
        /**
         * Sets the index-th row of the current matrix to the vector4 values
         * @param index defines the number of the row to set
         * @param row defines the target vector4
         * @returns the updated current matrix
         */
        Matrix.prototype.setRow = function (index, row) {
            if (index < 0 || index > 3) {
                return this;
            }
            var i = index * 4;
            this.m[i + 0] = row.x;
            this.m[i + 1] = row.y;
            this.m[i + 2] = row.z;
            this.m[i + 3] = row.w;
            this._markAsUpdated();
            return this;
        };
        /**
         * Compute the transpose of the matrix
         * @returns the new transposed matrix
         */
        Matrix.prototype.transpose = function () {
            return Matrix.Transpose(this);
        };
        /**
         * Compute the transpose of the matrix and store it in a given matrix
         * @param result defines the target matrix
         * @returns the current matrix
         */
        Matrix.prototype.transposeToRef = function (result) {
            Matrix.TransposeToRef(this, result);
            return this;
        };
        /**
         * Sets the index-th row of the current matrix with the given 4 x float values
         * @param index defines the row index
         * @param x defines the x component to set
         * @param y defines the y component to set
         * @param z defines the z component to set
         * @param w defines the w component to set
         * @returns the updated current matrix
         */
        Matrix.prototype.setRowFromFloats = function (index, x, y, z, w) {
            if (index < 0 || index > 3) {
                return this;
            }
            var i = index * 4;
            this.m[i + 0] = x;
            this.m[i + 1] = y;
            this.m[i + 2] = z;
            this.m[i + 3] = w;
            this._markAsUpdated();
            return this;
        };
        /**
         * Compute a new matrix set with the current matrix values multiplied by scale (float)
         * @param scale defines the scale factor
         * @returns a new matrix
         */
        Matrix.prototype.scale = function (scale) {
            var result = new Matrix();
            this.scaleToRef(scale, result);
            return result;
        };
        /**
         * Scale the current matrix values by a factor to a given result matrix
         * @param scale defines the scale factor
         * @param result defines the matrix to store the result
         * @returns the current matrix
         */
        Matrix.prototype.scaleToRef = function (scale, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = this.m[index] * scale;
            }
            result._markAsUpdated();
            return this;
        };
        /**
         * Scale the current matrix values by a factor and add the result to a given matrix
         * @param scale defines the scale factor
         * @param result defines the Matrix to store the result
         * @returns the current matrix
         */
        Matrix.prototype.scaleAndAddToRef = function (scale, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] += this.m[index] * scale;
            }
            result._markAsUpdated();
            return this;
        };
        /**
         * Writes to the given matrix a normal matrix, computed from this one (using values from identity matrix for fourth row and column).
         * @param ref matrix to store the result
         */
        Matrix.prototype.toNormalMatrix = function (ref) {
            this.invertToRef(ref);
            ref.transpose();
            var m = ref.m;
            Matrix.FromValuesToRef(m[0], m[1], m[2], 0, m[4], m[5], m[6], 0, m[8], m[9], m[10], 0, 0, 0, 0, 1, ref);
        };
        /**
         * Gets only rotation part of the current matrix
         * @returns a new matrix sets to the extracted rotation matrix from the current one
         */
        Matrix.prototype.getRotationMatrix = function () {
            var result = Matrix.Identity();
            this.getRotationMatrixToRef(result);
            return result;
        };
        /**
         * Extracts the rotation matrix from the current one and sets it as the given "result"
         * @param result defines the target matrix to store data to
         * @returns the current matrix
         */
        Matrix.prototype.getRotationMatrixToRef = function (result) {
            var m = this.m;
            var sx = Math.sqrt(m[0] * m[0] + m[1] * m[1] + m[2] * m[2]);
            var sy = Math.sqrt(m[4] * m[4] + m[5] * m[5] + m[6] * m[6]);
            var sz = Math.sqrt(m[8] * m[8] + m[9] * m[9] + m[10] * m[10]);
            if (this.determinant() <= 0) {
                sy *= -1;
            }
            if (sx === 0 || sy === 0 || sz === 0) {
                Matrix.IdentityToRef(result);
            }
            else {
                Matrix.FromValuesToRef(m[0] / sx, m[1] / sx, m[2] / sx, 0, m[4] / sy, m[5] / sy, m[6] / sy, 0, m[8] / sz, m[9] / sz, m[10] / sz, 0, 0, 0, 0, 1, result);
            }
            return this;
        };
        // Statics
        /**
         * Creates a matrix from an array
         * @param array defines the source array
         * @param offset defines an offset in the source array
         * @returns a new Matrix set from the starting index of the given array
         */
        Matrix.FromArray = function (array, offset) {
            var result = new Matrix();
            if (!offset) {
                offset = 0;
            }
            Matrix.FromArrayToRef(array, offset, result);
            return result;
        };
        /**
         * Copy the content of an array into a given matrix
         * @param array defines the source array
         * @param offset defines an offset in the source array
         * @param result defines the target matrix
         */
        Matrix.FromArrayToRef = function (array, offset, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = array[index + offset];
            }
            result._markAsUpdated();
        };
        /**
         * Stores an array into a matrix after having multiplied each component by a given factor
         * @param array defines the source array
         * @param offset defines the offset in the source array
         * @param scale defines the scaling factor
         * @param result defines the target matrix
         */
        Matrix.FromFloat32ArrayToRefScaled = function (array, offset, scale, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = array[index + offset] * scale;
            }
            result._markAsUpdated();
        };
        /**
         * Stores a list of values (16) inside a given matrix
         * @param initialM11 defines 1st value of 1st row
         * @param initialM12 defines 2nd value of 1st row
         * @param initialM13 defines 3rd value of 1st row
         * @param initialM14 defines 4th value of 1st row
         * @param initialM21 defines 1st value of 2nd row
         * @param initialM22 defines 2nd value of 2nd row
         * @param initialM23 defines 3rd value of 2nd row
         * @param initialM24 defines 4th value of 2nd row
         * @param initialM31 defines 1st value of 3rd row
         * @param initialM32 defines 2nd value of 3rd row
         * @param initialM33 defines 3rd value of 3rd row
         * @param initialM34 defines 4th value of 3rd row
         * @param initialM41 defines 1st value of 4th row
         * @param initialM42 defines 2nd value of 4th row
         * @param initialM43 defines 3rd value of 4th row
         * @param initialM44 defines 4th value of 4th row
         * @param result defines the target matrix
         */
        Matrix.FromValuesToRef = function (initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44, result) {
            result.m[0] = initialM11;
            result.m[1] = initialM12;
            result.m[2] = initialM13;
            result.m[3] = initialM14;
            result.m[4] = initialM21;
            result.m[5] = initialM22;
            result.m[6] = initialM23;
            result.m[7] = initialM24;
            result.m[8] = initialM31;
            result.m[9] = initialM32;
            result.m[10] = initialM33;
            result.m[11] = initialM34;
            result.m[12] = initialM41;
            result.m[13] = initialM42;
            result.m[14] = initialM43;
            result.m[15] = initialM44;
            result._markAsUpdated();
        };
        Object.defineProperty(Matrix, "IdentityReadOnly", {
            /**
             * Gets an identity matrix that must not be updated
             */
            get: function () {
                return Matrix._identityReadOnly;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Creates new matrix from a list of values (16)
         * @param initialM11 defines 1st value of 1st row
         * @param initialM12 defines 2nd value of 1st row
         * @param initialM13 defines 3rd value of 1st row
         * @param initialM14 defines 4th value of 1st row
         * @param initialM21 defines 1st value of 2nd row
         * @param initialM22 defines 2nd value of 2nd row
         * @param initialM23 defines 3rd value of 2nd row
         * @param initialM24 defines 4th value of 2nd row
         * @param initialM31 defines 1st value of 3rd row
         * @param initialM32 defines 2nd value of 3rd row
         * @param initialM33 defines 3rd value of 3rd row
         * @param initialM34 defines 4th value of 3rd row
         * @param initialM41 defines 1st value of 4th row
         * @param initialM42 defines 2nd value of 4th row
         * @param initialM43 defines 3rd value of 4th row
         * @param initialM44 defines 4th value of 4th row
         * @returns the new matrix
         */
        Matrix.FromValues = function (initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44) {
            var result = new Matrix();
            result.m[0] = initialM11;
            result.m[1] = initialM12;
            result.m[2] = initialM13;
            result.m[3] = initialM14;
            result.m[4] = initialM21;
            result.m[5] = initialM22;
            result.m[6] = initialM23;
            result.m[7] = initialM24;
            result.m[8] = initialM31;
            result.m[9] = initialM32;
            result.m[10] = initialM33;
            result.m[11] = initialM34;
            result.m[12] = initialM41;
            result.m[13] = initialM42;
            result.m[14] = initialM43;
            result.m[15] = initialM44;
            return result;
        };
        /**
         * Creates a new matrix composed by merging scale (vector3), rotation (quaternion) and translation (vector3)
         * @param scale defines the scale vector3
         * @param rotation defines the rotation quaternion
         * @param translation defines the translation vector3
         * @returns a new matrix
         */
        Matrix.Compose = function (scale, rotation, translation) {
            var result = Matrix.Identity();
            Matrix.ComposeToRef(scale, rotation, translation, result);
            return result;
        };
        /**
         * Sets a matrix to a value composed by merging scale (vector3), rotation (quaternion) and translation (vector3)
         * @param scale defines the scale vector3
         * @param rotation defines the rotation quaternion
         * @param translation defines the translation vector3
         * @param result defines the target matrix
         */
        Matrix.ComposeToRef = function (scale, rotation, translation, result) {
            Matrix.FromValuesToRef(scale.x, 0, 0, 0, 0, scale.y, 0, 0, 0, 0, scale.z, 0, 0, 0, 0, 1, MathTmp.Matrix[1]);
            rotation.toRotationMatrix(MathTmp.Matrix[0]);
            MathTmp.Matrix[1].multiplyToRef(MathTmp.Matrix[0], result);
            result.setTranslation(translation);
        };
        /**
         * Creates a new identity matrix
         * @returns a new identity matrix
         */
        Matrix.Identity = function () {
            return Matrix.FromValues(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        };
        /**
         * Creates a new identity matrix and stores the result in a given matrix
         * @param result defines the target matrix
         */
        Matrix.IdentityToRef = function (result) {
            Matrix.FromValuesToRef(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, result);
        };
        /**
         * Creates a new zero matrix
         * @returns a new zero matrix
         */
        Matrix.Zero = function () {
            return Matrix.FromValues(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the X axis
         * @param angle defines the angle (in radians) to use
         * @return the new matrix
         */
        Matrix.RotationX = function (angle) {
            var result = new Matrix();
            Matrix.RotationXToRef(angle, result);
            return result;
        };
        /**
         * Creates a new matrix as the invert of a given matrix
         * @param source defines the source matrix
         * @returns the new matrix
         */
        Matrix.Invert = function (source) {
            var result = new Matrix();
            source.invertToRef(result);
            return result;
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the X axis and stores it in a given matrix
         * @param angle defines the angle (in radians) to use
         * @param result defines the target matrix
         */
        Matrix.RotationXToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[0] = 1.0;
            result.m[15] = 1.0;
            result.m[5] = c;
            result.m[10] = c;
            result.m[9] = -s;
            result.m[6] = s;
            result.m[1] = 0.0;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the Y axis
         * @param angle defines the angle (in radians) to use
         * @return the new matrix
         */
        Matrix.RotationY = function (angle) {
            var result = new Matrix();
            Matrix.RotationYToRef(angle, result);
            return result;
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the Y axis and stores it in a given matrix
         * @param angle defines the angle (in radians) to use
         * @param result defines the target matrix
         */
        Matrix.RotationYToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[5] = 1.0;
            result.m[15] = 1.0;
            result.m[0] = c;
            result.m[2] = -s;
            result.m[8] = s;
            result.m[10] = c;
            result.m[1] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[9] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the Z axis
         * @param angle defines the angle (in radians) to use
         * @return the new matrix
         */
        Matrix.RotationZ = function (angle) {
            var result = new Matrix();
            Matrix.RotationZToRef(angle, result);
            return result;
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the Z axis and stores it in a given matrix
         * @param angle defines the angle (in radians) to use
         * @param result defines the target matrix
         */
        Matrix.RotationZToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[10] = 1.0;
            result.m[15] = 1.0;
            result.m[0] = c;
            result.m[1] = s;
            result.m[4] = -s;
            result.m[5] = c;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[9] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the given axis
         * @param axis defines the axis to use
         * @param angle defines the angle (in radians) to use
         * @return the new matrix
         */
        Matrix.RotationAxis = function (axis, angle) {
            var result = Matrix.Zero();
            Matrix.RotationAxisToRef(axis, angle, result);
            return result;
        };
        /**
         * Creates a new rotation matrix for "angle" radians around the given axis and stores it in a given matrix
         * @param axis defines the axis to use
         * @param angle defines the angle (in radians) to use
         * @param result defines the target matrix
         */
        Matrix.RotationAxisToRef = function (axis, angle, result) {
            var s = Math.sin(-angle);
            var c = Math.cos(-angle);
            var c1 = 1 - c;
            axis.normalize();
            result.m[0] = (axis.x * axis.x) * c1 + c;
            result.m[1] = (axis.x * axis.y) * c1 - (axis.z * s);
            result.m[2] = (axis.x * axis.z) * c1 + (axis.y * s);
            result.m[3] = 0.0;
            result.m[4] = (axis.y * axis.x) * c1 + (axis.z * s);
            result.m[5] = (axis.y * axis.y) * c1 + c;
            result.m[6] = (axis.y * axis.z) * c1 - (axis.x * s);
            result.m[7] = 0.0;
            result.m[8] = (axis.z * axis.x) * c1 - (axis.y * s);
            result.m[9] = (axis.z * axis.y) * c1 + (axis.x * s);
            result.m[10] = (axis.z * axis.z) * c1 + c;
            result.m[11] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Creates a rotation matrix
         * @param yaw defines the yaw angle in radians (Y axis)
         * @param pitch defines the pitch angle in radians (X axis)
         * @param roll defines the roll angle in radians (X axis)
         * @returns the new rotation matrix
         */
        Matrix.RotationYawPitchRoll = function (yaw, pitch, roll) {
            var result = new Matrix();
            Matrix.RotationYawPitchRollToRef(yaw, pitch, roll, result);
            return result;
        };
        /**
         * Creates a rotation matrix and stores it in a given matrix
         * @param yaw defines the yaw angle in radians (Y axis)
         * @param pitch defines the pitch angle in radians (X axis)
         * @param roll defines the roll angle in radians (X axis)
         * @param result defines the target matrix
         */
        Matrix.RotationYawPitchRollToRef = function (yaw, pitch, roll, result) {
            Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, this._tempQuaternion);
            this._tempQuaternion.toRotationMatrix(result);
        };
        /**
         * Creates a scaling matrix
         * @param x defines the scale factor on X axis
         * @param y defines the scale factor on Y axis
         * @param z defines the scale factor on Z axis
         * @returns the new matrix
         */
        Matrix.Scaling = function (x, y, z) {
            var result = Matrix.Zero();
            Matrix.ScalingToRef(x, y, z, result);
            return result;
        };
        /**
         * Creates a scaling matrix and stores it in a given matrix
         * @param x defines the scale factor on X axis
         * @param y defines the scale factor on Y axis
         * @param z defines the scale factor on Z axis
         * @param result defines the target matrix
         */
        Matrix.ScalingToRef = function (x, y, z, result) {
            result.m[0] = x;
            result.m[1] = 0.0;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[5] = y;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[9] = 0.0;
            result.m[10] = z;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Creates a translation matrix
         * @param x defines the translation on X axis
         * @param y defines the translation on Y axis
         * @param z defines the translationon Z axis
         * @returns the new matrix
         */
        Matrix.Translation = function (x, y, z) {
            var result = Matrix.Identity();
            Matrix.TranslationToRef(x, y, z, result);
            return result;
        };
        /**
         * Creates a translation matrix and stores it in a given matrix
         * @param x defines the translation on X axis
         * @param y defines the translation on Y axis
         * @param z defines the translationon Z axis
         * @param result defines the target matrix
         */
        Matrix.TranslationToRef = function (x, y, z, result) {
            Matrix.FromValuesToRef(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, x, y, z, 1.0, result);
        };
        /**
         * Returns a new Matrix whose values are the interpolated values for "gradient" (float) between the ones of the matrices "startValue" and "endValue".
         * @param startValue defines the start value
         * @param endValue defines the end value
         * @param gradient defines the gradient factor
         * @returns the new matrix
         */
        Matrix.Lerp = function (startValue, endValue, gradient) {
            var result = Matrix.Zero();
            Matrix.LerpToRef(startValue, endValue, gradient, result);
            return result;
        };
        /**
         * Set the given matrix "result" as the interpolated values for "gradient" (float) between the ones of the matrices "startValue" and "endValue".
         * @param startValue defines the start value
         * @param endValue defines the end value
         * @param gradient defines the gradient factor
         * @param result defines the Matrix object where to store data
         */
        Matrix.LerpToRef = function (startValue, endValue, gradient, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = startValue.m[index] * (1.0 - gradient) + endValue.m[index] * gradient;
            }
            result._markAsUpdated();
        };
        /**
         * Builds a new matrix whose values are computed by:
         * * decomposing the the "startValue" and "endValue" matrices into their respective scale, rotation and translation matrices
         * * interpolating for "gradient" (float) the values between each of these decomposed matrices between the start and the end
         * * recomposing a new matrix from these 3 interpolated scale, rotation and translation matrices
         * @param startValue defines the first matrix
         * @param endValue defines the second matrix
         * @param gradient defines the gradient between the two matrices
         * @returns the new matrix
         */
        Matrix.DecomposeLerp = function (startValue, endValue, gradient) {
            var result = Matrix.Zero();
            Matrix.DecomposeLerpToRef(startValue, endValue, gradient, result);
            return result;
        };
        /**
         * Update a matrix to values which are computed by:
         * * decomposing the the "startValue" and "endValue" matrices into their respective scale, rotation and translation matrices
         * * interpolating for "gradient" (float) the values between each of these decomposed matrices between the start and the end
         * * recomposing a new matrix from these 3 interpolated scale, rotation and translation matrices
         * @param startValue defines the first matrix
         * @param endValue defines the second matrix
         * @param gradient defines the gradient between the two matrices
         * @param result defines the target matrix
         */
        Matrix.DecomposeLerpToRef = function (startValue, endValue, gradient, result) {
            var startScale = MathTmp.Vector3[0];
            var startRotation = MathTmp.Quaternion[0];
            var startTranslation = MathTmp.Vector3[1];
            startValue.decompose(startScale, startRotation, startTranslation);
            var endScale = MathTmp.Vector3[2];
            var endRotation = MathTmp.Quaternion[1];
            var endTranslation = MathTmp.Vector3[3];
            endValue.decompose(endScale, endRotation, endTranslation);
            var resultScale = MathTmp.Vector3[4];
            Vector3.LerpToRef(startScale, endScale, gradient, resultScale);
            var resultRotation = MathTmp.Quaternion[2];
            Quaternion.SlerpToRef(startRotation, endRotation, gradient, resultRotation);
            var resultTranslation = MathTmp.Vector3[5];
            Vector3.LerpToRef(startTranslation, endTranslation, gradient, resultTranslation);
            Matrix.ComposeToRef(resultScale, resultRotation, resultTranslation, result);
        };
        /**
         * Gets a new rotation matrix used to rotate an entity so as it looks at the target vector3, from the eye vector3 position, the up vector3 being oriented like "up"
         * This function works in left handed mode
         * @param eye defines the final position of the entity
         * @param target defines where the entity should look at
         * @param up defines the up vector for the entity
         * @returns the new matrix
         */
        Matrix.LookAtLH = function (eye, target, up) {
            var result = Matrix.Zero();
            Matrix.LookAtLHToRef(eye, target, up, result);
            return result;
        };
        /**
         * Sets the given "result" Matrix to a rotation matrix used to rotate an entity so that it looks at the target vector3, from the eye vector3 position, the up vector3 being oriented like "up".
         * This function works in left handed mode
         * @param eye defines the final position of the entity
         * @param target defines where the entity should look at
         * @param up defines the up vector for the entity
         * @param result defines the target matrix
         */
        Matrix.LookAtLHToRef = function (eye, target, up, result) {
            // Z axis
            target.subtractToRef(eye, this._zAxis);
            this._zAxis.normalize();
            // X axis
            Vector3.CrossToRef(up, this._zAxis, this._xAxis);
            if (this._xAxis.lengthSquared() === 0) {
                this._xAxis.x = 1.0;
            }
            else {
                this._xAxis.normalize();
            }
            // Y axis
            Vector3.CrossToRef(this._zAxis, this._xAxis, this._yAxis);
            this._yAxis.normalize();
            // Eye angles
            var ex = -Vector3.Dot(this._xAxis, eye);
            var ey = -Vector3.Dot(this._yAxis, eye);
            var ez = -Vector3.Dot(this._zAxis, eye);
            return Matrix.FromValuesToRef(this._xAxis.x, this._yAxis.x, this._zAxis.x, 0, this._xAxis.y, this._yAxis.y, this._zAxis.y, 0, this._xAxis.z, this._yAxis.z, this._zAxis.z, 0, ex, ey, ez, 1, result);
        };
        /**
         * Gets a new rotation matrix used to rotate an entity so as it looks at the target vector3, from the eye vector3 position, the up vector3 being oriented like "up"
         * This function works in right handed mode
         * @param eye defines the final position of the entity
         * @param target defines where the entity should look at
         * @param up defines the up vector for the entity
         * @returns the new matrix
         */
        Matrix.LookAtRH = function (eye, target, up) {
            var result = Matrix.Zero();
            Matrix.LookAtRHToRef(eye, target, up, result);
            return result;
        };
        /**
         * Sets the given "result" Matrix to a rotation matrix used to rotate an entity so that it looks at the target vector3, from the eye vector3 position, the up vector3 being oriented like "up".
         * This function works in right handed mode
         * @param eye defines the final position of the entity
         * @param target defines where the entity should look at
         * @param up defines the up vector for the entity
         * @param result defines the target matrix
         */
        Matrix.LookAtRHToRef = function (eye, target, up, result) {
            // Z axis
            eye.subtractToRef(target, this._zAxis);
            this._zAxis.normalize();
            // X axis
            Vector3.CrossToRef(up, this._zAxis, this._xAxis);
            if (this._xAxis.lengthSquared() === 0) {
                this._xAxis.x = 1.0;
            }
            else {
                this._xAxis.normalize();
            }
            // Y axis
            Vector3.CrossToRef(this._zAxis, this._xAxis, this._yAxis);
            this._yAxis.normalize();
            // Eye angles
            var ex = -Vector3.Dot(this._xAxis, eye);
            var ey = -Vector3.Dot(this._yAxis, eye);
            var ez = -Vector3.Dot(this._zAxis, eye);
            return Matrix.FromValuesToRef(this._xAxis.x, this._yAxis.x, this._zAxis.x, 0, this._xAxis.y, this._yAxis.y, this._zAxis.y, 0, this._xAxis.z, this._yAxis.z, this._zAxis.z, 0, ex, ey, ez, 1, result);
        };
        /**
         * Create a left-handed orthographic projection matrix
         * @param width defines the viewport width
         * @param height defines the viewport height
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a left-handed orthographic projection matrix
         */
        Matrix.OrthoLH = function (width, height, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoLHToRef(width, height, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Store a left-handed orthographic projection to a given matrix
         * @param width defines the viewport width
         * @param height defines the viewport height
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         */
        Matrix.OrthoLHToRef = function (width, height, znear, zfar, result) {
            var n = znear;
            var f = zfar;
            var a = 2.0 / width;
            var b = 2.0 / height;
            var c = 2.0 / (f - n);
            var d = -(f + n) / (f - n);
            Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 0.0, 0.0, 0.0, d, 1.0, result);
        };
        /**
         * Create a left-handed orthographic projection matrix
         * @param left defines the viewport left coordinate
         * @param right defines the viewport right coordinate
         * @param bottom defines the viewport bottom coordinate
         * @param top defines the viewport top coordinate
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a left-handed orthographic projection matrix
         */
        Matrix.OrthoOffCenterLH = function (left, right, bottom, top, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Stores a left-handed orthographic projection into a given matrix
         * @param left defines the viewport left coordinate
         * @param right defines the viewport right coordinate
         * @param bottom defines the viewport bottom coordinate
         * @param top defines the viewport top coordinate
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         */
        Matrix.OrthoOffCenterLHToRef = function (left, right, bottom, top, znear, zfar, result) {
            var n = znear;
            var f = zfar;
            var a = 2.0 / (right - left);
            var b = 2.0 / (top - bottom);
            var c = 2.0 / (f - n);
            var d = -(f + n) / (f - n);
            var i0 = (left + right) / (left - right);
            var i1 = (top + bottom) / (bottom - top);
            Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 0.0, i0, i1, d, 1.0, result);
        };
        /**
         * Creates a right-handed orthographic projection matrix
         * @param left defines the viewport left coordinate
         * @param right defines the viewport right coordinate
         * @param bottom defines the viewport bottom coordinate
         * @param top defines the viewport top coordinate
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a right-handed orthographic projection matrix
         */
        Matrix.OrthoOffCenterRH = function (left, right, bottom, top, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoOffCenterRHToRef(left, right, bottom, top, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Stores a right-handed orthographic projection into a given matrix
         * @param left defines the viewport left coordinate
         * @param right defines the viewport right coordinate
         * @param bottom defines the viewport bottom coordinate
         * @param top defines the viewport top coordinate
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         */
        Matrix.OrthoOffCenterRHToRef = function (left, right, bottom, top, znear, zfar, result) {
            Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, result);
            result.m[10] *= -1.0;
        };
        /**
         * Creates a left-handed perspective projection matrix
         * @param width defines the viewport width
         * @param height defines the viewport height
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a left-handed perspective projection matrix
         */
        Matrix.PerspectiveLH = function (width, height, znear, zfar) {
            var matrix = Matrix.Zero();
            var n = znear;
            var f = zfar;
            var a = 2.0 * n / width;
            var b = 2.0 * n / height;
            var c = (f + n) / (f - n);
            var d = -2.0 * f * n / (f - n);
            Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 1.0, 0.0, 0.0, d, 0.0, matrix);
            return matrix;
        };
        /**
         * Creates a left-handed perspective projection matrix
         * @param fov defines the horizontal field of view
         * @param aspect defines the aspect ratio
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a left-handed perspective projection matrix
         */
        Matrix.PerspectiveFovLH = function (fov, aspect, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.PerspectiveFovLHToRef(fov, aspect, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Stores a left-handed perspective projection into a given matrix
         * @param fov defines the horizontal field of view
         * @param aspect defines the aspect ratio
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
         */
        Matrix.PerspectiveFovLHToRef = function (fov, aspect, znear, zfar, result, isVerticalFovFixed) {
            if (isVerticalFovFixed === void 0) { isVerticalFovFixed = true; }
            var n = znear;
            var f = zfar;
            var t = 1.0 / (Math.tan(fov * 0.5));
            var a = isVerticalFovFixed ? (t / aspect) : t;
            var b = isVerticalFovFixed ? t : (t * aspect);
            var c = (f + n) / (f - n);
            var d = -2.0 * f * n / (f - n);
            Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 1.0, 0.0, 0.0, d, 0.0, result);
        };
        /**
         * Creates a right-handed perspective projection matrix
         * @param fov defines the horizontal field of view
         * @param aspect defines the aspect ratio
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @returns a new matrix as a right-handed perspective projection matrix
         */
        Matrix.PerspectiveFovRH = function (fov, aspect, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.PerspectiveFovRHToRef(fov, aspect, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Stores a right-handed perspective projection into a given matrix
         * @param fov defines the horizontal field of view
         * @param aspect defines the aspect ratio
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
         */
        Matrix.PerspectiveFovRHToRef = function (fov, aspect, znear, zfar, result, isVerticalFovFixed) {
            //alternatively this could be expressed as:
            //    m = PerspectiveFovLHToRef
            //    m[10] *= -1.0;
            //    m[11] *= -1.0;
            if (isVerticalFovFixed === void 0) { isVerticalFovFixed = true; }
            var n = znear;
            var f = zfar;
            var t = 1.0 / (Math.tan(fov * 0.5));
            var a = isVerticalFovFixed ? (t / aspect) : t;
            var b = isVerticalFovFixed ? t : (t * aspect);
            var c = -(f + n) / (f - n);
            var d = -2 * f * n / (f - n);
            Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, -1.0, 0.0, 0.0, d, 0.0, result);
        };
        /**
         * Stores a perspective projection for WebVR info a given matrix
         * @param fov defines the field of view
         * @param znear defines the near clip plane
         * @param zfar defines the far clip plane
         * @param result defines the target matrix
         * @param rightHanded defines if the matrix must be in right-handed mode (false by default)
         */
        Matrix.PerspectiveFovWebVRToRef = function (fov, znear, zfar, result, rightHanded) {
            if (rightHanded === void 0) { rightHanded = false; }
            var rightHandedFactor = rightHanded ? -1 : 1;
            var upTan = Math.tan(fov.upDegrees * Math.PI / 180.0);
            var downTan = Math.tan(fov.downDegrees * Math.PI / 180.0);
            var leftTan = Math.tan(fov.leftDegrees * Math.PI / 180.0);
            var rightTan = Math.tan(fov.rightDegrees * Math.PI / 180.0);
            var xScale = 2.0 / (leftTan + rightTan);
            var yScale = 2.0 / (upTan + downTan);
            result.m[0] = xScale;
            result.m[1] = result.m[2] = result.m[3] = result.m[4] = 0.0;
            result.m[5] = yScale;
            result.m[6] = result.m[7] = 0.0;
            result.m[8] = ((leftTan - rightTan) * xScale * 0.5);
            result.m[9] = -((upTan - downTan) * yScale * 0.5);
            result.m[10] = -zfar / (znear - zfar);
            result.m[11] = 1.0 * rightHandedFactor;
            result.m[12] = result.m[13] = result.m[15] = 0.0;
            result.m[14] = -(2.0 * zfar * znear) / (zfar - znear);
            result._markAsUpdated();
        };
        /**
         * Computes a complete transformation matrix
         * @param viewport defines the viewport to use
         * @param world defines the world matrix
         * @param view defines the view matrix
         * @param projection defines the projection matrix
         * @param zmin defines the near clip plane
         * @param zmax defines the far clip plane
         * @returns the transformation matrix
         */
        Matrix.GetFinalMatrix = function (viewport, world, view, projection, zmin, zmax) {
            var cw = viewport.width;
            var ch = viewport.height;
            var cx = viewport.x;
            var cy = viewport.y;
            var viewportMatrix = Matrix.FromValues(cw / 2.0, 0.0, 0.0, 0.0, 0.0, -ch / 2.0, 0.0, 0.0, 0.0, 0.0, zmax - zmin, 0.0, cx + cw / 2.0, ch / 2.0 + cy, zmin, 1);
            return world.multiply(view).multiply(projection).multiply(viewportMatrix);
        };
        /**
         * Extracts a 2x2 matrix from a given matrix and store the result in a Float32Array
         * @param matrix defines the matrix to use
         * @returns a new Float32Array array with 4 elements : the 2x2 matrix extracted from the given matrix
         */
        Matrix.GetAsMatrix2x2 = function (matrix) {
            return new Float32Array([
                matrix.m[0], matrix.m[1],
                matrix.m[4], matrix.m[5]
            ]);
        };
        /**
         * Extracts a 3x3 matrix from a given matrix and store the result in a Float32Array
         * @param matrix defines the matrix to use
         * @returns a new Float32Array array with 9 elements : the 3x3 matrix extracted from the given matrix
         */
        Matrix.GetAsMatrix3x3 = function (matrix) {
            return new Float32Array([
                matrix.m[0], matrix.m[1], matrix.m[2],
                matrix.m[4], matrix.m[5], matrix.m[6],
                matrix.m[8], matrix.m[9], matrix.m[10]
            ]);
        };
        /**
         * Compute the transpose of a given matrix
         * @param matrix defines the matrix to transpose
         * @returns the new matrix
         */
        Matrix.Transpose = function (matrix) {
            var result = new Matrix();
            Matrix.TransposeToRef(matrix, result);
            return result;
        };
        /**
         * Compute the transpose of a matrix and store it in a target matrix
         * @param matrix defines the matrix to transpose
         * @param result defines the target matrix
         */
        Matrix.TransposeToRef = function (matrix, result) {
            result.m[0] = matrix.m[0];
            result.m[1] = matrix.m[4];
            result.m[2] = matrix.m[8];
            result.m[3] = matrix.m[12];
            result.m[4] = matrix.m[1];
            result.m[5] = matrix.m[5];
            result.m[6] = matrix.m[9];
            result.m[7] = matrix.m[13];
            result.m[8] = matrix.m[2];
            result.m[9] = matrix.m[6];
            result.m[10] = matrix.m[10];
            result.m[11] = matrix.m[14];
            result.m[12] = matrix.m[3];
            result.m[13] = matrix.m[7];
            result.m[14] = matrix.m[11];
            result.m[15] = matrix.m[15];
        };
        /**
         * Computes a reflection matrix from a plane
         * @param plane defines the reflection plane
         * @returns a new matrix
         */
        Matrix.Reflection = function (plane) {
            var matrix = new Matrix();
            Matrix.ReflectionToRef(plane, matrix);
            return matrix;
        };
        /**
         * Computes a reflection matrix from a plane
         * @param plane defines the reflection plane
         * @param result defines the target matrix
         */
        Matrix.ReflectionToRef = function (plane, result) {
            plane.normalize();
            var x = plane.normal.x;
            var y = plane.normal.y;
            var z = plane.normal.z;
            var temp = -2 * x;
            var temp2 = -2 * y;
            var temp3 = -2 * z;
            result.m[0] = (temp * x) + 1;
            result.m[1] = temp2 * x;
            result.m[2] = temp3 * x;
            result.m[3] = 0.0;
            result.m[4] = temp * y;
            result.m[5] = (temp2 * y) + 1;
            result.m[6] = temp3 * y;
            result.m[7] = 0.0;
            result.m[8] = temp * z;
            result.m[9] = temp2 * z;
            result.m[10] = (temp3 * z) + 1;
            result.m[11] = 0.0;
            result.m[12] = temp * plane.d;
            result.m[13] = temp2 * plane.d;
            result.m[14] = temp3 * plane.d;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Sets the given matrix as a rotation matrix composed from the 3 left handed axes
         * @param xaxis defines the value of the 1st axis
         * @param yaxis defines the value of the 2nd axis
         * @param zaxis defines the value of the 3rd axis
         * @param result defines the target matrix
         */
        Matrix.FromXYZAxesToRef = function (xaxis, yaxis, zaxis, result) {
            result.m[0] = xaxis.x;
            result.m[1] = xaxis.y;
            result.m[2] = xaxis.z;
            result.m[3] = 0.0;
            result.m[4] = yaxis.x;
            result.m[5] = yaxis.y;
            result.m[6] = yaxis.z;
            result.m[7] = 0.0;
            result.m[8] = zaxis.x;
            result.m[9] = zaxis.y;
            result.m[10] = zaxis.z;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Creates a rotation matrix from a quaternion and stores it in a target matrix
         * @param quat defines the quaternion to use
         * @param result defines the target matrix
         */
        Matrix.FromQuaternionToRef = function (quat, result) {
            var xx = quat.x * quat.x;
            var yy = quat.y * quat.y;
            var zz = quat.z * quat.z;
            var xy = quat.x * quat.y;
            var zw = quat.z * quat.w;
            var zx = quat.z * quat.x;
            var yw = quat.y * quat.w;
            var yz = quat.y * quat.z;
            var xw = quat.x * quat.w;
            result.m[0] = 1.0 - (2.0 * (yy + zz));
            result.m[1] = 2.0 * (xy + zw);
            result.m[2] = 2.0 * (zx - yw);
            result.m[3] = 0.0;
            result.m[4] = 2.0 * (xy - zw);
            result.m[5] = 1.0 - (2.0 * (zz + xx));
            result.m[6] = 2.0 * (yz + xw);
            result.m[7] = 0.0;
            result.m[8] = 2.0 * (zx + yw);
            result.m[9] = 2.0 * (yz - xw);
            result.m[10] = 1.0 - (2.0 * (yy + xx));
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        Matrix._tempQuaternion = new Quaternion();
        Matrix._xAxis = Vector3.Zero();
        Matrix._yAxis = Vector3.Zero();
        Matrix._zAxis = Vector3.Zero();
        Matrix._updateFlagSeed = 0;
        Matrix._identityReadOnly = Matrix.Identity();
        return Matrix;
    }());
    BABYLON.Matrix = Matrix;
    var Plane = /** @class */ (function () {
        /**
         * Creates a Plane object according to the given floats a, b, c, d and the plane equation : ax + by + cz + d = 0
         */
        function Plane(a, b, c, d) {
            this.normal = new Vector3(a, b, c);
            this.d = d;
        }
        /**
         * Returns the plane coordinates as a new array of 4 elements [a, b, c, d].
         */
        Plane.prototype.asArray = function () {
            return [this.normal.x, this.normal.y, this.normal.z, this.d];
        };
        // Methods
        /**
         * Returns a new plane copied from the current Plane.
         */
        Plane.prototype.clone = function () {
            return new Plane(this.normal.x, this.normal.y, this.normal.z, this.d);
        };
        /**
         * Returns the string "Plane".
         */
        Plane.prototype.getClassName = function () {
            return "Plane";
        };
        /**
         * Returns the Plane hash code.
         */
        Plane.prototype.getHashCode = function () {
            var hash = this.normal.getHashCode();
            hash = (hash * 397) ^ (this.d || 0);
            return hash;
        };
        /**
         * Normalize the current Plane in place.
         * Returns the updated Plane.
         */
        Plane.prototype.normalize = function () {
            var norm = (Math.sqrt((this.normal.x * this.normal.x) + (this.normal.y * this.normal.y) + (this.normal.z * this.normal.z)));
            var magnitude = 0.0;
            if (norm !== 0) {
                magnitude = 1.0 / norm;
            }
            this.normal.x *= magnitude;
            this.normal.y *= magnitude;
            this.normal.z *= magnitude;
            this.d *= magnitude;
            return this;
        };
        /**
         * Returns a new Plane as the result of the transformation of the current Plane by the given matrix.
         */
        Plane.prototype.transform = function (transformation) {
            var transposedMatrix = Matrix.Transpose(transformation);
            var x = this.normal.x;
            var y = this.normal.y;
            var z = this.normal.z;
            var d = this.d;
            var normalX = (((x * transposedMatrix.m[0]) + (y * transposedMatrix.m[1])) + (z * transposedMatrix.m[2])) + (d * transposedMatrix.m[3]);
            var normalY = (((x * transposedMatrix.m[4]) + (y * transposedMatrix.m[5])) + (z * transposedMatrix.m[6])) + (d * transposedMatrix.m[7]);
            var normalZ = (((x * transposedMatrix.m[8]) + (y * transposedMatrix.m[9])) + (z * transposedMatrix.m[10])) + (d * transposedMatrix.m[11]);
            var finalD = (((x * transposedMatrix.m[12]) + (y * transposedMatrix.m[13])) + (z * transposedMatrix.m[14])) + (d * transposedMatrix.m[15]);
            return new Plane(normalX, normalY, normalZ, finalD);
        };
        /**
         * Returns the dot product (float) of the point coordinates and the plane normal.
         */
        Plane.prototype.dotCoordinate = function (point) {
            return ((((this.normal.x * point.x) + (this.normal.y * point.y)) + (this.normal.z * point.z)) + this.d);
        };
        /**
         * Updates the current Plane from the plane defined by the three given points.
         * Returns the updated Plane.
         */
        Plane.prototype.copyFromPoints = function (point1, point2, point3) {
            var x1 = point2.x - point1.x;
            var y1 = point2.y - point1.y;
            var z1 = point2.z - point1.z;
            var x2 = point3.x - point1.x;
            var y2 = point3.y - point1.y;
            var z2 = point3.z - point1.z;
            var yz = (y1 * z2) - (z1 * y2);
            var xz = (z1 * x2) - (x1 * z2);
            var xy = (x1 * y2) - (y1 * x2);
            var pyth = (Math.sqrt((yz * yz) + (xz * xz) + (xy * xy)));
            var invPyth;
            if (pyth !== 0) {
                invPyth = 1.0 / pyth;
            }
            else {
                invPyth = 0.0;
            }
            this.normal.x = yz * invPyth;
            this.normal.y = xz * invPyth;
            this.normal.z = xy * invPyth;
            this.d = -((this.normal.x * point1.x) + (this.normal.y * point1.y) + (this.normal.z * point1.z));
            return this;
        };
        /**
         * Boolean : True is the vector "direction"  is the same side than the plane normal.
         */
        Plane.prototype.isFrontFacingTo = function (direction, epsilon) {
            var dot = Vector3.Dot(this.normal, direction);
            return (dot <= epsilon);
        };
        /**
         * Returns the signed distance (float) from the given point to the Plane.
         */
        Plane.prototype.signedDistanceTo = function (point) {
            return Vector3.Dot(point, this.normal) + this.d;
        };
        // Statics
        /**
         * Returns a new Plane from the given array.
         */
        Plane.FromArray = function (array) {
            return new Plane(array[0], array[1], array[2], array[3]);
        };
        /**
         * Returns a new Plane defined by the three given points.
         */
        Plane.FromPoints = function (point1, point2, point3) {
            var result = new Plane(0.0, 0.0, 0.0, 0.0);
            result.copyFromPoints(point1, point2, point3);
            return result;
        };
        /**
         * Returns a new Plane the normal vector to this plane at the given origin point.
         * Note : the vector "normal" is updated because normalized.
         */
        Plane.FromPositionAndNormal = function (origin, normal) {
            var result = new Plane(0.0, 0.0, 0.0, 0.0);
            normal.normalize();
            result.normal = normal;
            result.d = -(normal.x * origin.x + normal.y * origin.y + normal.z * origin.z);
            return result;
        };
        /**
         * Returns the signed distance between the plane defined by the normal vector at the "origin"" point and the given other point.
         */
        Plane.SignedDistanceToPlaneFromPositionAndNormal = function (origin, normal, point) {
            var d = -(normal.x * origin.x + normal.y * origin.y + normal.z * origin.z);
            return Vector3.Dot(point, normal) + d;
        };
        return Plane;
    }());
    BABYLON.Plane = Plane;
    var Viewport = /** @class */ (function () {
        /**
         * Creates a Viewport object located at (x, y) and sized (width, height).
         */
        function Viewport(x, y, width, height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
        Viewport.prototype.toGlobal = function (renderWidthOrEngine, renderHeight) {
            if (renderWidthOrEngine.getRenderWidth) {
                var engine = renderWidthOrEngine;
                return this.toGlobal(engine.getRenderWidth(), engine.getRenderHeight());
            }
            var renderWidth = renderWidthOrEngine;
            return new Viewport(this.x * renderWidth, this.y * renderHeight, this.width * renderWidth, this.height * renderHeight);
        };
        /**
         * Returns a new Viewport copied from the current one.
         */
        Viewport.prototype.clone = function () {
            return new Viewport(this.x, this.y, this.width, this.height);
        };
        return Viewport;
    }());
    BABYLON.Viewport = Viewport;
    var Frustum = /** @class */ (function () {
        function Frustum() {
        }
        /**
         * Returns a new array of 6 Frustum planes computed by the given transformation matrix.
         */
        Frustum.GetPlanes = function (transform) {
            var frustumPlanes = [];
            for (var index = 0; index < 6; index++) {
                frustumPlanes.push(new Plane(0.0, 0.0, 0.0, 0.0));
            }
            Frustum.GetPlanesToRef(transform, frustumPlanes);
            return frustumPlanes;
        };
        Frustum.GetNearPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[2];
            frustumPlane.normal.y = transform.m[7] + transform.m[6];
            frustumPlane.normal.z = transform.m[11] + transform.m[10];
            frustumPlane.d = transform.m[15] + transform.m[14];
            frustumPlane.normalize();
        };
        Frustum.GetFarPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[2];
            frustumPlane.normal.y = transform.m[7] - transform.m[6];
            frustumPlane.normal.z = transform.m[11] - transform.m[10];
            frustumPlane.d = transform.m[15] - transform.m[14];
            frustumPlane.normalize();
        };
        Frustum.GetLeftPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[0];
            frustumPlane.normal.y = transform.m[7] + transform.m[4];
            frustumPlane.normal.z = transform.m[11] + transform.m[8];
            frustumPlane.d = transform.m[15] + transform.m[12];
            frustumPlane.normalize();
        };
        Frustum.GetRightPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[0];
            frustumPlane.normal.y = transform.m[7] - transform.m[4];
            frustumPlane.normal.z = transform.m[11] - transform.m[8];
            frustumPlane.d = transform.m[15] - transform.m[12];
            frustumPlane.normalize();
        };
        Frustum.GetTopPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[1];
            frustumPlane.normal.y = transform.m[7] - transform.m[5];
            frustumPlane.normal.z = transform.m[11] - transform.m[9];
            frustumPlane.d = transform.m[15] - transform.m[13];
            frustumPlane.normalize();
        };
        Frustum.GetBottomPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[1];
            frustumPlane.normal.y = transform.m[7] + transform.m[5];
            frustumPlane.normal.z = transform.m[11] + transform.m[9];
            frustumPlane.d = transform.m[15] + transform.m[13];
            frustumPlane.normalize();
        };
        /**
         * Sets the given array "frustumPlanes" with the 6 Frustum planes computed by the given transformation matrix.
         */
        Frustum.GetPlanesToRef = function (transform, frustumPlanes) {
            // Near
            Frustum.GetNearPlaneToRef(transform, frustumPlanes[0]);
            // Far
            Frustum.GetFarPlaneToRef(transform, frustumPlanes[1]);
            // Left
            Frustum.GetLeftPlaneToRef(transform, frustumPlanes[2]);
            // Right
            Frustum.GetRightPlaneToRef(transform, frustumPlanes[3]);
            // Top
            Frustum.GetTopPlaneToRef(transform, frustumPlanes[4]);
            // Bottom
            Frustum.GetBottomPlaneToRef(transform, frustumPlanes[5]);
        };
        return Frustum;
    }());
    BABYLON.Frustum = Frustum;
    /** Defines supported spaces */
    var Space;
    (function (Space) {
        /** Local (object) space */
        Space[Space["LOCAL"] = 0] = "LOCAL";
        /** World space */
        Space[Space["WORLD"] = 1] = "WORLD";
        /** Bone space */
        Space[Space["BONE"] = 2] = "BONE";
    })(Space = BABYLON.Space || (BABYLON.Space = {}));
    /** Defines the 3 main axes */
    var Axis = /** @class */ (function () {
        function Axis() {
        }
        /** X axis */
        Axis.X = new Vector3(1.0, 0.0, 0.0);
        /** Y axis */
        Axis.Y = new Vector3(0.0, 1.0, 0.0);
        /** Z axis */
        Axis.Z = new Vector3(0.0, 0.0, 1.0);
        return Axis;
    }());
    BABYLON.Axis = Axis;
    ;
    var BezierCurve = /** @class */ (function () {
        function BezierCurve() {
        }
        /**
         * Returns the cubic Bezier interpolated value (float) at "t" (float) from the given x1, y1, x2, y2 floats.
         */
        BezierCurve.interpolate = function (t, x1, y1, x2, y2) {
            // Extract X (which is equal to time here)
            var f0 = 1 - 3 * x2 + 3 * x1;
            var f1 = 3 * x2 - 6 * x1;
            var f2 = 3 * x1;
            var refinedT = t;
            for (var i = 0; i < 5; i++) {
                var refinedT2 = refinedT * refinedT;
                var refinedT3 = refinedT2 * refinedT;
                var x = f0 * refinedT3 + f1 * refinedT2 + f2 * refinedT;
                var slope = 1.0 / (3.0 * f0 * refinedT2 + 2.0 * f1 * refinedT + f2);
                refinedT -= (x - t) * slope;
                refinedT = Math.min(1, Math.max(0, refinedT));
            }
            // Resolve cubic bezier for the given x
            return 3 * Math.pow(1 - refinedT, 2) * refinedT * y1 +
                3 * (1 - refinedT) * Math.pow(refinedT, 2) * y2 +
                Math.pow(refinedT, 3);
        };
        return BezierCurve;
    }());
    BABYLON.BezierCurve = BezierCurve;
    /**
     * Defines potential orientation for back face culling
     */
    var Orientation;
    (function (Orientation) {
        /**
         * Clockwise
         */
        Orientation[Orientation["CW"] = 0] = "CW";
        /** Counter clockwise */
        Orientation[Orientation["CCW"] = 1] = "CCW";
    })(Orientation = BABYLON.Orientation || (BABYLON.Orientation = {}));
    /**
     * Defines angle representation
     */
    var Angle = /** @class */ (function () {
        /**
         * Creates an Angle object of "radians" radians (float).
         */
        function Angle(radians) {
            this._radians = radians;
            if (this._radians < 0.0)
                this._radians += (2.0 * Math.PI);
        }
        /**
         * Get value in degrees
         * @returns the Angle value in degrees (float)
         */
        Angle.prototype.degrees = function () {
            return this._radians * 180.0 / Math.PI;
        };
        /**
         * Get value in radians
         * @returns the Angle value in radians (float)
         */
        Angle.prototype.radians = function () {
            return this._radians;
        };
        /**
         * Gets a new Angle object valued with the angle value in radians between the two given vectors
         * @param a defines first vector
         * @param b defines second vector
         * @returns a new Angle
         */
        Angle.BetweenTwoPoints = function (a, b) {
            var delta = b.subtract(a);
            var theta = Math.atan2(delta.y, delta.x);
            return new Angle(theta);
        };
        /**
         * Gets a new Angle object from the given float in radians
         * @param radians defines the angle value in radians
         * @returns a new Angle
         */
        Angle.FromRadians = function (radians) {
            return new Angle(radians);
        };
        /**
         * Gets a new Angle object from the given float in degrees
         * @param degrees defines the angle value in degrees
         * @returns a new Angle
         */
        Angle.FromDegrees = function (degrees) {
            return new Angle(degrees * Math.PI / 180.0);
        };
        return Angle;
    }());
    BABYLON.Angle = Angle;
    var Arc2 = /** @class */ (function () {
        /**
         * Creates an Arc object from the three given points : start, middle and end.
         */
        function Arc2(startPoint, midPoint, endPoint) {
            this.startPoint = startPoint;
            this.midPoint = midPoint;
            this.endPoint = endPoint;
            var temp = Math.pow(midPoint.x, 2) + Math.pow(midPoint.y, 2);
            var startToMid = (Math.pow(startPoint.x, 2) + Math.pow(startPoint.y, 2) - temp) / 2.;
            var midToEnd = (temp - Math.pow(endPoint.x, 2) - Math.pow(endPoint.y, 2)) / 2.;
            var det = (startPoint.x - midPoint.x) * (midPoint.y - endPoint.y) - (midPoint.x - endPoint.x) * (startPoint.y - midPoint.y);
            this.centerPoint = new Vector2((startToMid * (midPoint.y - endPoint.y) - midToEnd * (startPoint.y - midPoint.y)) / det, ((startPoint.x - midPoint.x) * midToEnd - (midPoint.x - endPoint.x) * startToMid) / det);
            this.radius = this.centerPoint.subtract(this.startPoint).length();
            this.startAngle = Angle.BetweenTwoPoints(this.centerPoint, this.startPoint);
            var a1 = this.startAngle.degrees();
            var a2 = Angle.BetweenTwoPoints(this.centerPoint, this.midPoint).degrees();
            var a3 = Angle.BetweenTwoPoints(this.centerPoint, this.endPoint).degrees();
            // angles correction
            if (a2 - a1 > +180.0)
                a2 -= 360.0;
            if (a2 - a1 < -180.0)
                a2 += 360.0;
            if (a3 - a2 > +180.0)
                a3 -= 360.0;
            if (a3 - a2 < -180.0)
                a3 += 360.0;
            this.orientation = (a2 - a1) < 0 ? Orientation.CW : Orientation.CCW;
            this.angle = Angle.FromDegrees(this.orientation === Orientation.CW ? a1 - a3 : a3 - a1);
        }
        return Arc2;
    }());
    BABYLON.Arc2 = Arc2;
    var Path2 = /** @class */ (function () {
        /**
         * Creates a Path2 object from the starting 2D coordinates x and y.
         */
        function Path2(x, y) {
            this._points = new Array();
            this._length = 0.0;
            this.closed = false;
            this._points.push(new Vector2(x, y));
        }
        /**
         * Adds a new segment until the given coordinates (x, y) to the current Path2.
         * Returns the updated Path2.
         */
        Path2.prototype.addLineTo = function (x, y) {
            if (this.closed) {
                return this;
            }
            var newPoint = new Vector2(x, y);
            var previousPoint = this._points[this._points.length - 1];
            this._points.push(newPoint);
            this._length += newPoint.subtract(previousPoint).length();
            return this;
        };
        /**
         * Adds _numberOfSegments_ segments according to the arc definition (middle point coordinates, end point coordinates, the arc start point being the current Path2 last point) to the current Path2.
         * Returns the updated Path2.
         */
        Path2.prototype.addArcTo = function (midX, midY, endX, endY, numberOfSegments) {
            if (numberOfSegments === void 0) { numberOfSegments = 36; }
            if (this.closed) {
                return this;
            }
            var startPoint = this._points[this._points.length - 1];
            var midPoint = new Vector2(midX, midY);
            var endPoint = new Vector2(endX, endY);
            var arc = new Arc2(startPoint, midPoint, endPoint);
            var increment = arc.angle.radians() / numberOfSegments;
            if (arc.orientation === Orientation.CW)
                increment *= -1;
            var currentAngle = arc.startAngle.radians() + increment;
            for (var i = 0; i < numberOfSegments; i++) {
                var x = Math.cos(currentAngle) * arc.radius + arc.centerPoint.x;
                var y = Math.sin(currentAngle) * arc.radius + arc.centerPoint.y;
                this.addLineTo(x, y);
                currentAngle += increment;
            }
            return this;
        };
        /**
         * Closes the Path2.
         * Returns the Path2.
         */
        Path2.prototype.close = function () {
            this.closed = true;
            return this;
        };
        /**
         * Returns the Path2 total length (float).
         */
        Path2.prototype.length = function () {
            var result = this._length;
            if (!this.closed) {
                var lastPoint = this._points[this._points.length - 1];
                var firstPoint = this._points[0];
                result += (firstPoint.subtract(lastPoint).length());
            }
            return result;
        };
        /**
         * Returns the Path2 internal array of points.
         */
        Path2.prototype.getPoints = function () {
            return this._points;
        };
        /**
         * Returns a new Vector2 located at a percentage of the Path2 total length on this path.
         */
        Path2.prototype.getPointAtLengthPosition = function (normalizedLengthPosition) {
            if (normalizedLengthPosition < 0 || normalizedLengthPosition > 1) {
                return Vector2.Zero();
            }
            var lengthPosition = normalizedLengthPosition * this.length();
            var previousOffset = 0;
            for (var i = 0; i < this._points.length; i++) {
                var j = (i + 1) % this._points.length;
                var a = this._points[i];
                var b = this._points[j];
                var bToA = b.subtract(a);
                var nextOffset = (bToA.length() + previousOffset);
                if (lengthPosition >= previousOffset && lengthPosition <= nextOffset) {
                    var dir = bToA.normalize();
                    var localOffset = lengthPosition - previousOffset;
                    return new Vector2(a.x + (dir.x * localOffset), a.y + (dir.y * localOffset));
                }
                previousOffset = nextOffset;
            }
            return Vector2.Zero();
        };
        /**
         * Returns a new Path2 starting at the coordinates (x, y).
         */
        Path2.StartingAt = function (x, y) {
            return new Path2(x, y);
        };
        return Path2;
    }());
    BABYLON.Path2 = Path2;
    var Path3D = /** @class */ (function () {
        /**
        * new Path3D(path, normal, raw)
        * Creates a Path3D. A Path3D is a logical math object, so not a mesh.
        * please read the description in the tutorial :  http://doc.babylonjs.com/tutorials/How_to_use_Path3D
        * path : an array of Vector3, the curve axis of the Path3D
        * normal (optional) : Vector3, the first wanted normal to the curve. Ex (0, 1, 0) for a vertical normal.
        * raw (optional, default false) : boolean, if true the returned Path3D isn't normalized. Useful to depict path acceleration or speed.
        */
        function Path3D(path, firstNormal, raw) {
            if (firstNormal === void 0) { firstNormal = null; }
            this.path = path;
            this._curve = new Array();
            this._distances = new Array();
            this._tangents = new Array();
            this._normals = new Array();
            this._binormals = new Array();
            for (var p = 0; p < path.length; p++) {
                this._curve[p] = path[p].clone(); // hard copy
            }
            this._raw = raw || false;
            this._compute(firstNormal);
        }
        /**
         * Returns the Path3D array of successive Vector3 designing its curve.
         */
        Path3D.prototype.getCurve = function () {
            return this._curve;
        };
        /**
         * Returns an array populated with tangent vectors on each Path3D curve point.
         */
        Path3D.prototype.getTangents = function () {
            return this._tangents;
        };
        /**
         * Returns an array populated with normal vectors on each Path3D curve point.
         */
        Path3D.prototype.getNormals = function () {
            return this._normals;
        };
        /**
         * Returns an array populated with binormal vectors on each Path3D curve point.
         */
        Path3D.prototype.getBinormals = function () {
            return this._binormals;
        };
        /**
         * Returns an array populated with distances (float) of the i-th point from the first curve point.
         */
        Path3D.prototype.getDistances = function () {
            return this._distances;
        };
        /**
         * Forces the Path3D tangent, normal, binormal and distance recomputation.
         * Returns the same object updated.
         */
        Path3D.prototype.update = function (path, firstNormal) {
            if (firstNormal === void 0) { firstNormal = null; }
            for (var p = 0; p < path.length; p++) {
                this._curve[p].x = path[p].x;
                this._curve[p].y = path[p].y;
                this._curve[p].z = path[p].z;
            }
            this._compute(firstNormal);
            return this;
        };
        // private function compute() : computes tangents, normals and binormals
        Path3D.prototype._compute = function (firstNormal) {
            var l = this._curve.length;
            // first and last tangents
            this._tangents[0] = this._getFirstNonNullVector(0);
            if (!this._raw) {
                this._tangents[0].normalize();
            }
            this._tangents[l - 1] = this._curve[l - 1].subtract(this._curve[l - 2]);
            if (!this._raw) {
                this._tangents[l - 1].normalize();
            }
            // normals and binormals at first point : arbitrary vector with _normalVector()
            var tg0 = this._tangents[0];
            var pp0 = this._normalVector(this._curve[0], tg0, firstNormal);
            this._normals[0] = pp0;
            if (!this._raw) {
                this._normals[0].normalize();
            }
            this._binormals[0] = Vector3.Cross(tg0, this._normals[0]);
            if (!this._raw) {
                this._binormals[0].normalize();
            }
            this._distances[0] = 0.0;
            // normals and binormals : next points
            var prev; // previous vector (segment)
            var cur; // current vector (segment)
            var curTang; // current tangent
            // previous normal
            var prevBinor; // previous binormal
            for (var i = 1; i < l; i++) {
                // tangents
                prev = this._getLastNonNullVector(i);
                if (i < l - 1) {
                    cur = this._getFirstNonNullVector(i);
                    this._tangents[i] = prev.add(cur);
                    this._tangents[i].normalize();
                }
                this._distances[i] = this._distances[i - 1] + prev.length();
                // normals and binormals
                // http://www.cs.cmu.edu/afs/andrew/scs/cs/15-462/web/old/asst2camera.html
                curTang = this._tangents[i];
                prevBinor = this._binormals[i - 1];
                this._normals[i] = Vector3.Cross(prevBinor, curTang);
                if (!this._raw) {
                    this._normals[i].normalize();
                }
                this._binormals[i] = Vector3.Cross(curTang, this._normals[i]);
                if (!this._raw) {
                    this._binormals[i].normalize();
                }
            }
        };
        // private function getFirstNonNullVector(index)
        // returns the first non null vector from index : curve[index + N].subtract(curve[index])
        Path3D.prototype._getFirstNonNullVector = function (index) {
            var i = 1;
            var nNVector = this._curve[index + i].subtract(this._curve[index]);
            while (nNVector.length() === 0 && index + i + 1 < this._curve.length) {
                i++;
                nNVector = this._curve[index + i].subtract(this._curve[index]);
            }
            return nNVector;
        };
        // private function getLastNonNullVector(index)
        // returns the last non null vector from index : curve[index].subtract(curve[index - N])
        Path3D.prototype._getLastNonNullVector = function (index) {
            var i = 1;
            var nLVector = this._curve[index].subtract(this._curve[index - i]);
            while (nLVector.length() === 0 && index > i + 1) {
                i++;
                nLVector = this._curve[index].subtract(this._curve[index - i]);
            }
            return nLVector;
        };
        // private function normalVector(v0, vt, va) :
        // returns an arbitrary point in the plane defined by the point v0 and the vector vt orthogonal to this plane
        // if va is passed, it returns the va projection on the plane orthogonal to vt at the point v0
        Path3D.prototype._normalVector = function (v0, vt, va) {
            var normal0;
            var tgl = vt.length();
            if (tgl === 0.0) {
                tgl = 1.0;
            }
            if (va === undefined || va === null) {
                var point;
                if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.y) / tgl, 1.0, BABYLON.Epsilon)) { // search for a point in the plane
                    point = new Vector3(0.0, -1.0, 0.0);
                }
                else if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.x) / tgl, 1.0, BABYLON.Epsilon)) {
                    point = new Vector3(1.0, 0.0, 0.0);
                }
                else if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.z) / tgl, 1.0, BABYLON.Epsilon)) {
                    point = new Vector3(0.0, 0.0, 1.0);
                }
                else {
                    point = Vector3.Zero();
                }
                normal0 = Vector3.Cross(vt, point);
            }
            else {
                normal0 = Vector3.Cross(vt, va);
                Vector3.CrossToRef(normal0, vt, normal0);
            }
            normal0.normalize();
            return normal0;
        };
        return Path3D;
    }());
    BABYLON.Path3D = Path3D;
    var Curve3 = /** @class */ (function () {
        /**
         * A Curve3 object is a logical object, so not a mesh, to handle curves in the 3D geometric space.
         * A Curve3 is designed from a series of successive Vector3.
         * Tuto : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#curve3-object
         */
        function Curve3(points) {
            this._length = 0.0;
            this._points = points;
            this._length = this._computeLength(points);
        }
        /**
         * Returns a Curve3 object along a Quadratic Bezier curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#quadratic-bezier-curve
         * @param v0 (Vector3) the origin point of the Quadratic Bezier
         * @param v1 (Vector3) the control point
         * @param v2 (Vector3) the end point of the Quadratic Bezier
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateQuadraticBezier = function (v0, v1, v2, nbPoints) {
            nbPoints = nbPoints > 2 ? nbPoints : 3;
            var bez = new Array();
            var equation = function (t, val0, val1, val2) {
                var res = (1.0 - t) * (1.0 - t) * val0 + 2.0 * t * (1.0 - t) * val1 + t * t * val2;
                return res;
            };
            for (var i = 0; i <= nbPoints; i++) {
                bez.push(new Vector3(equation(i / nbPoints, v0.x, v1.x, v2.x), equation(i / nbPoints, v0.y, v1.y, v2.y), equation(i / nbPoints, v0.z, v1.z, v2.z)));
            }
            return new Curve3(bez);
        };
        /**
         * Returns a Curve3 object along a Cubic Bezier curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#cubic-bezier-curve
         * @param v0 (Vector3) the origin point of the Cubic Bezier
         * @param v1 (Vector3) the first control point
         * @param v2 (Vector3) the second control point
         * @param v3 (Vector3) the end point of the Cubic Bezier
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateCubicBezier = function (v0, v1, v2, v3, nbPoints) {
            nbPoints = nbPoints > 3 ? nbPoints : 4;
            var bez = new Array();
            var equation = function (t, val0, val1, val2, val3) {
                var res = (1.0 - t) * (1.0 - t) * (1.0 - t) * val0 + 3.0 * t * (1.0 - t) * (1.0 - t) * val1 + 3.0 * t * t * (1.0 - t) * val2 + t * t * t * val3;
                return res;
            };
            for (var i = 0; i <= nbPoints; i++) {
                bez.push(new Vector3(equation(i / nbPoints, v0.x, v1.x, v2.x, v3.x), equation(i / nbPoints, v0.y, v1.y, v2.y, v3.y), equation(i / nbPoints, v0.z, v1.z, v2.z, v3.z)));
            }
            return new Curve3(bez);
        };
        /**
         * Returns a Curve3 object along a Hermite Spline curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#hermite-spline
         * @param p1 (Vector3) the origin point of the Hermite Spline
         * @param t1 (Vector3) the tangent vector at the origin point
         * @param p2 (Vector3) the end point of the Hermite Spline
         * @param t2 (Vector3) the tangent vector at the end point
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateHermiteSpline = function (p1, t1, p2, t2, nbPoints) {
            var hermite = new Array();
            var step = 1.0 / nbPoints;
            for (var i = 0; i <= nbPoints; i++) {
                hermite.push(Vector3.Hermite(p1, t1, p2, t2, i * step));
            }
            return new Curve3(hermite);
        };
        /**
         * Returns a Curve3 object along a CatmullRom Spline curve :
         * @param points (array of Vector3) the points the spline must pass through. At least, four points required.
         * @param nbPoints (integer) the wanted number of points between each curve control points.
         */
        Curve3.CreateCatmullRomSpline = function (points, nbPoints) {
            var totalPoints = new Array();
            totalPoints.push(points[0].clone());
            Array.prototype.push.apply(totalPoints, points);
            totalPoints.push(points[points.length - 1].clone());
            var catmullRom = new Array();
            var step = 1.0 / nbPoints;
            var amount = 0.0;
            for (var i = 0; i < totalPoints.length - 3; i++) {
                amount = 0;
                for (var c = 0; c < nbPoints; c++) {
                    catmullRom.push(Vector3.CatmullRom(totalPoints[i], totalPoints[i + 1], totalPoints[i + 2], totalPoints[i + 3], amount));
                    amount += step;
                }
            }
            i--;
            catmullRom.push(Vector3.CatmullRom(totalPoints[i], totalPoints[i + 1], totalPoints[i + 2], totalPoints[i + 3], amount));
            return new Curve3(catmullRom);
        };
        /**
         * Returns the Curve3 stored array of successive Vector3
         */
        Curve3.prototype.getPoints = function () {
            return this._points;
        };
        /**
         * Returns the computed length (float) of the curve.
         */
        Curve3.prototype.length = function () {
            return this._length;
        };
        /**
         * Returns a new instance of Curve3 object : var curve = curveA.continue(curveB);
         * This new Curve3 is built by translating and sticking the curveB at the end of the curveA.
         * curveA and curveB keep unchanged.
         */
        Curve3.prototype.continue = function (curve) {
            var lastPoint = this._points[this._points.length - 1];
            var continuedPoints = this._points.slice();
            var curvePoints = curve.getPoints();
            for (var i = 1; i < curvePoints.length; i++) {
                continuedPoints.push(curvePoints[i].subtract(curvePoints[0]).add(lastPoint));
            }
            var continuedCurve = new Curve3(continuedPoints);
            return continuedCurve;
        };
        Curve3.prototype._computeLength = function (path) {
            var l = 0;
            for (var i = 1; i < path.length; i++) {
                l += (path[i].subtract(path[i - 1])).length();
            }
            return l;
        };
        return Curve3;
    }());
    BABYLON.Curve3 = Curve3;
    // Vertex formats
    var PositionNormalVertex = /** @class */ (function () {
        function PositionNormalVertex(position, normal) {
            if (position === void 0) { position = Vector3.Zero(); }
            if (normal === void 0) { normal = Vector3.Up(); }
            this.position = position;
            this.normal = normal;
        }
        PositionNormalVertex.prototype.clone = function () {
            return new PositionNormalVertex(this.position.clone(), this.normal.clone());
        };
        return PositionNormalVertex;
    }());
    BABYLON.PositionNormalVertex = PositionNormalVertex;
    var PositionNormalTextureVertex = /** @class */ (function () {
        function PositionNormalTextureVertex(position, normal, uv) {
            if (position === void 0) { position = Vector3.Zero(); }
            if (normal === void 0) { normal = Vector3.Up(); }
            if (uv === void 0) { uv = Vector2.Zero(); }
            this.position = position;
            this.normal = normal;
            this.uv = uv;
        }
        PositionNormalTextureVertex.prototype.clone = function () {
            return new PositionNormalTextureVertex(this.position.clone(), this.normal.clone(), this.uv.clone());
        };
        return PositionNormalTextureVertex;
    }());
    BABYLON.PositionNormalTextureVertex = PositionNormalTextureVertex;
    // Temporary pre-allocated objects for engine internal use
    // usage in any internal function :
    // var tmp = Tmp.Vector3[0];   <= gets access to the first pre-created Vector3
    // There's a Tmp array per object type : int, float, Vector2, Vector3, Vector4, Quaternion, Matrix
    var Tmp = /** @class */ (function () {
        function Tmp() {
        }
        Tmp.Color3 = [Color3.Black(), Color3.Black(), Color3.Black()];
        Tmp.Vector2 = [Vector2.Zero(), Vector2.Zero(), Vector2.Zero()]; // 3 temp Vector2 at once should be enough
        Tmp.Vector3 = [Vector3.Zero(), Vector3.Zero(), Vector3.Zero(),
            Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero()]; // 9 temp Vector3 at once should be enough
        Tmp.Vector4 = [Vector4.Zero(), Vector4.Zero(), Vector4.Zero()]; // 3 temp Vector4 at once should be enough
        Tmp.Quaternion = [Quaternion.Zero(), Quaternion.Zero()]; // 2 temp Quaternion at once should be enough
        Tmp.Matrix = [Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero()]; // 6 temp Matrices at once should be enough
        return Tmp;
    }());
    BABYLON.Tmp = Tmp;
    // Same as Tmp but not exported to keep it only for math functions to avoid conflicts
    var MathTmp = /** @class */ (function () {
        function MathTmp() {
        }
        MathTmp.Vector3 = [Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero()];
        MathTmp.Matrix = [Matrix.Zero(), Matrix.Zero()];
        MathTmp.Quaternion = [Quaternion.Zero(), Quaternion.Zero(), Quaternion.Zero()];
        return MathTmp;
    }());
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.math.js.map

var BABYLON;
(function (BABYLON) {
    var Scalar = /** @class */ (function () {
        function Scalar() {
        }
        /**
         * Boolean : true if the absolute difference between a and b is lower than epsilon (default = 1.401298E-45)
         */
        Scalar.WithinEpsilon = function (a, b, epsilon) {
            if (epsilon === void 0) { epsilon = 1.401298E-45; }
            var num = a - b;
            return -epsilon <= num && num <= epsilon;
        };
        /**
         * Returns a string : the upper case translation of the number i to hexadecimal.
         */
        Scalar.ToHex = function (i) {
            var str = i.toString(16);
            if (i <= 15) {
                return ("0" + str).toUpperCase();
            }
            return str.toUpperCase();
        };
        /**
         * Returns -1 if value is negative and +1 is value is positive.
         * Returns the value itself if it's equal to zero.
         */
        Scalar.Sign = function (value) {
            value = +value; // convert to a number
            if (value === 0 || isNaN(value))
                return value;
            return value > 0 ? 1 : -1;
        };
        /**
         * Returns the value itself if it's between min and max.
         * Returns min if the value is lower than min.
         * Returns max if the value is greater than max.
         */
        Scalar.Clamp = function (value, min, max) {
            if (min === void 0) { min = 0; }
            if (max === void 0) { max = 1; }
            return Math.min(max, Math.max(min, value));
        };
        /**
         * Returns the log2 of value.
         */
        Scalar.Log2 = function (value) {
            return Math.log(value) * Math.LOG2E;
        };
        /**
        * Loops the value, so that it is never larger than length and never smaller than 0.
        *
        * This is similar to the modulo operator but it works with floating point numbers.
        * For example, using 3.0 for t and 2.5 for length, the result would be 0.5.
        * With t = 5 and length = 2.5, the result would be 0.0.
        * Note, however, that the behaviour is not defined for negative numbers as it is for the modulo operator
        */
        Scalar.Repeat = function (value, length) {
            return value - Math.floor(value / length) * length;
        };
        /**
        * Normalize the value between 0.0 and 1.0 using min and max values
        */
        Scalar.Normalize = function (value, min, max) {
            return (value - min) / (max - min);
        };
        /**
        * Denormalize the value from 0.0 and 1.0 using min and max values
        */
        Scalar.Denormalize = function (normalized, min, max) {
            return (normalized * (max - min) + min);
        };
        /**
        * Calculates the shortest difference between two given angles given in degrees.
        */
        Scalar.DeltaAngle = function (current, target) {
            var num = Scalar.Repeat(target - current, 360.0);
            if (num > 180.0) {
                num -= 360.0;
            }
            return num;
        };
        /**
        * PingPongs the value t, so that it is never larger than length and never smaller than 0.
        *
        * The returned value will move back and forth between 0 and length
        */
        Scalar.PingPong = function (tx, length) {
            var t = Scalar.Repeat(tx, length * 2.0);
            return length - Math.abs(t - length);
        };
        /**
        * Interpolates between min and max with smoothing at the limits.
        *
        * This function interpolates between min and max in a similar way to Lerp. However, the interpolation will gradually speed up
        * from the start and slow down toward the end. This is useful for creating natural-looking animation, fading and other transitions.
        */
        Scalar.SmoothStep = function (from, to, tx) {
            var t = Scalar.Clamp(tx);
            t = -2.0 * t * t * t + 3.0 * t * t;
            return to * t + from * (1.0 - t);
        };
        /**
        * Moves a value current towards target.
        *
        * This is essentially the same as Mathf.Lerp but instead the function will ensure that the speed never exceeds maxDelta.
        * Negative values of maxDelta pushes the value away from target.
        */
        Scalar.MoveTowards = function (current, target, maxDelta) {
            var result = 0;
            if (Math.abs(target - current) <= maxDelta) {
                result = target;
            }
            else {
                result = current + Scalar.Sign(target - current) * maxDelta;
            }
            return result;
        };
        /**
        * Same as MoveTowards but makes sure the values interpolate correctly when they wrap around 360 degrees.
        *
        * Variables current and target are assumed to be in degrees. For optimization reasons, negative values of maxDelta
        *  are not supported and may cause oscillation. To push current away from a target angle, add 180 to that angle instead.
        */
        Scalar.MoveTowardsAngle = function (current, target, maxDelta) {
            var num = Scalar.DeltaAngle(current, target);
            var result = 0;
            if (-maxDelta < num && num < maxDelta) {
                result = target;
            }
            else {
                target = current + num;
                result = Scalar.MoveTowards(current, target, maxDelta);
            }
            return result;
        };
        /**
            * Creates a new scalar with values linearly interpolated of "amount" between the start scalar and the end scalar.
            */
        Scalar.Lerp = function (start, end, amount) {
            return start + ((end - start) * amount);
        };
        /**
        * Same as Lerp but makes sure the values interpolate correctly when they wrap around 360 degrees.
        * The parameter t is clamped to the range [0, 1]. Variables a and b are assumed to be in degrees.
        */
        Scalar.LerpAngle = function (start, end, amount) {
            var num = Scalar.Repeat(end - start, 360.0);
            if (num > 180.0) {
                num -= 360.0;
            }
            return start + num * Scalar.Clamp(amount);
        };
        /**
        * Calculates the linear parameter t that produces the interpolant value within the range [a, b].
        */
        Scalar.InverseLerp = function (a, b, value) {
            var result = 0;
            if (a != b) {
                result = Scalar.Clamp((value - a) / (b - a));
            }
            else {
                result = 0.0;
            }
            return result;
        };
        /**
         * Returns a new scalar located for "amount" (float) on the Hermite spline defined by the scalars "value1", "value3", "tangent1", "tangent2".
         */
        Scalar.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            return (((value1 * part1) + (value2 * part2)) + (tangent1 * part3)) + (tangent2 * part4);
        };
        /**
        * Returns a random float number between and min and max values
        */
        Scalar.RandomRange = function (min, max) {
            if (min === max)
                return min;
            return ((Math.random() * (max - min)) + min);
        };
        /**
        * This function returns percentage of a number in a given range.
        *
        * RangeToPercent(40,20,60) will return 0.5 (50%)
        * RangeToPercent(34,0,100) will return 0.34 (34%)
        */
        Scalar.RangeToPercent = function (number, min, max) {
            return ((number - min) / (max - min));
        };
        /**
        * This function returns number that corresponds to the percentage in a given range.
        *
        * PercentToRange(0.34,0,100) will return 34.
        */
        Scalar.PercentToRange = function (percent, min, max) {
            return ((max - min) * percent + min);
        };
        /**
         * Returns the angle converted to equivalent value between -Math.PI and Math.PI radians.
         * @param angle The angle to normalize in radian.
         * @return The converted angle.
         */
        Scalar.NormalizeRadians = function (angle) {
            // More precise but slower version kept for reference.
            // angle = angle % Tools.TwoPi;
            // angle = (angle + Tools.TwoPi) % Tools.TwoPi;
            //if (angle > Math.PI) {
            //	angle -= Tools.TwoPi;
            //}
            angle -= (Scalar.TwoPi * Math.floor((angle + Math.PI) / Scalar.TwoPi));
            return angle;
        };
        /**
         * Two pi constants convenient for computation.
         */
        Scalar.TwoPi = Math.PI * 2;
        return Scalar;
    }());
    BABYLON.Scalar = Scalar;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.math.scalar.js.map



//# sourceMappingURL=babylon.mixins.js.map

// Type definitions for WebGL 2, Editor's Draft Fri Feb 24 16:10:18 2017 -0800
// Project: https://www.khronos.org/registry/webgl/specs/latest/2.0/
// Definitions by: Nico Kemnitz <https://github.com/nkemnitz/>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

//# sourceMappingURL=babylon.webgl2.js.map

var BABYLON;
(function (BABYLON) {
    var __decoratorInitialStore = {};
    var __mergedStore = {};
    var _copySource = function (creationFunction, source, instanciate) {
        var destination = creationFunction();
        // Tags
        if (BABYLON.Tags) {
            BABYLON.Tags.AddTagsTo(destination, source.tags);
        }
        var classStore = getMergedStore(destination);
        // Properties
        for (var property in classStore) {
            var propertyDescriptor = classStore[property];
            var sourceProperty = source[property];
            var propertyType = propertyDescriptor.type;
            if (sourceProperty !== undefined && sourceProperty !== null) {
                switch (propertyType) {
                    case 0: // Value
                    case 6: // Mesh reference
                    case 11: // Camera reference
                        destination[property] = sourceProperty;
                        break;
                    case 1: // Texture
                        destination[property] = (instanciate || sourceProperty.isRenderTarget) ? sourceProperty : sourceProperty.clone();
                        break;
                    case 2: // Color3
                    case 3: // FresnelParameters
                    case 4: // Vector2
                    case 5: // Vector3
                    case 7: // Color Curves
                    case 10: // Quaternion
                        destination[property] = instanciate ? sourceProperty : sourceProperty.clone();
                        break;
                }
            }
        }
        return destination;
    };
    function getDirectStore(target) {
        var classKey = target.getClassName();
        if (!__decoratorInitialStore[classKey]) {
            __decoratorInitialStore[classKey] = {};
        }
        return __decoratorInitialStore[classKey];
    }
    /**
     * Return the list of properties flagged as serializable
     * @param target: host object
     */
    function getMergedStore(target) {
        var classKey = target.getClassName();
        if (__mergedStore[classKey]) {
            return __mergedStore[classKey];
        }
        __mergedStore[classKey] = {};
        var store = __mergedStore[classKey];
        var currentTarget = target;
        var currentKey = classKey;
        while (currentKey) {
            var initialStore = __decoratorInitialStore[currentKey];
            for (var property in initialStore) {
                store[property] = initialStore[property];
            }
            var parent_1 = void 0;
            var done = false;
            do {
                parent_1 = Object.getPrototypeOf(currentTarget);
                if (!parent_1.getClassName) {
                    done = true;
                    break;
                }
                if (parent_1.getClassName() !== currentKey) {
                    break;
                }
                currentTarget = parent_1;
            } while (parent_1);
            if (done) {
                break;
            }
            currentKey = parent_1.getClassName();
            currentTarget = parent_1;
        }
        return store;
    }
    function generateSerializableMember(type, sourceName) {
        return function (target, propertyKey) {
            var classStore = getDirectStore(target);
            if (!classStore[propertyKey]) {
                classStore[propertyKey] = { type: type, sourceName: sourceName };
            }
        };
    }
    function generateExpandMember(setCallback, targetKey) {
        if (targetKey === void 0) { targetKey = null; }
        return function (target, propertyKey) {
            var key = targetKey || ("_" + propertyKey);
            Object.defineProperty(target, propertyKey, {
                get: function () {
                    return this[key];
                },
                set: function (value) {
                    if (this[key] === value) {
                        return;
                    }
                    this[key] = value;
                    target[setCallback].apply(this);
                },
                enumerable: true,
                configurable: true
            });
        };
    }
    function expandToProperty(callback, targetKey) {
        if (targetKey === void 0) { targetKey = null; }
        return generateExpandMember(callback, targetKey);
    }
    BABYLON.expandToProperty = expandToProperty;
    function serialize(sourceName) {
        return generateSerializableMember(0, sourceName); // value member
    }
    BABYLON.serialize = serialize;
    function serializeAsTexture(sourceName) {
        return generateSerializableMember(1, sourceName); // texture member
    }
    BABYLON.serializeAsTexture = serializeAsTexture;
    function serializeAsColor3(sourceName) {
        return generateSerializableMember(2, sourceName); // color3 member
    }
    BABYLON.serializeAsColor3 = serializeAsColor3;
    function serializeAsFresnelParameters(sourceName) {
        return generateSerializableMember(3, sourceName); // fresnel parameters member
    }
    BABYLON.serializeAsFresnelParameters = serializeAsFresnelParameters;
    function serializeAsVector2(sourceName) {
        return generateSerializableMember(4, sourceName); // vector2 member
    }
    BABYLON.serializeAsVector2 = serializeAsVector2;
    function serializeAsVector3(sourceName) {
        return generateSerializableMember(5, sourceName); // vector3 member
    }
    BABYLON.serializeAsVector3 = serializeAsVector3;
    function serializeAsMeshReference(sourceName) {
        return generateSerializableMember(6, sourceName); // mesh reference member
    }
    BABYLON.serializeAsMeshReference = serializeAsMeshReference;
    function serializeAsColorCurves(sourceName) {
        return generateSerializableMember(7, sourceName); // color curves
    }
    BABYLON.serializeAsColorCurves = serializeAsColorCurves;
    function serializeAsColor4(sourceName) {
        return generateSerializableMember(8, sourceName); // color 4
    }
    BABYLON.serializeAsColor4 = serializeAsColor4;
    function serializeAsImageProcessingConfiguration(sourceName) {
        return generateSerializableMember(9, sourceName); // image processing
    }
    BABYLON.serializeAsImageProcessingConfiguration = serializeAsImageProcessingConfiguration;
    function serializeAsQuaternion(sourceName) {
        return generateSerializableMember(10, sourceName); // quaternion member
    }
    BABYLON.serializeAsQuaternion = serializeAsQuaternion;
    /**
     * Decorator used to define property that can be serialized as reference to a camera
     * @param sourceName defines the name of the property to decorate
     */
    function serializeAsCameraReference(sourceName) {
        return generateSerializableMember(11, sourceName); // camera reference member
    }
    BABYLON.serializeAsCameraReference = serializeAsCameraReference;
    var SerializationHelper = /** @class */ (function () {
        function SerializationHelper() {
        }
        SerializationHelper.Serialize = function (entity, serializationObject) {
            if (!serializationObject) {
                serializationObject = {};
            }
            // Tags
            if (BABYLON.Tags) {
                serializationObject.tags = BABYLON.Tags.GetTags(entity);
            }
            var serializedProperties = getMergedStore(entity);
            // Properties
            for (var property in serializedProperties) {
                var propertyDescriptor = serializedProperties[property];
                var targetPropertyName = propertyDescriptor.sourceName || property;
                var propertyType = propertyDescriptor.type;
                var sourceProperty = entity[property];
                if (sourceProperty !== undefined && sourceProperty !== null) {
                    switch (propertyType) {
                        case 0: // Value
                            serializationObject[targetPropertyName] = sourceProperty;
                            break;
                        case 1: // Texture
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 2: // Color3
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 3: // FresnelParameters
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 4: // Vector2
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 5: // Vector3
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 6: // Mesh reference
                            serializationObject[targetPropertyName] = sourceProperty.id;
                            break;
                        case 7: // Color Curves
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 8: // Color 4
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 9: // Image Processing
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 10: // Quaternion
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 11: // Camera reference
                            serializationObject[targetPropertyName] = sourceProperty.id;
                            break;
                    }
                }
            }
            return serializationObject;
        };
        SerializationHelper.Parse = function (creationFunction, source, scene, rootUrl) {
            if (rootUrl === void 0) { rootUrl = null; }
            var destination = creationFunction();
            if (!rootUrl) {
                rootUrl = "";
            }
            // Tags
            if (BABYLON.Tags) {
                BABYLON.Tags.AddTagsTo(destination, source.tags);
            }
            var classStore = getMergedStore(destination);
            // Properties
            for (var property in classStore) {
                var propertyDescriptor = classStore[property];
                var sourceProperty = source[propertyDescriptor.sourceName || property];
                var propertyType = propertyDescriptor.type;
                if (sourceProperty !== undefined && sourceProperty !== null) {
                    var dest = destination;
                    switch (propertyType) {
                        case 0: // Value
                            dest[property] = sourceProperty;
                            break;
                        case 1: // Texture
                            if (scene) {
                                dest[property] = BABYLON.Texture.Parse(sourceProperty, scene, rootUrl);
                            }
                            break;
                        case 2: // Color3
                            dest[property] = BABYLON.Color3.FromArray(sourceProperty);
                            break;
                        case 3: // FresnelParameters
                            dest[property] = BABYLON.FresnelParameters.Parse(sourceProperty);
                            break;
                        case 4: // Vector2
                            dest[property] = BABYLON.Vector2.FromArray(sourceProperty);
                            break;
                        case 5: // Vector3
                            dest[property] = BABYLON.Vector3.FromArray(sourceProperty);
                            break;
                        case 6: // Mesh reference
                            if (scene) {
                                dest[property] = scene.getLastMeshByID(sourceProperty);
                            }
                            break;
                        case 7: // Color Curves
                            dest[property] = BABYLON.ColorCurves.Parse(sourceProperty);
                            break;
                        case 8: // Color 4
                            dest[property] = BABYLON.Color4.FromArray(sourceProperty);
                            break;
                        case 9: // Image Processing
                            dest[property] = BABYLON.ImageProcessingConfiguration.Parse(sourceProperty);
                            break;
                        case 10: // Quaternion
                            dest[property] = BABYLON.Quaternion.FromArray(sourceProperty);
                            break;
                        case 11: // Camera reference
                            if (scene) {
                                dest[property] = scene.getCameraByID(sourceProperty);
                            }
                            break;
                    }
                }
            }
            return destination;
        };
        SerializationHelper.Clone = function (creationFunction, source) {
            return _copySource(creationFunction, source, false);
        };
        SerializationHelper.Instanciate = function (creationFunction, source) {
            return _copySource(creationFunction, source, true);
        };
        return SerializationHelper;
    }());
    BABYLON.SerializationHelper = SerializationHelper;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.decorators.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * Wrapper class for promise with external resolve and reject.
     */
    var Deferred = /** @class */ (function () {
        /**
         * Constructor for this deferred object.
         */
        function Deferred() {
            var _this = this;
            this.promise = new Promise(function (resolve, reject) {
                _this._resolve = resolve;
                _this._reject = reject;
            });
        }
        Object.defineProperty(Deferred.prototype, "resolve", {
            /**
             * The resolve method of the promise associated with this deferred object.
             */
            get: function () {
                return this._resolve;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Deferred.prototype, "reject", {
            /**
             * The reject method of the promise associated with this deferred object.
             */
            get: function () {
                return this._reject;
            },
            enumerable: true,
            configurable: true
        });
        return Deferred;
    }());
    BABYLON.Deferred = Deferred;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.deferred.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * A class serves as a medium between the observable and its observers
     */
    var EventState = /** @class */ (function () {
        /**
         * Create a new EventState
         * @param mask defines the mask associated with this state
         * @param skipNextObservers defines a flag which will instruct the observable to skip following observers when set to true
         * @param target defines the original target of the state
         * @param currentTarget defines the current target of the state
         */
        function EventState(mask, skipNextObservers, target, currentTarget) {
            if (skipNextObservers === void 0) { skipNextObservers = false; }
            this.initalize(mask, skipNextObservers, target, currentTarget);
        }
        /**
         * Initialize the current event state
         * @param mask defines the mask associated with this state
         * @param skipNextObservers defines a flag which will instruct the observable to skip following observers when set to true
         * @param target defines the original target of the state
         * @param currentTarget defines the current target of the state
         * @returns the current event state
         */
        EventState.prototype.initalize = function (mask, skipNextObservers, target, currentTarget) {
            if (skipNextObservers === void 0) { skipNextObservers = false; }
            this.mask = mask;
            this.skipNextObservers = skipNextObservers;
            this.target = target;
            this.currentTarget = currentTarget;
            return this;
        };
        return EventState;
    }());
    BABYLON.EventState = EventState;
    /**
     * Represent an Observer registered to a given Observable object.
     */
    var Observer = /** @class */ (function () {
        /**
         * Creates a new observer
         * @param callback defines the callback to call when the observer is notified
         * @param mask defines the mask of the observer (used to filter notifications)
         * @param scope defines the current scope used to restore the JS context
         */
        function Observer(
        /**
         * Defines the callback to call when the observer is notified
         */
        callback, 
        /**
         * Defines the mask of the observer (used to filter notifications)
         */
        mask, 
        /**
         * Defines the current scope used to restore the JS context
         */
        scope) {
            if (scope === void 0) { scope = null; }
            this.callback = callback;
            this.mask = mask;
            this.scope = scope;
            /** @hidden */
            this._willBeUnregistered = false;
            /**
             * Gets or sets a property defining that the observer as to be unregistered after the next notification
             */
            this.unregisterOnNextCall = false;
        }
        return Observer;
    }());
    BABYLON.Observer = Observer;
    /**
     * Represent a list of observers registered to multiple Observables object.
     */
    var MultiObserver = /** @class */ (function () {
        function MultiObserver() {
        }
        /**
         * Release associated resources
         */
        MultiObserver.prototype.dispose = function () {
            if (this._observers && this._observables) {
                for (var index = 0; index < this._observers.length; index++) {
                    this._observables[index].remove(this._observers[index]);
                }
            }
            this._observers = null;
            this._observables = null;
        };
        /**
         * Raise a callback when one of the observable will notify
         * @param observables defines a list of observables to watch
         * @param callback defines the callback to call on notification
         * @param mask defines the mask used to filter notifications
         * @param scope defines the current scope used to restore the JS context
         * @returns the new MultiObserver
         */
        MultiObserver.Watch = function (observables, callback, mask, scope) {
            if (mask === void 0) { mask = -1; }
            if (scope === void 0) { scope = null; }
            var result = new MultiObserver();
            result._observers = new Array();
            result._observables = observables;
            for (var _i = 0, observables_1 = observables; _i < observables_1.length; _i++) {
                var observable = observables_1[_i];
                var observer = observable.add(callback, mask, false, scope);
                if (observer) {
                    result._observers.push(observer);
                }
            }
            return result;
        };
        return MultiObserver;
    }());
    BABYLON.MultiObserver = MultiObserver;
    /**
     * The Observable class is a simple implementation of the Observable pattern.
     *
     * There's one slight particularity though: a given Observable can notify its observer using a particular mask value, only the Observers registered with this mask value will be notified.
     * This enable a more fine grained execution without having to rely on multiple different Observable objects.
     * For instance you may have a given Observable that have four different types of notifications: Move (mask = 0x01), Stop (mask = 0x02), Turn Right (mask = 0X04), Turn Left (mask = 0X08).
     * A given observer can register itself with only Move and Stop (mask = 0x03), then it will only be notified when one of these two occurs and will never be for Turn Left/Right.
     */
    var Observable = /** @class */ (function () {
        /**
         * Creates a new observable
         * @param onObserverAdded defines a callback to call when a new observer is added
         */
        function Observable(onObserverAdded) {
            this._observers = new Array();
            this._eventState = new EventState(0);
            if (onObserverAdded) {
                this._onObserverAdded = onObserverAdded;
            }
        }
        /**
         * Create a new Observer with the specified callback
         * @param callback the callback that will be executed for that Observer
         * @param mask the mask used to filter observers
         * @param insertFirst if true the callback will be inserted at the first position, hence executed before the others ones. If false (default behavior) the callback will be inserted at the last position, executed after all the others already present.
         * @param scope optional scope for the callback to be called from
         * @param unregisterOnFirstCall defines if the observer as to be unregistered after the next notification
         * @returns the new observer created for the callback
         */
        Observable.prototype.add = function (callback, mask, insertFirst, scope, unregisterOnFirstCall) {
            if (mask === void 0) { mask = -1; }
            if (insertFirst === void 0) { insertFirst = false; }
            if (scope === void 0) { scope = null; }
            if (unregisterOnFirstCall === void 0) { unregisterOnFirstCall = false; }
            if (!callback) {
                return null;
            }
            var observer = new Observer(callback, mask, scope);
            observer.unregisterOnNextCall = unregisterOnFirstCall;
            if (insertFirst) {
                this._observers.unshift(observer);
            }
            else {
                this._observers.push(observer);
            }
            if (this._onObserverAdded) {
                this._onObserverAdded(observer);
            }
            return observer;
        };
        /**
         * Remove an Observer from the Observable object
         * @param observer the instance of the Observer to remove
         * @returns false if it doesn't belong to this Observable
         */
        Observable.prototype.remove = function (observer) {
            if (!observer) {
                return false;
            }
            var index = this._observers.indexOf(observer);
            if (index !== -1) {
                this._observers.splice(index, 1);
                return true;
            }
            return false;
        };
        /**
         * Remove a callback from the Observable object
         * @param callback the callback to remove
         * @param scope optional scope. If used only the callbacks with this scope will be removed
         * @returns false if it doesn't belong to this Observable
        */
        Observable.prototype.removeCallback = function (callback, scope) {
            for (var index = 0; index < this._observers.length; index++) {
                if (this._observers[index].callback === callback && (!scope || scope === this._observers[index].scope)) {
                    this._observers.splice(index, 1);
                    return true;
                }
            }
            return false;
        };
        Observable.prototype._deferUnregister = function (observer) {
            var _this = this;
            observer.unregisterOnNextCall = false;
            observer._willBeUnregistered = true;
            BABYLON.Tools.SetImmediate(function () {
                _this.remove(observer);
            });
        };
        /**
         * Notify all Observers by calling their respective callback with the given data
         * Will return true if all observers were executed, false if an observer set skipNextObservers to true, then prevent the subsequent ones to execute
         * @param eventData defines the data to send to all observers
         * @param mask defines the mask of the current notification (observers with incompatible mask (ie mask & observer.mask === 0) will not be notified)
         * @param target defines the original target of the state
         * @param currentTarget defines the current target of the state
         * @returns false if the complete observer chain was not processed (because one observer set the skipNextObservers to true)
         */
        Observable.prototype.notifyObservers = function (eventData, mask, target, currentTarget) {
            if (mask === void 0) { mask = -1; }
            if (!this._observers.length) {
                return true;
            }
            var state = this._eventState;
            state.mask = mask;
            state.target = target;
            state.currentTarget = currentTarget;
            state.skipNextObservers = false;
            state.lastReturnValue = eventData;
            for (var _i = 0, _a = this._observers; _i < _a.length; _i++) {
                var obs = _a[_i];
                if (obs._willBeUnregistered) {
                    continue;
                }
                if (obs.mask & mask) {
                    if (obs.scope) {
                        state.lastReturnValue = obs.callback.apply(obs.scope, [eventData, state]);
                    }
                    else {
                        state.lastReturnValue = obs.callback(eventData, state);
                    }
                    if (obs.unregisterOnNextCall) {
                        this._deferUnregister(obs);
                    }
                }
                if (state.skipNextObservers) {
                    return false;
                }
            }
            return true;
        };
        /**
         * Calling this will execute each callback, expecting it to be a promise or return a value.
         * If at any point in the chain one function fails, the promise will fail and the execution will not continue.
         * This is useful when a chain of events (sometimes async events) is needed to initialize a certain object
         * and it is crucial that all callbacks will be executed.
         * The order of the callbacks is kept, callbacks are not executed parallel.
         *
         * @param eventData The data to be sent to each callback
         * @param mask is used to filter observers defaults to -1
         * @param target defines the callback target (see EventState)
         * @param currentTarget defines he current object in the bubbling phase
         * @returns {Promise<T>} will return a Promise than resolves when all callbacks executed successfully.
         */
        Observable.prototype.notifyObserversWithPromise = function (eventData, mask, target, currentTarget) {
            var _this = this;
            if (mask === void 0) { mask = -1; }
            // create an empty promise
            var p = Promise.resolve(eventData);
            // no observers? return this promise.
            if (!this._observers.length) {
                return p;
            }
            var state = this._eventState;
            state.mask = mask;
            state.target = target;
            state.currentTarget = currentTarget;
            state.skipNextObservers = false;
            // execute one callback after another (not using Promise.all, the order is important)
            this._observers.forEach(function (obs) {
                if (state.skipNextObservers) {
                    return;
                }
                if (obs._willBeUnregistered) {
                    return;
                }
                if (obs.mask & mask) {
                    if (obs.scope) {
                        p = p.then(function (lastReturnedValue) {
                            state.lastReturnValue = lastReturnedValue;
                            return obs.callback.apply(obs.scope, [eventData, state]);
                        });
                    }
                    else {
                        p = p.then(function (lastReturnedValue) {
                            state.lastReturnValue = lastReturnedValue;
                            return obs.callback(eventData, state);
                        });
                    }
                    if (obs.unregisterOnNextCall) {
                        _this._deferUnregister(obs);
                    }
                }
            });
            // return the eventData
            return p.then(function () { return eventData; });
        };
        /**
         * Notify a specific observer
         * @param observer defines the observer to notify
         * @param eventData defines the data to be sent to each callback
         * @param mask is used to filter observers defaults to -1
         */
        Observable.prototype.notifyObserver = function (observer, eventData, mask) {
            if (mask === void 0) { mask = -1; }
            var state = this._eventState;
            state.mask = mask;
            state.skipNextObservers = false;
            observer.callback(eventData, state);
        };
        /**
         * Gets a boolean indicating if the observable has at least one observer
         * @returns true is the Observable has at least one Observer registered
         */
        Observable.prototype.hasObservers = function () {
            return this._observers.length > 0;
        };
        /**
        * Clear the list of observers
        */
        Observable.prototype.clear = function () {
            this._observers = new Array();
            this._onObserverAdded = null;
        };
        /**
         * Clone the current observable
         * @returns a new observable
         */
        Observable.prototype.clone = function () {
            var result = new Observable();
            result._observers = this._observers.slice(0);
            return result;
        };
        /**
         * Does this observable handles observer registered with a given mask
         * @param mask defines the mask to be tested
         * @return whether or not one observer registered with the given mask is handeled
        **/
        Observable.prototype.hasSpecificMask = function (mask) {
            if (mask === void 0) { mask = -1; }
            for (var _i = 0, _a = this._observers; _i < _a.length; _i++) {
                var obs = _a[_i];
                if (obs.mask & mask || obs.mask === mask) {
                    return true;
                }
            }
            return false;
        };
        return Observable;
    }());
    BABYLON.Observable = Observable;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.observable.js.map


var BABYLON;
(function (BABYLON) {
    var SmartArray = /** @class */ (function () {
        function SmartArray(capacity) {
            this.length = 0;
            this.data = new Array(capacity);
            this._id = SmartArray._GlobalId++;
        }
        SmartArray.prototype.push = function (value) {
            this.data[this.length++] = value;
            if (this.length > this.data.length) {
                this.data.length *= 2;
            }
        };
        SmartArray.prototype.forEach = function (func) {
            for (var index = 0; index < this.length; index++) {
                func(this.data[index]);
            }
        };
        SmartArray.prototype.sort = function (compareFn) {
            this.data.sort(compareFn);
        };
        SmartArray.prototype.reset = function () {
            this.length = 0;
        };
        SmartArray.prototype.dispose = function () {
            this.reset();
            if (this.data) {
                this.data.length = 0;
                this.data = [];
            }
        };
        SmartArray.prototype.concat = function (array) {
            if (array.length === 0) {
                return;
            }
            if (this.length + array.length > this.data.length) {
                this.data.length = (this.length + array.length) * 2;
            }
            for (var index = 0; index < array.length; index++) {
                this.data[this.length++] = (array.data || array)[index];
            }
        };
        SmartArray.prototype.indexOf = function (value) {
            var position = this.data.indexOf(value);
            if (position >= this.length) {
                return -1;
            }
            return position;
        };
        SmartArray.prototype.contains = function (value) {
            return this.data.indexOf(value) !== -1;
        };
        // Statics
        SmartArray._GlobalId = 0;
        return SmartArray;
    }());
    BABYLON.SmartArray = SmartArray;
    var SmartArrayNoDuplicate = /** @class */ (function (_super) {
        __extends(SmartArrayNoDuplicate, _super);
        function SmartArrayNoDuplicate() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._duplicateId = 0;
            return _this;
        }
        SmartArrayNoDuplicate.prototype.push = function (value) {
            _super.prototype.push.call(this, value);
            if (!value.__smartArrayFlags) {
                value.__smartArrayFlags = {};
            }
            value.__smartArrayFlags[this._id] = this._duplicateId;
        };
        SmartArrayNoDuplicate.prototype.pushNoDuplicate = function (value) {
            if (value.__smartArrayFlags && value.__smartArrayFlags[this._id] === this._duplicateId) {
                return false;
            }
            this.push(value);
            return true;
        };
        SmartArrayNoDuplicate.prototype.reset = function () {
            _super.prototype.reset.call(this);
            this._duplicateId++;
        };
        SmartArrayNoDuplicate.prototype.concatWithNoDuplicate = function (array) {
            if (array.length === 0) {
                return;
            }
            if (this.length + array.length > this.data.length) {
                this.data.length = (this.length + array.length) * 2;
            }
            for (var index = 0; index < array.length; index++) {
                var item = (array.data || array)[index];
                this.pushNoDuplicate(item);
            }
        };
        return SmartArrayNoDuplicate;
    }(SmartArray));
    BABYLON.SmartArrayNoDuplicate = SmartArrayNoDuplicate;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.smartArray.js.map


var BABYLON;
(function (BABYLON) {
    // See https://stackoverflow.com/questions/12915412/how-do-i-extend-a-host-object-e-g-error-in-typescript
    // and https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    var LoadFileError = /** @class */ (function (_super) {
        __extends(LoadFileError, _super);
        function LoadFileError(message, request) {
            var _this = _super.call(this, message) || this;
            _this.request = request;
            _this.name = "LoadFileError";
            LoadFileError._setPrototypeOf(_this, LoadFileError.prototype);
            return _this;
        }
        // Polyfill for Object.setPrototypeOf if necessary.
        LoadFileError._setPrototypeOf = Object.setPrototypeOf || (function (o, proto) { o.__proto__ = proto; return o; });
        return LoadFileError;
    }(Error));
    BABYLON.LoadFileError = LoadFileError;
    var RetryStrategy = /** @class */ (function () {
        function RetryStrategy() {
        }
        RetryStrategy.ExponentialBackoff = function (maxRetries, baseInterval) {
            if (maxRetries === void 0) { maxRetries = 3; }
            if (baseInterval === void 0) { baseInterval = 500; }
            return function (url, request, retryIndex) {
                if (request.status !== 0 || retryIndex >= maxRetries || url.indexOf("file:") !== -1) {
                    return -1;
                }
                return Math.pow(2, retryIndex) * baseInterval;
            };
        };
        return RetryStrategy;
    }());
    BABYLON.RetryStrategy = RetryStrategy;
    // Screenshots
    var screenshotCanvas;
    var cloneValue = function (source, destinationObject) {
        if (!source)
            return null;
        if (source instanceof BABYLON.Mesh) {
            return null;
        }
        if (source instanceof BABYLON.SubMesh) {
            return source.clone(destinationObject);
        }
        else if (source.clone) {
            return source.clone();
        }
        return null;
    };
    var Tools = /** @class */ (function () {
        function Tools() {
        }
        /**
         * Interpolates between a and b via alpha
         * @param a The lower value (returned when alpha = 0)
         * @param b The upper value (returned when alpha = 1)
         * @param alpha The interpolation-factor
         * @return The mixed value
         */
        Tools.Mix = function (a, b, alpha) {
            return a * (1 - alpha) + b * alpha;
        };
        Tools.Instantiate = function (className) {
            if (Tools.RegisteredExternalClasses && Tools.RegisteredExternalClasses[className]) {
                return Tools.RegisteredExternalClasses[className];
            }
            var arr = className.split(".");
            var fn = (window || this);
            for (var i = 0, len = arr.length; i < len; i++) {
                fn = fn[arr[i]];
            }
            if (typeof fn !== "function") {
                return null;
            }
            return fn;
        };
        /**
         * Provides a slice function that will work even on IE
         * @param data defines the array to slice
         * @param start defines the start of the data (optional)
         * @param end defines the end of the data (optional)
         * @returns the new sliced array
         */
        Tools.Slice = function (data, start, end) {
            if (data.slice) {
                return data.slice(start, end);
            }
            return Array.prototype.slice.call(data, start, end);
        };
        Tools.SetImmediate = function (action) {
            if (window.setImmediate) {
                window.setImmediate(action);
            }
            else {
                setTimeout(action, 1);
            }
        };
        Tools.IsExponentOfTwo = function (value) {
            var count = 1;
            do {
                count *= 2;
            } while (count < value);
            return count === value;
        };
        /**
         * Returns the nearest 32-bit single precision float representation of a Number
         * @param value A Number.  If the parameter is of a different type, it will get converted
         * to a number or to NaN if it cannot be converted
         * @returns number
         */
        Tools.FloatRound = function (value) {
            if (Math.fround) {
                return Math.fround(value);
            }
            return (Tools._tmpFloatArray[0] = value);
        };
        /**
         * Find the next highest power of two.
         * @param x Number to start search from.
         * @return Next highest power of two.
         */
        Tools.CeilingPOT = function (x) {
            x--;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            x++;
            return x;
        };
        /**
         * Find the next lowest power of two.
         * @param x Number to start search from.
         * @return Next lowest power of two.
         */
        Tools.FloorPOT = function (x) {
            x = x | (x >> 1);
            x = x | (x >> 2);
            x = x | (x >> 4);
            x = x | (x >> 8);
            x = x | (x >> 16);
            return x - (x >> 1);
        };
        /**
         * Find the nearest power of two.
         * @param x Number to start search from.
         * @return Next nearest power of two.
         */
        Tools.NearestPOT = function (x) {
            var c = Tools.CeilingPOT(x);
            var f = Tools.FloorPOT(x);
            return (c - x) > (x - f) ? f : c;
        };
        Tools.GetExponentOfTwo = function (value, max, mode) {
            if (mode === void 0) { mode = BABYLON.Engine.SCALEMODE_NEAREST; }
            var pot;
            switch (mode) {
                case BABYLON.Engine.SCALEMODE_FLOOR:
                    pot = Tools.FloorPOT(value);
                    break;
                case BABYLON.Engine.SCALEMODE_NEAREST:
                    pot = Tools.NearestPOT(value);
                    break;
                case BABYLON.Engine.SCALEMODE_CEILING:
                default:
                    pot = Tools.CeilingPOT(value);
                    break;
            }
            return Math.min(pot, max);
        };
        Tools.GetFilename = function (path) {
            var index = path.lastIndexOf("/");
            if (index < 0)
                return path;
            return path.substring(index + 1);
        };
        /**
         * Extracts the "folder" part of a path (everything before the filename).
         * @param uri The URI to extract the info from
         * @param returnUnchangedIfNoSlash Do not touch the URI if no slashes are present
         * @returns The "folder" part of the path
         */
        Tools.GetFolderPath = function (uri, returnUnchangedIfNoSlash) {
            if (returnUnchangedIfNoSlash === void 0) { returnUnchangedIfNoSlash = false; }
            var index = uri.lastIndexOf("/");
            if (index < 0) {
                if (returnUnchangedIfNoSlash) {
                    return uri;
                }
                return "";
            }
            return uri.substring(0, index + 1);
        };
        Tools.GetDOMTextContent = function (element) {
            var result = "";
            var child = element.firstChild;
            while (child) {
                if (child.nodeType === 3) {
                    result += child.textContent;
                }
                child = child.nextSibling;
            }
            return result;
        };
        Tools.ToDegrees = function (angle) {
            return angle * 180 / Math.PI;
        };
        Tools.ToRadians = function (angle) {
            return angle * Math.PI / 180;
        };
        Tools.EncodeArrayBufferTobase64 = function (buffer) {
            var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            var bytes = new Uint8Array(buffer);
            while (i < bytes.length) {
                chr1 = bytes[i++];
                chr2 = i < bytes.length ? bytes[i++] : Number.NaN; // Not sure if the index 
                chr3 = i < bytes.length ? bytes[i++] : Number.NaN; // checks are needed here
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                }
                else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output += keyStr.charAt(enc1) + keyStr.charAt(enc2) +
                    keyStr.charAt(enc3) + keyStr.charAt(enc4);
            }
            return "data:image/png;base64," + output;
        };
        Tools.ExtractMinAndMaxIndexed = function (positions, indices, indexStart, indexCount, bias) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            for (var index = indexStart; index < indexStart + indexCount; index++) {
                var current = new BABYLON.Vector3(positions[indices[index] * 3], positions[indices[index] * 3 + 1], positions[indices[index] * 3 + 2]);
                minimum = BABYLON.Vector3.Minimize(current, minimum);
                maximum = BABYLON.Vector3.Maximize(current, maximum);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                minimum.z -= minimum.z * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
                maximum.z += maximum.z * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.ExtractMinAndMax = function (positions, start, count, bias, stride) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            if (!stride) {
                stride = 3;
            }
            for (var index = start; index < start + count; index++) {
                var current = new BABYLON.Vector3(positions[index * stride], positions[index * stride + 1], positions[index * stride + 2]);
                minimum = BABYLON.Vector3.Minimize(current, minimum);
                maximum = BABYLON.Vector3.Maximize(current, maximum);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                minimum.z -= minimum.z * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
                maximum.z += maximum.z * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.Vector2ArrayFeeder = function (array) {
            return function (index) {
                var isFloatArray = (array.BYTES_PER_ELEMENT !== undefined);
                var length = isFloatArray ? array.length / 2 : array.length;
                if (index >= length) {
                    return null;
                }
                if (isFloatArray) {
                    var fa = array;
                    return new BABYLON.Vector2(fa[index * 2 + 0], fa[index * 2 + 1]);
                }
                var a = array;
                return a[index];
            };
        };
        Tools.ExtractMinAndMaxVector2 = function (feeder, bias) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector2(Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector2(-Number.MAX_VALUE, -Number.MAX_VALUE);
            var i = 0;
            var cur = feeder(i++);
            while (cur) {
                minimum = BABYLON.Vector2.Minimize(cur, minimum);
                maximum = BABYLON.Vector2.Maximize(cur, maximum);
                cur = feeder(i++);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.MakeArray = function (obj, allowsNullUndefined) {
            if (allowsNullUndefined !== true && (obj === undefined || obj == null))
                return null;
            return Array.isArray(obj) ? obj : [obj];
        };
        // Misc.
        Tools.GetPointerPrefix = function () {
            var eventPrefix = "pointer";
            // Check if pointer events are supported
            if (Tools.IsWindowObjectExist() && !window.PointerEvent && !navigator.pointerEnabled) {
                eventPrefix = "mouse";
            }
            return eventPrefix;
        };
        /**
         * @param func - the function to be called
         * @param requester - the object that will request the next frame. Falls back to window.
         */
        Tools.QueueNewFrame = function (func, requester) {
            if (!Tools.IsWindowObjectExist()) {
                return setTimeout(func, 16);
            }
            if (!requester) {
                requester = window;
            }
            if (requester.requestAnimationFrame) {
                return requester.requestAnimationFrame(func);
            }
            else if (requester.msRequestAnimationFrame) {
                return requester.msRequestAnimationFrame(func);
            }
            else if (requester.webkitRequestAnimationFrame) {
                return requester.webkitRequestAnimationFrame(func);
            }
            else if (requester.mozRequestAnimationFrame) {
                return requester.mozRequestAnimationFrame(func);
            }
            else if (requester.oRequestAnimationFrame) {
                return requester.oRequestAnimationFrame(func);
            }
            else {
                return window.setTimeout(func, 16);
            }
        };
        Tools.RequestFullscreen = function (element) {
            var requestFunction = element.requestFullscreen || element.msRequestFullscreen || element.webkitRequestFullscreen || element.mozRequestFullScreen;
            if (!requestFunction)
                return;
            requestFunction.call(element);
        };
        Tools.ExitFullscreen = function () {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            }
            else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            }
            else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            }
            else if (document.msCancelFullScreen) {
                document.msCancelFullScreen();
            }
        };
        Tools.SetCorsBehavior = function (url, element) {
            if (url && url.indexOf("data:") === 0) {
                return;
            }
            if (Tools.CorsBehavior) {
                if (typeof (Tools.CorsBehavior) === 'string' || Tools.CorsBehavior instanceof String) {
                    element.crossOrigin = Tools.CorsBehavior;
                }
                else {
                    var result = Tools.CorsBehavior(url);
                    if (result) {
                        element.crossOrigin = result;
                    }
                }
            }
        };
        // External files
        Tools.CleanUrl = function (url) {
            url = url.replace(/#/mg, "%23");
            return url;
        };
        Tools.LoadImage = function (url, onLoad, onError, database) {
            if (url instanceof ArrayBuffer) {
                url = Tools.EncodeArrayBufferTobase64(url);
            }
            url = Tools.CleanUrl(url);
            url = Tools.PreprocessUrl(url);
            var img = new Image();
            Tools.SetCorsBehavior(url, img);
            var loadHandler = function () {
                img.removeEventListener("load", loadHandler);
                img.removeEventListener("error", errorHandler);
                onLoad(img);
            };
            var errorHandler = function (err) {
                img.removeEventListener("load", loadHandler);
                img.removeEventListener("error", errorHandler);
                Tools.Error("Error while trying to load image: " + url);
                if (onError) {
                    onError("Error while trying to load image: " + url, err);
                }
            };
            img.addEventListener("load", loadHandler);
            img.addEventListener("error", errorHandler);
            var noIndexedDB = function () {
                img.src = url;
            };
            var loadFromIndexedDB = function () {
                if (database) {
                    database.loadImageFromDB(url, img);
                }
            };
            //ANY database to do!
            if (url.substr(0, 5) !== "data:" && database && database.enableTexturesOffline && BABYLON.Database.IsUASupportingBlobStorage) {
                database.openAsync(loadFromIndexedDB, noIndexedDB);
            }
            else {
                if (url.indexOf("file:") !== -1) {
                    var textureName = decodeURIComponent(url.substring(5).toLowerCase());
                    if (BABYLON.FilesInput.FilesToLoad[textureName]) {
                        try {
                            var blobURL;
                            try {
                                blobURL = URL.createObjectURL(BABYLON.FilesInput.FilesToLoad[textureName], { oneTimeOnly: true });
                            }
                            catch (ex) {
                                // Chrome doesn't support oneTimeOnly parameter
                                blobURL = URL.createObjectURL(BABYLON.FilesInput.FilesToLoad[textureName]);
                            }
                            img.src = blobURL;
                        }
                        catch (e) {
                            img.src = "";
                        }
                        return img;
                    }
                }
                noIndexedDB();
            }
            return img;
        };
        Tools.LoadFile = function (url, onSuccess, onProgress, database, useArrayBuffer, onError) {
            url = Tools.CleanUrl(url);
            url = Tools.PreprocessUrl(url);
            // If file and file input are set
            if (url.indexOf("file:") !== -1) {
                var fileName = decodeURIComponent(url.substring(5).toLowerCase());
                if (BABYLON.FilesInput.FilesToLoad[fileName]) {
                    return Tools.ReadFile(BABYLON.FilesInput.FilesToLoad[fileName], onSuccess, onProgress, useArrayBuffer);
                }
            }
            var loadUrl = Tools.BaseUrl + url;
            var aborted = false;
            var fileRequest = {
                onCompleteObservable: new BABYLON.Observable(),
                abort: function () { return aborted = true; },
            };
            var requestFile = function () {
                var request = new XMLHttpRequest();
                var retryHandle = null;
                fileRequest.abort = function () {
                    aborted = true;
                    if (request.readyState !== (XMLHttpRequest.DONE || 4)) {
                        request.abort();
                    }
                    if (retryHandle !== null) {
                        clearTimeout(retryHandle);
                        retryHandle = null;
                    }
                };
                var retryLoop = function (retryIndex) {
                    request.open('GET', loadUrl, true);
                    if (useArrayBuffer) {
                        request.responseType = "arraybuffer";
                    }
                    if (onProgress) {
                        request.addEventListener("progress", onProgress);
                    }
                    var onLoadEnd = function () {
                        request.removeEventListener("loadend", onLoadEnd);
                        fileRequest.onCompleteObservable.notifyObservers(fileRequest);
                        fileRequest.onCompleteObservable.clear();
                    };
                    request.addEventListener("loadend", onLoadEnd);
                    var onReadyStateChange = function () {
                        if (aborted) {
                            return;
                        }
                        // In case of undefined state in some browsers.
                        if (request.readyState === (XMLHttpRequest.DONE || 4)) {
                            // Some browsers have issues where onreadystatechange can be called multiple times with the same value.
                            request.removeEventListener("readystatechange", onReadyStateChange);
                            if (request.status >= 200 && request.status < 300 || (!Tools.IsWindowObjectExist() && (request.status === 0))) {
                                onSuccess(!useArrayBuffer ? request.responseText : request.response, request.responseURL);
                                return;
                            }
                            var retryStrategy = Tools.DefaultRetryStrategy;
                            if (retryStrategy) {
                                var waitTime = retryStrategy(loadUrl, request, retryIndex);
                                if (waitTime !== -1) {
                                    // Prevent the request from completing for retry.
                                    request.removeEventListener("loadend", onLoadEnd);
                                    request = new XMLHttpRequest();
                                    retryHandle = setTimeout(function () { return retryLoop(retryIndex + 1); }, waitTime);
                                    return;
                                }
                            }
                            var e = new LoadFileError("Error status: " + request.status + " " + request.statusText + " - Unable to load " + loadUrl, request);
                            if (onError) {
                                onError(request, e);
                            }
                            else {
                                throw e;
                            }
                        }
                    };
                    request.addEventListener("readystatechange", onReadyStateChange);
                    request.send();
                };
                retryLoop(0);
            };
            // Caching all files
            if (database && database.enableSceneOffline) {
                var noIndexedDB_1 = function () {
                    if (!aborted) {
                        requestFile();
                    }
                };
                var loadFromIndexedDB = function () {
                    // TODO: database needs to support aborting and should return a IFileRequest
                    if (aborted) {
                        return;
                    }
                    if (database) {
                        database.loadFileFromDB(url, function (data) {
                            if (!aborted) {
                                onSuccess(data);
                            }
                            fileRequest.onCompleteObservable.notifyObservers(fileRequest);
                        }, onProgress ? function (event) {
                            if (!aborted) {
                                onProgress(event);
                            }
                        } : undefined, noIndexedDB_1, useArrayBuffer);
                    }
                };
                database.openAsync(loadFromIndexedDB, noIndexedDB_1);
            }
            else {
                requestFile();
            }
            return fileRequest;
        };
        /**
         * Load a script (identified by an url). When the url returns, the
         * content of this file is added into a new script element, attached to the DOM (body element)
         */
        Tools.LoadScript = function (scriptUrl, onSuccess, onError) {
            var head = document.getElementsByTagName('head')[0];
            var script = document.createElement('script');
            script.type = 'text/javascript';
            script.src = scriptUrl;
            script.onload = function () {
                if (onSuccess) {
                    onSuccess();
                }
            };
            script.onerror = function (e) {
                if (onError) {
                    onError("Unable to load script '" + scriptUrl + "'", e);
                }
            };
            head.appendChild(script);
        };
        Tools.ReadFileAsDataURL = function (fileToLoad, callback, progressCallback) {
            var reader = new FileReader();
            var request = {
                onCompleteObservable: new BABYLON.Observable(),
                abort: function () { return reader.abort(); },
            };
            reader.onloadend = function (e) {
                request.onCompleteObservable.notifyObservers(request);
            };
            reader.onload = function (e) {
                //target doesn't have result from ts 1.3
                callback(e.target['result']);
            };
            reader.onprogress = progressCallback;
            reader.readAsDataURL(fileToLoad);
            return request;
        };
        Tools.ReadFile = function (fileToLoad, callback, progressCallBack, useArrayBuffer) {
            var reader = new FileReader();
            var request = {
                onCompleteObservable: new BABYLON.Observable(),
                abort: function () { return reader.abort(); },
            };
            reader.onloadend = function (e) { return request.onCompleteObservable.notifyObservers(request); };
            reader.onerror = function (e) {
                Tools.Log("Error while reading file: " + fileToLoad.name);
                callback(JSON.stringify({ autoClear: true, clearColor: [1, 0, 0], ambientColor: [0, 0, 0], gravity: [0, -9.807, 0], meshes: [], cameras: [], lights: [] }));
            };
            reader.onload = function (e) {
                //target doesn't have result from ts 1.3
                callback(e.target['result']);
            };
            if (progressCallBack) {
                reader.onprogress = progressCallBack;
            }
            if (!useArrayBuffer) {
                // Asynchronous read
                reader.readAsText(fileToLoad);
            }
            else {
                reader.readAsArrayBuffer(fileToLoad);
            }
            return request;
        };
        //returns a downloadable url to a file content.
        Tools.FileAsURL = function (content) {
            var fileBlob = new Blob([content]);
            var url = window.URL || window.webkitURL;
            var link = url.createObjectURL(fileBlob);
            return link;
        };
        // Misc.
        Tools.Format = function (value, decimals) {
            if (decimals === void 0) { decimals = 2; }
            return value.toFixed(decimals);
        };
        Tools.CheckExtends = function (v, min, max) {
            if (v.x < min.x)
                min.x = v.x;
            if (v.y < min.y)
                min.y = v.y;
            if (v.z < min.z)
                min.z = v.z;
            if (v.x > max.x)
                max.x = v.x;
            if (v.y > max.y)
                max.y = v.y;
            if (v.z > max.z)
                max.z = v.z;
        };
        Tools.DeepCopy = function (source, destination, doNotCopyList, mustCopyList) {
            for (var prop in source) {
                if (prop[0] === "_" && (!mustCopyList || mustCopyList.indexOf(prop) === -1)) {
                    continue;
                }
                if (doNotCopyList && doNotCopyList.indexOf(prop) !== -1) {
                    continue;
                }
                var sourceValue = source[prop];
                var typeOfSourceValue = typeof sourceValue;
                if (typeOfSourceValue === "function") {
                    continue;
                }
                try {
                    if (typeOfSourceValue === "object") {
                        if (sourceValue instanceof Array) {
                            destination[prop] = [];
                            if (sourceValue.length > 0) {
                                if (typeof sourceValue[0] == "object") {
                                    for (var index = 0; index < sourceValue.length; index++) {
                                        var clonedValue = cloneValue(sourceValue[index], destination);
                                        if (destination[prop].indexOf(clonedValue) === -1) { // Test if auto inject was not done
                                            destination[prop].push(clonedValue);
                                        }
                                    }
                                }
                                else {
                                    destination[prop] = sourceValue.slice(0);
                                }
                            }
                        }
                        else {
                            destination[prop] = cloneValue(sourceValue, destination);
                        }
                    }
                    else {
                        destination[prop] = sourceValue;
                    }
                }
                catch (e) {
                    // Just ignore error (it could be because of a read-only property)
                }
            }
        };
        Tools.IsEmpty = function (obj) {
            for (var i in obj) {
                if (obj.hasOwnProperty(i)) {
                    return false;
                }
            }
            return true;
        };
        Tools.RegisterTopRootEvents = function (events) {
            for (var index = 0; index < events.length; index++) {
                var event = events[index];
                window.addEventListener(event.name, event.handler, false);
                try {
                    if (window.parent) {
                        window.parent.addEventListener(event.name, event.handler, false);
                    }
                }
                catch (e) {
                    // Silently fails...
                }
            }
        };
        Tools.UnregisterTopRootEvents = function (events) {
            for (var index = 0; index < events.length; index++) {
                var event = events[index];
                window.removeEventListener(event.name, event.handler);
                try {
                    if (window.parent) {
                        window.parent.removeEventListener(event.name, event.handler);
                    }
                }
                catch (e) {
                    // Silently fails...
                }
            }
        };
        Tools.DumpFramebuffer = function (width, height, engine, successCallback, mimeType, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            // Read the contents of the framebuffer
            var numberOfChannelsByLine = width * 4;
            var halfHeight = height / 2;
            //Reading datas from WebGL
            var data = engine.readPixels(0, 0, width, height);
            //To flip image on Y axis.
            for (var i = 0; i < halfHeight; i++) {
                for (var j = 0; j < numberOfChannelsByLine; j++) {
                    var currentCell = j + i * numberOfChannelsByLine;
                    var targetLine = height - i - 1;
                    var targetCell = j + targetLine * numberOfChannelsByLine;
                    var temp = data[currentCell];
                    data[currentCell] = data[targetCell];
                    data[targetCell] = temp;
                }
            }
            // Create a 2D canvas to store the result
            if (!screenshotCanvas) {
                screenshotCanvas = document.createElement('canvas');
            }
            screenshotCanvas.width = width;
            screenshotCanvas.height = height;
            var context = screenshotCanvas.getContext('2d');
            if (context) {
                // Copy the pixels to a 2D canvas
                var imageData = context.createImageData(width, height);
                var castData = (imageData.data);
                castData.set(data);
                context.putImageData(imageData, 0, 0);
                Tools.EncodeScreenshotCanvasData(successCallback, mimeType, fileName);
            }
        };
        Tools.EncodeScreenshotCanvasData = function (successCallback, mimeType, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            var base64Image = screenshotCanvas.toDataURL(mimeType);
            if (successCallback) {
                successCallback(base64Image);
            }
            else {
                // We need HTMLCanvasElement.toBlob for HD screenshots
                if (!screenshotCanvas.toBlob) {
                    //  low performance polyfill based on toDataURL (https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob)
                    screenshotCanvas.toBlob = function (callback, type, quality) {
                        var _this = this;
                        setTimeout(function () {
                            var binStr = atob(_this.toDataURL(type, quality).split(',')[1]), len = binStr.length, arr = new Uint8Array(len);
                            for (var i = 0; i < len; i++) {
                                arr[i] = binStr.charCodeAt(i);
                            }
                            callback(new Blob([arr], { type: type || 'image/png' }));
                        });
                    };
                }
                screenshotCanvas.toBlob(function (blob) {
                    var url = URL.createObjectURL(blob);
                    //Creating a link if the browser have the download attribute on the a tag, to automatically start download generated image.
                    if (("download" in document.createElement("a"))) {
                        var a = window.document.createElement("a");
                        a.href = url;
                        if (fileName) {
                            a.setAttribute("download", fileName);
                        }
                        else {
                            var date = new Date();
                            var stringDate = (date.getFullYear() + "-" + (date.getMonth() + 1)).slice(-2) + "-" + date.getDate() + "_" + date.getHours() + "-" + ('0' + date.getMinutes()).slice(-2);
                            a.setAttribute("download", "screenshot_" + stringDate + ".png");
                        }
                        window.document.body.appendChild(a);
                        a.addEventListener("click", function () {
                            if (a.parentElement) {
                                a.parentElement.removeChild(a);
                            }
                        });
                        a.click();
                    }
                    else {
                        var newWindow = window.open("");
                        if (!newWindow)
                            return;
                        var img = newWindow.document.createElement("img");
                        img.onload = function () {
                            // no longer need to read the blob so it's revoked
                            URL.revokeObjectURL(url);
                        };
                        img.src = url;
                        newWindow.document.body.appendChild(img);
                    }
                });
            }
        };
        Tools.CreateScreenshot = function (engine, camera, size, successCallback, mimeType) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            var width;
            var height;
            // If a precision value is specified
            if (size.precision) {
                width = Math.round(engine.getRenderWidth() * size.precision);
                height = Math.round(width / engine.getAspectRatio(camera));
            }
            else if (size.width && size.height) {
                width = size.width;
                height = size.height;
            }
            //If passing only width, computing height to keep display canvas ratio.
            else if (size.width && !size.height) {
                width = size.width;
                height = Math.round(width / engine.getAspectRatio(camera));
            }
            //If passing only height, computing width to keep display canvas ratio.
            else if (size.height && !size.width) {
                height = size.height;
                width = Math.round(height * engine.getAspectRatio(camera));
            }
            //Assuming here that "size" parameter is a number
            else if (!isNaN(size)) {
                height = size;
                width = size;
            }
            else {
                Tools.Error("Invalid 'size' parameter !");
                return;
            }
            if (!screenshotCanvas) {
                screenshotCanvas = document.createElement('canvas');
            }
            screenshotCanvas.width = width;
            screenshotCanvas.height = height;
            var renderContext = screenshotCanvas.getContext("2d");
            var ratio = engine.getRenderWidth() / engine.getRenderHeight();
            var newWidth = width;
            var newHeight = newWidth / ratio;
            if (newHeight > height) {
                newHeight = height;
                newWidth = newHeight * ratio;
            }
            var offsetX = Math.max(0, width - newWidth) / 2;
            var offsetY = Math.max(0, height - newHeight) / 2;
            var renderingCanvas = engine.getRenderingCanvas();
            if (renderContext && renderingCanvas) {
                renderContext.drawImage(renderingCanvas, offsetX, offsetY, newWidth, newHeight);
            }
            Tools.EncodeScreenshotCanvasData(successCallback, mimeType);
        };
        /**
         * Generates an image screenshot from the specified camera.
         *
         * @param engine The engine to use for rendering
         * @param camera The camera to use for rendering
         * @param size This parameter can be set to a single number or to an object with the
         * following (optional) properties: precision, width, height. If a single number is passed,
         * it will be used for both width and height. If an object is passed, the screenshot size
         * will be derived from the parameters. The precision property is a multiplier allowing
         * rendering at a higher or lower resolution.
         * @param successCallback The callback receives a single parameter which contains the
         * screenshot as a string of base64-encoded characters. This string can be assigned to the
         * src parameter of an <img> to display it.
         * @param mimeType The MIME type of the screenshot image (default: image/png).
         * Check your browser for supported MIME types.
         * @param samples Texture samples (default: 1)
         * @param antialiasing Whether antialiasing should be turned on or not (default: false)
         * @param fileName A name for for the downloaded file.
         * @constructor
         */
        Tools.CreateScreenshotUsingRenderTarget = function (engine, camera, size, successCallback, mimeType, samples, antialiasing, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            if (samples === void 0) { samples = 1; }
            if (antialiasing === void 0) { antialiasing = false; }
            var width;
            var height;
            //If a precision value is specified
            if (size.precision) {
                width = Math.round(engine.getRenderWidth() * size.precision);
                height = Math.round(width / engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            else if (size.width && size.height) {
                width = size.width;
                height = size.height;
            }
            //If passing only width, computing height to keep display canvas ratio.
            else if (size.width && !size.height) {
                width = size.width;
                height = Math.round(width / engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            //If passing only height, computing width to keep display canvas ratio.
            else if (size.height && !size.width) {
                height = size.height;
                width = Math.round(height * engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            //Assuming here that "size" parameter is a number
            else if (!isNaN(size)) {
                height = size;
                width = size;
            }
            else {
                Tools.Error("Invalid 'size' parameter !");
                return;
            }
            var scene = camera.getScene();
            var previousCamera = null;
            if (scene.activeCamera !== camera) {
                previousCamera = scene.activeCamera;
                scene.activeCamera = camera;
            }
            //At this point size can be a number, or an object (according to engine.prototype.createRenderTargetTexture method)
            var texture = new BABYLON.RenderTargetTexture("screenShot", size, scene, false, false, BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
            texture.renderList = null;
            texture.samples = samples;
            if (antialiasing) {
                texture.addPostProcess(new BABYLON.FxaaPostProcess('antialiasing', 1.0, scene.activeCamera));
            }
            texture.onAfterRenderObservable.add(function () {
                Tools.DumpFramebuffer(width, height, engine, successCallback, mimeType, fileName);
            });
            scene.incrementRenderId();
            scene.resetCachedMaterial();
            texture.render(true);
            texture.dispose();
            if (previousCamera) {
                scene.activeCamera = previousCamera;
            }
            camera.getProjectionMatrix(true); // Force cache refresh;
        };
        // XHR response validator for local file scenario
        Tools.ValidateXHRData = function (xhr, dataType) {
            // 1 for text (.babylon, manifest and shaders), 2 for TGA, 4 for DDS, 7 for all
            if (dataType === void 0) { dataType = 7; }
            try {
                if (dataType & 1) {
                    if (xhr.responseText && xhr.responseText.length > 0) {
                        return true;
                    }
                    else if (dataType === 1) {
                        return false;
                    }
                }
                if (dataType & 2) {
                    // Check header width and height since there is no "TGA" magic number
                    var tgaHeader = BABYLON.TGATools.GetTGAHeader(xhr.response);
                    if (tgaHeader.width && tgaHeader.height && tgaHeader.width > 0 && tgaHeader.height > 0) {
                        return true;
                    }
                    else if (dataType === 2) {
                        return false;
                    }
                }
                if (dataType & 4) {
                    // Check for the "DDS" magic number
                    var ddsHeader = new Uint8Array(xhr.response, 0, 3);
                    if (ddsHeader[0] === 68 && ddsHeader[1] === 68 && ddsHeader[2] === 83) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
            }
            catch (e) {
                // Global protection
            }
            return false;
        };
        /**
         * Implementation from http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/2117523#answer-2117523
         * Be aware Math.random() could cause collisions, but:
         * "All but 6 of the 128 bits of the ID are randomly generated, which means that for any two ids, there's a 1 in 2^^122 (or 5.3x10^^36) chance they'll collide"
         */
        Tools.RandomId = function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        };
        /**
        * Test if the given uri is a base64 string.
        * @param uri The uri to test
        * @return True if the uri is a base64 string or false otherwise.
        */
        Tools.IsBase64 = function (uri) {
            return uri.length < 5 ? false : uri.substr(0, 5) === "data:";
        };
        /**
        * Decode the given base64 uri.
        * @param uri The uri to decode
        * @return The decoded base64 data.
        */
        Tools.DecodeBase64 = function (uri) {
            var decodedString = atob(uri.split(",")[1]);
            var bufferLength = decodedString.length;
            var bufferView = new Uint8Array(new ArrayBuffer(bufferLength));
            for (var i = 0; i < bufferLength; i++) {
                bufferView[i] = decodedString.charCodeAt(i);
            }
            return bufferView.buffer;
        };
        Object.defineProperty(Tools, "NoneLogLevel", {
            get: function () {
                return Tools._NoneLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "MessageLogLevel", {
            get: function () {
                return Tools._MessageLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "WarningLogLevel", {
            get: function () {
                return Tools._WarningLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "ErrorLogLevel", {
            get: function () {
                return Tools._ErrorLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "AllLogLevel", {
            get: function () {
                return Tools._MessageLogLevel | Tools._WarningLogLevel | Tools._ErrorLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Tools._AddLogEntry = function (entry) {
            Tools._LogCache = entry + Tools._LogCache;
            if (Tools.OnNewCacheEntry) {
                Tools.OnNewCacheEntry(entry);
            }
        };
        Tools._FormatMessage = function (message) {
            var padStr = function (i) { return (i < 10) ? "0" + i : "" + i; };
            var date = new Date();
            return "[" + padStr(date.getHours()) + ":" + padStr(date.getMinutes()) + ":" + padStr(date.getSeconds()) + "]: " + message;
        };
        Tools._LogDisabled = function (message) {
            // nothing to do
        };
        Tools._LogEnabled = function (message) {
            var formattedMessage = Tools._FormatMessage(message);
            console.log("BJS - " + formattedMessage);
            var entry = "<div style='color:white'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Tools._WarnDisabled = function (message) {
            // nothing to do
        };
        Tools._WarnEnabled = function (message) {
            var formattedMessage = Tools._FormatMessage(message);
            console.warn("BJS - " + formattedMessage);
            var entry = "<div style='color:orange'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Tools._ErrorDisabled = function (message) {
            // nothing to do
        };
        Tools._ErrorEnabled = function (message) {
            Tools.errorsCount++;
            var formattedMessage = Tools._FormatMessage(message);
            console.error("BJS - " + formattedMessage);
            var entry = "<div style='color:red'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Object.defineProperty(Tools, "LogCache", {
            get: function () {
                return Tools._LogCache;
            },
            enumerable: true,
            configurable: true
        });
        Tools.ClearLogCache = function () {
            Tools._LogCache = "";
            Tools.errorsCount = 0;
        };
        Object.defineProperty(Tools, "LogLevels", {
            set: function (level) {
                if ((level & Tools.MessageLogLevel) === Tools.MessageLogLevel) {
                    Tools.Log = Tools._LogEnabled;
                }
                else {
                    Tools.Log = Tools._LogDisabled;
                }
                if ((level & Tools.WarningLogLevel) === Tools.WarningLogLevel) {
                    Tools.Warn = Tools._WarnEnabled;
                }
                else {
                    Tools.Warn = Tools._WarnDisabled;
                }
                if ((level & Tools.ErrorLogLevel) === Tools.ErrorLogLevel) {
                    Tools.Error = Tools._ErrorEnabled;
                }
                else {
                    Tools.Error = Tools._ErrorDisabled;
                }
            },
            enumerable: true,
            configurable: true
        });
        Tools.IsWindowObjectExist = function () {
            return (typeof window) !== "undefined";
        };
        Object.defineProperty(Tools, "PerformanceNoneLogLevel", {
            get: function () {
                return Tools._PerformanceNoneLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceUserMarkLogLevel", {
            get: function () {
                return Tools._PerformanceUserMarkLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceConsoleLogLevel", {
            get: function () {
                return Tools._PerformanceConsoleLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceLogLevel", {
            set: function (level) {
                if ((level & Tools.PerformanceUserMarkLogLevel) === Tools.PerformanceUserMarkLogLevel) {
                    Tools.StartPerformanceCounter = Tools._StartUserMark;
                    Tools.EndPerformanceCounter = Tools._EndUserMark;
                    return;
                }
                if ((level & Tools.PerformanceConsoleLogLevel) === Tools.PerformanceConsoleLogLevel) {
                    Tools.StartPerformanceCounter = Tools._StartPerformanceConsole;
                    Tools.EndPerformanceCounter = Tools._EndPerformanceConsole;
                    return;
                }
                Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
                Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
            },
            enumerable: true,
            configurable: true
        });
        Tools._StartPerformanceCounterDisabled = function (counterName, condition) {
        };
        Tools._EndPerformanceCounterDisabled = function (counterName, condition) {
        };
        Tools._StartUserMark = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!Tools._performance) {
                if (!Tools.IsWindowObjectExist()) {
                    return;
                }
                Tools._performance = window.performance;
            }
            if (!condition || !Tools._performance.mark) {
                return;
            }
            Tools._performance.mark(counterName + "-Begin");
        };
        Tools._EndUserMark = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition || !Tools._performance.mark) {
                return;
            }
            Tools._performance.mark(counterName + "-End");
            Tools._performance.measure(counterName, counterName + "-Begin", counterName + "-End");
        };
        Tools._StartPerformanceConsole = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition) {
                return;
            }
            Tools._StartUserMark(counterName, condition);
            if (console.time) {
                console.time(counterName);
            }
        };
        Tools._EndPerformanceConsole = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition) {
                return;
            }
            Tools._EndUserMark(counterName, condition);
            if (console.time) {
                console.timeEnd(counterName);
            }
        };
        Object.defineProperty(Tools, "Now", {
            get: function () {
                if (Tools.IsWindowObjectExist() && window.performance && window.performance.now) {
                    return window.performance.now();
                }
                return Date.now();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * This method will return the name of the class used to create the instance of the given object.
         * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator.
         * @param object the object to get the class name from
         * @return the name of the class, will be "object" for a custom data type not using the @className decorator
         */
        Tools.GetClassName = function (object, isType) {
            if (isType === void 0) { isType = false; }
            var name = null;
            if (!isType && object.getClassName) {
                name = object.getClassName();
            }
            else {
                if (object instanceof Object) {
                    var classObj = isType ? object : Object.getPrototypeOf(object);
                    name = classObj.constructor["__bjsclassName__"];
                }
                if (!name) {
                    name = typeof object;
                }
            }
            return name;
        };
        Tools.First = function (array, predicate) {
            for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
                var el = array_1[_i];
                if (predicate(el)) {
                    return el;
                }
            }
            return null;
        };
        /**
         * This method will return the name of the full name of the class, including its owning module (if any).
         * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator or implementing a method getClassName():string (in which case the module won't be specified).
         * @param object the object to get the class name from
         * @return a string that can have two forms: "moduleName.className" if module was specified when the class' Name was registered or "className" if there was not module specified.
         */
        Tools.getFullClassName = function (object, isType) {
            if (isType === void 0) { isType = false; }
            var className = null;
            var moduleName = null;
            if (!isType && object.getClassName) {
                className = object.getClassName();
            }
            else {
                if (object instanceof Object) {
                    var classObj = isType ? object : Object.getPrototypeOf(object);
                    className = classObj.constructor["__bjsclassName__"];
                    moduleName = classObj.constructor["__bjsmoduleName__"];
                }
                if (!className) {
                    className = typeof object;
                }
            }
            if (!className) {
                return null;
            }
            return ((moduleName != null) ? (moduleName + ".") : "") + className;
        };
        /**
         * This method can be used with hashCodeFromStream when your input is an array of values that are either: number, string, boolean or custom type implementing the getHashCode():number method.
         * @param array
         */
        Tools.arrayOrStringFeeder = function (array) {
            return function (index) {
                if (index >= array.length) {
                    return null;
                }
                var val = array.charCodeAt ? array.charCodeAt(index) : array[index];
                if (val && val.getHashCode) {
                    val = val.getHashCode();
                }
                if (typeof val === "string") {
                    return Tools.hashCodeFromStream(Tools.arrayOrStringFeeder(val));
                }
                return val;
            };
        };
        /**
         * Compute the hashCode of a stream of number
         * To compute the HashCode on a string or an Array of data types implementing the getHashCode() method, use the arrayOrStringFeeder method.
         * @param feeder a callback that will be called until it returns null, each valid returned values will be used to compute the hash code.
         * @return the hash code computed
         */
        Tools.hashCodeFromStream = function (feeder) {
            // Based from here: http://stackoverflow.com/a/7616484/802124
            var hash = 0;
            var index = 0;
            var chr = feeder(index++);
            while (chr != null) {
                hash = ((hash << 5) - hash) + chr;
                hash |= 0; // Convert to 32bit integer
                chr = feeder(index++);
            }
            return hash;
        };
        /**
         * Returns a promise that resolves after the given amount of time.
         * @param delay Number of milliseconds to delay
         * @returns Promise that resolves after the given amount of time
         */
        Tools.DelayAsync = function (delay) {
            return new Promise(function (resolve) {
                setTimeout(function () {
                    resolve();
                }, delay);
            });
        };
        Tools.BaseUrl = "";
        Tools.DefaultRetryStrategy = RetryStrategy.ExponentialBackoff();
        /**
         * Default behaviour for cors in the application.
         * It can be a string if the expected behavior is identical in the entire app.
         * Or a callback to be able to set it per url or on a group of them (in case of Video source for instance)
         */
        Tools.CorsBehavior = "anonymous";
        Tools.UseFallbackTexture = true;
        /**
         * Use this object to register external classes like custom textures or material
         * to allow the laoders to instantiate them
         */
        Tools.RegisteredExternalClasses = {};
        // Used in case of a texture loading problem 
        Tools.fallbackTexture = "data:image/jpg;base64,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";
        Tools._tmpFloatArray = new Float32Array(1);
        Tools.PreprocessUrl = function (url) {
            return url;
        };
        // Logs
        Tools._NoneLogLevel = 0;
        Tools._MessageLogLevel = 1;
        Tools._WarningLogLevel = 2;
        Tools._ErrorLogLevel = 4;
        Tools._LogCache = "";
        Tools.errorsCount = 0;
        Tools.Log = Tools._LogEnabled;
        Tools.Warn = Tools._WarnEnabled;
        Tools.Error = Tools._ErrorEnabled;
        // Performances
        Tools._PerformanceNoneLogLevel = 0;
        Tools._PerformanceUserMarkLogLevel = 1;
        Tools._PerformanceConsoleLogLevel = 2;
        Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
        Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
        return Tools;
    }());
    BABYLON.Tools = Tools;
    /**
     * This class is used to track a performance counter which is number based.
     * The user has access to many properties which give statistics of different nature
     *
     * The implementer can track two kinds of Performance Counter: time and count
     * For time you can optionally call fetchNewFrame() to notify the start of a new frame to monitor, then call beginMonitoring() to start and endMonitoring() to record the lapsed time. endMonitoring takes a newFrame parameter for you to specify if the monitored time should be set for a new frame or accumulated to the current frame being monitored.
     * For count you first have to call fetchNewFrame() to notify the start of a new frame to monitor, then call addCount() how many time required to increment the count value you monitor.
     */
    var PerfCounter = /** @class */ (function () {
        function PerfCounter() {
            this._startMonitoringTime = 0;
            this._min = 0;
            this._max = 0;
            this._average = 0;
            this._lastSecAverage = 0;
            this._current = 0;
            this._totalValueCount = 0;
            this._totalAccumulated = 0;
            this._lastSecAccumulated = 0;
            this._lastSecTime = 0;
            this._lastSecValueCount = 0;
        }
        Object.defineProperty(PerfCounter.prototype, "min", {
            /**
             * Returns the smallest value ever
             */
            get: function () {
                return this._min;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "max", {
            /**
             * Returns the biggest value ever
             */
            get: function () {
                return this._max;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "average", {
            /**
             * Returns the average value since the performance counter is running
             */
            get: function () {
                return this._average;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "lastSecAverage", {
            /**
             * Returns the average value of the last second the counter was monitored
             */
            get: function () {
                return this._lastSecAverage;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "current", {
            /**
             * Returns the current value
             */
            get: function () {
                return this._current;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "total", {
            get: function () {
                return this._totalAccumulated;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "count", {
            get: function () {
                return this._totalValueCount;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Call this method to start monitoring a new frame.
         * This scenario is typically used when you accumulate monitoring time many times for a single frame, you call this method at the start of the frame, then beginMonitoring to start recording and endMonitoring(false) to accumulated the recorded time to the PerfCounter or addCount() to accumulate a monitored count.
         */
        PerfCounter.prototype.fetchNewFrame = function () {
            this._totalValueCount++;
            this._current = 0;
            this._lastSecValueCount++;
        };
        /**
         * Call this method to monitor a count of something (e.g. mesh drawn in viewport count)
         * @param newCount the count value to add to the monitored count
         * @param fetchResult true when it's the last time in the frame you add to the counter and you wish to update the statistics properties (min/max/average), false if you only want to update statistics.
         */
        PerfCounter.prototype.addCount = function (newCount, fetchResult) {
            if (!PerfCounter.Enabled) {
                return;
            }
            this._current += newCount;
            if (fetchResult) {
                this._fetchResult();
            }
        };
        /**
         * Start monitoring this performance counter
         */
        PerfCounter.prototype.beginMonitoring = function () {
            if (!PerfCounter.Enabled) {
                return;
            }
            this._startMonitoringTime = Tools.Now;
        };
        /**
         * Compute the time lapsed since the previous beginMonitoring() call.
         * @param newFrame true by default to fetch the result and monitor a new frame, if false the time monitored will be added to the current frame counter
         */
        PerfCounter.prototype.endMonitoring = function (newFrame) {
            if (newFrame === void 0) { newFrame = true; }
            if (!PerfCounter.Enabled) {
                return;
            }
            if (newFrame) {
                this.fetchNewFrame();
            }
            var currentTime = Tools.Now;
            this._current = currentTime - this._startMonitoringTime;
            if (newFrame) {
                this._fetchResult();
            }
        };
        PerfCounter.prototype._fetchResult = function () {
            this._totalAccumulated += this._current;
            this._lastSecAccumulated += this._current;
            // Min/Max update
            this._min = Math.min(this._min, this._current);
            this._max = Math.max(this._max, this._current);
            this._average = this._totalAccumulated / this._totalValueCount;
            // Reset last sec?
            var now = Tools.Now;
            if ((now - this._lastSecTime) > 1000) {
                this._lastSecAverage = this._lastSecAccumulated / this._lastSecValueCount;
                this._lastSecTime = now;
                this._lastSecAccumulated = 0;
                this._lastSecValueCount = 0;
            }
        };
        PerfCounter.Enabled = true;
        return PerfCounter;
    }());
    BABYLON.PerfCounter = PerfCounter;
    /**
     * Use this className as a decorator on a given class definition to add it a name and optionally its module.
     * You can then use the Tools.getClassName(obj) on an instance to retrieve its class name.
     * This method is the only way to get it done in all cases, even if the .js file declaring the class is minified
     * @param name The name of the class, case should be preserved
     * @param module The name of the Module hosting the class, optional, but strongly recommended to specify if possible. Case should be preserved.
     */
    function className(name, module) {
        return function (target) {
            target["__bjsclassName__"] = name;
            target["__bjsmoduleName__"] = (module != null) ? module : null;
        };
    }
    BABYLON.className = className;
    /**
    * An implementation of a loop for asynchronous functions.
    */
    var AsyncLoop = /** @class */ (function () {
        /**
         * Constroctor.
         * @param iterations the number of iterations.
         * @param _fn the function to run each iteration
         * @param _successCallback the callback that will be called upon succesful execution
         * @param offset starting offset.
         */
        function AsyncLoop(iterations, _fn, _successCallback, offset) {
            if (offset === void 0) { offset = 0; }
            this.iterations = iterations;
            this._fn = _fn;
            this._successCallback = _successCallback;
            this.index = offset - 1;
            this._done = false;
        }
        /**
         * Execute the next iteration. Must be called after the last iteration was finished.
         */
        AsyncLoop.prototype.executeNext = function () {
            if (!this._done) {
                if (this.index + 1 < this.iterations) {
                    ++this.index;
                    this._fn(this);
                }
                else {
                    this.breakLoop();
                }
            }
        };
        /**
         * Break the loop and run the success callback.
         */
        AsyncLoop.prototype.breakLoop = function () {
            this._done = true;
            this._successCallback();
        };
        /**
         * Helper function
         */
        AsyncLoop.Run = function (iterations, _fn, _successCallback, offset) {
            if (offset === void 0) { offset = 0; }
            var loop = new AsyncLoop(iterations, _fn, _successCallback, offset);
            loop.executeNext();
            return loop;
        };
        /**
         * A for-loop that will run a given number of iterations synchronous and the rest async.
         * @param iterations total number of iterations
         * @param syncedIterations number of synchronous iterations in each async iteration.
         * @param fn the function to call each iteration.
         * @param callback a success call back that will be called when iterating stops.
         * @param breakFunction a break condition (optional)
         * @param timeout timeout settings for the setTimeout function. default - 0.
         * @constructor
         */
        AsyncLoop.SyncAsyncForLoop = function (iterations, syncedIterations, fn, callback, breakFunction, timeout) {
            if (timeout === void 0) { timeout = 0; }
            AsyncLoop.Run(Math.ceil(iterations / syncedIterations), function (loop) {
                if (breakFunction && breakFunction())
                    loop.breakLoop();
                else {
                    setTimeout(function () {
                        for (var i = 0; i < syncedIterations; ++i) {
                            var iteration = (loop.index * syncedIterations) + i;
                            if (iteration >= iterations)
                                break;
                            fn(iteration);
                            if (breakFunction && breakFunction()) {
                                loop.breakLoop();
                                break;
                            }
                        }
                        loop.executeNext();
                    }, timeout);
                }
            }, callback);
        };
        return AsyncLoop;
    }());
    BABYLON.AsyncLoop = AsyncLoop;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.tools.js.map

var BABYLON;
(function (BABYLON) {
    var PromiseStates;
    (function (PromiseStates) {
        PromiseStates[PromiseStates["Pending"] = 0] = "Pending";
        PromiseStates[PromiseStates["Fulfilled"] = 1] = "Fulfilled";
        PromiseStates[PromiseStates["Rejected"] = 2] = "Rejected";
    })(PromiseStates || (PromiseStates = {}));
    var FulFillmentAgregator = /** @class */ (function () {
        function FulFillmentAgregator() {
            this.count = 0;
            this.target = 0;
            this.results = [];
        }
        return FulFillmentAgregator;
    }());
    var InternalPromise = /** @class */ (function () {
        function InternalPromise(resolver) {
            var _this = this;
            this._state = PromiseStates.Pending;
            this._children = new Array();
            this._rejectWasConsumed = false;
            if (!resolver) {
                return;
            }
            try {
                resolver(function (value) {
                    _this._resolve(value);
                }, function (reason) {
                    _this._reject(reason);
                });
            }
            catch (e) {
                this._reject(e);
            }
        }
        Object.defineProperty(InternalPromise.prototype, "_result", {
            get: function () {
                return this._resultValue;
            },
            set: function (value) {
                this._resultValue = value;
                if (this._parent && this._parent._result === undefined) {
                    this._parent._result = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        InternalPromise.prototype.catch = function (onRejected) {
            return this.then(undefined, onRejected);
        };
        InternalPromise.prototype.then = function (onFulfilled, onRejected) {
            var _this = this;
            var newPromise = new InternalPromise();
            newPromise._onFulfilled = onFulfilled;
            newPromise._onRejected = onRejected;
            // Composition
            this._children.push(newPromise);
            newPromise._parent = this;
            if (this._state !== PromiseStates.Pending) {
                BABYLON.Tools.SetImmediate(function () {
                    if (_this._state === PromiseStates.Fulfilled || _this._rejectWasConsumed) {
                        var returnedValue = newPromise._resolve(_this._result);
                        if (returnedValue !== undefined && returnedValue !== null) {
                            if (returnedValue._state !== undefined) {
                                var returnedPromise = returnedValue;
                                newPromise._children.push(returnedPromise);
                                returnedPromise._parent = newPromise;
                                newPromise = returnedPromise;
                            }
                            else {
                                newPromise._result = returnedValue;
                            }
                        }
                    }
                    else {
                        newPromise._reject(_this._reason);
                    }
                });
            }
            return newPromise;
        };
        InternalPromise.prototype._moveChildren = function (children) {
            var _this = this;
            (_a = this._children).push.apply(_a, children.splice(0, children.length));
            this._children.forEach(function (child) {
                child._parent = _this;
            });
            if (this._state === PromiseStates.Fulfilled) {
                for (var _i = 0, _b = this._children; _i < _b.length; _i++) {
                    var child = _b[_i];
                    child._resolve(this._result);
                }
            }
            else if (this._state === PromiseStates.Rejected) {
                for (var _c = 0, _d = this._children; _c < _d.length; _c++) {
                    var child = _d[_c];
                    child._reject(this._reason);
                }
            }
            var _a;
        };
        InternalPromise.prototype._resolve = function (value) {
            try {
                this._state = PromiseStates.Fulfilled;
                var returnedValue = null;
                if (this._onFulfilled) {
                    returnedValue = this._onFulfilled(value);
                }
                if (returnedValue !== undefined && returnedValue !== null) {
                    if (returnedValue._state !== undefined) {
                        // Transmit children
                        var returnedPromise = returnedValue;
                        returnedPromise._parent = this;
                        returnedPromise._moveChildren(this._children);
                        value = returnedPromise._result;
                    }
                    else {
                        value = returnedValue;
                    }
                }
                this._result = value;
                for (var _i = 0, _a = this._children; _i < _a.length; _i++) {
                    var child = _a[_i];
                    child._resolve(value);
                }
                this._children.length = 0;
                delete this._onFulfilled;
                delete this._onRejected;
            }
            catch (e) {
                this._reject(e, true);
            }
        };
        InternalPromise.prototype._reject = function (reason, onLocalThrow) {
            if (onLocalThrow === void 0) { onLocalThrow = false; }
            this._state = PromiseStates.Rejected;
            this._reason = reason;
            if (this._onRejected && !onLocalThrow) {
                try {
                    this._onRejected(reason);
                    this._rejectWasConsumed = true;
                }
                catch (e) {
                    reason = e;
                }
            }
            for (var _i = 0, _a = this._children; _i < _a.length; _i++) {
                var child = _a[_i];
                if (this._rejectWasConsumed) {
                    child._resolve(null);
                }
                else {
                    child._reject(reason);
                }
            }
            this._children.length = 0;
            delete this._onFulfilled;
            delete this._onRejected;
        };
        InternalPromise.resolve = function (value) {
            var newPromise = new InternalPromise();
            newPromise._resolve(value);
            return newPromise;
        };
        InternalPromise._RegisterForFulfillment = function (promise, agregator, index) {
            promise.then(function (value) {
                agregator.results[index] = value;
                agregator.count++;
                if (agregator.count === agregator.target) {
                    agregator.rootPromise._resolve(agregator.results);
                }
                return null;
            }, function (reason) {
                if (agregator.rootPromise._state !== PromiseStates.Rejected) {
                    agregator.rootPromise._reject(reason);
                }
            });
        };
        InternalPromise.all = function (promises) {
            var newPromise = new InternalPromise();
            var agregator = new FulFillmentAgregator();
            agregator.target = promises.length;
            agregator.rootPromise = newPromise;
            if (promises.length) {
                for (var index = 0; index < promises.length; index++) {
                    InternalPromise._RegisterForFulfillment(promises[index], agregator, index);
                }
            }
            else {
                newPromise._resolve([]);
            }
            return newPromise;
        };
        InternalPromise.race = function (promises) {
            var newPromise = new InternalPromise();
            if (promises.length) {
                for (var _i = 0, promises_1 = promises; _i < promises_1.length; _i++) {
                    var promise = promises_1[_i];
                    promise.then(function (value) {
                        if (newPromise) {
                            newPromise._resolve(value);
                            newPromise = null;
                        }
                        return null;
                    }, function (reason) {
                        if (newPromise) {
                            newPromise._reject(reason);
                            newPromise = null;
                        }
                    });
                }
            }
            return newPromise;
        };
        return InternalPromise;
    }());
    /**
     * Helper class that provides a small promise polyfill
     */
    var PromisePolyfill = /** @class */ (function () {
        function PromisePolyfill() {
        }
        /**
         * Static function used to check if the polyfill is required
         * If this is the case then the function will inject the polyfill to window.Promise
         * @param force defines a boolean used to force the injection (mostly for testing purposes)
         */
        PromisePolyfill.Apply = function (force) {
            if (force === void 0) { force = false; }
            if (force || typeof Promise === 'undefined') {
                var root = window;
                root.Promise = InternalPromise;
            }
        };
        return PromisePolyfill;
    }());
    BABYLON.PromisePolyfill = PromisePolyfill;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.promise.js.map

/// <reference path="../../../dist/preview release/babylon.d.ts" />
var BABYLON;
(function (BABYLON) {
    /**
     * Helper class to push actions to a pool of workers.
     */
    var WorkerPool = /** @class */ (function () {
        /**
         * Constructor
         * @param workers Array of workers to use for actions
         */
        function WorkerPool(workers) {
            this._pendingActions = new Array();
            this._workerInfos = workers.map(function (worker) { return ({
                worker: worker,
                active: false
            }); });
        }
        /**
         * Terminates all workers and clears any pending actions.
         */
        WorkerPool.prototype.dispose = function () {
            for (var _i = 0, _a = this._workerInfos; _i < _a.length; _i++) {
                var workerInfo = _a[_i];
                workerInfo.worker.terminate();
            }
            delete this._workerInfos;
            delete this._pendingActions;
        };
        /**
         * Pushes an action to the worker pool. If all the workers are active, the action will be
         * pended until a worker has completed its action.
         * @param action The action to perform. Call onComplete when the action is complete.
         */
        WorkerPool.prototype.push = function (action) {
            for (var _i = 0, _a = this._workerInfos; _i < _a.length; _i++) {
                var workerInfo = _a[_i];
                if (!workerInfo.active) {
                    this._execute(workerInfo, action);
                    return;
                }
            }
            this._pendingActions.push(action);
        };
        WorkerPool.prototype._execute = function (workerInfo, action) {
            var _this = this;
            workerInfo.active = true;
            action(workerInfo.worker, function () {
                workerInfo.active = false;
                var nextAction = _this._pendingActions.shift();
                if (nextAction) {
                    _this._execute(workerInfo, nextAction);
                }
            });
        };
        return WorkerPool;
    }());
    BABYLON.WorkerPool = WorkerPool;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.workerPool.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * @hidden
     **/
    var _AlphaState = /** @class */ (function () {
        /**
         * Initializes the state.
         */
        function _AlphaState() {
            this._isAlphaBlendDirty = false;
            this._isBlendFunctionParametersDirty = false;
            this._isBlendEquationParametersDirty = false;
            this._isBlendConstantsDirty = false;
            this._alphaBlend = false;
            this._blendFunctionParameters = new Array(4);
            this._blendEquationParameters = new Array(2);
            this._blendConstants = new Array(4);
            this.reset();
        }
        Object.defineProperty(_AlphaState.prototype, "isDirty", {
            get: function () {
                return this._isAlphaBlendDirty || this._isBlendFunctionParametersDirty;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_AlphaState.prototype, "alphaBlend", {
            get: function () {
                return this._alphaBlend;
            },
            set: function (value) {
                if (this._alphaBlend === value) {
                    return;
                }
                this._alphaBlend = value;
                this._isAlphaBlendDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        _AlphaState.prototype.setAlphaBlendConstants = function (r, g, b, a) {
            if (this._blendConstants[0] === r &&
                this._blendConstants[1] === g &&
                this._blendConstants[2] === b &&
                this._blendConstants[3] === a) {
                return;
            }
            this._blendConstants[0] = r;
            this._blendConstants[1] = g;
            this._blendConstants[2] = b;
            this._blendConstants[3] = a;
            this._isBlendConstantsDirty = true;
        };
        _AlphaState.prototype.setAlphaBlendFunctionParameters = function (value0, value1, value2, value3) {
            if (this._blendFunctionParameters[0] === value0 &&
                this._blendFunctionParameters[1] === value1 &&
                this._blendFunctionParameters[2] === value2 &&
                this._blendFunctionParameters[3] === value3) {
                return;
            }
            this._blendFunctionParameters[0] = value0;
            this._blendFunctionParameters[1] = value1;
            this._blendFunctionParameters[2] = value2;
            this._blendFunctionParameters[3] = value3;
            this._isBlendFunctionParametersDirty = true;
        };
        _AlphaState.prototype.setAlphaEquationParameters = function (rgb, alpha) {
            if (this._blendEquationParameters[0] === rgb &&
                this._blendEquationParameters[1] === alpha) {
                return;
            }
            this._blendEquationParameters[0] = rgb;
            this._blendEquationParameters[1] = alpha;
            this._isBlendEquationParametersDirty = true;
        };
        _AlphaState.prototype.reset = function () {
            this._alphaBlend = false;
            this._blendFunctionParameters[0] = null;
            this._blendFunctionParameters[1] = null;
            this._blendFunctionParameters[2] = null;
            this._blendFunctionParameters[3] = null;
            this._blendEquationParameters[0] = null;
            this._blendEquationParameters[1] = null;
            this._blendConstants[0] = null;
            this._blendConstants[1] = null;
            this._blendConstants[2] = null;
            this._blendConstants[3] = null;
            this._isAlphaBlendDirty = true;
            this._isBlendFunctionParametersDirty = false;
            this._isBlendEquationParametersDirty = false;
            this._isBlendConstantsDirty = false;
        };
        _AlphaState.prototype.apply = function (gl) {
            if (!this.isDirty) {
                return;
            }
            // Alpha blend
            if (this._isAlphaBlendDirty) {
                if (this._alphaBlend) {
                    gl.enable(gl.BLEND);
                }
                else {
                    gl.disable(gl.BLEND);
                }
                this._isAlphaBlendDirty = false;
            }
            // Alpha function
            if (this._isBlendFunctionParametersDirty) {
                gl.blendFuncSeparate(this._blendFunctionParameters[0], this._blendFunctionParameters[1], this._blendFunctionParameters[2], this._blendFunctionParameters[3]);
                this._isBlendFunctionParametersDirty = false;
            }
            // Alpha equation
            if (this._isBlendEquationParametersDirty) {
                gl.blendEquationSeparate(this._isBlendEquationParametersDirty[0], this._isBlendEquationParametersDirty[1]);
                this._isBlendEquationParametersDirty = false;
            }
            // Constants
            if (this._isBlendConstantsDirty) {
                gl.blendColor(this._blendConstants[0], this._blendConstants[1], this._blendConstants[2], this._blendConstants[3]);
                this._isBlendConstantsDirty = false;
            }
        };
        return _AlphaState;
    }());
    BABYLON._AlphaState = _AlphaState;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.alphaCullingState.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * @hidden
     **/
    var _DepthCullingState = /** @class */ (function () {
        /**
         * Initializes the state.
         */
        function _DepthCullingState() {
            this._isDepthTestDirty = false;
            this._isDepthMaskDirty = false;
            this._isDepthFuncDirty = false;
            this._isCullFaceDirty = false;
            this._isCullDirty = false;
            this._isZOffsetDirty = false;
            this._isFrontFaceDirty = false;
            this.reset();
        }
        Object.defineProperty(_DepthCullingState.prototype, "isDirty", {
            get: function () {
                return this._isDepthFuncDirty || this._isDepthTestDirty || this._isDepthMaskDirty || this._isCullFaceDirty || this._isCullDirty || this._isZOffsetDirty || this._isFrontFaceDirty;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "zOffset", {
            get: function () {
                return this._zOffset;
            },
            set: function (value) {
                if (this._zOffset === value) {
                    return;
                }
                this._zOffset = value;
                this._isZOffsetDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "cullFace", {
            get: function () {
                return this._cullFace;
            },
            set: function (value) {
                if (this._cullFace === value) {
                    return;
                }
                this._cullFace = value;
                this._isCullFaceDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "cull", {
            get: function () {
                return this._cull;
            },
            set: function (value) {
                if (this._cull === value) {
                    return;
                }
                this._cull = value;
                this._isCullDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "depthFunc", {
            get: function () {
                return this._depthFunc;
            },
            set: function (value) {
                if (this._depthFunc === value) {
                    return;
                }
                this._depthFunc = value;
                this._isDepthFuncDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "depthMask", {
            get: function () {
                return this._depthMask;
            },
            set: function (value) {
                if (this._depthMask === value) {
                    return;
                }
                this._depthMask = value;
                this._isDepthMaskDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "depthTest", {
            get: function () {
                return this._depthTest;
            },
            set: function (value) {
                if (this._depthTest === value) {
                    return;
                }
                this._depthTest = value;
                this._isDepthTestDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_DepthCullingState.prototype, "frontFace", {
            get: function () {
                return this._frontFace;
            },
            set: function (value) {
                if (this._frontFace === value) {
                    return;
                }
                this._frontFace = value;
                this._isFrontFaceDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        _DepthCullingState.prototype.reset = function () {
            this._depthMask = true;
            this._depthTest = true;
            this._depthFunc = null;
            this._cullFace = null;
            this._cull = null;
            this._zOffset = 0;
            this._frontFace = null;
            this._isDepthTestDirty = true;
            this._isDepthMaskDirty = true;
            this._isDepthFuncDirty = false;
            this._isCullFaceDirty = false;
            this._isCullDirty = false;
            this._isZOffsetDirty = false;
            this._isFrontFaceDirty = false;
        };
        _DepthCullingState.prototype.apply = function (gl) {
            if (!this.isDirty) {
                return;
            }
            // Cull
            if (this._isCullDirty) {
                if (this.cull) {
                    gl.enable(gl.CULL_FACE);
                }
                else {
                    gl.disable(gl.CULL_FACE);
                }
                this._isCullDirty = false;
            }
            // Cull face
            if (this._isCullFaceDirty) {
                gl.cullFace(this.cullFace);
                this._isCullFaceDirty = false;
            }
            // Depth mask
            if (this._isDepthMaskDirty) {
                gl.depthMask(this.depthMask);
                this._isDepthMaskDirty = false;
            }
            // Depth test
            if (this._isDepthTestDirty) {
                if (this.depthTest) {
                    gl.enable(gl.DEPTH_TEST);
                }
                else {
                    gl.disable(gl.DEPTH_TEST);
                }
                this._isDepthTestDirty = false;
            }
            // Depth func
            if (this._isDepthFuncDirty) {
                gl.depthFunc(this.depthFunc);
                this._isDepthFuncDirty = false;
            }
            // zOffset
            if (this._isZOffsetDirty) {
                if (this.zOffset) {
                    gl.enable(gl.POLYGON_OFFSET_FILL);
                    gl.polygonOffset(this.zOffset, 0);
                }
                else {
                    gl.disable(gl.POLYGON_OFFSET_FILL);
                }
                this._isZOffsetDirty = false;
            }
            // Front face
            if (this._isFrontFaceDirty) {
                gl.frontFace(this.frontFace);
                this._isFrontFaceDirty = false;
            }
        };
        return _DepthCullingState;
    }());
    BABYLON._DepthCullingState = _DepthCullingState;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.depthCullingState.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * @hidden
     **/
    var _StencilState = /** @class */ (function () {
        function _StencilState() {
            this._isStencilTestDirty = false;
            this._isStencilMaskDirty = false;
            this._isStencilFuncDirty = false;
            this._isStencilOpDirty = false;
            this.reset();
        }
        Object.defineProperty(_StencilState.prototype, "isDirty", {
            get: function () {
                return this._isStencilTestDirty || this._isStencilMaskDirty || this._isStencilFuncDirty || this._isStencilOpDirty;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilFunc", {
            get: function () {
                return this._stencilFunc;
            },
            set: function (value) {
                if (this._stencilFunc === value) {
                    return;
                }
                this._stencilFunc = value;
                this._isStencilFuncDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilFuncRef", {
            get: function () {
                return this._stencilFuncRef;
            },
            set: function (value) {
                if (this._stencilFuncRef === value) {
                    return;
                }
                this._stencilFuncRef = value;
                this._isStencilFuncDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilFuncMask", {
            get: function () {
                return this._stencilFuncMask;
            },
            set: function (value) {
                if (this._stencilFuncMask === value) {
                    return;
                }
                this._stencilFuncMask = value;
                this._isStencilFuncDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilOpStencilFail", {
            get: function () {
                return this._stencilOpStencilFail;
            },
            set: function (value) {
                if (this._stencilOpStencilFail === value) {
                    return;
                }
                this._stencilOpStencilFail = value;
                this._isStencilOpDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilOpDepthFail", {
            get: function () {
                return this._stencilOpDepthFail;
            },
            set: function (value) {
                if (this._stencilOpDepthFail === value) {
                    return;
                }
                this._stencilOpDepthFail = value;
                this._isStencilOpDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilOpStencilDepthPass", {
            get: function () {
                return this._stencilOpStencilDepthPass;
            },
            set: function (value) {
                if (this._stencilOpStencilDepthPass === value) {
                    return;
                }
                this._stencilOpStencilDepthPass = value;
                this._isStencilOpDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilMask", {
            get: function () {
                return this._stencilMask;
            },
            set: function (value) {
                if (this._stencilMask === value) {
                    return;
                }
                this._stencilMask = value;
                this._isStencilMaskDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(_StencilState.prototype, "stencilTest", {
            get: function () {
                return this._stencilTest;
            },
            set: function (value) {
                if (this._stencilTest === value) {
                    return;
                }
                this._stencilTest = value;
                this._isStencilTestDirty = true;
            },
            enumerable: true,
            configurable: true
        });
        _StencilState.prototype.reset = function () {
            this._stencilTest = false;
            this._stencilMask = 0xFF;
            this._stencilFunc = BABYLON.Engine.ALWAYS;
            this._stencilFuncRef = 1;
            this._stencilFuncMask = 0xFF;
            this._stencilOpStencilFail = BABYLON.Engine.KEEP;
            this._stencilOpDepthFail = BABYLON.Engine.KEEP;
            this._stencilOpStencilDepthPass = BABYLON.Engine.REPLACE;
            this._isStencilTestDirty = true;
            this._isStencilMaskDirty = true;
            this._isStencilFuncDirty = true;
            this._isStencilOpDirty = true;
        };
        _StencilState.prototype.apply = function (gl) {
            if (!this.isDirty) {
                return;
            }
            // Stencil test
            if (this._isStencilTestDirty) {
                if (this.stencilTest) {
                    gl.enable(gl.STENCIL_TEST);
                }
                else {
                    gl.disable(gl.STENCIL_TEST);
                }
                this._isStencilTestDirty = false;
            }
            // Stencil mask
            if (this._isStencilMaskDirty) {
                gl.stencilMask(this.stencilMask);
                this._isStencilMaskDirty = false;
            }
            // Stencil func
            if (this._isStencilFuncDirty) {
                gl.stencilFunc(this.stencilFunc, this.stencilFuncRef, this.stencilFuncMask);
                this._isStencilFuncDirty = false;
            }
            // Stencil op
            if (this._isStencilOpDirty) {
                gl.stencilOp(this.stencilOpStencilFail, this.stencilOpDepthFail, this.stencilOpStencilDepthPass);
                this._isStencilOpDirty = false;
            }
        };
        return _StencilState;
    }());
    BABYLON._StencilState = _StencilState;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.stencilState.js.map

var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var BABYLON;
(function (BABYLON) {
    var compileShader = function (gl, source, type, defines, shaderVersion) {
        return compileRawShader(gl, shaderVersion + (defines ? defines + "\n" : "") + source, type);
    };
    var compileRawShader = function (gl, source, type) {
        var shader = gl.createShader(type === "vertex" ? gl.VERTEX_SHADER : gl.FRAGMENT_SHADER);
        gl.shaderSource(shader, source);
        gl.compileShader(shader);
        if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
            var log = gl.getShaderInfoLog(shader);
            if (log) {
                throw new Error(log);
            }
        }
        if (!shader) {
            throw new Error("Something went wrong while compile the shader.");
        }
        return shader;
    };
    var getSamplingParameters = function (samplingMode, generateMipMaps, gl) {
        var magFilter = gl.NEAREST;
        var minFilter = gl.NEAREST;
        switch (samplingMode) {
            case BABYLON.Texture.BILINEAR_SAMPLINGMODE:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.TRILINEAR_SAMPLINGMODE:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_SAMPLINGMODE:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.NEAREST_NEAREST_MIPNEAREST:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR_MIPNEAREST:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR_MIPLINEAR:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR:
                magFilter = gl.NEAREST;
                minFilter = gl.LINEAR;
                break;
            case BABYLON.Texture.NEAREST_NEAREST:
                magFilter = gl.NEAREST;
                minFilter = gl.NEAREST;
                break;
            case BABYLON.Texture.LINEAR_NEAREST_MIPNEAREST:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.LINEAR_NEAREST_MIPLINEAR:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.LINEAR_LINEAR:
                magFilter = gl.LINEAR;
                minFilter = gl.LINEAR;
                break;
            case BABYLON.Texture.LINEAR_NEAREST:
                magFilter = gl.LINEAR;
                minFilter = gl.NEAREST;
                break;
        }
        return {
            min: minFilter,
            mag: magFilter
        };
    };
    var partialLoadImg = function (url, index, loadedImages, scene, onfinish, onErrorCallBack) {
        if (onErrorCallBack === void 0) { onErrorCallBack = null; }
        var img;
        var onload = function () {
            loadedImages[index] = img;
            loadedImages._internalCount++;
            if (scene) {
                scene._removePendingData(img);
            }
            if (loadedImages._internalCount === 6) {
                onfinish(loadedImages);
            }
        };
        var onerror = function (message, exception) {
            if (scene) {
                scene._removePendingData(img);
            }
            if (onErrorCallBack) {
                onErrorCallBack(message, exception);
            }
        };
        img = BABYLON.Tools.LoadImage(url, onload, onerror, scene ? scene.database : null);
        if (scene) {
            scene._addPendingData(img);
        }
    };
    var cascadeLoadImgs = function (rootUrl, scene, onfinish, files, onError) {
        if (onError === void 0) { onError = null; }
        var loadedImages = [];
        loadedImages._internalCount = 0;
        for (var index = 0; index < 6; index++) {
            partialLoadImg(files[index], index, loadedImages, scene, onfinish, onError);
        }
    };
    var BufferPointer = /** @class */ (function () {
        function BufferPointer() {
        }
        return BufferPointer;
    }());
    /**
     * Interface for attribute information associated with buffer instanciation
     */
    var InstancingAttributeInfo = /** @class */ (function () {
        function InstancingAttributeInfo() {
        }
        return InstancingAttributeInfo;
    }());
    BABYLON.InstancingAttributeInfo = InstancingAttributeInfo;
    /**
     * Define options used to create a render target texture
     */
    var RenderTargetCreationOptions = /** @class */ (function () {
        function RenderTargetCreationOptions() {
        }
        return RenderTargetCreationOptions;
    }());
    BABYLON.RenderTargetCreationOptions = RenderTargetCreationOptions;
    /**
     * Define options used to create a depth texture
     */
    var DepthTextureCreationOptions = /** @class */ (function () {
        function DepthTextureCreationOptions() {
        }
        return DepthTextureCreationOptions;
    }());
    BABYLON.DepthTextureCreationOptions = DepthTextureCreationOptions;
    /**
     * Class used to describe the capabilities of the engine relatively to the current browser
     */
    var EngineCapabilities = /** @class */ (function () {
        function EngineCapabilities() {
        }
        return EngineCapabilities;
    }());
    BABYLON.EngineCapabilities = EngineCapabilities;
    /**
     * The engine class is responsible for interfacing with all lower-level APIs such as WebGL and Audio
     */
    var Engine = /** @class */ (function () {
        /**
         * Creates a new engine
         * @param canvasOrContext defines the canvas or WebGL context to use for rendering
         * @param antialias defines enable antialiasing (default: false)
         * @param options defines further options to be sent to the getContext() function
         * @param adaptToDeviceRatio defines whether to adapt to the device's viewport characteristics (default: false)
         */
        function Engine(canvasOrContext, antialias, options, adaptToDeviceRatio) {
            if (adaptToDeviceRatio === void 0) { adaptToDeviceRatio = false; }
            var _this = this;
            // Public members
            /**
             * Gets or sets a boolean that indicates if textures must be forced to power of 2 size even if not required
             */
            this.forcePOTTextures = false;
            /**
             * Gets a boolean indicating if the engine is currently rendering in fullscreen mode
             */
            this.isFullscreen = false;
            /**
             * Gets a boolean indicating if the pointer is currently locked
             */
            this.isPointerLock = false;
            /**
             * Gets or sets a boolean indicating if back faces must be culled (true by default)
             */
            this.cullBackFaces = true;
            /**
             * Gets or sets a boolean indicating if the engine must keep rendering even if the window is not in foregroun
             */
            this.renderEvenInBackground = true;
            /**
             * Gets or sets a boolean indicating that cache can be kept between frames
             */
            this.preventCacheWipeBetweenFrames = false;
            /**
             * Gets or sets a boolean to enable/disable IndexedDB support and avoid XHR on .manifest
             **/
            this.enableOfflineSupport = false;
            /**
             * Gets or sets a boolean to enable/disable checking manifest if IndexedDB support is enabled (Babylon.js will always consider the database is up to date)
             **/
            this.disableManifestCheck = false;
            /**
             * Gets the list of created scenes
             */
            this.scenes = new Array();
            /**
             * Gets the list of created postprocesses
             */
            this.postProcesses = new Array();
            // Observables
            /**
             * Observable event triggered each time the rendering canvas is resized
             */
            this.onResizeObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas loses focus
             */
            this.onCanvasBlurObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas gains focus
             */
            this.onCanvasFocusObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas receives pointerout event
             */
            this.onCanvasPointerOutObservable = new BABYLON.Observable();
            /**
             * Observable event triggered before each texture is initialized
             */
            this.onBeforeTextureInitObservable = new BABYLON.Observable();
            //WebVR
            this._vrDisplay = undefined;
            this._vrSupported = false;
            this._vrExclusivePointerMode = false;
            // Uniform buffers list
            /**
             * Gets or sets a boolean indicating that uniform buffers must be disabled even if they are supported
             */
            this.disableUniformBuffers = false;
            /** @hidden */
            this._uniformBuffers = new Array();
            // Observables
            /**
             * Observable raised when the engine begins a new frame
             */
            this.onBeginFrameObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine ends the current frame
             */
            this.onEndFrameObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine is about to compile a shader
             */
            this.onBeforeShaderCompilationObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine has jsut compiled a shader
             */
            this.onAfterShaderCompilationObservable = new BABYLON.Observable();
            this._windowIsBackground = false;
            this._webGLVersion = 1.0;
            /** @hidden */
            this._badOS = false;
            /** @hidden */
            this._badDesktopOS = false;
            /**
             * Gets or sets a value indicating if we want to disable texture binding optmization.
             * This could be required on some buggy drivers which wants to have textures bound in a progressive order.
             * By default Babylon.js will try to let textures bound where they are and only update the samplers to point where the texture is
             */
            this.disableTextureBindingOptimization = false;
            /**
             * Observable signaled when VR display mode changes
             */
            this.onVRDisplayChangedObservable = new BABYLON.Observable();
            /**
             * Observable signaled when VR request present is complete
             */
            this.onVRRequestPresentComplete = new BABYLON.Observable();
            /**
             * Observable signaled when VR request present starts
             */
            this.onVRRequestPresentStart = new BABYLON.Observable();
            this._colorWrite = true;
            /** @hidden */
            this._drawCalls = new BABYLON.PerfCounter();
            /** @hidden */
            this._textureCollisions = new BABYLON.PerfCounter();
            this._renderingQueueLaunched = false;
            this._activeRenderLoops = new Array();
            // Deterministic lockstepMaxSteps
            this._deterministicLockstep = false;
            this._lockstepMaxSteps = 4;
            // Lost context
            /**
             * Observable signaled when a context lost event is raised
             */
            this.onContextLostObservable = new BABYLON.Observable();
            /**
             * Observable signaled when a context restored event is raised
             */
            this.onContextRestoredObservable = new BABYLON.Observable();
            this._contextWasLost = false;
            this._doNotHandleContextLost = false;
            // FPS
            this._performanceMonitor = new BABYLON.PerformanceMonitor();
            this._fps = 60;
            this._deltaTime = 0;
            /**
             * Turn this value on if you want to pause FPS computation when in background
             */
            this.disablePerformanceMonitorInBackground = false;
            // States
            /** @hidden */
            this._depthCullingState = new BABYLON._DepthCullingState();
            /** @hidden */
            this._stencilState = new BABYLON._StencilState();
            /** @hidden */
            this._alphaState = new BABYLON._AlphaState();
            /** @hidden */
            this._alphaMode = Engine.ALPHA_DISABLE;
            // Cache
            this._internalTexturesCache = new Array();
            /** @hidden */
            this._activeChannel = 0;
            this._currentTextureChannel = -1;
            /** @hidden */
            this._boundTexturesCache = {};
            this._compiledEffects = {};
            this._vertexAttribArraysEnabled = [];
            this._uintIndicesCurrentlySet = false;
            this._currentBoundBuffer = new Array();
            this._currentBufferPointers = new Array();
            this._currentInstanceLocations = new Array();
            this._currentInstanceBuffers = new Array();
            this._firstBoundInternalTextureTracker = new BABYLON.DummyInternalTextureTracker();
            this._lastBoundInternalTextureTracker = new BABYLON.DummyInternalTextureTracker();
            this._vaoRecordInProgress = false;
            this._mustWipeVertexAttributes = false;
            this._nextFreeTextureSlots = new Array();
            this._maxSimultaneousTextures = 0;
            this._activeRequests = new Array();
            // Hardware supported Compressed Textures
            this._texturesSupported = new Array();
            this._onVRFullScreenTriggered = function () {
                if (_this._vrDisplay && _this._vrDisplay.isPresenting) {
                    //get the old size before we change
                    _this._oldSize = new BABYLON.Size(_this.getRenderWidth(), _this.getRenderHeight());
                    _this._oldHardwareScaleFactor = _this.getHardwareScalingLevel();
                    //get the width and height, change the render size
                    var leftEye = _this._vrDisplay.getEyeParameters('left');
                    _this.setHardwareScalingLevel(1);
                    _this.setSize(leftEye.renderWidth * 2, leftEye.renderHeight);
                }
                else {
                    _this.setHardwareScalingLevel(_this._oldHardwareScaleFactor);
                    _this.setSize(_this._oldSize.width, _this._oldSize.height);
                }
            };
            this._boundUniforms = {};
            // Register promises
            BABYLON.PromisePolyfill.Apply();
            var canvas = null;
            Engine.Instances.push(this);
            if (!canvasOrContext) {
                return;
            }
            options = options || {};
            if (canvasOrContext.getContext) {
                canvas = canvasOrContext;
                this._renderingCanvas = canvas;
                if (antialias != null) {
                    options.antialias = antialias;
                }
                if (options.deterministicLockstep === undefined) {
                    options.deterministicLockstep = false;
                }
                if (options.lockstepMaxSteps === undefined) {
                    options.lockstepMaxSteps = 4;
                }
                if (options.preserveDrawingBuffer === undefined) {
                    options.preserveDrawingBuffer = false;
                }
                if (options.audioEngine === undefined) {
                    options.audioEngine = true;
                }
                if (options.stencil === undefined) {
                    options.stencil = true;
                }
                this._deterministicLockstep = options.deterministicLockstep;
                this._lockstepMaxSteps = options.lockstepMaxSteps;
                this._doNotHandleContextLost = options.doNotHandleContextLost ? true : false;
                // Exceptions
                if (navigator && navigator.userAgent) {
                    var ua = navigator.userAgent;
                    for (var _i = 0, _a = Engine.ExceptionList; _i < _a.length; _i++) {
                        var exception = _a[_i];
                        var key = exception.key;
                        var targets = exception.targets;
                        if (ua.indexOf(key) > -1) {
                            if (exception.capture && exception.captureConstraint) {
                                var capture = exception.capture;
                                var constraint = exception.captureConstraint;
                                var regex = new RegExp(capture);
                                var matches = regex.exec(ua);
                                if (matches && matches.length > 0) {
                                    var capturedValue = parseInt(matches[matches.length - 1]);
                                    if (capturedValue >= constraint) {
                                        continue;
                                    }
                                }
                            }
                            for (var _b = 0, targets_1 = targets; _b < targets_1.length; _b++) {
                                var target = targets_1[_b];
                                switch (target) {
                                    case "uniformBuffer":
                                        this.disableUniformBuffers = true;
                                        break;
                                    case "textureBindingOptimization":
                                        this.disableTextureBindingOptimization = true;
                                        break;
                                }
                            }
                        }
                    }
                }
                // GL
                if (!options.disableWebGL2Support) {
                    try {
                        this._gl = (canvas.getContext("webgl2", options) || canvas.getContext("experimental-webgl2", options));
                        if (this._gl) {
                            this._webGLVersion = 2.0;
                        }
                    }
                    catch (e) {
                        // Do nothing
                    }
                }
                if (!this._gl) {
                    if (!canvas) {
                        throw new Error("The provided canvas is null or undefined.");
                    }
                    try {
                        this._gl = (canvas.getContext("webgl", options) || canvas.getContext("experimental-webgl", options));
                    }
                    catch (e) {
                        throw new Error("WebGL not supported");
                    }
                }
                if (!this._gl) {
                    throw new Error("WebGL not supported");
                }
                this._onCanvasFocus = function () {
                    _this.onCanvasFocusObservable.notifyObservers(_this);
                };
                this._onCanvasBlur = function () {
                    _this.onCanvasBlurObservable.notifyObservers(_this);
                };
                canvas.addEventListener("focus", this._onCanvasFocus);
                canvas.addEventListener("blur", this._onCanvasBlur);
                this._onBlur = function () {
                    if (_this.disablePerformanceMonitorInBackground) {
                        _this._performanceMonitor.disable();
                    }
                    _this._windowIsBackground = true;
                };
                this._onFocus = function () {
                    if (_this.disablePerformanceMonitorInBackground) {
                        _this._performanceMonitor.enable();
                    }
                    _this._windowIsBackground = false;
                };
                this._onCanvasPointerOut = function (ev) {
                    _this.onCanvasPointerOutObservable.notifyObservers(ev);
                };
                window.addEventListener("blur", this._onBlur);
                window.addEventListener("focus", this._onFocus);
                canvas.addEventListener("pointerout", this._onCanvasPointerOut);
                // Context lost
                if (!this._doNotHandleContextLost) {
                    this._onContextLost = function (evt) {
                        evt.preventDefault();
                        _this._contextWasLost = true;
                        BABYLON.Tools.Warn("WebGL context lost.");
                        _this.onContextLostObservable.notifyObservers(_this);
                    };
                    this._onContextRestored = function (evt) {
                        // Adding a timeout to avoid race condition at browser level
                        setTimeout(function () {
                            // Rebuild gl context
                            _this._initGLContext();
                            // Rebuild effects
                            _this._rebuildEffects();
                            // Rebuild textures
                            _this._rebuildInternalTextures();
                            // Rebuild buffers
                            _this._rebuildBuffers();
                            // Cache
                            _this.wipeCaches(true);
                            BABYLON.Tools.Warn("WebGL context successfully restored.");
                            _this.onContextRestoredObservable.notifyObservers(_this);
                            _this._contextWasLost = false;
                        }, 0);
                    };
                    canvas.addEventListener("webglcontextlost", this._onContextLost, false);
                    canvas.addEventListener("webglcontextrestored", this._onContextRestored, false);
                }
            }
            else {
                this._gl = canvasOrContext;
                this._renderingCanvas = this._gl.canvas;
                if (this._gl.renderbufferStorageMultisample) {
                    this._webGLVersion = 2.0;
                }
                options.stencil = this._gl.getContextAttributes().stencil;
            }
            // Viewport
            var limitDeviceRatio = options.limitDeviceRatio || window.devicePixelRatio || 1.0;
            this._hardwareScalingLevel = adaptToDeviceRatio ? 1.0 / Math.min(limitDeviceRatio, window.devicePixelRatio || 1.0) : 1.0;
            this.resize();
            this._isStencilEnable = options.stencil ? true : false;
            this._initGLContext();
            if (canvas) {
                // Fullscreen
                this._onFullscreenChange = function () {
                    if (document.fullscreen !== undefined) {
                        _this.isFullscreen = document.fullscreen;
                    }
                    else if (document.mozFullScreen !== undefined) {
                        _this.isFullscreen = document.mozFullScreen;
                    }
                    else if (document.webkitIsFullScreen !== undefined) {
                        _this.isFullscreen = document.webkitIsFullScreen;
                    }
                    else if (document.msIsFullScreen !== undefined) {
                        _this.isFullscreen = document.msIsFullScreen;
                    }
                    // Pointer lock
                    if (_this.isFullscreen && _this._pointerLockRequested && canvas) {
                        canvas.requestPointerLock = canvas.requestPointerLock ||
                            canvas.msRequestPointerLock ||
                            canvas.mozRequestPointerLock ||
                            canvas.webkitRequestPointerLock;
                        if (canvas.requestPointerLock) {
                            canvas.requestPointerLock();
                        }
                    }
                };
                document.addEventListener("fullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("mozfullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("webkitfullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("msfullscreenchange", this._onFullscreenChange, false);
                // Pointer lock
                this._onPointerLockChange = function () {
                    _this.isPointerLock = (document.mozPointerLockElement === canvas ||
                        document.webkitPointerLockElement === canvas ||
                        document.msPointerLockElement === canvas ||
                        document.pointerLockElement === canvas);
                };
                document.addEventListener("pointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("mspointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("mozpointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("webkitpointerlockchange", this._onPointerLockChange, false);
                this._onVRDisplayPointerRestricted = function () {
                    if (canvas) {
                        canvas.requestPointerLock();
                    }
                };
                this._onVRDisplayPointerUnrestricted = function () {
                    document.exitPointerLock();
                };
                window.addEventListener('vrdisplaypointerrestricted', this._onVRDisplayPointerRestricted, false);
                window.addEventListener('vrdisplaypointerunrestricted', this._onVRDisplayPointerUnrestricted, false);
            }
            if (options.audioEngine && BABYLON.AudioEngine && !Engine.audioEngine) {
                Engine.audioEngine = new BABYLON.AudioEngine();
            }
            // Prepare buffer pointers
            for (var i = 0; i < this._caps.maxVertexAttribs; i++) {
                this._currentBufferPointers[i] = new BufferPointer();
            }
            this._linkTrackers(this._firstBoundInternalTextureTracker, this._lastBoundInternalTextureTracker);
            // Load WebVR Devices
            if (options.autoEnableWebVR) {
                this.initWebVR();
            }
            // Detect if we are running on a faulty buggy OS.
            this._badOS = /iPad/i.test(navigator.userAgent) || /iPhone/i.test(navigator.userAgent);
            // Detect if we are running on a faulty buggy desktop OS.
            this._badDesktopOS = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
            console.log("Babylon.js engine (v" + Engine.Version + ") launched");
            this.enableOfflineSupport = (BABYLON.Database !== undefined);
        }
        Object.defineProperty(Engine, "LastCreatedEngine", {
            /**
             * Gets the latest created engine
             */
            get: function () {
                if (Engine.Instances.length === 0) {
                    return null;
                }
                return Engine.Instances[Engine.Instances.length - 1];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LastCreatedScene", {
            /**
             * Gets the latest created scene
             */
            get: function () {
                var lastCreatedEngine = Engine.LastCreatedEngine;
                if (!lastCreatedEngine) {
                    return null;
                }
                if (lastCreatedEngine.scenes.length === 0) {
                    return null;
                }
                return lastCreatedEngine.scenes[lastCreatedEngine.scenes.length - 1];
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Will flag all materials in all scenes in all engines as dirty to trigger new shader compilation
         * @param flag defines which part of the materials must be marked as dirty
         * @param predicate defines a predicate used to filter which materials should be affected
         */
        Engine.MarkAllMaterialsAsDirty = function (flag, predicate) {
            for (var engineIndex = 0; engineIndex < Engine.Instances.length; engineIndex++) {
                var engine = Engine.Instances[engineIndex];
                for (var sceneIndex = 0; sceneIndex < engine.scenes.length; sceneIndex++) {
                    engine.scenes[sceneIndex].markAllMaterialsAsDirty(flag, predicate);
                }
            }
        };
        Object.defineProperty(Engine, "NEVER", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will never pass. i.e. Nothing will be drawn */
            get: function () {
                return Engine._NEVER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALWAYS", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will always pass. i.e. Pixels will be drawn in the order they are drawn */
            get: function () {
                return Engine._ALWAYS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LESS", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than the stored value */
            get: function () {
                return Engine._LESS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "EQUAL", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is equals to the stored value */
            get: function () {
                return Engine._EQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LEQUAL", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than or equal to the stored value */
            get: function () {
                return Engine._LEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "GREATER", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than the stored value */
            get: function () {
                return Engine._GREATER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "GEQUAL", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than or equal to the stored value */
            get: function () {
                return Engine._GEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "NOTEQUAL", {
            /** Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is not equal to the stored value */
            get: function () {
                return Engine._NOTEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "KEEP", {
            /** Passed to stencilOperation to specify that stencil value must be kept */
            get: function () {
                return Engine._KEEP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "REPLACE", {
            /** Passed to stencilOperation to specify that stencil value must be replaced */
            get: function () {
                return Engine._REPLACE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INCR", {
            /** Passed to stencilOperation to specify that stencil value must be incremented */
            get: function () {
                return Engine._INCR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DECR", {
            /** Passed to stencilOperation to specify that stencil value must be decremented */
            get: function () {
                return Engine._DECR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INVERT", {
            /** Passed to stencilOperation to specify that stencil value must be inverted */
            get: function () {
                return Engine._INVERT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INCR_WRAP", {
            /** Passed to stencilOperation to specify that stencil value must be incremented with wrapping */
            get: function () {
                return Engine._INCR_WRAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DECR_WRAP", {
            /** Passed to stencilOperation to specify that stencil value must be decremented with wrapping */
            get: function () {
                return Engine._DECR_WRAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_DISABLE", {
            // Alpha
            /** Defines that alpha blending is disabled */
            get: function () {
                return Engine._ALPHA_DISABLE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_ONEONE", {
            /** Defines that alpha blending to SRC + DEST */
            get: function () {
                return Engine._ALPHA_ONEONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_ADD", {
            /** Defines that alpha blending to SRC ALPHA * SRC + DEST */
            get: function () {
                return Engine._ALPHA_ADD;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_COMBINE", {
            /** Defines that alpha blending to SRC ALPHA * SRC + (1 - SRC ALPHA) * DEST */
            get: function () {
                return Engine._ALPHA_COMBINE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_SUBTRACT", {
            /** Defines that alpha blending to DEST - SRC * DEST */
            get: function () {
                return Engine._ALPHA_SUBTRACT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_MULTIPLY", {
            /** Defines that alpha blending to SRC * DEST */
            get: function () {
                return Engine._ALPHA_MULTIPLY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_MAXIMIZED", {
            /** Defines that alpha blending to SRC ALPHA * SRC + (1 - SRC) * DEST */
            get: function () {
                return Engine._ALPHA_MAXIMIZED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_PREMULTIPLIED", {
            /** Defines that alpha blending to SRC + (1 - SRC ALPHA) * DEST */
            get: function () {
                return Engine._ALPHA_PREMULTIPLIED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_PREMULTIPLIED_PORTERDUFF", {
            /**
             * Defines that alpha blending to SRC + (1 - SRC ALPHA) * DEST
             * Alpha will be set to (1 - SRC ALPHA) * DEST ALPHA
             */
            get: function () {
                return Engine._ALPHA_PREMULTIPLIED_PORTERDUFF;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_INTERPOLATE", {
            /** Defines that alpha blending to CST * SRC + (1 - CST) * DEST */
            get: function () {
                return Engine._ALPHA_INTERPOLATE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_SCREENMODE", {
            /**
             * Defines that alpha blending to SRC + (1 - SRC) * DEST
             * Alpha will be set to SRC ALPHA + (1 - SRC ALPHA) * DEST ALPHA
             */
            get: function () {
                return Engine._ALPHA_SCREENMODE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_NONE", {
            // Delays
            /** Defines that the ressource is not delayed*/
            get: function () {
                return Engine._DELAYLOADSTATE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_LOADED", {
            /** Defines that the ressource was successfully delay loaded */
            get: function () {
                return Engine._DELAYLOADSTATE_LOADED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_LOADING", {
            /** Defines that the ressource is currently delay loading */
            get: function () {
                return Engine._DELAYLOADSTATE_LOADING;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_NOTLOADED", {
            /** Defines that the ressource is delayed and has not started loading */
            get: function () {
                return Engine._DELAYLOADSTATE_NOTLOADED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_ALPHA", {
            /** ALPHA */
            get: function () {
                return Engine._TEXTUREFORMAT_ALPHA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_LUMINANCE", {
            /** LUMINANCE */
            get: function () {
                return Engine._TEXTUREFORMAT_LUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_R32F", {
            /**
             * R32F
             */
            get: function () {
                return Engine._TEXTUREFORMAT_R32F;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RG32F", {
            /**
             * RG32F
             */
            get: function () {
                return Engine._TEXTUREFORMAT_RG32F;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGB32F", {
            /**
             * RGB32F
             */
            get: function () {
                return Engine._TEXTUREFORMAT_RGB32F;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGBA32F", {
            /**
             * RGBA32F
             */
            get: function () {
                return Engine._TEXTUREFORMAT_RGBA32F;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_LUMINANCE_ALPHA", {
            /** LUMINANCE_ALPHA */
            get: function () {
                return Engine._TEXTUREFORMAT_LUMINANCE_ALPHA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGB", {
            /** RGB */
            get: function () {
                return Engine._TEXTUREFORMAT_RGB;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGBA", {
            /** RGBA */
            get: function () {
                return Engine._TEXTUREFORMAT_RGBA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_UNSIGNED_INT", {
            /** UNSIGNED_INT */
            get: function () {
                return Engine._TEXTURETYPE_UNSIGNED_INT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_FLOAT", {
            /** FLOAT */
            get: function () {
                return Engine._TEXTURETYPE_FLOAT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_HALF_FLOAT", {
            /** HALF_FLOAT */
            get: function () {
                return Engine._TEXTURETYPE_HALF_FLOAT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_FLOOR", {
            /** Defines that texture rescaling will use a floor to find the closer power of 2 size */
            get: function () {
                return Engine._SCALEMODE_FLOOR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_NEAREST", {
            /** Defines that texture rescaling will look for the nearest power of 2 size */
            get: function () {
                return Engine._SCALEMODE_NEAREST;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_CEILING", {
            /** Defines that texture rescaling will use a ceil to find the closer power of 2 size */
            get: function () {
                return Engine._SCALEMODE_CEILING;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "Version", {
            /**
             * Returns the current version of the framework
             */
            get: function () {
                return "3.2.0";
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "isInVRExclusivePointerMode", {
            /**
             * Gets a boolean indicating that the engine is currently in VR exclusive mode for the pointers
             * @see https://docs.microsoft.com/en-us/microsoft-edge/webvr/essentials#mouse-input
             */
            get: function () {
                return this._vrExclusivePointerMode;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "supportsUniformBuffers", {
            /**
             * Gets a boolean indicating that the engine supports uniform buffers
             * @see http://doc.babylonjs.com/features/webgl2#uniform-buffer-objets
             */
            get: function () {
                return this.webGLVersion > 1 && !this.disableUniformBuffers;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "needPOTTextures", {
            /**
             * Gets a boolean indicating that only power of 2 textures are supported
             * Please note that you can still use non power of 2 textures but in this case the engine will forcefully convert them
             */
            get: function () {
                return this._webGLVersion < 2 || this.forcePOTTextures;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "performanceMonitor", {
            /**
             * Gets the performance monitor attached to this engine
             * @see http://doc.babylonjs.com/how_to/optimizing_your_scene#engineinstrumentation
             */
            get: function () {
                return this._performanceMonitor;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "texturesSupported", {
            /**
             * Gets the list of texture formats supported
             */
            get: function () {
                return this._texturesSupported;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "textureFormatInUse", {
            /**
             * Gets the list of texture formats in use
             */
            get: function () {
                return this._textureFormatInUse;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "currentViewport", {
            /**
             * Gets the current viewport
             */
            get: function () {
                return this._cachedViewport;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyTexture", {
            /**
             * Gets the default empty texture
             */
            get: function () {
                if (!this._emptyTexture) {
                    this._emptyTexture = this.createRawTexture(new Uint8Array(4), 1, 1, Engine.TEXTUREFORMAT_RGBA, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyTexture;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyTexture3D", {
            /**
             * Gets the default empty 3D texture
             */
            get: function () {
                if (!this._emptyTexture3D) {
                    this._emptyTexture3D = this.createRawTexture3D(new Uint8Array(4), 1, 1, 1, Engine.TEXTUREFORMAT_RGBA, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyTexture3D;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyCubeTexture", {
            /**
             * Gets the default empty cube texture
             */
            get: function () {
                if (!this._emptyCubeTexture) {
                    var faceData = new Uint8Array(4);
                    var cubeData = [faceData, faceData, faceData, faceData, faceData, faceData];
                    this._emptyCubeTexture = this.createRawCubeTexture(cubeData, 1, Engine.TEXTUREFORMAT_RGBA, Engine.TEXTURETYPE_UNSIGNED_INT, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyCubeTexture;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype._rebuildInternalTextures = function () {
            var currentState = this._internalTexturesCache.slice(); // Do a copy because the rebuild will add proxies
            for (var _i = 0, currentState_1 = currentState; _i < currentState_1.length; _i++) {
                var internalTexture = currentState_1[_i];
                internalTexture._rebuild();
            }
        };
        Engine.prototype._rebuildEffects = function () {
            for (var key in this._compiledEffects) {
                var effect = this._compiledEffects[key];
                effect._prepareEffect();
            }
            BABYLON.Effect.ResetCache();
        };
        Engine.prototype._rebuildBuffers = function () {
            // Index / Vertex
            for (var _i = 0, _a = this.scenes; _i < _a.length; _i++) {
                var scene = _a[_i];
                scene.resetCachedMaterial();
                scene._rebuildGeometries();
                scene._rebuildTextures();
            }
            // Uniforms
            for (var _b = 0, _c = this._uniformBuffers; _b < _c.length; _b++) {
                var uniformBuffer = _c[_b];
                uniformBuffer._rebuild();
            }
        };
        Engine.prototype._initGLContext = function () {
            // Caps
            this._caps = new EngineCapabilities();
            this._caps.maxTexturesImageUnits = this._gl.getParameter(this._gl.MAX_TEXTURE_IMAGE_UNITS);
            this._caps.maxCombinedTexturesImageUnits = this._gl.getParameter(this._gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
            this._caps.maxVertexTextureImageUnits = this._gl.getParameter(this._gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
            this._caps.maxTextureSize = this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE);
            this._caps.maxCubemapTextureSize = this._gl.getParameter(this._gl.MAX_CUBE_MAP_TEXTURE_SIZE);
            this._caps.maxRenderTextureSize = this._gl.getParameter(this._gl.MAX_RENDERBUFFER_SIZE);
            this._caps.maxVertexAttribs = this._gl.getParameter(this._gl.MAX_VERTEX_ATTRIBS);
            this._caps.maxVaryingVectors = this._gl.getParameter(this._gl.MAX_VARYING_VECTORS);
            this._caps.maxFragmentUniformVectors = this._gl.getParameter(this._gl.MAX_FRAGMENT_UNIFORM_VECTORS);
            this._caps.maxVertexUniformVectors = this._gl.getParameter(this._gl.MAX_VERTEX_UNIFORM_VECTORS);
            // Infos
            this._glVersion = this._gl.getParameter(this._gl.VERSION);
            var rendererInfo = this._gl.getExtension("WEBGL_debug_renderer_info");
            if (rendererInfo != null) {
                this._glRenderer = this._gl.getParameter(rendererInfo.UNMASKED_RENDERER_WEBGL);
                this._glVendor = this._gl.getParameter(rendererInfo.UNMASKED_VENDOR_WEBGL);
            }
            if (!this._glVendor) {
                this._glVendor = "Unknown vendor";
            }
            if (!this._glRenderer) {
                this._glRenderer = "Unknown renderer";
            }
            // Constants
            this._gl.HALF_FLOAT_OES = 0x8D61; // Half floating-point type (16-bit).
            if (this._gl.RGBA16F !== 0x881A) {
                this._gl.RGBA16F = 0x881A; // RGBA 16-bit floating-point color-renderable internal sized format.
            }
            if (this._gl.RGBA32F !== 0x8814) {
                this._gl.RGBA32F = 0x8814; // RGBA 32-bit floating-point color-renderable internal sized format.
            }
            if (this._gl.DEPTH24_STENCIL8 !== 35056) {
                this._gl.DEPTH24_STENCIL8 = 35056;
            }
            // Extensions
            this._caps.standardDerivatives = this._webGLVersion > 1 || (this._gl.getExtension('OES_standard_derivatives') !== null);
            this._caps.astc = this._gl.getExtension('WEBGL_compressed_texture_astc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_astc');
            this._caps.s3tc = this._gl.getExtension('WEBGL_compressed_texture_s3tc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_s3tc');
            this._caps.pvrtc = this._gl.getExtension('WEBGL_compressed_texture_pvrtc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_pvrtc');
            this._caps.etc1 = this._gl.getExtension('WEBGL_compressed_texture_etc1') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_etc1');
            this._caps.etc2 = this._gl.getExtension('WEBGL_compressed_texture_etc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_etc') ||
                this._gl.getExtension('WEBGL_compressed_texture_es3_0'); // also a requirement of OpenGL ES 3
            this._caps.textureAnisotropicFilterExtension = this._gl.getExtension('EXT_texture_filter_anisotropic') || this._gl.getExtension('WEBKIT_EXT_texture_filter_anisotropic') || this._gl.getExtension('MOZ_EXT_texture_filter_anisotropic');
            this._caps.maxAnisotropy = this._caps.textureAnisotropicFilterExtension ? this._gl.getParameter(this._caps.textureAnisotropicFilterExtension.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 0;
            this._caps.uintIndices = this._webGLVersion > 1 || this._gl.getExtension('OES_element_index_uint') !== null;
            this._caps.fragmentDepthSupported = this._webGLVersion > 1 || this._gl.getExtension('EXT_frag_depth') !== null;
            this._caps.highPrecisionShaderSupported = true;
            this._caps.timerQuery = this._gl.getExtension('EXT_disjoint_timer_query_webgl2') || this._gl.getExtension("EXT_disjoint_timer_query");
            if (this._caps.timerQuery) {
                if (this._webGLVersion === 1) {
                    this._gl.getQuery = this._caps.timerQuery.getQueryEXT.bind(this._caps.timerQuery);
                }
                this._caps.canUseTimestampForTimerQuery = this._gl.getQuery(this._caps.timerQuery.TIMESTAMP_EXT, this._caps.timerQuery.QUERY_COUNTER_BITS_EXT) > 0;
            }
            // Checks if some of the format renders first to allow the use of webgl inspector.
            this._caps.colorBufferFloat = this._webGLVersion > 1 && this._gl.getExtension('EXT_color_buffer_float');
            this._caps.textureFloat = (this._webGLVersion > 1 || this._gl.getExtension('OES_texture_float')) ? true : false;
            this._caps.textureFloatLinearFiltering = this._caps.textureFloat && this._gl.getExtension('OES_texture_float_linear') ? true : false;
            this._caps.textureFloatRender = this._caps.textureFloat && this._canRenderToFloatFramebuffer() ? true : false;
            this._caps.textureHalfFloat = (this._webGLVersion > 1 || this._gl.getExtension('OES_texture_half_float')) ? true : false;
            this._caps.textureHalfFloatLinearFiltering = (this._webGLVersion > 1 || (this._caps.textureHalfFloat && this._gl.getExtension('OES_texture_half_float_linear'))) ? true : false;
            if (this._webGLVersion > 1) {
                this._gl.HALF_FLOAT_OES = 0x140B;
            }
            this._caps.textureHalfFloatRender = this._caps.textureHalfFloat && this._canRenderToHalfFloatFramebuffer();
            this._caps.textureLOD = (this._webGLVersion > 1 || this._gl.getExtension('EXT_shader_texture_lod')) ? true : false;
            // Draw buffers
            if (this._webGLVersion > 1) {
                this._caps.drawBuffersExtension = true;
            }
            else {
                var drawBuffersExtension = this._gl.getExtension('WEBGL_draw_buffers');
                if (drawBuffersExtension !== null) {
                    this._caps.drawBuffersExtension = true;
                    this._gl.drawBuffers = drawBuffersExtension.drawBuffersWEBGL.bind(drawBuffersExtension);
                    this._gl.DRAW_FRAMEBUFFER = this._gl.FRAMEBUFFER;
                    for (var i = 0; i < 16; i++) {
                        this._gl["COLOR_ATTACHMENT" + i + "_WEBGL"] = drawBuffersExtension["COLOR_ATTACHMENT" + i + "_WEBGL"];
                    }
                }
                else {
                    this._caps.drawBuffersExtension = false;
                }
            }
            // Depth Texture
            if (this._webGLVersion > 1) {
                this._caps.depthTextureExtension = true;
            }
            else {
                var depthTextureExtension = this._gl.getExtension('WEBGL_depth_texture');
                if (depthTextureExtension != null) {
                    this._caps.depthTextureExtension = true;
                    this._gl.UNSIGNED_INT_24_8 = depthTextureExtension.UNSIGNED_INT_24_8_WEBGL;
                }
            }
            // Vertex array object
            if (this._webGLVersion > 1) {
                this._caps.vertexArrayObject = true;
            }
            else {
                var vertexArrayObjectExtension = this._gl.getExtension('OES_vertex_array_object');
                if (vertexArrayObjectExtension != null) {
                    this._caps.vertexArrayObject = true;
                    this._gl.createVertexArray = vertexArrayObjectExtension.createVertexArrayOES.bind(vertexArrayObjectExtension);
                    this._gl.bindVertexArray = vertexArrayObjectExtension.bindVertexArrayOES.bind(vertexArrayObjectExtension);
                    this._gl.deleteVertexArray = vertexArrayObjectExtension.deleteVertexArrayOES.bind(vertexArrayObjectExtension);
                }
                else {
                    this._caps.vertexArrayObject = false;
                }
            }
            // Instances count
            if (this._webGLVersion > 1) {
                this._caps.instancedArrays = true;
            }
            else {
                var instanceExtension = this._gl.getExtension('ANGLE_instanced_arrays');
                if (instanceExtension != null) {
                    this._caps.instancedArrays = true;
                    this._gl.drawArraysInstanced = instanceExtension.drawArraysInstancedANGLE.bind(instanceExtension);
                    this._gl.drawElementsInstanced = instanceExtension.drawElementsInstancedANGLE.bind(instanceExtension);
                    this._gl.vertexAttribDivisor = instanceExtension.vertexAttribDivisorANGLE.bind(instanceExtension);
                }
                else {
                    this._caps.instancedArrays = false;
                }
            }
            // Intelligently add supported compressed formats in order to check for.
            // Check for ASTC support first as it is most powerful and to be very cross platform.
            // Next PVRTC & DXT, which are probably superior to ETC1/2.
            // Likely no hardware which supports both PVR & DXT, so order matters little.
            // ETC2 is newer and handles ETC1 (no alpha capability), so check for first.
            if (this._caps.astc)
                this.texturesSupported.push('-astc.ktx');
            if (this._caps.s3tc)
                this.texturesSupported.push('-dxt.ktx');
            if (this._caps.pvrtc)
                this.texturesSupported.push('-pvrtc.ktx');
            if (this._caps.etc2)
                this.texturesSupported.push('-etc2.ktx');
            if (this._caps.etc1)
                this.texturesSupported.push('-etc1.ktx');
            if (this._gl.getShaderPrecisionFormat) {
                var highp = this._gl.getShaderPrecisionFormat(this._gl.FRAGMENT_SHADER, this._gl.HIGH_FLOAT);
                if (highp) {
                    this._caps.highPrecisionShaderSupported = highp.precision !== 0;
                }
            }
            // Depth buffer
            this.setDepthBuffer(true);
            this.setDepthFunctionToLessOrEqual();
            this.setDepthWrite(true);
            // Texture maps
            this._maxSimultaneousTextures = this._caps.maxCombinedTexturesImageUnits;
            for (var slot = 0; slot < this._maxSimultaneousTextures; slot++) {
                this._nextFreeTextureSlots.push(slot);
            }
        };
        Object.defineProperty(Engine.prototype, "webGLVersion", {
            /**
             * Gets version of the current webGL context
             */
            get: function () {
                return this._webGLVersion;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "isStencilEnable", {
            /**
             * Returns true if the stencil buffer has been enabled through the creation option of the context.
             */
            get: function () {
                return this._isStencilEnable;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype._prepareWorkingCanvas = function () {
            if (this._workingCanvas) {
                return;
            }
            this._workingCanvas = document.createElement("canvas");
            var context = this._workingCanvas.getContext("2d");
            if (context) {
                this._workingContext = context;
            }
        };
        /**
         * Reset the texture cache to empty state
         */
        Engine.prototype.resetTextureCache = function () {
            for (var key in this._boundTexturesCache) {
                if (!this._boundTexturesCache.hasOwnProperty(key)) {
                    continue;
                }
                var boundTexture = this._boundTexturesCache[key];
                if (boundTexture) {
                    this._removeDesignatedSlot(boundTexture);
                }
                this._boundTexturesCache[key] = null;
            }
            if (!this.disableTextureBindingOptimization) {
                this._nextFreeTextureSlots = [];
                for (var slot = 0; slot < this._maxSimultaneousTextures; slot++) {
                    this._nextFreeTextureSlots.push(slot);
                }
            }
            this._currentTextureChannel = -1;
        };
        /**
         * Gets a boolean indicating that the engine is running in deterministic lock step mode
         * @see http://doc.babylonjs.com/babylon101/animations#deterministic-lockstep
         * @returns true if engine is in deterministic lock step mode
         */
        Engine.prototype.isDeterministicLockStep = function () {
            return this._deterministicLockstep;
        };
        /**
         * Gets the max steps when engine is running in deterministic lock step
         * @see http://doc.babylonjs.com/babylon101/animations#deterministic-lockstep
         * @returns the max steps
         */
        Engine.prototype.getLockstepMaxSteps = function () {
            return this._lockstepMaxSteps;
        };
        /**
         * Gets an object containing information about the current webGL context
         * @returns an object containing the vender, the renderer and the version of the current webGL context
         */
        Engine.prototype.getGlInfo = function () {
            return {
                vendor: this._glVendor,
                renderer: this._glRenderer,
                version: this._glVersion
            };
        };
        /**
         * Gets current aspect ratio
         * @param camera defines the camera to use to get the aspect ratio
         * @param useScreen defines if screen size must be used (or the current render target if any)
         * @returns a number defining the aspect ratio
         */
        Engine.prototype.getAspectRatio = function (camera, useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            var viewport = camera.viewport;
            return (this.getRenderWidth(useScreen) * viewport.width) / (this.getRenderHeight(useScreen) * viewport.height);
        };
        /**
         * Gets the current render width
         * @param useScreen defines if screen size must be used (or the current render target if any)
         * @returns a number defining the current render width
         */
        Engine.prototype.getRenderWidth = function (useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            if (!useScreen && this._currentRenderTarget) {
                return this._currentRenderTarget.width;
            }
            return this._gl.drawingBufferWidth;
        };
        /**
         * Gets the current render height
         * @param useScreen defines if screen size must be used (or the current render target if any)
         * @returns a number defining the current render height
         */
        Engine.prototype.getRenderHeight = function (useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            if (!useScreen && this._currentRenderTarget) {
                return this._currentRenderTarget.height;
            }
            return this._gl.drawingBufferHeight;
        };
        /**
         * Gets the HTML canvas attached with the current webGL context
         * @returns a HTML canvas
         */
        Engine.prototype.getRenderingCanvas = function () {
            return this._renderingCanvas;
        };
        /**
         * Gets the client rect of the HTML canvas attached with the current webGL context
         * @returns a client rectanglee
         */
        Engine.prototype.getRenderingCanvasClientRect = function () {
            if (!this._renderingCanvas) {
                return null;
            }
            return this._renderingCanvas.getBoundingClientRect();
        };
        /**
         * Defines the hardware scaling level.
         * By default the hardware scaling level is computed from the window device ratio.
         * if level = 1 then the engine will render at the exact resolution of the canvas. If level = 0.5 then the engine will render at twice the size of the canvas.
         * @param level defines the level to use
         */
        Engine.prototype.setHardwareScalingLevel = function (level) {
            this._hardwareScalingLevel = level;
            this.resize();
        };
        /**
         * Gets the current hardware scaling level.
         * By default the hardware scaling level is computed from the window device ratio.
         * if level = 1 then the engine will render at the exact resolution of the canvas. If level = 0.5 then the engine will render at twice the size of the canvas.
         * @returns a number indicating the current hardware scaling level
         */
        Engine.prototype.getHardwareScalingLevel = function () {
            return this._hardwareScalingLevel;
        };
        /**
         * Gets the list of loaded textures
         * @returns an array containing all loaded textures
         */
        Engine.prototype.getLoadedTexturesCache = function () {
            return this._internalTexturesCache;
        };
        /**
         * Gets the object containing all engine capabilities
         * @returns the EngineCapabilities object
         */
        Engine.prototype.getCaps = function () {
            return this._caps;
        };
        Object.defineProperty(Engine.prototype, "drawCalls", {
            /** @hidden */
            get: function () {
                BABYLON.Tools.Warn("drawCalls is deprecated. Please use SceneInstrumentation class");
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "drawCallsPerfCounter", {
            /** @hidden */
            get: function () {
                BABYLON.Tools.Warn("drawCallsPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Gets the current depth function
         * @returns a number defining the depth function
         */
        Engine.prototype.getDepthFunction = function () {
            return this._depthCullingState.depthFunc;
        };
        /**
         * Sets the current depth function
         * @param depthFunc defines the function to use
         */
        Engine.prototype.setDepthFunction = function (depthFunc) {
            this._depthCullingState.depthFunc = depthFunc;
        };
        /**
         * Sets the current depth function to GREATER
         */
        Engine.prototype.setDepthFunctionToGreater = function () {
            this._depthCullingState.depthFunc = this._gl.GREATER;
        };
        /**
         * Sets the current depth function to GEQUAL
         */
        Engine.prototype.setDepthFunctionToGreaterOrEqual = function () {
            this._depthCullingState.depthFunc = this._gl.GEQUAL;
        };
        /**
         * Sets the current depth function to LESS
         */
        Engine.prototype.setDepthFunctionToLess = function () {
            this._depthCullingState.depthFunc = this._gl.LESS;
        };
        /**
         * Sets the current depth function to LEQUAL
         */
        Engine.prototype.setDepthFunctionToLessOrEqual = function () {
            this._depthCullingState.depthFunc = this._gl.LEQUAL;
        };
        /**
         * Gets a boolean indicating if stencil buffer is enabled
         * @returns the current stencil buffer state
         */
        Engine.prototype.getStencilBuffer = function () {
            return this._stencilState.stencilTest;
        };
        /**
         * Enable or disable the stencil buffer
         * @param enable defines if the stencil buffer must be enabled or disabled
         */
        Engine.prototype.setStencilBuffer = function (enable) {
            this._stencilState.stencilTest = enable;
        };
        /**
         * Gets the current stencil mask
         * @returns a number defining the new stencil mask to use
         */
        Engine.prototype.getStencilMask = function () {
            return this._stencilState.stencilMask;
        };
        /**
         * Sets the current stencil mask
         * @param mask defines the new stencil mask to use
         */
        Engine.prototype.setStencilMask = function (mask) {
            this._stencilState.stencilMask = mask;
        };
        /**
         * Gets the current stencil function
         * @returns a number defining the stencil function to use
         */
        Engine.prototype.getStencilFunction = function () {
            return this._stencilState.stencilFunc;
        };
        /**
         * Gets the current stencil reference value
         * @returns a number defining the stencil reference value to use
         */
        Engine.prototype.getStencilFunctionReference = function () {
            return this._stencilState.stencilFuncRef;
        };
        /**
         * Gets the current stencil mask
         * @returns a number defining the stencil mask to use
         */
        Engine.prototype.getStencilFunctionMask = function () {
            return this._stencilState.stencilFuncMask;
        };
        /**
         * Sets the current stencil function
         * @param stencilFunc defines the new stencil function to use
         */
        Engine.prototype.setStencilFunction = function (stencilFunc) {
            this._stencilState.stencilFunc = stencilFunc;
        };
        /**
         * Sets the current stencil reference
         * @param reference defines the new stencil reference to use
         */
        Engine.prototype.setStencilFunctionReference = function (reference) {
            this._stencilState.stencilFuncRef = reference;
        };
        /**
         * Sets the current stencil mask
         * @param mask defines the new stencil mask to use
         */
        Engine.prototype.setStencilFunctionMask = function (mask) {
            this._stencilState.stencilFuncMask = mask;
        };
        /**
         * Gets the current stencil operation when stencil fails
         * @returns a number defining stencil operation to use when stencil fails
         */
        Engine.prototype.getStencilOperationFail = function () {
            return this._stencilState.stencilOpStencilFail;
        };
        /**
         * Gets the current stencil operation when depth fails
         * @returns a number defining stencil operation to use when depth fails
         */
        Engine.prototype.getStencilOperationDepthFail = function () {
            return this._stencilState.stencilOpDepthFail;
        };
        /**
         * Gets the current stencil operation when stencil passes
         * @returns a number defining stencil operation to use when stencil passes
         */
        Engine.prototype.getStencilOperationPass = function () {
            return this._stencilState.stencilOpStencilDepthPass;
        };
        /**
         * Sets the stencil operation to use when stencil fails
         * @param operation defines the stencil operation to use when stencil fails
         */
        Engine.prototype.setStencilOperationFail = function (operation) {
            this._stencilState.stencilOpStencilFail = operation;
        };
        /**
         * Sets the stencil operation to use when depth fails
         * @param operation defines the stencil operation to use when depth fails
         */
        Engine.prototype.setStencilOperationDepthFail = function (operation) {
            this._stencilState.stencilOpDepthFail = operation;
        };
        /**
         * Sets the stencil operation to use when stencil passes
         * @param operation defines the stencil operation to use when stencil passes
         */
        Engine.prototype.setStencilOperationPass = function (operation) {
            this._stencilState.stencilOpStencilDepthPass = operation;
        };
        /**
         * Sets a boolean indicating if the dithering state is enabled or disabled
         * @param value defines the dithering state
         */
        Engine.prototype.setDitheringState = function (value) {
            if (value) {
                this._gl.enable(this._gl.DITHER);
            }
            else {
                this._gl.disable(this._gl.DITHER);
            }
        };
        /**
         * Sets a boolean indicating if the rasterizer state is enabled or disabled
         * @param value defines the rasterizer state
         */
        Engine.prototype.setRasterizerState = function (value) {
            if (value) {
                this._gl.disable(this._gl.RASTERIZER_DISCARD);
            }
            else {
                this._gl.enable(this._gl.RASTERIZER_DISCARD);
            }
        };
        /**
         * stop executing a render loop function and remove it from the execution array
         * @param renderFunction defines the function to be removed. If not provided all functions will be removed.
         */
        Engine.prototype.stopRenderLoop = function (renderFunction) {
            if (!renderFunction) {
                this._activeRenderLoops = [];
                return;
            }
            var index = this._activeRenderLoops.indexOf(renderFunction);
            if (index >= 0) {
                this._activeRenderLoops.splice(index, 1);
            }
        };
        /** @hidden */
        Engine.prototype._renderLoop = function () {
            if (!this._contextWasLost) {
                var shouldRender = true;
                if (!this.renderEvenInBackground && this._windowIsBackground) {
                    shouldRender = false;
                }
                if (shouldRender) {
                    // Start new frame
                    this.beginFrame();
                    for (var index = 0; index < this._activeRenderLoops.length; index++) {
                        var renderFunction = this._activeRenderLoops[index];
                        renderFunction();
                    }
                    // Present
                    this.endFrame();
                }
            }
            if (this._activeRenderLoops.length > 0) {
                // Register new frame
                var requester = null;
                if (this._vrDisplay && this._vrDisplay.isPresenting)
                    requester = this._vrDisplay;
                this._frameHandler = BABYLON.Tools.QueueNewFrame(this._bindedRenderFunction, requester);
            }
            else {
                this._renderingQueueLaunched = false;
            }
        };
        /**
         * Register and execute a render loop. The engine can have more than one render function
         * @param renderFunction defines the function to continuously execute
         */
        Engine.prototype.runRenderLoop = function (renderFunction) {
            if (this._activeRenderLoops.indexOf(renderFunction) !== -1) {
                return;
            }
            this._activeRenderLoops.push(renderFunction);
            if (!this._renderingQueueLaunched) {
                this._renderingQueueLaunched = true;
                this._bindedRenderFunction = this._renderLoop.bind(this);
                this._frameHandler = BABYLON.Tools.QueueNewFrame(this._bindedRenderFunction);
            }
        };
        /**
         * Toggle full screen mode
         * @param requestPointerLock defines if a pointer lock should be requested from the user
         * @param options defines an option object to be sent to the requestFullscreen function
         */
        Engine.prototype.switchFullscreen = function (requestPointerLock) {
            if (this.isFullscreen) {
                BABYLON.Tools.ExitFullscreen();
            }
            else {
                this._pointerLockRequested = requestPointerLock;
                if (this._renderingCanvas) {
                    BABYLON.Tools.RequestFullscreen(this._renderingCanvas);
                }
            }
        };
        /**
         * Clear the current render buffer or the current render target (if any is set up)
         * @param color defines the color to use
         * @param backBuffer defines if the back buffer must be cleared
         * @param depth defines if the depth buffer must be cleared
         * @param stencil defines if the stencil buffer must be cleared
         */
        Engine.prototype.clear = function (color, backBuffer, depth, stencil) {
            if (stencil === void 0) { stencil = false; }
            this.applyStates();
            var mode = 0;
            if (backBuffer && color) {
                this._gl.clearColor(color.r, color.g, color.b, color.a !== undefined ? color.a : 1.0);
                mode |= this._gl.COLOR_BUFFER_BIT;
            }
            if (depth) {
                this._gl.clearDepth(1.0);
                mode |= this._gl.DEPTH_BUFFER_BIT;
            }
            if (stencil) {
                this._gl.clearStencil(0);
                mode |= this._gl.STENCIL_BUFFER_BIT;
            }
            this._gl.clear(mode);
        };
        /**
         * Executes a scissor clear (ie. a clear on a specific portion of the screen)
         * @param x defines the x-coordinate of the top left corner of the clear rectangle
         * @param y defines the y-coordinate of the corner of the clear rectangle
         * @param width defines the width of the clear rectangle
         * @param height defines the height of the clear rectangle
         * @param clearColor defines the clear color
         */
        Engine.prototype.scissorClear = function (x, y, width, height, clearColor) {
            var gl = this._gl;
            // Save state
            var curScissor = gl.getParameter(gl.SCISSOR_TEST);
            var curScissorBox = gl.getParameter(gl.SCISSOR_BOX);
            // Change state
            gl.enable(gl.SCISSOR_TEST);
            gl.scissor(x, y, width, height);
            // Clear
            this.clear(clearColor, true, true, true);
            // Restore state
            gl.scissor(curScissorBox[0], curScissorBox[1], curScissorBox[2], curScissorBox[3]);
            if (curScissor === true) {
                gl.enable(gl.SCISSOR_TEST);
            }
            else {
                gl.disable(gl.SCISSOR_TEST);
            }
        };
        /**
         * Set the WebGL's viewport
         * @param viewport defines the viewport element to be used
         * @param requiredWidth defines the width required for rendering. If not provided the rendering canvas' width is used
         * @param requiredHeight defines the height required for rendering. If not provided the rendering canvas' height is used
         */
        Engine.prototype.setViewport = function (viewport, requiredWidth, requiredHeight) {
            var width = requiredWidth || this.getRenderWidth();
            var height = requiredHeight || this.getRenderHeight();
            var x = viewport.x || 0;
            var y = viewport.y || 0;
            this._cachedViewport = viewport;
            this._gl.viewport(x * width, y * height, width * viewport.width, height * viewport.height);
        };
        /**
         * Directly set the WebGL Viewport
         * @param x defines the x coordinate of the viewport (in screen space)
         * @param y defines the y coordinate of the viewport (in screen space)
         * @param width defines the width of the viewport (in screen space)
         * @param height defines the height of the viewport (in screen space)
         * @return the current viewport Object (if any) that is being replaced by this call. You can restore this viewport later on to go back to the original state
         */
        Engine.prototype.setDirectViewport = function (x, y, width, height) {
            var currentViewport = this._cachedViewport;
            this._cachedViewport = null;
            this._gl.viewport(x, y, width, height);
            return currentViewport;
        };
        /**
         * Begin a new frame
         */
        Engine.prototype.beginFrame = function () {
            this.onBeginFrameObservable.notifyObservers(this);
            this._measureFps();
        };
        /**
         * Enf the current frame
         */
        Engine.prototype.endFrame = function () {
            // Force a flush in case we are using a bad OS.
            if (this._badOS) {
                this.flushFramebuffer();
            }
            // Submit frame to the vr device, if enabled
            if (this._vrDisplay && this._vrDisplay.isPresenting) {
                // TODO: We should only submit the frame if we read frameData successfully.
                this._vrDisplay.submitFrame();
            }
            this.onEndFrameObservable.notifyObservers(this);
        };
        /**
         * Resize the view according to the canvas' size
         */
        Engine.prototype.resize = function () {
            // We're not resizing the size of the canvas while in VR mode & presenting
            if (!(this._vrDisplay && this._vrDisplay.isPresenting)) {
                var width = this._renderingCanvas ? this._renderingCanvas.clientWidth : window.innerWidth;
                var height = this._renderingCanvas ? this._renderingCanvas.clientHeight : window.innerHeight;
                this.setSize(width / this._hardwareScalingLevel, height / this._hardwareScalingLevel);
            }
        };
        /**
         * Force a specific size of the canvas
         * @param width defines the new canvas' width
         * @param height defines the new canvas' height
         */
        Engine.prototype.setSize = function (width, height) {
            if (!this._renderingCanvas) {
                return;
            }
            if (this._renderingCanvas.width === width && this._renderingCanvas.height === height) {
                return;
            }
            this._renderingCanvas.width = width;
            this._renderingCanvas.height = height;
            for (var index = 0; index < this.scenes.length; index++) {
                var scene = this.scenes[index];
                for (var camIndex = 0; camIndex < scene.cameras.length; camIndex++) {
                    var cam = scene.cameras[camIndex];
                    cam._currentRenderId = 0;
                }
            }
            if (this.onResizeObservable.hasObservers) {
                this.onResizeObservable.notifyObservers(this);
            }
        };
        // WebVR functions
        /**
         * Gets a boolean indicating if a webVR device was detected
         * @returns true if a webVR device was detected
         */
        Engine.prototype.isVRDevicePresent = function () {
            return !!this._vrDisplay;
        };
        /**
         * Gets the current webVR device
         * @returns the current webVR device (or null)
         */
        Engine.prototype.getVRDevice = function () {
            return this._vrDisplay;
        };
        /**
         * Initializes a webVR display and starts listening to display change events
         * The onVRDisplayChangedObservable will be notified upon these changes
         * @returns The onVRDisplayChangedObservable
         */
        Engine.prototype.initWebVR = function () {
            this.initWebVRAsync();
            return this.onVRDisplayChangedObservable;
        };
        /**
         * Initializes a webVR display and starts listening to display change events
         * The onVRDisplayChangedObservable will be notified upon these changes
         * @returns A promise containing a VRDisplay and if vr is supported
         */
        Engine.prototype.initWebVRAsync = function () {
            var _this = this;
            var notifyObservers = function () {
                var eventArgs = {
                    vrDisplay: _this._vrDisplay,
                    vrSupported: _this._vrSupported
                };
                _this.onVRDisplayChangedObservable.notifyObservers(eventArgs);
                _this._webVRInitPromise = new Promise(function (res) { res(eventArgs); });
            };
            if (!this._onVrDisplayConnect) {
                this._onVrDisplayConnect = function (event) {
                    _this._vrDisplay = event.display;
                    notifyObservers();
                };
                this._onVrDisplayDisconnect = function () {
                    _this._vrDisplay.cancelAnimationFrame(_this._frameHandler);
                    _this._vrDisplay = undefined;
                    _this._frameHandler = BABYLON.Tools.QueueNewFrame(_this._bindedRenderFunction);
                    notifyObservers();
                };
                this._onVrDisplayPresentChange = function () {
                    _this._vrExclusivePointerMode = _this._vrDisplay && _this._vrDisplay.isPresenting;
                };
                window.addEventListener('vrdisplayconnect', this._onVrDisplayConnect);
                window.addEventListener('vrdisplaydisconnect', this._onVrDisplayDisconnect);
                window.addEventListener('vrdisplaypresentchange', this._onVrDisplayPresentChange);
            }
            this._webVRInitPromise = this._webVRInitPromise || this._getVRDisplaysAsync();
            this._webVRInitPromise.then(notifyObservers);
            return this._webVRInitPromise;
        };
        /**
         * Call this function to switch to webVR mode
         * Will do nothing if webVR is not supported or if there is no webVR device
         * @see http://doc.babylonjs.com/how_to/webvr_camera
         */
        Engine.prototype.enableVR = function () {
            var _this = this;
            if (this._vrDisplay && !this._vrDisplay.isPresenting) {
                var onResolved = function () {
                    _this.onVRRequestPresentComplete.notifyObservers(true);
                    _this._onVRFullScreenTriggered();
                };
                var onRejected = function () {
                    _this.onVRRequestPresentComplete.notifyObservers(false);
                };
                this.onVRRequestPresentStart.notifyObservers(this);
                this._vrDisplay.requestPresent([{ source: this.getRenderingCanvas() }]).then(onResolved).catch(onRejected);
            }
        };
        /**
         * Call this function to leave webVR mode
         * Will do nothing if webVR is not supported or if there is no webVR device
         * @see http://doc.babylonjs.com/how_to/webvr_camera
         */
        Engine.prototype.disableVR = function () {
            if (this._vrDisplay && this._vrDisplay.isPresenting) {
                this._vrDisplay.exitPresent().then(this._onVRFullScreenTriggered).catch(this._onVRFullScreenTriggered);
            }
        };
        Engine.prototype._getVRDisplaysAsync = function () {
            var _this = this;
            return new Promise(function (res, rej) {
                if (navigator.getVRDisplays) {
                    navigator.getVRDisplays().then(function (devices) {
                        _this._vrSupported = true;
                        // note that devices may actually be an empty array. This is fine;
                        // we expect this._vrDisplay to be undefined in this case.
                        _this._vrDisplay = devices[0];
                        res({
                            vrDisplay: _this._vrDisplay,
                            vrSupported: _this._vrSupported
                        });
                    });
                }
                else {
                    _this._vrDisplay = undefined;
                    _this._vrSupported = false;
                    res({
                        vrDisplay: _this._vrDisplay,
                        vrSupported: _this._vrSupported
                    });
                }
            });
        };
        /**
         * Binds the frame buffer to the specified texture.
         * @param texture The texture to render to or null for the default canvas
         * @param faceIndex The face of the texture to render to in case of cube texture
         * @param requiredWidth The width of the target to render to
         * @param requiredHeight The height of the target to render to
         * @param forceFullscreenViewport Forces the viewport to be the entire texture/screen if true
         * @param depthStencilTexture The depth stencil texture to use to render
         */
        Engine.prototype.bindFramebuffer = function (texture, faceIndex, requiredWidth, requiredHeight, forceFullscreenViewport, depthStencilTexture) {
            if (this._currentRenderTarget) {
                this.unBindFramebuffer(this._currentRenderTarget);
            }
            this._currentRenderTarget = texture;
            this.bindUnboundFramebuffer(texture._MSAAFramebuffer ? texture._MSAAFramebuffer : texture._framebuffer);
            var gl = this._gl;
            if (texture.isCube) {
                if (faceIndex === undefined) {
                    faceIndex = 0;
                }
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, texture._webGLTexture, 0);
                if (depthStencilTexture) {
                    if (depthStencilTexture._generateStencilBuffer) {
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, depthStencilTexture._webGLTexture, 0);
                    }
                    else {
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, depthStencilTexture._webGLTexture, 0);
                    }
                }
            }
            if (this._cachedViewport && !forceFullscreenViewport) {
                this.setViewport(this._cachedViewport, requiredWidth, requiredHeight);
            }
            else {
                gl.viewport(0, 0, requiredWidth || texture.width, requiredHeight || texture.height);
            }
            this.wipeCaches();
        };
        Engine.prototype.bindUnboundFramebuffer = function (framebuffer) {
            if (this._currentFramebuffer !== framebuffer) {
                this._gl.bindFramebuffer(this._gl.FRAMEBUFFER, framebuffer);
                this._currentFramebuffer = framebuffer;
            }
        };
        /**
         * Unbind the current render target texture from the webGL context
         * @param texture defines the render target texture to unbind
         * @param disableGenerateMipMaps defines a boolean indicating that mipmaps must not be generated
         * @param onBeforeUnbind defines a function which will be called before the effective unbind
         */
        Engine.prototype.unBindFramebuffer = function (texture, disableGenerateMipMaps, onBeforeUnbind) {
            if (disableGenerateMipMaps === void 0) { disableGenerateMipMaps = false; }
            this._currentRenderTarget = null;
            // If MSAA, we need to bitblt back to main texture
            var gl = this._gl;
            if (texture._MSAAFramebuffer) {
                gl.bindFramebuffer(gl.READ_FRAMEBUFFER, texture._MSAAFramebuffer);
                gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, texture._framebuffer);
                gl.blitFramebuffer(0, 0, texture.width, texture.height, 0, 0, texture.width, texture.height, gl.COLOR_BUFFER_BIT, gl.NEAREST);
            }
            if (texture.generateMipMaps && !disableGenerateMipMaps && !texture.isCube) {
                this._bindTextureDirectly(gl.TEXTURE_2D, texture, true);
                gl.generateMipmap(gl.TEXTURE_2D);
                this._bindTextureDirectly(gl.TEXTURE_2D, null);
            }
            if (onBeforeUnbind) {
                if (texture._MSAAFramebuffer) {
                    // Bind the correct framebuffer
                    this.bindUnboundFramebuffer(texture._framebuffer);
                }
                onBeforeUnbind();
            }
            this.bindUnboundFramebuffer(null);
        };
        /**
         * Unbind a list of render target textures from the webGL context
         * This is used only when drawBuffer extension or webGL2 are active
         * @param textures defines the render target textures to unbind
         * @param disableGenerateMipMaps defines a boolean indicating that mipmaps must not be generated
         * @param onBeforeUnbind defines a function which will be called before the effective unbind
         */
        Engine.prototype.unBindMultiColorAttachmentFramebuffer = function (textures, disableGenerateMipMaps, onBeforeUnbind) {
            if (disableGenerateMipMaps === void 0) { disableGenerateMipMaps = false; }
            this._currentRenderTarget = null;
            // If MSAA, we need to bitblt back to main texture
            var gl = this._gl;
            if (textures[0]._MSAAFramebuffer) {
                gl.bindFramebuffer(gl.READ_FRAMEBUFFER, textures[0]._MSAAFramebuffer);
                gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, textures[0]._framebuffer);
                var attachments = textures[0]._attachments;
                if (!attachments) {
                    attachments = new Array(textures.length);
                    textures[0]._attachments = attachments;
                }
                for (var i = 0; i < textures.length; i++) {
                    var texture = textures[i];
                    for (var j = 0; j < attachments.length; j++) {
                        attachments[j] = gl.NONE;
                    }
                    attachments[i] = gl[this.webGLVersion > 1 ? "COLOR_ATTACHMENT" + i : "COLOR_ATTACHMENT" + i + "_WEBGL"];
                    gl.readBuffer(attachments[i]);
                    gl.drawBuffers(attachments);
                    gl.blitFramebuffer(0, 0, texture.width, texture.height, 0, 0, texture.width, texture.height, gl.COLOR_BUFFER_BIT, gl.NEAREST);
                }
                for (var i = 0; i < attachments.length; i++) {
                    attachments[i] = gl[this.webGLVersion > 1 ? "COLOR_ATTACHMENT" + i : "COLOR_ATTACHMENT" + i + "_WEBGL"];
                }
                gl.drawBuffers(attachments);
            }
            for (var i = 0; i < textures.length; i++) {
                var texture = textures[i];
                if (texture.generateMipMaps && !disableGenerateMipMaps && !texture.isCube) {
                    this._bindTextureDirectly(gl.TEXTURE_2D, texture);
                    gl.generateMipmap(gl.TEXTURE_2D);
                    this._bindTextureDirectly(gl.TEXTURE_2D, null);
                }
            }
            if (onBeforeUnbind) {
                if (textures[0]._MSAAFramebuffer) {
                    // Bind the correct framebuffer
                    this.bindUnboundFramebuffer(textures[0]._framebuffer);
                }
                onBeforeUnbind();
            }
            this.bindUnboundFramebuffer(null);
        };
        /**
         * Force the mipmap generation for the given render target texture
         * @param texture defines the render target texture to use
         */
        Engine.prototype.generateMipMapsForCubemap = function (texture) {
            if (texture.generateMipMaps) {
                var gl = this._gl;
                this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            }
        };
        /**
         * Force a webGL flush (ie. a flush of all waiting webGL commands)
         */
        Engine.prototype.flushFramebuffer = function () {
            this._gl.flush();
        };
        /**
         * Unbind the current render target and bind the default framebuffer
         */
        Engine.prototype.restoreDefaultFramebuffer = function () {
            if (this._currentRenderTarget) {
                this.unBindFramebuffer(this._currentRenderTarget);
            }
            else {
                this.bindUnboundFramebuffer(null);
            }
            if (this._cachedViewport) {
                this.setViewport(this._cachedViewport);
            }
            this.wipeCaches();
        };
        // UBOs
        /**
         * Create an uniform buffer
         * @see http://doc.babylonjs.com/features/webgl2#uniform-buffer-objets
         * @param elements defines the content of the uniform buffer
         * @returns the webGL uniform buffer
         */
        Engine.prototype.createUniformBuffer = function (elements) {
            var ubo = this._gl.createBuffer();
            if (!ubo) {
                throw new Error("Unable to create uniform buffer");
            }
            this.bindUniformBuffer(ubo);
            if (elements instanceof Float32Array) {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, elements, this._gl.STATIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, new Float32Array(elements), this._gl.STATIC_DRAW);
            }
            this.bindUniformBuffer(null);
            ubo.references = 1;
            return ubo;
        };
        /**
         * Create a dynamic uniform buffer
         * @see http://doc.babylonjs.com/features/webgl2#uniform-buffer-objets
         * @param elements defines the content of the uniform buffer
         * @returns the webGL uniform buffer
         */
        Engine.prototype.createDynamicUniformBuffer = function (elements) {
            var ubo = this._gl.createBuffer();
            if (!ubo) {
                throw new Error("Unable to create dynamic uniform buffer");
            }
            this.bindUniformBuffer(ubo);
            if (elements instanceof Float32Array) {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, elements, this._gl.DYNAMIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, new Float32Array(elements), this._gl.DYNAMIC_DRAW);
            }
            this.bindUniformBuffer(null);
            ubo.references = 1;
            return ubo;
        };
        /**
         * Update an existing uniform buffer
         * @see http://doc.babylonjs.com/features/webgl2#uniform-buffer-objets
         * @param uniformBuffer defines the target uniform buffer
         * @param elements defines the content to update
         * @param offset defines the offset in the uniform buffer where update should start
         * @param count defines the size of the data to update
         */
        Engine.prototype.updateUniformBuffer = function (uniformBuffer, elements, offset, count) {
            this.bindUniformBuffer(uniformBuffer);
            if (offset === undefined) {
                offset = 0;
            }
            if (count === undefined) {
                if (elements instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, offset, elements);
                }
                else {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, offset, new Float32Array(elements));
                }
            }
            else {
                if (elements instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, 0, elements.subarray(offset, offset + count));
                }
                else {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, 0, new Float32Array(elements).subarray(offset, offset + count));
                }
            }
            this.bindUniformBuffer(null);
        };
        // VBOs
        Engine.prototype._resetVertexBufferBinding = function () {
            this.bindArrayBuffer(null);
            this._cachedVertexBuffers = null;
        };
        /**
         * Creates a vertex buffer
         * @param data the data for the vertex buffer
         * @returns the new WebGL static buffer
         */
        Engine.prototype.createVertexBuffer = function (data) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create vertex buffer");
            }
            this.bindArrayBuffer(vbo);
            if (data instanceof Array) {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array(data), this._gl.STATIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, data, this._gl.STATIC_DRAW);
            }
            this._resetVertexBufferBinding();
            vbo.references = 1;
            return vbo;
        };
        /**
         * Creates a dynamic vertex buffer
         * @param data the data for the dynamic vertex buffer
         * @returns the new WebGL dynamic buffer
         */
        Engine.prototype.createDynamicVertexBuffer = function (data) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create dynamic vertex buffer");
            }
            this.bindArrayBuffer(vbo);
            if (data instanceof Array) {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array(data), this._gl.DYNAMIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, data, this._gl.DYNAMIC_DRAW);
            }
            this._resetVertexBufferBinding();
            vbo.references = 1;
            return vbo;
        };
        /**
         * Update a dynamic index buffer
         * @param indexBuffer defines the target index buffer
         * @param indices defines the data to update
         * @param offset defines the offset in the target index buffer where update should start
         */
        Engine.prototype.updateDynamicIndexBuffer = function (indexBuffer, indices, offset) {
            if (offset === void 0) { offset = 0; }
            // Force cache update
            this._currentBoundBuffer[this._gl.ELEMENT_ARRAY_BUFFER] = null;
            this.bindIndexBuffer(indexBuffer);
            var arrayBuffer;
            if (indices instanceof Uint16Array || indices instanceof Uint32Array) {
                arrayBuffer = indices;
            }
            else {
                arrayBuffer = indexBuffer.is32Bits ? new Uint32Array(indices) : new Uint16Array(indices);
            }
            this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER, arrayBuffer, this._gl.DYNAMIC_DRAW);
            this._resetIndexBufferBinding();
        };
        /**
         * Updates a dynamic vertex buffer.
         * @param vertexBuffer the vertex buffer to update
         * @param data the data used to update the vertex buffer
         * @param byteOffset the byte offset of the data
         * @param byteLength the byte length of the data
         */
        Engine.prototype.updateDynamicVertexBuffer = function (vertexBuffer, data, byteOffset, byteLength) {
            this.bindArrayBuffer(vertexBuffer);
            if (byteOffset === undefined) {
                byteOffset = 0;
            }
            if (byteLength === undefined) {
                if (data instanceof Array) {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, byteOffset, new Float32Array(data));
                }
                else {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, byteOffset, data);
                }
            }
            else {
                if (data instanceof Array) {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, new Float32Array(data).subarray(byteOffset, byteOffset + byteLength));
                }
                else {
                    if (data instanceof ArrayBuffer) {
                        data = new Uint8Array(data, byteOffset, byteLength);
                    }
                    else {
                        data = new Uint8Array(data.buffer, data.byteOffset + byteOffset, byteLength);
                    }
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, data);
                }
            }
            this._resetVertexBufferBinding();
        };
        Engine.prototype._resetIndexBufferBinding = function () {
            this.bindIndexBuffer(null);
            this._cachedIndexBuffer = null;
        };
        /**
         * Creates a new index buffer
         * @param indices defines the content of the index buffer
         * @param updatable defines if the index buffer must be updatable
         * @returns a new webGL buffer
         */
        Engine.prototype.createIndexBuffer = function (indices, updatable) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create index buffer");
            }
            this.bindIndexBuffer(vbo);
            // Check for 32 bits indices
            var arrayBuffer;
            var need32Bits = false;
            if (indices instanceof Uint16Array) {
                arrayBuffer = indices;
            }
            else {
                //check 32 bit support
                if (this._caps.uintIndices) {
                    if (indices instanceof Uint32Array) {
                        arrayBuffer = indices;
                        need32Bits = true;
                    }
                    else {
                        //number[] or Int32Array, check if 32 bit is necessary
                        for (var index = 0; index < indices.length; index++) {
                            if (indices[index] > 65535) {
                                need32Bits = true;
                                break;
                            }
                        }
                        arrayBuffer = need32Bits ? new Uint32Array(indices) : new Uint16Array(indices);
                    }
                }
                else {
                    //no 32 bit support, force conversion to 16 bit (values greater 16 bit are lost)
                    arrayBuffer = new Uint16Array(indices);
                }
            }
            this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER, arrayBuffer, updatable ? this._gl.DYNAMIC_DRAW : this._gl.STATIC_DRAW);
            this._resetIndexBufferBinding();
            vbo.references = 1;
            vbo.is32Bits = need32Bits;
            return vbo;
        };
        /**
         * Bind a webGL buffer to the webGL context
         * @param buffer defines the buffer to bind
         */
        Engine.prototype.bindArrayBuffer = function (buffer) {
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.bindBuffer(buffer, this._gl.ARRAY_BUFFER);
        };
        /**
         * Bind an uniform buffer to the current webGL context
         * @param buffer defines the buffer to bind
         */
        Engine.prototype.bindUniformBuffer = function (buffer) {
            this._gl.bindBuffer(this._gl.UNIFORM_BUFFER, buffer);
        };
        /**
         * Bind a buffer to the current webGL context at a given location
         * @param buffer defines the buffer to bind
         * @param location defines the index where to bind the buffer
         */
        Engine.prototype.bindUniformBufferBase = function (buffer, location) {
            this._gl.bindBufferBase(this._gl.UNIFORM_BUFFER, location, buffer);
        };
        /**
         * Bind a specific block at a given index in a specific shader program
         * @param shaderProgram defines the shader program
         * @param blockName defines the block name
         * @param index defines the index where to bind the block
         */
        Engine.prototype.bindUniformBlock = function (shaderProgram, blockName, index) {
            var uniformLocation = this._gl.getUniformBlockIndex(shaderProgram, blockName);
            this._gl.uniformBlockBinding(shaderProgram, uniformLocation, index);
        };
        ;
        Engine.prototype.bindIndexBuffer = function (buffer) {
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.bindBuffer(buffer, this._gl.ELEMENT_ARRAY_BUFFER);
        };
        Engine.prototype.bindBuffer = function (buffer, target) {
            if (this._vaoRecordInProgress || this._currentBoundBuffer[target] !== buffer) {
                this._gl.bindBuffer(target, buffer);
                this._currentBoundBuffer[target] = buffer;
            }
        };
        /**
         * update the bound buffer with the given data
         * @param data defines the data to update
         */
        Engine.prototype.updateArrayBuffer = function (data) {
            this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, data);
        };
        Engine.prototype._vertexAttribPointer = function (buffer, indx, size, type, normalized, stride, offset) {
            var pointer = this._currentBufferPointers[indx];
            var changed = false;
            if (!pointer.active) {
                changed = true;
                pointer.active = true;
                pointer.index = indx;
                pointer.size = size;
                pointer.type = type;
                pointer.normalized = normalized;
                pointer.stride = stride;
                pointer.offset = offset;
                pointer.buffer = buffer;
            }
            else {
                if (pointer.buffer !== buffer) {
                    pointer.buffer = buffer;
                    changed = true;
                }
                if (pointer.size !== size) {
                    pointer.size = size;
                    changed = true;
                }
                if (pointer.type !== type) {
                    pointer.type = type;
                    changed = true;
                }
                if (pointer.normalized !== normalized) {
                    pointer.normalized = normalized;
                    changed = true;
                }
                if (pointer.stride !== stride) {
                    pointer.stride = stride;
                    changed = true;
                }
                if (pointer.offset !== offset) {
                    pointer.offset = offset;
                    changed = true;
                }
            }
            if (changed || this._vaoRecordInProgress) {
                this.bindArrayBuffer(buffer);
                this._gl.vertexAttribPointer(indx, size, type, normalized, stride, offset);
            }
        };
        Engine.prototype._bindIndexBufferWithCache = function (indexBuffer) {
            if (indexBuffer == null) {
                return;
            }
            if (this._cachedIndexBuffer !== indexBuffer) {
                this._cachedIndexBuffer = indexBuffer;
                this.bindIndexBuffer(indexBuffer);
                this._uintIndicesCurrentlySet = indexBuffer.is32Bits;
            }
        };
        Engine.prototype._bindVertexBuffersAttributes = function (vertexBuffers, effect) {
            var attributes = effect.getAttributesNames();
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.unbindAllAttributes();
            for (var index = 0; index < attributes.length; index++) {
                var order = effect.getAttributeLocation(index);
                if (order >= 0) {
                    var vertexBuffer = vertexBuffers[attributes[index]];
                    if (!vertexBuffer) {
                        continue;
                    }
                    this._gl.enableVertexAttribArray(order);
                    if (!this._vaoRecordInProgress) {
                        this._vertexAttribArraysEnabled[order] = true;
                    }
                    var buffer = vertexBuffer.getBuffer();
                    if (buffer) {
                        this._vertexAttribPointer(buffer, order, vertexBuffer.getSize(), vertexBuffer.type, vertexBuffer.normalized, vertexBuffer.byteStride, vertexBuffer.byteOffset);
                        if (vertexBuffer.getIsInstanced()) {
                            this._gl.vertexAttribDivisor(order, vertexBuffer.getInstanceDivisor());
                            if (!this._vaoRecordInProgress) {
                                this._currentInstanceLocations.push(order);
                                this._currentInstanceBuffers.push(buffer);
                            }
                        }
                    }
                }
            }
        };
        /**
         * Records a vertex array object
         * @see http://doc.babylonjs.com/features/webgl2#vertex-array-objects
         * @param vertexBuffers defines the list of vertex buffers to store
         * @param indexBuffer defines the index buffer to store
         * @param effect defines the effect to store
         * @returns the new vertex array object
         */
        Engine.prototype.recordVertexArrayObject = function (vertexBuffers, indexBuffer, effect) {
            var vao = this._gl.createVertexArray();
            this._vaoRecordInProgress = true;
            this._gl.bindVertexArray(vao);
            this._mustWipeVertexAttributes = true;
            this._bindVertexBuffersAttributes(vertexBuffers, effect);
            this.bindIndexBuffer(indexBuffer);
            this._vaoRecordInProgress = false;
            this._gl.bindVertexArray(null);
            return vao;
        };
        /**
         * Bind a specific vertex array object
         * @see http://doc.babylonjs.com/features/webgl2#vertex-array-objects
         * @param vertexArrayObject defines the vertex array object to bind
         * @param indexBuffer defines the index buffer to bind
         */
        Engine.prototype.bindVertexArrayObject = function (vertexArrayObject, indexBuffer) {
            if (this._cachedVertexArrayObject !== vertexArrayObject) {
                this._cachedVertexArrayObject = vertexArrayObject;
                this._gl.bindVertexArray(vertexArrayObject);
                this._cachedVertexBuffers = null;
                this._cachedIndexBuffer = null;
                this._uintIndicesCurrentlySet = indexBuffer != null && indexBuffer.is32Bits;
                this._mustWipeVertexAttributes = true;
            }
        };
        /**
         * Bind webGl buffers directly to the webGL context
         * @param vertexBuffer defines the vertex buffer to bind
         * @param indexBuffer defines the index buffer to bind
         * @param vertexDeclaration defines the vertex declaration to use with the vertex buffer
         * @param vertexStrideSize defines the vertex stride of the vertex buffer
         * @param effect defines the effect associated with the vertex buffer
         */
        Engine.prototype.bindBuffersDirectly = function (vertexBuffer, indexBuffer, vertexDeclaration, vertexStrideSize, effect) {
            if (this._cachedVertexBuffers !== vertexBuffer || this._cachedEffectForVertexBuffers !== effect) {
                this._cachedVertexBuffers = vertexBuffer;
                this._cachedEffectForVertexBuffers = effect;
                var attributesCount = effect.getAttributesCount();
                this._unbindVertexArrayObject();
                this.unbindAllAttributes();
                var offset = 0;
                for (var index = 0; index < attributesCount; index++) {
                    if (index < vertexDeclaration.length) {
                        var order = effect.getAttributeLocation(index);
                        if (order >= 0) {
                            this._gl.enableVertexAttribArray(order);
                            this._vertexAttribArraysEnabled[order] = true;
                            this._vertexAttribPointer(vertexBuffer, order, vertexDeclaration[index], this._gl.FLOAT, false, vertexStrideSize, offset);
                        }
                        offset += vertexDeclaration[index] * 4;
                    }
                }
            }
            this._bindIndexBufferWithCache(indexBuffer);
        };
        Engine.prototype._unbindVertexArrayObject = function () {
            if (!this._cachedVertexArrayObject) {
                return;
            }
            this._cachedVertexArrayObject = null;
            this._gl.bindVertexArray(null);
        };
        /**
         * Bind a list of vertex buffers to the webGL context
         * @param vertexBuffers defines the list of vertex buffers to bind
         * @param indexBuffer defines the index buffer to bind
         * @param effect defines the effect associated with the vertex buffers
         */
        Engine.prototype.bindBuffers = function (vertexBuffers, indexBuffer, effect) {
            if (this._cachedVertexBuffers !== vertexBuffers || this._cachedEffectForVertexBuffers !== effect) {
                this._cachedVertexBuffers = vertexBuffers;
                this._cachedEffectForVertexBuffers = effect;
                this._bindVertexBuffersAttributes(vertexBuffers, effect);
            }
            this._bindIndexBufferWithCache(indexBuffer);
        };
        /**
         * Unbind all instance attributes
         */
        Engine.prototype.unbindInstanceAttributes = function () {
            var boundBuffer;
            for (var i = 0, ul = this._currentInstanceLocations.length; i < ul; i++) {
                var instancesBuffer = this._currentInstanceBuffers[i];
                if (boundBuffer != instancesBuffer && instancesBuffer.references) {
                    boundBuffer = instancesBuffer;
                    this.bindArrayBuffer(instancesBuffer);
                }
                var offsetLocation = this._currentInstanceLocations[i];
                this._gl.vertexAttribDivisor(offsetLocation, 0);
            }
            this._currentInstanceBuffers.length = 0;
            this._currentInstanceLocations.length = 0;
        };
        /**
         * Release and free the memory of a vertex array object
         * @param vao defines the vertex array object to delete
         */
        Engine.prototype.releaseVertexArrayObject = function (vao) {
            this._gl.deleteVertexArray(vao);
        };
        /** @hidden */
        Engine.prototype._releaseBuffer = function (buffer) {
            buffer.references--;
            if (buffer.references === 0) {
                this._gl.deleteBuffer(buffer);
                return true;
            }
            return false;
        };
        /**
         * Creates a webGL buffer to use with instanciation
         * @param capacity defines the size of the buffer
         * @returns the webGL buffer
         */
        Engine.prototype.createInstancesBuffer = function (capacity) {
            var buffer = this._gl.createBuffer();
            if (!buffer) {
                throw new Error("Unable to create instance buffer");
            }
            buffer.capacity = capacity;
            this.bindArrayBuffer(buffer);
            this._gl.bufferData(this._gl.ARRAY_BUFFER, capacity, this._gl.DYNAMIC_DRAW);
            return buffer;
        };
        /**
         * Delete a webGL buffer used with instanciation
         * @param buffer defines the webGL buffer to delete
         */
        Engine.prototype.deleteInstancesBuffer = function (buffer) {
            this._gl.deleteBuffer(buffer);
        };
        /**
         * Update the content of a webGL buffer used with instanciation and bind it to the webGL context
         * @param instancesBuffer defines the webGL buffer to update and bind
         * @param data defines the data to store in the buffer
         * @param offsetLocations defines the offsets or attributes information used to determine where data must be stored in the buffer
         */
        Engine.prototype.updateAndBindInstancesBuffer = function (instancesBuffer, data, offsetLocations) {
            this.bindArrayBuffer(instancesBuffer);
            if (data) {
                this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, data);
            }
            if (offsetLocations[0].index !== undefined) {
                var stride = 0;
                for (var i = 0; i < offsetLocations.length; i++) {
                    var ai = offsetLocations[i];
                    stride += ai.attributeSize * 4;
                }
                for (var i = 0; i < offsetLocations.length; i++) {
                    var ai = offsetLocations[i];
                    if (!this._vertexAttribArraysEnabled[ai.index]) {
                        this._gl.enableVertexAttribArray(ai.index);
                        this._vertexAttribArraysEnabled[ai.index] = true;
                    }
                    this._vertexAttribPointer(instancesBuffer, ai.index, ai.attributeSize, ai.attribyteType || this._gl.FLOAT, ai.normalized || false, stride, ai.offset);
                    this._gl.vertexAttribDivisor(ai.index, 1);
                    this._currentInstanceLocations.push(ai.index);
                    this._currentInstanceBuffers.push(instancesBuffer);
                }
            }
            else {
                for (var index = 0; index < 4; index++) {
                    var offsetLocation = offsetLocations[index];
                    if (!this._vertexAttribArraysEnabled[offsetLocation]) {
                        this._gl.enableVertexAttribArray(offsetLocation);
                        this._vertexAttribArraysEnabled[offsetLocation] = true;
                    }
                    this._vertexAttribPointer(instancesBuffer, offsetLocation, 4, this._gl.FLOAT, false, 64, index * 16);
                    this._gl.vertexAttribDivisor(offsetLocation, 1);
                    this._currentInstanceLocations.push(offsetLocation);
                    this._currentInstanceBuffers.push(instancesBuffer);
                }
            }
        };
        /**
         * Apply all cached states (depth, culling, stencil and alpha)
         */
        Engine.prototype.applyStates = function () {
            this._depthCullingState.apply(this._gl);
            this._stencilState.apply(this._gl);
            this._alphaState.apply(this._gl);
        };
        /**
         * Send a draw order
         * @param useTriangles defines if triangles must be used to draw (else wireframe will be used)
         * @param indexStart defines the starting index
         * @param indexCount defines the number of index to draw
         * @param instancesCount defines the number of instances to draw (if instanciation is enabled)
         */
        Engine.prototype.draw = function (useTriangles, indexStart, indexCount, instancesCount) {
            this.drawElementsType(useTriangles ? BABYLON.Material.TriangleFillMode : BABYLON.Material.WireFrameFillMode, indexStart, indexCount, instancesCount);
        };
        /**
         * Draw a list of points
         * @param verticesStart defines the index of first vertex to draw
         * @param verticesCount defines the count of vertices to draw
         * @param instancesCount defines the number of instances to draw (if instanciation is enabled)
         */
        Engine.prototype.drawPointClouds = function (verticesStart, verticesCount, instancesCount) {
            this.drawArraysType(BABYLON.Material.PointFillMode, verticesStart, verticesCount, instancesCount);
        };
        /**
         * Draw a list of unindexed primitives
         * @param useTriangles defines if triangles must be used to draw (else wireframe will be used)
         * @param verticesStart defines the index of first vertex to draw
         * @param verticesCount defines the count of vertices to draw
         * @param instancesCount defines the number of instances to draw (if instanciation is enabled)
         */
        Engine.prototype.drawUnIndexed = function (useTriangles, verticesStart, verticesCount, instancesCount) {
            this.drawArraysType(useTriangles ? BABYLON.Material.TriangleFillMode : BABYLON.Material.WireFrameFillMode, verticesStart, verticesCount, instancesCount);
        };
        /**
         * Draw a list of indexed primitives
         * @param fillMode defines the primitive to use
         * @param indexStart defines the starting index
         * @param indexCount defines the number of index to draw
         * @param instancesCount defines the number of instances to draw (if instanciation is enabled)
         */
        Engine.prototype.drawElementsType = function (fillMode, indexStart, indexCount, instancesCount) {
            // Apply states
            this.applyStates();
            this._drawCalls.addCount(1, false);
            // Render
            var drawMode = this._drawMode(fillMode);
            var indexFormat = this._uintIndicesCurrentlySet ? this._gl.UNSIGNED_INT : this._gl.UNSIGNED_SHORT;
            var mult = this._uintIndicesCurrentlySet ? 4 : 2;
            if (instancesCount) {
                this._gl.drawElementsInstanced(drawMode, indexCount, indexFormat, indexStart * mult, instancesCount);
            }
            else {
                this._gl.drawElements(drawMode, indexCount, indexFormat, indexStart * mult);
            }
        };
        /**
         * Draw a list of unindexed primitives
         * @param fillMode defines the primitive to use
         * @param verticesStart defines the index of first vertex to draw
         * @param verticesCount defines the count of vertices to draw
         * @param instancesCount defines the number of instances to draw (if instanciation is enabled)
         */
        Engine.prototype.drawArraysType = function (fillMode, verticesStart, verticesCount, instancesCount) {
            // Apply states
            this.applyStates();
            this._drawCalls.addCount(1, false);
            var drawMode = this._drawMode(fillMode);
            if (instancesCount) {
                this._gl.drawArraysInstanced(drawMode, verticesStart, verticesCount, instancesCount);
            }
            else {
                this._gl.drawArrays(drawMode, verticesStart, verticesCount);
            }
        };
        Engine.prototype._drawMode = function (fillMode) {
            switch (fillMode) {
                // Triangle views
                case BABYLON.Material.TriangleFillMode:
                    return this._gl.TRIANGLES;
                case BABYLON.Material.PointFillMode:
                    return this._gl.POINTS;
                case BABYLON.Material.WireFrameFillMode:
                    return this._gl.LINES;
                // Draw modes
                case BABYLON.Material.PointListDrawMode:
                    return this._gl.POINTS;
                case BABYLON.Material.LineListDrawMode:
                    return this._gl.LINES;
                case BABYLON.Material.LineLoopDrawMode:
                    return this._gl.LINE_LOOP;
                case BABYLON.Material.LineStripDrawMode:
                    return this._gl.LINE_STRIP;
                case BABYLON.Material.TriangleStripDrawMode:
                    return this._gl.TRIANGLE_STRIP;
                case BABYLON.Material.TriangleFanDrawMode:
                    return this._gl.TRIANGLE_FAN;
                default:
                    return this._gl.TRIANGLES;
            }
        };
        // Shaders
        /** @hidden */
        Engine.prototype._releaseEffect = function (effect) {
            if (this._compiledEffects[effect._key]) {
                delete this._compiledEffects[effect._key];
                this._deleteProgram(effect.getProgram());
            }
        };
        /** @hidden */
        Engine.prototype._deleteProgram = function (program) {
            if (program) {
                program.__SPECTOR_rebuildProgram = null;
                if (program.transformFeedback) {
                    this.deleteTransformFeedback(program.transformFeedback);
                    program.transformFeedback = null;
                }
                this._gl.deleteProgram(program);
            }
        };
        /**
         * Create a new effect (used to store vertex/fragment shaders)
         * @param baseName defines the base name of the effect (The name of file without .fragment.fx or .vertex.fx)
         * @param attributesNamesOrOptions defines either a list of attribute names or an EffectCreationOptions object
         * @param uniformsNamesOrEngine defines either a list of uniform names or the engine to use
         * @param samplers defines an array of string used to represent textures
         * @param defines defines the string containing the defines to use to compile the shaders
         * @param fallbacks defines the list of potential fallbacks to use if shader conmpilation fails
         * @param onCompiled defines a function to call when the effect creation is successful
         * @param onError defines a function to call when the effect creation has failed
         * @param indexParameters defines an object containing the index values to use to compile shaders (like the maximum number of simultaneous lights)
         * @returns the new Effect
         */
        Engine.prototype.createEffect = function (baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers, defines, fallbacks, onCompiled, onError, indexParameters) {
            var vertex = baseName.vertexElement || baseName.vertex || baseName;
            var fragment = baseName.fragmentElement || baseName.fragment || baseName;
            var name = vertex + "+" + fragment + "@" + (defines ? defines : attributesNamesOrOptions.defines);
            if (this._compiledEffects[name]) {
                var compiledEffect = this._compiledEffects[name];
                if (onCompiled && compiledEffect.isReady()) {
                    onCompiled(compiledEffect);
                }
                return compiledEffect;
            }
            var effect = new BABYLON.Effect(baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers, this, defines, fallbacks, onCompiled, onError, indexParameters);
            effect._key = name;
            this._compiledEffects[name] = effect;
            return effect;
        };
        /**
         * Create an effect to use with particle systems
         * @param fragmentName defines the base name of the effect (The name of file without .fragment.fx)
         * @param uniformsNames defines a list of attribute names
         * @param samplers defines an array of string used to represent textures
         * @param defines defines the string containing the defines to use to compile the shaders
         * @param fallbacks defines the list of potential fallbacks to use if shader conmpilation fails
         * @param onCompiled defines a function to call when the effect creation is successful
         * @param onError defines a function to call when the effect creation has failed
         * @returns the new Effect
         */
        Engine.prototype.createEffectForParticles = function (fragmentName, uniformsNames, samplers, defines, fallbacks, onCompiled, onError) {
            if (uniformsNames === void 0) { uniformsNames = []; }
            if (samplers === void 0) { samplers = []; }
            if (defines === void 0) { defines = ""; }
            return this.createEffect({
                vertex: "particles",
                fragmentElement: fragmentName
            }, ["position", "color", "options"], ["view", "projection"].concat(uniformsNames), ["diffuseSampler"].concat(samplers), defines, fallbacks, onCompiled, onError);
        };
        /**
         * Directly creates a webGL program
         * @param vertexCode defines the vertex shader code to use
         * @param fragmentCode defines the fragment shader code to use
         * @param context defines the webGL context to use (if not set, the current one will be used)
         * @param transformFeedbackVaryings defines the list of transform feedback varyings to use
         * @returns the new webGL program
         */
        Engine.prototype.createRawShaderProgram = function (vertexCode, fragmentCode, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            context = context || this._gl;
            var vertexShader = compileRawShader(context, vertexCode, "vertex");
            var fragmentShader = compileRawShader(context, fragmentCode, "fragment");
            return this._createShaderProgram(vertexShader, fragmentShader, context, transformFeedbackVaryings);
        };
        /**
         * Creates a webGL program
         * @param vertexCode  defines the vertex shader code to use
         * @param fragmentCode defines the fragment shader code to use
         * @param defines defines the string containing the defines to use to compile the shaders
         * @param context defines the webGL context to use (if not set, the current one will be used)
         * @param transformFeedbackVaryings defines the list of transform feedback varyings to use
         * @returns the new webGL program
         */
        Engine.prototype.createShaderProgram = function (vertexCode, fragmentCode, defines, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            context = context || this._gl;
            this.onBeforeShaderCompilationObservable.notifyObservers(this);
            var shaderVersion = (this._webGLVersion > 1) ? "#version 300 es\n#define WEBGL2 \n" : "";
            var vertexShader = compileShader(context, vertexCode, "vertex", defines, shaderVersion);
            var fragmentShader = compileShader(context, fragmentCode, "fragment", defines, shaderVersion);
            var program = this._createShaderProgram(vertexShader, fragmentShader, context, transformFeedbackVaryings);
            this.onAfterShaderCompilationObservable.notifyObservers(this);
            return program;
        };
        Engine.prototype._createShaderProgram = function (vertexShader, fragmentShader, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            var shaderProgram = context.createProgram();
            if (!shaderProgram) {
                throw new Error("Unable to create program");
            }
            context.attachShader(shaderProgram, vertexShader);
            context.attachShader(shaderProgram, fragmentShader);
            if (this.webGLVersion > 1 && transformFeedbackVaryings) {
                var transformFeedback = this.createTransformFeedback();
                this.bindTransformFeedback(transformFeedback);
                this.setTranformFeedbackVaryings(shaderProgram, transformFeedbackVaryings);
                shaderProgram.transformFeedback = transformFeedback;
            }
            context.linkProgram(shaderProgram);
            if (this.webGLVersion > 1 && transformFeedbackVaryings) {
                this.bindTransformFeedback(null);
            }
            var linked = context.getProgramParameter(shaderProgram, context.LINK_STATUS);
            if (!linked) {
                context.validateProgram(shaderProgram);
                var error = context.getProgramInfoLog(shaderProgram);
                if (error) {
                    throw new Error(error);
                }
            }
            context.deleteShader(vertexShader);
            context.deleteShader(fragmentShader);
            return shaderProgram;
        };
        /**
         * Gets the list of webGL uniform locations associated with a specific program based on a list of uniform names
         * @param shaderProgram defines the webGL program to use
         * @param uniformsNames defines the list of uniform names
         * @returns an array of webGL uniform locations
         */
        Engine.prototype.getUniforms = function (shaderProgram, uniformsNames) {
            var results = new Array();
            for (var index = 0; index < uniformsNames.length; index++) {
                results.push(this._gl.getUniformLocation(shaderProgram, uniformsNames[index]));
            }
            return results;
        };
        /**
         * Gets the lsit of active attributes for a given webGL program
         * @param shaderProgram defines the webGL program to use
         * @param attributesNames defines the list of attribute names to get
         * @returns an array of indices indicating the offset of each attribute
         */
        Engine.prototype.getAttributes = function (shaderProgram, attributesNames) {
            var results = [];
            for (var index = 0; index < attributesNames.length; index++) {
                try {
                    results.push(this._gl.getAttribLocation(shaderProgram, attributesNames[index]));
                }
                catch (e) {
                    results.push(-1);
                }
            }
            return results;
        };
        /**
         * Activates an effect, mkaing it the current one (ie. the one used for rendering)
         * @param effect defines the effect to activate
         */
        Engine.prototype.enableEffect = function (effect) {
            if (!effect) {
                return;
            }
            // Use program
            this.bindSamplers(effect);
            this._currentEffect = effect;
            if (effect.onBind) {
                effect.onBind(effect);
            }
            effect.onBindObservable.notifyObservers(effect);
        };
        /**
         * Set the value of an uniform to an array of int32
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of int32 to store
         */
        Engine.prototype.setIntArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1iv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of int32 (stored as vec2)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of int32 to store
         */
        Engine.prototype.setIntArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2iv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of int32 (stored as vec3)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of int32 to store
         */
        Engine.prototype.setIntArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3iv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of int32 (stored as vec4)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of int32 to store
         */
        Engine.prototype.setIntArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4iv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of float32
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of float32 to store
         */
        Engine.prototype.setFloatArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of float32 (stored as vec2)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of float32 to store
         */
        Engine.prototype.setFloatArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of float32 (stored as vec3)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of float32 to store
         */
        Engine.prototype.setFloatArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of float32 (stored as vec4)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of float32 to store
         */
        Engine.prototype.setFloatArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of number
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of number to store
         */
        Engine.prototype.setArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of number (stored as vec2)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of number to store
         */
        Engine.prototype.setArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of number (stored as vec3)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of number to store
         */
        Engine.prototype.setArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of number (stored as vec4)
         * @param uniform defines the webGL uniform location where to store the value
         * @param array defines the array of number to store
         */
        Engine.prototype.setArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4fv(uniform, array);
        };
        /**
         * Set the value of an uniform to an array of float32 (stored as matrices)
         * @param uniform defines the webGL uniform location where to store the value
         * @param matrices defines the array of float32 to store
         */
        Engine.prototype.setMatrices = function (uniform, matrices) {
            if (!uniform)
                return;
            this._gl.uniformMatrix4fv(uniform, false, matrices);
        };
        /**
         * Set the value of an uniform to a matrix
         * @param uniform defines the webGL uniform location where to store the value
         * @param matrix defines the matrix to store
         */
        Engine.prototype.setMatrix = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix4fv(uniform, false, matrix.toArray());
        };
        /**
         * Set the value of an uniform to a matrix (3x3)
         * @param uniform defines the webGL uniform location where to store the value
         * @param matrix defines the Float32Array representing the 3x3 matrix to store
         */
        Engine.prototype.setMatrix3x3 = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix3fv(uniform, false, matrix);
        };
        /**
         * Set the value of an uniform to a matrix (2x2)
         * @param uniform defines the webGL uniform location where to store the value
         * @param matrix defines the Float32Array representing the 2x2 matrix to store
         */
        Engine.prototype.setMatrix2x2 = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix2fv(uniform, false, matrix);
        };
        /**
         * Set the value of an uniform to a number (int)
         * @param uniform defines the webGL uniform location where to store the value
         * @param value defines the int number to store
         */
        Engine.prototype.setInt = function (uniform, value) {
            if (!uniform)
                return;
            this._gl.uniform1i(uniform, value);
        };
        /**
         * Set the value of an uniform to a number (float)
         * @param uniform defines the webGL uniform location where to store the value
         * @param value defines the float number to store
         */
        Engine.prototype.setFloat = function (uniform, value) {
            if (!uniform)
                return;
            this._gl.uniform1f(uniform, value);
        };
        /**
         * Set the value of an uniform to a vec2
         * @param uniform defines the webGL uniform location where to store the value
         * @param x defines the 1st component of the value
         * @param y defines the 2nd component of the value
         */
        Engine.prototype.setFloat2 = function (uniform, x, y) {
            if (!uniform)
                return;
            this._gl.uniform2f(uniform, x, y);
        };
        /**
         * Set the value of an uniform to a vec3
         * @param uniform defines the webGL uniform location where to store the value
         * @param x defines the 1st component of the value
         * @param y defines the 2nd component of the value
         * @param z defines the 3rd component of the value
         */
        Engine.prototype.setFloat3 = function (uniform, x, y, z) {
            if (!uniform)
                return;
            this._gl.uniform3f(uniform, x, y, z);
        };
        /**
         * Set the value of an uniform to a boolean
         * @param uniform defines the webGL uniform location where to store the value
         * @param bool defines the boolean to store
         */
        Engine.prototype.setBool = function (uniform, bool) {
            if (!uniform)
                return;
            this._gl.uniform1i(uniform, bool);
        };
        /**
         * Set the value of an uniform to a vec4
         * @param uniform defines the webGL uniform location where to store the value
         * @param x defines the 1st component of the value
         * @param y defines the 2nd component of the value
         * @param z defines the 3rd component of the value
         * @param w defines the 4th component of the value
         */
        Engine.prototype.setFloat4 = function (uniform, x, y, z, w) {
            if (!uniform)
                return;
            this._gl.uniform4f(uniform, x, y, z, w);
        };
        /**
         * Set the value of an uniform to a Color3
         * @param uniform defines the webGL uniform location where to store the value
         * @param color3 defines the color to store
         */
        Engine.prototype.setColor3 = function (uniform, color3) {
            if (!uniform)
                return;
            this._gl.uniform3f(uniform, color3.r, color3.g, color3.b);
        };
        /**
         * Set the value of an uniform to a Color3 and an alpha value
         * @param uniform defines the webGL uniform location where to store the value
         * @param color3 defines the color to store
         * @param alpha defines the alpha component to store
         */
        Engine.prototype.setColor4 = function (uniform, color3, alpha) {
            if (!uniform)
                return;
            this._gl.uniform4f(uniform, color3.r, color3.g, color3.b, alpha);
        };
        /**
         * Sets a Color4 on a uniform variable
         * @param uniform defines the uniform location
         * @param color4 defines the value to be set
         */
        Engine.prototype.setDirectColor4 = function (uniform, color4) {
            if (!uniform)
                return;
            this._gl.uniform4f(uniform, color4.r, color4.g, color4.b, color4.a);
        };
        // States
        /**
         * Set various states to the webGL context
         * @param culling defines backface culling state
         * @param zOffset defines the value to apply to zOffset (0 by default)
         * @param force defines if states must be applied even if cache is up to date
         * @param reverseSide defines if culling must be reversed (CCW instead of CW and CW instead of CCW)
         */
        Engine.prototype.setState = function (culling, zOffset, force, reverseSide) {
            if (zOffset === void 0) { zOffset = 0; }
            if (reverseSide === void 0) { reverseSide = false; }
            // Culling
            if (this._depthCullingState.cull !== culling || force) {
                this._depthCullingState.cull = culling;
            }
            // Cull face
            var cullFace = this.cullBackFaces ? this._gl.BACK : this._gl.FRONT;
            if (this._depthCullingState.cullFace !== cullFace || force) {
                this._depthCullingState.cullFace = cullFace;
            }
            // Z offset
            this.setZOffset(zOffset);
            // Front face
            var frontFace = reverseSide ? this._gl.CW : this._gl.CCW;
            if (this._depthCullingState.frontFace !== frontFace || force) {
                this._depthCullingState.frontFace = frontFace;
            }
        };
        /**
         * Set the z offset to apply to current rendering
         * @param value defines the offset to apply
         */
        Engine.prototype.setZOffset = function (value) {
            this._depthCullingState.zOffset = value;
        };
        /**
         * Gets the current value of the zOffset
         * @returns the current zOffset state
         */
        Engine.prototype.getZOffset = function () {
            return this._depthCullingState.zOffset;
        };
        /**
         * Enable or disable depth buffering
         * @param enable defines the state to set
         */
        Engine.prototype.setDepthBuffer = function (enable) {
            this._depthCullingState.depthTest = enable;
        };
        /**
         * Gets a boolean indicating if depth writing is enabled
         * @returns the current depth writing state
         */
        Engine.prototype.getDepthWrite = function () {
            return this._depthCullingState.depthMask;
        };
        /**
         * Enable or disable depth writing
         * @param enable defines the state to set
         */
        Engine.prototype.setDepthWrite = function (enable) {
            this._depthCullingState.depthMask = enable;
        };
        /**
         * Enable or disable color writing
         * @param enable defines the state to set
         */
        Engine.prototype.setColorWrite = function (enable) {
            this._gl.colorMask(enable, enable, enable, enable);
            this._colorWrite = enable;
        };
        /**
         * Gets a boolean indicating if color writing is enabled
         * @returns the current color writing state
         */
        Engine.prototype.getColorWrite = function () {
            return this._colorWrite;
        };
        /**
         * Sets alpha constants used by some alpha blending modes
         * @param r defines the red component
         * @param g defines the green component
         * @param b defines the blue component
         * @param a defines the alpha component
         */
        Engine.prototype.setAlphaConstants = function (r, g, b, a) {
            this._alphaState.setAlphaBlendConstants(r, g, b, a);
        };
        /**
         * Sets the current alpha mode
         * @param mode defines the mode to use (one of the BABYLON.Engine.ALPHA_XXX)
         * @param noDepthWriteChange defines if depth writing state should remains unchanged (false by default)
         * @see http://doc.babylonjs.com/resources/transparency_and_how_meshes_are_rendered
         */
        Engine.prototype.setAlphaMode = function (mode, noDepthWriteChange) {
            if (noDepthWriteChange === void 0) { noDepthWriteChange = false; }
            if (this._alphaMode === mode) {
                return;
            }
            switch (mode) {
                case Engine.ALPHA_DISABLE:
                    this._alphaState.alphaBlend = false;
                    break;
                case Engine.ALPHA_PREMULTIPLIED:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_PREMULTIPLIED_PORTERDUFF:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_COMBINE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_ONEONE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE, this._gl.ZERO, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_ADD:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE, this._gl.ZERO, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_SUBTRACT:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ZERO, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_MULTIPLY:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.DST_COLOR, this._gl.ZERO, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_MAXIMIZED:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_INTERPOLATE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.CONSTANT_COLOR, this._gl.ONE_MINUS_CONSTANT_COLOR, this._gl.CONSTANT_ALPHA, this._gl.ONE_MINUS_CONSTANT_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_SCREENMODE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
            }
            if (!noDepthWriteChange) {
                this.setDepthWrite(mode === Engine.ALPHA_DISABLE);
            }
            this._alphaMode = mode;
        };
        /**
         * Gets the current alpha mode
         * @see http://doc.babylonjs.com/resources/transparency_and_how_meshes_are_rendered
         * @returns the current alpha mode
         */
        Engine.prototype.getAlphaMode = function () {
            return this._alphaMode;
        };
        // Textures
        /**
         * Force the entire cache to be cleared
         * You should not have to use this function unless your engine needs to share the webGL context with another engine
         * @param bruteForce defines a boolean to force clearing ALL caches (including stencil, detoh and alpha states)
         */
        Engine.prototype.wipeCaches = function (bruteForce) {
            if (this.preventCacheWipeBetweenFrames && !bruteForce) {
                return;
            }
            this._currentEffect = null;
            if (bruteForce) {
                this.resetTextureCache();
                this._currentProgram = null;
                this._stencilState.reset();
                this._depthCullingState.reset();
                this.setDepthFunctionToLessOrEqual();
                this._alphaState.reset();
            }
            this._resetVertexBufferBinding();
            this._cachedIndexBuffer = null;
            this._cachedEffectForVertexBuffers = null;
            this._unbindVertexArrayObject();
            this.bindIndexBuffer(null);
        };
        /**
         * Set the compressed texture format to use, based on the formats you have, and the formats
         * supported by the hardware / browser.
         *
         * Khronos Texture Container (.ktx) files are used to support this.  This format has the
         * advantage of being specifically designed for OpenGL.  Header elements directly correspond
         * to API arguments needed to compressed textures.  This puts the burden on the container
         * generator to house the arcane code for determining these for current & future formats.
         *
         * for description see https://www.khronos.org/opengles/sdk/tools/KTX/
         * for file layout see https://www.khronos.org/opengles/sdk/tools/KTX/file_format_spec/
         *
         * Note: The result of this call is not taken into account when a texture is base64.
         *
         * @param formatsAvailable defines the list of those format families you have created
         * on your server.  Syntax: '-' + format family + '.ktx'.  (Case and order do not matter.)
         *
         * Current families are astc, dxt, pvrtc, etc2, & etc1.
         * @returns The extension selected.
         */
        Engine.prototype.setTextureFormatToUse = function (formatsAvailable) {
            for (var i = 0, len1 = this.texturesSupported.length; i < len1; i++) {
                for (var j = 0, len2 = formatsAvailable.length; j < len2; j++) {
                    if (this._texturesSupported[i] === formatsAvailable[j].toLowerCase()) {
                        return this._textureFormatInUse = this._texturesSupported[i];
                    }
                }
            }
            // actively set format to nothing, to allow this to be called more than once
            // and possibly fail the 2nd time
            this._textureFormatInUse = null;
            return null;
        };
        /** @hidden */
        Engine.prototype._createTexture = function () {
            var texture = this._gl.createTexture();
            if (!texture) {
                throw new Error("Unable to create texture");
            }
            return texture;
        };
        /**
         * Usually called from BABYLON.Texture.ts.
         * Passed information to create a WebGLTexture
         * @param urlArg defines a value which contains one of the following:
         * * A conventional http URL, e.g. 'http://...' or 'file://...'
         * * A base64 string of in-line texture data, e.g. 'data:image/jpg;base64,/...'
         * * An indicator that data being passed using the buffer parameter, e.g. 'data:mytexture.jpg'
         * @param noMipmap defines a boolean indicating that no mipmaps shall be generated.  Ignored for compressed textures.  They must be in the file
         * @param invertY when true, image is flipped when loaded.  You probably want true. Ignored for compressed textures.  Must be flipped in the file
         * @param scene needed for loading to the correct scene
         * @param samplingMode mode with should be used sample / access the texture (Default: BABYLON.Texture.TRILINEAR_SAMPLINGMODE)
         * @param onLoad optional callback to be called upon successful completion
         * @param onError optional callback to be called upon failure
         * @param buffer a source of a file previously fetched as either an ArrayBuffer (compressed or image format) or HTMLImageElement (image format)
         * @param fallback an internal argument in case the function must be called again, due to etc1 not having alpha capabilities
         * @param format internal format.  Default: RGB when extension is '.jpg' else RGBA.  Ignored for compressed textures
         * @returns a InternalTexture for assignment back into BABYLON.Texture
         */
        Engine.prototype.createTexture = function (urlArg, noMipmap, invertY, scene, samplingMode, onLoad, onError, buffer, fallback, format) {
            var _this = this;
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (buffer === void 0) { buffer = null; }
            if (fallback === void 0) { fallback = null; }
            if (format === void 0) { format = null; }
            var url = String(urlArg); // assign a new string, so that the original is still available in case of fallback
            var fromData = url.substr(0, 5) === "data:";
            var fromBlob = url.substr(0, 5) === "blob:";
            var isBase64 = fromData && url.indexOf("base64") !== -1;
            var texture = fallback ? fallback : new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_URL);
            // establish the file extension, if possible
            var lastDot = url.lastIndexOf('.');
            var extension = (lastDot > 0) ? url.substring(lastDot).toLowerCase() : "";
            var isDDS = this.getCaps().s3tc && (extension.indexOf(".dds") === 0);
            var isTGA = (extension.indexOf(".tga") === 0);
            // determine if a ktx file should be substituted
            var isKTX = false;
            if (this._textureFormatInUse && !isBase64 && !fallback) {
                url = url.substring(0, lastDot) + this._textureFormatInUse;
                isKTX = true;
            }
            if (scene) {
                scene._addPendingData(texture);
            }
            texture.url = url;
            texture.generateMipMaps = !noMipmap;
            texture.samplingMode = samplingMode;
            texture.invertY = invertY;
            if (!this._doNotHandleContextLost) {
                // Keep a link to the buffer only if we plan to handle context lost
                texture._buffer = buffer;
            }
            var onLoadObserver = null;
            if (onLoad && !fallback) {
                onLoadObserver = texture.onLoadedObservable.add(onLoad);
            }
            if (!fallback)
                this._internalTexturesCache.push(texture);
            var onerror = function (message, exception) {
                if (scene) {
                    scene._removePendingData(texture);
                }
                if (onLoadObserver) {
                    texture.onLoadedObservable.remove(onLoadObserver);
                }
                // fallback for when compressed file not found to try again.  For instance, etc1 does not have an alpha capable type
                if (isKTX) {
                    _this.createTexture(urlArg, noMipmap, invertY, scene, samplingMode, null, onError, buffer, texture);
                }
                else if (BABYLON.Tools.UseFallbackTexture) {
                    _this.createTexture(BABYLON.Tools.fallbackTexture, noMipmap, invertY, scene, samplingMode, null, onError, buffer, texture);
                }
                if (onError) {
                    onError(message || "Unknown error", exception);
                }
            };
            var callback = null;
            // processing for non-image formats
            if (isKTX || isTGA || isDDS) {
                if (isKTX) {
                    callback = function (data) {
                        var ktx = new BABYLON.KhronosTextureContainer(data, 1);
                        _this._prepareWebGLTexture(texture, scene, ktx.pixelWidth, ktx.pixelHeight, invertY, false, true, function () {
                            ktx.uploadLevels(_this._gl, !noMipmap);
                            return false;
                        }, samplingMode);
                    };
                }
                else if (isTGA) {
                    callback = function (arrayBuffer) {
                        var data = new Uint8Array(arrayBuffer);
                        var header = BABYLON.TGATools.GetTGAHeader(data);
                        _this._prepareWebGLTexture(texture, scene, header.width, header.height, invertY, noMipmap, false, function () {
                            BABYLON.TGATools.UploadContent(_this._gl, data);
                            return false;
                        }, samplingMode);
                    };
                }
                else if (isDDS) {
                    callback = function (data) {
                        var info = BABYLON.DDSTools.GetDDSInfo(data);
                        var loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap && ((info.width >> (info.mipmapCount - 1)) === 1);
                        _this._prepareWebGLTexture(texture, scene, info.width, info.height, invertY, !loadMipmap, info.isFourCC, function () {
                            BABYLON.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 1);
                            return false;
                        }, samplingMode);
                    };
                }
                if (!buffer) {
                    this._loadFile(url, function (data) {
                        if (callback) {
                            callback(data);
                        }
                    }, undefined, scene ? scene.database : undefined, true, function (request, exception) {
                        onerror("Unable to load " + (request ? request.responseURL : url, exception));
                    });
                }
                else {
                    if (callback) {
                        callback(buffer);
                    }
                }
                // image format processing
            }
            else {
                var onload = function (img) {
                    if (fromBlob && !_this._doNotHandleContextLost) {
                        // We need to store the image if we need to rebuild the texture
                        // in case of a webgl context lost
                        texture._buffer = img;
                    }
                    _this._prepareWebGLTexture(texture, scene, img.width, img.height, invertY, noMipmap, false, function (potWidth, potHeight, continuationCallback) {
                        var gl = _this._gl;
                        var isPot = (img.width === potWidth && img.height === potHeight);
                        var internalFormat = format ? _this._getInternalFormat(format) : ((extension === ".jpg") ? gl.RGB : gl.RGBA);
                        if (isPot) {
                            gl.texImage2D(gl.TEXTURE_2D, 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, img);
                            return false;
                        }
                        // Using shaders to rescale because canvas.drawImage is lossy
                        var source = new BABYLON.InternalTexture(_this, BABYLON.InternalTexture.DATASOURCE_TEMP);
                        _this._bindTextureDirectly(gl.TEXTURE_2D, source, true);
                        gl.texImage2D(gl.TEXTURE_2D, 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, img);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                        _this._rescaleTexture(source, texture, scene, internalFormat, function () {
                            _this._releaseTexture(source);
                            _this._bindTextureDirectly(gl.TEXTURE_2D, texture, true);
                            continuationCallback();
                        });
                        return true;
                    }, samplingMode);
                };
                if (!fromData || isBase64)
                    if (buffer instanceof HTMLImageElement) {
                        onload(buffer);
                    }
                    else {
                        BABYLON.Tools.LoadImage(url, onload, onerror, scene ? scene.database : null);
                    }
                else if (buffer instanceof Array || typeof buffer === "string" || buffer instanceof ArrayBuffer)
                    BABYLON.Tools.LoadImage(buffer, onload, onerror, scene ? scene.database : null);
                else
                    onload(buffer);
            }
            return texture;
        };
        Engine.prototype._rescaleTexture = function (source, destination, scene, internalFormat, onComplete) {
            var _this = this;
            var rtt = this.createRenderTargetTexture({
                width: destination.width,
                height: destination.height,
            }, {
                generateMipMaps: false,
                type: Engine.TEXTURETYPE_UNSIGNED_INT,
                samplingMode: BABYLON.Texture.BILINEAR_SAMPLINGMODE,
                generateDepthBuffer: false,
                generateStencilBuffer: false
            });
            if (!this._rescalePostProcess) {
                this._rescalePostProcess = new BABYLON.PassPostProcess("rescale", 1, null, BABYLON.Texture.BILINEAR_SAMPLINGMODE, this, false, Engine.TEXTURETYPE_UNSIGNED_INT);
            }
            this._rescalePostProcess.getEffect().executeWhenCompiled(function () {
                _this._rescalePostProcess.onApply = function (effect) {
                    effect._bindTexture("textureSampler", source);
                };
                var hostingScene = scene;
                if (!hostingScene) {
                    hostingScene = _this.scenes[_this.scenes.length - 1];
                }
                hostingScene.postProcessManager.directRender([_this._rescalePostProcess], rtt, true);
                _this._bindTextureDirectly(_this._gl.TEXTURE_2D, destination, true);
                _this._gl.copyTexImage2D(_this._gl.TEXTURE_2D, 0, internalFormat, 0, 0, destination.width, destination.height, 0);
                _this.unBindFramebuffer(rtt);
                _this._releaseTexture(rtt);
                if (onComplete) {
                    onComplete();
                }
            });
        };
        /**
         * Update a raw texture
         * @param texture defines the texture to update
         * @param data defines the data to store in the texture
         * @param format defines the format of the data
         * @param invertY defines if data must be stored with Y axis inverted
         * @param compression defines the compression used (null by default)
         * @param type defines the type fo the data (BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT by default)
         */
        Engine.prototype.updateRawTexture = function (texture, data, format, invertY, compression, type) {
            if (compression === void 0) { compression = null; }
            if (type === void 0) { type = Engine.TEXTURETYPE_UNSIGNED_INT; }
            if (!texture) {
                return;
            }
            var internalSizedFomat = this._getRGBABufferInternalSizedFormat(type, format);
            var internalFormat = this._getInternalFormat(format);
            var textureType = this._getWebGLTextureType(type);
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture, true);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
                texture.format = format;
                texture.type = type;
                texture.invertY = invertY;
                texture._compression = compression;
            }
            if (texture.width % 4 !== 0) {
                this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT, 1);
            }
            if (compression && data) {
                this._gl.compressedTexImage2D(this._gl.TEXTURE_2D, 0, this.getCaps().s3tc[compression], texture.width, texture.height, 0, data);
            }
            else {
                this._gl.texImage2D(this._gl.TEXTURE_2D, 0, internalSizedFomat, texture.width, texture.height, 0, internalFormat, textureType, data);
            }
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            //  this.resetTextureCache();
            texture.isReady = true;
        };
        /**
         * Creates a raw texture
         * @param data defines the data to store in the texture
         * @param width defines the width of the texture
         * @param height defines the height of the texture
         * @param format defines the format of the data
         * @param generateMipMaps defines if the engine should generate the mip levels
         * @param invertY defines if data must be stored with Y axis inverted
         * @param samplingMode defines the required sampling mode (BABYLON.Texture.NEAREST_SAMPLINGMODE by default)
         * @param compression defines the compression used (null by default)
         * @param type defines the type fo the data (BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT by default)
         * @returns the raw texture inside an InternalTexture
         */
        Engine.prototype.createRawTexture = function (data, width, height, format, generateMipMaps, invertY, samplingMode, compression, type) {
            if (compression === void 0) { compression = null; }
            if (type === void 0) { type = Engine.TEXTURETYPE_UNSIGNED_INT; }
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RAW);
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = width;
            texture.height = height;
            texture.format = format;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            texture.invertY = invertY;
            texture._compression = compression;
            texture.type = type;
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
            }
            this.updateRawTexture(texture, data, format, invertY, compression, type);
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture, true);
            // Filters
            var filters = getSamplingParameters(samplingMode, generateMipMaps, this._gl);
            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, filters.min);
            if (generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        /**
         * Creates a dynamic texture
         * @param width defines the width of the texture
         * @param height defines the height of the texture
         * @param generateMipMaps defines if the engine should generate the mip levels
         * @param samplingMode defines the required sampling mode (BABYLON.Texture.NEAREST_SAMPLINGMODE by default)
         * @returns the dynamic texture inside an InternalTexture
         */
        Engine.prototype.createDynamicTexture = function (width, height, generateMipMaps, samplingMode) {
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_DYNAMIC);
            texture.baseWidth = width;
            texture.baseHeight = height;
            if (generateMipMaps) {
                width = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(width, this._caps.maxTextureSize) : width;
                height = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(height, this._caps.maxTextureSize) : height;
            }
            //  this.resetTextureCache();
            texture.width = width;
            texture.height = height;
            texture.isReady = false;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            this.updateTextureSamplingMode(samplingMode, texture);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        /**
         * Update the sampling mode of a given texture
         * @param samplingMode defines the required sampling mode
         * @param texture defines the texture to update
         */
        Engine.prototype.updateTextureSamplingMode = function (samplingMode, texture) {
            var filters = getSamplingParameters(samplingMode, texture.generateMipMaps, this._gl);
            if (texture.isCube) {
                this._setTextureParameterInteger(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_MAG_FILTER, filters.mag, texture);
                this._setTextureParameterInteger(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
            }
            else if (texture.is3D) {
                this._setTextureParameterInteger(this._gl.TEXTURE_3D, this._gl.TEXTURE_MAG_FILTER, filters.mag, texture);
                this._setTextureParameterInteger(this._gl.TEXTURE_3D, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            }
            else {
                this._setTextureParameterInteger(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, filters.mag, texture);
                this._setTextureParameterInteger(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            }
            texture.samplingMode = samplingMode;
        };
        /**
         * Update the content of a dynamic texture
         * @param texture defines the texture to update
         * @param canvas defines the canvas containing the source
         * @param invertY defines if data must be stored with Y axis inverted
         * @param premulAlpha defines if alpha is stored as premultiplied
         * @param format defines the format of the data
         */
        Engine.prototype.updateDynamicTexture = function (texture, canvas, invertY, premulAlpha, format) {
            if (premulAlpha === void 0) { premulAlpha = false; }
            if (!texture) {
                return;
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture, true);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY ? 1 : 0);
            if (premulAlpha) {
                this._gl.pixelStorei(this._gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, 1);
            }
            var internalFormat = format ? this._getInternalFormat(format) : this._gl.RGBA;
            this._gl.texImage2D(this._gl.TEXTURE_2D, 0, internalFormat, internalFormat, this._gl.UNSIGNED_BYTE, canvas);
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            if (premulAlpha) {
                this._gl.pixelStorei(this._gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, 0);
            }
            texture.isReady = true;
        };
        /**
         * Update a video texture
         * @param texture defines the texture to update
         * @param video defines the video element to use
         * @param invertY defines if data must be stored with Y axis inverted
         */
        Engine.prototype.updateVideoTexture = function (texture, video, invertY) {
            if (!texture || texture._isDisabled) {
                return;
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture, true);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY ? 0 : 1); // Video are upside down by default
            try {
                // Testing video texture support
                if (this._videoTextureSupported === undefined) {
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, video);
                    if (this._gl.getError() !== 0) {
                        this._videoTextureSupported = false;
                    }
                    else {
                        this._videoTextureSupported = true;
                    }
                }
                // Copy video through the current working canvas if video texture is not supported
                if (!this._videoTextureSupported) {
                    if (!texture._workingCanvas) {
                        texture._workingCanvas = document.createElement("canvas");
                        var context = texture._workingCanvas.getContext("2d");
                        if (!context) {
                            throw new Error("Unable to get 2d context");
                        }
                        texture._workingContext = context;
                        texture._workingCanvas.width = texture.width;
                        texture._workingCanvas.height = texture.height;
                    }
                    texture._workingContext.drawImage(video, 0, 0, video.videoWidth, video.videoHeight, 0, 0, texture.width, texture.height);
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, texture._workingCanvas);
                }
                else {
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, video);
                }
                if (texture.generateMipMaps) {
                    this._gl.generateMipmap(this._gl.TEXTURE_2D);
                }
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                //    this.resetTextureCache();
                texture.isReady = true;
            }
            catch (ex) {
                // Something unexpected
                // Let's disable the texture
                texture._isDisabled = true;
            }
        };
        /**
         * Updates a depth texture Comparison Mode and Function.
         * If the comparison Function is equal to 0, the mode will be set to none.
         * Otherwise, this only works in webgl 2 and requires a shadow sampler in the shader.
         * @param texture The texture to set the comparison function for
         * @param comparisonFunction The comparison function to set, 0 if no comparison required
         */
        Engine.prototype.updateTextureComparisonFunction = function (texture, comparisonFunction) {
            if (this.webGLVersion === 1) {
                BABYLON.Tools.Error("WebGL 1 does not support texture comparison.");
                return;
            }
            var gl = this._gl;
            if (texture.isCube) {
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, texture, true);
                if (comparisonFunction === 0) {
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_COMPARE_FUNC, Engine.LEQUAL);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_COMPARE_MODE, gl.NONE);
                }
                else {
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_COMPARE_FUNC, comparisonFunction);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_COMPARE_MODE, gl.COMPARE_REF_TO_TEXTURE);
                }
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
            }
            else {
                this._bindTextureDirectly(this._gl.TEXTURE_2D, texture, true);
                if (comparisonFunction === 0) {
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_COMPARE_FUNC, Engine.LEQUAL);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_COMPARE_MODE, gl.NONE);
                }
                else {
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_COMPARE_FUNC, comparisonFunction);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_COMPARE_MODE, gl.COMPARE_REF_TO_TEXTURE);
                }
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            }
            texture._comparisonFunction = comparisonFunction;
        };
        Engine.prototype._setupDepthStencilTexture = function (internalTexture, size, generateStencil, bilinearFiltering, comparisonFunction) {
            var width = size.width || size;
            var height = size.height || size;
            internalTexture.baseWidth = width;
            internalTexture.baseHeight = height;
            internalTexture.width = width;
            internalTexture.height = height;
            internalTexture.isReady = true;
            internalTexture.samples = 1;
            internalTexture.generateMipMaps = false;
            internalTexture._generateDepthBuffer = true;
            internalTexture._generateStencilBuffer = generateStencil;
            internalTexture.samplingMode = bilinearFiltering ? BABYLON.Texture.BILINEAR_SAMPLINGMODE : BABYLON.Texture.NEAREST_SAMPLINGMODE;
            internalTexture.type = Engine.TEXTURETYPE_UNSIGNED_INT;
            internalTexture._comparisonFunction = comparisonFunction;
            var gl = this._gl;
            var target = internalTexture.isCube ? gl.TEXTURE_CUBE_MAP : gl.TEXTURE_2D;
            var samplingParameters = getSamplingParameters(internalTexture.samplingMode, false, gl);
            gl.texParameteri(target, gl.TEXTURE_MAG_FILTER, samplingParameters.mag);
            gl.texParameteri(target, gl.TEXTURE_MIN_FILTER, samplingParameters.min);
            gl.texParameteri(target, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(target, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            if (comparisonFunction === 0) {
                gl.texParameteri(target, gl.TEXTURE_COMPARE_FUNC, Engine.LEQUAL);
                gl.texParameteri(target, gl.TEXTURE_COMPARE_MODE, gl.NONE);
            }
            else {
                gl.texParameteri(target, gl.TEXTURE_COMPARE_FUNC, comparisonFunction);
                gl.texParameteri(target, gl.TEXTURE_COMPARE_MODE, gl.COMPARE_REF_TO_TEXTURE);
            }
        };
        /**
         * Creates a depth stencil texture.
         * This is only available in WebGL 2 or with the depth texture extension available.
         * @param size The size of face edge in the texture.
         * @param options The options defining the texture.
         * @returns The texture
         */
        Engine.prototype.createDepthStencilTexture = function (size, options) {
            if (options.isCube) {
                var width = size.width || size;
                return this._createDepthStencilCubeTexture(width, options);
            }
            else {
                return this._createDepthStencilTexture(size, options);
            }
        };
        /**
         * Creates a depth stencil texture.
         * This is only available in WebGL 2 or with the depth texture extension available.
         * @param size The size of face edge in the texture.
         * @param options The options defining the texture.
         * @returns The texture
         */
        Engine.prototype._createDepthStencilTexture = function (size, options) {
            var internalTexture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_DEPTHTEXTURE);
            if (!this._caps.depthTextureExtension) {
                BABYLON.Tools.Error("Depth texture is not supported by your browser or hardware.");
                return internalTexture;
            }
            var internalOptions = __assign({ bilinearFiltering: false, comparisonFunction: 0, generateStencil: false }, options);
            var gl = this._gl;
            this._bindTextureDirectly(gl.TEXTURE_2D, internalTexture, true);
            this._setupDepthStencilTexture(internalTexture, size, internalOptions.generateStencil, internalOptions.bilinearFiltering, internalOptions.comparisonFunction);
            if (this.webGLVersion > 1) {
                if (internalOptions.generateStencil) {
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.DEPTH24_STENCIL8, internalTexture.width, internalTexture.height, 0, gl.DEPTH_STENCIL, gl.UNSIGNED_INT_24_8, null);
                }
                else {
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.DEPTH_COMPONENT24, internalTexture.width, internalTexture.height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                }
            }
            else {
                if (internalOptions.generateStencil) {
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.DEPTH_STENCIL, internalTexture.width, internalTexture.height, 0, gl.DEPTH_STENCIL, gl.UNSIGNED_INT_24_8, null);
                }
                else {
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.DEPTH_COMPONENT, internalTexture.width, internalTexture.height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                }
            }
            this._bindTextureDirectly(gl.TEXTURE_2D, null);
            return internalTexture;
        };
        /**
         * Creates a depth stencil cube texture.
         * This is only available in WebGL 2.
         * @param size The size of face edge in the cube texture.
         * @param options The options defining the cube texture.
         * @returns The cube texture
         */
        Engine.prototype._createDepthStencilCubeTexture = function (size, options) {
            var internalTexture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_UNKNOWN);
            internalTexture.isCube = true;
            if (this.webGLVersion === 1) {
                BABYLON.Tools.Error("Depth cube texture is not supported by WebGL 1.");
                return internalTexture;
            }
            var internalOptions = __assign({ bilinearFiltering: false, comparisonFunction: 0, generateStencil: false }, options);
            var gl = this._gl;
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, internalTexture, true);
            this._setupDepthStencilTexture(internalTexture, size, internalOptions.generateStencil, internalOptions.bilinearFiltering, internalOptions.comparisonFunction);
            // Create the depth/stencil buffer
            for (var face = 0; face < 6; face++) {
                if (internalOptions.generateStencil) {
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, 0, gl.DEPTH24_STENCIL8, size, size, 0, gl.DEPTH_STENCIL, gl.UNSIGNED_INT_24_8, null);
                }
                else {
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, 0, gl.DEPTH_COMPONENT24, size, size, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                }
            }
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            return internalTexture;
        };
        /**
         * Sets the frame buffer Depth / Stencil attachement of the render target to the defined depth stencil texture.
         * @param renderTarget The render target to set the frame buffer for
         */
        Engine.prototype.setFrameBufferDepthStencilTexture = function (renderTarget) {
            // Create the framebuffer
            var internalTexture = renderTarget.getInternalTexture();
            if (!internalTexture || !internalTexture._framebuffer || !renderTarget.depthStencilTexture) {
                return;
            }
            var gl = this._gl;
            var depthStencilTexture = renderTarget.depthStencilTexture;
            this.bindUnboundFramebuffer(internalTexture._framebuffer);
            if (depthStencilTexture.isCube) {
                if (depthStencilTexture._generateStencilBuffer) {
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_CUBE_MAP_POSITIVE_X, depthStencilTexture._webGLTexture, 0);
                }
                else {
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_CUBE_MAP_POSITIVE_X, depthStencilTexture._webGLTexture, 0);
                }
            }
            else {
                if (depthStencilTexture._generateStencilBuffer) {
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_2D, depthStencilTexture._webGLTexture, 0);
                }
                else {
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, depthStencilTexture._webGLTexture, 0);
                }
            }
            this.bindUnboundFramebuffer(null);
        };
        /**
         * Creates a new render target texture
         * @param size defines the size of the texture
         * @param options defines the options used to create the texture
         * @returns a new render target texture stored in an InternalTexture
         */
        Engine.prototype.createRenderTargetTexture = function (size, options) {
            var fullOptions = new RenderTargetCreationOptions();
            if (options !== undefined && typeof options === "object") {
                fullOptions.generateMipMaps = options.generateMipMaps;
                fullOptions.generateDepthBuffer = options.generateDepthBuffer === undefined ? true : options.generateDepthBuffer;
                fullOptions.generateStencilBuffer = fullOptions.generateDepthBuffer && options.generateStencilBuffer;
                fullOptions.type = options.type === undefined ? Engine.TEXTURETYPE_UNSIGNED_INT : options.type;
                fullOptions.samplingMode = options.samplingMode === undefined ? BABYLON.Texture.TRILINEAR_SAMPLINGMODE : options.samplingMode;
                fullOptions.format = options.format === undefined ? Engine.TEXTUREFORMAT_RGBA : options.format;
            }
            else {
                fullOptions.generateMipMaps = options;
                fullOptions.generateDepthBuffer = true;
                fullOptions.generateStencilBuffer = false;
                fullOptions.type = Engine.TEXTURETYPE_UNSIGNED_INT;
                fullOptions.samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE;
                fullOptions.format = Engine.TEXTUREFORMAT_RGBA;
            }
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloatLinearFiltering) {
                // if floating point linear (gl.FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            else if (fullOptions.type === Engine.TEXTURETYPE_HALF_FLOAT && !this._caps.textureHalfFloatLinearFiltering) {
                // if floating point linear (HALF_FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RENDERTARGET);
            this._bindTextureDirectly(gl.TEXTURE_2D, texture, true);
            var width = size.width || size;
            var height = size.height || size;
            var filters = getSamplingParameters(fullOptions.samplingMode, fullOptions.generateMipMaps ? true : false, gl);
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloat) {
                fullOptions.type = Engine.TEXTURETYPE_UNSIGNED_INT;
                BABYLON.Tools.Warn("Float textures are not supported. Render target forced to TEXTURETYPE_UNSIGNED_BYTE type");
            }
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(fullOptions.type, fullOptions.format), width, height, 0, this._getInternalFormat(fullOptions.format), this._getWebGLTextureType(fullOptions.type), null);
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture._webGLTexture, 0);
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(fullOptions.generateStencilBuffer ? true : false, fullOptions.generateDepthBuffer, width, height);
            if (fullOptions.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            // Unbind
            this._bindTextureDirectly(gl.TEXTURE_2D, null);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            texture._framebuffer = framebuffer;
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = width;
            texture.height = height;
            texture.isReady = true;
            texture.samples = 1;
            texture.generateMipMaps = fullOptions.generateMipMaps ? true : false;
            texture.samplingMode = fullOptions.samplingMode;
            texture.type = fullOptions.type;
            texture._generateDepthBuffer = fullOptions.generateDepthBuffer;
            texture._generateStencilBuffer = fullOptions.generateStencilBuffer ? true : false;
            // this.resetTextureCache();
            this._internalTexturesCache.push(texture);
            return texture;
        };
        /**
         * Create a multi render target texture
         * @see http://doc.babylonjs.com/features/webgl2#multiple-render-target
         * @param size defines the size of the texture
         * @param options defines the creation options
         * @returns the cube texture as an InternalTexture
         */
        Engine.prototype.createMultipleRenderTarget = function (size, options) {
            var generateMipMaps = false;
            var generateDepthBuffer = true;
            var generateStencilBuffer = false;
            var generateDepthTexture = false;
            var textureCount = 1;
            var defaultType = Engine.TEXTURETYPE_UNSIGNED_INT;
            var defaultSamplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE;
            var types = new Array();
            var samplingModes = new Array();
            if (options !== undefined) {
                generateMipMaps = options.generateMipMaps === undefined ? false : options.generateMipMaps;
                generateDepthBuffer = options.generateDepthBuffer === undefined ? true : options.generateDepthBuffer;
                generateStencilBuffer = options.generateStencilBuffer === undefined ? false : options.generateStencilBuffer;
                generateDepthTexture = options.generateDepthTexture === undefined ? false : options.generateDepthTexture;
                textureCount = options.textureCount || 1;
                if (options.types) {
                    types = options.types;
                }
                if (options.samplingModes) {
                    samplingModes = options.samplingModes;
                }
            }
            var gl = this._gl;
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            var width = size.width || size;
            var height = size.height || size;
            var textures = [];
            var attachments = [];
            var depthStencilBuffer = this._setupFramebufferDepthAttachments(generateStencilBuffer, generateDepthBuffer, width, height);
            for (var i = 0; i < textureCount; i++) {
                var samplingMode = samplingModes[i] || defaultSamplingMode;
                var type = types[i] || defaultType;
                if (type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloatLinearFiltering) {
                    // if floating point linear (gl.FLOAT) then force to NEAREST_SAMPLINGMODE
                    samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
                }
                else if (type === Engine.TEXTURETYPE_HALF_FLOAT && !this._caps.textureHalfFloatLinearFiltering) {
                    // if floating point linear (HALF_FLOAT) then force to NEAREST_SAMPLINGMODE
                    samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
                }
                var filters = getSamplingParameters(samplingMode, generateMipMaps, gl);
                if (type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloat) {
                    type = Engine.TEXTURETYPE_UNSIGNED_INT;
                    BABYLON.Tools.Warn("Float textures are not supported. Render target forced to TEXTURETYPE_UNSIGNED_BYTE type");
                }
                var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_MULTIRENDERTARGET);
                var attachment = gl[this.webGLVersion > 1 ? "COLOR_ATTACHMENT" + i : "COLOR_ATTACHMENT" + i + "_WEBGL"];
                textures.push(texture);
                attachments.push(attachment);
                gl.activeTexture(gl["TEXTURE" + i]);
                gl.bindTexture(gl.TEXTURE_2D, texture._webGLTexture);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(type), width, height, 0, gl.RGBA, this._getWebGLTextureType(type), null);
                gl.framebufferTexture2D(gl.DRAW_FRAMEBUFFER, attachment, gl.TEXTURE_2D, texture._webGLTexture, 0);
                if (generateMipMaps) {
                    this._gl.generateMipmap(this._gl.TEXTURE_2D);
                }
                // Unbind
                this._bindTextureDirectly(gl.TEXTURE_2D, null);
                texture._framebuffer = framebuffer;
                texture._depthStencilBuffer = depthStencilBuffer;
                texture.baseWidth = width;
                texture.baseHeight = height;
                texture.width = width;
                texture.height = height;
                texture.isReady = true;
                texture.samples = 1;
                texture.generateMipMaps = generateMipMaps;
                texture.samplingMode = samplingMode;
                texture.type = type;
                texture._generateDepthBuffer = generateDepthBuffer;
                texture._generateStencilBuffer = generateStencilBuffer;
                texture._attachments = attachments;
                this._internalTexturesCache.push(texture);
            }
            if (generateDepthTexture && this._caps.depthTextureExtension) {
                // Depth texture
                var depthTexture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_MULTIRENDERTARGET);
                gl.activeTexture(gl.TEXTURE0);
                gl.bindTexture(gl.TEXTURE_2D, depthTexture._webGLTexture);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                gl.texImage2D(gl.TEXTURE_2D, 0, this.webGLVersion < 2 ? gl.DEPTH_COMPONENT : gl.DEPTH_COMPONENT16, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_SHORT, null);
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, depthTexture._webGLTexture, 0);
                depthTexture._framebuffer = framebuffer;
                depthTexture.baseWidth = width;
                depthTexture.baseHeight = height;
                depthTexture.width = width;
                depthTexture.height = height;
                depthTexture.isReady = true;
                depthTexture.samples = 1;
                depthTexture.generateMipMaps = generateMipMaps;
                depthTexture.samplingMode = gl.NEAREST;
                depthTexture._generateDepthBuffer = generateDepthBuffer;
                depthTexture._generateStencilBuffer = generateStencilBuffer;
                textures.push(depthTexture);
                this._internalTexturesCache.push(depthTexture);
            }
            gl.drawBuffers(attachments);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            this.resetTextureCache();
            return textures;
        };
        Engine.prototype._setupFramebufferDepthAttachments = function (generateStencilBuffer, generateDepthBuffer, width, height, samples) {
            if (samples === void 0) { samples = 1; }
            var depthStencilBuffer = null;
            var gl = this._gl;
            // Create the depth/stencil buffer
            if (generateStencilBuffer) {
                depthStencilBuffer = gl.createRenderbuffer();
                gl.bindRenderbuffer(gl.RENDERBUFFER, depthStencilBuffer);
                if (samples > 1) {
                    gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, gl.DEPTH24_STENCIL8, width, height);
                }
                else {
                    gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, width, height);
                }
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, depthStencilBuffer);
            }
            else if (generateDepthBuffer) {
                depthStencilBuffer = gl.createRenderbuffer();
                gl.bindRenderbuffer(gl.RENDERBUFFER, depthStencilBuffer);
                if (samples > 1) {
                    gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, gl.DEPTH_COMPONENT16, width, height);
                }
                else {
                    gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, width, height);
                }
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, depthStencilBuffer);
            }
            return depthStencilBuffer;
        };
        /**
         * Updates the sample count of a render target texture
         * @see http://doc.babylonjs.com/features/webgl2#multisample-render-targets
         * @param texture defines the texture to update
         * @param samples defines the sample count to set
         * @returns the effective sample count (could be 0 if multisample render targets are not supported)
         */
        Engine.prototype.updateRenderTargetTextureSampleCount = function (texture, samples) {
            if (this.webGLVersion < 2 || !texture) {
                return 1;
            }
            if (texture.samples === samples) {
                return samples;
            }
            var gl = this._gl;
            samples = Math.min(samples, gl.getParameter(gl.MAX_SAMPLES));
            // Dispose previous render buffers
            if (texture._depthStencilBuffer) {
                gl.deleteRenderbuffer(texture._depthStencilBuffer);
                texture._depthStencilBuffer = null;
            }
            if (texture._MSAAFramebuffer) {
                gl.deleteFramebuffer(texture._MSAAFramebuffer);
                texture._MSAAFramebuffer = null;
            }
            if (texture._MSAARenderBuffer) {
                gl.deleteRenderbuffer(texture._MSAARenderBuffer);
                texture._MSAARenderBuffer = null;
            }
            if (samples > 1) {
                var framebuffer = gl.createFramebuffer();
                if (!framebuffer) {
                    throw new Error("Unable to create multi sampled framebuffer");
                }
                texture._MSAAFramebuffer = framebuffer;
                this.bindUnboundFramebuffer(texture._MSAAFramebuffer);
                var colorRenderbuffer = gl.createRenderbuffer();
                if (!colorRenderbuffer) {
                    throw new Error("Unable to create multi sampled framebuffer");
                }
                gl.bindRenderbuffer(gl.RENDERBUFFER, colorRenderbuffer);
                gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, this._getRGBAMultiSampleBufferFormat(texture.type), texture.width, texture.height);
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, colorRenderbuffer);
                texture._MSAARenderBuffer = colorRenderbuffer;
            }
            else {
                this.bindUnboundFramebuffer(texture._framebuffer);
            }
            texture.samples = samples;
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(texture._generateStencilBuffer, texture._generateDepthBuffer, texture.width, texture.height, samples);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            return samples;
        };
        /**
         * Update the sample count for a given multiple render target texture
         * @see http://doc.babylonjs.com/features/webgl2#multisample-render-targets
         * @param textures defines the textures to update
         * @param samples defines the sample count to set
         * @returns the effective sample count (could be 0 if multisample render targets are not supported)
         */
        Engine.prototype.updateMultipleRenderTargetTextureSampleCount = function (textures, samples) {
            if (this.webGLVersion < 2 || !textures || textures.length == 0) {
                return 1;
            }
            if (textures[0].samples === samples) {
                return samples;
            }
            var gl = this._gl;
            samples = Math.min(samples, gl.getParameter(gl.MAX_SAMPLES));
            // Dispose previous render buffers
            if (textures[0]._depthStencilBuffer) {
                gl.deleteRenderbuffer(textures[0]._depthStencilBuffer);
                textures[0]._depthStencilBuffer = null;
            }
            if (textures[0]._MSAAFramebuffer) {
                gl.deleteFramebuffer(textures[0]._MSAAFramebuffer);
                textures[0]._MSAAFramebuffer = null;
            }
            for (var i = 0; i < textures.length; i++) {
                if (textures[i]._MSAARenderBuffer) {
                    gl.deleteRenderbuffer(textures[i]._MSAARenderBuffer);
                    textures[i]._MSAARenderBuffer = null;
                }
            }
            if (samples > 1) {
                var framebuffer = gl.createFramebuffer();
                if (!framebuffer) {
                    throw new Error("Unable to create multi sampled framebuffer");
                }
                this.bindUnboundFramebuffer(framebuffer);
                var depthStencilBuffer = this._setupFramebufferDepthAttachments(textures[0]._generateStencilBuffer, textures[0]._generateDepthBuffer, textures[0].width, textures[0].height, samples);
                var attachments = [];
                for (var i = 0; i < textures.length; i++) {
                    var texture = textures[i];
                    var attachment = gl[this.webGLVersion > 1 ? "COLOR_ATTACHMENT" + i : "COLOR_ATTACHMENT" + i + "_WEBGL"];
                    var colorRenderbuffer = gl.createRenderbuffer();
                    if (!colorRenderbuffer) {
                        throw new Error("Unable to create multi sampled framebuffer");
                    }
                    gl.bindRenderbuffer(gl.RENDERBUFFER, colorRenderbuffer);
                    gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, this._getRGBAMultiSampleBufferFormat(texture.type), texture.width, texture.height);
                    gl.framebufferRenderbuffer(gl.FRAMEBUFFER, attachment, gl.RENDERBUFFER, colorRenderbuffer);
                    texture._MSAAFramebuffer = framebuffer;
                    texture._MSAARenderBuffer = colorRenderbuffer;
                    texture.samples = samples;
                    texture._depthStencilBuffer = depthStencilBuffer;
                    gl.bindRenderbuffer(gl.RENDERBUFFER, null);
                    attachments.push(attachment);
                }
                gl.drawBuffers(attachments);
            }
            else {
                this.bindUnboundFramebuffer(textures[0]._framebuffer);
            }
            this.bindUnboundFramebuffer(null);
            return samples;
        };
        /** @hidden */
        Engine.prototype._uploadDataToTexture = function (target, lod, internalFormat, width, height, format, type, data) {
            this._gl.texImage2D(target, lod, internalFormat, width, height, 0, format, type, data);
        };
        /** @hidden */
        Engine.prototype._uploadCompressedDataToTexture = function (target, lod, internalFormat, width, height, data) {
            this._gl.compressedTexImage2D(target, lod, internalFormat, width, height, 0, data);
        };
        /**
         * Creates a new render target cube texture
         * @param size defines the size of the texture
         * @param options defines the options used to create the texture
         * @returns a new render target cube texture stored in an InternalTexture
         */
        Engine.prototype.createRenderTargetCubeTexture = function (size, options) {
            var fullOptions = __assign({ generateMipMaps: true, generateDepthBuffer: true, generateStencilBuffer: false, type: Engine.TEXTURETYPE_UNSIGNED_INT, samplingMode: BABYLON.Texture.TRILINEAR_SAMPLINGMODE, format: Engine.TEXTUREFORMAT_RGBA }, options);
            fullOptions.generateStencilBuffer = fullOptions.generateDepthBuffer && fullOptions.generateStencilBuffer;
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloatLinearFiltering) {
                // if floating point linear (gl.FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            else if (fullOptions.type === Engine.TEXTURETYPE_HALF_FLOAT && !this._caps.textureHalfFloatLinearFiltering) {
                // if floating point linear (HALF_FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RENDERTARGET);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
            var filters = getSamplingParameters(fullOptions.samplingMode, fullOptions.generateMipMaps, gl);
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloat) {
                fullOptions.type = Engine.TEXTURETYPE_UNSIGNED_INT;
                BABYLON.Tools.Warn("Float textures are not supported. Cube render target forced to TEXTURETYPE_UNESIGNED_BYTE type");
            }
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, filters.min);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            for (var face = 0; face < 6; face++) {
                gl.texImage2D((gl.TEXTURE_CUBE_MAP_POSITIVE_X + face), 0, this._getRGBABufferInternalSizedFormat(fullOptions.type, fullOptions.format), size, size, 0, this._getInternalFormat(fullOptions.format), this._getWebGLTextureType(fullOptions.type), null);
            }
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(fullOptions.generateStencilBuffer, fullOptions.generateDepthBuffer, size, size);
            // MipMaps
            if (fullOptions.generateMipMaps) {
                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
            }
            // Unbind
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            texture._framebuffer = framebuffer;
            texture.width = size;
            texture.height = size;
            texture.isReady = true;
            texture.isCube = true;
            texture.samples = 1;
            texture.generateMipMaps = fullOptions.generateMipMaps;
            texture.samplingMode = fullOptions.samplingMode;
            texture.type = fullOptions.type;
            texture._generateDepthBuffer = fullOptions.generateDepthBuffer;
            texture._generateStencilBuffer = fullOptions.generateStencilBuffer;
            this._internalTexturesCache.push(texture);
            return texture;
        };
        /**
         * Create a cube texture from prefiltered data (ie. the mipmaps contain ready to use data for PBR reflection)
         * @param rootUrl defines the url where the file to load is located
         * @param scene defines the current scene
         * @param scale defines scale to apply to the mip map selection
         * @param offset defines offset to apply to the mip map selection
         * @param onLoad defines an optional callback raised when the texture is loaded
         * @param onError defines an optional callback raised if there is an issue to load the texture
         * @param format defines the format of the data
         * @param forcedExtension defines the extension to use to pick the right loader
         * @returns the cube texture as an InternalTexture
         */
        Engine.prototype.createPrefilteredCubeTexture = function (rootUrl, scene, scale, offset, onLoad, onError, format, forcedExtension) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (forcedExtension === void 0) { forcedExtension = null; }
            var callback = function (loadData) {
                if (!loadData) {
                    if (onLoad) {
                        onLoad(null);
                    }
                    return;
                }
                var texture = loadData.texture;
                if (loadData.info.sphericalPolynomial) {
                    texture._sphericalPolynomial = loadData.info.sphericalPolynomial;
                }
                texture._dataSource = BABYLON.InternalTexture.DATASOURCE_CUBEPREFILTERED;
                texture._lodGenerationScale = scale;
                texture._lodGenerationOffset = offset;
                if (_this._caps.textureLOD) {
                    // Do not add extra process if texture lod is supported.
                    if (onLoad) {
                        onLoad(texture);
                    }
                    return;
                }
                var mipSlices = 3;
                var gl = _this._gl;
                var width = loadData.width;
                if (!width) {
                    return;
                }
                var textures = [];
                for (var i = 0; i < mipSlices; i++) {
                    //compute LOD from even spacing in smoothness (matching shader calculation)
                    var smoothness = i / (mipSlices - 1);
                    var roughness = 1 - smoothness;
                    var minLODIndex = offset; // roughness = 0
                    var maxLODIndex = BABYLON.Scalar.Log2(width) * scale + offset; // roughness = 1
                    var lodIndex = minLODIndex + (maxLODIndex - minLODIndex) * roughness;
                    var mipmapIndex = Math.round(Math.min(Math.max(lodIndex, 0), maxLODIndex));
                    var glTextureFromLod = new BABYLON.InternalTexture(_this, BABYLON.InternalTexture.DATASOURCE_TEMP);
                    glTextureFromLod.isCube = true;
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, glTextureFromLod, true);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                    if (loadData.isDDS) {
                        var info = loadData.info;
                        var data = loadData.data;
                        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                        BABYLON.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, true, 6, mipmapIndex);
                    }
                    else {
                        BABYLON.Tools.Warn("DDS is the only prefiltered cube map supported so far.");
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
                    // Wrap in a base texture for easy binding.
                    var lodTexture = new BABYLON.BaseTexture(scene);
                    lodTexture.isCube = true;
                    lodTexture._texture = glTextureFromLod;
                    glTextureFromLod.isReady = true;
                    textures.push(lodTexture);
                }
                texture._lodTextureHigh = textures[2];
                texture._lodTextureMid = textures[1];
                texture._lodTextureLow = textures[0];
                if (onLoad) {
                    onLoad(texture);
                }
            };
            return this.createCubeTexture(rootUrl, scene, null, false, callback, onError, format, forcedExtension, true);
        };
        /**
         * Creates a cube texture
         * @param rootUrl defines the url where the files to load is located
         * @param scene defines the current scene
         * @param files defines the list of files to load (1 per face)
         * @param noMipmap defines a boolean indicating that no mipmaps shall be generated (false by default)
         * @param onLoad defines an optional callback raised when the texture is loaded
         * @param onError defines an optional callback raised if there is an issue to load the texture
         * @param format defines the format of the data
         * @param forcedExtension defines the extension to use to pick the right loader
         * @param createPolynomials if a polynomial sphere should be created for the cube texture
         * @returns the cube texture as an InternalTexture
         */
        Engine.prototype.createCubeTexture = function (rootUrl, scene, files, noMipmap, onLoad, onError, format, forcedExtension, createPolynomials) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (forcedExtension === void 0) { forcedExtension = null; }
            if (createPolynomials === void 0) { createPolynomials = false; }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_CUBE);
            texture.isCube = true;
            texture.url = rootUrl;
            texture.generateMipMaps = !noMipmap;
            if (!this._doNotHandleContextLost) {
                texture._extension = forcedExtension;
                texture._files = files;
            }
            var isKTX = false;
            var isDDS = false;
            var lastDot = rootUrl.lastIndexOf('.');
            var extension = forcedExtension ? forcedExtension : (lastDot > -1 ? rootUrl.substring(lastDot).toLowerCase() : "");
            if (this._textureFormatInUse) {
                extension = this._textureFormatInUse;
                rootUrl = (lastDot > -1 ? rootUrl.substring(0, lastDot) : rootUrl) + this._textureFormatInUse;
                isKTX = true;
            }
            else {
                isDDS = (extension === ".dds");
            }
            var onerror = function (request, exception) {
                if (onError && request) {
                    onError(request.status + " " + request.statusText, exception);
                }
            };
            if (isKTX) {
                this._loadFile(rootUrl, function (data) {
                    var ktx = new BABYLON.KhronosTextureContainer(data, 6);
                    var loadMipmap = ktx.numberOfMipmapLevels > 1 && !noMipmap;
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 1);
                    ktx.uploadLevels(_this._gl, !noMipmap);
                    _this.setCubeMapTextureParams(gl, loadMipmap);
                    texture.width = ktx.pixelWidth;
                    texture.height = ktx.pixelHeight;
                    texture.isReady = true;
                }, undefined, undefined, true, onerror);
            }
            else if (isDDS) {
                if (files && files.length === 6) {
                    this._cascadeLoadFiles(scene, function (imgs) {
                        var info;
                        var loadMipmap = false;
                        var width = 0;
                        for (var index = 0; index < imgs.length; index++) {
                            var data = imgs[index];
                            info = BABYLON.DDSTools.GetDDSInfo(data);
                            loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap;
                            _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                            BABYLON.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 6, -1, index);
                            if (!noMipmap && !info.isFourCC && info.mipmapCount === 1) {
                                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                            }
                            texture.width = info.width;
                            texture.height = info.height;
                            texture.type = info.textureType;
                            width = info.width;
                        }
                        _this.setCubeMapTextureParams(gl, loadMipmap);
                        texture.isReady = true;
                        if (onLoad) {
                            onLoad({ isDDS: true, width: width, info: info, imgs: imgs, texture: texture });
                        }
                    }, files, onError);
                }
                else {
                    this._loadFile(rootUrl, function (data) {
                        var info = BABYLON.DDSTools.GetDDSInfo(data);
                        if (createPolynomials) {
                            info.sphericalPolynomial = new BABYLON.SphericalPolynomial();
                        }
                        var loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap;
                        _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                        BABYLON.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 6);
                        if (!noMipmap && !info.isFourCC && info.mipmapCount === 1) {
                            gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                        }
                        _this.setCubeMapTextureParams(gl, loadMipmap);
                        texture.width = info.width;
                        texture.height = info.height;
                        texture.isReady = true;
                        texture.type = info.textureType;
                        if (onLoad) {
                            onLoad({ isDDS: true, width: info.width, info: info, data: data, texture: texture });
                        }
                    }, undefined, undefined, true, onerror);
                }
            }
            else {
                if (!files) {
                    throw new Error("Cannot load cubemap because files were not defined");
                }
                cascadeLoadImgs(rootUrl, scene, function (imgs) {
                    var width = _this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(imgs[0].width, _this._caps.maxCubemapTextureSize) : imgs[0].width;
                    var height = width;
                    _this._prepareWorkingCanvas();
                    if (!_this._workingCanvas || !_this._workingContext) {
                        return;
                    }
                    _this._workingCanvas.width = width;
                    _this._workingCanvas.height = height;
                    var faces = [
                        gl.TEXTURE_CUBE_MAP_POSITIVE_X, gl.TEXTURE_CUBE_MAP_POSITIVE_Y, gl.TEXTURE_CUBE_MAP_POSITIVE_Z,
                        gl.TEXTURE_CUBE_MAP_NEGATIVE_X, gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, gl.TEXTURE_CUBE_MAP_NEGATIVE_Z
                    ];
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 0);
                    var internalFormat = format ? _this._getInternalFormat(format) : _this._gl.RGBA;
                    for (var index = 0; index < faces.length; index++) {
                        _this._workingContext.drawImage(imgs[index], 0, 0, imgs[index].width, imgs[index].height, 0, 0, width, height);
                        gl.texImage2D(faces[index], 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, _this._workingCanvas);
                    }
                    if (!noMipmap) {
                        gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                    }
                    _this.setCubeMapTextureParams(gl, !noMipmap);
                    texture.width = width;
                    texture.height = height;
                    texture.isReady = true;
                    if (format) {
                        texture.format = format;
                    }
                    texture.onLoadedObservable.notifyObservers(texture);
                    texture.onLoadedObservable.clear();
                    if (onLoad) {
                        onLoad();
                    }
                }, files, onError);
            }
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.setCubeMapTextureParams = function (gl, loadMipmap) {
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, loadMipmap ? gl.LINEAR_MIPMAP_LINEAR : gl.LINEAR);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            //  this.resetTextureCache();
        };
        /**
         * Update a raw cube texture
         * @param texture defines the texture to udpdate
         * @param data defines the data to store
         * @param format defines the data format
         * @param type defines the type fo the data (BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT by default)
         * @param invertY defines if data must be stored with Y axis inverted
         * @param compression defines the compression used (null by default)
         * @param level defines which level of the texture to update
         */
        Engine.prototype.updateRawCubeTexture = function (texture, data, format, type, invertY, compression, level) {
            if (compression === void 0) { compression = null; }
            if (level === void 0) { level = 0; }
            texture._bufferViewArray = data;
            texture.format = format;
            texture.type = type;
            texture.invertY = invertY;
            texture._compression = compression;
            var gl = this._gl;
            var textureType = this._getWebGLTextureType(type);
            var internalFormat = this._getInternalFormat(format);
            var internalSizedFomat = this._getRGBABufferInternalSizedFormat(type);
            var needConversion = false;
            if (internalFormat === gl.RGB) {
                internalFormat = gl.RGBA;
                needConversion = true;
            }
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (texture.width % 4 !== 0) {
                gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
            }
            // Data are known to be in +X +Y +Z -X -Y -Z
            for (var faceIndex = 0; faceIndex < 6; faceIndex++) {
                var faceData = data[faceIndex];
                if (compression) {
                    gl.compressedTexImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, level, (this.getCaps().s3tc)[compression], texture.width, texture.height, 0, faceData);
                }
                else {
                    if (needConversion) {
                        faceData = this._convertRGBtoRGBATextureData(faceData, texture.width, texture.height, type);
                    }
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, level, internalSizedFomat, texture.width, texture.height, 0, internalFormat, textureType, faceData);
                }
            }
            var isPot = !this.needPOTTextures || (BABYLON.Tools.IsExponentOfTwo(texture.width) && BABYLON.Tools.IsExponentOfTwo(texture.height));
            if (isPot && texture.generateMipMaps && level === 0) {
                this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
            // this.resetTextureCache();
            texture.isReady = true;
        };
        /**
         * Creates a new raw cube texture
         * @param data defines the array of data to use to create each face
         * @param size defines the size of the textures
         * @param format defines the format of the data
         * @param type defines the type fo the data (like BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT)
         * @param generateMipMaps  defines if the engine should generate the mip levels
         * @param invertY defines if data must be stored with Y axis inverted
         * @param samplingMode defines the required sampling mode (like BABYLON.Texture.NEAREST_SAMPLINGMODE)
         * @param compression defines the compression used (null by default)
         * @returns the cube texture as an InternalTexture
         */
        Engine.prototype.createRawCubeTexture = function (data, size, format, type, generateMipMaps, invertY, samplingMode, compression) {
            if (compression === void 0) { compression = null; }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_CUBERAW);
            texture.isCube = true;
            texture.generateMipMaps = generateMipMaps;
            texture.format = format;
            texture.type = type;
            if (!this._doNotHandleContextLost) {
                texture._bufferViewArray = data;
            }
            var textureType = this._getWebGLTextureType(type);
            var internalFormat = this._getInternalFormat(format);
            if (internalFormat === gl.RGB) {
                internalFormat = gl.RGBA;
            }
            var width = size;
            var height = width;
            texture.width = width;
            texture.height = height;
            // Double check on POT to generate Mips.
            var isPot = !this.needPOTTextures || (BABYLON.Tools.IsExponentOfTwo(texture.width) && BABYLON.Tools.IsExponentOfTwo(texture.height));
            if (!isPot) {
                generateMipMaps = false;
            }
            // Upload data if needed. The texture won't be ready until then.
            if (data) {
                this.updateRawCubeTexture(texture, data, format, type, invertY, compression);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, texture, true);
            // Filters
            if (data && generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP);
            }
            if (textureType === gl.FLOAT && !this._caps.textureFloatLinearFiltering) {
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            }
            else if (textureType === this._gl.HALF_FLOAT_OES && !this._caps.textureHalfFloatLinearFiltering) {
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            }
            else {
                var filters = getSamplingParameters(samplingMode, generateMipMaps, gl);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, filters.mag);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, filters.min);
            }
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            return texture;
        };
        /**
         * Creates a new raw cube texture from a specified url
         * @param url defines the url where the data is located
         * @param scene defines the current scene
         * @param size defines the size of the textures
         * @param format defines the format of the data
         * @param type defines the type fo the data (like BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT)
         * @param noMipmap defines if the engine should avoid generating the mip levels
         * @param callback defines a callback used to extract texture data from loaded data
         * @param mipmapGenerator defines to provide an optional tool to generate mip levels
         * @param onLoad defines a callback called when texture is loaded
         * @param onError defines a callback called if there is an error
         * @param samplingMode defines the required sampling mode (like BABYLON.Texture.NEAREST_SAMPLINGMODE)
         * @param invertY defines if data must be stored with Y axis inverted
         * @returns the cube texture as an InternalTexture
         */
        Engine.prototype.createRawCubeTextureFromUrl = function (url, scene, size, format, type, noMipmap, callback, mipmapGenerator, onLoad, onError, samplingMode, invertY) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            if (invertY === void 0) { invertY = false; }
            var gl = this._gl;
            var texture = this.createRawCubeTexture(null, size, format, type, !noMipmap, invertY, samplingMode);
            scene._addPendingData(texture);
            texture.url = url;
            this._internalTexturesCache.push(texture);
            var onerror = function (request, exception) {
                scene._removePendingData(texture);
                if (onError && request) {
                    onError(request.status + " " + request.statusText, exception);
                }
            };
            var internalCallback = function (data) {
                var width = texture.width;
                var faceDataArrays = callback(data);
                if (!faceDataArrays) {
                    return;
                }
                if (mipmapGenerator) {
                    var textureType = _this._getWebGLTextureType(type);
                    var internalFormat = _this._getInternalFormat(format);
                    var internalSizedFomat = _this._getRGBABufferInternalSizedFormat(type);
                    var needConversion = false;
                    if (internalFormat === gl.RGB) {
                        internalFormat = gl.RGBA;
                        needConversion = true;
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture, true);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 0);
                    var mipData = mipmapGenerator(faceDataArrays);
                    for (var level = 0; level < mipData.length; level++) {
                        var mipSize = width >> level;
                        for (var faceIndex = 0; faceIndex < 6; faceIndex++) {
                            var mipFaceData = mipData[level][faceIndex];
                            if (needConversion) {
                                mipFaceData = _this._convertRGBtoRGBATextureData(mipFaceData, mipSize, mipSize, type);
                            }
                            gl.texImage2D(faceIndex, level, internalSizedFomat, mipSize, mipSize, 0, internalFormat, textureType, mipFaceData);
                        }
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
                }
                else {
                    texture.generateMipMaps = !noMipmap;
                    _this.updateRawCubeTexture(texture, faceDataArrays, format, type, invertY);
                }
                texture.isReady = true;
                // this.resetTextureCache();
                scene._removePendingData(texture);
                if (onLoad) {
                    onLoad();
                }
            };
            this._loadFile(url, function (data) {
                internalCallback(data);
            }, undefined, scene.database, true, onerror);
            return texture;
        };
        ;
        /**
         * Update a raw 3D texture
         * @param texture defines the texture to update
         * @param data defines the data to store
         * @param format defines the data format
         * @param invertY defines if data must be stored with Y axis inverted
         * @param compression defines the used compression (can be null)
         */
        Engine.prototype.updateRawTexture3D = function (texture, data, format, invertY, compression) {
            if (compression === void 0) { compression = null; }
            var internalFormat = this._getInternalFormat(format);
            this._bindTextureDirectly(this._gl.TEXTURE_3D, texture, true);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
                texture.format = format;
                texture.invertY = invertY;
                texture._compression = compression;
            }
            if (texture.width % 4 !== 0) {
                this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT, 1);
            }
            if (compression && data) {
                this._gl.compressedTexImage3D(this._gl.TEXTURE_3D, 0, this.getCaps().s3tc[compression], texture.width, texture.height, texture.depth, 0, data);
            }
            else {
                this._gl.texImage3D(this._gl.TEXTURE_3D, 0, internalFormat, texture.width, texture.height, texture.depth, 0, internalFormat, this._gl.UNSIGNED_BYTE, data);
            }
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_3D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            // this.resetTextureCache();
            texture.isReady = true;
        };
        /**
         * Creates a new raw 3D texture
         * @param data defines the data used to create the texture
         * @param width defines the width of the texture
         * @param height defines the height of the texture
         * @param depth defines the depth of the texture
         * @param format defines the format of the texture
         * @param generateMipMaps defines if the engine must generate mip levels
         * @param invertY defines if data must be stored with Y axis inverted
         * @param samplingMode defines the required sampling mode (like BABYLON.Texture.NEAREST_SAMPLINGMODE)
         * @param compression defines the compressed used (can be null)
         * @returns a new raw 3D texture (stored in an InternalTexture)
         */
        Engine.prototype.createRawTexture3D = function (data, width, height, depth, format, generateMipMaps, invertY, samplingMode, compression) {
            if (compression === void 0) { compression = null; }
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RAW3D);
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.baseDepth = depth;
            texture.width = width;
            texture.height = height;
            texture.depth = depth;
            texture.format = format;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            texture.is3D = true;
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
            }
            this.updateRawTexture3D(texture, data, format, invertY, compression);
            this._bindTextureDirectly(this._gl.TEXTURE_3D, texture, true);
            // Filters
            var filters = getSamplingParameters(samplingMode, generateMipMaps, this._gl);
            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MIN_FILTER, filters.min);
            if (generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_3D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype._prepareWebGLTextureContinuation = function (texture, scene, noMipmap, isCompressed, samplingMode) {
            var gl = this._gl;
            if (!gl) {
                return;
            }
            var filters = getSamplingParameters(samplingMode, !noMipmap, gl);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
            if (!noMipmap && !isCompressed) {
                gl.generateMipmap(gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(gl.TEXTURE_2D, null);
            // this.resetTextureCache();
            if (scene) {
                scene._removePendingData(texture);
            }
            texture.onLoadedObservable.notifyObservers(texture);
            texture.onLoadedObservable.clear();
        };
        Engine.prototype._prepareWebGLTexture = function (texture, scene, width, height, invertY, noMipmap, isCompressed, processFunction, samplingMode) {
            var _this = this;
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            var potWidth = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(width, this.getCaps().maxTextureSize) : width;
            var potHeight = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(height, this.getCaps().maxTextureSize) : height;
            var gl = this._gl;
            if (!gl) {
                return;
            }
            if (!texture._webGLTexture) {
                //  this.resetTextureCache();
                if (scene) {
                    scene._removePendingData(texture);
                }
                return;
            }
            this._bindTextureDirectly(gl.TEXTURE_2D, texture, true);
            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = potWidth;
            texture.height = potHeight;
            texture.isReady = true;
            if (processFunction(potWidth, potHeight, function () {
                _this._prepareWebGLTextureContinuation(texture, scene, noMipmap, isCompressed, samplingMode);
            })) {
                // Returning as texture needs extra async steps
                return;
            }
            this._prepareWebGLTextureContinuation(texture, scene, noMipmap, isCompressed, samplingMode);
        };
        Engine.prototype._convertRGBtoRGBATextureData = function (rgbData, width, height, textureType) {
            // Create new RGBA data container.
            var rgbaData;
            if (textureType === Engine.TEXTURETYPE_FLOAT) {
                rgbaData = new Float32Array(width * height * 4);
            }
            else {
                rgbaData = new Uint32Array(width * height * 4);
            }
            // Convert each pixel.
            for (var x = 0; x < width; x++) {
                for (var y = 0; y < height; y++) {
                    var index = (y * width + x) * 3;
                    var newIndex = (y * width + x) * 4;
                    // Map Old Value to new value.
                    rgbaData[newIndex + 0] = rgbData[index + 0];
                    rgbaData[newIndex + 1] = rgbData[index + 1];
                    rgbaData[newIndex + 2] = rgbData[index + 2];
                    // Add fully opaque alpha channel.
                    rgbaData[newIndex + 3] = 1;
                }
            }
            return rgbaData;
        };
        /** @hidden */
        Engine.prototype._releaseFramebufferObjects = function (texture) {
            var gl = this._gl;
            if (texture._framebuffer) {
                gl.deleteFramebuffer(texture._framebuffer);
                texture._framebuffer = null;
            }
            if (texture._depthStencilBuffer) {
                gl.deleteRenderbuffer(texture._depthStencilBuffer);
                texture._depthStencilBuffer = null;
            }
            if (texture._MSAAFramebuffer) {
                gl.deleteFramebuffer(texture._MSAAFramebuffer);
                texture._MSAAFramebuffer = null;
            }
            if (texture._MSAARenderBuffer) {
                gl.deleteRenderbuffer(texture._MSAARenderBuffer);
                texture._MSAARenderBuffer = null;
            }
        };
        /** @hidden */
        Engine.prototype._releaseTexture = function (texture) {
            var gl = this._gl;
            this._releaseFramebufferObjects(texture);
            gl.deleteTexture(texture._webGLTexture);
            // Unbind channels
            this.unbindAllTextures();
            var index = this._internalTexturesCache.indexOf(texture);
            if (index !== -1) {
                this._internalTexturesCache.splice(index, 1);
            }
            // Integrated fixed lod samplers.
            if (texture._lodTextureHigh) {
                texture._lodTextureHigh.dispose();
            }
            if (texture._lodTextureMid) {
                texture._lodTextureMid.dispose();
            }
            if (texture._lodTextureLow) {
                texture._lodTextureLow.dispose();
            }
            // Set output texture of post process to null if the texture has been released/disposed
            this.scenes.forEach(function (scene) {
                scene.postProcesses.forEach(function (postProcess) {
                    if (postProcess._outputTexture == texture) {
                        postProcess._outputTexture = null;
                    }
                });
                scene.cameras.forEach(function (camera) {
                    camera._postProcesses.forEach(function (postProcess) {
                        if (postProcess) {
                            if (postProcess._outputTexture == texture) {
                                postProcess._outputTexture = null;
                            }
                        }
                    });
                });
            });
        };
        Engine.prototype.setProgram = function (program) {
            if (this._currentProgram !== program) {
                this._gl.useProgram(program);
                this._currentProgram = program;
            }
        };
        /**
         * Binds an effect to the webGL context
         * @param effect defines the effect to bind
         */
        Engine.prototype.bindSamplers = function (effect) {
            this.setProgram(effect.getProgram());
            var samplers = effect.getSamplers();
            for (var index = 0; index < samplers.length; index++) {
                var uniform = effect.getUniform(samplers[index]);
                if (uniform) {
                    this._boundUniforms[index] = uniform;
                }
            }
            this._currentEffect = null;
        };
        Engine.prototype._moveBoundTextureOnTop = function (internalTexture) {
            if (this.disableTextureBindingOptimization || this._lastBoundInternalTextureTracker.previous === internalTexture) {
                return;
            }
            // Remove
            this._linkTrackers(internalTexture.previous, internalTexture.next);
            // Bind last to it
            this._linkTrackers(this._lastBoundInternalTextureTracker.previous, internalTexture);
            // Bind to dummy
            this._linkTrackers(internalTexture, this._lastBoundInternalTextureTracker);
        };
        Engine.prototype._getCorrectTextureChannel = function (channel, internalTexture) {
            if (!internalTexture) {
                return -1;
            }
            internalTexture._initialSlot = channel;
            if (this.disableTextureBindingOptimization) { // We want texture sampler ID === texture channel
                if (channel !== internalTexture._designatedSlot) {
                    this._textureCollisions.addCount(1, false);
                }
            }
            else {
                if (channel !== internalTexture._designatedSlot) {
                    if (internalTexture._designatedSlot > -1) { // Texture is already assigned to a slot
                        return internalTexture._designatedSlot;
                    }
                    else {
                        // No slot for this texture, let's pick a new one (if we find a free slot)
                        if (this._nextFreeTextureSlots.length) {
                            return this._nextFreeTextureSlots[0];
                        }
                        // We need to recycle the oldest bound texture, sorry.
                        this._textureCollisions.addCount(1, false);
                        return this._removeDesignatedSlot(this._firstBoundInternalTextureTracker.next);
                    }
                }
            }
            return channel;
        };
        Engine.prototype._linkTrackers = function (previous, next) {
            previous.next = next;
            next.previous = previous;
        };
        Engine.prototype._removeDesignatedSlot = function (internalTexture) {
            var currentSlot = internalTexture._designatedSlot;
            if (currentSlot === -1) {
                return -1;
            }
            internalTexture._designatedSlot = -1;
            if (this.disableTextureBindingOptimization) {
                return -1;
            }
            // Remove from bound list
            this._linkTrackers(internalTexture.previous, internalTexture.next);
            // Free the slot
            this._boundTexturesCache[currentSlot] = null;
            this._nextFreeTextureSlots.push(currentSlot);
            return currentSlot;
        };
        Engine.prototype._activateCurrentTexture = function () {
            if (this._currentTextureChannel !== this._activeChannel) {
                this._gl.activeTexture(this._gl.TEXTURE0 + this._activeChannel);
                this._currentTextureChannel = this._activeChannel;
            }
        };
        /** @hidden */
        Engine.prototype._bindTextureDirectly = function (target, texture, forTextureDataUpdate, force) {
            if (forTextureDataUpdate === void 0) { forTextureDataUpdate = false; }
            if (force === void 0) { force = false; }
            if (forTextureDataUpdate && texture && texture._designatedSlot > -1) {
                this._activeChannel = texture._designatedSlot;
            }
            var currentTextureBound = this._boundTexturesCache[this._activeChannel];
            var isTextureForRendering = texture && texture._initialSlot > -1;
            if (currentTextureBound !== texture || force) {
                if (currentTextureBound) {
                    this._removeDesignatedSlot(currentTextureBound);
                }
                this._activateCurrentTexture();
                this._gl.bindTexture(target, texture ? texture._webGLTexture : null);
                this._boundTexturesCache[this._activeChannel] = texture;
                if (texture) {
                    if (!this.disableTextureBindingOptimization) {
                        var slotIndex = this._nextFreeTextureSlots.indexOf(this._activeChannel);
                        if (slotIndex > -1) {
                            this._nextFreeTextureSlots.splice(slotIndex, 1);
                        }
                        this._linkTrackers(this._lastBoundInternalTextureTracker.previous, texture);
                        this._linkTrackers(texture, this._lastBoundInternalTextureTracker);
                    }
                    texture._designatedSlot = this._activeChannel;
                }
            }
            else if (forTextureDataUpdate) {
                this._activateCurrentTexture();
            }
            if (isTextureForRendering && !forTextureDataUpdate) {
                this._bindSamplerUniformToChannel(texture._initialSlot, this._activeChannel);
            }
        };
        /** @hidden */
        Engine.prototype._bindTexture = function (channel, texture) {
            if (channel < 0) {
                return;
            }
            if (texture) {
                channel = this._getCorrectTextureChannel(channel, texture);
            }
            this._activeChannel = channel;
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
        };
        /**
         * Sets a texture to the webGL context from a postprocess
         * @param channel defines the channel to use
         * @param postProcess defines the source postprocess
         */
        Engine.prototype.setTextureFromPostProcess = function (channel, postProcess) {
            this._bindTexture(channel, postProcess ? postProcess._textures.data[postProcess._currentRenderTextureInd] : null);
        };
        /**
         * Binds the output of the passed in post process to the texture channel specified
         * @param channel The channel the texture should be bound to
         * @param postProcess The post process which's output should be bound
         */
        Engine.prototype.setTextureFromPostProcessOutput = function (channel, postProcess) {
            this._bindTexture(channel, postProcess ? postProcess._outputTexture : null);
        };
        /**
         * Unbind all textures from the webGL context
         */
        Engine.prototype.unbindAllTextures = function () {
            for (var channel = 0; channel < this._maxSimultaneousTextures; channel++) {
                this._activeChannel = channel;
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
                if (this.webGLVersion > 1) {
                    this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
                }
            }
        };
        /**
         * Sets a texture to the according uniform.
         * @param channel The texture channel
         * @param uniform The uniform to set
         * @param texture The texture to apply
         */
        Engine.prototype.setTexture = function (channel, uniform, texture) {
            if (channel < 0) {
                return;
            }
            if (uniform) {
                this._boundUniforms[channel] = uniform;
            }
            this._setTexture(channel, texture);
        };
        /**
         * Sets a depth stencil texture from a render target to the according uniform.
         * @param channel The texture channel
         * @param uniform The uniform to set
         * @param texture The render target texture containing the depth stencil texture to apply
         */
        Engine.prototype.setDepthStencilTexture = function (channel, uniform, texture) {
            if (channel < 0) {
                return;
            }
            if (uniform) {
                this._boundUniforms[channel] = uniform;
            }
            if (!texture || !texture.depthStencilTexture) {
                this._setTexture(channel, null);
            }
            else {
                this._setTexture(channel, texture, false, true);
            }
        };
        Engine.prototype._bindSamplerUniformToChannel = function (sourceSlot, destination) {
            var uniform = this._boundUniforms[sourceSlot];
            if (uniform._currentState === destination) {
                return;
            }
            this._gl.uniform1i(uniform, destination);
            uniform._currentState = destination;
        };
        Engine.prototype._getTextureWrapMode = function (mode) {
            switch (mode) {
                case BABYLON.Texture.WRAP_ADDRESSMODE:
                    return this._gl.REPEAT;
                case BABYLON.Texture.CLAMP_ADDRESSMODE:
                    return this._gl.CLAMP_TO_EDGE;
                case BABYLON.Texture.MIRROR_ADDRESSMODE:
                    return this._gl.MIRRORED_REPEAT;
            }
            return this._gl.REPEAT;
        };
        Engine.prototype._setTexture = function (channel, texture, isPartOfTextureArray, depthStencilTexture) {
            if (isPartOfTextureArray === void 0) { isPartOfTextureArray = false; }
            if (depthStencilTexture === void 0) { depthStencilTexture = false; }
            // Not ready?
            if (!texture) {
                if (this._boundTexturesCache[channel] != null) {
                    this._activeChannel = channel;
                    this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                    this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
                    if (this.webGLVersion > 1) {
                        this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
                    }
                }
                return false;
            }
            // Video
            if (texture.video) {
                this._activeChannel = channel;
                texture.update();
            }
            else if (texture.delayLoadState === Engine.DELAYLOADSTATE_NOTLOADED) { // Delay loading
                texture.delayLoad();
                return false;
            }
            var internalTexture;
            if (depthStencilTexture) {
                internalTexture = texture.depthStencilTexture;
            }
            else if (texture.isReady()) {
                internalTexture = texture.getInternalTexture();
            }
            else if (texture.isCube) {
                internalTexture = this.emptyCubeTexture;
            }
            else if (texture.is3D) {
                internalTexture = this.emptyTexture3D;
            }
            else {
                internalTexture = this.emptyTexture;
            }
            if (!isPartOfTextureArray) {
                channel = this._getCorrectTextureChannel(channel, internalTexture);
            }
            var needToBind = true;
            if (this._boundTexturesCache[channel] === internalTexture) {
                this._moveBoundTextureOnTop(internalTexture);
                if (!isPartOfTextureArray) {
                    this._bindSamplerUniformToChannel(internalTexture._initialSlot, channel);
                }
                needToBind = false;
            }
            this._activeChannel = channel;
            if (internalTexture && internalTexture.is3D) {
                if (needToBind) {
                    this._bindTextureDirectly(this._gl.TEXTURE_3D, internalTexture, isPartOfTextureArray);
                }
                if (internalTexture && internalTexture._cachedWrapU !== texture.wrapU) {
                    internalTexture._cachedWrapU = texture.wrapU;
                    this._setTextureParameterInteger(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_S, this._getTextureWrapMode(texture.wrapU), internalTexture);
                }
                if (internalTexture && internalTexture._cachedWrapV !== texture.wrapV) {
                    internalTexture._cachedWrapV = texture.wrapV;
                    this._setTextureParameterInteger(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_T, this._getTextureWrapMode(texture.wrapV), internalTexture);
                }
                if (internalTexture && internalTexture._cachedWrapR !== texture.wrapR) {
                    internalTexture._cachedWrapR = texture.wrapR;
                    this._setTextureParameterInteger(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_R, this._getTextureWrapMode(texture.wrapR), internalTexture);
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_3D, texture);
            }
            else if (internalTexture && internalTexture.isCube) {
                if (needToBind) {
                    this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, internalTexture, isPartOfTextureArray);
                }
                if (internalTexture._cachedCoordinatesMode !== texture.coordinatesMode) {
                    internalTexture._cachedCoordinatesMode = texture.coordinatesMode;
                    // CUBIC_MODE and SKYBOX_MODE both require CLAMP_TO_EDGE.  All other modes use REPEAT.
                    var textureWrapMode = (texture.coordinatesMode !== BABYLON.Texture.CUBIC_MODE && texture.coordinatesMode !== BABYLON.Texture.SKYBOX_MODE) ? this._gl.REPEAT : this._gl.CLAMP_TO_EDGE;
                    this._setTextureParameterInteger(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_S, textureWrapMode, internalTexture);
                    this._setTextureParameterInteger(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_T, textureWrapMode);
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_CUBE_MAP, texture);
            }
            else {
                if (needToBind) {
                    this._bindTextureDirectly(this._gl.TEXTURE_2D, internalTexture, isPartOfTextureArray);
                }
                if (internalTexture && internalTexture._cachedWrapU !== texture.wrapU) {
                    internalTexture._cachedWrapU = texture.wrapU;
                    this._setTextureParameterInteger(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._getTextureWrapMode(texture.wrapU), internalTexture);
                }
                if (internalTexture && internalTexture._cachedWrapV !== texture.wrapV) {
                    internalTexture._cachedWrapV = texture.wrapV;
                    this._setTextureParameterInteger(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._getTextureWrapMode(texture.wrapV), internalTexture);
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_2D, texture);
            }
            return true;
        };
        /**
         * Sets an array of texture to the webGL context
         * @param channel defines the channel where the texture array must be set
         * @param uniform defines the associated uniform location
         * @param textures defines the array of textures to bind
         */
        Engine.prototype.setTextureArray = function (channel, uniform, textures) {
            if (channel < 0 || !uniform) {
                return;
            }
            if (!this._textureUnits || this._textureUnits.length !== textures.length) {
                this._textureUnits = new Int32Array(textures.length);
            }
            for (var i = 0; i < textures.length; i++) {
                this._textureUnits[i] = this._getCorrectTextureChannel(channel + i, textures[i].getInternalTexture());
            }
            this._gl.uniform1iv(uniform, this._textureUnits);
            for (var index = 0; index < textures.length; index++) {
                this._setTexture(this._textureUnits[index], textures[index], true);
            }
        };
        /** @hidden */
        Engine.prototype._setAnisotropicLevel = function (target, texture) {
            var internalTexture = texture.getInternalTexture();
            if (!internalTexture) {
                return;
            }
            var anisotropicFilterExtension = this._caps.textureAnisotropicFilterExtension;
            var value = texture.anisotropicFilteringLevel;
            if (internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR_MIPNEAREST
                && internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR_MIPLINEAR
                && internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR) {
                value = 1; // Forcing the anisotropic to 1 because else webgl will force filters to linear
            }
            if (anisotropicFilterExtension && internalTexture._cachedAnisotropicFilteringLevel !== value) {
                this._setTextureParameterFloat(target, anisotropicFilterExtension.TEXTURE_MAX_ANISOTROPY_EXT, Math.min(value, this._caps.maxAnisotropy), internalTexture);
                internalTexture._cachedAnisotropicFilteringLevel = value;
            }
        };
        Engine.prototype._setTextureParameterFloat = function (target, parameter, value, texture) {
            this._bindTextureDirectly(target, texture, true, true);
            this._gl.texParameterf(target, parameter, value);
        };
        Engine.prototype._setTextureParameterInteger = function (target, parameter, value, texture) {
            if (texture) {
                this._bindTextureDirectly(target, texture, true, true);
            }
            this._gl.texParameteri(target, parameter, value);
        };
        /**
         * Reads pixels from the current frame buffer. Please note that this function can be slow
         * @param x defines the x coordinate of the rectangle where pixels must be read
         * @param y defines the y coordinate of the rectangle where pixels must be read
         * @param width defines the width of the rectangle where pixels must be read
         * @param height defines the height of the rectangle where pixels must be read
         * @returns a Uint8Array containing RGBA colors
         */
        Engine.prototype.readPixels = function (x, y, width, height) {
            var data = new Uint8Array(height * width * 4);
            this._gl.readPixels(x, y, width, height, this._gl.RGBA, this._gl.UNSIGNED_BYTE, data);
            return data;
        };
        /**
         * Add an externaly attached data from its key.
         * This method call will fail and return false, if such key already exists.
         * If you don't care and just want to get the data no matter what, use the more convenient getOrAddExternalDataWithFactory() method.
         * @param key the unique key that identifies the data
         * @param data the data object to associate to the key for this Engine instance
         * @return true if no such key were already present and the data was added successfully, false otherwise
         */
        Engine.prototype.addExternalData = function (key, data) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.add(key, data);
        };
        /**
         * Get an externaly attached data from its key
         * @param key the unique key that identifies the data
         * @return the associated data, if present (can be null), or undefined if not present
         */
        Engine.prototype.getExternalData = function (key) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.get(key);
        };
        /**
         * Get an externaly attached data from its key, create it using a factory if it's not already present
         * @param key the unique key that identifies the data
         * @param factory the factory that will be called to create the instance if and only if it doesn't exists
         * @return the associated data, can be null if the factory returned null.
         */
        Engine.prototype.getOrAddExternalDataWithFactory = function (key, factory) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.getOrAddWithFactory(key, factory);
        };
        /**
         * Remove an externaly attached data from the Engine instance
         * @param key the unique key that identifies the data
         * @return true if the data was successfully removed, false if it doesn't exist
         */
        Engine.prototype.removeExternalData = function (key) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.remove(key);
        };
        /**
         * Unbind all vertex attributes from the webGL context
         */
        Engine.prototype.unbindAllAttributes = function () {
            if (this._mustWipeVertexAttributes) {
                this._mustWipeVertexAttributes = false;
                for (var i = 0; i < this._caps.maxVertexAttribs; i++) {
                    this._gl.disableVertexAttribArray(i);
                    this._vertexAttribArraysEnabled[i] = false;
                    this._currentBufferPointers[i].active = false;
                }
                return;
            }
            for (var i = 0, ul = this._vertexAttribArraysEnabled.length; i < ul; i++) {
                if (i >= this._caps.maxVertexAttribs || !this._vertexAttribArraysEnabled[i]) {
                    continue;
                }
                this._gl.disableVertexAttribArray(i);
                this._vertexAttribArraysEnabled[i] = false;
                this._currentBufferPointers[i].active = false;
            }
        };
        /**
         * Force the engine to release all cached effects. This means that next effect compilation will have to be done completely even if a similar effect was already compiled
         */
        Engine.prototype.releaseEffects = function () {
            for (var name in this._compiledEffects) {
                this._deleteProgram(this._compiledEffects[name]._program);
            }
            this._compiledEffects = {};
        };
        /**
         * Dispose and release all associated resources
         */
        Engine.prototype.dispose = function () {
            this.hideLoadingUI();
            this.stopRenderLoop();
            // Release postProcesses
            while (this.postProcesses.length) {
                this.postProcesses[0].dispose();
            }
            // Empty texture
            if (this._emptyTexture) {
                this._releaseTexture(this._emptyTexture);
                this._emptyTexture = null;
            }
            if (this._emptyCubeTexture) {
                this._releaseTexture(this._emptyCubeTexture);
                this._emptyCubeTexture = null;
            }
            // Rescale PP
            if (this._rescalePostProcess) {
                this._rescalePostProcess.dispose();
            }
            // Release scenes
            while (this.scenes.length) {
                this.scenes[0].dispose();
            }
            // Release audio engine
            if (Engine.audioEngine) {
                Engine.audioEngine.dispose();
            }
            // Release effects
            this.releaseEffects();
            // Unbind
            this.unbindAllAttributes();
            this._boundUniforms = [];
            if (this._dummyFramebuffer) {
                this._gl.deleteFramebuffer(this._dummyFramebuffer);
            }
            //WebVR
            this.disableVR();
            // Events
            if (BABYLON.Tools.IsWindowObjectExist()) {
                window.removeEventListener("blur", this._onBlur);
                window.removeEventListener("focus", this._onFocus);
                window.removeEventListener('vrdisplaypointerrestricted', this._onVRDisplayPointerRestricted);
                window.removeEventListener('vrdisplaypointerunrestricted', this._onVRDisplayPointerUnrestricted);
                if (this._renderingCanvas) {
                    this._renderingCanvas.removeEventListener("focus", this._onCanvasFocus);
                    this._renderingCanvas.removeEventListener("blur", this._onCanvasBlur);
                    this._renderingCanvas.removeEventListener("pointerout", this._onCanvasPointerOut);
                    if (!this._doNotHandleContextLost) {
                        this._renderingCanvas.removeEventListener("webglcontextlost", this._onContextLost);
                        this._renderingCanvas.removeEventListener("webglcontextrestored", this._onContextRestored);
                    }
                }
                document.removeEventListener("fullscreenchange", this._onFullscreenChange);
                document.removeEventListener("mozfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("webkitfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("msfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("pointerlockchange", this._onPointerLockChange);
                document.removeEventListener("mspointerlockchange", this._onPointerLockChange);
                document.removeEventListener("mozpointerlockchange", this._onPointerLockChange);
                document.removeEventListener("webkitpointerlockchange", this._onPointerLockChange);
                if (this._onVrDisplayConnect) {
                    window.removeEventListener('vrdisplayconnect', this._onVrDisplayConnect);
                    if (this._onVrDisplayDisconnect) {
                        window.removeEventListener('vrdisplaydisconnect', this._onVrDisplayDisconnect);
                    }
                    if (this._onVrDisplayPresentChange) {
                        window.removeEventListener('vrdisplaypresentchange', this._onVrDisplayPresentChange);
                    }
                    this._onVrDisplayConnect = null;
                    this._onVrDisplayDisconnect = null;
                }
            }
            // Remove from Instances
            var index = Engine.Instances.indexOf(this);
            if (index >= 0) {
                Engine.Instances.splice(index, 1);
            }
            this._workingCanvas = null;
            this._workingContext = null;
            this._currentBufferPointers = [];
            this._renderingCanvas = null;
            this._currentProgram = null;
            this._bindedRenderFunction = null;
            this.onResizeObservable.clear();
            this.onCanvasBlurObservable.clear();
            this.onCanvasFocusObservable.clear();
            this.onCanvasPointerOutObservable.clear();
            this.onBeginFrameObservable.clear();
            this.onEndFrameObservable.clear();
            BABYLON.Effect.ResetCache();
            // Abort active requests
            for (var _i = 0, _a = this._activeRequests; _i < _a.length; _i++) {
                var request = _a[_i];
                request.abort();
            }
        };
        // Loading screen
        /**
         * Display the loading screen
         * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
         */
        Engine.prototype.displayLoadingUI = function () {
            if (!BABYLON.Tools.IsWindowObjectExist()) {
                return;
            }
            var loadingScreen = this.loadingScreen;
            if (loadingScreen) {
                loadingScreen.displayLoadingUI();
            }
        };
        /**
         * Hide the loading screen
         * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
         */
        Engine.prototype.hideLoadingUI = function () {
            if (!BABYLON.Tools.IsWindowObjectExist()) {
                return;
            }
            var loadingScreen = this.loadingScreen;
            if (loadingScreen) {
                loadingScreen.hideLoadingUI();
            }
        };
        Object.defineProperty(Engine.prototype, "loadingScreen", {
            /**
             * Gets the current loading screen object
             * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
             */
            get: function () {
                if (!this._loadingScreen && BABYLON.DefaultLoadingScreen && this._renderingCanvas)
                    this._loadingScreen = new BABYLON.DefaultLoadingScreen(this._renderingCanvas);
                return this._loadingScreen;
            },
            /**
             * Sets the current loading screen object
             * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
             */
            set: function (loadingScreen) {
                this._loadingScreen = loadingScreen;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "loadingUIText", {
            /**
             * Sets the current loading screen text
             * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
             */
            set: function (text) {
                this.loadingScreen.loadingUIText = text;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "loadingUIBackgroundColor", {
            /**
             * Sets the current loading screen background color
             * @see http://doc.babylonjs.com/how_to/creating_a_custom_loading_screen
             */
            set: function (color) {
                this.loadingScreen.loadingUIBackgroundColor = color;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Attach a new callback raised when context lost event is fired
         * @param callback defines the callback to call
         */
        Engine.prototype.attachContextLostEvent = function (callback) {
            if (this._renderingCanvas) {
                this._renderingCanvas.addEventListener("webglcontextlost", callback, false);
            }
        };
        /**
         * Attach a new callback raised when context restored event is fired
         * @param callback defines the callback to call
         */
        Engine.prototype.attachContextRestoredEvent = function (callback) {
            if (this._renderingCanvas) {
                this._renderingCanvas.addEventListener("webglcontextrestored", callback, false);
            }
        };
        /**
         * Gets the source code of the vertex shader associated with a specific webGL program
         * @param program defines the program to use
         * @returns a string containing the source code of the vertex shader associated with the program
         */
        Engine.prototype.getVertexShaderSource = function (program) {
            var shaders = this._gl.getAttachedShaders(program);
            if (!shaders) {
                return null;
            }
            return this._gl.getShaderSource(shaders[0]);
        };
        /**
         * Gets the source code of the fragment shader associated with a specific webGL program
         * @param program defines the program to use
         * @returns a string containing the source code of the fragment shader associated with the program
         */
        Engine.prototype.getFragmentShaderSource = function (program) {
            var shaders = this._gl.getAttachedShaders(program);
            if (!shaders) {
                return null;
            }
            return this._gl.getShaderSource(shaders[1]);
        };
        /**
         * Get the current error code of the webGL context
         * @returns the error code
         * @see https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/getError
         */
        Engine.prototype.getError = function () {
            return this._gl.getError();
        };
        // FPS
        /**
         * Gets the current framerate
         * @returns a number representing the framerate
         */
        Engine.prototype.getFps = function () {
            return this._fps;
        };
        /**
         * Gets the time spent between current and previous frame
         * @returns a number representing the delta time in ms
         */
        Engine.prototype.getDeltaTime = function () {
            return this._deltaTime;
        };
        Engine.prototype._measureFps = function () {
            this._performanceMonitor.sampleFrame();
            this._fps = this._performanceMonitor.averageFPS;
            this._deltaTime = this._performanceMonitor.instantaneousFrameTime || 0;
        };
        /** @hidden */
        Engine.prototype._readTexturePixels = function (texture, width, height, faceIndex) {
            if (faceIndex === void 0) { faceIndex = -1; }
            var gl = this._gl;
            if (!this._dummyFramebuffer) {
                var dummy = gl.createFramebuffer();
                if (!dummy) {
                    throw new Error("Unable to create dummy framebuffer");
                }
                this._dummyFramebuffer = dummy;
            }
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._dummyFramebuffer);
            if (faceIndex > -1) {
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, texture._webGLTexture, 0);
            }
            else {
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture._webGLTexture, 0);
            }
            var readType = (texture.type !== undefined) ? this._getWebGLTextureType(texture.type) : gl.UNSIGNED_BYTE;
            var buffer;
            switch (readType) {
                case gl.UNSIGNED_BYTE:
                    buffer = new Uint8Array(4 * width * height);
                    readType = gl.UNSIGNED_BYTE;
                    break;
                default:
                    buffer = new Float32Array(4 * width * height);
                    readType = gl.FLOAT;
                    break;
            }
            gl.readPixels(0, 0, width, height, gl.RGBA, readType, buffer);
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._currentFramebuffer);
            return buffer;
        };
        Engine.prototype._canRenderToFloatFramebuffer = function () {
            if (this._webGLVersion > 1) {
                return this._caps.colorBufferFloat;
            }
            return this._canRenderToFramebuffer(Engine.TEXTURETYPE_FLOAT);
        };
        Engine.prototype._canRenderToHalfFloatFramebuffer = function () {
            if (this._webGLVersion > 1) {
                return this._caps.colorBufferFloat;
            }
            return this._canRenderToFramebuffer(Engine.TEXTURETYPE_HALF_FLOAT);
        };
        // Thank you : http://stackoverflow.com/questions/28827511/webgl-ios-render-to-floating-point-texture
        Engine.prototype._canRenderToFramebuffer = function (type) {
            var gl = this._gl;
            //clear existing errors
            while (gl.getError() !== gl.NO_ERROR) { }
            var successful = true;
            var texture = gl.createTexture();
            gl.bindTexture(gl.TEXTURE_2D, texture);
            gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(type), 1, 1, 0, gl.RGBA, this._getWebGLTextureType(type), null);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
            var fb = gl.createFramebuffer();
            gl.bindFramebuffer(gl.FRAMEBUFFER, fb);
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture, 0);
            var status = gl.checkFramebufferStatus(gl.FRAMEBUFFER);
            successful = successful && (status === gl.FRAMEBUFFER_COMPLETE);
            successful = successful && (gl.getError() === gl.NO_ERROR);
            //try render by clearing frame buffer's color buffer
            if (successful) {
                gl.clear(gl.COLOR_BUFFER_BIT);
                successful = successful && (gl.getError() === gl.NO_ERROR);
            }
            //try reading from frame to ensure render occurs (just creating the FBO is not sufficient to determine if rendering is supported)
            if (successful) {
                //in practice it's sufficient to just read from the backbuffer rather than handle potentially issues reading from the texture
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                var readFormat = gl.RGBA;
                var readType = gl.UNSIGNED_BYTE;
                var buffer = new Uint8Array(4);
                gl.readPixels(0, 0, 1, 1, readFormat, readType, buffer);
                successful = successful && (gl.getError() === gl.NO_ERROR);
            }
            //clean up
            gl.deleteTexture(texture);
            gl.deleteFramebuffer(fb);
            gl.bindFramebuffer(gl.FRAMEBUFFER, null);
            //clear accumulated errors
            while (!successful && (gl.getError() !== gl.NO_ERROR)) { }
            return successful;
        };
        /** @hidden */
        Engine.prototype._getWebGLTextureType = function (type) {
            if (type === Engine.TEXTURETYPE_FLOAT) {
                return this._gl.FLOAT;
            }
            else if (type === Engine.TEXTURETYPE_HALF_FLOAT) {
                // Add Half Float Constant.
                return this._gl.HALF_FLOAT_OES;
            }
            return this._gl.UNSIGNED_BYTE;
        };
        ;
        Engine.prototype._getInternalFormat = function (format) {
            var internalFormat = this._gl.RGBA;
            switch (format) {
                case Engine.TEXTUREFORMAT_ALPHA:
                    internalFormat = this._gl.ALPHA;
                    break;
                case Engine.TEXTUREFORMAT_LUMINANCE:
                    internalFormat = this._gl.LUMINANCE;
                    break;
                case Engine.TEXTUREFORMAT_LUMINANCE_ALPHA:
                    internalFormat = this._gl.LUMINANCE_ALPHA;
                    break;
                case Engine.TEXTUREFORMAT_RGB:
                case Engine.TEXTUREFORMAT_RGB32F:
                    internalFormat = this._gl.RGB;
                    break;
                case Engine.TEXTUREFORMAT_RGBA:
                case Engine.TEXTUREFORMAT_RGBA32F:
                    internalFormat = this._gl.RGBA;
                    break;
                case Engine.TEXTUREFORMAT_R32F:
                    internalFormat = this._gl.RED;
                    break;
                case Engine.TEXTUREFORMAT_RG32F:
                    internalFormat = this._gl.RG;
                    break;
            }
            return internalFormat;
        };
        /** @hidden */
        Engine.prototype._getRGBABufferInternalSizedFormat = function (type, format) {
            if (this._webGLVersion === 1) {
                if (format) {
                    switch (format) {
                        case Engine.TEXTUREFORMAT_LUMINANCE:
                            return this._gl.LUMINANCE;
                    }
                }
                return this._gl.RGBA;
            }
            if (type === Engine.TEXTURETYPE_FLOAT) {
                if (format) {
                    switch (format) {
                        case Engine.TEXTUREFORMAT_R32F:
                            return this._gl.R32F;
                        case Engine.TEXTUREFORMAT_RG32F:
                            return this._gl.RG32F;
                        case Engine.TEXTUREFORMAT_RGB32F:
                            return this._gl.RGB32F;
                    }
                }
                return this._gl.RGBA32F;
            }
            else if (type === Engine.TEXTURETYPE_HALF_FLOAT) {
                return this._gl.RGBA16F;
            }
            if (format) {
                switch (format) {
                    case Engine.TEXTUREFORMAT_LUMINANCE:
                        return this._gl.LUMINANCE;
                    case Engine.TEXTUREFORMAT_RGB:
                        return this._gl.RGB;
                }
            }
            return this._gl.RGBA;
        };
        ;
        /** @hidden */
        Engine.prototype._getRGBAMultiSampleBufferFormat = function (type) {
            if (type === Engine.TEXTURETYPE_FLOAT) {
                return this._gl.RGBA32F;
            }
            else if (type === Engine.TEXTURETYPE_HALF_FLOAT) {
                return this._gl.RGBA16F;
            }
            return this._gl.RGBA8;
        };
        ;
        /**
         * Create a new webGL query (you must be sure that queries are supported by checking getCaps() function)
         * @return the new query
         */
        Engine.prototype.createQuery = function () {
            return this._gl.createQuery();
        };
        /**
         * Delete and release a webGL query
         * @param query defines the query to delete
         * @return the current engine
         */
        Engine.prototype.deleteQuery = function (query) {
            this._gl.deleteQuery(query);
            return this;
        };
        /**
         * Check if a given query has resolved and got its value
         * @param query defines the query to check
         * @returns true if the query got its value
         */
        Engine.prototype.isQueryResultAvailable = function (query) {
            return this._gl.getQueryParameter(query, this._gl.QUERY_RESULT_AVAILABLE);
        };
        /**
         * Gets the value of a given query
         * @param query defines the query to check
         * @returns the value of the query
         */
        Engine.prototype.getQueryResult = function (query) {
            return this._gl.getQueryParameter(query, this._gl.QUERY_RESULT);
        };
        /**
         * Initiates an occlusion query
         * @param algorithmType defines the algorithm to use
         * @param query defines the query to use
         * @returns the current engine
         * @see http://doc.babylonjs.com/features/occlusionquery
         */
        Engine.prototype.beginOcclusionQuery = function (algorithmType, query) {
            var glAlgorithm = this.getGlAlgorithmType(algorithmType);
            this._gl.beginQuery(glAlgorithm, query);
            return this;
        };
        /**
         * Ends an occlusion query
         * @see http://doc.babylonjs.com/features/occlusionquery
         * @param algorithmType defines the algorithm to use
         * @returns the current engine
         */
        Engine.prototype.endOcclusionQuery = function (algorithmType) {
            var glAlgorithm = this.getGlAlgorithmType(algorithmType);
            this._gl.endQuery(glAlgorithm);
            return this;
        };
        /* Time queries */
        Engine.prototype._createTimeQuery = function () {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.createQueryEXT) {
                return timerQuery.createQueryEXT();
            }
            return this.createQuery();
        };
        Engine.prototype._deleteTimeQuery = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.deleteQueryEXT) {
                timerQuery.deleteQueryEXT(query);
                return;
            }
            this.deleteQuery(query);
        };
        Engine.prototype._getTimeQueryResult = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.getQueryObjectEXT) {
                return timerQuery.getQueryObjectEXT(query, timerQuery.QUERY_RESULT_EXT);
            }
            return this.getQueryResult(query);
        };
        Engine.prototype._getTimeQueryAvailability = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.getQueryObjectEXT) {
                return timerQuery.getQueryObjectEXT(query, timerQuery.QUERY_RESULT_AVAILABLE_EXT);
            }
            return this.isQueryResultAvailable(query);
        };
        /**
         * Starts a time query (used to measure time spent by the GPU on a specific frame)
         * Please note that only one query can be issued at a time
         * @returns a time token used to track the time span
         */
        Engine.prototype.startTimeQuery = function () {
            var timerQuery = this._caps.timerQuery;
            if (!timerQuery) {
                return null;
            }
            var token = new BABYLON._TimeToken();
            this._gl.getParameter(timerQuery.GPU_DISJOINT_EXT);
            if (this._caps.canUseTimestampForTimerQuery) {
                token._startTimeQuery = this._createTimeQuery();
                timerQuery.queryCounterEXT(token._startTimeQuery, timerQuery.TIMESTAMP_EXT);
            }
            else {
                if (this._currentNonTimestampToken) {
                    return this._currentNonTimestampToken;
                }
                token._timeElapsedQuery = this._createTimeQuery();
                if (timerQuery.beginQueryEXT) {
                    timerQuery.beginQueryEXT(timerQuery.TIME_ELAPSED_EXT, token._timeElapsedQuery);
                }
                else {
                    this._gl.beginQuery(timerQuery.TIME_ELAPSED_EXT, token._timeElapsedQuery);
                }
                this._currentNonTimestampToken = token;
            }
            return token;
        };
        /**
         * Ends a time query
         * @param token defines the token used to measure the time span
         * @returns the time spent (in ns)
         */
        Engine.prototype.endTimeQuery = function (token) {
            var timerQuery = this._caps.timerQuery;
            if (!timerQuery || !token) {
                return -1;
            }
            if (this._caps.canUseTimestampForTimerQuery) {
                if (!token._startTimeQuery) {
                    return -1;
                }
                if (!token._endTimeQuery) {
                    token._endTimeQuery = this._createTimeQuery();
                    timerQuery.queryCounterEXT(token._endTimeQuery, timerQuery.TIMESTAMP_EXT);
                }
            }
            else if (!token._timeElapsedQueryEnded) {
                if (!token._timeElapsedQuery) {
                    return -1;
                }
                if (timerQuery.endQueryEXT) {
                    timerQuery.endQueryEXT(timerQuery.TIME_ELAPSED_EXT);
                }
                else {
                    this._gl.endQuery(timerQuery.TIME_ELAPSED_EXT);
                }
                token._timeElapsedQueryEnded = true;
            }
            var disjoint = this._gl.getParameter(timerQuery.GPU_DISJOINT_EXT);
            var available = false;
            if (token._endTimeQuery) {
                available = this._getTimeQueryAvailability(token._endTimeQuery);
            }
            else if (token._timeElapsedQuery) {
                available = this._getTimeQueryAvailability(token._timeElapsedQuery);
            }
            if (available && !disjoint) {
                var result = 0;
                if (this._caps.canUseTimestampForTimerQuery) {
                    if (!token._startTimeQuery || !token._endTimeQuery) {
                        return -1;
                    }
                    var timeStart = this._getTimeQueryResult(token._startTimeQuery);
                    var timeEnd = this._getTimeQueryResult(token._endTimeQuery);
                    result = timeEnd - timeStart;
                    this._deleteTimeQuery(token._startTimeQuery);
                    this._deleteTimeQuery(token._endTimeQuery);
                    token._startTimeQuery = null;
                    token._endTimeQuery = null;
                }
                else {
                    if (!token._timeElapsedQuery) {
                        return -1;
                    }
                    result = this._getTimeQueryResult(token._timeElapsedQuery);
                    this._deleteTimeQuery(token._timeElapsedQuery);
                    token._timeElapsedQuery = null;
                    token._timeElapsedQueryEnded = false;
                    this._currentNonTimestampToken = null;
                }
                return result;
            }
            return -1;
        };
        Engine.prototype.getGlAlgorithmType = function (algorithmType) {
            return algorithmType === BABYLON.AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE ? this._gl.ANY_SAMPLES_PASSED_CONSERVATIVE : this._gl.ANY_SAMPLES_PASSED;
        };
        // Transform feedback
        /**
         * Creates a webGL transform feedback object
         * Please makes sure to check webGLVersion property to check if you are running webGL 2+
         * @returns the webGL transform feedback object
         */
        Engine.prototype.createTransformFeedback = function () {
            return this._gl.createTransformFeedback();
        };
        /**
         * Delete a webGL transform feedback object
         * @param value defines the webGL transform feedback object to delete
         */
        Engine.prototype.deleteTransformFeedback = function (value) {
            this._gl.deleteTransformFeedback(value);
        };
        /**
         * Bind a webGL transform feedback object to the webgl context
         * @param value defines the webGL transform feedback object to bind
         */
        Engine.prototype.bindTransformFeedback = function (value) {
            this._gl.bindTransformFeedback(this._gl.TRANSFORM_FEEDBACK, value);
        };
        /**
         * Begins a transform feedback operation
         * @param usePoints defines if points or triangles must be used
         */
        Engine.prototype.beginTransformFeedback = function (usePoints) {
            if (usePoints === void 0) { usePoints = true; }
            this._gl.beginTransformFeedback(usePoints ? this._gl.POINTS : this._gl.TRIANGLES);
        };
        /**
         * Ends a transform feedback operation
         */
        Engine.prototype.endTransformFeedback = function () {
            this._gl.endTransformFeedback();
        };
        /**
         * Specify the varyings to use with transform feedback
         * @param program defines the associated webGL program
         * @param value defines the list of strings representing the varying names
         */
        Engine.prototype.setTranformFeedbackVaryings = function (program, value) {
            this._gl.transformFeedbackVaryings(program, value, this._gl.INTERLEAVED_ATTRIBS);
        };
        /**
         * Bind a webGL buffer for a transform feedback operation
         * @param value defines the webGL buffer to bind
         */
        Engine.prototype.bindTransformFeedbackBuffer = function (value) {
            this._gl.bindBufferBase(this._gl.TRANSFORM_FEEDBACK_BUFFER, 0, value);
        };
        /** @hidden */
        Engine.prototype._loadFile = function (url, onSuccess, onProgress, database, useArrayBuffer, onError) {
            var _this = this;
            var request = BABYLON.Tools.LoadFile(url, onSuccess, onProgress, database, useArrayBuffer, onError);
            this._activeRequests.push(request);
            request.onCompleteObservable.add(function (request) {
                _this._activeRequests.splice(_this._activeRequests.indexOf(request), 1);
            });
            return request;
        };
        /** @hidden */
        Engine.prototype._loadFileAsync = function (url, database, useArrayBuffer) {
            var _this = this;
            return new Promise(function (resolve, reject) {
                _this._loadFile(url, function (data) {
                    resolve(data);
                }, undefined, database, useArrayBuffer, function (request, exception) {
                    reject(exception);
                });
            });
        };
        Engine.prototype._partialLoadFile = function (url, index, loadedFiles, scene, onfinish, onErrorCallBack) {
            if (onErrorCallBack === void 0) { onErrorCallBack = null; }
            var onload = function (data) {
                loadedFiles[index] = data;
                loadedFiles._internalCount++;
                if (loadedFiles._internalCount === 6) {
                    onfinish(loadedFiles);
                }
            };
            var onerror = function (request, exception) {
                if (onErrorCallBack && request) {
                    onErrorCallBack(request.status + " " + request.statusText, exception);
                }
            };
            this._loadFile(url, onload, undefined, undefined, true, onerror);
        };
        Engine.prototype._cascadeLoadFiles = function (scene, onfinish, files, onError) {
            if (onError === void 0) { onError = null; }
            var loadedFiles = [];
            loadedFiles._internalCount = 0;
            for (var index = 0; index < 6; index++) {
                this._partialLoadFile(files[index], index, loadedFiles, scene, onfinish, onError);
            }
        };
        // Statics
        /**
         * Gets a boolean indicating if the engine can be instanciated (ie. if a webGL context can be found)
         * @returns true if the engine can be created
         * @ignorenaming
         */
        Engine.isSupported = function () {
            try {
                var tempcanvas = document.createElement("canvas");
                var gl = tempcanvas.getContext("webgl") || tempcanvas.getContext("experimental-webgl");
                return gl != null && !!window.WebGLRenderingContext;
            }
            catch (e) {
                return false;
            }
        };
        /** Use this array to turn off some WebGL2 features on known buggy browsers version */
        Engine.ExceptionList = [
            { key: "Chrome/63.0", capture: "63\\.0\\.3239\\.(\\d+)", captureConstraint: 108, targets: ["uniformBuffer"] },
            { key: "Firefox/58", capture: null, captureConstraint: null, targets: ["uniformBuffer"] },
            { key: "Firefox/59", capture: null, captureConstraint: null, targets: ["uniformBuffer"] },
            { key: "Macintosh", capture: null, captureConstraint: null, targets: ["textureBindingOptimization"] },
            { key: "iPhone", capture: null, captureConstraint: null, targets: ["textureBindingOptimization"] },
            { key: "iPad", capture: null, captureConstraint: null, targets: ["textureBindingOptimization"] }
        ];
        /** Gets the list of created engines */
        Engine.Instances = new Array();
        // Const statics
        Engine._ALPHA_DISABLE = 0;
        Engine._ALPHA_ADD = 1;
        Engine._ALPHA_COMBINE = 2;
        Engine._ALPHA_SUBTRACT = 3;
        Engine._ALPHA_MULTIPLY = 4;
        Engine._ALPHA_MAXIMIZED = 5;
        Engine._ALPHA_ONEONE = 6;
        Engine._ALPHA_PREMULTIPLIED = 7;
        Engine._ALPHA_PREMULTIPLIED_PORTERDUFF = 8;
        Engine._ALPHA_INTERPOLATE = 9;
        Engine._ALPHA_SCREENMODE = 10;
        Engine._DELAYLOADSTATE_NONE = 0;
        Engine._DELAYLOADSTATE_LOADED = 1;
        Engine._DELAYLOADSTATE_LOADING = 2;
        Engine._DELAYLOADSTATE_NOTLOADED = 4;
        Engine._TEXTUREFORMAT_ALPHA = 0;
        Engine._TEXTUREFORMAT_LUMINANCE = 1;
        Engine._TEXTUREFORMAT_LUMINANCE_ALPHA = 2;
        Engine._TEXTUREFORMAT_RGB = 4;
        Engine._TEXTUREFORMAT_RGBA = 5;
        Engine._TEXTUREFORMAT_R32F = 6;
        Engine._TEXTUREFORMAT_RG32F = 7;
        Engine._TEXTUREFORMAT_RGB32F = 8;
        Engine._TEXTUREFORMAT_RGBA32F = 9;
        Engine._TEXTURETYPE_UNSIGNED_INT = 0;
        Engine._TEXTURETYPE_FLOAT = 1;
        Engine._TEXTURETYPE_HALF_FLOAT = 2;
        // Depht or Stencil test Constants.
        Engine._NEVER = 0x0200; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will never pass. i.e. Nothing will be drawn.
        Engine._ALWAYS = 0x0207; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will always pass. i.e. Pixels will be drawn in the order they are drawn.
        Engine._LESS = 0x0201; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than the stored value.
        Engine._EQUAL = 0x0202; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is equals to the stored value.
        Engine._LEQUAL = 0x0203; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than or equal to the stored value.
        Engine._GREATER = 0x0204; // Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than the stored value.
        Engine._GEQUAL = 0x0206; //	Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than or equal to the stored value.
        Engine._NOTEQUAL = 0x0205; //  Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is not equal to the stored value.
        // Stencil Actions Constants.
        Engine._KEEP = 0x1E00;
        Engine._REPLACE = 0x1E01;
        Engine._INCR = 0x1E02;
        Engine._DECR = 0x1E03;
        Engine._INVERT = 0x150A;
        Engine._INCR_WRAP = 0x8507;
        Engine._DECR_WRAP = 0x8508;
        // Texture rescaling mode
        Engine._SCALEMODE_FLOOR = 1;
        Engine._SCALEMODE_NEAREST = 2;
        Engine._SCALEMODE_CEILING = 3;
        // Updatable statics so stick with vars here
        /**
         * Gets or sets the epsilon value used by collision engine
         */
        Engine.CollisionsEpsilon = 0.001;
        /**
         * Gets or sets the relative url used to load code if using the engine in non-minified mode
         */
        Engine.CodeRepository = "src/";
        /**
         * Gets or sets the relative url used to load shaders if using the engine in non-minified mode
         */
        Engine.ShadersRepository = "src/Shaders/";
        return Engine;
    }());
    BABYLON.Engine = Engine;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.engine.js.map


var BABYLON;
(function (BABYLON) {
    /**
     * Node is the basic class for all scene objects (Mesh, Light Camera).
     */
    var Node = /** @class */ (function () {
        /**
         * Creates a new Node
         * @param {string} name - the name and id to be given to this node
         * @param {BABYLON.Scene} the scene this node will be added to
         */
        function Node(name, scene) {
            if (scene === void 0) { scene = null; }
            /**
             * Gets or sets a string used to store user defined state for the node
             */
            this.state = "";
            /**
             * Gets or sets an object used to store user defined information for the node
             */
            this.metadata = null;
            /**
             * Gets or sets a boolean used to define if the node must be serialized
             */
            this.doNotSerialize = false;
            /** @hidden */
            this._isDisposed = false;
            /**
             * Gets a list of Animations associated with the node
             */
            this.animations = new Array();
            this._ranges = {};
            this._isEnabled = true;
            this._isReady = true;
            /** @hidden */
            this._currentRenderId = -1;
            this._parentRenderId = -1;
            this._childRenderId = -1;
            this._animationPropertiesOverride = null;
            /**
            * An event triggered when the mesh is disposed
            */
            this.onDisposeObservable = new BABYLON.Observable();
            // Behaviors
            this._behaviors = new Array();
            this.name = name;
            this.id = name;
            this._scene = (scene || BABYLON.Engine.LastCreatedScene);
            this.uniqueId = this._scene.getUniqueId();
            this._initCache();
        }
        /**
         * Gets a boolean indicating if the node has been disposed
         * @returns true if the node was disposed
         */
        Node.prototype.isDisposed = function () {
            return this._isDisposed;
        };
        Object.defineProperty(Node.prototype, "parent", {
            get: function () {
                return this._parentNode;
            },
            /**
             * Gets or sets the parent of the node
             */
            set: function (parent) {
                if (this._parentNode === parent) {
                    return;
                }
                // Remove self from list of children of parent
                if (this._parentNode && this._parentNode._children !== undefined && this._parentNode._children !== null) {
                    var index = this._parentNode._children.indexOf(this);
                    if (index !== -1) {
                        this._parentNode._children.splice(index, 1);
                    }
                }
                // Store new parent
                this._parentNode = parent;
                // Add as child to new parent
                if (this._parentNode) {
                    if (this._parentNode._children === undefined || this._parentNode._children === null) {
                        this._parentNode._children = new Array();
                    }
                    this._parentNode._children.push(this);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Node.prototype, "animationPropertiesOverride", {
            /**
             * Gets or sets the animation properties override
             */
            get: function () {
                if (!this._animationPropertiesOverride) {
                    return this._scene.animationPropertiesOverride;
                }
                return this._animationPropertiesOverride;
            },
            set: function (value) {
                this._animationPropertiesOverride = value;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Gets a string idenfifying the name of the class
         * @returns "Node" string
         */
        Node.prototype.getClassName = function () {
            return "Node";
        };
        Object.defineProperty(Node.prototype, "onDispose", {
            /**
             * Sets a callback that will be raised when the node will be disposed
             */
            set: function (callback) {
                if (this._onDisposeObserver) {
                    this.onDisposeObservable.remove(this._onDisposeObserver);
                }
                this._onDisposeObserver = this.onDisposeObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Gets the scene of the node
         * @returns a {BABYLON.Scene}
         */
        Node.prototype.getScene = function () {
            return this._scene;
        };
        /**
         * Gets the engine of the node
         * @returns a {BABYLON.Engine}
         */
        Node.prototype.getEngine = function () {
            return this._scene.getEngine();
        };
        /**
         * Attach a behavior to the node
         * @see http://doc.babylonjs.com/features/behaviour
         * @param behavior defines the behavior to attach
         * @returns the current Node
         */
        Node.prototype.addBehavior = function (behavior) {
            var _this = this;
            var index = this._behaviors.indexOf(behavior);
            if (index !== -1) {
                return this;
            }
            behavior.init();
            if (this._scene.isLoading) {
                // We defer the attach when the scene will be loaded
                var observer = this._scene.onDataLoadedObservable.add(function () {
                    behavior.attach(_this);
                    setTimeout(function () {
                        // Need to use a timeout to avoid removing an observer while iterating the list of observers
                        _this._scene.onDataLoadedObservable.remove(observer);
                    }, 0);
                });
            }
            else {
                behavior.attach(this);
            }
            this._behaviors.push(behavior);
            return this;
        };
        /**
         * Remove an attached behavior
         * @see http://doc.babylonjs.com/features/behaviour
         * @param behavior defines the behavior to attach
         * @returns the current Node
         */
        Node.prototype.removeBehavior = function (behavior) {
            var index = this._behaviors.indexOf(behavior);
            if (index === -1) {
                return this;
            }
            this._behaviors[index].detach();
            this._behaviors.splice(index, 1);
            return this;
        };
        Object.defineProperty(Node.prototype, "behaviors", {
            /**
             * Gets the list of attached behaviors
             * @see http://doc.babylonjs.com/features/behaviour
             */
            get: function () {
                return this._behaviors;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Gets an attached behavior by name
         * @param name defines the name of the behavior to look for
         * @see http://doc.babylonjs.com/features/behaviour
         * @returns null if behavior was not found else the requested behavior
         */
        Node.prototype.getBehaviorByName = function (name) {
            for (var _i = 0, _a = this._behaviors; _i < _a.length; _i++) {
                var behavior = _a[_i];
                if (behavior.name === name) {
                    return behavior;
                }
            }
            return null;
        };
        /**
         * Returns the world matrix of the node
         * @returns a matrix containing the node's world matrix
         */
        Node.prototype.getWorldMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        /** @hidden */
        Node.prototype._getWorldMatrixDeterminant = function () {
            return 1;
        };
        // override it in derived class if you add new variables to the cache
        // and call the parent class method
        /** @hidden */
        Node.prototype._initCache = function () {
            this._cache = {};
            this._cache.parent = undefined;
        };
        /** @hidden */
        Node.prototype.updateCache = function (force) {
            if (!force && this.isSynchronized())
                return;
            this._cache.parent = this.parent;
            this._updateCache();
        };
        // override it in derived class if you add new variables to the cache
        // and call the parent class method if !ignoreParentClass
        /** @hidden */
        Node.prototype._updateCache = function (ignoreParentClass) {
        };
        // override it in derived class if you add new variables to the cache
        /** @hidden */
        Node.prototype._isSynchronized = function () {
            return true;
        };
        /** @hidden */
        Node.prototype._markSyncedWithParent = function () {
            if (this.parent) {
                this._parentRenderId = this.parent._childRenderId;
            }
        };
        /** @hidden */
        Node.prototype.isSynchronizedWithParent = function () {
            if (!this.parent) {
                return true;
            }
            if (this._parentRenderId !== this.parent._childRenderId) {
                return false;
            }
            return this.parent.isSynchronized();
        };
        /** @hidden */
        Node.prototype.isSynchronized = function (updateCache) {
            var check = this.hasNewParent();
            check = check || !this.isSynchronizedWithParent();
            check = check || !this._isSynchronized();
            if (updateCache)
                this.updateCache(true);
            return !check;
        };
        /** @hidden */
        Node.prototype.hasNewParent = function (update) {
            if (this._cache.parent === this.parent)
                return false;
            if (update)
                this._cache.parent = this.parent;
            return true;
        };
        /**
         * Is this node ready to be used/rendered
         * @param completeCheck defines if a complete check (including materials and lights) has to be done (false by default)
         * @return true if the node is ready
         */
        Node.prototype.isReady = function (completeCheck) {
            if (completeCheck === void 0) { completeCheck = false; }
            return this._isReady;
        };
        /**
         * Is this node enabled?
         * If the node has a parent, all ancestors will be checked and false will be returned if any are false (not enabled), otherwise will return true
         * @param checkAncestors indicates if this method should check the ancestors. The default is to check the ancestors. If set to false, the method will return the value of this node without checking ancestors
         * @return whether this node (and its parent) is enabled
         */
        Node.prototype.isEnabled = function (checkAncestors) {
            if (checkAncestors === void 0) { checkAncestors = true; }
            if (checkAncestors === false) {
                return this._isEnabled;
            }
            if (this._isEnabled === false) {
                return false;
            }
            if (this.parent !== undefined && this.parent !== null) {
                return this.parent.isEnabled(checkAncestors);
            }
            return true;
        };
        /**
         * Set the enabled state of this node
         * @param value defines the new enabled state
         */
        Node.prototype.setEnabled = function (value) {
            this._isEnabled = value;
        };
        /**
         * Is this node a descendant of the given node?
         * The function will iterate up the hierarchy until the ancestor was found or no more parents defined
         * @param ancestor defines the parent node to inspect
         * @returns a boolean indicating if this node is a descendant of the given node
         */
        Node.prototype.isDescendantOf = function (ancestor) {
            if (this.parent) {
                if (this.parent === ancestor) {
                    return true;
                }
                return this.parent.isDescendantOf(ancestor);
            }
            return false;
        };
        /** @hidden */
        Node.prototype._getDescendants = function (results, directDescendantsOnly, predicate) {
            if (directDescendantsOnly === void 0) { directDescendantsOnly = false; }
            if (!this._children) {
                return;
            }
            for (var index = 0; index < this._children.length; index++) {
                var item = this._children[index];
                if (!predicate || predicate(item)) {
                    results.push(item);
                }
                if (!directDescendantsOnly) {
                    item._getDescendants(results, false, predicate);
                }
            }
        };
        /**
         * Will return all nodes that have this node as ascendant
         * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered
         * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
         * @return all children nodes of all types
         */
        Node.prototype.getDescendants = function (directDescendantsOnly, predicate) {
            var results = new Array();
            this._getDescendants(results, directDescendantsOnly, predicate);
            return results;
        };
        /**
         * Get all child-meshes of this node
         * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered
         * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
         * @returns an array of {BABYLON.AbstractMesh}
         */
        Node.prototype.getChildMeshes = function (directDescendantsOnly, predicate) {
            var results = [];
            this._getDescendants(results, directDescendantsOnly, function (node) {
                return ((!predicate || predicate(node)) && (node instanceof BABYLON.AbstractMesh));
            });
            return results;
        };
        /**
         * Get all child-transformNodes of this node
         * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered
         * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
         * @returns an array of {BABYLON.TransformNode}
         */
        Node.prototype.getChildTransformNodes = function (directDescendantsOnly, predicate) {
            var results = [];
            this._getDescendants(results, directDescendantsOnly, function (node) {
                return ((!predicate || predicate(node)) && (node instanceof BABYLON.TransformNode));
            });
            return results;
        };
        /**
         * Get all direct children of this node
         * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
         * @returns an array of {BABYLON.Node}
         */
        Node.prototype.getChildren = function (predicate) {
            return this.getDescendants(true, predicate);
        };
        /** @hidden */
        Node.prototype._setReady = function (state) {
            if (state === this._isReady) {
                return;
            }
            if (!state) {
                this._isReady = false;
                return;
            }
            if (this.onReady) {
                this.onReady(this);
            }
            this._isReady = true;
        };
        /**
         * Get an animation by name
         * @param name defines the name of the animation to look for
         * @returns null if not found else the requested animation
         */
        Node.prototype.getAnimationByName = function (name) {
            for (var i = 0; i < this.animations.length; i++) {
                var animation = this.animations[i];
                if (animation.name === name) {
                    return animation;
                }
            }
            return null;
        };
        /**
         * Creates an animation range for this node
         * @param name defines the name of the range
         * @param from defines the starting key
         * @param to defines the end key
         */
        Node.prototype.createAnimationRange = function (name, from, to) {
            // check name not already in use
            if (!this._ranges[name]) {
                this._ranges[name] = new BABYLON.AnimationRange(name, from, to);
                for (var i = 0, nAnimations = this.animations.length; i < nAnimations; i++) {
                    if (this.animations[i]) {
                        this.animations[i].createRange(name, from, to);
                    }
                }
            }
        };
        /**
         * Delete a specific animation range
         * @param name defines the name of the range to delete
         * @param deleteFrames defines if animation frames from the range must be deleted as well
         */
        Node.prototype.deleteAnimationRange = function (name, deleteFrames) {
            if (deleteFrames === void 0) { deleteFrames = true; }
            for (var i = 0, nAnimations = this.animations.length; i < nAnimations; i++) {
                if (this.animations[i]) {
                    this.animations[i].deleteRange(name, deleteFrames);
                }
            }
            this._ranges[name] = null; // said much faster than 'delete this._range[name]' 
        };
        /**
         * Get an animation range by name
         * @param name defines the name of the animation range to look for
         * @returns null if not found else the requested animation range
         */
        Node.prototype.getAnimationRange = function (name) {
            return this._ranges[name];
        };
        /**
         * Will start the animation sequence
         * @param name defines the range frames for animation sequence
         * @param loop defines if the animation should loop (false by default)
         * @param speedRatio defines the speed factor in which to run the animation (1 by default)
         * @param onAnimationEnd defines a function to be executed when the animation ended (undefined by default)
         * @returns the object created for this animation. If range does not exist, it will return null
         */
        Node.prototype.beginAnimation = function (name, loop, speedRatio, onAnimationEnd) {
            var range = this.getAnimationRange(name);
            if (!range) {
                return null;
            }
            return this._scene.beginAnimation(this, range.from, range.to, loop, speedRatio, onAnimationEnd);
        };
        /**
         * Serialize animation ranges into a JSON compatible object
         * @returns serialization object
         */
        Node.prototype.serializeAnimationRanges = function () {
            var serializationRanges = [];
            for (var name in this._ranges) {
                var localRange = this._ranges[name];
                if (!localRange) {
                    continue;
                }
                var range = {};
                range.name = name;
                range.from = localRange.from;
                range.to = localRange.to;
                serializationRanges.push(range);
            }
            return serializationRanges;
        };
        /**
         * Computes the world matrix of the node
         * @param force defines if the cache version should be invalidated forcing the world matrix to be created from scratch
         * @returns the world matrix
         */
        Node.prototype.computeWorldMatrix = function (force) {
            return BABYLON.Matrix.Identity();
        };
        /**
         * Releases resources associated with this node.
         * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
         * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
         */
        Node.prototype.dispose = function (doNotRecurse, disposeMaterialAndTextures) {
            if (disposeMaterialAndTextures === void 0) { disposeMaterialAndTextures = false; }
            if (!doNotRecurse) {
                var nodes = this.getDescendants(true);
                for (var _i = 0, nodes_1 = nodes; _i < nodes_1.length; _i++) {
                    var node = nodes_1[_i];
                    node.dispose(doNotRecurse, disposeMaterialAndTextures);
                }
            }
            else {
                var transformNodes = this.getChildTransformNodes(true);
                for (var _a = 0, transformNodes_1 = transformNodes; _a < transformNodes_1.length; _a++) {
                    var transformNode = transformNodes_1[_a];
                    transformNode.parent = null;
                    transformNode.computeWorldMatrix(true);
                }
            }
            this.parent = null;
            // Callback
            this.onDisposeObservable.notifyObservers(this);
            this.onDisposeObservable.clear();
            // Behaviors
            for (var _b = 0, _c = this._behaviors; _b < _c.length; _b++) {
                var behavior = _c[_b];
                behavior.detach();
            }
            this._behaviors = [];
            this._isDisposed = true;
        };
        /**
         * Parse animation range data from a serialization object and store them into a given node
         * @param node defines where to store the animation ranges
         * @param parsedNode defines the serialization object to read data from
         * @param scene defines the hosting scene
         */
        Node.ParseAnimationRanges = function (node, parsedNode, scene) {
            if (parsedNode.ranges) {
                for (var index = 0; index < parsedNode.ranges.length; index++) {
                    var data = parsedNode.ranges[index];
                    node.createAnimationRange(data.name, data.from, data.to);
                }
            }
        };
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "name", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "id", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "uniqueId", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "state", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "metadata", void 0);
        return Node;
    }());
    BABYLON.Node = Node;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.node.js.map

var BABYLON;
(function (BABYLON) {
    var BoundingSphere = /** @class */ (function () {
        /**
         * Creates a new bounding sphere
         * @param min defines the minimum vector (in local space)
         * @param max defines the maximum vector (in local space)
         */
        function BoundingSphere(min, max) {
            this._tempRadiusVector = BABYLON.Vector3.Zero();
            this.reConstruct(min, max);
        }
        /**
         * Recreates the entire bounding sphere from scratch
         * @param min defines the new minimum vector (in local space)
         * @param max defines the new maximum vector (in local space)
         */
        BoundingSphere.prototype.reConstruct = function (min, max) {
            this.minimum = min.clone();
            this.maximum = max.clone();
            var distance = BABYLON.Vector3.Distance(min, max);
            this.center = BABYLON.Vector3.Lerp(min, max, 0.5);
            this.radius = distance * 0.5;
            this.centerWorld = BABYLON.Vector3.Zero();
            this._update(BABYLON.Matrix.Identity());
        };
        // Methods
        BoundingSphere.prototype._update = function (world) {
            BABYLON.Vector3.TransformCoordinatesToRef(this.center, world, this.centerWorld);
            BABYLON.Vector3.TransformNormalFromFloatsToRef(1.0, 1.0, 1.0, world, this._tempRadiusVector);
            this.radiusWorld = Math.max(Math.abs(this._tempRadiusVector.x), Math.abs(this._tempRadiusVector.y), Math.abs(this._tempRadiusVector.z)) * this.radius;
        };
        BoundingSphere.prototype.isInFrustum = function (frustumPlanes) {
            for (var i = 0; i < 6; i++) {
                if (frustumPlanes[i].dotCoordinate(this.centerWorld) <= -this.radiusWorld)
                    return false;
            }
            return true;
        };
        BoundingSphere.prototype.intersectsPoint = function (point) {
            var x = this.centerWorld.x - point.x;
            var y = this.centerWorld.y - point.y;
            var z = this.centerWorld.z - point.z;
            var distance = Math.sqrt((x * x) + (y * y) + (z * z));
            if (Math.abs(this.radiusWorld - distance) < BABYLON.Epsilon)
                return false;
            return true;
        };
        // Statics
        BoundingSphere.Intersects = function (sphere0, sphere1) {
            var x = sphere0.centerWorld.x - sphere1.centerWorld.x;
            var y = sphere0.centerWorld.y - sphere1.centerWorld.y;
            var z = sphere0.centerWorld.z - sphere1.centerWorld.z;
            var distance = Math.sqrt((x * x) + (y * y) + (z * z));
            if (sphere0.radiusWorld + sphere1.radiusWorld < distance)
                return false;
            return true;
        };
        return BoundingSphere;
    }());
    BABYLON.BoundingSphere = BoundingSphere;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingSphere.js.map

var BABYLON;
(function (BABYLON) {
    var BoundingBox = /** @class */ (function () {
        /**
         * Creates a new bounding box
         * @param min defines the minimum vector (in local space)
         * @param max defines the maximum vector (in local space)
         */
        function BoundingBox(min, max) {
            this.vectorsWorld = new Array();
            this.reConstruct(min, max);
        }
        // Methods
        /**
         * Recreates the entire bounding box from scratch
         * @param min defines the new minimum vector (in local space)
         * @param max defines the new maximum vector (in local space)
         */
        BoundingBox.prototype.reConstruct = function (min, max) {
            this.minimum = min.clone();
            this.maximum = max.clone();
            // Bounding vectors
            this.vectors = new Array();
            this.vectors.push(this.minimum.clone());
            this.vectors.push(this.maximum.clone());
            this.vectors.push(this.minimum.clone());
            this.vectors[2].x = this.maximum.x;
            this.vectors.push(this.minimum.clone());
            this.vectors[3].y = this.maximum.y;
            this.vectors.push(this.minimum.clone());
            this.vectors[4].z = this.maximum.z;
            this.vectors.push(this.maximum.clone());
            this.vectors[5].z = this.minimum.z;
            this.vectors.push(this.maximum.clone());
            this.vectors[6].x = this.minimum.x;
            this.vectors.push(this.maximum.clone());
            this.vectors[7].y = this.minimum.y;
            // OBB
            this.center = this.maximum.add(this.minimum).scale(0.5);
            this.extendSize = this.maximum.subtract(this.minimum).scale(0.5);
            this.directions = [BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero()];
            // World
            for (var index = 0; index < this.vectors.length; index++) {
                this.vectorsWorld[index] = BABYLON.Vector3.Zero();
            }
            this.minimumWorld = BABYLON.Vector3.Zero();
            this.maximumWorld = BABYLON.Vector3.Zero();
            this.centerWorld = BABYLON.Vector3.Zero();
            this.extendSizeWorld = BABYLON.Vector3.Zero();
            this._update(this._worldMatrix || BABYLON.Matrix.Identity());
        };
        BoundingBox.prototype.getWorldMatrix = function () {
            return this._worldMatrix;
        };
        BoundingBox.prototype.setWorldMatrix = function (matrix) {
            this._worldMatrix.copyFrom(matrix);
            return this;
        };
        BoundingBox.prototype._update = function (world) {
            BABYLON.Vector3.FromFloatsToRef(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE, this.minimumWorld);
            BABYLON.Vector3.FromFloatsToRef(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE, this.maximumWorld);
            for (var index = 0; index < this.vectors.length; index++) {
                var v = this.vectorsWorld[index];
                BABYLON.Vector3.TransformCoordinatesToRef(this.vectors[index], world, v);
                if (v.x < this.minimumWorld.x)
                    this.minimumWorld.x = v.x;
                if (v.y < this.minimumWorld.y)
                    this.minimumWorld.y = v.y;
                if (v.z < this.minimumWorld.z)
                    this.minimumWorld.z = v.z;
                if (v.x > this.maximumWorld.x)
                    this.maximumWorld.x = v.x;
                if (v.y > this.maximumWorld.y)
                    this.maximumWorld.y = v.y;
                if (v.z > this.maximumWorld.z)
                    this.maximumWorld.z = v.z;
            }
            // Extend
            this.maximumWorld.subtractToRef(this.minimumWorld, this.extendSizeWorld);
            this.extendSizeWorld.scaleInPlace(0.5);
            // OBB
            this.maximumWorld.addToRef(this.minimumWorld, this.centerWorld);
            this.centerWorld.scaleInPlace(0.5);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 0, this.directions[0]);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 4, this.directions[1]);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 8, this.directions[2]);
            this._worldMatrix = world;
        };
        BoundingBox.prototype.isInFrustum = function (frustumPlanes) {
            return BoundingBox.IsInFrustum(this.vectorsWorld, frustumPlanes);
        };
        BoundingBox.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return BoundingBox.IsCompletelyInFrustum(this.vectorsWorld, frustumPlanes);
        };
        BoundingBox.prototype.intersectsPoint = function (point) {
            var delta = -BABYLON.Epsilon;
            if (this.maximumWorld.x - point.x < delta || delta > point.x - this.minimumWorld.x)
                return false;
            if (this.maximumWorld.y - point.y < delta || delta > point.y - this.minimumWorld.y)
                return false;
            if (this.maximumWorld.z - point.z < delta || delta > point.z - this.minimumWorld.z)
                return false;
            return true;
        };
        BoundingBox.prototype.intersectsSphere = function (sphere) {
            return BoundingBox.IntersectsSphere(this.minimumWorld, this.maximumWorld, sphere.centerWorld, sphere.radiusWorld);
        };
        BoundingBox.prototype.intersectsMinMax = function (min, max) {
            if (this.maximumWorld.x < min.x || this.minimumWorld.x > max.x)
                return false;
            if (this.maximumWorld.y < min.y || this.minimumWorld.y > max.y)
                return false;
            if (this.maximumWorld.z < min.z || this.minimumWorld.z > max.z)
                return false;
            return true;
        };
        // Statics
        BoundingBox.Intersects = function (box0, box1) {
            if (box0.maximumWorld.x < box1.minimumWorld.x || box0.minimumWorld.x > box1.maximumWorld.x)
                return false;
            if (box0.maximumWorld.y < box1.minimumWorld.y || box0.minimumWorld.y > box1.maximumWorld.y)
                return false;
            if (box0.maximumWorld.z < box1.minimumWorld.z || box0.minimumWorld.z > box1.maximumWorld.z)
                return false;
            return true;
        };
        BoundingBox.IntersectsSphere = function (minPoint, maxPoint, sphereCenter, sphereRadius) {
            var vector = BABYLON.Vector3.Clamp(sphereCenter, minPoint, maxPoint);
            var num = BABYLON.Vector3.DistanceSquared(sphereCenter, vector);
            return (num <= (sphereRadius * sphereRadius));
        };
        BoundingBox.IsCompletelyInFrustum = function (boundingVectors, frustumPlanes) {
            for (var p = 0; p < 6; p++) {
                for (var i = 0; i < 8; i++) {
                    if (frustumPlanes[p].dotCoordinate(boundingVectors[i]) < 0) {
                        return false;
                    }
                }
            }
            return true;
        };
        BoundingBox.IsInFrustum = function (boundingVectors, frustumPlanes) {
            for (var p = 0; p < 6; p++) {
                var inCount = 8;
                for (var i = 0; i < 8; i++) {
                    if (frustumPlanes[p].dotCoordinate(boundingVectors[i]) < 0) {
                        --inCount;
                    }
                    else {
                        break;
                    }
                }
                if (inCount === 0)
                    return false;
            }
            return true;
        };
        return BoundingBox;
    }());
    BABYLON.BoundingBox = BoundingBox;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingBox.js.map

var BABYLON;
(function (BABYLON) {
    var computeBoxExtents = function (axis, box) {
        var p = BABYLON.Vector3.Dot(box.centerWorld, axis);
        var r0 = Math.abs(BABYLON.Vector3.Dot(box.directions[0], axis)) * box.extendSize.x;
        var r1 = Math.abs(BABYLON.Vector3.Dot(box.directions[1], axis)) * box.extendSize.y;
        var r2 = Math.abs(BABYLON.Vector3.Dot(box.directions[2], axis)) * box.extendSize.z;
        var r = r0 + r1 + r2;
        return {
            min: p - r,
            max: p + r
        };
    };
    var extentsOverlap = function (min0, max0, min1, max1) { return !(min0 > max1 || min1 > max0); };
    var axisOverlap = function (axis, box0, box1) {
        var result0 = computeBoxExtents(axis, box0);
        var result1 = computeBoxExtents(axis, box1);
        return extentsOverlap(result0.min, result0.max, result1.min, result1.max);
    };
    var BoundingInfo = /** @class */ (function () {
        function BoundingInfo(minimum, maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this._isLocked = false;
            this.boundingBox = new BABYLON.BoundingBox(minimum, maximum);
            this.boundingSphere = new BABYLON.BoundingSphere(minimum, maximum);
        }
        Object.defineProperty(BoundingInfo.prototype, "isLocked", {
            get: function () {
                return this._isLocked;
            },
            set: function (value) {
                this._isLocked = value;
            },
            enumerable: true,
            configurable: true
        });
        // Methods
        BoundingInfo.prototype.update = function (world) {
            if (this._isLocked) {
                return;
            }
            this.boundingBox._update(world);
            this.boundingSphere._update(world);
        };
        /**
         * Recreate the bounding info to be centered around a specific point given a specific extend.
         * @param center New center of the bounding info
         * @param extend New extend of the bounding info
         */
        BoundingInfo.prototype.centerOn = function (center, extend) {
            this.minimum = center.subtract(extend);
            this.maximum = center.add(extend);
            this.boundingBox = new BABYLON.BoundingBox(this.minimum, this.maximum);
            this.boundingSphere = new BABYLON.BoundingSphere(this.minimum, this.maximum);
            return this;
        };
        BoundingInfo.prototype.isInFrustum = function (frustumPlanes) {
            if (!this.boundingSphere.isInFrustum(frustumPlanes))
                return false;
            return this.boundingBox.isInFrustum(frustumPlanes);
        };
        Object.defineProperty(BoundingInfo.prototype, "diagonalLength", {
            /**
             * Gets the world distance between the min and max points of the bounding box
             */
            get: function () {
                var boundingBox = this.boundingBox;
                var size = boundingBox.maximumWorld.subtract(boundingBox.minimumWorld);
                return size.length();
            },
            enumerable: true,
            configurable: true
        });
        BoundingInfo.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return this.boundingBox.isCompletelyInFrustum(frustumPlanes);
        };
        BoundingInfo.prototype._checkCollision = function (collider) {
            return collider._canDoCollision(this.boundingSphere.centerWorld, this.boundingSphere.radiusWorld, this.boundingBox.minimumWorld, this.boundingBox.maximumWorld);
        };
        BoundingInfo.prototype.intersectsPoint = function (point) {
            if (!this.boundingSphere.centerWorld) {
                return false;
            }
            if (!this.boundingSphere.intersectsPoint(point)) {
                return false;
            }
            if (!this.boundingBox.intersectsPoint(point)) {
                return false;
            }
            return true;
        };
        BoundingInfo.prototype.intersects = function (boundingInfo, precise) {
            if (!this.boundingSphere.centerWorld || !boundingInfo.boundingSphere.centerWorld) {
                return false;
            }
            if (!BABYLON.BoundingSphere.Intersects(this.boundingSphere, boundingInfo.boundingSphere)) {
                return false;
            }
            if (!BABYLON.BoundingBox.Intersects(this.boundingBox, boundingInfo.boundingBox)) {
                return false;
            }
            if (!precise) {
                return true;
            }
            var box0 = this.boundingBox;
            var box1 = boundingInfo.boundingBox;
            if (!axisOverlap(box0.directions[0], box0, box1))
                return false;
            if (!axisOverlap(box0.directions[1], box0, box1))
                return false;
            if (!axisOverlap(box0.directions[2], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[0], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[1], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[2], box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[2]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[2]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[2]), box0, box1))
                return false;
            return true;
        };
        return BoundingInfo;
    }());
    BABYLON.BoundingInfo = BoundingInfo;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingInfo.js.map



var BABYLON;
(function (BABYLON) {
    var TransformNode = /** @class */ (function (_super) {
        __extends(TransformNode, _super);
        function TransformNode(name, scene, isPure) {
            if (scene === void 0) { scene = null; }
            if (isPure === void 0) { isPure = true; }
            var _this = _super.call(this, name, scene) || this;
            _this._forward = new BABYLON.Vector3(0, 0, 1);
            _this._forwardInverted = new BABYLON.Vector3(0, 0, -1);
            _this._up = new BABYLON.Vector3(0, 1, 0);
            _this._right = new BABYLON.Vector3(1, 0, 0);
            _this._rightInverted = new BABYLON.Vector3(-1, 0, 0);
            // Properties
            _this._rotation = BABYLON.Vector3.Zero();
            _this._scaling = BABYLON.Vector3.One();
            _this._isDirty = false;
            _this.billboardMode = TransformNode.BILLBOARDMODE_NONE;
            _this.scalingDeterminant = 1;
            _this.infiniteDistance = false;
            _this.position = BABYLON.Vector3.Zero();
            _this._localWorld = BABYLON.Matrix.Zero();
            _this._worldMatrix = BABYLON.Matrix.Zero();
            _this._worldMatrixDeterminant = 0;
            _this._absolutePosition = BABYLON.Vector3.Zero();
            _this._pivotMatrix = BABYLON.Matrix.Identity();
            _this._postMultiplyPivotMatrix = false;
            _this._isWorldMatrixFrozen = false;
            /**
            * An event triggered after the world matrix is updated
            */
            _this.onAfterWorldMatrixUpdateObservable = new BABYLON.Observable();
            _this._nonUniformScaling = false;
            if (isPure) {
                _this.getScene().addTransformNode(_this);
            }
            return _this;
        }
        /**
         * Gets a string idenfifying the name of the class
         * @returns "TransformNode" string
         */
        TransformNode.prototype.getClassName = function () {
            return "TransformNode";
        };
        Object.defineProperty(TransformNode.prototype, "rotation", {
            /**
              * Rotation property : a Vector3 depicting the rotation value in radians around each local axis X, Y, Z.
              * If rotation quaternion is set, this Vector3 will (almost always) be the Zero vector!
              * Default : (0.0, 0.0, 0.0)
              */
            get: function () {
                return this._rotation;
            },
            set: function (newRotation) {
                this._rotation = newRotation;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "scaling", {
            /**
             * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
             * Default : (1.0, 1.0, 1.0)
             */
            get: function () {
                return this._scaling;
            },
            /**
             * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
             * Default : (1.0, 1.0, 1.0)
            */
            set: function (newScaling) {
                this._scaling = newScaling;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "rotationQuaternion", {
            /**
             * Rotation Quaternion property : this a Quaternion object depicting the mesh rotation by using a unit quaternion.
             * It's null by default.
             * If set, only the rotationQuaternion is then used to compute the mesh rotation and its property `.rotation\ is then ignored and set to (0.0, 0.0, 0.0)
             */
            get: function () {
                return this._rotationQuaternion;
            },
            set: function (quaternion) {
                this._rotationQuaternion = quaternion;
                //reset the rotation vector. 
                if (quaternion && this.rotation.length()) {
                    this.rotation.copyFromFloats(0.0, 0.0, 0.0);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "forward", {
            /**
             * The forward direction of that transform in world space.
             */
            get: function () {
                return BABYLON.Vector3.Normalize(BABYLON.Vector3.TransformNormal(this.getScene().useRightHandedSystem ? this._forwardInverted : this._forward, this.getWorldMatrix()));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "up", {
            /**
             * The up direction of that transform in world space.
             */
            get: function () {
                return BABYLON.Vector3.Normalize(BABYLON.Vector3.TransformNormal(this._up, this.getWorldMatrix()));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "right", {
            /**
             * The right direction of that transform in world space.
             */
            get: function () {
                return BABYLON.Vector3.Normalize(BABYLON.Vector3.TransformNormal(this.getScene().useRightHandedSystem ? this._rightInverted : this._right, this.getWorldMatrix()));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the latest update of the World matrix
         * Returns a Matrix.
         */
        TransformNode.prototype.getWorldMatrix = function () {
            if (this._currentRenderId !== this.getScene().getRenderId()) {
                this.computeWorldMatrix();
            }
            return this._worldMatrix;
        };
        /** @hidden */
        TransformNode.prototype._getWorldMatrixDeterminant = function () {
            return this._worldMatrixDeterminant;
        };
        Object.defineProperty(TransformNode.prototype, "worldMatrixFromCache", {
            /**
             * Returns directly the latest state of the mesh World matrix.
             * A Matrix is returned.
             */
            get: function () {
                return this._worldMatrix;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Copies the paramater passed Matrix into the mesh Pose matrix.
         * Returns the TransformNode.
         */
        TransformNode.prototype.updatePoseMatrix = function (matrix) {
            this._poseMatrix.copyFrom(matrix);
            return this;
        };
        /**
         * Returns the mesh Pose matrix.
         * Returned object : Matrix
         */
        TransformNode.prototype.getPoseMatrix = function () {
            return this._poseMatrix;
        };
        TransformNode.prototype._isSynchronized = function () {
            if (this._isDirty) {
                return false;
            }
            if (this.billboardMode !== this._cache.billboardMode || this.billboardMode !== TransformNode.BILLBOARDMODE_NONE)
                return false;
            if (this._cache.pivotMatrixUpdated) {
                return false;
            }
            if (this.infiniteDistance) {
                return false;
            }
            if (!this._cache.position.equals(this.position))
                return false;
            if (this.rotationQuaternion) {
                if (!this._cache.rotationQuaternion.equals(this.rotationQuaternion))
                    return false;
            }
            if (!this._cache.rotation.equals(this.rotation))
                return false;
            if (!this._cache.scaling.equals(this.scaling))
                return false;
            return true;
        };
        TransformNode.prototype._initCache = function () {
            _super.prototype._initCache.call(this);
            this._cache.localMatrixUpdated = false;
            this._cache.position = BABYLON.Vector3.Zero();
            this._cache.scaling = BABYLON.Vector3.Zero();
            this._cache.rotation = BABYLON.Vector3.Zero();
            this._cache.rotationQuaternion = new BABYLON.Quaternion(0, 0, 0, 0);
            this._cache.billboardMode = -1;
        };
        TransformNode.prototype.markAsDirty = function (property) {
            if (property === "rotation") {
                this.rotationQuaternion = null;
            }
            this._currentRenderId = Number.MAX_VALUE;
            this._isDirty = true;
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "absolutePosition", {
            /**
             * Returns the current mesh absolute position.
             * Retuns a Vector3.
             */
            get: function () {
                return this._absolutePosition;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Sets a new matrix to apply before all other transformation
         * @param matrix defines the transform matrix
         * @returns the current TransformNode
         */
        TransformNode.prototype.setPreTransformMatrix = function (matrix) {
            return this.setPivotMatrix(matrix, false);
        };
        /**
         * Sets a new pivot matrix to the current node
         * @param matrix defines the new pivot matrix to use
         * @param postMultiplyPivotMatrix defines if the pivot matrix must be cancelled in the world matrix. When this parameter is set to true (default), the inverse of the pivot matrix is also applied at the end to cancel the transformation effect
         * @returns the current TransformNode
        */
        TransformNode.prototype.setPivotMatrix = function (matrix, postMultiplyPivotMatrix) {
            if (postMultiplyPivotMatrix === void 0) { postMultiplyPivotMatrix = true; }
            this._pivotMatrix = matrix.clone();
            this._cache.pivotMatrixUpdated = true;
            this._postMultiplyPivotMatrix = postMultiplyPivotMatrix;
            if (this._postMultiplyPivotMatrix) {
                if (!this._pivotMatrixInverse) {
                    this._pivotMatrixInverse = BABYLON.Matrix.Invert(this._pivotMatrix);
                }
                else {
                    this._pivotMatrix.invertToRef(this._pivotMatrixInverse);
                }
            }
            return this;
        };
        /**
         * Returns the mesh pivot matrix.
         * Default : Identity.
         * A Matrix is returned.
         */
        TransformNode.prototype.getPivotMatrix = function () {
            return this._pivotMatrix;
        };
        /**
         * Prevents the World matrix to be computed any longer.
         * Returns the TransformNode.
         */
        TransformNode.prototype.freezeWorldMatrix = function () {
            this._isWorldMatrixFrozen = false; // no guarantee world is not already frozen, switch off temporarily
            this.computeWorldMatrix(true);
            this._isWorldMatrixFrozen = true;
            return this;
        };
        /**
         * Allows back the World matrix computation.
         * Returns the TransformNode.
         */
        TransformNode.prototype.unfreezeWorldMatrix = function () {
            this._isWorldMatrixFrozen = false;
            this.computeWorldMatrix(true);
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "isWorldMatrixFrozen", {
            /**
             * True if the World matrix has been frozen.
             * Returns a boolean.
             */
            get: function () {
                return this._isWorldMatrixFrozen;
            },
            enumerable: true,
            configurable: true
        });
        /**
            * Retuns the mesh absolute position in the World.
            * Returns a Vector3.
            */
        TransformNode.prototype.getAbsolutePosition = function () {
            this.computeWorldMatrix();
            return this._absolutePosition;
        };
        /**
         * Sets the mesh absolute position in the World from a Vector3 or an Array(3).
         * Returns the TransformNode.
         */
        TransformNode.prototype.setAbsolutePosition = function (absolutePosition) {
            if (!absolutePosition) {
                return this;
            }
            var absolutePositionX;
            var absolutePositionY;
            var absolutePositionZ;
            if (absolutePosition.x === undefined) {
                if (arguments.length < 3) {
                    return this;
                }
                absolutePositionX = arguments[0];
                absolutePositionY = arguments[1];
                absolutePositionZ = arguments[2];
            }
            else {
                absolutePositionX = absolutePosition.x;
                absolutePositionY = absolutePosition.y;
                absolutePositionZ = absolutePosition.z;
            }
            if (this.parent) {
                var invertParentWorldMatrix = this.parent.getWorldMatrix().clone();
                invertParentWorldMatrix.invert();
                var worldPosition = new BABYLON.Vector3(absolutePositionX, absolutePositionY, absolutePositionZ);
                this.position = BABYLON.Vector3.TransformCoordinates(worldPosition, invertParentWorldMatrix);
            }
            else {
                this.position.x = absolutePositionX;
                this.position.y = absolutePositionY;
                this.position.z = absolutePositionZ;
            }
            return this;
        };
        /**
           * Sets the mesh position in its local space.
           * Returns the TransformNode.
           */
        TransformNode.prototype.setPositionWithLocalVector = function (vector3) {
            this.computeWorldMatrix();
            this.position = BABYLON.Vector3.TransformNormal(vector3, this._localWorld);
            return this;
        };
        /**
         * Returns the mesh position in the local space from the current World matrix values.
         * Returns a new Vector3.
         */
        TransformNode.prototype.getPositionExpressedInLocalSpace = function () {
            this.computeWorldMatrix();
            var invLocalWorldMatrix = this._localWorld.clone();
            invLocalWorldMatrix.invert();
            return BABYLON.Vector3.TransformNormal(this.position, invLocalWorldMatrix);
        };
        /**
         * Translates the mesh along the passed Vector3 in its local space.
         * Returns the TransformNode.
         */
        TransformNode.prototype.locallyTranslate = function (vector3) {
            this.computeWorldMatrix(true);
            this.position = BABYLON.Vector3.TransformCoordinates(vector3, this._localWorld);
            return this;
        };
        /**
         * Orients a mesh towards a target point. Mesh must be drawn facing user.
         * @param targetPoint the position (must be in same space as current mesh) to look at
         * @param yawCor optional yaw (y-axis) correction in radians
         * @param pitchCor optional pitch (x-axis) correction in radians
         * @param rollCor optional roll (z-axis) correction in radians
         * @param space the choosen space of the target
         * @returns the TransformNode.
         */
        TransformNode.prototype.lookAt = function (targetPoint, yawCor, pitchCor, rollCor, space) {
            if (yawCor === void 0) { yawCor = 0; }
            if (pitchCor === void 0) { pitchCor = 0; }
            if (rollCor === void 0) { rollCor = 0; }
            if (space === void 0) { space = BABYLON.Space.LOCAL; }
            var dv = TransformNode._lookAtVectorCache;
            var pos = space === BABYLON.Space.LOCAL ? this.position : this.getAbsolutePosition();
            targetPoint.subtractToRef(pos, dv);
            var yaw = -Math.atan2(dv.z, dv.x) - Math.PI / 2;
            var len = Math.sqrt(dv.x * dv.x + dv.z * dv.z);
            var pitch = Math.atan2(dv.y, len);
            if (this.rotationQuaternion) {
                BABYLON.Quaternion.RotationYawPitchRollToRef(yaw + yawCor, pitch + pitchCor, rollCor, this.rotationQuaternion);
            }
            else {
                this.rotation.x = pitch + pitchCor;
                this.rotation.y = yaw + yawCor;
                this.rotation.z = rollCor;
            }
            return this;
        };
        /**
          * Returns a new Vector3 what is the localAxis, expressed in the mesh local space, rotated like the mesh.
          * This Vector3 is expressed in the World space.
          */
        TransformNode.prototype.getDirection = function (localAxis) {
            var result = BABYLON.Vector3.Zero();
            this.getDirectionToRef(localAxis, result);
            return result;
        };
        /**
         * Sets the Vector3 "result" as the rotated Vector3 "localAxis" in the same rotation than the mesh.
         * localAxis is expressed in the mesh local space.
         * result is computed in the Wordl space from the mesh World matrix.
         * Returns the TransformNode.
         */
        TransformNode.prototype.getDirectionToRef = function (localAxis, result) {
            BABYLON.Vector3.TransformNormalToRef(localAxis, this.getWorldMatrix(), result);
            return this;
        };
        /**
         * Sets a new pivot point to the current node
         * @param point defines the new pivot point to use
         * @param space defines if the point is in world or local space (local by default)
         * @returns the current TransformNode
        */
        TransformNode.prototype.setPivotPoint = function (point, space) {
            if (space === void 0) { space = BABYLON.Space.LOCAL; }
            if (this.getScene().getRenderId() == 0) {
                this.computeWorldMatrix(true);
            }
            var wm = this.getWorldMatrix();
            if (space == BABYLON.Space.WORLD) {
                var tmat = BABYLON.Tmp.Matrix[0];
                wm.invertToRef(tmat);
                point = BABYLON.Vector3.TransformCoordinates(point, tmat);
            }
            return this.setPivotMatrix(BABYLON.Matrix.Translation(-point.x, -point.y, -point.z), true);
        };
        /**
         * Returns a new Vector3 set with the mesh pivot point coordinates in the local space.
         */
        TransformNode.prototype.getPivotPoint = function () {
            var point = BABYLON.Vector3.Zero();
            this.getPivotPointToRef(point);
            return point;
        };
        /**
         * Sets the passed Vector3 "result" with the coordinates of the mesh pivot point in the local space.
         * Returns the TransformNode.
         */
        TransformNode.prototype.getPivotPointToRef = function (result) {
            result.x = -this._pivotMatrix.m[12];
            result.y = -this._pivotMatrix.m[13];
            result.z = -this._pivotMatrix.m[14];
            return this;
        };
        /**
         * Returns a new Vector3 set with the mesh pivot point World coordinates.
         */
        TransformNode.prototype.getAbsolutePivotPoint = function () {
            var point = BABYLON.Vector3.Zero();
            this.getAbsolutePivotPointToRef(point);
            return point;
        };
        /**
         * Sets the Vector3 "result" coordinates with the mesh pivot point World coordinates.
         * Returns the TransformNode.
         */
        TransformNode.prototype.getAbsolutePivotPointToRef = function (result) {
            result.x = this._pivotMatrix.m[12];
            result.y = this._pivotMatrix.m[13];
            result.z = this._pivotMatrix.m[14];
            this.getPivotPointToRef(result);
            BABYLON.Vector3.TransformCoordinatesToRef(result, this.getWorldMatrix(), result);
            return this;
        };
        /**
         * Defines the passed node as the parent of the current node.
         * The node will remain exactly where it is and its position / rotation will be updated accordingly
         * Returns the TransformNode.
         */
        TransformNode.prototype.setParent = function (node) {
            if (node === null) {
                var rotation = BABYLON.Tmp.Quaternion[0];
                var position = BABYLON.Tmp.Vector3[0];
                var scale = BABYLON.Tmp.Vector3[1];
                if (this.parent && this.parent.computeWorldMatrix) {
                    this.parent.computeWorldMatrix(true);
                }
                this.computeWorldMatrix(true);
                this.getWorldMatrix().decompose(scale, rotation, position);
                if (this.rotationQuaternion) {
                    this.rotationQuaternion.copyFrom(rotation);
                }
                else {
                    rotation.toEulerAnglesToRef(this.rotation);
                }
                this.scaling.x = scale.x;
                this.scaling.y = scale.y;
                this.scaling.z = scale.z;
                this.position.x = position.x;
                this.position.y = position.y;
                this.position.z = position.z;
            }
            else {
                var rotation = BABYLON.Tmp.Quaternion[0];
                var position = BABYLON.Tmp.Vector3[0];
                var scale = BABYLON.Tmp.Vector3[1];
                var diffMatrix = BABYLON.Tmp.Matrix[0];
                var invParentMatrix = BABYLON.Tmp.Matrix[1];
                this.computeWorldMatrix(true);
                node.computeWorldMatrix(true);
                node.getWorldMatrix().invertToRef(invParentMatrix);
                this.getWorldMatrix().multiplyToRef(invParentMatrix, diffMatrix);
                diffMatrix.decompose(scale, rotation, position);
                if (this.rotationQuaternion) {
                    this.rotationQuaternion.copyFrom(rotation);
                }
                else {
                    rotation.toEulerAnglesToRef(this.rotation);
                }
                this.position.x = position.x;
                this.position.y = position.y;
                this.position.z = position.z;
                this.scaling.x = scale.x;
                this.scaling.y = scale.y;
                this.scaling.z = scale.z;
            }
            this.parent = node;
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "nonUniformScaling", {
            get: function () {
                return this._nonUniformScaling;
            },
            enumerable: true,
            configurable: true
        });
        TransformNode.prototype._updateNonUniformScalingState = function (value) {
            if (this._nonUniformScaling === value) {
                return false;
            }
            this._nonUniformScaling = true;
            return true;
        };
        /**
         * Attach the current TransformNode to another TransformNode associated with a bone
         * @param bone Bone affecting the TransformNode
         * @param affectedTransformNode TransformNode associated with the bone
         */
        TransformNode.prototype.attachToBone = function (bone, affectedTransformNode) {
            this._transformToBoneReferal = affectedTransformNode;
            this.parent = bone;
            if (bone.getWorldMatrix().determinant() < 0) {
                this.scalingDeterminant *= -1;
            }
            return this;
        };
        TransformNode.prototype.detachFromBone = function () {
            if (!this.parent) {
                return this;
            }
            if (this.parent.getWorldMatrix().determinant() < 0) {
                this.scalingDeterminant *= -1;
            }
            this._transformToBoneReferal = null;
            this.parent = null;
            return this;
        };
        /**
         * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in the given space.
         * space (default LOCAL) can be either BABYLON.Space.LOCAL, either BABYLON.Space.WORLD.
         * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
         * The passed axis is also normalized.
         * Returns the TransformNode.
         */
        TransformNode.prototype.rotate = function (axis, amount, space) {
            axis.normalize();
            if (!this.rotationQuaternion) {
                this.rotationQuaternion = BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
                this.rotation = BABYLON.Vector3.Zero();
            }
            var rotationQuaternion;
            if (!space || space === BABYLON.Space.LOCAL) {
                rotationQuaternion = BABYLON.Quaternion.RotationAxisToRef(axis, amount, TransformNode._rotationAxisCache);
                this.rotationQuaternion.multiplyToRef(rotationQuaternion, this.rotationQuaternion);
            }
            else {
                if (this.parent) {
                    var invertParentWorldMatrix = this.parent.getWorldMatrix().clone();
                    invertParentWorldMatrix.invert();
                    axis = BABYLON.Vector3.TransformNormal(axis, invertParentWorldMatrix);
                }
                rotationQuaternion = BABYLON.Quaternion.RotationAxisToRef(axis, amount, TransformNode._rotationAxisCache);
                rotationQuaternion.multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
            }
            return this;
        };
        /**
         * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in world space.
         * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
         * The passed axis is also normalized.
         * Returns the TransformNode.
         * Method is based on http://www.euclideanspace.com/maths/geometry/affine/aroundPoint/index.htm
         */
        TransformNode.prototype.rotateAround = function (point, axis, amount) {
            axis.normalize();
            if (!this.rotationQuaternion) {
                this.rotationQuaternion = BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
                this.rotation.copyFromFloats(0, 0, 0);
            }
            point.subtractToRef(this.position, BABYLON.Tmp.Vector3[0]);
            BABYLON.Matrix.TranslationToRef(BABYLON.Tmp.Vector3[0].x, BABYLON.Tmp.Vector3[0].y, BABYLON.Tmp.Vector3[0].z, BABYLON.Tmp.Matrix[0]);
            BABYLON.Tmp.Matrix[0].invertToRef(BABYLON.Tmp.Matrix[2]);
            BABYLON.Matrix.RotationAxisToRef(axis, amount, BABYLON.Tmp.Matrix[1]);
            BABYLON.Tmp.Matrix[2].multiplyToRef(BABYLON.Tmp.Matrix[1], BABYLON.Tmp.Matrix[2]);
            BABYLON.Tmp.Matrix[2].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[2]);
            BABYLON.Tmp.Matrix[2].decompose(BABYLON.Tmp.Vector3[0], BABYLON.Tmp.Quaternion[0], BABYLON.Tmp.Vector3[1]);
            this.position.addInPlace(BABYLON.Tmp.Vector3[1]);
            BABYLON.Tmp.Quaternion[0].multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
            return this;
        };
        /**
         * Translates the mesh along the axis vector for the passed distance in the given space.
         * space (default LOCAL) can be either BABYLON.Space.LOCAL, either BABYLON.Space.WORLD.
         * Returns the TransformNode.
         */
        TransformNode.prototype.translate = function (axis, distance, space) {
            var displacementVector = axis.scale(distance);
            if (!space || space === BABYLON.Space.LOCAL) {
                var tempV3 = this.getPositionExpressedInLocalSpace().add(displacementVector);
                this.setPositionWithLocalVector(tempV3);
            }
            else {
                this.setAbsolutePosition(this.getAbsolutePosition().add(displacementVector));
            }
            return this;
        };
        /**
         * Adds a rotation step to the mesh current rotation.
         * x, y, z are Euler angles expressed in radians.
         * This methods updates the current mesh rotation, either mesh.rotation, either mesh.rotationQuaternion if it's set.
         * This means this rotation is made in the mesh local space only.
         * It's useful to set a custom rotation order different from the BJS standard one YXZ.
         * Example : this rotates the mesh first around its local X axis, then around its local Z axis, finally around its local Y axis.
         * ```javascript
         * mesh.addRotation(x1, 0, 0).addRotation(0, 0, z2).addRotation(0, 0, y3);
         * ```
         * Note that `addRotation()` accumulates the passed rotation values to the current ones and computes the .rotation or .rotationQuaternion updated values.
         * Under the hood, only quaternions are used. So it's a little faster is you use .rotationQuaternion because it doesn't need to translate them back to Euler angles.
         * Returns the TransformNode.
         */
        TransformNode.prototype.addRotation = function (x, y, z) {
            var rotationQuaternion;
            if (this.rotationQuaternion) {
                rotationQuaternion = this.rotationQuaternion;
            }
            else {
                rotationQuaternion = BABYLON.Tmp.Quaternion[1];
                BABYLON.Quaternion.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, rotationQuaternion);
            }
            var accumulation = BABYLON.Tmp.Quaternion[0];
            BABYLON.Quaternion.RotationYawPitchRollToRef(y, x, z, accumulation);
            rotationQuaternion.multiplyInPlace(accumulation);
            if (!this.rotationQuaternion) {
                rotationQuaternion.toEulerAnglesToRef(this.rotation);
            }
            return this;
        };
        /**
         * Computes the mesh World matrix and returns it.
         * If the mesh world matrix is frozen, this computation does nothing more than returning the last frozen values.
         * If the parameter `force` is let to `false` (default), the current cached World matrix is returned.
         * If the parameter `force`is set to `true`, the actual computation is done.
         * Returns the mesh World Matrix.
         */
        TransformNode.prototype.computeWorldMatrix = function (force) {
            if (this._isWorldMatrixFrozen) {
                return this._worldMatrix;
            }
            if (!force && this.isSynchronized(true)) {
                this._currentRenderId = this.getScene().getRenderId();
                return this._worldMatrix;
            }
            this._cache.position.copyFrom(this.position);
            this._cache.scaling.copyFrom(this.scaling);
            this._cache.pivotMatrixUpdated = false;
            this._cache.billboardMode = this.billboardMode;
            this._currentRenderId = this.getScene().getRenderId();
            this._childRenderId = this.getScene().getRenderId();
            this._isDirty = false;
            // Scaling
            BABYLON.Matrix.ScalingToRef(this.scaling.x * this.scalingDeterminant, this.scaling.y * this.scalingDeterminant, this.scaling.z * this.scalingDeterminant, BABYLON.Tmp.Matrix[1]);
            // Rotation
            //rotate, if quaternion is set and rotation was used
            if (this.rotationQuaternion) {
                var len = this.rotation.length();
                if (len) {
                    this.rotationQuaternion.multiplyInPlace(BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z));
                    this.rotation.copyFromFloats(0, 0, 0);
                }
            }
            if (this.rotationQuaternion) {
                this.rotationQuaternion.toRotationMatrix(BABYLON.Tmp.Matrix[0]);
                this._cache.rotationQuaternion.copyFrom(this.rotationQuaternion);
            }
            else {
                BABYLON.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, BABYLON.Tmp.Matrix[0]);
                this._cache.rotation.copyFrom(this.rotation);
            }
            // Translation
            var camera = this.getScene().activeCamera;
            if (this.infiniteDistance && !this.parent && camera) {
                var cameraWorldMatrix = camera.getWorldMatrix();
                var cameraGlobalPosition = new BABYLON.Vector3(cameraWorldMatrix.m[12], cameraWorldMatrix.m[13], cameraWorldMatrix.m[14]);
                BABYLON.Matrix.TranslationToRef(this.position.x + cameraGlobalPosition.x, this.position.y + cameraGlobalPosition.y, this.position.z + cameraGlobalPosition.z, BABYLON.Tmp.Matrix[2]);
            }
            else {
                BABYLON.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, BABYLON.Tmp.Matrix[2]);
            }
            // Composing transformations
            this._pivotMatrix.multiplyToRef(BABYLON.Tmp.Matrix[1], BABYLON.Tmp.Matrix[4]);
            BABYLON.Tmp.Matrix[4].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[5]);
            // Billboarding (testing PG:http://www.babylonjs-playground.com/#UJEIL#13)
            if (this.billboardMode !== TransformNode.BILLBOARDMODE_NONE && camera) {
                if ((this.billboardMode & TransformNode.BILLBOARDMODE_ALL) !== TransformNode.BILLBOARDMODE_ALL) {
                    // Need to decompose each rotation here
                    var currentPosition = BABYLON.Tmp.Vector3[3];
                    if (this.parent && this.parent.getWorldMatrix) {
                        if (this._transformToBoneReferal) {
                            this.parent.getWorldMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                            BABYLON.Vector3.TransformCoordinatesToRef(this.position, BABYLON.Tmp.Matrix[6], currentPosition);
                        }
                        else {
                            BABYLON.Vector3.TransformCoordinatesToRef(this.position, this.parent.getWorldMatrix(), currentPosition);
                        }
                    }
                    else {
                        currentPosition.copyFrom(this.position);
                    }
                    currentPosition.subtractInPlace(camera.globalPosition);
                    var finalEuler = BABYLON.Tmp.Vector3[4].copyFromFloats(0, 0, 0);
                    if ((this.billboardMode & TransformNode.BILLBOARDMODE_X) === TransformNode.BILLBOARDMODE_X) {
                        finalEuler.x = Math.atan2(-currentPosition.y, currentPosition.z);
                    }
                    if ((this.billboardMode & TransformNode.BILLBOARDMODE_Y) === TransformNode.BILLBOARDMODE_Y) {
                        finalEuler.y = Math.atan2(currentPosition.x, currentPosition.z);
                    }
                    if ((this.billboardMode & TransformNode.BILLBOARDMODE_Z) === TransformNode.BILLBOARDMODE_Z) {
                        finalEuler.z = Math.atan2(currentPosition.y, currentPosition.x);
                    }
                    BABYLON.Matrix.RotationYawPitchRollToRef(finalEuler.y, finalEuler.x, finalEuler.z, BABYLON.Tmp.Matrix[0]);
                }
                else {
                    BABYLON.Tmp.Matrix[1].copyFrom(camera.getViewMatrix());
                    BABYLON.Tmp.Matrix[1].setTranslationFromFloats(0, 0, 0);
                    BABYLON.Tmp.Matrix[1].invertToRef(BABYLON.Tmp.Matrix[0]);
                }
                BABYLON.Tmp.Matrix[1].copyFrom(BABYLON.Tmp.Matrix[5]);
                BABYLON.Tmp.Matrix[1].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[5]);
            }
            // Local world
            BABYLON.Tmp.Matrix[5].multiplyToRef(BABYLON.Tmp.Matrix[2], this._localWorld);
            // Parent
            if (this.parent && this.parent.getWorldMatrix) {
                if (this.billboardMode !== TransformNode.BILLBOARDMODE_NONE) {
                    if (this._transformToBoneReferal) {
                        this.parent.getWorldMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                        BABYLON.Tmp.Matrix[5].copyFrom(BABYLON.Tmp.Matrix[6]);
                    }
                    else {
                        BABYLON.Tmp.Matrix[5].copyFrom(this.parent.getWorldMatrix());
                    }
                    this._localWorld.getTranslationToRef(BABYLON.Tmp.Vector3[5]);
                    BABYLON.Vector3.TransformCoordinatesToRef(BABYLON.Tmp.Vector3[5], BABYLON.Tmp.Matrix[5], BABYLON.Tmp.Vector3[5]);
                    this._worldMatrix.copyFrom(this._localWorld);
                    this._worldMatrix.setTranslation(BABYLON.Tmp.Vector3[5]);
                }
                else {
                    if (this._transformToBoneReferal) {
                        this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                        BABYLON.Tmp.Matrix[6].multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), this._worldMatrix);
                    }
                    else {
                        this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), this._worldMatrix);
                    }
                }
                this._markSyncedWithParent();
            }
            else {
                this._worldMatrix.copyFrom(this._localWorld);
            }
            // Post multiply inverse of pivotMatrix
            if (this._postMultiplyPivotMatrix) {
                this._worldMatrix.multiplyToRef(this._pivotMatrixInverse, this._worldMatrix);
            }
            // Normal matrix
            if (this.scaling.isNonUniform) {
                this._updateNonUniformScalingState(true);
            }
            else if (this.parent && this.parent._nonUniformScaling) {
                this._updateNonUniformScalingState(this.parent._nonUniformScaling);
            }
            else {
                this._updateNonUniformScalingState(false);
            }
            this._afterComputeWorldMatrix();
            // Absolute position
            this._absolutePosition.copyFromFloats(this._worldMatrix.m[12], this._worldMatrix.m[13], this._worldMatrix.m[14]);
            // Callbacks
            this.onAfterWorldMatrixUpdateObservable.notifyObservers(this);
            if (!this._poseMatrix) {
                this._poseMatrix = BABYLON.Matrix.Invert(this._worldMatrix);
            }
            // Cache the determinant
            this._worldMatrixDeterminant = this._worldMatrix.determinant();
            return this._worldMatrix;
        };
        TransformNode.prototype._afterComputeWorldMatrix = function () {
        };
        /**
        * If you'd like to be called back after the mesh position, rotation or scaling has been updated.
        * @param func: callback function to add
        *
        * Returns the TransformNode.
        */
        TransformNode.prototype.registerAfterWorldMatrixUpdate = function (func) {
            this.onAfterWorldMatrixUpdateObservable.add(func);
            return this;
        };
        /**
         * Removes a registered callback function.
         * Returns the TransformNode.
         */
        TransformNode.prototype.unregisterAfterWorldMatrixUpdate = function (func) {
            this.onAfterWorldMatrixUpdateObservable.removeCallback(func);
            return this;
        };
        /**
         * Clone the current transform node
         * Returns the new transform node
         * @param name Name of the new clone
         * @param newParent New parent for the clone
         * @param doNotCloneChildren Do not clone children hierarchy
         */
        TransformNode.prototype.clone = function (name, newParent, doNotCloneChildren) {
            var _this = this;
            var result = BABYLON.SerializationHelper.Clone(function () { return new TransformNode(name, _this.getScene()); }, this);
            result.name = name;
            result.id = name;
            if (newParent) {
                result.parent = newParent;
            }
            if (!doNotCloneChildren) {
                // Children
                var directDescendants = this.getDescendants(true);
                for (var index = 0; index < directDescendants.length; index++) {
                    var child = directDescendants[index];
                    if (child.clone) {
                        child.clone(name + "." + child.name, result);
                    }
                }
            }
            return result;
        };
        TransformNode.prototype.serialize = function (currentSerializationObject) {
            var serializationObject = BABYLON.SerializationHelper.Serialize(this, currentSerializationObject);
            serializationObject.type = this.getClassName();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            if (BABYLON.Tags && BABYLON.Tags.HasTags(this)) {
                serializationObject.tags = BABYLON.Tags.GetTags(this);
            }
            serializationObject.localMatrix = this.getPivotMatrix().asArray();
            serializationObject.isEnabled = this.isEnabled();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            return serializationObject;
        };
        // Statics
        /**
         * Returns a new TransformNode object parsed from the source provided.
         * The parameter `parsedMesh` is the source.
         * The parameter `rootUrl` is a string, it's the root URL to prefix the `delayLoadingFile` property with
         */
        TransformNode.Parse = function (parsedTransformNode, scene, rootUrl) {
            var transformNode = BABYLON.SerializationHelper.Parse(function () { return new TransformNode(parsedTransformNode.name, scene); }, parsedTransformNode, scene, rootUrl);
            if (BABYLON.Tags) {
                BABYLON.Tags.AddTagsTo(transformNode, parsedTransformNode.tags);
            }
            if (parsedTransformNode.localMatrix) {
                transformNode.setPreTransformMatrix(BABYLON.Matrix.FromArray(parsedTransformNode.localMatrix));
            }
            else if (parsedTransformNode.pivotMatrix) {
                transformNode.setPivotMatrix(BABYLON.Matrix.FromArray(parsedTransformNode.pivotMatrix));
            }
            transformNode.setEnabled(parsedTransformNode.isEnabled);
            // Parent
            if (parsedTransformNode.parentId) {
                transformNode._waitingParentId = parsedTransformNode.parentId;
            }
            return transformNode;
        };
        /**
         * Releases resources associated with this transform node.
         * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
         * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
         */
        TransformNode.prototype.dispose = function (doNotRecurse, disposeMaterialAndTextures) {
            if (disposeMaterialAndTextures === void 0) { disposeMaterialAndTextures = false; }
            // Animations
            this.getScene().stopAnimation(this);
            // Remove from scene
            this.getScene().removeTransformNode(this);
            this.onAfterWorldMatrixUpdateObservable.clear();
            _super.prototype.dispose.call(this, doNotRecurse, disposeMaterialAndTextures);
        };
        // Statics
        TransformNode.BILLBOARDMODE_NONE = 0;
        TransformNode.BILLBOARDMODE_X = 1;
        TransformNode.BILLBOARDMODE_Y = 2;
        TransformNode.BILLBOARDMODE_Z = 4;
        TransformNode.BILLBOARDMODE_ALL = 7;
        TransformNode._lookAtVectorCache = new BABYLON.Vector3(0, 0, 0);
        TransformNode._rotationAxisCache = new BABYLON.Quaternion();
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "_rotation", void 0);
        __decorate([
            BABYLON.serializeAsQuaternion()
        ], TransformNode.prototype, "_rotationQuaternion", void 0);
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "_scaling", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "billboardMode", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "scalingDeterminant", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "infiniteDistance", void 0);
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "position", void 0);
        return TransformNode;
    }(BABYLON.Node));
    BABYLON.TransformNode = TransformNode;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.transformNode.js.map


var BABYLON;
(function (BABYLON) {
    /**
     * Class used to store all common mesh properties
     */
    var AbstractMesh = /** @class */ (function (_super) {
        __extends(AbstractMesh, _super);
        // Constructor
        /**
         * Creates a new AbstractMesh
         * @param name defines the name of the mesh
         * @param scene defines the hosting scene
         */
        function AbstractMesh(name, scene) {
            if (scene === void 0) { scene = null; }
            var _this = _super.call(this, name, scene, false) || this;
            _this._facetNb = 0; // facet number
            _this._partitioningSubdivisions = 10; // number of subdivisions per axis in the partioning space  
            _this._partitioningBBoxRatio = 1.01; // the partioning array space is by default 1% bigger than the bounding box
            _this._facetDataEnabled = false; // is the facet data feature enabled on this mesh ?
            _this._facetParameters = {}; // keep a reference to the object parameters to avoid memory re-allocation
            _this._bbSize = BABYLON.Vector3.Zero(); // bbox size approximated for facet data
            _this._subDiv = {
                max: 1,
                X: 1,
                Y: 1,
                Z: 1
            };
            _this._facetDepthSort = false; // is the facet depth sort to be computed
            _this._facetDepthSortEnabled = false; // is the facet depth sort initialized
            // Events
            /**
            * An event triggered when this mesh collides with another one
            */
            _this.onCollideObservable = new BABYLON.Observable();
            /**
            * An event triggered when the collision's position changes
            */
            _this.onCollisionPositionChangeObservable = new BABYLON.Observable();
            /**
            * An event triggered when material is changed
            */
            _this.onMaterialChangedObservable = new BABYLON.Observable();
            // Properties
            /**
             * Gets or sets the orientation for POV movement & rotation
             */
            _this.definedFacingForward = true;
            /**
            * This property determines the type of occlusion query algorithm to run in WebGl, you can use:
            * * AbstractMesh.OCCLUSION_ALGORITHM_TYPE_ACCURATE which is mapped to GL_ANY_SAMPLES_PASSED.
            * * AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE (Default Value) which is mapped to GL_ANY_SAMPLES_PASSED_CONSERVATIVE which is a false positive algorithm that is faster than GL_ANY_SAMPLES_PASSED but less accurate.
            * @see http://doc.babylonjs.com/features/occlusionquery
            */
            _this.occlusionQueryAlgorithmType = AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE;
            /**
             * This property is responsible for starting the occlusion query within the Mesh or not, this property is also used to determine what should happen when the occlusionRetryCount is reached. It has supports 3 values:
             * * OCCLUSION_TYPE_NONE (Default Value): this option means no occlusion query whith the Mesh.
             * * OCCLUSION_TYPE_OPTIMISTIC: this option is means use occlusion query and if occlusionRetryCount is reached and the query is broken show the mesh.
             * * OCCLUSION_TYPE_STRICT: this option is means use occlusion query and if occlusionRetryCount is reached and the query is broken restore the last state of the mesh occlusion if the mesh was visible then show the mesh if was hidden then hide don't show.
             * @see http://doc.babylonjs.com/features/occlusionquery
             */
            _this.occlusionType = AbstractMesh.OCCLUSION_TYPE_NONE;
            /**
            * This number indicates the number of allowed retries before stop the occlusion query, this is useful if the occlusion query is taking long time before to the query result is retireved, the query result indicates if the object is visible within the scene or not and based on that Babylon.Js engine decideds to show or hide the object.
            * The default value is -1 which means don't break the query and wait till the result
            * @see http://doc.babylonjs.com/features/occlusionquery
            */
            _this.occlusionRetryCount = -1;
            _this._occlusionInternalRetryCounter = 0;
            _this._isOccluded = false;
            _this._isOcclusionQueryInProgress = false;
            _this._visibility = 1.0;
            /** Gets or sets the alpha index used to sort transparent meshes
             * @see http://doc.babylonjs.com/resources/transparency_and_how_meshes_are_rendered#alpha-index
             */
            _this.alphaIndex = Number.MAX_VALUE;
            /**
             * Gets or sets a boolean indicating if the mesh is visible (renderable). Default is true
             */
            _this.isVisible = true;
            /**
             * Gets or sets a boolean indicating if the mesh can be picked (by scene.pick for instance or through actions). Default is true
             */
            _this.isPickable = true;
            /**
             * Gets or sets a boolean indicating if the bounding box must be rendered as well (false by default)
             */
            _this.showBoundingBox = false;
            /** Gets or sets a boolean indicating that bounding boxes of subMeshes must be rendered as well (false by default) */
            _this.showSubMeshesBoundingBox = false;
            /** Gets or sets a boolean indicating if the mesh must be considered as a ray blocker for lens flares (false by default)
             * @see http://doc.babylonjs.com/how_to/how_to_use_lens_flares
             */
            _this.isBlocker = false;
            /**
             * Gets or sets a boolean indicating that pointer move events must be supported on this mesh (false by default)
             */
            _this.enablePointerMoveEvents = false;
            /**
             * Specifies the rendering group id for this mesh (0 by default)
             * @see http://doc.babylonjs.com/resources/transparency_and_how_meshes_are_rendered#rendering-groups
             */
            _this.renderingGroupId = 0;
            _this._receiveShadows = false;
            /**
             * Gets or sets a boolean indicating if the outline must be rendered as well
             * @see https://www.babylonjs-playground.com/#10WJ5S#3
             */
            _this.renderOutline = false;
            /** Defines color to use when rendering outline */
            _this.outlineColor = BABYLON.Color3.Red();
            /** Define width to use when rendering outline */
            _this.outlineWidth = 0.02;
            /**
             * Gets or sets a boolean indicating if the overlay must be rendered as well
             * @see https://www.babylonjs-playground.com/#10WJ5S#2
             */
            _this.renderOverlay = false;
            /** Defines color to use when rendering overlay */
            _this.overlayColor = BABYLON.Color3.Red();
            /** Defines alpha to use when rendering overlay */
            _this.overlayAlpha = 0.5;
            _this._hasVertexAlpha = false;
            _this._useVertexColors = true;
            _this._computeBonesUsingShaders = true;
            _this._numBoneInfluencers = 4;
            _this._applyFog = true;
            /** Gets or sets a boolean indicating that internal octree (if available) can be used to boost submeshes selection (true by default) */
            _this.useOctreeForRenderingSelection = true;
            /** Gets or sets a boolean indicating that internal octree (if available) can be used to boost submeshes picking (true by default) */
            _this.useOctreeForPicking = true;
            /** Gets or sets a boolean indicating that internal octree (if available) can be used to boost submeshes collision (true by default) */
            _this.useOctreeForCollisions = true;
            _this._layerMask = 0x0FFFFFFF;
            /**
             * True if the mesh must be rendered in any case (this will shortcut the frustum clipping phase)
             */
            _this.alwaysSelectAsActiveMesh = false;
            /**
             * Gets or sets the current action manager
             * @see http://doc.babylonjs.com/how_to/how_to_use_actions
             */
            _this.actionManager = null;
            /**
             * Gets or sets impostor used for physic simulation
             * @see http://doc.babylonjs.com/features/physics_engine
             */
            _this.physicsImpostor = null;
            // Collisions
            _this._checkCollisions = false;
            _this._collisionMask = -1;
            _this._collisionGroup = -1;
            /**
             * Gets or sets the ellipsoid used to impersonate this mesh when using collision engine (default is (0.5, 1, 0.5))
             * @see http://doc.babylonjs.com/babylon101/cameras,_mesh_collisions_and_gravity
             */
            _this.ellipsoid = new BABYLON.Vector3(0.5, 1, 0.5);
            /**
             * Gets or sets the ellipsoid offset used to impersonate this mesh when using collision engine (default is (0, 0, 0))
             * @see http://doc.babylonjs.com/babylon101/cameras,_mesh_collisions_and_gravity
             */
            _this.ellipsoidOffset = new BABYLON.Vector3(0, 0, 0);
            _this._oldPositionForCollisions = new BABYLON.Vector3(0, 0, 0);
            _this._diffPositionForCollisions = new BABYLON.Vector3(0, 0, 0);
            // Edges
            /**
             * Defines edge width used when edgesRenderer is enabled
             * @see https://www.babylonjs-playground.com/#10OJSG#13
             */
            _this.edgesWidth = 1;
            /**
             * Defines edge color used when edgesRenderer is enabled
             * @see https://www.babylonjs-playground.com/#10OJSG#13
             */
            _this.edgesColor = new BABYLON.Color4(1, 0, 0, 1);
            // Cache
            _this._collisionsTransformMatrix = BABYLON.Matrix.Zero();
            _this._collisionsScalingMatrix = BABYLON.Matrix.Zero();
            /** @hidden */
            _this._renderId = 0;
            /** @hidden */
            _this._intersectionsInProgress = new Array();
            /** @hidden */
            _this._unIndexed = false;
            /** @hidden */
            _this._lightSources = new Array();
            _this._onCollisionPositionChange = function (collisionId, newPosition, collidedMesh) {
                if (collidedMesh === void 0) { collidedMesh = null; }
                //TODO move this to the collision coordinator!
                if (_this.getScene().workerCollisions)
                    newPosition.multiplyInPlace(_this._collider._radius);
                newPosition.subtractToRef(_this._oldPositionForCollisions, _this._diffPositionForCollisions);
                if (_this._diffPositionForCollisions.length() > BABYLON.Engine.CollisionsEpsilon) {
                    _this.position.addInPlace(_this._diffPositionForCollisions);
                }
                if (collidedMesh) {
                    _this.onCollideObservable.notifyObservers(collidedMesh);
                }
                _this.onCollisionPositionChangeObservable.notifyObservers(_this.position);
            };
            _this.getScene().addMesh(_this);
            _this._resyncLightSources();
            return _this;
        }
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_NONE", {
            /**
             * No billboard
             */
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_X", {
            /** Billboard on X axis */
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_X;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_Y", {
            /** Billboard on Y axis */
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_Y;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_Z", {
            /** Billboard on Z axis */
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_Z;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_ALL", {
            /** Billboard on all axes */
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_ALL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "facetNb", {
            /**
             * Gets the number of facets in the mesh
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#what-is-a-mesh-facet
             */
            get: function () {
                return this._facetNb;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "partitioningSubdivisions", {
            /**
             * Gets or set the number (integer) of subdivisions per axis in the partioning space
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#tweaking-the-partitioning
             */
            get: function () {
                return this._partitioningSubdivisions;
            },
            set: function (nb) {
                this._partitioningSubdivisions = nb;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "partitioningBBoxRatio", {
            /**
             * The ratio (float) to apply to the bouding box size to set to the partioning space.
             * Ex : 1.01 (default) the partioning space is 1% bigger than the bounding box
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#tweaking-the-partitioning
             */
            get: function () {
                return this._partitioningBBoxRatio;
            },
            set: function (ratio) {
                this._partitioningBBoxRatio = ratio;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "mustDepthSortFacets", {
            /**
             * Gets or sets a boolean indicating that the facets must be depth sorted on next call to `updateFacetData()`.
             * Works only for updatable meshes.
             * Doesn't work with multi-materials
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#facet-depth-sort
             */
            get: function () {
                return this._facetDepthSort;
            },
            set: function (sort) {
                this._facetDepthSort = sort;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "facetDepthSortFrom", {
            /**
             * The location (Vector3) where the facet depth sort must be computed from.
             * By default, the active camera position.
             * Used only when facet depth sort is enabled
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#facet-depth-sort
             */
            get: function () {
                return this._facetDepthSortFrom;
            },
            set: function (location) {
                this._facetDepthSortFrom = location;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isFacetDataEnabled", {
            /**
             * gets a boolean indicating if facetData is enabled
             * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata#what-is-a-mesh-facet
             */
            get: function () {
                return this._facetDataEnabled;
            },
            enumerable: true,
            configurable: true
        });
        /** @hidden */
        AbstractMesh.prototype._updateNonUniformScalingState = function (value) {
            if (!_super.prototype._updateNonUniformScalingState.call(this, value)) {
                return false;
            }
            this._markSubMeshesAsMiscDirty();
            return true;
        };
        Object.defineProperty(AbstractMesh.prototype, "onCollide", {
            /** Set a function to call when this mesh collides with another one */
            set: function (callback) {
                if (this._onCollideObserver) {
                    this.onCollideObservable.remove(this._onCollideObserver);
                }
                this._onCollideObserver = this.onCollideObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "onCollisionPositionChange", {
            /** Set a function to call when the collision's position changes */
            set: function (callback) {
                if (this._onCollisionPositionChangeObserver) {
                    this.onCollisionPositionChangeObservable.remove(this._onCollisionPositionChangeObserver);
                }
                this._onCollisionPositionChangeObserver = this.onCollisionPositionChangeObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isOccluded", {
            /**
            * Gets or sets whether the mesh is occluded or not, it is used also to set the intial state of the mesh to be occluded or not
            * @see http://doc.babylonjs.com/features/occlusionquery
            */
            get: function () {
                return this._isOccluded;
            },
            set: function (value) {
                this._isOccluded = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isOcclusionQueryInProgress", {
            /**
             * Flag to check the progress status of the query
             * @see http://doc.babylonjs.com/features/occlusionquery
             */
            get: function () {
                return this._isOcclusionQueryInProgress;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "visibility", {
            /**
             * Gets or sets mesh visibility between 0 and 1 (default is 1)
             */
            get: function () {
                return this._visibility;
            },
            /**
             * Gets or sets mesh visibility between 0 and 1 (default is 1)
             */
            set: function (value) {
                if (this._visibility === value) {
                    return;
                }
                this._visibility = value;
                this._markSubMeshesAsMiscDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "material", {
            /** Gets or sets current material */
            get: function () {
                return this._material;
            },
            set: function (value) {
                if (this._material === value) {
                    return;
                }
                this._material = value;
                if (this.onMaterialChangedObservable.hasObservers) {
                    this.onMaterialChangedObservable.notifyObservers(this);
                }
                if (!this.subMeshes) {
                    return;
                }
                this._unBindEffect();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "receiveShadows", {
            /**
             * Gets or sets a boolean indicating that this mesh can receive realtime shadows
             * @see http://doc.babylonjs.com/babylon101/shadows
             */
            get: function () {
                return this._receiveShadows;
            },
            set: function (value) {
                if (this._receiveShadows === value) {
                    return;
                }
                this._receiveShadows = value;
                this._markSubMeshesAsLightDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "hasVertexAlpha", {
            /** Gets or sets a boolean indicating that this mesh contains vertex color data with alpha values */
            get: function () {
                return this._hasVertexAlpha;
            },
            set: function (value) {
                if (this._hasVertexAlpha === value) {
                    return;
                }
                this._hasVertexAlpha = value;
                this._markSubMeshesAsAttributesDirty();
                this._markSubMeshesAsMiscDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "useVertexColors", {
            /** Gets or sets a boolean indicating that this mesh needs to use vertex color data to render (if this kind of vertex data is available in the geometry) */
            get: function () {
                return this._useVertexColors;
            },
            set: function (value) {
                if (this._useVertexColors === value) {
                    return;
                }
                this._useVertexColors = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "computeBonesUsingShaders", {
            /**
             * Gets or sets a boolean indicating that bone animations must be computed by the CPU (false by default)
             */
            get: function () {
                return this._computeBonesUsingShaders;
            },
            set: function (value) {
                if (this._computeBonesUsingShaders === value) {
                    return;
                }
                this._computeBonesUsingShaders = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "numBoneInfluencers", {
            /** Gets or sets the number of allowed bone influences per vertex (4 by default) */
            get: function () {
                return this._numBoneInfluencers;
            },
            set: function (value) {
                if (this._numBoneInfluencers === value) {
                    return;
                }
                this._numBoneInfluencers = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "applyFog", {
            /** Gets or sets a boolean indicating that this mesh will allow fog to be rendered on it (true by default) */
            get: function () {
                return this._applyFog;
            },
            set: function (value) {
                if (this._applyFog === value) {
                    return;
                }
                this._applyFog = value;
                this._markSubMeshesAsMiscDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "layerMask", {
            /**
             * Gets or sets the current layer mask (default is 0x0FFFFFFF)
             * @see http://doc.babylonjs.com/how_to/layermasks_and_multi-cam_textures
             */
            get: function () {
                return this._layerMask;
            },
            set: function (value) {
                if (value === this._layerMask) {
                    return;
                }
                this._layerMask = value;
                this._resyncLightSources();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collisionMask", {
            /**
             * Gets or sets a collision mask used to mask collisions (default is -1).
             * A collision between A and B will happen if A.collisionGroup & b.collisionMask !== 0
             */
            get: function () {
                return this._collisionMask;
            },
            set: function (mask) {
                this._collisionMask = !isNaN(mask) ? mask : -1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collisionGroup", {
            /**
             * Gets or sets the current collision group mask (-1 by default).
             * A collision between A and B will happen if A.collisionGroup & b.collisionMask !== 0
             */
            get: function () {
                return this._collisionGroup;
            },
            set: function (mask) {
                this._collisionGroup = !isNaN(mask) ? mask : -1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "_positions", {
            /** @hidden */
            get: function () {
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "skeleton", {
            get: function () {
                return this._skeleton;
            },
            /**
             * Gets or sets a skeleton to apply skining transformations
             * @see http://doc.babylonjs.com/how_to/how_to_use_bones_and_skeletons
             */
            set: function (value) {
                if (this._skeleton && this._skeleton.needInitialSkinMatrix) {
                    this._skeleton._unregisterMeshWithPoseMatrix(this);
                }
                if (value && value.needInitialSkinMatrix) {
                    value._registerMeshWithPoseMatrix(this);
                }
                this._skeleton = value;
                if (!this._skeleton) {
                    this._bonesTransformMatrices = null;
                }
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the string "AbstractMesh"
         * @returns "AbstractMesh"
         */
        AbstractMesh.prototype.getClassName = function () {
            return "AbstractMesh";
        };
        /**
         * Gets a string representation of the current mesh
         * @param fullDetails defines a boolean indicating if full details must be included
         * @returns a string representation of the current mesh
         */
        AbstractMesh.prototype.toString = function (fullDetails) {
            var ret = "Name: " + this.name + ", isInstance: " + (this instanceof BABYLON.InstancedMesh ? "YES" : "NO");
            ret += ", # of submeshes: " + (this.subMeshes ? this.subMeshes.length : 0);
            if (this._skeleton) {
                ret += ", skeleton: " + this._skeleton.name;
            }
            if (fullDetails) {
                ret += ", billboard mode: " + (["NONE", "X", "Y", null, "Z", null, null, "ALL"])[this.billboardMode];
                ret += ", freeze wrld mat: " + (this._isWorldMatrixFrozen || this._waitingFreezeWorldMatrix ? "YES" : "NO");
            }
            return ret;
        };
        /** @hidden */
        AbstractMesh.prototype._rebuild = function () {
            if (this._occlusionQuery) {
                this._occlusionQuery = null;
            }
            if (this._edgesRenderer) {
                this._edgesRenderer._rebuild();
            }
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                subMesh._rebuild();
            }
        };
        /** @hidden */
        AbstractMesh.prototype._resyncLightSources = function () {
            this._lightSources.length = 0;
            for (var _i = 0, _a = this.getScene().lights; _i < _a.length; _i++) {
                var light = _a[_i];
                if (!light.isEnabled()) {
                    continue;
                }
                if (light.canAffectMesh(this)) {
                    this._lightSources.push(light);
                }
            }
            this._markSubMeshesAsLightDirty();
        };
        /** @hidden */
        AbstractMesh.prototype._resyncLighSource = function (light) {
            var isIn = light.isEnabled() && light.canAffectMesh(this);
            var index = this._lightSources.indexOf(light);
            if (index === -1) {
                if (!isIn) {
                    return;
                }
                this._lightSources.push(light);
            }
            else {
                if (isIn) {
                    return;
                }
                this._lightSources.splice(index, 1);
            }
            this._markSubMeshesAsLightDirty();
        };
        /** @hidden */
        AbstractMesh.prototype._unBindEffect = function () {
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                subMesh.setEffect(null);
            }
        };
        /** @hidden */
        AbstractMesh.prototype._removeLightSource = function (light) {
            var index = this._lightSources.indexOf(light);
            if (index === -1) {
                return;
            }
            this._lightSources.splice(index, 1);
            this._markSubMeshesAsLightDirty();
        };
        AbstractMesh.prototype._markSubMeshesAsDirty = function (func) {
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                if (subMesh._materialDefines) {
                    func(subMesh._materialDefines);
                }
            }
        };
        /** @hidden */
        AbstractMesh.prototype._markSubMeshesAsLightDirty = function () {
            this._markSubMeshesAsDirty(function (defines) { return defines.markAsLightDirty(); });
        };
        /** @hidden */
        AbstractMesh.prototype._markSubMeshesAsAttributesDirty = function () {
            this._markSubMeshesAsDirty(function (defines) { return defines.markAsAttributesDirty(); });
        };
        /** @hidden */
        AbstractMesh.prototype._markSubMeshesAsMiscDirty = function () {
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                var material = subMesh.getMaterial();
                if (material) {
                    material.markAsDirty(BABYLON.Material.MiscDirtyFlag);
                }
            }
        };
        Object.defineProperty(AbstractMesh.prototype, "scaling", {
            /**
            * Gets or sets a Vector3 depicting the mesh scaling along each local axis X, Y, Z.  Default is (1.0, 1.0, 1.0)
            */
            get: function () {
                return this._scaling;
            },
            set: function (newScaling) {
                this._scaling = newScaling;
                if (this.physicsImpostor) {
                    this.physicsImpostor.forceUpdate();
                }
            },
            enumerable: true,
            configurable: true
        });
        // Methods
        /**
         * Disables the mesh edge rendering mode
         * @returns the currentAbstractMesh
         */
        AbstractMesh.prototype.disableEdgesRendering = function () {
            if (this._edgesRenderer) {
                this._edgesRenderer.dispose();
                this._edgesRenderer = null;
            }
            return this;
        };
        /**
         * Enables the edge rendering mode on the mesh.
         * This mode makes the mesh edges visible
         * @param epsilon defines the maximal distance between two angles to detect a face
         * @param checkVerticesInsteadOfIndices indicates that we should check vertex list directly instead of faces
         * @returns the currentAbstractMesh
         * @see https://www.babylonjs-playground.com/#19O9TU#0
         */
        AbstractMesh.prototype.enableEdgesRendering = function (epsilon, checkVerticesInsteadOfIndices) {
            if (epsilon === void 0) { epsilon = 0.95; }
            if (checkVerticesInsteadOfIndices === void 0) { checkVerticesInsteadOfIndices = false; }
            this.disableEdgesRendering();
            this._edgesRenderer = new BABYLON.EdgesRenderer(this, epsilon, checkVerticesInsteadOfIndices);
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "isBlocked", {
            /**
             * Returns true if the mesh is blocked. Implemented by child classes
             */
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the mesh itself by default. Implemented by child classes
         * @param camera defines the camera to use to pick the right LOD level
         * @returns the currentAbstractMesh
         */
        AbstractMesh.prototype.getLOD = function (camera) {
            return this;
        };
        /**
         * Returns 0 by default. Implemented by child classes
         * @returns an integer
         */
        AbstractMesh.prototype.getTotalVertices = function () {
            return 0;
        };
        /**
         * Returns null by default. Implemented by child classes
         * @returns null
         */
        AbstractMesh.prototype.getIndices = function () {
            return null;
        };
        /**
         * Returns the array of the requested vertex data kind. Implemented by child classes
         * @param kind defines the vertex data kind to use
         * @returns null
         */
        AbstractMesh.prototype.getVerticesData = function (kind) {
            return null;
        };
        /**
         * Sets the vertex data of the mesh geometry for the requested `kind`.
         * If the mesh has no geometry, a new Geometry object is set to the mesh and then passed this vertex data.
         * Note that a new underlying VertexBuffer object is created each call.
         * If the `kind` is the `PositionKind`, the mesh BoundingInfo is renewed, so the bounding box and sphere, and the mesh World Matrix is recomputed.
         * @param kind defines vertex data kind:
         * * BABYLON.VertexBuffer.PositionKind
         * * BABYLON.VertexBuffer.UVKind
         * * BABYLON.VertexBuffer.UV2Kind
         * * BABYLON.VertexBuffer.UV3Kind
         * * BABYLON.VertexBuffer.UV4Kind
         * * BABYLON.VertexBuffer.UV5Kind
         * * BABYLON.VertexBuffer.UV6Kind
         * * BABYLON.VertexBuffer.ColorKind
         * * BABYLON.VertexBuffer.MatricesIndicesKind
         * * BABYLON.VertexBuffer.MatricesIndicesExtraKind
         * * BABYLON.VertexBuffer.MatricesWeightsKind
         * * BABYLON.VertexBuffer.MatricesWeightsExtraKind
         * @param data defines the data source
         * @param updatable defines if the data must be flagged as updatable (or static)
         * @param stride defines the vertex stride (size of an entire vertex). Can be null and in this case will be deduced from vertex data kind
         * @returns the current mesh
         */
        AbstractMesh.prototype.setVerticesData = function (kind, data, updatable, stride) {
            return this;
        };
        /**
         * Updates the existing vertex data of the mesh geometry for the requested `kind`.
         * If the mesh has no geometry, it is simply returned as it is.
         * @param kind defines vertex data kind:
         * * BABYLON.VertexBuffer.PositionKind
         * * BABYLON.VertexBuffer.UVKind
         * * BABYLON.VertexBuffer.UV2Kind
         * * BABYLON.VertexBuffer.UV3Kind
         * * BABYLON.VertexBuffer.UV4Kind
         * * BABYLON.VertexBuffer.UV5Kind
         * * BABYLON.VertexBuffer.UV6Kind
         * * BABYLON.VertexBuffer.ColorKind
         * * BABYLON.VertexBuffer.MatricesIndicesKind
         * * BABYLON.VertexBuffer.MatricesIndicesExtraKind
         * * BABYLON.VertexBuffer.MatricesWeightsKind
         * * BABYLON.VertexBuffer.MatricesWeightsExtraKind
         * @param data defines the data source
         * @param updateExtends If `kind` is `PositionKind` and if `updateExtends` is true, the mesh BoundingInfo is renewed, so the bounding box and sphere, and the mesh World Matrix is recomputed
         * @param makeItUnique If true, a new global geometry is created from this data and is set to the mesh
         * @returns the current mesh
         */
        AbstractMesh.prototype.updateVerticesData = function (kind, data, updateExtends, makeItUnique) {
            return this;
        };
        /**
         * Sets the mesh indices,
         * If the mesh has no geometry, a new Geometry object is created and set to the mesh.
         * @param indices Expects an array populated with integers or a typed array (Int32Array, Uint32Array, Uint16Array)
         * @param totalVertices Defines the total number of vertices
         * @returns the current mesh
         */
        AbstractMesh.prototype.setIndices = function (indices, totalVertices) {
            return this;
        };
        /**
         * Gets a boolean indicating if specific vertex data is present
         * @param kind defines the vertex data kind to use
         * @returns true is data kind is present
         */
        AbstractMesh.prototype.isVerticesDataPresent = function (kind) {
            return false;
        };
        /**
         * Returns the mesh BoundingInfo object or creates a new one and returns if it was undefined
         * @returns a BoundingInfo
         */
        AbstractMesh.prototype.getBoundingInfo = function () {
            if (this._masterMesh) {
                return this._masterMesh.getBoundingInfo();
            }
            if (!this._boundingInfo) {
                // this._boundingInfo is being created here
                this._updateBoundingInfo();
            }
            // cannot be null.
            return this._boundingInfo;
        };
        /**
         * Uniformly scales the mesh to fit inside of a unit cube (1 X 1 X 1 units)
         * @param includeDescendants Use the hierarchy's bounding box instead of the mesh's bounding box
         * @returns the current mesh
         */
        AbstractMesh.prototype.normalizeToUnitCube = function (includeDescendants) {
            if (includeDescendants === void 0) { includeDescendants = true; }
            var boundingVectors = this.getHierarchyBoundingVectors(includeDescendants);
            var sizeVec = boundingVectors.max.subtract(boundingVectors.min);
            var maxDimension = Math.max(sizeVec.x, sizeVec.y, sizeVec.z);
            if (maxDimension === 0) {
                return this;
            }
            var scale = 1 / maxDimension;
            this.scaling.scaleInPlace(scale);
            return this;
        };
        /**
         * Overwrite the current bounding info
         * @param boundingInfo defines the new bounding info
         * @returns the current mesh
         */
        AbstractMesh.prototype.setBoundingInfo = function (boundingInfo) {
            this._boundingInfo = boundingInfo;
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "useBones", {
            /** Gets a boolean indicating if this mesh has skinning data and an attached skeleton */
            get: function () {
                return (this.skeleton && this.getScene().skeletonsEnabled && this.isVerticesDataPresent(BABYLON.VertexBuffer.MatricesIndicesKind) && this.isVerticesDataPresent(BABYLON.VertexBuffer.MatricesWeightsKind));
            },
            enumerable: true,
            configurable: true
        });
        /** @hidden */
        AbstractMesh.prototype._preActivate = function () {
        };
        /** @hidden */
        AbstractMesh.prototype._preActivateForIntermediateRendering = function (renderId) {
        };
        /** @hidden */
        AbstractMesh.prototype._activate = function (renderId) {
            this._renderId = renderId;
        };
        /**
         * Gets the current world matrix
         * @returns a Matrix
         */
        AbstractMesh.prototype.getWorldMatrix = function () {
            if (this._masterMesh) {
                return this._masterMesh.getWorldMatrix();
            }
            return _super.prototype.getWorldMatrix.call(this);
        };
        /** @hidden */
        AbstractMesh.prototype._getWorldMatrixDeterminant = function () {
            if (this._masterMesh) {
                return this._masterMesh._getWorldMatrixDeterminant();
            }
            return _super.prototype._getWorldMatrixDeterminant.call(this);
        };
        // ================================== Point of View Movement =================================
        /**
         * Perform relative position change from the point of view of behind the front of the mesh.
         * This is performed taking into account the meshes current rotation, so you do not have to care.
         * Supports definition of mesh facing forward or backward
         * @param amountRight defines the distance on the right axis
         * @param amountUp defines the distance on the up axis
         * @param amountForward defines the distance on the forward axis
         * @returns the current mesh
         */
        AbstractMesh.prototype.movePOV = function (amountRight, amountUp, amountForward) {
            this.position.addInPlace(this.calcMovePOV(amountRight, amountUp, amountForward));
            return this;
        };
        /**
         * Calculate relative position change from the point of view of behind the front of the mesh.
         * This is performed taking into account the meshes current rotation, so you do not have to care.
         * Supports definition of mesh facing forward or backward
         * @param amountRight defines the distance on the right axis
         * @param amountUp defines the distance on the up axis
         * @param amountForward defines the distance on the forward axis
         * @returns the new displacement vector
         */
        AbstractMesh.prototype.calcMovePOV = function (amountRight, amountUp, amountForward) {
            var rotMatrix = new BABYLON.Matrix();
            var rotQuaternion = (this.rotationQuaternion) ? this.rotationQuaternion : BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
            rotQuaternion.toRotationMatrix(rotMatrix);
            var translationDelta = BABYLON.Vector3.Zero();
            var defForwardMult = this.definedFacingForward ? -1 : 1;
            BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(amountRight * defForwardMult, amountUp, amountForward * defForwardMult, rotMatrix, translationDelta);
            return translationDelta;
        };
        // ================================== Point of View Rotation =================================
        /**
         * Perform relative rotation change from the point of view of behind the front of the mesh.
         * Supports definition of mesh facing forward or backward
         * @param flipBack defines the flip
         * @param twirlClockwise defines the twirl
         * @param tiltRight defines the tilt
         * @returns the current mesh
         */
        AbstractMesh.prototype.rotatePOV = function (flipBack, twirlClockwise, tiltRight) {
            this.rotation.addInPlace(this.calcRotatePOV(flipBack, twirlClockwise, tiltRight));
            return this;
        };
        /**
         * Calculate relative rotation change from the point of view of behind the front of the mesh.
         * Supports definition of mesh facing forward or backward.
         * @param flipBack defines the flip
         * @param twirlClockwise defines the twirl
         * @param tiltRight defines the tilt
         * @returns the new rotation vector
         */
        AbstractMesh.prototype.calcRotatePOV = function (flipBack, twirlClockwise, tiltRight) {
            var defForwardMult = this.definedFacingForward ? 1 : -1;
            return new BABYLON.Vector3(flipBack * defForwardMult, twirlClockwise, tiltRight * defForwardMult);
        };
        /**
         * Return the minimum and maximum world vectors of the entire hierarchy under current mesh
         * @param includeDescendants Include bounding info from descendants as well (true by default)
         * @returns the new bounding vectors
         */
        AbstractMesh.prototype.getHierarchyBoundingVectors = function (includeDescendants) {
            if (includeDescendants === void 0) { includeDescendants = true; }
            // Ensures that all world matrix will be recomputed.
            this.getScene().incrementRenderId();
            this.computeWorldMatrix(true);
            var min;
            var max;
            var boundingInfo = this.getBoundingInfo();
            if (!this.subMeshes) {
                min = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
                max = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            }
            else {
                min = boundingInfo.boundingBox.minimumWorld;
                max = boundingInfo.boundingBox.maximumWorld;
            }
            if (includeDescendants) {
                var descendants = this.getDescendants(false);
                for (var _i = 0, descendants_1 = descendants; _i < descendants_1.length; _i++) {
                    var descendant = descendants_1[_i];
                    var childMesh = descendant;
                    childMesh.computeWorldMatrix(true);
                    //make sure we have the needed params to get mix and max
                    if (!childMesh.getBoundingInfo || childMesh.getTotalVertices() === 0) {
                        continue;
                    }
                    var childBoundingInfo = childMesh.getBoundingInfo();
                    var boundingBox = childBoundingInfo.boundingBox;
                    var minBox = boundingBox.minimumWorld;
                    var maxBox = boundingBox.maximumWorld;
                    BABYLON.Tools.CheckExtends(minBox, min, max);
                    BABYLON.Tools.CheckExtends(maxBox, min, max);
                }
            }
            return {
                min: min,
                max: max
            };
        };
        /** @hidden */
        AbstractMesh.prototype._updateBoundingInfo = function () {
            this._boundingInfo = this._boundingInfo || new BABYLON.BoundingInfo(this.absolutePosition, this.absolutePosition);
            this._boundingInfo.update(this.worldMatrixFromCache);
            this._updateSubMeshesBoundingInfo(this.worldMatrixFromCache);
            return this;
        };
        /** @hidden */
        AbstractMesh.prototype._updateSubMeshesBoundingInfo = function (matrix) {
            if (!this.subMeshes) {
                return this;
            }
            for (var subIndex = 0; subIndex < this.subMeshes.length; subIndex++) {
                var subMesh = this.subMeshes[subIndex];
                if (!subMesh.IsGlobal) {
                    subMesh.updateBoundingInfo(matrix);
                }
            }
            return this;
        };
        /** @hidden */
        AbstractMesh.prototype._afterComputeWorldMatrix = function () {
            // Bounding info
            this._updateBoundingInfo();
        };
        /**
         * Returns `true` if the mesh is within the frustum defined by the passed array of planes.
         * A mesh is in the frustum if its bounding box intersects the frustum
         * @param frustumPlanes defines the frustum to test
         * @returns true if the mesh is in the frustum planes
         */
        AbstractMesh.prototype.isInFrustum = function (frustumPlanes) {
            return this._boundingInfo !== null && this._boundingInfo.isInFrustum(frustumPlanes);
        };
        /**
         * Returns `true` if the mesh is completely in the frustum defined be the passed array of planes.
         * A mesh is completely in the frustum if its bounding box it completely inside the frustum.
         * @param frustumPlanes defines the frustum to test
         * @returns true if the mesh is completely in the frustum planes
         */
        AbstractMesh.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return this._boundingInfo !== null && this._boundingInfo.isCompletelyInFrustum(frustumPlanes);
        };
        /**
         * True if the mesh intersects another mesh or a SolidParticle object
         * @param mesh defines a target mesh or SolidParticle to test
         * @param precise Unless the parameter `precise` is set to `true` the intersection is computed according to Axis Aligned Bounding Boxes (AABB), else according to OBB (Oriented BBoxes)
         * @param includeDescendants Can be set to true to test if the mesh defined in parameters intersects with the current mesh or any child meshes
         * @returns true if there is an intersection
         */
        AbstractMesh.prototype.intersectsMesh = function (mesh, precise, includeDescendants) {
            if (precise === void 0) { precise = false; }
            if (!this._boundingInfo || !mesh._boundingInfo) {
                return false;
            }
            if (this._boundingInfo.intersects(mesh._boundingInfo, precise)) {
                return true;
            }
            if (includeDescendants) {
                for (var _i = 0, _a = this.getChildMeshes(); _i < _a.length; _i++) {
                    var child = _a[_i];
                    if (child.intersectsMesh(mesh, precise, true)) {
                        return true;
                    }
                }
            }
            return false;
        };
        /**
         * Returns true if the passed point (Vector3) is inside the mesh bounding box
         * @param point defines the point to test
         * @returns true if there is an intersection
         */
        AbstractMesh.prototype.intersectsPoint = function (point) {
            if (!this._boundingInfo) {
                return false;
            }
            return this._boundingInfo.intersectsPoint(point);
        };
        /**
         * Gets the current physics impostor
         * @see http://doc.babylonjs.com/features/physics_engine
         * @returns a physics impostor or null
         */
        AbstractMesh.prototype.getPhysicsImpostor = function () {
            return this.physicsImpostor;
        };
        /**
         * Gets the position of the current mesh in camera space
         * @param camera defines the camera to use
         * @returns a position
         */
        AbstractMesh.prototype.getPositionInCameraSpace = function (camera) {
            if (camera === void 0) { camera = null; }
            if (!camera) {
                camera = this.getScene().activeCamera;
            }
            return BABYLON.Vector3.TransformCoordinates(this.absolutePosition, camera.getViewMatrix());
        };
        /**
         * Returns the distance from the mesh to the active camera
         * @param camera defines the camera to use
         * @returns the distance
         */
        AbstractMesh.prototype.getDistanceToCamera = function (camera) {
            if (camera === void 0) { camera = null; }
            if (!camera) {
                camera = this.getScene().activeCamera;
            }
            return this.absolutePosition.subtract(camera.position).length();
        };
        /**
         * Apply a physic impulse to the mesh
         * @param force defines the force to apply
         * @param contactPoint defines where to apply the force
         * @returns the current mesh
         * @see http://doc.babylonjs.com/how_to/using_the_physics_engine
         */
        AbstractMesh.prototype.applyImpulse = function (force, contactPoint) {
            if (!this.physicsImpostor) {
                return this;
            }
            this.physicsImpostor.applyImpulse(force, contactPoint);
            return this;
        };
        /**
         * Creates a physic joint between two meshes
         * @param otherMesh defines the other mesh to use
         * @param pivot1 defines the pivot to use on this mesh
         * @param pivot2 defines the pivot to use on the other mesh
         * @param options defines additional options (can be plugin dependent)
         * @returns the current mesh
         * @see https://www.babylonjs-playground.com/#0BS5U0#0
         */
        AbstractMesh.prototype.setPhysicsLinkWith = function (otherMesh, pivot1, pivot2, options) {
            if (!this.physicsImpostor || !otherMesh.physicsImpostor) {
                return this;
            }
            this.physicsImpostor.createJoint(otherMesh.physicsImpostor, BABYLON.PhysicsJoint.HingeJoint, {
                mainPivot: pivot1,
                connectedPivot: pivot2,
                nativeParams: options
            });
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "checkCollisions", {
            // Collisions
            /**
             * Gets or sets a boolean indicating that this mesh can be used in the collision engine
             * @see http://doc.babylonjs.com/babylon101/cameras,_mesh_collisions_and_gravity
             */
            get: function () {
                return this._checkCollisions;
            },
            set: function (collisionEnabled) {
                this._checkCollisions = collisionEnabled;
                if (this.getScene().workerCollisions) {
                    this.getScene().collisionCoordinator.onMeshUpdated(this);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collider", {
            /**
             * Gets Collider object used to compute collisions (not physics)
             * @see http://doc.babylonjs.com/babylon101/cameras,_mesh_collisions_and_gravity
             */
            get: function () {
                return this._collider;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Move the mesh using collision engine
         * @see http://doc.babylonjs.com/babylon101/cameras,_mesh_collisions_and_gravity
         * @param displacement defines the requested displacement vector
         * @returns the current mesh
         */
        AbstractMesh.prototype.moveWithCollisions = function (displacement) {
            var globalPosition = this.getAbsolutePosition();
            globalPosition.addToRef(this.ellipsoidOffset, this._oldPositionForCollisions);
            if (!this._collider) {
                this._collider = new BABYLON.Collider();
            }
            this._collider._radius = this.ellipsoid;
            this.getScene().collisionCoordinator.getNewPosition(this._oldPositionForCollisions, displacement, this._collider, 3, this, this._onCollisionPositionChange, this.uniqueId);
            return this;
        };
        // Submeshes octree
        /**
        * This function will create an octree to help to select the right submeshes for rendering, picking and collision computations.
        * Please note that you must have a decent number of submeshes to get performance improvements when using an octree
        * @param maxCapacity defines the maximum size of each block (64 by default)
        * @param maxDepth defines the maximum depth to use (no more than 2 levels by default)
        * @returns the new octree
        * @see https://www.babylonjs-playground.com/#NA4OQ#12
        * @see http://doc.babylonjs.com/how_to/optimizing_your_scene_with_octrees
        */
        AbstractMesh.prototype.createOrUpdateSubmeshesOctree = function (maxCapacity, maxDepth) {
            if (maxCapacity === void 0) { maxCapacity = 64; }
            if (maxDepth === void 0) { maxDepth = 2; }
            if (!this._submeshesOctree) {
                this._submeshesOctree = new BABYLON.Octree(BABYLON.Octree.CreationFuncForSubMeshes, maxCapacity, maxDepth);
            }
            this.computeWorldMatrix(true);
            var boundingInfo = this.getBoundingInfo();
            // Update octree
            var bbox = boundingInfo.boundingBox;
            this._submeshesOctree.update(bbox.minimumWorld, bbox.maximumWorld, this.subMeshes);
            return this._submeshesOctree;
        };
        // Collisions
        /** @hidden */
        AbstractMesh.prototype._collideForSubMesh = function (subMesh, transformMatrix, collider) {
            this._generatePointsArray();
            if (!this._positions) {
                return this;
            }
            // Transformation
            if (!subMesh._lastColliderWorldVertices || !subMesh._lastColliderTransformMatrix.equals(transformMatrix)) {
                subMesh._lastColliderTransformMatrix = transformMatrix.clone();
                subMesh._lastColliderWorldVertices = [];
                subMesh._trianglePlanes = [];
                var start = subMesh.verticesStart;
                var end = (subMesh.verticesStart + subMesh.verticesCount);
                for (var i = start; i < end; i++) {
                    subMesh._lastColliderWorldVertices.push(BABYLON.Vector3.TransformCoordinates(this._positions[i], transformMatrix));
                }
            }
            // Collide
            collider._collide(subMesh._trianglePlanes, subMesh._lastColliderWorldVertices, this.getIndices(), subMesh.indexStart, subMesh.indexStart + subMesh.indexCount, subMesh.verticesStart, !!subMesh.getMaterial());
            if (collider.collisionFound) {
                collider.collidedMesh = this;
            }
            return this;
        };
        /** @hidden */
        AbstractMesh.prototype._processCollisionsForSubMeshes = function (collider, transformMatrix) {
            var subMeshes;
            var len;
            // Octrees
            if (this._submeshesOctree && this.useOctreeForCollisions) {
                var radius = collider._velocityWorldLength + Math.max(collider._radius.x, collider._radius.y, collider._radius.z);
                var intersections = this._submeshesOctree.intersects(collider._basePointWorld, radius);
                len = intersections.length;
                subMeshes = intersections.data;
            }
            else {
                subMeshes = this.subMeshes;
                len = subMeshes.length;
            }
            for (var index = 0; index < len; index++) {
                var subMesh = subMeshes[index];
                // Bounding test
                if (len > 1 && !subMesh._checkCollision(collider))
                    continue;
                this._collideForSubMesh(subMesh, transformMatrix, collider);
            }
            return this;
        };
        /** @hidden */
        AbstractMesh.prototype._checkCollision = function (collider) {
            // Bounding box test
            if (!this._boundingInfo || !this._boundingInfo._checkCollision(collider))
                return this;
            // Transformation matrix
            BABYLON.Matrix.ScalingToRef(1.0 / collider._radius.x, 1.0 / collider._radius.y, 1.0 / collider._radius.z, this._collisionsScalingMatrix);
            this.worldMatrixFromCache.multiplyToRef(this._collisionsScalingMatrix, this._collisionsTransformMatrix);
            this._processCollisionsForSubMeshes(collider, this._collisionsTransformMatrix);
            return this;
        };
        // Picking
        /** @hidden */
        AbstractMesh.prototype._generatePointsArray = function () {
            return false;
        };
        /**
         * Checks if the passed Ray intersects with the mesh
         * @param ray defines the ray to use
         * @param fastCheck defines if fast mode (but less precise) must be used (false by default)
         * @returns the picking info
         * @see http://doc.babylonjs.com/babylon101/intersect_collisions_-_mesh
         */
        AbstractMesh.prototype.intersects = function (ray, fastCheck) {
            var pickingInfo = new BABYLON.PickingInfo();
            if (!this.subMeshes || !this._boundingInfo || !ray.intersectsSphere(this._boundingInfo.boundingSphere) || !ray.intersectsBox(this._boundingInfo.boundingBox)) {
                return pickingInfo;
            }
            if (!this._generatePointsArray()) {
                return pickingInfo;
            }
            var intersectInfo = null;
            // Octrees
            var subMeshes;
            var len;
            if (this._submeshesOctree && this.useOctreeForPicking) {
                var worldRay = BABYLON.Ray.Transform(ray, this.getWorldMatrix());
                var intersections = this._submeshesOctree.intersectsRay(worldRay);
                len = intersections.length;
                subMeshes = intersections.data;
            }
            else {
                subMeshes = this.subMeshes;
                len = subMeshes.length;
            }
            for (var index = 0; index < len; index++) {
                var subMesh = subMeshes[index];
                // Bounding test
                if (len > 1 && !subMesh.canIntersects(ray))
                    continue;
                var currentIntersectInfo = subMesh.intersects(ray, this._positions, this.getIndices(), fastCheck);
                if (currentIntersectInfo) {
                    if (fastCheck || !intersectInfo || currentIntersectInfo.distance < intersectInfo.distance) {
                        intersectInfo = currentIntersectInfo;
                        intersectInfo.subMeshId = index;
                        if (fastCheck) {
                            break;
                        }
                    }
                }
            }
            if (intersectInfo) {
                // Get picked point
                var world = this.getWorldMatrix();
                var worldOrigin = BABYLON.Vector3.TransformCoordinates(ray.origin, world);
                var direction = ray.direction.clone();
                direction = direction.scale(intersectInfo.distance);
                var worldDirection = BABYLON.Vector3.TransformNormal(direction, world);
                var pickedPoint = worldOrigin.add(worldDirection);
                // Return result
                pickingInfo.hit = true;
                pickingInfo.distance = BABYLON.Vector3.Distance(worldOrigin, pickedPoint);
                pickingInfo.pickedPoint = pickedPoint;
                pickingInfo.pickedMesh = this;
                pickingInfo.bu = intersectInfo.bu || 0;
                pickingInfo.bv = intersectInfo.bv || 0;
                pickingInfo.faceId = intersectInfo.faceId;
                pickingInfo.subMeshId = intersectInfo.subMeshId;
                return pickingInfo;
            }
            return pickingInfo;
        };
        /**
         * Clones the current mesh
         * @param name defines the mesh name
         * @param newParent defines the new mesh parent
         * @param doNotCloneChildren defines a boolean indicating that children must not be cloned (false by default)
         * @returns the new mesh
         */
        AbstractMesh.prototype.clone = function (name, newParent, doNotCloneChildren) {
            return null;
        };
        /**
         * Disposes all the submeshes of the current meshnp
         * @returns the current mesh
         */
        AbstractMesh.prototype.releaseSubMeshes = function () {
            if (this.subMeshes) {
                while (this.subMeshes.length) {
                    this.subMeshes[0].dispose();
                }
            }
            else {
                this.subMeshes = new Array();
            }
            return this;
        };
        /**
         * Releases resources associated with this abstract mesh.
         * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
         * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
         */
        AbstractMesh.prototype.dispose = function (doNotRecurse, disposeMaterialAndTextures) {
            var _this = this;
            if (disposeMaterialAndTextures === void 0) { disposeMaterialAndTextures = false; }
            var index;
            // Smart Array Retainers.
            this.getScene().freeActiveMeshes();
            this.getScene().freeRenderingGroups();
            // Action manager
            if (this.actionManager !== undefined && this.actionManager !== null) {
                this.actionManager.dispose();
                this.actionManager = null;
            }
            // Skeleton
            this._skeleton = null;
            // Physics
            if (this.physicsImpostor) {
                this.physicsImpostor.dispose( /*!doNotRecurse*/);
            }
            // Intersections in progress
            for (index = 0; index < this._intersectionsInProgress.length; index++) {
                var other = this._intersectionsInProgress[index];
                var pos = other._intersectionsInProgress.indexOf(this);
                other._intersectionsInProgress.splice(pos, 1);
            }
            this._intersectionsInProgress = [];
            // Lights
            var lights = this.getScene().lights;
            lights.forEach(function (light) {
                var meshIndex = light.includedOnlyMeshes.indexOf(_this);
                if (meshIndex !== -1) {
                    light.includedOnlyMeshes.splice(meshIndex, 1);
                }
                meshIndex = light.excludedMeshes.indexOf(_this);
                if (meshIndex !== -1) {
                    light.excludedMeshes.splice(meshIndex, 1);
                }
                // Shadow generators
                var generator = light.getShadowGenerator();
                if (generator) {
                    var shadowMap = generator.getShadowMap();
                    if (shadowMap && shadowMap.renderList) {
                        meshIndex = shadowMap.renderList.indexOf(_this);
                        if (meshIndex !== -1) {
                            shadowMap.renderList.splice(meshIndex, 1);
                        }
                    }
                }
            });
            // Edges
            if (this._edgesRenderer) {
                this._edgesRenderer.dispose();
                this._edgesRenderer = null;
            }
            // SubMeshes
            if (this.getClassName() !== "InstancedMesh") {
                this.releaseSubMeshes();
            }
            // Octree
            var sceneOctree = this.getScene().selectionOctree;
            if (sceneOctree !== undefined && sceneOctree !== null) {
                var index = sceneOctree.dynamicContent.indexOf(this);
                if (index !== -1) {
                    sceneOctree.dynamicContent.splice(index, 1);
                }
            }
            // Query
            var engine = this.getScene().getEngine();
            if (this._occlusionQuery) {
                this._isOcclusionQueryInProgress = false;
                engine.deleteQuery(this._occlusionQuery);
                this._occlusionQuery = null;
            }
            // Engine
            engine.wipeCaches();
            // Remove from scene
            this.getScene().removeMesh(this);
            if (disposeMaterialAndTextures) {
                if (this.material) {
                    this.material.dispose(false, true);
                }
            }
            if (!doNotRecurse) {
                // Particles
                for (index = 0; index < this.getScene().particleSystems.length; index++) {
                    if (this.getScene().particleSystems[index].emitter === this) {
                        this.getScene().particleSystems[index].dispose();
                        index--;
                    }
                }
            }
            // facet data
            if (this._facetDataEnabled) {
                this.disableFacetData();
            }
            this.onAfterWorldMatrixUpdateObservable.clear();
            this.onCollideObservable.clear();
            this.onCollisionPositionChangeObservable.clear();
            _super.prototype.dispose.call(this, doNotRecurse, disposeMaterialAndTextures);
        };
        /**
         * Adds the passed mesh as a child to the current mesh
         * @param mesh defines the child mesh
         * @returns the current mesh
         */
        AbstractMesh.prototype.addChild = function (mesh) {
            mesh.setParent(this);
            return this;
        };
        /**
         * Removes the passed mesh from the current mesh children list
         * @param mesh defines the child mesh
         * @returns the current mesh
         */
        AbstractMesh.prototype.removeChild = function (mesh) {
            mesh.setParent(null);
            return this;
        };
        // Facet data
        /** @hidden */
        AbstractMesh.prototype._initFacetData = function () {
            if (!this._facetNormals) {
                this._facetNormals = new Array();
            }
            if (!this._facetPositions) {
                this._facetPositions = new Array();
            }
            if (!this._facetPartitioning) {
                this._facetPartitioning = new Array();
            }
            this._facetNb = (this.getIndices().length / 3) | 0;
            this._partitioningSubdivisions = (this._partitioningSubdivisions) ? this._partitioningSubdivisions : 10; // default nb of partitioning subdivisions = 10
            this._partitioningBBoxRatio = (this._partitioningBBoxRatio) ? this._partitioningBBoxRatio : 1.01; // default ratio 1.01 = the partitioning is 1% bigger than the bounding box
            for (var f = 0; f < this._facetNb; f++) {
                this._facetNormals[f] = BABYLON.Vector3.Zero();
                this._facetPositions[f] = BABYLON.Vector3.Zero();
            }
            this._facetDataEnabled = true;
            return this;
        };
        /**
         * Updates the mesh facetData arrays and the internal partitioning when the mesh is morphed or updated.
         * This method can be called within the render loop.
         * You don't need to call this method by yourself in the render loop when you update/morph a mesh with the methods CreateXXX() as they automatically manage this computation
         * @returns the current mesh
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.updateFacetData = function () {
            if (!this._facetDataEnabled) {
                this._initFacetData();
            }
            var positions = this.getVerticesData(BABYLON.VertexBuffer.PositionKind);
            var indices = this.getIndices();
            var normals = this.getVerticesData(BABYLON.VertexBuffer.NormalKind);
            var bInfo = this.getBoundingInfo();
            if (this._facetDepthSort && !this._facetDepthSortEnabled) {
                // init arrays, matrix and sort function on first call
                this._facetDepthSortEnabled = true;
                if (indices instanceof Uint16Array) {
                    this._depthSortedIndices = new Uint16Array(indices);
                }
                else if (indices instanceof Uint32Array) {
                    this._depthSortedIndices = new Uint32Array(indices);
                }
                else {
                    var needs32bits = false;
                    for (var i = 0; i < indices.length; i++) {
                        if (indices[i] > 65535) {
                            needs32bits = true;
                            break;
                        }
                    }
                    if (needs32bits) {
                        this._depthSortedIndices = new Uint32Array(indices);
                    }
                    else {
                        this._depthSortedIndices = new Uint16Array(indices);
                    }
                }
                this._facetDepthSortFunction = function (f1, f2) {
                    return (f2.sqDistance - f1.sqDistance);
                };
                if (!this._facetDepthSortFrom) {
                    var camera = this.getScene().activeCamera;
                    this._facetDepthSortFrom = (camera) ? camera.position : BABYLON.Vector3.Zero();
                }
                this._depthSortedFacets = [];
                for (var f = 0; f < this._facetNb; f++) {
                    var depthSortedFacet = { ind: f * 3, sqDistance: 0.0 };
                    this._depthSortedFacets.push(depthSortedFacet);
                }
                this._invertedMatrix = BABYLON.Matrix.Identity();
                this._facetDepthSortOrigin = BABYLON.Vector3.Zero();
            }
            this._bbSize.x = (bInfo.maximum.x - bInfo.minimum.x > BABYLON.Epsilon) ? bInfo.maximum.x - bInfo.minimum.x : BABYLON.Epsilon;
            this._bbSize.y = (bInfo.maximum.y - bInfo.minimum.y > BABYLON.Epsilon) ? bInfo.maximum.y - bInfo.minimum.y : BABYLON.Epsilon;
            this._bbSize.z = (bInfo.maximum.z - bInfo.minimum.z > BABYLON.Epsilon) ? bInfo.maximum.z - bInfo.minimum.z : BABYLON.Epsilon;
            var bbSizeMax = (this._bbSize.x > this._bbSize.y) ? this._bbSize.x : this._bbSize.y;
            bbSizeMax = (bbSizeMax > this._bbSize.z) ? bbSizeMax : this._bbSize.z;
            this._subDiv.max = this._partitioningSubdivisions;
            this._subDiv.X = Math.floor(this._subDiv.max * this._bbSize.x / bbSizeMax); // adjust the number of subdivisions per axis
            this._subDiv.Y = Math.floor(this._subDiv.max * this._bbSize.y / bbSizeMax); // according to each bbox size per axis
            this._subDiv.Z = Math.floor(this._subDiv.max * this._bbSize.z / bbSizeMax);
            this._subDiv.X = this._subDiv.X < 1 ? 1 : this._subDiv.X; // at least one subdivision
            this._subDiv.Y = this._subDiv.Y < 1 ? 1 : this._subDiv.Y;
            this._subDiv.Z = this._subDiv.Z < 1 ? 1 : this._subDiv.Z;
            // set the parameters for ComputeNormals()
            this._facetParameters.facetNormals = this.getFacetLocalNormals();
            this._facetParameters.facetPositions = this.getFacetLocalPositions();
            this._facetParameters.facetPartitioning = this.getFacetLocalPartitioning();
            this._facetParameters.bInfo = bInfo;
            this._facetParameters.bbSize = this._bbSize;
            this._facetParameters.subDiv = this._subDiv;
            this._facetParameters.ratio = this.partitioningBBoxRatio;
            this._facetParameters.depthSort = this._facetDepthSort;
            if (this._facetDepthSort && this._facetDepthSortEnabled) {
                this.computeWorldMatrix(true);
                this._worldMatrix.invertToRef(this._invertedMatrix);
                BABYLON.Vector3.TransformCoordinatesToRef(this._facetDepthSortFrom, this._invertedMatrix, this._facetDepthSortOrigin);
                this._facetParameters.distanceTo = this._facetDepthSortOrigin;
            }
            this._facetParameters.depthSortedFacets = this._depthSortedFacets;
            BABYLON.VertexData.ComputeNormals(positions, indices, normals, this._facetParameters);
            if (this._facetDepthSort && this._facetDepthSortEnabled) {
                this._depthSortedFacets.sort(this._facetDepthSortFunction);
                var l = (this._depthSortedIndices.length / 3) | 0;
                for (var f = 0; f < l; f++) {
                    var sind = this._depthSortedFacets[f].ind;
                    this._depthSortedIndices[f * 3] = indices[sind];
                    this._depthSortedIndices[f * 3 + 1] = indices[sind + 1];
                    this._depthSortedIndices[f * 3 + 2] = indices[sind + 2];
                }
                this.updateIndices(this._depthSortedIndices);
            }
            return this;
        };
        /**
         * Returns the facetLocalNormals array.
         * The normals are expressed in the mesh local spac
         * @returns an array of Vector3
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetLocalNormals = function () {
            if (!this._facetNormals) {
                this.updateFacetData();
            }
            return this._facetNormals;
        };
        /**
         * Returns the facetLocalPositions array.
         * The facet positions are expressed in the mesh local space
         * @returns an array of Vector3
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetLocalPositions = function () {
            if (!this._facetPositions) {
                this.updateFacetData();
            }
            return this._facetPositions;
        };
        /**
         * Returns the facetLocalPartioning array
         * @returns an array of array of numbers
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetLocalPartitioning = function () {
            if (!this._facetPartitioning) {
                this.updateFacetData();
            }
            return this._facetPartitioning;
        };
        /**
         * Returns the i-th facet position in the world system.
         * This method allocates a new Vector3 per call
         * @param i defines the facet index
         * @returns a new Vector3
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetPosition = function (i) {
            var pos = BABYLON.Vector3.Zero();
            this.getFacetPositionToRef(i, pos);
            return pos;
        };
        /**
         * Sets the reference Vector3 with the i-th facet position in the world system
         * @param i defines the facet index
         * @param ref defines the target vector
         * @returns the current mesh
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetPositionToRef = function (i, ref) {
            var localPos = (this.getFacetLocalPositions())[i];
            var world = this.getWorldMatrix();
            BABYLON.Vector3.TransformCoordinatesToRef(localPos, world, ref);
            return this;
        };
        /**
         * Returns the i-th facet normal in the world system.
         * This method allocates a new Vector3 per call
         * @param i defines the facet index
         * @returns a new Vector3
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetNormal = function (i) {
            var norm = BABYLON.Vector3.Zero();
            this.getFacetNormalToRef(i, norm);
            return norm;
        };
        /**
         * Sets the reference Vector3 with the i-th facet normal in the world system
         * @param i defines the facet index
         * @param ref defines the target vector
         * @returns the current mesh
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetNormalToRef = function (i, ref) {
            var localNorm = (this.getFacetLocalNormals())[i];
            BABYLON.Vector3.TransformNormalToRef(localNorm, this.getWorldMatrix(), ref);
            return this;
        };
        /**
         * Returns the facets (in an array) in the same partitioning block than the one the passed coordinates are located (expressed in the mesh local system)
         * @param x defines x coordinate
         * @param y defines y coordinate
         * @param z defines z coordinate
         * @returns the array of facet indexes
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetsAtLocalCoordinates = function (x, y, z) {
            var bInfo = this.getBoundingInfo();
            var ox = Math.floor((x - bInfo.minimum.x * this._partitioningBBoxRatio) * this._subDiv.X * this._partitioningBBoxRatio / this._bbSize.x);
            var oy = Math.floor((y - bInfo.minimum.y * this._partitioningBBoxRatio) * this._subDiv.Y * this._partitioningBBoxRatio / this._bbSize.y);
            var oz = Math.floor((z - bInfo.minimum.z * this._partitioningBBoxRatio) * this._subDiv.Z * this._partitioningBBoxRatio / this._bbSize.z);
            if (ox < 0 || ox > this._subDiv.max || oy < 0 || oy > this._subDiv.max || oz < 0 || oz > this._subDiv.max) {
                return null;
            }
            return this._facetPartitioning[ox + this._subDiv.max * oy + this._subDiv.max * this._subDiv.max * oz];
        };
        /**
         * Returns the closest mesh facet index at (x,y,z) World coordinates, null if not found
         * @param projected sets as the (x,y,z) world projection on the facet
         * @param checkFace if true (default false), only the facet "facing" to (x,y,z) or only the ones "turning their backs", according to the parameter "facing" are returned
         * @param facing if facing and checkFace are true, only the facet "facing" to (x, y, z) are returned : positive dot (x, y, z) * facet position. If facing si false and checkFace is true, only the facet "turning their backs" to (x, y, z) are returned : negative dot (x, y, z) * facet position
         * @param x defines x coordinate
         * @param y defines y coordinate
         * @param z defines z coordinate
         * @returns the face index if found (or null instead)
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getClosestFacetAtCoordinates = function (x, y, z, projected, checkFace, facing) {
            if (checkFace === void 0) { checkFace = false; }
            if (facing === void 0) { facing = true; }
            var world = this.getWorldMatrix();
            var invMat = BABYLON.Tmp.Matrix[5];
            world.invertToRef(invMat);
            var invVect = BABYLON.Tmp.Vector3[8];
            BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(x, y, z, invMat, invVect); // transform (x,y,z) to coordinates in the mesh local space
            var closest = this.getClosestFacetAtLocalCoordinates(invVect.x, invVect.y, invVect.z, projected, checkFace, facing);
            if (projected) {
                // tranform the local computed projected vector to world coordinates
                BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(projected.x, projected.y, projected.z, world, projected);
            }
            return closest;
        };
        /**
         * Returns the closest mesh facet index at (x,y,z) local coordinates, null if not found
         * @param projected sets as the (x,y,z) local projection on the facet
         * @param checkFace if true (default false), only the facet "facing" to (x,y,z) or only the ones "turning their backs", according to the parameter "facing" are returned
         * @param facing if facing and checkFace are true, only the facet "facing" to (x, y, z) are returned : positive dot (x, y, z) * facet position. If facing si false and checkFace is true, only the facet "turning their backs" to (x, y, z) are returned : negative dot (x, y, z) * facet position
         * @param x defines x coordinate
         * @param y defines y coordinate
         * @param z defines z coordinate
         * @returns the face index if found (or null instead)
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getClosestFacetAtLocalCoordinates = function (x, y, z, projected, checkFace, facing) {
            if (checkFace === void 0) { checkFace = false; }
            if (facing === void 0) { facing = true; }
            var closest = null;
            var tmpx = 0.0;
            var tmpy = 0.0;
            var tmpz = 0.0;
            var d = 0.0; // tmp dot facet normal * facet position
            var t0 = 0.0;
            var projx = 0.0;
            var projy = 0.0;
            var projz = 0.0;
            // Get all the facets in the same partitioning block than (x, y, z)
            var facetPositions = this.getFacetLocalPositions();
            var facetNormals = this.getFacetLocalNormals();
            var facetsInBlock = this.getFacetsAtLocalCoordinates(x, y, z);
            if (!facetsInBlock) {
                return null;
            }
            // Get the closest facet to (x, y, z)
            var shortest = Number.MAX_VALUE; // init distance vars
            var tmpDistance = shortest;
            var fib; // current facet in the block
            var norm; // current facet normal
            var p0; // current facet barycenter position
            // loop on all the facets in the current partitioning block
            for (var idx = 0; idx < facetsInBlock.length; idx++) {
                fib = facetsInBlock[idx];
                norm = facetNormals[fib];
                p0 = facetPositions[fib];
                d = (x - p0.x) * norm.x + (y - p0.y) * norm.y + (z - p0.z) * norm.z;
                if (!checkFace || (checkFace && facing && d >= 0.0) || (checkFace && !facing && d <= 0.0)) {
                    // compute (x,y,z) projection on the facet = (projx, projy, projz)
                    d = norm.x * p0.x + norm.y * p0.y + norm.z * p0.z;
                    t0 = -(norm.x * x + norm.y * y + norm.z * z - d) / (norm.x * norm.x + norm.y * norm.y + norm.z * norm.z);
                    projx = x + norm.x * t0;
                    projy = y + norm.y * t0;
                    projz = z + norm.z * t0;
                    tmpx = projx - x;
                    tmpy = projy - y;
                    tmpz = projz - z;
                    tmpDistance = tmpx * tmpx + tmpy * tmpy + tmpz * tmpz; // compute length between (x, y, z) and its projection on the facet
                    if (tmpDistance < shortest) { // just keep the closest facet to (x, y, z)
                        shortest = tmpDistance;
                        closest = fib;
                        if (projected) {
                            projected.x = projx;
                            projected.y = projy;
                            projected.z = projz;
                        }
                    }
                }
            }
            return closest;
        };
        /**
         * Returns the object "parameter" set with all the expected parameters for facetData computation by ComputeNormals()
         * @returns the parameters
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.getFacetDataParameters = function () {
            return this._facetParameters;
        };
        /**
         * Disables the feature FacetData and frees the related memory
         * @returns the current mesh
         * @see http://doc.babylonjs.com/how_to/how_to_use_facetdata
         */
        AbstractMesh.prototype.disableFacetData = function () {
            if (this._facetDataEnabled) {
                this._facetDataEnabled = false;
                this._facetPositions = new Array();
                this._facetNormals = new Array();
                this._facetPartitioning = new Array();
                this._facetParameters = null;
                this._depthSortedIndices = new Uint32Array(0);
            }
            return this;
        };
        /**
         * Updates the AbstractMesh indices array
         * @param indices defines the data source
         * @returns the current mesh
         */
        AbstractMesh.prototype.updateIndices = function (indices) {
            return this;
        };
        /**
         * Creates new normals data for the mesh
         * @param updatable defines if the normal vertex buffer must be flagged as updatable
         * @returns the current mesh
         */
        AbstractMesh.prototype.createNormals = function (updatable) {
            var positions = this.getVerticesData(BABYLON.VertexBuffer.PositionKind);
            var indices = this.getIndices();
            var normals;
            if (this.isVerticesDataPresent(BABYLON.VertexBuffer.NormalKind)) {
                normals = this.getVerticesData(BABYLON.VertexBuffer.NormalKind);
            }
            else {
                normals = [];
            }
            BABYLON.VertexData.ComputeNormals(positions, indices, normals, { useRightHandedSystem: this.getScene().useRightHandedSystem });
            this.setVerticesData(BABYLON.VertexBuffer.NormalKind, normals, updatable);
            return this;
        };
        /**
         * Align the mesh with a normal
         * @param normal defines the normal to use
         * @param upDirection can be used to redefined the up vector to use (will use the (0, 1, 0) by default)
         * @returns the current mesh
         */
        AbstractMesh.prototype.alignWithNormal = function (normal, upDirection) {
            if (!upDirection) {
                upDirection = BABYLON.Axis.Y;
            }
            var axisX = BABYLON.Tmp.Vector3[0];
            var axisZ = BABYLON.Tmp.Vector3[1];
            BABYLON.Vector3.CrossToRef(upDirection, normal, axisZ);
            BABYLON.Vector3.CrossToRef(normal, axisZ, axisX);
            if (this.rotationQuaternion) {
                BABYLON.Quaternion.RotationQuaternionFromAxisToRef(axisX, normal, axisZ, this.rotationQuaternion);
            }
            else {
                BABYLON.Vector3.RotationFromAxisToRef(axisX, normal, axisZ, this.rotation);
            }
            return this;
        };
        /** @hidden */
        AbstractMesh.prototype._checkOcclusionQuery = function () {
            var engine = this.getEngine();
            if (engine.webGLVersion < 2 || this.occlusionType === AbstractMesh.OCCLUSION_TYPE_NONE) {
                this._isOccluded = false;
                return;
            }
            if (this.isOcclusionQueryInProgress && this._occlusionQuery) {
                var isOcclusionQueryAvailable = engine.isQueryResultAvailable(this._occlusionQuery);
                if (isOcclusionQueryAvailable) {
                    var occlusionQueryResult = engine.getQueryResult(this._occlusionQuery);
                    this._isOcclusionQueryInProgress = false;
                    this._occlusionInternalRetryCounter = 0;
                    this._isOccluded = occlusionQueryResult === 1 ? false : true;
                }
                else {
                    this._occlusionInternalRetryCounter++;
                    if (this.occlusionRetryCount !== -1 && this._occlusionInternalRetryCounter > this.occlusionRetryCount) {
                        this._isOcclusionQueryInProgress = false;
                        this._occlusionInternalRetryCounter = 0;
                        // if optimistic set isOccluded to false regardless of the status of isOccluded. (Render in the current render loop)
                        // if strict continue the last state of the object.
                        this._isOccluded = this.occlusionType === AbstractMesh.OCCLUSION_TYPE_OPTIMISTIC ? false : this._isOccluded;
                    }
                    else {
                        return;
                    }
                }
            }
            var scene = this.getScene();
            var occlusionBoundingBoxRenderer = scene.getBoundingBoxRenderer();
            if (!this._occlusionQuery) {
                this._occlusionQuery = engine.createQuery();
            }
            engine.beginOcclusionQuery(this.occlusionQueryAlgorithmType, this._occlusionQuery);
            occlusionBoundingBoxRenderer.renderOcclusionBoundingBox(this);
            engine.endOcclusionQuery(this.occlusionQueryAlgorithmType);
            this._isOcclusionQueryInProgress = true;
        };
        /** No occlusion */
        AbstractMesh.OCCLUSION_TYPE_NONE = 0;
        /** Occlusion set to optimisitic */
        AbstractMesh.OCCLUSION_TYPE_OPTIMISTIC = 1;
        /** Occlusion set to strict */
        AbstractMesh.OCCLUSION_TYPE_STRICT = 2;
        /** Use an accurante occlusion algorithm */
        AbstractMesh.OCCLUSION_ALGORITHM_TYPE_ACCURATE = 0;
        /** Use a conservative occlusion algorithm */
        AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE = 1;
        return AbstractMesh;
    }(BABYLON.TransformNode));
    BABYLON.AbstractMesh = AbstractMesh;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.abstractMesh.js.map







var BABYLON;
(function (BABYLON) {
    /**
     * Base class of all the lights in Babylon. It groups all the generic information about lights.
     * Lights are used, as you would expect, to affect how meshes are seen, in terms of both illumination and colour.
     * All meshes allow light to pass through them unless shadow generation is activated. The default number of lights allowed is four but this can be increased.
     */
    var Light = /** @class */ (function (_super) {
        __extends(Light, _super);
        /**
         * Creates a Light object in the scene.
         * Documentation : http://doc.babylonjs.com/tutorials/lights
         * @param name The firendly name of the light
         * @param scene The scene the light belongs too
         */
        function Light(name, scene) {
            var _this = _super.call(this, name, scene) || this;
            /**
             * Diffuse gives the basic color to an object.
             */
            _this.diffuse = new BABYLON.Color3(1.0, 1.0, 1.0);
            /**
             * Specular produces a highlight color on an object.
             * Note: This is note affecting PBR materials.
             */
            _this.specular = new BABYLON.Color3(1.0, 1.0, 1.0);
            /**
             * Strength of the light.
             * Note: By default it is define in the framework own unit.
             * Note: In PBR materials the intensityMode can be use to chose what unit the intensity is defined in.
             */
            _this.intensity = 1.0;
            /**
             * Defines how far from the source the light is impacting in scene units.
             * Note: Unused in PBR material as the distance light falloff is defined following the inverse squared falloff.
             */
            _this.range = Number.MAX_VALUE;
            /**
             * Cached photometric scale default to 1.0 as the automatic intensity mode defaults to 1.0 for every type
             * of light.
             */
            _this._photometricScale = 1.0;
            _this._intensityMode = Light.INTENSITYMODE_AUTOMATIC;
            _this._radius = 0.00001;
            /**
             * Defines the rendering priority of the lights. It can help in case of fallback or number of lights
             * exceeding the number allowed of the materials.
             */
            _this.renderPriority = 0;
            /**
             * Defines wether or not the shadows are enabled for this light. This can help turning off/on shadow without detaching
             * the current shadow generator.
             */
            _this.shadowEnabled = true;
            _this._excludeWithLayerMask = 0;
            _this._includeOnlyWithLayerMask = 0;
            _this._lightmapMode = 0;
            /**
             * @hidden Internal use only.
             */
            _this._excludedMeshesIds = new Array();
            /**
             * @hidden Internal use only.
             */
            _this._includedOnlyMeshesIds = new Array();
            _this.getScene().addLight(_this);
            _this._uniformBuffer = new BABYLON.UniformBuffer(_this.getScene().getEngine());
            _this._buildUniformLayout();
            _this.includedOnlyMeshes = new Array();
            _this.excludedMeshes = new Array();
            _this._resyncMeshes();
            return _this;
        }
        Object.defineProperty(Light, "LIGHTMAP_DEFAULT", {
            /**
             * If every light affecting the material is in this lightmapMode,
             * material.lightmapTexture adds or multiplies
             * (depends on material.useLightmapAsShadowmap)
             * after every other light calculations.
             */
            get: function () {
                return Light._LIGHTMAP_DEFAULT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTMAP_SPECULAR", {
            /**
             * material.lightmapTexture as only diffuse lighting from this light
             * adds only specular lighting from this light
             * adds dynamic shadows
             */
            get: function () {
                return Light._LIGHTMAP_SPECULAR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTMAP_SHADOWSONLY", {
            /**
             * material.lightmapTexture as only lighting
             * no light calculation from this light
             * only adds dynamic shadows from this light
             */
            get: function () {
                return Light._LIGHTMAP_SHADOWSONLY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_AUTOMATIC", {
            /**
             * Each light type uses the default quantity according to its type:
             *      point/spot lights use luminous intensity
             *      directional lights use illuminance
             */
            get: function () {
                return Light._INTENSITYMODE_AUTOMATIC;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINOUSPOWER", {
            /**
             * lumen (lm)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINOUSPOWER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINOUSINTENSITY", {
            /**
             * candela (lm/sr)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINOUSINTENSITY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_ILLUMINANCE", {
            /**
             * lux (lm/m^2)
             */
            get: function () {
                return Light._INTENSITYMODE_ILLUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINANCE", {
            /**
             * nit (cd/m^2)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_POINTLIGHT", {
            /**
             * Light type const id of the point light.
             */
            get: function () {
                return Light._LIGHTTYPEID_POINTLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_DIRECTIONALLIGHT", {
            /**
             * Light type const id of the directional light.
             */
            get: function () {
                return Light._LIGHTTYPEID_DIRECTIONALLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_SPOTLIGHT", {
            /**
             * Light type const id of the spot light.
             */
            get: function () {
                return Light._LIGHTTYPEID_SPOTLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_HEMISPHERICLIGHT", {
            /**
             * Light type const id of the hemispheric light.
             */
            get: function () {
                return Light._LIGHTTYPEID_HEMISPHERICLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "intensityMode", {
            /**
             * Gets the photometric scale used to interpret the intensity.
             * This is only relevant with PBR Materials where the light intensity can be defined in a physical way.
             */
            get: function () {
                return this._intensityMode;
            },
            /**
             * Sets the photometric scale used to interpret the intensity.
             * This is only relevant with PBR Materials where the light intensity can be defined in a physical way.
             */
            set: function (value) {
                this._intensityMode = value;
                this._computePhotometricScale();
            },
            enumerable: true,
            configurable: true
        });
        ;
        ;
        Object.defineProperty(Light.prototype, "radius", {
            /**
             * Gets the light radius used by PBR Materials to simulate soft area lights.
             */
            get: function () {
                return this._radius;
            },
            /**
             * sets the light radius used by PBR Materials to simulate soft area lights.
             */
            set: function (value) {
                this._radius = value;
                this._computePhotometricScale();
            },
            enumerable: true,
            configurable: true
        });
        ;
        ;
        Object.defineProperty(Light.prototype, "includedOnlyMeshes", {
            /**
             * Gets the only meshes impacted by this light.
             */
            get: function () {
                return this._includedOnlyMeshes;
            },
            /**
             * Sets the only meshes impacted by this light.
             */
            set: function (value) {
                this._includedOnlyMeshes = value;
                this._hookArrayForIncludedOnly(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "excludedMeshes", {
            /**
             * Gets the meshes not impacted by this light.
             */
            get: function () {
                return this._excludedMeshes;
            },
            /**
             * Sets the meshes not impacted by this light.
             */
            set: function (value) {
                this._excludedMeshes = value;
                this._hookArrayForExcluded(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "excludeWithLayerMask", {
            /**
             * Gets the layer id use to find what meshes are not impacted by the light.
             * Inactive if 0
             */
            get: function () {
                return this._excludeWithLayerMask;
            },
            /**
             * Sets the layer id use to find what meshes are not impacted by the light.
             * Inactive if 0
             */
            set: function (value) {
                this._excludeWithLayerMask = value;
                this._resyncMeshes();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "includeOnlyWithLayerMask", {
            /**
             * Gets the layer id use to find what meshes are impacted by the light.
             * Inactive if 0
             */
            get: function () {
                return this._includeOnlyWithLayerMask;
            },
            /**
             * Sets the layer id use to find what meshes are impacted by the light.
             * Inactive if 0
             */
            set: function (value) {
                this._includeOnlyWithLayerMask = value;
                this._resyncMeshes();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "lightmapMode", {
            /**
             * Gets the lightmap mode of this light (should be one of the constants defined by Light.LIGHTMAP_x)
             */
            get: function () {
                return this._lightmapMode;
            },
            /**
             * Sets the lightmap mode of this light (should be one of the constants defined by Light.LIGHTMAP_x)
             */
            set: function (value) {
                if (this._lightmapMode === value) {
                    return;
                }
                this._lightmapMode = value;
                this._markMeshesAsLightDirty();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the string "Light".
         * @returns the class name
         */
        Light.prototype.getClassName = function () {
            return "Light";
        };
        /**
         * Converts the light information to a readable string for debug purpose.
         * @param fullDetails Supports for multiple levels of logging within scene loading
         * @returns the human readable light info
         */
        Light.prototype.toString = function (fullDetails) {
            var ret = "Name: " + this.name;
            ret += ", type: " + (["Point", "Directional", "Spot", "Hemispheric"])[this.getTypeID()];
            if (this.animations) {
                for (var i = 0; i < this.animations.length; i++) {
                    ret += ", animation[0]: " + this.animations[i].toString(fullDetails);
                }
            }
            if (fullDetails) {
            }
            return ret;
        };
        /**
         * Set the enabled state of this node.
         * @param value - the new enabled state
         */
        Light.prototype.setEnabled = function (value) {
            _super.prototype.setEnabled.call(this, value);
            this._resyncMeshes();
        };
        /**
         * Returns the Light associated shadow generator if any.
         * @return the associated shadow generator.
         */
        Light.prototype.getShadowGenerator = function () {
            return this._shadowGenerator;
        };
        /**
         * Returns a Vector3, the absolute light position in the World.
         * @returns the world space position of the light
         */
        Light.prototype.getAbsolutePosition = function () {
            return BABYLON.Vector3.Zero();
        };
        /**
         * Specifies if the light will affect the passed mesh.
         * @param mesh The mesh to test against the light
         * @return true the mesh is affected otherwise, false.
         */
        Light.prototype.canAffectMesh = function (mesh) {
            if (!mesh) {
                return true;
            }
            if (this.includedOnlyMeshes && this.includedOnlyMeshes.length > 0 && this.includedOnlyMeshes.indexOf(mesh) === -1) {
                return false;
            }
            if (this.excludedMeshes && this.excludedMeshes.length > 0 && this.excludedMeshes.indexOf(mesh) !== -1) {
                return false;
            }
            if (this.includeOnlyWithLayerMask !== 0 && (this.includeOnlyWithLayerMask & mesh.layerMask) === 0) {
                return false;
            }
            if (this.excludeWithLayerMask !== 0 && this.excludeWithLayerMask & mesh.layerMask) {
                return false;
            }
            return true;
        };
        /**
         * Computes and Returns the light World matrix.
         * @returns the world matrix
         */
        Light.prototype.getWorldMatrix = function () {
            this._currentRenderId = this.getScene().getRenderId();
            this._childRenderId = this._currentRenderId;
            var worldMatrix = this._getWorldMatrix();
            if (this.parent && this.parent.getWorldMatrix) {
                if (!this._parentedWorldMatrix) {
                    this._parentedWorldMatrix = BABYLON.Matrix.Identity();
                }
                worldMatrix.multiplyToRef(this.parent.getWorldMatrix(), this._parentedWorldMatrix);
                this._markSyncedWithParent();
                return this._parentedWorldMatrix;
            }
            return worldMatrix;
        };
        /**
         * Sort function to order lights for rendering.
         * @param a First Light object to compare to second.
         * @param b Second Light object to compare first.
         * @return -1 to reduce's a's index relative to be, 0 for no change, 1 to increase a's index relative to b.
         */
        Light.CompareLightsPriority = function (a, b) {
            //shadow-casting lights have priority over non-shadow-casting lights
            //the renderPrioirty is a secondary sort criterion
            if (a.shadowEnabled !== b.shadowEnabled) {
                return (b.shadowEnabled ? 1 : 0) - (a.shadowEnabled ? 1 : 0);
            }
            return b.renderPriority - a.renderPriority;
        };
        /**
         * Releases resources associated with this node.
         * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
         * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
         */
        Light.prototype.dispose = function (doNotRecurse, disposeMaterialAndTextures) {
            if (disposeMaterialAndTextures === void 0) { disposeMaterialAndTextures = false; }
            if (this._shadowGenerator) {
                this._shadowGenerator.dispose();
                this._shadowGenerator = null;
            }
            // Animations
            this.getScene().stopAnimation(this);
            // Remove from meshes
            for (var _i = 0, _a = this.getScene().meshes; _i < _a.length; _i++) {
                var mesh = _a[_i];
                mesh._removeLightSource(this);
            }
            this._uniformBuffer.dispose();
            // Remove from scene
            this.getScene().removeLight(this);
            _super.prototype.dispose.call(this, doNotRecurse, disposeMaterialAndTextures);
        };
        /**
         * Returns the light type ID (integer).
         * @returns The light Type id as a constant defines in Light.LIGHTTYPEID_x
         */
        Light.prototype.getTypeID = function () {
            return 0;
        };
        /**
         * Returns the intensity scaled by the Photometric Scale according to the light type and intensity mode.
         * @returns the scaled intensity in intensity mode unit
         */
        Light.prototype.getScaledIntensity = function () {
            return this._photometricScale * this.intensity;
        };
        /**
         * Returns a new Light object, named "name", from the current one.
         * @param name The name of the cloned light
         * @returns the new created light
         */
        Light.prototype.clone = function (name) {
            var constructor = Light.GetConstructorFromName(this.getTypeID(), name, this.getScene());
            if (!constructor) {
                return null;
            }
            return BABYLON.SerializationHelper.Clone(constructor, this);
        };
        /**
         * Serializes the current light into a Serialization object.
         * @returns the serialized object.
         */
        Light.prototype.serialize = function () {
            var serializationObject = BABYLON.SerializationHelper.Serialize(this);
            // Type
            serializationObject.type = this.getTypeID();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            // Inclusion / exclusions
            if (this.excludedMeshes.length > 0) {
                serializationObject.excludedMeshesIds = [];
                this.excludedMeshes.forEach(function (mesh) {
                    serializationObject.excludedMeshesIds.push(mesh.id);
                });
            }
            if (this.includedOnlyMeshes.length > 0) {
                serializationObject.includedOnlyMeshesIds = [];
                this.includedOnlyMeshes.forEach(function (mesh) {
                    serializationObject.includedOnlyMeshesIds.push(mesh.id);
                });
            }
            // Animations  
            BABYLON.Animation.AppendSerializedAnimations(this, serializationObject);
            serializationObject.ranges = this.serializeAnimationRanges();
            return serializationObject;
        };
        /**
         * Creates a new typed light from the passed type (integer) : point light = 0, directional light = 1, spot light = 2, hemispheric light = 3.
         * This new light is named "name" and added to the passed scene.
         * @param type Type according to the types available in Light.LIGHTTYPEID_x
         * @param name The friendly name of the light
         * @param scene The scene the new light will belong to
         * @returns the constructor function
         */
        Light.GetConstructorFromName = function (type, name, scene) {
            switch (type) {
                case 0:
                    return function () { return new BABYLON.PointLight(name, BABYLON.Vector3.Zero(), scene); };
                case 1:
                    return function () { return new BABYLON.DirectionalLight(name, BABYLON.Vector3.Zero(), scene); };
                case 2:
                    return function () { return new BABYLON.SpotLight(name, BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero(), 0, 0, scene); };
                case 3:
                    return function () { return new BABYLON.HemisphericLight(name, BABYLON.Vector3.Zero(), scene); };
            }
            return null;
        };
        /**
         * Parses the passed "parsedLight" and returns a new instanced Light from this parsing.
         * @param parsedLight The JSON representation of the light
         * @param scene The scene to create the parsed light in
         * @returns the created light after parsing
         */
        Light.Parse = function (parsedLight, scene) {
            var constructor = Light.GetConstructorFromName(parsedLight.type, parsedLight.name, scene);
            if (!constructor) {
                return null;
            }
            var light = BABYLON.SerializationHelper.Parse(constructor, parsedLight, scene);
            // Inclusion / exclusions
            if (parsedLight.excludedMeshesIds) {
                light._excludedMeshesIds = parsedLight.excludedMeshesIds;
            }
            if (parsedLight.includedOnlyMeshesIds) {
                light._includedOnlyMeshesIds = parsedLight.includedOnlyMeshesIds;
            }
            // Parent
            if (parsedLight.parentId) {
                light._waitingParentId = parsedLight.parentId;
            }
            // Animations
            if (parsedLight.animations) {
                for (var animationIndex = 0; animationIndex < parsedLight.animations.length; animationIndex++) {
                    var parsedAnimation = parsedLight.animations[animationIndex];
                    light.animations.push(BABYLON.Animation.Parse(parsedAnimation));
                }
                BABYLON.Node.ParseAnimationRanges(light, parsedLight, scene);
            }
            if (parsedLight.autoAnimate) {
                scene.beginAnimation(light, parsedLight.autoAnimateFrom, parsedLight.autoAnimateTo, parsedLight.autoAnimateLoop, parsedLight.autoAnimateSpeed || 1.0);
            }
            return light;
        };
        Light.prototype._hookArrayForExcluded = function (array) {
            var _this = this;
            var oldPush = array.push;
            array.push = function () {
                var items = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    items[_i] = arguments[_i];
                }
                var result = oldPush.apply(array, items);
                for (var _a = 0, items_1 = items; _a < items_1.length; _a++) {
                    var item = items_1[_a];
                    item._resyncLighSource(_this);
                }
                return result;
            };
            var oldSplice = array.splice;
            array.splice = function (index, deleteCount) {
                var deleted = oldSp