MSHADERS = {  
  mvertex: [
    "varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"
  ].join("\n"),

  circlesFragment: [
    "uniform vec2 resolution;",
    "uniform float time;",
    "uniform float gtime;",
    "uniform int bgpart;",
    "uniform float circleTime;",
    "uniform float circleTime2;",
    "uniform int circlesOn;",
    
    
    "vec3 bground(vec2 uv, float time2) {",
	    "float m = sin(time2*0.2);",
      "float n = cos(time2*0.5);",
	    
      "float cc = sqrt(m*(uv.x-0.3)*(uv.x-0.3) + n*(uv.y-0.5)*(uv.y-0.5));",
      "float cc2 = sqrt(n*uv.x*uv.x + m*uv.y*uv.y);",

      "if(cc < 0.8*m && cc > 0.2)",
        "return vec3(uv.x*n, uv.x*m, uv.y*m);",

      "else if (cc2 < 0.8 && cc2 > 0.2*n)", 
        "return vec3(uv.x*m, uv.x*n*0.8, uv.y*n*0.8);",
      
      "else return vec3(m*m, n*m*0.5, n);",
    "}",

    "vec3 bg1(vec2 uv) {",
      "if(bgpart == 1) {",
        "return bground(uv, time*1.5-1.2);",
      "} else if( bgpart == 2 ) {",
        "return bground(uv, time+1.0);",
      "}",   
      "else return vec3(0.0,0.0,0.0);",
    "}",


    "vec3 circles2(vec2 u, float aspect) {",
      "float x = (u.x-0.5)*aspect;",
      "float y = u.y-0.5;",
      "float cc = sqrt(x*x + y*y)*tan(circleTime)*-0.5;",
      "float cc2 = sqrt(x*x + y*y)*tan(circleTime2)*-1.6;",
    
      "if (cc < 0.2 && cc > 0.1 && (circlesOn == 1 || circlesOn == 3))", 
        "return vec3(u.x*u.y*5.0, u.x*u.y*3.0, 0.0);",

      "else if(cc2 < 0.5 && cc2 > 0.37 && (circlesOn == 2 || circlesOn == 3))",
        "return vec3(u.x*u.y*5.0, 0.0, u.x*u.y*3.0);",

      "else return vec3(0.1*cos(time), 0.0, 0.1*sin(time));",    
    "}",


    "void main() {",
      "vec2 uv = gl_FragCoord.xy / resolution.xy;",

      "float aspect = resolution.x/resolution.y;",
    
      "float r = length(uv);",
      "float p = atan(uv.x, r);",
      "vec3 color;",
      "color = bg1(vec2(r, p))*0.7 + circles2(uv, aspect)*0.5;",
      "vec3 corColor = smoothstep(0.1, 1.0, color);",
      "gl_FragColor = vec4(corColor, 1.0);",
    "}"
  ].join("\n")

}
