var Shadercats = function(){
  PartBase.call(this);
  //this.setHorizontalBlur(8);
  //this.setVerticalBlur(8);
  this.setEdgeDetection();
  this.setBloom(4);
  this.createCats();
  this.createRb();
  this.catsMove = true;
};

Shadercats.prototype = PartBase.prototype.inheritance();

Shadercats.prototype.animateCats = function(elapsedTime) {
  for(var i=0; i<this.catArray.length; i++) {
    var c = this.catArray[i];
    c.position.y = (Math.sin(elapsedTime)*(c.position.z*0.1+1)+Math.cos(elapsedTime)*(0.1*c.position.x-1));
  }
};

Shadercats.prototype.moveCats = function(elapsedTime) {
  var catRot = TDEMO.SYNC.getObjRotation();
  var catPos = TDEMO.SYNC.getObjPosition();
  this.cats.position.x = catPos.x;
  this.cats.position.y = catPos.y;
  this.cats.position.z = catPos.z;
  
  this.cats.rotation.x = catRot.x;
  this.cats.rotation.y = catRot.y;
  this.cats.rotation.z = catRot.z;
};


Shadercats.prototype.animateRb = function(elapsedTime) {
  var msin = Math.sin(elapsedTime);
  var mcos = Math.cos(elapsedTime);
  for(var i=0; i<this.rainbow.rings.length; i++) {
    if(i%2 === 0) 
      this.rainbow.rings[i].position.set(12*msin, 10*msin, 12*msin);
    else 
      this.rainbow.rings[i].position.set(12*mcos, 10*msin, 12*mcos);
  }
  /*
  this.rainbow.red.position.set(12*msin, 10*msin, 12*msin);
  this.rainbow.orange.position.set(12*mcos, 10*msin, 12*mcos);
  this.rainbow.yel.position.set(12*msin, 10*msin, 12*mcos);
  this.rainbow.green.position.set(12*mcos, 10*msin, 12*msin);
  this.rainbow.blue.position.set(12*mcos, 10*msin, 12*mcos);
  this.rainbow.v1.position.set(12*mcos, 10*mcos, 12*mcos);
  this.rainbow.v2.position.set(12*msin, 10*mcos, 12*msin);
  */
};


Shadercats.prototype.circlesOn = function(value) {
  if (value !== 0 && this.circlesCount !== 0) {
    this.circlesCount = 3;
    this.uniforms.circlesOn.value = 3;
  } else {
    this.uniforms.circlesOn.value = value;
    this.circlesCount = value;
  }
};


Shadercats.prototype.animateShader = function(trig, bgControl) {
  var trig = TDEMO.SYNC.getCircle();
  var bgControl = TDEMO.SYNC.getShaderBg();

  if(this.elapsed == 0) { 
    this.timepoint1 = 0;
    this.timepoint2 = 0;
    this.circleStarted = false;
    this.circleStarted2 = false;
  }  

  if(bgControl > 2 || bgControl < 0) {
    this.bgtimeskip = bgControl;
  } else {
    this.uniforms.bgpart.value = bgControl;
  }
  
  if (trig === 1 && !this.circleStarted) {
    this.circlesOn(1);
    this.timepoint1 = (this.elapsed*0.75) % Math.PI;
    this.circleStarted = true;
  }

  if (trig === 2 && !this.circleStarted2) {
    this.circlesOn(2);
    this.timepoint2 = (this.elapsed*0.525) % Math.PI;
    this.circleStarted2 = true;
  }

  if (trig === 3) {
    this.circleStarted = false;
  }
  

  if (trig === 4) {
    this.circleStarted2 = false;
  }
  
  if (trig === 0) this.circlesOn(0);
  

  this.uniforms.circleTime.value = (Math.PI/2+this.elapsed*0.75 - this.timepoint1);
  this.uniforms.circleTime2.value = (Math.PI/2+this.elapsed*0.525 - this.timepoint2);

  this.uniforms.gtime.value = this.elapsed+this.bgtimeskip;
  this.uniforms.time.value = this.elapsed*0.75+this.bgtimeskip;
};

Shadercats.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta, true);

  var hb = TDEMO.SYNC.getHeartBeat();
  if (this.catsMove) this.animateCats(elapsedTime);
  if (hb === 1) this.catsMove = false;
  this.moveCats();
  this.animateRb(elapsedTime);
  this.animateShader();  
};


Shadercats.prototype.createCats = function() {
  this.planeMaterial = this.createMaterial();
  this.kissat();
  var startx = -30;
  var starty = 30;
  var startz = -30;
};

Shadercats.prototype.kissat = function() {
  var kissat = kissalauma(this.planeMaterial);
  this.cats = kissat["cats"];
  this.catArray = kissat["catArray"];
  this.scene.add(this.cats);
  this.cats.position.set(0,-30,0);
  this.cats.rotation.y = Math.PI / 6;
};

Shadercats.prototype.createRb = function() {
  var ambientLight = new THREE.AmbientLight(0xffffff);
  this.scene.add(ambientLight);
  this.rainbow = new Rainbow(4, TDEMO.TEXTURES.getTextures().sydan);
  this.rainbow.rainbowObj.position.set(-50, 0, -300);
  this.rainbow.rainbowObj.rotation.y = Math.PI / 4;
  this.scene.add(this.rainbow.rainbowObj);
};

Shadercats.prototype.createMaterial = function(){
  this.timepoint1 = 0;
  this.timepoint2 = 0;
  this.circleStarted = false;
  this.circleStarted2 = false;
  this.circlesCount = 0;
  this.bgtimeskip = 0;

  this.uniforms = {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(this.width, this.height)},
    gtime : {type : "f", value: 0.0},
    circleTime : {type : "f", value: 0.0},
    circleTime2 : {type : "f", value: 0.0},
    circlesOn : {type : "i", value: 0},
    bgpart : {type: "i", value: 0}
  };

  var material = new THREE.ShaderMaterial({
    uniforms : this.uniforms,
    vertexShader: MSHADERS.mvertex,
    fragmentShader: MSHADERS.circlesFragment,
    side : THREE.DoubleSide
  });
  
  return material; 
}
