/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import java.util.Arrays;

public class MoogFilter
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput frequency = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput resonance = new UGen.UGenInput(UGen.InputType.CONTROL);
    public Type type;
    private float[][] coeff;

    public MoogFilter(float frequencyInHz, float normalizedResonance) {
        this(frequencyInHz, normalizedResonance, Type.LP);
    }

    public MoogFilter(float frequencyInHz, float normalizedResonance, Type filterType) {
        this.type = filterType;
        this.frequency.setLastValue(frequencyInHz);
        this.resonance.setLastValue(this.constrain(normalizedResonance, 0.0f, 1.0f));
        this.coeff = new float[this.channelCount()][5];
    }

    @Override
    protected void channelCountChanged() {
        if (this.coeff == null || this.coeff.length != this.channelCount()) {
            this.coeff = new float[this.channelCount()][5];
        }
    }

    @Override
    protected void uGenerate(float[] out) {
        float normFreq = this.frequency.getLastValue() / (this.sampleRate() * 0.5f);
        float rez = this.constrain(this.resonance.getLastValue(), 0.0f, 1.0f);
        float q = 1.0f - normFreq;
        float p = normFreq + 0.8f * normFreq * q;
        float f = p + p - 1.0f;
        q = rez * (1.0f + 0.5f * q * (1.0f - q + 5.6f * q * q));
        float[] input = this.audio.getLastValues();
        block5: for (int i = 0; i < this.channelCount(); ++i) {
            float[] b = this.coeff[i];
            float in = this.constrain(input[i], -1.0f, 1.0f);
            float t1 = b[1];
            b[1] = ((in -= q * b[4]) + b[0]) * p - b[1] * f;
            float t2 = b[2];
            b[2] = (b[1] + t1) * p - b[2] * f;
            t1 = b[3];
            b[3] = (b[2] + t2) * p - b[3] * f;
            b[4] = (b[3] + t1) * p - b[4] * f;
            b[4] = b[4] - b[4] * b[4] * b[4] * 0.166667f;
            if (Float.isNaN(b[4])) {
                Arrays.fill(b, 0.0f);
            }
            b[0] = in;
            switch (this.type) {
                case HP: {
                    out[i] = in - b[4];
                    continue block5;
                }
                case LP: {
                    out[i] = b[4];
                    continue block5;
                }
                case BP: {
                    out[i] = 3.0f * (b[3] - b[4]);
                }
            }
        }
    }

    private float constrain(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static enum Type {
        HP,
        LP,
        BP;

    }
}

