/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class main
extends PApplet {
    Minim minim;
    AudioPlayer player;
    int sceneNumber = 1;
    foregroundScrollers fgs;
    starfield sf;
    zikCube zc;
    commodoreFlag cf;
    copperList cl;
    retroField rf;
    boingBall bB;
    int musicPosition;
    boolean overScene = false;

    public void setup() {
        this.minim = new Minim((Object)this);
        this.fgs = new foregroundScrollers();
        this.sf = new starfield();
        this.zc = new zikCube();
        this.cf = new commodoreFlag();
        this.cl = new copperList(5);
        this.rf = new retroField();
        this.bB = new boingBall();
        this.surface.setTitle("mGGk :: RetroProcesing");
        this.surface.setResizable(false);
        this.frameRate(60.0f);
        this.noCursor();
        this.player = this.minim.loadFile("erk_mankind.mp3");
        this.player.play();
    }

    public void draw() {
        this.musicPosition = this.player.position();
        main.print((String)(String.valueOf(this.musicPosition) + "\n"));
        if (this.musicPosition > 0 && this.musicPosition < 16700) {
            this.sceneNumber = 1;
        }
        if (this.musicPosition >= 16700 && this.musicPosition < 25000) {
            this.sceneNumber = 2;
        }
        if (this.musicPosition >= 25000 && this.musicPosition < 30000) {
            this.sceneNumber = 3;
        }
        if (this.musicPosition >= 30000 && this.musicPosition < 65000) {
            this.sceneNumber = 4;
        }
        if (this.musicPosition >= 122904) {
            this.exit();
        }
        this.clear();
        if (this.overScene) {
            this.sceneNumber = 5;
        }
        switch (this.sceneNumber) {
            case 1: {
                this.sf.display();
                this.zc.display();
                break;
            }
            case 2: {
                this.sf.display();
                this.cl.display();
                break;
            }
            case 3: {
                this.rf.display();
                break;
            }
            case 4: {
                this.rf.display();
                this.bB.display();
            }
        }
        this.fgs.display();
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"main"};
        if (passedArgs != null) {
            PApplet.main((String[])main.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class Star {
        float x;
        float y;

        Star() {
            this.y = main.this.random(0.0f, main.this.height);
            this.x = main.this.random(0.0f, main.this.width);
        }

        public void display() {
            this.x -= 10.0f;
            if (this.x <= 0.0f) {
                this.x = (float)main.this.width + main.this.random(0.0f, main.this.width);
            }
            main.this.fill(255);
            main.this.noStroke();
            main.this.rect(this.x, this.y, 2.0f, 2.0f);
        }
    }

    class boingBall {
        PGraphics pg;
        PImage texture;
        PShape ball;
        int round;
        int posX = 0;
        int posY = 0;
        int moveSpeed = 5;
        boolean forwardX;
        boolean forwardY = true;

        boingBall() {
            this.pg = main.this.createGraphics(1280, 800, "processing.opengl.PGraphics3D");
            this.texture = main.this.loadImage("boing_ball.jpg");
            this.ball = main.this.createShape(40, new float[]{20.0f});
            this.ball.setTexture(this.texture);
            this.ball.setStroke(false);
        }

        public void render() {
            this.pg.beginDraw();
            this.pg.clear();
            this.pg.noStroke();
            this.pg.noFill();
            this.pg.lights();
            this.pg.translate((float)(main.this.width / 2), (float)(main.this.height / 2), 0.0f);
            this.pg.rotateY((float)this.round / (float)Math.PI / 10.0f);
            this.pg.rotateX((float)this.round / (float)Math.PI / 10.0f);
            this.pg.scale(5.0f);
            this.pg.shape(this.ball);
            this.pg.noStroke();
            this.pg.endDraw();
            ++this.round;
        }

        public void display() {
            this.render();
            if (this.posX > 530) {
                this.forwardX = false;
            }
            if (this.posX < -530) {
                this.forwardX = true;
            }
            if (this.posY > 250) {
                this.forwardY = false;
            }
            if (this.posY < -250) {
                this.forwardY = true;
            }
            this.posX = this.forwardX ? (this.posX += this.moveSpeed) : (this.posX -= this.moveSpeed);
            this.posY = this.forwardY ? (this.posY += this.moveSpeed) : (this.posY -= this.moveSpeed);
            main.this.image((PImage)this.pg, this.posX, this.posY);
        }
    }

    public class commodoreFlag {
        PImage img;
        int round = 1;

        commodoreFlag() {
            this.img = main.this.loadImage("commodore-logo.jpg");
        }

        public void display() {
            int x = 0;
            while (x < this.img.width) {
                main.this.image(this.img.get(x, 0, 1, this.img.height), x, 20.0f * main.sin((float)main.radians((float)(x + main.this.millis()))));
                ++this.round;
                ++x;
            }
        }
    }

    public class copper {
        PGraphics renderHandler;
        int copHeight;
        int yPos;
        float redCol;
        float blueCol;
        float greenCol;
        float srRC;
        float srBC;
        float srGC;
        int stepNumber;
        int maxBot = 5;
        float currentY;
        float minY = 80.0f;
        float maxY = 600.0f;
        int speed = 5;
        boolean forward = true;

        copper(int cH, float rC, float gC, float bC, int yP) {
            this.copHeight = cH;
            this.redCol = rC;
            this.blueCol = bC;
            this.greenCol = gC;
            this.yPos = yP;
            this.stepNumber = this.copHeight;
            this.srRC = this.redCol;
            this.srBC = this.blueCol;
            this.srGC = this.greenCol;
            this.renderHandler = main.this.createGraphics(1280, cH);
        }

        public void render() {
            this.renderHandler.beginDraw();
            this.renderHandler.clear();
            this.srRC = this.redCol;
            this.srBC = this.blueCol;
            this.srGC = this.greenCol;
            int i = 0;
            while (i < this.copHeight) {
                if (i <= this.copHeight / 2 - 6) {
                    this.srRC += (255.0f - this.redCol) / (float)(this.stepNumber / 2);
                    this.srBC += (255.0f - this.blueCol) / (float)(this.stepNumber / 2);
                    this.srGC += (255.0f - this.greenCol) / (float)(this.stepNumber / 2);
                } else if (i >= this.copHeight / 2 - 6) {
                    this.srRC -= (255.0f - this.redCol) / (float)(this.stepNumber / 2);
                    this.srBC -= (255.0f - this.blueCol) / (float)(this.stepNumber / 2);
                    this.srGC -= (255.0f - this.greenCol) / (float)(this.stepNumber / 2);
                } else {
                    this.srRC = 255.0f;
                    this.srBC = 255.0f;
                    this.srGC = 255.0f;
                }
                this.renderHandler.stroke(this.srRC, this.srGC, this.srBC);
                this.renderHandler.line(0.0f, (float)i, 1280.0f, (float)i);
                ++i;
            }
            this.renderHandler.endDraw();
        }

        public void display() {
            this.render();
            if (this.yPos + this.speed + this.copHeight > 730) {
                this.forward = false;
            }
            if (this.yPos + this.speed + this.copHeight < 130) {
                this.forward = true;
            }
            this.yPos = this.forward ? (this.yPos += this.speed) : (this.yPos -= this.speed);
            main.this.image((PImage)this.renderHandler, 0.0f, this.yPos);
        }
    }

    public class copperList {
        copper[] copperArray;
        PVector[] colorVects;

        copperList(int count) {
            this.copperArray = new copper[count];
            this.colorVects = new PVector[count];
            this.colorVects[0] = new PVector(52.0f, 152.0f, 219.0f);
            this.colorVects[1] = new PVector(241.0f, 196.0f, 15.0f);
            this.colorVects[2] = new PVector(155.0f, 89.0f, 182.0f);
            this.colorVects[3] = new PVector(46.0f, 204.0f, 113.0f);
            this.colorVects[4] = new PVector(192.0f, 57.0f, 43.0f);
            int i = 0;
            while (i < count) {
                this.copperArray[i] = new copper(40, this.colorVects[i].x, this.colorVects[i].y, this.colorVects[i].z, 130 + 60 * i);
                ++i;
            }
        }

        public void display() {
            int i = 0;
            while (i < this.copperArray.length) {
                this.copperArray[i].display();
                ++i;
            }
        }
    }

    public class foregroundScrollers {
        PFont fontBottom;
        float sineFreq = 0.1f;
        float red;
        float blue;
        float green;
        int roundTop = 1;
        int roundBottom = 1;
        String scrollerText;
        int textPosX = 1280;

        foregroundScrollers() {
            this.fontBottom = main.this.loadFont("fontBottom.vlw");
            this.scrollerText = "Yeah !!!! Another release from mGGk, this time a small PC intro for the VIP 2017 Demoparty called RetroProcessing.";
            this.scrollerText = String.valueOf(this.scrollerText) + " code : mGGk - music : erk^mankind -";
            this.scrollerText = String.valueOf(this.scrollerText) + " First a nice colored cube..........why ? because it's nice :) Oh what's that ? Fake copperbars, it smell AMIGAAAAAAAAAAAAAA ! Well enought of this starfield, let's use a rainbow field.... Whooa nice.... But something from amiga is missing, so let's add a boing ball !";
            this.scrollerText = String.valueOf(this.scrollerText) + " Greetz to groups I like : ASD - Brainstorm - PooBrain - Cocoon - Conspiracy - Resistance - Mandarine - Fairlight - LNX - Triple A - Unity - Popsy Team - farbrausch - TRSI - X-Men - FLC - Flush - Still - Razor 1911";
            this.scrollerText = String.valueOf(this.scrollerText) + "                                                                                                                                                                                                              ";
            this.scrollerText = String.valueOf(this.scrollerText) + "Still there ? Really ? The intro is at the end, go take a beer instead of waiting something....";
        }

        public void display() {
            main.this.noStroke();
            main.this.fill(0);
            main.this.rect(0.0f, 0.0f, 1280.0f, 50.0f);
            int i = 2;
            while (i < 258) {
                this.red = main.sin((float)(this.sineFreq * (float)(i - this.roundTop) + 0.0f)) * 127.0f + 128.0f;
                this.blue = main.sin((float)(this.sineFreq * (float)(i - this.roundTop) + 2.0f)) * 127.0f + 128.0f;
                this.green = main.sin((float)(this.sineFreq * (float)(i - this.roundTop) + 4.0f)) * 127.0f + 128.0f;
                main.this.fill(this.red, this.green, this.blue);
                main.this.rect((i - 2) * 5, 50.0f, 5.0f, 5.0f);
                ++i;
            }
            this.roundTop += 2;
            main.this.fill(0);
            main.this.rect(0.0f, 750.0f, 1280.0f, 50.0f);
            i = 2;
            while (i < 258) {
                this.red = main.sin((float)(this.sineFreq * (float)(i - this.roundBottom) + 0.0f)) * 127.0f + 128.0f;
                this.blue = main.sin((float)(this.sineFreq * (float)(i - this.roundBottom) + 2.0f)) * 127.0f + 128.0f;
                this.green = main.sin((float)(this.sineFreq * (float)(i - this.roundBottom) + 4.0f)) * 127.0f + 128.0f;
                main.this.fill(this.red, this.green, this.blue);
                main.this.rect((i - 2) * 5, 745.0f, 5.0f, 5.0f);
                ++i;
            }
            this.roundBottom += 2;
            main.this.fill(255);
            main.this.textFont(this.fontBottom, 24.0f);
            main.this.text(this.scrollerText, this.textPosX, 32.0f);
            this.textPosX -= 5;
            main.this.fill(255);
            main.this.textFont(this.fontBottom, 24.0f);
            main.this.text("mGGk-2017", 10.0f, 785.0f);
        }
    }

    class retroField {
        PGraphics pg;
        int cols;
        int rows;
        int scl = 20;
        int w = 2000;
        int h = 1600;
        float red;
        float blue;
        float green;
        float sineFreq = 0.1f;
        float flying = 0.0f;
        int round;
        float[][] terrain;

        retroField() {
            this.pg = main.this.createGraphics(1280, 800, "processing.opengl.PGraphics3D");
            this.cols = this.w / this.scl;
            this.rows = this.h / this.scl;
            this.terrain = new float[this.cols][this.rows];
        }

        public void display() {
            this.flying -= 0.1f;
            float yoff = this.flying;
            int y = 0;
            while (y < this.rows) {
                float xoff = 0.0f;
                int x = 0;
                while (x < this.cols) {
                    this.terrain[x][y] = main.map((float)main.this.noise(xoff, yoff), (float)0.0f, (float)1.0f, (float)-100.0f, (float)100.0f);
                    xoff += 0.2f;
                    ++x;
                }
                yoff += 0.2f;
                ++y;
            }
            this.pg.beginDraw();
            this.pg.background(0);
            int i = 2;
            while (i < 258) {
                this.red = main.sin((float)(this.sineFreq * (float)(i - this.round / 30) + 0.0f)) * 127.0f + 128.0f;
                this.blue = main.sin((float)(this.sineFreq * (float)(i - this.round / 30) + 2.0f)) * 127.0f + 128.0f;
                this.green = main.sin((float)(this.sineFreq * (float)(i - this.round / 30) + 4.0f)) * 127.0f + 128.0f;
                this.pg.stroke(this.red, this.green, this.blue);
                ++i;
            }
            this.pg.noFill();
            this.pg.translate((float)(main.this.width / 2), (float)(main.this.height / 2 + 50));
            this.pg.rotateX(1.0471976f);
            this.pg.translate((float)(-this.w / 2), (float)(-this.h / 2));
            y = 0;
            while (y < this.rows - 1) {
                this.pg.beginShape(10);
                int x = 0;
                while (x < this.cols) {
                    this.pg.vertex((float)(x * this.scl), (float)(y * this.scl), this.terrain[x][y]);
                    this.pg.vertex((float)(x * this.scl), (float)((y + 1) * this.scl), this.terrain[x][y + 1]);
                    ++x;
                }
                this.pg.endShape();
                ++y;
            }
            ++this.round;
            this.pg.endDraw();
            main.this.image((PImage)this.pg, 0.0f, 0.0f);
        }
    }

    public class starfield {
        Star[] stars = new Star[800];
        float speed;

        starfield() {
            int i = 0;
            while (i < this.stars.length) {
                this.stars[i] = new Star();
                ++i;
            }
        }

        public void display() {
            int i = 0;
            while (i < this.stars.length) {
                this.stars[i].display();
                ++i;
            }
        }
    }

    public class zikCube {
        PGraphics pg;
        float round = 1.0f;
        PImage tex;

        zikCube() {
            this.pg = main.this.createGraphics(1280, 800, "processing.opengl.PGraphics3D");
        }

        public void display() {
            this.tex = main.this.loadImage("cube_texture.png");
            this.pg.beginDraw();
            this.pg.clear();
            this.pg.translate((float)(main.this.width / 2), (float)(main.this.height / 2), 0.0f);
            this.pg.rotateX(this.round);
            this.pg.rotateY(this.round);
            this.pg.noStroke();
            this.pg.scale(90.0f);
            this.VertexCube();
            this.pg.endDraw();
            this.round += 0.05f;
            main.this.image((PImage)this.pg, 0.0f, 0.0f);
        }

        public void VertexCube() {
            this.pg.beginShape(9);
            this.pg.fill(0.0f, 255.0f, 0.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.vertex(0.0f, 0.0f, -1.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(0.0f, 0.0f, -1.0f);
            this.pg.vertex(1.0f, 0.0f, 0.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(1.0f, 0.0f, 0.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.vertex(0.0f, 0.0f, 1.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(0.0f, 0.0f, 1.0f);
            this.pg.vertex(-1.0f, 0.0f, 0.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(-1.0f, 0.0f, 0.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(0.0f, 1.0f, 0.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(0.0f, 1.0f, 0.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(0.0f, -1.0f, 0.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.vertex(0.0f, -1.0f, 0.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.fill(255.0f, 255.0f, 255.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(0.0f, 0.0f, -1.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.vertex(0.0f, 0.0f, -1.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.vertex(1.0f, 0.0f, 0.0f);
            this.pg.vertex(1.0f, 0.0f, 0.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(0.0f, 0.0f, 1.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.vertex(0.0f, 0.0f, 1.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(-1.0f, 0.0f, 0.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(-1.0f, 0.0f, 0.0f);
            this.pg.vertex(0.0f, 1.0f, 0.0f);
            this.pg.vertex(-1.0f, 1.0f, 1.0f);
            this.pg.vertex(1.0f, 1.0f, 1.0f);
            this.pg.vertex(0.0f, 1.0f, 0.0f);
            this.pg.vertex(-1.0f, 1.0f, -1.0f);
            this.pg.vertex(1.0f, 1.0f, -1.0f);
            this.pg.vertex(0.0f, -1.0f, 0.0f);
            this.pg.vertex(-1.0f, -1.0f, 1.0f);
            this.pg.vertex(-1.0f, -1.0f, -1.0f);
            this.pg.vertex(0.0f, -1.0f, 0.0f);
            this.pg.vertex(1.0f, -1.0f, -1.0f);
            this.pg.vertex(1.0f, -1.0f, 1.0f);
            this.pg.endShape();
        }
    }
}

