using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

/*  
    v.01
    Michael Auerswald <michael@908video.de>

    Value to String using ToString() and Standard Numeric Format Strings
    See: https://msdn.microsoft.com/en-us/library/dwhawy9k(v=vs.110).aspx
*/

namespace Framefield.Core.IDe99b6118_240b_4b51_baf1_dac6149e9c5f
{

    public class Class_ValueToString : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Format = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Format = inputs[(int)InputId.Format].Eval(context).Text;
            //<<< _params            
            
            string s=Value.ToString(Format);
            context.Text=s;
            return context;
        }
    }
}

