using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID1fa6aa8d_59da_4ecc_b9d3_9c428f3c6e53
{
    public class Class_Sub : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            TextValue1 = 0,
            TextValue2 = 1
        }
        //<<< _inputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>>_params
            var TextValue1 = inputs[(int)InputId.TextValue1].Eval(context).Text;
            var TextValue2 = inputs[(int)InputId.TextValue2].Eval(context).Text;
            //<<<_params
            
            double v1=0;
            double v2=0;
            
            try {
                v1= Double.Parse(TextValue1);
                v2= Double.Parse(TextValue2);
            }
            catch(FormatException) {
                Logger.Warn(this,"Invalid Number formats: '{0}', '{1}'", TextValue1, TextValue2);
            }
            
            context.Text = String.Format("{0}", v1 - v2);
            return context;
        }
    }
}

