//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core;

namespace Framefield.Core.IDfc29b4a9_edf4_4417_a480_6760af8a5770
{
    public class Class_StopWatch2 : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            StartTrigger = 0,
            ResetTrigger = 1
        }
        //<<< _inputids        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var StartTrigger = inputs[(int)InputId.StartTrigger].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            //<<< _params
            
            if (_lastTime == float.NaN)
            {
                _lastTime = context.Time;
            }
            if (_lastTime != context.Time)
            {
                _duration += context.Time - _lastTime;
                _lastTime = context.Time;
                Changed = false;
            }
            
            bool resetTriggerUp = _oldResetTrigger < 0.5f && ResetTrigger > 0.5f;

            if(resetTriggerUp) 
                _running = false;
                
            _oldResetTrigger = ResetTrigger;
                
            
            bool startTriggerUp = _oldStartTrigger < 0.5f && StartTrigger > 0.5f;
            bool startTriggerDown = _oldStartTrigger > 0.5f && StartTrigger < 0.5f;
            _oldStartTrigger = StartTrigger;
            if (startTriggerUp)
            {                
                _startTime = context.Time;
                _running = true;
            }
            
            if(_running) {
    
                context.Value = context.Time - _startTime;
            }
            else {
                context.Value = 0;
            }

            return context;
        }

        bool _running = false;
        float _startTime=0;
        float _oldStartTrigger;
        float _oldResetTrigger;
        float _lastTime = 0;
        float _duration = 0;
    }
}


