//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Collections;
using OSC;

namespace Framefield.Core.ID1913dbfc_3a00_4798_a6e2_91d6a5feee94
{
    public class Class_OSCMessageFloat : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            OSCPath = 0,
            FrameMessages = 1
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            if (Changed)
            {
                //>>> _params
                var OSCPath = inputs[(int)InputId.OSCPath].Eval(context).Text;
                var FrameMessages = inputs[(int)InputId.FrameMessages].Eval(context).Dynamic;  // Needs to be checked for null!
                //<<< _params
                
                if (FrameMessages != null)
                {
                    var dict = (IDictionary<string, OSCMessage>)FrameMessages;
                    OSCMessage msg;
                    
                    if (dict.TryGetValue(OSCPath, out msg))
                    {
                        if (msg.Values.Count != 1)
                        {
                            Logger.Error(this, "Expected 1 param, got " + msg.Values.Count);
                            return context;
                        }
                        
                        var val = msg.Values[0];
                        float v0 = 0;
                        
                        try
                        {
                            v0 = Convert.ToSingle(val);
                        }
                        catch (FormatException)
                        {
                           Logger.Error(this, "The {0} value {1} is not recognized as a valid Single value.",
                                             val.GetType().Name, val);
                        }                     
                        catch (OverflowException)
                        {
                           Logger.Error(this, "The {0} value {1} is outside the range of the Single type.",
                                             val.GetType().Name, val);
                        }
                        catch (InvalidCastException)
                        {
                           Logger.Error(this, "Conversion of the {0} value {1} to a Single is not supported.",
                                             val.GetType().Name, val);
                        }    

                        _lastValue = v0;
                    }
                }
            
                Changed = false;
            }

            context.Value = _lastValue;
            return context;
        }
		
		private string _path;
		private float _lastValue; 
    }
}

