using System;
using System.Collections.Generic;
using SharpDX;
using SharpDX.Direct3D11;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.IDd9201da9_669b_4ab5_9a79_25efbb6a1929
{
    public class Class_MeshToScene : OperatorPart.Function,
                                     Framefield.Core.OperatorPartTraits.IMeshSupplier
    {
        // IMeshSupplier
        public void AddMeshesTo(ICollection<Mesh> meshes)
        {
            UpdateMesh(new OperatorPartContext(), OperatorPart.Connections);
            meshes.Add(_mesh);
            if (_mesh != null)
                Logger.Info("added mesh with: {0} triangles", _mesh.NumTriangles);
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _mesh);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            UpdateMesh(context, inputs);

            return context;
        }

        private void UpdateMesh(OperatorPartContext context, IList<OperatorPart> inputs)
        {
        Logger.Info("mesh != null: {0}", _mesh != null);
            if (_mesh != null && !Changed)
                return;

            _mesh = inputs[0].Eval(context).Mesh;

            Changed = false;
        }

        private Mesh _mesh;
    }
}