//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDee484f5f_0eab_4fb4_b83b_a495e5326d76
{
    public class Class_KeyColor : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            Threshold = 6,
            EdgeColorR = 7,
            EdgeColorG = 8,
            EdgeColorB = 9,
            EdgeColorA = 10,
            Amplify = 11,
            Radius = 12,
            FillColorR = 13,
            FillColorG = 14,
            FillColorB = 15,
            FillColorA = 16,
            FillRestR = 17,
            FillRestG = 18,
            FillRestB = 19,
            FillRestA = 20
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; // Needs to be checked for null!
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var Threshold = inputs[(int)InputId.Threshold].Eval(context).Value;
            var EdgeColorR = inputs[(int)InputId.EdgeColorR].Eval(context).Value;
            var EdgeColorG = inputs[(int)InputId.EdgeColorG].Eval(context).Value;
            var EdgeColorB = inputs[(int)InputId.EdgeColorB].Eval(context).Value;
            var EdgeColorA = inputs[(int)InputId.EdgeColorA].Eval(context).Value;
            var EdgeColor = new Color4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA);
            var Amplify = inputs[(int)InputId.Amplify].Eval(context).Value;
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var FillColorR = inputs[(int)InputId.FillColorR].Eval(context).Value;
            var FillColorG = inputs[(int)InputId.FillColorG].Eval(context).Value;
            var FillColorB = inputs[(int)InputId.FillColorB].Eval(context).Value;
            var FillColorA = inputs[(int)InputId.FillColorA].Eval(context).Value;
            var FillColor = new Color4(FillColorR, FillColorG, FillColorB, FillColorA);
            var FillRestR = inputs[(int)InputId.FillRestR].Eval(context).Value;
            var FillRestG = inputs[(int)InputId.FillRestG].Eval(context).Value;
            var FillRestB = inputs[(int)InputId.FillRestB].Eval(context).Value;
            var FillRestA = inputs[(int)InputId.FillRestA].Eval(context).Value;
            var FillRest = new Color4(FillRestR, FillRestG, FillRestB, FillRestA);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB, ColorA));
                    _effect.GetVariableByName("Threshold").AsScalar().Set(Threshold);
                    _effect.GetVariableByName("EdgeColor").AsVector().Set(new Vector4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA));
                    _effect.GetVariableByName("Amplify").AsScalar().Set(Amplify);
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("FillColor").AsVector().Set(new Vector4(FillColorR, FillColorG, FillColorB, FillColorA));
                    _effect.GetVariableByName("FillRest").AsVector().Set(new Vector4(FillRestR, FillRestG, FillRestB, FillRestA));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

