//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.IDc7b7d191_2cdf_47aa_9795_f84931103cec
{
    public class Class_FileExists : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            ImagePath = 0
        }
        //<<< _inputids

        //>>> _outputids
        private enum OutputId
        {
            Exists = 0
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var ImagePath = inputs[(int)InputId.ImagePath].Eval(context).Text;
            //<<< _params

            if (ImagePath == _lastImage)
                Changed = false;

            _lastImage = ImagePath;

            if (Changed)
            {
                _exists = File.Exists(ImagePath);
                Changed = false;
            }

            context.Value = _exists ? 1.0f : 0.0f;

            return context;
        }

        bool _exists;
        String _lastImage = String.Empty;
    }
}

