//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDbf26f3a7_2f3d_4863_8944_ac6d08b35c5c
{
    public class Class_DamperAngle : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Friction = 1
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Friction = inputs[(int)InputId.Friction].Eval(context).Value;
            //<<< _params
            
            Value %= 360;

            if (context.GlobalTime < _dampedTime)
                _damped = Value;
                        
            if( Double.IsNaN(_damped))
                _damped = Value;
                
            // Fix roll-over
            if( Math.Abs( Value - _damped) > 180) {
                _damped += Value > _damped? 360 : - 360;
            }

            _damped = Friction*_damped + (1 - Friction)*Value;
            
            _dampedTime = context.GlobalTime;
            context.Value = _damped;
            return context;
        }
        
        float _damped;
        float _dampedTime = 999999;
    }
}

