using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID005a693c_373b_4665_a1bd_27982a344598
{
    public class Class_Cos : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            angle = 0,
            period = 1,
            amplitute = 2,
            offset = 3,
            phase = 4
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var angle = inputs[(int)InputId.angle].Eval(context).Value;
            var period = inputs[(int)InputId.period].Eval(context).Value;
            var amplitute = inputs[(int)InputId.amplitute].Eval(context).Value;
            var offset = inputs[(int)InputId.offset].Eval(context).Value;
            var phase = inputs[(int)InputId.phase].Eval(context).Value;
            //<<< _params
            
            context.Value = (float) (Math.Cos((angle + phase) / period *Math.PI) * amplitute + offset );
            
            return context;
        }
    }
}

