package util;

import java.util.Arrays;

import game.Map.ObstacleType;

public class Util {

	public static ObstacleType[][] deepCopy(ObstacleType[][] original) {
	    if (original == null) {
	        return null;
	    }
	    final ObstacleType[][] result = new ObstacleType[original.length][];
	    for (int i = 0; i < original.length; i++) {
	        result[i] = Arrays.copyOf(original[i], original[i].length);
	    }
	    return result;
	}

	public static long pascalTriangle(int r, int k) {
	    if(r == 1 || k <= 1 || k >= r) return 1L;
	    return pascalTriangle(r-1, k-1) + pascalTriangle(r-1, k);
	}
	
}
