package net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import bot.BotManager;
import debug.Log;

public class NetworkManager extends Thread {

	private static NetworkManager instance = null;
	
	private Socket socket;
	
	private DataInputStream input;
	private DataOutputStream output;
	
	private String logTag = "NetworkHandler";
	
	protected NetworkManager() {
		
	}
	
	public void Initialize(String url, int port) {
		Log.writeLine(logTag, "Connecting to " + url + ".");
		try {
			this.socket = new Socket(url, port);
			
			this.input = new DataInputStream(socket.getInputStream());
			this.output = new DataOutputStream(socket.getOutputStream());
			
			this.start();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void run() {
		sendName();
		
		long time = 0;
		while (true) {
			try {
				if (input.available() <= 0) {
					if (5 - time > 0) {
						Thread.sleep(5 - time);
					}
					continue;
				}
				long t = System.currentTimeMillis();
				byte[] bytes = new byte[input.available()];
				input.readFully(bytes);
				String s = new String(bytes);
				parseJson(s);
				time = System.currentTimeMillis() - t;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private void parseJson(String s) {
		JSONParser parser = new JSONParser();
		
		try {
			JSONObject json = (JSONObject) parser.parse(s);
			
			String messageType = (String) json.get("messagetype");
			
			switch (messageType) {
				case "welcome":
					Log.writeLine(logTag, "Got welcome message!");
					
					JSONObject position = (JSONObject) json.get("you");
					JSONArray opponents = (JSONArray) json.get("others");
					JSONObject map = (JSONObject) json.get("map");
					
					BotManager.getInstance().bot.map.update(map);
					BotManager.getInstance().bot.map.updateOpponents(opponents);
					BotManager.getInstance().bot.update(position);
					break;
					
				case "stateupdate":
					Log.writeLine(logTag, "Updating state!");
					
					JSONObject gamestate = (JSONObject) json.get("gamestate");
					position = (JSONObject) gamestate.get("you");
					opponents = (JSONArray) gamestate.get("others");
					map = (JSONObject) gamestate.get("map");

					BotManager.getInstance().bot.map.update(map);
					BotManager.getInstance().bot.map.updateOpponents(opponents);
					BotManager.getInstance().bot.update(position);
					break;
			
				case "dead":
					Log.writeLine(logTag, "We are dead!");
					break;
					
				case "endofround":
					Log.writeLine(logTag, "Round has ended!");
					break;
					
				case "startofround":
					Log.writeLine(logTag, "Round is starting!");
					break;
					
				default:
					Log.writeLine(logTag, "Unknown messageType: " + messageType);
					break;
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}
	
	private void sendName() {
		send("NAME HejPetri");
	}
	
	public void send(String s) {
		try {
			output.writeBytes(s + "\n");
			output.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static NetworkManager getInstance() {
		if(instance == null) {
			instance = new NetworkManager();
		}
		return instance;
	}
}
