/*
 * Decompiled with CFR 0.152.
 */
package net;

import bot.BotManager;
import debug.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NetworkManager
extends Thread {
    private static NetworkManager instance = null;
    private Socket socket;
    private DataInputStream input;
    private DataOutputStream output;
    private String logTag = "NetworkHandler";

    protected NetworkManager() {
    }

    public void Initialize(String url, int port) {
        Log.writeLine(this.logTag, "Connecting to " + url + ".");
        try {
            this.socket = new Socket(url, port);
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.sendName();
        long time = 0L;
        while (true) {
            try {
                while (true) {
                    if (this.input.available() <= 0) {
                        if (5L - time <= 0L) continue;
                        Thread.sleep(5L - time);
                        continue;
                    }
                    long t = System.currentTimeMillis();
                    byte[] bytes = new byte[this.input.available()];
                    this.input.readFully(bytes);
                    String s = new String(bytes);
                    this.parseJson(s);
                    time = System.currentTimeMillis() - t;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void parseJson(String s) {
        JSONParser parser = new JSONParser();
        try {
            String messageType;
            JSONObject json = (JSONObject)parser.parse(s);
            switch (messageType = (String)json.get("messagetype")) {
                case "welcome": {
                    Log.writeLine(this.logTag, "Got welcome message!");
                    JSONObject position = (JSONObject)json.get("you");
                    JSONArray opponents = (JSONArray)json.get("others");
                    JSONObject map = (JSONObject)json.get("map");
                    BotManager.getInstance().bot.map.update(map);
                    BotManager.getInstance().bot.map.updateOpponents(opponents);
                    BotManager.getInstance().bot.update(position);
                    break;
                }
                case "stateupdate": {
                    Log.writeLine(this.logTag, "Updating state!");
                    JSONObject gamestate = (JSONObject)json.get("gamestate");
                    JSONObject position = (JSONObject)gamestate.get("you");
                    JSONArray opponents = (JSONArray)gamestate.get("others");
                    JSONObject map = (JSONObject)gamestate.get("map");
                    BotManager.getInstance().bot.map.update(map);
                    BotManager.getInstance().bot.map.updateOpponents(opponents);
                    BotManager.getInstance().bot.update(position);
                    break;
                }
                case "dead": {
                    Log.writeLine(this.logTag, "We are dead!");
                    break;
                }
                case "endofround": {
                    Log.writeLine(this.logTag, "Round has ended!");
                    break;
                }
                case "startofround": {
                    Log.writeLine(this.logTag, "Round is starting!");
                    break;
                }
                default: {
                    Log.writeLine(this.logTag, "Unknown messageType: " + messageType);
                    break;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void sendName() {
        this.send("NAME HejPetri");
    }

    public void send(String s) {
        try {
            this.output.writeBytes(String.valueOf(s) + "\n");
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NetworkManager getInstance() {
        if (instance == null) {
            instance = new NetworkManager();
        }
        return instance;
    }
}

