using System.Linq;

namespace GhostlyAi
{
    public class Tile : IPathNode<Gamestate>
    {
        public int X { get; set; }
        public int Y { get; set; }
        public TileType TileType { get; set; }
        public double G { get; set; }
        public double H { get; set; }
        public double F { get; set; }
        public double Points { get; set; }

        public bool IsWalkable(Gamestate gamestate)
        {
            if (gamestate.You.Isdangerous)
            {
                var player = gamestate.Others.FirstOrDefault(p => p.X == X && p.Y == Y);

                if (player != null)
                {
                    if (player.Isdangerous == false)
                        return true;
                }
            }


            //M i s fall ha en fix som gjr at jeg ikke flger etter motstander
//            if (TileType == TileType.Player && gamestate.Map.Pelletsleft < 25)
//            {
//                var player = gamestate.Others.FirstOrDefault(p => p.X == X && p.Y == Y);
//
//                if (player != null)
//                {
//                    if (player.Isdangerous == gamestate.You.Isdangerous)
//                        return true;
//                }
//            }

            return TileType == TileType.Door || TileType == TileType.Floor || TileType == TileType.Pellet || TileType == TileType.SuperPellet;
        }
    }
}