#version 100
precision mediump float;

attribute vec3 vpos;	//could use 'location()' in GL4 to set which attrib each var is
attribute vec4 vcol;	//else it's defined at shader-compile time
attribute vec3 vnrm;
attribute vec2 vUV;

varying vec4 col;
varying vec3 nrm;
varying vec2 uv;

uniform mat4 matM,matP,matN;//model,proj,normals
uniform float wiggle;
uniform float wiggleAmt;
uniform float wiggleFrq;


void main()
{
	col = vcol;
	vec3 pos = vpos*3.0;	//hardcoded adjustment
	pos += (sin(pos.x*wiggleFrq + wiggle) + sin(pos.y*wiggleFrq *1.0 + wiggle*1.0) + sin(pos.z*wiggleFrq*1.2 + wiggle*1.2))*vnrm*wiggleAmt;
	gl_Position = matP* matM* vec4(pos,1.0);

	nrm = (matN* vec4(vnrm,1.0)).xyz;
	uv = vUV;
}