attribute vec4 pos;
attribute vec2 tex; 
varying vec2 tc;
varying vec4 color; 
varying float unique;  
varying float uniqueCycle;  

uniform vec3 eyePos; 
uniform mat4 viewproj; 
uniform mat4 view; 
uniform mat4 tview;
uniform mat4 world; 
 
uniform float time; 
uniform int flip=0; 
uniform float inverse;

float rand( vec2 n ) {
   return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{	
	/* Random Values */
	unique = rand(pos.w);
	float su = 10.*time*unique; 
	uniqueCycle = su-frac(su);

	/* Calculate Billboard */
	//vec2 ttex = tex.xy;
	//ttex.xy=1.0-tex.xy*inverse;
	vec4 center = vec4((tex.xy+1.0)/2.0, 0.0, 1.0); 
	
	//vec4 center = vec4((pos.xy-.50)*2.0, 0.0, 1.0); 
	
	vec4 bboard = 3.0*(unique*3.0+2.0)*world*(center.x*tview[0]+center.y*tview[1]);
	//vec4 center = vec4((pos.xy-.50)*2.0, 0.0, 1.0); 
	//vec4 bboard = 50.0*(center.x*tview[0]+center.y*tview[1]);


	/* Create height deformation */
	float y = 0.0;
	y += 4.0*sin(length(pos.xz+100.0*vec2(sin(time*.2), cos(time*.3)))*.1+time);
	y += 4.0*sin((pos.x+pos.z)*.05+time*2.0);
	y += 4.0*cos((pos.x-pos.z)*.05+time*1.5);
	y += 1.0*cos((pos.x)*.125+time*1.0);
	y += 1.0*cos((pos.z)*.125+time*1.0);
	y += 3.0 * unique;

	y = 100.0;
	y = pos.y-1.5;
	//x -= 3.5;
	//y = 0.0;

	/* Apply height */
	vec4 genPos = vec4(pos.x-10.0, y-5.0, pos.z+12.0, 1.0);

	vec4 newPos = (bboard+genPos);
	vec4 viewPos = view*vec4(genPos.xyz, 1.0);
	gl_Position = viewproj*world*vec4(newPos.xyz, 1.0);
	
	/* propagate tc */
	float random = 2.0*abs(rand(pos.z+uniqueCycle));//+.3*sin(time*.01+unique));
	float n = random-frac(random);
	tc = tex;//*world[0][1];
	tc.y = 1.0-tc.y; 
	tc = tc*vec2(1.0, .5)+vec2(0.0, .5)*n; 


	/* depth */
//	color.r = pow(color, vec4(2.0));
//	/color.b = max(.2, pow(rand(pos.w)*3.0, 2.0));

	color = vec4(gl_Position.z/gl_Position.w);
	//color = length(viewPos.xyz)/1000.0;
	color = max(0.0, 1.0-length(genPos.xyz-eyePos)/3500.0);
	color.r = pow(color, vec4(2.0));
	color.g = max(0.0, 1.0-length(genPos.xyz-eyePos)/400.0);
	color.b = max(.2, pow(rand(pos.w)*3.0, 2.0));

	//color = .5;
	//tc = (pos.xy);
	//color = vec4(.5+.5*sin(pos.z+.2),.5+.5*sin(pos.z*.1+.3),.5+.5*sin(pos.z*.2),1.0); 
	//color = (1.0+pos.y*2.0)*vec4(1.95+.15*sin(22030.0*pos.x+2433.2),1.5+.25*sin(2300.0*pos.x+.200),1.15+.5*sin(1228.0*pos.x+23.2),1);
}	

//FRAGMENT
uniform sampler2D Texture0; 

uniform float binaryValue; 

void main()
{  
	float d = length(tc.xy-.5);  // [0-.7071]
	d = (sqrt(.5)-d)/sqrt(.5);   // [1.0-0]
	
	/* Compute Hard Shape */
	gl_FragColor = color.b*min(1.0, max(0.0, d-.85)*10.0);
	//gl_FragColor = color;

	/* Compute Shadow */
	gl_FragColor += .70*vec4(max(0.0, d*d));

	gl_FragColor *= color.r;//pow(color.r/400.0, 2.0);

	//gl_FragColor = color.r/500.0;

	//gl_FragColor = getCoC(color.r);//1000.0;//*color.r;
	gl_FragColor = 1.0-texture2D(Texture0, tc);
	//gl_FragColor *= unique;
	gl_FragColor *= .5+1.0*sin(uniqueCycle);
	gl_FragColor *= color.r;//pow(color.r/400.0, 2.0);

	//gl_FragColor.rgb = 1.0;
	gl_FragColor.rgb *= 1.0;
	gl_FragColor.rgb *= vec3(1.5, 2.0, 1.8);
	gl_FragColor.a = 1.0;//color.g;//1.0;// color;// d;// 1.0;

	gl_FragColor.a = binaryValue; 
	gl_FragColor.rgb *= binaryValue*.550;

}

