varying vec2 tc; 
attribute vec4 pos; 

void main()
{   
    gl_Position = vec4(pos.xy, 0.0, 1.0);
    tc = (pos.xy+1.0)/2.0;
   // tc.y = 1.0-tc.y;
}   

//FRAGMENT
uniform float time; 
uniform float ratio; 
uniform sampler2D Texture0; 
uniform sampler2D Texture1; 
uniform float fade; 
uniform float white; 
float rand( vec2 n ) {
   return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

vec4 getSaturation(vec4 pixel, float Saturation)
{
   float saturation = Saturation; 
   
   pixel.rgb = mix(pixel.rgb, vec3(length(pixel.rgb)), saturation); 
   return pixel; 
}

vec4 getContrast(vec4 pixel, float Contrast)
{
   float contrast = Contrast;
   pixel.rgb *= contrast;  
   return pixel; 
}


float A = 0.15;
float B = 0.50;
float C = 0.10;
float D = 0.20; 
float E = 0.02;
float F = 0.30; 
float W = 18.2; 

float ExposureBias = 4.0; 

vec4 Uncharted2Tonemap(vec4 c) {
    vec3 x = vec3(c.xyz);
    return vec4( ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F, 1.0);
}

void main()
{
    vec2 uv = tc;
    vec4 blur = texture2D(Texture1, uv);
#if 0
    gl_FragColor = texture2D(Texture0, uv);
    return; 
    
    
    gl_FragColor = max(0.0, blur-1.0); 
    return;
#endif

   // gl_FragColor += blur; 
 //   return; 
    
    // distort 
    float stepSize = 0.0530; 
    float dist = pow(length(uv-.5)*.5, 2.0);  //1.5 == 2.0
    vec2 dir = normalize(uv-.5);

    float lodLevel = 0.0;
    
    vec4 p = texture2D(Texture0, uv, lodLevel);
    p.r += texture2D( Texture0, uv-dir*dist*stepSize, lodLevel ).r;
    p.g += texture2D( Texture0, uv-dir*dist*stepSize*2.0, lodLevel ).g;
    p.b += texture2D( Texture0, uv-dir*dist*stepSize*3.0 , lodLevel).b;
    p.rg += texture2D( Texture0, uv-dir*dist*stepSize*1.5 , lodLevel).rg;
    p.gb += texture2D( Texture0, uv-dir*dist*stepSize*2.5 , lodLevel).gb;
    p.rgb /= vec3(3,4,3);

    p += 1.*pow(max(vec4(0.0), blur-vec4(1.0)), vec4(1.00));
  //  p*=.5;
    //gl_FragColor = p;
   // gl_FragColor = blur;
    
    //gl_FragColor = Uncharted2Tonemap(gl_FragColor*ExposureBias);

    p = clamp(p, 0, W);
    vec4 toned = Uncharted2Tonemap(p*ExposureBias);
    vec4 white_scale = Uncharted2Tonemap( W- vec4(p) );
    vec4 color = toned/white_scale; 
    gl_FragColor = color;
   // gl_FragColor = blur;
    //gl_FragColor =  white_scale/2.0;

#if 1 // Vignetting  
    float v = 1.0-length(uv-.5); 
    float vv = 1.0*pow(v*.95+.05*rand(uv+time), 1.15);
    gl_FragColor *= sqrt(.5+.5*vec4(vv));                                // vignetting
    //gl_FragColor *= fade;                                    //fade to black
    //gl_FragColor = sqrt(gl_FragColor);                          // gamma correction
    //gl_FragColor.a = 1.0;
 #endif 

    gl_FragColor = clamp(gl_FragColor+vec4(white), vec4(0.0), vec4(1.0));
    //gl_FragColor = getContrast(gl_FragColor, length(p.rgb)*.3);
    //gl_FragColor = getContrast(gl_FragColor, blur.r*.125+1.5*p.r+.50);
   // vec4 white_scale = Uncharted2Tonemap( W- vec4(c*4.2) );


 // gl_FragColor = texture2D(Texture0, uv, 0.5);
    //gl_FragColor = vec4(1.0, 0,0,0);
}

