attribute vec4 pos;
attribute vec2 tex; 
varying vec2 tc;
varying vec4 color; 
varying float unique;  
varying float uniqueCycle;  

uniform vec3 eyePos; 
uniform mat4 viewproj; 
uniform mat4 view; 
uniform mat4 tview;
uniform mat4 world; 
 
uniform float time; 
uniform int flip=0; 
uniform float inverse;

float rand( vec2 n ) {
   return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{	
	/* Random Values */
	unique = rand(pos.w);
	float su = 10.*time*unique; 
	uniqueCycle = su-frac(su);

	/* Calculate Billboard */

	//ttex.x = 1.0-ttex.x*inverse;
	vec4 center = vec4((tex.xy+1.0)/2.0-0.5, 0.0, 1.0); 
	//vec4 center = vec4((pos.xy-.50)*2.0, 0.0, 1.0); 
	
	vec4 bboard = 10.0*world*(center.x*tview[0]+center.y*tview[1]);

	/* Apply height */
	vec4 genPos = vec4(pos.x-10.0, pos.y-5.0, pos.z+12.0, 1.0);
	genPos.xyz = pos.xyz;

	vec3 tubeCoords = genPos; 
	float tetha = -(genPos.x/2048 +.5)*3.141592*2.0;
	float a = 3217.0/6.5*.5;
	tubeCoords.x = a*sin(tetha);
	tubeCoords.y = a*cos(tetha);
	vec3 ln = normalize(vec3(sin(tetha), cos(tetha), 0.0f));
	tubeCoords = genPos.xyz;
	tubeCoords += ln*genPos.y;
				

	//genPos.xyz = tubeCoords.xyz;

	vec4 newPos = (bboard+genPos);
	vec4 viewPos = view*vec4(genPos.xyz, 1.0);
	gl_Position = viewproj*world*vec4(newPos.xyz, 1.0);
	
	/* propagate tc */
	float random = 2.0*abs(rand(pos.z+uniqueCycle));//+.3*sin(time*.01+unique));
	float n = random-frac(random);
	tc = tex;//*world[0][1];
	tc.y = 1.0-tc.y; 
	//tc = tc*vec2(1.0, .5)+vec2(0.0, .5)*n; 


	/* depth */

//	color = vec4(gl_Position.z/gl_Position.w);
	//color = length(viewPos.xyz)/1000.0;
//	color = max(0.0, 1.0-length(genPos.xyz-eyePos)/3500.0);
//	color.r = pow(color, 2.0);
//	color.g = max(0.0, 1.0-length(genPos.xyz-eyePos)/400.0);
//	color.b = max(.2, pow(rand(pos.w)*3.0, 2.0));

	color.a = pos.w; 
	//color = .5;
	//tc = (pos.xy);
	//color = vec4(.5+.5*sin(pos.z+.2),.5+.5*sin(pos.z*.1+.3),.5+.5*sin(pos.z*.2),1.0); 
	//color = (1.0+pos.y*2.0)*vec4(1.95+.15*sin(22030.0*pos.x+2433.2),1.5+.25*sin(2300.0*pos.x+.200),1.15+.5*sin(1228.0*pos.x+23.2),1);
}	

//FRAGMENT
uniform sampler2D Texture0; 

uniform float highValue; 
uniform float highThreshold; 
void main()
{  
	gl_FragColor = vec4(1,0,0,1);
	gl_FragColor = texture2D(Texture0, tc);
	gl_FragColor.rgb = 1.0*gl_FragColor.a*vec3(1.8, 1.2, 1.2);
	//gl_FragColor.rgb *= 2.0*pow(clamp(color.a/.012250, 0.0, 1.0), 1.751250);///200.0;
	//gl_FragColor.rgb *= 2.0*pow(clamp(color.a/.042250, 0.0, 1.0), 1.751250);///200.0;
	gl_FragColor.rgb *= 1.0*pow(clamp(color.a/(highThreshold*.1), 0.0, 1.0), 1.751250);///200.0;
	
	gl_FragColor.rgb *= highValue; 
	return; 
}

