//SamplerState sm:register(s1);
//Texture2D input:register(t0);

// cbuffer for ShaderScene
cbuffer c : register(b1)
{
	float4x4 matView; // view matrix, (world space -> camera space) (if camera avaiable)
	float4x4 matProj; // projection matrix, (camera space -> screen space)
	float4x4 matInvView; // inverse view matrix (camera space -> world space) (if camera avaiable)
	float4x4 matInvProj; // nverse projection matrix (screen space -> camera space);
	float4 worldCameraPosition; // position of camera (if camera avaiable)
	float4 screenResolution; // resolution is provided if needed
	float4 debugMouse; // mouse coordinates from -1 to +1 for debug purposes (disabled for live)
	float normalizedTime; // scene time from 0 to 1
	float param1; // scene parameter 1
	float param2; // scene parameter 2
	float param3; // scene parameter 3
	float totalTime; 
	float trackTime;
}

float glsl_mod(float x, float y) { return frac(x/y)*y; }
float2 glsl_mod(float2 x, float2 y) { return frac(x/y)*y; }
float3 glsl_mod(float3 x, float3 y) { return frac(x/y)*y; }
float4 glsl_mod(float4 x, float4 y) { return frac(x/y)*y; }


//distance function
float df(float3 p){
	p.y+=totalTime;
	float3 m = glsl_mod(p+2, 4.0)-2;
	float3 id = p - m;
	p = m;
	p += sin(totalTime+(id.yxz)*float3(0.17,71.13,173.13)+float3(.14,53.1,415.1));
	float sphere = length(p)-0.050;
	return sphere;
}

// normal function
float3 nf(float3 p){
	float2 e = float2(0,0.1);
	float c = df(p);
	return normalize(float3( df(p+e.yxx)-c, df(p+e.xyx)-c, df(p+e.xxy)-c ));
}

float4 main(in float4 vertexPosition : SV_Position, in float2 uv : TEXCOORD, out float depth : SV_DEPTH) : SV_TARGET0
{ 
	//float3 pos = float3(2+debugMouse.x,2+debugMouse.y,-10);
	float3 dir = normalize(float3(0.5-uv,2.0));
	dir.x *= screenResolution.x/screenResolution.y;
	float3 pos = worldCameraPosition.xyz;
	
	//float3 dir = mul(float4(uv-.5,2.0, 1.0),matInvView).xyz;
	float3x3 matViewRot;// = float3x3(matView);
	matViewRot[0][0] = matView[0][0];
	matViewRot[1][0] = matView[1][0];
	matViewRot[2][0] = matView[2][0];
	matViewRot[0][1] = matView[0][1];
	matViewRot[1][1] = matView[1][1];
	matViewRot[2][1] = matView[2][1];
	matViewRot[0][2] = matView[0][2];
	matViewRot[1][2] = matView[1][2];
	matViewRot[2][2] = matView[2][2];
	dir = mul(matViewRot, - dir.xyz);
	//float3 pos = (mul(float4(1,1,1,1),matInvView)).xyz;
	
	//dir = normalize(dir - pos);
	//
	
	float time = normalizedTime; 
	
	float3 original_pos = pos;
	
	int i;
	float t;
	for (i=0; i<64; i++)
	{
		t = df(pos);
		pos += dir*t;
		if (t<0.01){
			break;
		} 
	}
	
	float fi = float(i)/64.0;
	fi = 1.0-fi;
	
	float3 color;
	if (t<=0.01)
	{
		//object
		float3 n = nf(pos);
		float ao = df(pos+n);
		ao = ao*.75 + df(pos+n*.03)*.5;
		ao = ao*.75 + df(pos+n*.02)*.5;
		ao = ao*.75 + df(pos+n*.01)*.5;
		ao = ao*.5+.1;
		
		float3 light = normalize(float3(1-param2,-3,-3));
		
		float sh = 4.0;
		float eps = 0.5;
		for (int i=0; i<32; i++)
		{
			sh = min(sh, df(pos+light*eps)/eps);
			eps = eps*0.9;
		}
		color = (sh*.5+.5)*ao*2;
		color *= 20.0/distance(original_pos, pos);
		
		depth = distance(original_pos, pos)*0.01;
	}
	else 
	{
		//background
		color = 0;
		depth = 1.0; //infinte
		clip(-1);
		
	}
	
	return float4(color*0.5,1.0); // return color in linear space
}