var Rainbow = function() {
  this.rainbowObj = new THREE.Object3D();

  var ringGeom;
  var ringsystem;
  var size = 1.5;

  ringGeom = this.createRing(300,30,2000);
  this.red = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0xff0000, size : size}) );
  this.rainbowObj.add(this.red);

  ringGeom = this.createRing(275,30,2000);
  this.orange = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0xFF7F00, size : size}) );
  this.rainbowObj.add(this.orange);

  ringGeom = this.createRing(250,30,2000);
  this.yel = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0xffff00, size : size}) );
  this.rainbowObj.add(this.yel);

  ringGeom = this.createRing(230,30,2000);
  this.green = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0x00ff00, size : size}) );
  this.rainbowObj.add(this.green);

  ringGeom = this.createRing(210,20,2000);
  this.blue = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0x0000ff, size : size}) );
  this.rainbowObj.add(this.blue);

  ringGeom = this.createRing(195,20,2000);
  this.v1 = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0x4B0082, size : size}) );
  this.rainbowObj.add(this.v1);

  ringGeom = this.createRing(182,20,2000);
  this.v2 = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: 0x8B00FF, size : size}) );
  this.rainbowObj.add(this.v2);

  //this.rainbowObj.rotation.y = Math.PI;

  //return this.rainbowObj;
}

Rainbow.prototype.createRing = function(outer, inner, particleAmount){
  var geom = new THREE.Geometry();

  for(i=5; i<=particleAmount; i++) {

    var p = new THREE.Vector3();

    p.x = Math.sin(i) * outer + Math.random() * inner;
    p.y = Math.cos(i) * outer + Math.random() * inner;
    p.z = Math.sin(i) * outer + Math.random() * inner;

    geom.vertices.push( p );
  }

  //console.log(geom);
  return geom;
}
