#version 120

uniform sampler2D texture;
uniform float colorPercent = 0.0;

vec4 desaturate(vec4 tex, float colorPercent)
{
	float grey = (tex.r+tex.g+tex.b)/3*(1-colorPercent);
	vec4 color = vec4(tex.r*colorPercent+grey, tex.g*colorPercent+grey, tex.b*colorPercent+grey, gl_Color.a);
	return color;
}

void main()
{
	gl_FragColor = desaturate(texture2D(texture, gl_TexCoord[0].xy), colorPercent);
}
