uniform float time;
uniform vec2 resolution;

float width = resolution.x;
float height = resolution.y;
float centerX = width / 2.0;
float centerY = height / 2.0;
const int BALL_NUM = 80;

vec3 drawBall( int n, float size, float subOffset ) {
    float offset = float(n) * ( 3.14 * 2.0 / float(BALL_NUM) ) + subOffset;
    float x = width/2.0  * (1.0 + sin(1.2 * time + float(3*n+4*n)));
    float y = height/2.0  * (1.0 + cos(1.2 * time + float(3*n+4*n)));
    vec2 center = vec2( x, y );
    vec3 color = vec3( 1.0, 1.0, 1.0 );
    vec2 pos = gl_FragCoord.xy;
    float dist = length( pos - center );
    color = vec3( pow( size / dist * sin(time * sin(time/1000.0)), 2.0 ) );
    return color;
}

void main( void ) {    
    vec3 color;
    for( int i = 0; i < BALL_NUM; ++i ) {
        color += drawBall( i, 5.0, 0.0 );
    }
    
    gl_FragColor = vec4( color, 1.0 );

}


