void drawText(float left, float top, float ripple, PImage img) {
  pushMatrix();
  //camera(W/2, H/2, (H/2) / tan(PI/6), W/2, H/2, 0, 0, 1, 0);
  camera(480, 270, 490, 480, 270, 0, 0, 1, 0);
  hint(DISABLE_DEPTH_TEST);
  
  beginShape(TRIANGLE_STRIP);
  textureMode(IMAGE);
  texture(img);
  noStroke();
  float block_w = img.width/20;
  for (float x = 0; x < img.width; x += block_w) {
    addStripVertices(left, top, img.height, x, ripple);
  }
  addStripVertices(left, top, img.height, img.width, ripple);
  endShape();
  
  hint(ENABLE_DEPTH_TEST);
  popMatrix();
}
void addStripVertices(float left, float top, float height, float x, float ripple) {
  float y = ripple*sin((left+x) / 20.f);
  vertex(left+x, top+y+height, 0, x, height);
  vertex(left+x, top+y, 0, x, 0);
}

void drawText2(float left, float top, float ripple, PImage img) {
  pushMatrix();
  camera(W/2, H/2, (H/2) / tan(PI/6), W/2, H/2, 0, 0, 1, 0);
  hint(DISABLE_DEPTH_TEST);
  
  beginShape(QUADS);
  textureMode(IMAGE);
  texture(img);
  noStroke();
  float block_w = 10;
  for (float x = 0; x < img.width; x += block_w) {
    float bottom = top + img.height;
    float y = ripple*sin((left+x) / 20.f);
    vertex(left+x, top+y, 1,            x, 0);
    vertex(left+x+block_w, top+y, 1,    x+block_w, 0);
    vertex(left+x+block_w, bottom+y, 1, x+block_w, img.height);
    vertex(left+x, bottom+y, 1,         x, img.height);
  }
  endShape();
  
  hint(ENABLE_DEPTH_TEST);
  popMatrix();
}