final color cubes_color_blue1 = color(25, 52, 65);
final color cubes_color_blue2 = color(252, 255, 245);

void drawCubeScene3(final float time, float beats) {
    // Simple version of the scene with single cube cluster slowly growing

    background(32);

    translate(width / 2, height / 2, 0);

    noStroke();

    pushMatrix();

    // looks nicer with some offset to the beat
    beats = beats + 0.3;

    // scale the cubes to the beat
    float cube_bounce =
        0.0625*(beats%(8*8));// * sin(6 * beats * PI);

    scale(0.5 + cube_bounce);

    cubes_DrawCubeCluster(time, beats);

    popMatrix();

}

void drawCubeScene4(final float time, float beats) {
    // Simple version of the scene from inside cube cluster

    background(32);

    translate(width / 2, height / 2, 0);

    noStroke();

    pushMatrix();

    // looks nicer with some offset to the beat
    beats = beats + 0.3;

    // scale the cubes to the beat
    float cube_bounce =
        abs(cos((beats % 1) * PI));// * sin(6 * beats * PI);

    scale(10 + cube_bounce);

    cubes_DrawCubeCluster(time, beats);

    popMatrix();

}

void drawCubeScene(final float time, float beats) {
    // Simple version of the scene with single cube cluster

    background(32);

    translate(width / 2, height / 2, 0);

    noStroke();

    pushMatrix();

    // looks nicer with some offset to the beat
    beats = beats + 0.3;

    // scale the cubes to the beat
    float cube_bounce =
        abs(cos((beats % 1) * PI));// * sin(6 * beats * PI);

    scale(1.0 + cube_bounce);

    cubes_DrawCubeCluster(time, beats);

    popMatrix();

}

void drawCubeScene2(final float time, float beats) {
    // Alternate version of the scene with multiple cube clusters

    background(0);

    noStroke();

    // center to viewport
    translate(width / 2, height / 2, 0);

    // looks nicer with some offset to the beat
    beats = beats + 0.3;

    float camera_away_movement = sin(time) * 10.0;

    // Adjust camera
    translate(0.0, 20.0, 0.0); // up a bit
    translate(0.0, 0.0, 30.0 + camera_away_movement); // away
    rotateX(-0.6); // rotate downwards
    rotateY(time); // rotate around objects

    // floor
    pushMatrix();
        translate(0, 1.5 * height, 0);
        rectMode(CENTER);
        rotateX(0.5 * PI);
        //rect(0, 0, 6.0 * height, 6.0 * height);
        translate(-3.0 * height, -3.0 * height); // center the floor
        image(floor_texture, 0, 0, 6.0 * height, 6.0 * height);
    popMatrix();

    // three cubes

    for (int i = 0; i < 3; i++) {
        pushMatrix();

        rotateY(i * (TWO_PI / 3.0));

        translate(0.0, 0.0,
            (float)moonlander.getValue("translateZ") * 100.0);

        cubes_DrawCubeCluster(time, beats);

        popMatrix();
    }

}

void cubes_DrawCubeCluster(final float time, final float beats) {
    for (int i = 0; i < 10; i++) {
        pushMatrix();

        lights();

        cubes_DrawCube(time, beats, i);

        popMatrix();
    }
}

void cubes_DrawCube(float time, float beats, final int index) {
    color fill_color = lerpColor(
        cubes_color_blue1, cubes_color_blue2, index / 10.0);

    fill(fill_color);

    time = time + 0.1 * index;

    rotateY(time);
    rotateX(time * 1.3);
    rotateZ(time * 1.9);

    box(height * 0.4);
}