/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Minim;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;

public class Controller {
    @Deprecated
    public static FloatControl.Type VOLUME = FloatControl.Type.VOLUME;
    @Deprecated
    public static FloatControl.Type GAIN = FloatControl.Type.MASTER_GAIN;
    @Deprecated
    public static FloatControl.Type BALANCE = FloatControl.Type.BALANCE;
    @Deprecated
    public static FloatControl.Type PAN = FloatControl.Type.PAN;
    @Deprecated
    public static FloatControl.Type SAMPLE_RATE = FloatControl.Type.SAMPLE_RATE;
    @Deprecated
    public static BooleanControl.Type MUTE = BooleanControl.Type.MUTE;
    private Control[] controls;
    private ValueShifter vshifter;
    private ValueShifter gshifter;
    private ValueShifter bshifter;
    private ValueShifter pshifter;
    private boolean vshift;
    private boolean gshift;
    private boolean bshift;
    private boolean pshift;

    public Controller(Control[] cntrls) {
        this.controls = cntrls;
        this.pshift = false;
        this.bshift = false;
        this.gshift = false;
        this.vshift = false;
    }

    void update() {
        if (this.vshift) {
            this.setVolume(this.vshifter.value());
            if (this.vshifter.done()) {
                this.vshift = false;
            }
        }
        if (this.gshift) {
            this.setGain(this.gshifter.value());
            if (this.gshifter.done()) {
                this.gshift = false;
            }
        }
        if (this.bshift) {
            this.setBalance(this.bshifter.value());
            if (this.bshifter.done()) {
                this.bshift = false;
            }
        }
        if (this.pshift) {
            this.setPan(this.pshifter.value());
            if (this.pshifter.done()) {
                this.pshift = false;
            }
        }
    }

    public void printControls() {
        if (this.controls.length > 0) {
            System.out.println("Available controls are:");
            for (int i = 0; i < this.controls.length; ++i) {
                Control.Type type = this.controls[i].getType();
                System.out.print("  " + type.toString());
                if (type == VOLUME || type == GAIN || type == BALANCE || type == PAN) {
                    FloatControl fc = (FloatControl)this.controls[i];
                    String shiftSupported = "does";
                    if (fc.getUpdatePeriod() == -1) {
                        shiftSupported = "doesn't";
                    }
                    System.out.println(", which has a range of " + fc.getMaximum() + " to " + fc.getMinimum() + " and " + shiftSupported + " support shifting.");
                    continue;
                }
                System.out.println("");
            }
        } else {
            System.out.println("There are no controls available.");
        }
    }

    @Deprecated
    public boolean hasControl(Control.Type type) {
        for (int i = 0; i < this.controls.length; ++i) {
            if (!this.controls[i].getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Control[] getControls() {
        return this.controls;
    }

    @Deprecated
    public Control getControl(Control.Type type) {
        for (int i = 0; i < this.controls.length; ++i) {
            if (!this.controls[i].getType().equals(type)) continue;
            return this.controls[i];
        }
        return null;
    }

    @Deprecated
    public FloatControl volume() {
        return (FloatControl)this.getControl(VOLUME);
    }

    @Deprecated
    public FloatControl gain() {
        return (FloatControl)this.getControl(GAIN);
    }

    @Deprecated
    public FloatControl balance() {
        return (FloatControl)this.getControl(BALANCE);
    }

    @Deprecated
    public FloatControl pan() {
        return (FloatControl)this.getControl(PAN);
    }

    public void mute() {
        this.setValue(MUTE, true);
    }

    public void unmute() {
        this.setValue(MUTE, false);
    }

    public boolean isMuted() {
        return this.getValue(MUTE);
    }

    private boolean getValue(BooleanControl.Type type) {
        boolean v = false;
        if (this.hasControl(type)) {
            BooleanControl c = (BooleanControl)this.getControl(type);
            v = c.getValue();
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
        return v;
    }

    private void setValue(BooleanControl.Type type, boolean v) {
        if (this.hasControl(type)) {
            BooleanControl c = (BooleanControl)this.getControl(type);
            c.setValue(v);
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
    }

    private float getValue(FloatControl.Type type) {
        float v = 0.0f;
        if (this.hasControl(type)) {
            FloatControl c = (FloatControl)this.getControl(type);
            v = c.getValue();
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
        return v;
    }

    private void setValue(FloatControl.Type type, float v) {
        if (this.hasControl(type)) {
            FloatControl c = (FloatControl)this.getControl(type);
            if (v > c.getMaximum()) {
                v = c.getMaximum();
            } else if (v < c.getMinimum()) {
                v = c.getMinimum();
            }
            c.setValue(v);
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
    }

    public float getVolume() {
        return this.getValue(VOLUME);
    }

    public void setVolume(float value) {
        this.setValue(VOLUME, value);
    }

    public void shiftVolume(float from, float to, int millis) {
        if (this.hasControl(VOLUME)) {
            this.setVolume(from);
            this.vshifter = new ValueShifter(from, to, millis);
            this.vshift = true;
        }
    }

    public boolean isShiftingVolume() {
        return this.vshift;
    }

    public float getGain() {
        return this.getValue(GAIN);
    }

    public void setGain(float value) {
        this.setValue(GAIN, value);
    }

    public void shiftGain(float from, float to, int millis) {
        if (this.hasControl(GAIN)) {
            this.setGain(from);
            this.gshifter = new ValueShifter(from, to, millis);
            this.gshift = true;
        }
    }

    public boolean isShiftingGain() {
        return this.gshift;
    }

    public float getBalance() {
        return this.getValue(BALANCE);
    }

    public void setBalance(float value) {
        this.setValue(BALANCE, value);
    }

    public void shiftBalance(float from, float to, int millis) {
        if (this.hasControl(BALANCE)) {
            this.setBalance(from);
            this.bshifter = new ValueShifter(from, to, millis);
            this.bshift = true;
        }
    }

    public boolean isShiftingBalance() {
        return this.bshift;
    }

    public float getPan() {
        return this.getValue(PAN);
    }

    public void setPan(float value) {
        this.setValue(PAN, value);
    }

    public void shiftPan(float from, float to, int millis) {
        if (this.hasControl(PAN)) {
            this.setPan(from);
            this.pshifter = new ValueShifter(from, to, millis);
            this.pshift = true;
        }
    }

    public boolean isShiftingPan() {
        return this.pshift;
    }

    class ValueShifter {
        private float tstart = (int)System.currentTimeMillis();
        private float tend;
        private float vstart;
        private float vend;

        public ValueShifter(float vs, float ve, int t) {
            this.tend = this.tstart + (float)t;
            this.vstart = vs;
            this.vend = ve;
        }

        public float value() {
            int millis = (int)System.currentTimeMillis();
            float norm = ((float)millis - this.tstart) / (this.tend - this.tstart);
            float range = this.vend - this.vstart;
            return this.vstart + range * norm;
        }

        public boolean done() {
            return (float)((int)System.currentTimeMillis()) > this.tend;
        }
    }
}

