import ddf.minim.*;
import ddf.minim.analysis.*;
import java.util.*;

String musicfile = "demo_mixdown2.wav";

Minim minim;
AudioPlayer audioplayer;
MultiChannelBuffer buffers;
float[] sampledata;


int bufsize = 1024;
int windowsize = 2048;
int rate; //samplerate

BeatDetect ding;
int framesFromHit = 0;
ArrayList<Float> oscillatorHeights = new ArrayList<Float>(width);



// mistä kohdasta luetaan fft-sampleikkuna
int player_samplepos() {
  // minim palauttaa millisekunteja
  float secs = audioplayer.position() / 1000.0;
  // aika sampleyksiköissä
  int samplepos = (int)(secs * audioplayer.sampleRate());
  // nykyhetki ikkunan keskelle, vaihtoehtona mm.
  // koko windowsize eli aika ikkunan lopussa 
  samplepos -= windowsize/2;
  // ei vahingossakaan negatiiviseks
  samplepos = max(samplepos, 0);
  // eikä toisenkaan reunan yli
  samplepos = min(samplepos, sampledata.length - windowsize);
  return samplepos;
}



void soundDraw() {
  int samplepos = player_samplepos();
  float[] window = Arrays.copyOfRange(sampledata, samplepos, samplepos + windowsize);
  int lineHeight = height/2 - 266;  //changes height of the line!
  int startW = 152;
  int endW = width - 152;
  
  //fft.forward(window);
  ding.detect(window);
  
  // beatdetectin arvoväli, käyttää muita indeksejä
  int b_a = 10;
  int b_b = 13;
  
  //beatdetect
  stroke(#fecc14);
  fill(255);
  if (ding.isRange(b_a, b_b, 2)) { //myös isSnare() ym.
    framesFromHit = 0;
    for (int i = startW; i <= endW; i++) {
      if (i % 2 == 0) {
        oscillatorHeights.set(i, (randomGaussian()*18));
      }
      else {
        oscillatorHeights.set(i, (randomGaussian()*15));
      }
      ellipse(i, lineHeight + oscillatorHeights.get(i), 5, 5);
    }
  }
  else {
    framesFromHit += 1;
    if (framesFromHit == 1) {
      for (int i = startW; i <= endW; i++) {
        float previous = oscillatorHeights.get(i);
        oscillatorHeights.set(i, previous * 2);
        ellipse(i, lineHeight + oscillatorHeights.get(i), 5, 5);
      }
    }
    else {
      for (int i = startW; i <= endW; i++) {
        float previous = oscillatorHeights.get(i);
        oscillatorHeights.set(i, 0.9 * previous);
        ellipse(i, lineHeight + oscillatorHeights.get(i), 5, 5);
      }
    }

  }
  noStroke();
}