boolean destroyActive = false;

boolean checkCollision(Circle cir1, Circle cir2) {

    // Get distances between the circles components
    PVector distanceVect = PVector.sub(cir2.loc, cir1.loc);
    

    // Calculate magnitude of the vector separating the circles
    float distanceVectMag = distanceVect.mag();

    // Minimum distance before they are touching
    float minDistance = cir1.Rad() + cir2.Rad();

    if (distanceVectMag < minDistance) {
      if (destroyActive) {
        return true;
      }
      else {
        float distanceCorrection = (minDistance-distanceVectMag)/2.0;
        PVector d = distanceVect.copy();
        PVector correctionVector = d.normalize().mult(distanceCorrection);
        cir2.loc.add(correctionVector);
        cir1.loc.sub(correctionVector);
  
        // get angle of distanceVect
        float theta  = distanceVect.heading();
        // precalculate trig values
        float sine = sin(theta);
        float cosine = cos(theta);
  
        /* bTemp will hold rotated circle positions. You 
         just need to worry about bTemp[1] position*/
        PVector[] bTemp = {
          new PVector(), new PVector()
        };
  
        /* this circle's position is relative to the cir2
         so you can use the vector between them (bVect) as the 
         reference point in the rotation expressions.
         bTemp[0].position.x and bTemp[0].position.y will initialize
         automatically to 0.0, which is what you want
         since b[1] will rotate around b[0] */
        bTemp[1].x  = cosine * distanceVect.x + sine * distanceVect.y;
        bTemp[1].y  = cosine * distanceVect.y - sine * distanceVect.x;
  
        // rotate Temporary velocities
        PVector[] vTemp = {
          new PVector(), new PVector()
        };
  
        vTemp[0].x  = cosine * cir1.getDirX() + sine * cir1.getDirY();
        vTemp[0].y  = cosine * cir1.getDirY() - sine * cir1.getDirX();
        vTemp[1].x  = cosine * cir2.getDirX() + sine * cir2.getDirY();
        vTemp[1].y  = cosine * cir2.getDirY() - sine * cir2.getDirX();
  
        /* Now that velocities are rotated, you can use 1D
         conservation of momentum equations to calculate 
         the final velocity along the x-axis. */
        PVector[] vFinal = {  
          new PVector(), new PVector()
        };
  
        // final rotated velocity for b[0]
        float c1m = cir1.Rad()*.1;
        float c2m = cir2. Rad()*.1;
        
        vFinal[0].x = ((c1m - c2m) * vTemp[0].x + 2 * c2m * vTemp[1].x) / (c1m + c2m);
        vFinal[0].y = vTemp[0].y;
  
        // final rotated velocity for b[0]
        vFinal[1].x = ((c2m - c1m) * vTemp[1].x + 2 * c1m * vTemp[0].x) / (c1m + c2m);
        vFinal[1].y = vTemp[1].y;
  
        // hack to avoid clumping
        bTemp[0].x += vFinal[0].x;
        bTemp[1].x += vFinal[1].x;
  
        /* Rotate circle positions and velocities back
         Reverse signs in trig expressions to rotate 
         in the opposite direction */
        // rotate circles
        PVector[] bFinal = { 
          new PVector(), new PVector()
        };
        
        bFinal[0].x = cosine * bTemp[0].x - sine * bTemp[0].y;
        bFinal[0].y = cosine * bTemp[0].y + sine * bTemp[0].x;
        bFinal[1].x = cosine * bTemp[1].x - sine * bTemp[1].y;
        bFinal[1].y = cosine * bTemp[1].y + sine * bTemp[1].x;
    
        if (distanceVectMag < minDistance/3) { //Some problem with collision detection, solves it really ugly.
          // update circles to screen position
          cir2.setX(50+(cir1.loc.x + bFinal[1].x));
          cir2.setY(50+(cir1.loc.y + bFinal[1].y));
    
          cir1.loc.add(bFinal[0]);
    
          // update velocities
          cir1.setDir(cosine * vFinal[0].x - sine * vFinal[0].y, cosine * vFinal[0].y + sine * vFinal[0].x);
          cir2.setDir(cosine * vFinal[1].x - sine * vFinal[1].y, cosine * vFinal[1].y + sine * vFinal[1].x);
        }
        else { //original circle movement
          // update circles to screen position
          cir2.setX(cir1.loc.x + bFinal[1].x);
          cir2.setY(cir1.loc.y + bFinal[1].y);
    
          cir1.loc.add(bFinal[0]);
    
          // update velocities
          cir1.setDir(cosine * vFinal[0].x - sine * vFinal[0].y, cosine * vFinal[0].y + sine * vFinal[0].x);
          cir2.setDir(cosine * vFinal[1].x - sine * vFinal[1].y, cosine * vFinal[1].y + sine * vFinal[1].x);
        }
      }
    }
    return false;
  }