/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class BandPass
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_freq = 4000.0f;
    private float m_bw = 1000.0f;

    public BandPass(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        BandPass bandPass = this;
        bandPass.m_engine.start();
    }

    public void process(SoundObject soundObject, float f, float f2) {
        this.m_freq = f;
        this.m_bw = f2;
        this.m_nodeId = Engine.bandPassPlay(soundObject.returnId(), this.m_freq, this.m_bw);
    }

    public void process(SoundObject soundObject, float f) {
        this.m_freq = f;
        this.m_nodeId = Engine.bandPassPlay(soundObject.returnId(), this.m_freq, this.m_bw);
    }

    public void process(SoundObject soundObject) {
        this.m_nodeId = Engine.bandPassPlay(soundObject.returnId(), this.m_freq, this.m_bw);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.filterBwSet(this.m_freq, this.m_bw, this.m_nodeId[0]);
        }
    }

    public void set(float f, float f2) {
        this.m_freq = f;
        this.m_bw = f2;
        this.set();
    }

    public void freq(float f) {
        this.m_freq = f;
        this.set();
    }

    public void bw(float f) {
        this.m_bw = f;
        this.set();
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

